function path_added=SetAdvisorPath(varargin)

%------------------Add ADVISOR directories to the MATLAB path-------------
% Add the appropriate paths based on where advisor.m is found with the which command (This
% defines the main ADVISOR directory)
%
% NOTE: paths will only be added with the addpath command if they don't already exist.
% If new directories were added to the path (using addpath), a 1 will be returned 
% otherwise a 0 will be returned.
% 
% SetAdvisorPath can accept a comma separated list of arguments.  The arguments should be
% the name of an existing directory.  Non-existing directories will not be created. The 
% comma separated list of arguments will be stored in varargin as a cell array of strings
% Each directory will be added to the path individually.
%

% use lower command for all except unix platforms (which is case sensitive)
if isunix
    adv_dir=fileparts(which('advisor'));
    p=path;
else   
    adv_dir=lower(fileparts(which('advisor')));
    p=lower(path);
end

% directories that must be present in MATLAB path for ADVISOR to run properly
dir2add={...
    fullfile(adv_dir, 'extras', 'batmodel', 'documentation');...
    fullfile(adv_dir, 'extras', 'batmodel');...
    fullfile(adv_dir, 'extras', 'engmodel');...
    fullfile(adv_dir, 'extras', 'engmodel', 'documentation');...
    fullfile(adv_dir, 'extras', 'Image2Map');...
    fullfile(adv_dir, 'extras', 'Scale_Bore_Stroke');...
    fullfile(adv_dir, 'data');...
    fullfile(adv_dir, 'data', 'accessory');...
    fullfile(adv_dir, 'data', 'accessory', 'etc');...
    fullfile(adv_dir, 'data', 'control');...
    fullfile(adv_dir, 'data', 'drive_cycle');...
    fullfile(adv_dir, 'data', 'energy_storage');...
    fullfile(adv_dir, 'data', 'exhaust');...
    fullfile(adv_dir, 'data', 'fuel_converter');...
    fullfile(adv_dir, 'data', 'fuel_converter', 'neural_net');...
    fullfile(adv_dir, 'data', 'fuel_converter', 'KTH');...
    fullfile(adv_dir, 'data', 'generator');...
    fullfile(adv_dir, 'data', 'motor');...
    fullfile(adv_dir, 'data', 'test_procedure');...
    fullfile(adv_dir, 'data', 'transmission');...
    fullfile(adv_dir, 'data', 'vehicle');...
    fullfile(adv_dir, 'data', 'wheel');...
    fullfile(adv_dir, 'documentation');...
    fullfile(adv_dir, 'gui_graphics');...
    fullfile(adv_dir, 'gui');...
    fullfile(adv_dir, 'gui', 'optionlists');...
    fullfile(adv_dir, 'gui', 'DynamicGraphics');...
    fullfile(adv_dir, 'gui', 'Results');...
    fullfile(adv_dir, 'gui', 'SimSetup');...
    fullfile(adv_dir, 'gui', 'SaberCosim');...
    fullfile(adv_dir, 'gui', 'SaberCosim', 'Battery');...
    fullfile(adv_dir, 'models');...
    fullfile(adv_dir, 'models', 'library');...
    fullfile(adv_dir, 'models', 'Saber');...
    fullfile(adv_dir, 'models', 'Saber', 'Battery');...
    fullfile(adv_dir, 'models', 'Simplorer');...
    fullfile(adv_dir, 'models', 'Sindafluint');...
    fullfile(adv_dir, 'optimization');...
    fullfile(adv_dir, 'optimization', 'examples', '3humpcamelback');...
    fullfile(adv_dir, 'optimization', 'examples', '3humpcamelback', 'direct');...
    fullfile(adv_dir, 'optimization', 'examples', '3humpcamelback', 'isight');...
    fullfile(adv_dir, 'optimization', 'examples', '3humpcamelback', 'matlab');...
    fullfile(adv_dir, 'optimization', 'examples', '3humpcamelback', 'visualdoc');...
    fullfile(adv_dir, 'optimization', 'examples', 'box');...
    fullfile(adv_dir, 'optimization', 'examples', 'box', 'direct');...
    fullfile(adv_dir, 'optimization', 'examples', 'box', 'isight');...
    fullfile(adv_dir, 'optimization', 'examples', 'box', 'matlab');...
    fullfile(adv_dir, 'optimization', 'examples', 'box', 'visualdoc');...
    fullfile(adv_dir, 'optimization', 'examples', 'control');...
    fullfile(adv_dir, 'optimization', 'examples', 'control', 'direct');...
    fullfile(adv_dir, 'optimization', 'examples', 'control', 'isight');...
    fullfile(adv_dir, 'optimization', 'examples', 'control', 'matlab');...
    fullfile(adv_dir, 'optimization', 'examples', 'sizing');...
    fullfile(adv_dir, 'optimization', 'examples', 'sizing', 'direct');...
    fullfile(adv_dir, 'optimization', 'examples', 'sizing', 'isight');...
    fullfile(adv_dir, 'optimization', 'examples', 'sizing', 'matlab');...
    fullfile(adv_dir, 'optimization', 'examples', 'sizing', 'visualdoc');...
    fullfile(adv_dir, 'optimization', 'examples', 'sizing_plus_control');...
    fullfile(adv_dir, 'optimization', 'examples', 'sizing_plus_control', 'direct');...
    fullfile(adv_dir, 'optimization', 'examples', 'sizing_plus_control', 'isight');...
    fullfile(adv_dir, 'optimization', 'examples', 'sizing_plus_control', 'matlab');...
    fullfile(adv_dir, 'tmp');...
    fullfile(adv_dir, 'saved_vehicles')};
if ~isunix
    dir2add=lower(dir2add);
end

% checking and adding paths as necessary.
path_added=0;
for i=1:length(dir2add)
    temp=findstr(dir2add{i}, p);
    if isempty(temp)
        addpath(dir2add{i}, '-frozen');
        path_added=1;
    end
end

temp=findstr(adv_dir,p);

if isempty(temp)
    addpath(adv_dir,'-frozen') % add the main directory if it isn't already in there
    path_added=1;
end

% add any user-specified directories
if exist('varargin', 'var')
    for i=1:length(varargin)
        try
            if isunix
                addpath(varargin{i},'-frozen')
            else
                addpath(lower(varargin{i}),'-frozen')
            end
        catch err
            disp(['Directory ', varargin{i}, ' does not exist.'])    
            disp(err);
        end
    end
end

return

% Revision History
% 12/07/01:tm added -frozen arguement to the end of the add path 
%             statements to prevent windows change notification handle errors
% 06-MAR-2002[mpo] added \data\accessory\etc to the path
% 10-APR-2002[mpo] added \data\accessory\neural_net to the path
% 16-APR-2002[mpo] added \models\Sindafluint to the path
% 4/29/03:tm removed ..\kth_old since it no longer exists
% 8/4/03: ss removed VSOLE, no longer available through ADVISOR
