% ADVISOR Data file:  FC_GCTOOL.M
%
% Data source:   
%
% Data confidence level:  
%
% Notes: This file can be used to define a fuel cell powerplant 
% using GCtool. DO NOT EDIT THIS FILE!!!
%
% Created on:  02/17/99
% By:  Tony Markel, National Renewable Energy Laboratory, Tony_Markel@nrel.gov
%
% Revision history at end of file.
%----------------------------------------------------------------------------------------------------------------------
fc_version=2003; % version of ADVISOR for which the file was generated

% prompt user for inputs
gctool_setup;
uiwait(gcf);

if eval(['~strcmp(vinf.fuel_converter.name,vinf.fuel_converter.prev_name)'])
   
   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   % FILE ID INFO
   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   fc_description='GCtool based Fuel Converter - Fuel Cell'; 
   fc_version=2003; % version of ADVISOR for which the file was generated
   fc_proprietary=0; % 0=> non-proprietary, 1=> proprietary, do not distribute
   fc_validation=0; % 1=> no validation, 1=> data agrees with source data, 
   % 2=> data matches source data and data collection methods have been verified
   disp(['Data loaded: FC_GCTOOL - ',fc_description]);
   
   % fuel cell model selector
   fc_fuel_cell_model=3; % 1--> polarization curves, 2--> pwr vs. eff, 3--> gctool model, 4-->semi-empirical fc model
   
   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   % run gctool in design mode
   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DEFAULT SCALING
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
fc_pwr_scale=1.0;   % --  scale fc power
%the following variable is not used directly in modelling and should always be equal to one
%it's used for initialization purposes
fc_eff_scale=1.0; % -- scale the efficiency
fc_trq_scale=1.0; % -- required only for autosize and optimization routines
fc_spd_scale=1.0; % -- required only for autosize and optimization routines
fc_cold=0;      % boolean 0=no cold data; 1=cold data exists

% user definable mass scaling function
fc_mass_scale_fun=inline('(x(1)*fc_trq_scale+x(2))*(x(3)*fc_spd_scale+x(4))*(fc_base_mass+fc_acc_mass)+fc_fuel_mass','x','fc_spd_scale','fc_trq_scale','fc_base_mass','fc_acc_mass','fc_fuel_mass');
fc_mass_scale_coef=[1 0 1 0]; % coefficients of mass scaling function


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% OTHER DATA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if ~vinf.gctool.user_defined
   if strcmp(vinf.gctool.model.name,'Hydrogen PEM')
      fc_fuel_type='Hydrogen';
      fc_fuel_den=0.018*1000; % (g/l), density of the fuel 
      fc_fuel_lhv=120.0*1000; % (J/g), lower heating value of the fuel
   elseif strcmp(vinf.gctool.model.name,'Steam Reformed Methanol PEM')
      fc_fuel_type='Methanol';
      fc_fuel_den=0.790*1000; % (g/l), density of the fuel 
      fc_fuel_lhv=19.7*1000; % (J/g), lower heating value of the fuel
   elseif strcmp(vinf.gctool.model.name,'POX Reformed Gasoline PEM')
      fc_fuel_type='Gasoline';
      fc_fuel_den=0.835*1000; % (g/l), density of the fuel 
      fc_fuel_lhv=42.7*1000; % (J/g), lower heating value of the fuel
   end
   fc_max_pwr=vinf.gctool.dv.value(1)/1000; % kW     peak engine power
else
   fc_fuel_type='Unknown';
   fc_fuel_den=vinf.gctool.fuel_den; % (g/l), density of the fuel 
   fc_fuel_lhv=vinf.gctool.fuel_lhv; % (J/g), lower heating value of the fuel
   fc_max_pwr=vinf.gctool.dv.value(1)/1000; % kW     peak engine power
end
fc_base_mass=2.0*fc_max_pwr;        % kg   mass of the fuel cell stack, assuming mass penalty of 2 kg/kW
fc_acc_mass=1.0*fc_max_pwr;         % kg   mass of fuel cell accy's, electrics, cntrl's - assumes mass penalty of 1 kg/kW 
fc_fuel_mass=0.6*fc_max_pwr;  % kg   mass of fuel and fuel tank 
fc_mass=fc_base_mass+fc_acc_mass+fc_fuel_mass; % kg  total engine/fuel system mass
%fc_mass=vinf.gctool.fc_mass;
%fc_mass=300/2.205; % (kg), mass of the engine



%%%%%%%%%%%%%
% MODEL PLACEHOLDER INFORMATION
%  - this information is used in the pwr vs. eff and 
%    polarization curve fuel cell models and must be 
%    defined for the block diagrams to work properly.
%    This information will not affect the results 
%    of the GCtool model.
%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% FUEL USE AND EMISSIONS MAPS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% (g/s), fuel consumption indexed vertically by fc_map_spd and
% horizontally by fc_map_trq
fc_pwr_map=[0.01 2.5 5 10 15 20 25 30 35 40 45 50]*1000; % W (net) including parasitic losses
fc_eff_map=[33 52.5 57.5 60 59 58 57 56 55 53 51 48]/100; % efficiency indexed by fc_pwr_map

% create fuel use map (g/s)
fc_fuel_map=fc_pwr_map./fc_eff_map./fc_fuel_lhv; % used in block diagram

% create fuel consumption map (g/kWh)
fc_fuel_map_gpkWh=(1./fc_eff_map)/fc_fuel_lhv*3600*1000; % used in gui_inpchk plots

% (g/s), engine out HC emissions indexed vertically by fc_map_spd and
% horizontally by fc_map_trq
fc_hc_map=zeros(size(fc_fuel_map));

% (g/s), engine out HC emissions indexed vertically by fc_map_spd and
% horizontally by fc_map_trq
fc_co_map=zeros(size(fc_fuel_map));

% (g/s), engine out HC emissions indexed vertically by fc_map_spd and
% horizontally by fc_map_trq
fc_nox_map=zeros(size(fc_fuel_map)); 

% (g/s), engine out PM emissions indexed vertically by fc_map_spd and
% horizontally by fc_map_trq
fc_pm_map=zeros(size(fc_fuel_map));

% (g/s), engine out O2 indexed vertically by fc_map_spd and
% horizontally by fc_map_trq
fc_o2_map=zeros(size(fc_fuel_map));

fc_emis=0;      % boolean 0=no emis data; 1=emis data

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Cold Engine Maps
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
fc_cold_tmp=20; %deg C
fc_fuel_map_cold=zeros(size(fc_fuel_map));
fc_hc_map_cold=zeros(size(fc_fuel_map));
fc_co_map_cold=zeros(size(fc_fuel_map));
fc_nox_map_cold=zeros(size(fc_fuel_map));
fc_pm_map_cold=zeros(size(fc_fuel_map));
%Process Cold Maps to generate Correction Factor Maps
names={'fc_fuel_map','fc_hc_map','fc_co_map','fc_nox_map','fc_pm_map'};
for i=1:length(names)
    %cold to hot raio, e.g. fc_fuel_map_c2h = fc_fuel_map_cold ./ fc_fuel_map
    eval([names{i},'_c2h=',names{i},'_cold./(',names{i},'+eps);'])
end

% variables not applicable to a fuel cell but needed for thermal models
fc_tstat=94;                  % C      engine coolant thermostat set temperature (typically 95 +/- 5 C)
fc_cp=500;                    % J/kgK  ave cp of engine (iron=500, Al or Mg = 1000)
fc_h_cp=500;                  % J/kgK  ave cp of hood & engine compartment (iron=500, Al or Mg = 1000)
fc_ext_sarea=0.3;             % m^2    exterior surface area of engine
fc_hood_sarea=1.5;            % m^2    surface area of hood/eng compt.
fc_emisv=0.8;                 %        emissivity of engine ext surface/hood int surface
fc_hood_emisv=0.9;            %        emissivity hood ext
fc_h_air_flow=0.0;            % kg/s   heater air flow rate (140 cfm=0.07)
fc_cl2h_eff=0.7;              % --     ave cabin heater HX eff (based on air side)
fc_c2i_th_cond=500;           % W/K    conductance btwn engine cyl & int
fc_i2x_th_cond=500;           % W/K    conductance btwn engine int & ext
fc_h2x_th_cond=10;            % W/K    conductance btwn engine & engine compartment
fc_ex_pwr_frac=[0.40 0.30];                        % --   frac of waste heat that goes to exhaust as func of engine speed
fc_exflow_map=fc_fuel_map*(1+14.5);                % g/s  ex gas flow map:  for SI engines, exflow=(fuel use)*[1 + (stoic A/F ratio)]
fc_extmp_map=100*ones(size(fc_fuel_map));       % W   initialize size of ex pwr map

end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% REVISION HISTORY
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 9/12/99 (tm): file created
% 9/20/99:tm added default definitions for parameters used in pwr vs. eff and polarization curve models
% 11/03/99:ss updated version from 2.2 to 2.21
% 01/31/01: vhj added fc_cold=0, added cold map variables, added +eps to avoid dividing by zero
% 2/8/00:tm updated version to 3.1
% 02/26/01: vhj added variable definition of fc_o2_map (used in NOx absorber emis.)
% 7/30/01:tm added user definable mass scaling function mass=f(fc_spd_scale,fc_trq_scale,fc_base_mass,fc_acc_mass,fc_fuel_mass)
% 4/08/02: kh updated version to 2002, added Opcon screw compressor data
% 4/26/02:tm removed extra auxiliary systems input data - converted to config system
