% ADVISOR Data file:  FC_TT_IC.M
%
% Data source:   
%
% Data confidence level:  
%
% Notes:  This file loads a baseline fuel convertor file and adjusts
% it to match the user specified technical targets. 
%
% DO NOT EDIT THIS FILE!!!
%
% Created on:  02/17/99
% By:  Tony Markel, National Renewable Energy Laboratory, Tony_Markel@nrel.gov
%
% Revision history at end of file.
%

eval('vinf.tt.fuel_converter; test4exist=1;','test4exist=0;')

if ~test4exist|~strcmp(vinf.tt.fuel_converter.params.description{1},'Best brake thermal efficiency (%)')
   % setup defaults
   %vinf.tt.fuel_converter.filename='FC_CI88';
   vinf.tt.fuel_converter.filename=vinf.fuel_converter.prev_name;
   vinf.tt.fuel_converter.params.description{1}='Best brake thermal efficiency (%)';
   vinf.tt.fuel_converter.params.value(1)=43;
   vinf.tt.fuel_converter.params.description{2}='Specific power (W/kg)';
   vinf.tt.fuel_converter.params.value(2)=525;
end

%added following line to keep previous name
%if strcmp(vinf.fuel_converter.prev_name,'FC_TT_IC')
%   vinf.fuel_converter.prev_name=vinf.tt.fuel_converter.filename;
%end

vinf.tt.comp_name='fuel_converter';

% prompt user for inputs
tt_setup;

if eval(['~strcmp(vinf.',vinf.tt.comp_name,'.name,vinf.',vinf.tt.comp_name,'.prev_name)'])
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% FILE ID INFO
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
fc_description='Technical Target based Fuel Converter - Internal Combustion'; 
fc_version=2003; % version of ADVISOR for which the file was generated
fc_proprietary=0; % 0=> non-proprietary, 1=> proprietary, do not distribute
fc_validation=0; % 1=> no validation, 1=> data agrees with source data, 
% 2=> data matches source data and data collection methods have been verified
fc_cold=0;      % boolean 0=no cold data; 1=cold data exists
disp(['Data loaded: FC_TT_IC - ',fc_description]);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DEFINE TECHNICAL TARGETS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% (%) best brake thermal efficiency
tt_bte=vinf.tt.fuel_converter.params.value(1); 
% (W/kg) specific power
tt_spwr=vinf.tt.fuel_converter.params.value(2); 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% LOAD BASE DATA FILE
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% save current fc_description
str=fc_description;

eval(vinf.tt.fuel_converter.filename); 

% build new fuel converter description
fc_description=['Tech Target Fuel Converter based on ',fc_description]; 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% ADJUST DATA TO SATISFY TECHNICAL TARGETS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% calculate the current efficiency map 
[T,w]=meshgrid(fc_map_trq*fc_trq_scale, fc_map_spd*fc_spd_scale);
fc_map_kW=T.*w/1000;
fc_map_eff=(fc_map_kW*1000)./(fc_fuel_map*fc_spd_scale*fc_trq_scale*fc_fuel_lhv)*100;

% determine the best brake thermal efficiency within the allowable operating range
good_trqs=[];
for spd=1:length(fc_map_spd)
   good_trqs=[good_trqs; T(spd,:)<=fc_max_trq(spd)];
end;
fc_map_eff_good=fc_map_eff.*good_trqs;
fc_bte=max(max(fc_map_eff_good));

% scale the entire fuel map by the ratio of the actual to the target brake thermal efficiency
fc_fuel_map=fc_fuel_map/(tt_bte/fc_bte);

% scale the mass of the fuel converter to satisfy specific power tech target
fc_mass=max(fc_map_spd*fc_spd_scale.*fc_max_trq*fc_trq_scale)/tt_spwr;

disp([' ** best brake thermal efficiency set at ', num2str(tt_bte), ' %. ']);
disp([' ** specific power set at ', num2str(tt_spwr), ' W/kg. ']);

% (g/s), engine out O2 indexed vertically by fc_map_spd and
% horizontally by fc_map_trq
fc_o2_map=zeros(size(fc_fuel_map));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Cold Engine Maps
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
fc_cold_tmp=20; %deg C
fc_fuel_map_cold=zeros(size(fc_fuel_map));
fc_hc_map_cold=zeros(size(fc_fuel_map));
fc_co_map_cold=zeros(size(fc_fuel_map));
fc_nox_map_cold=zeros(size(fc_fuel_map));
fc_pm_map_cold=zeros(size(fc_fuel_map));
%Process Cold Maps to generate Correction Factor Maps
names={'fc_fuel_map','fc_hc_map','fc_co_map','fc_nox_map','fc_pm_map'};
for i=1:length(names)
    %cold to hot raio, e.g. fc_fuel_map_c2h = fc_fuel_map_cold ./ fc_fuel_map
    eval([names{i},'_c2h=',names{i},'_cold./(',names{i},'+eps);'])
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% CLEAN-UP WORKSPACE
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear T w fc_map_kW fc_map_eff good_trqs spd fc_map_eff_good fc_bte
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% REVISION HISTORY
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 02/17/99 (tm): file created 
% 3/11/99:tm enclosed code in an if statement so that it is conditionally executed 
% 3/15/99:ss updated *_version to 2.1 from 2.0
% 3/15/99:ss updated *_version to 2.1 from 2.0
% 11/03/99:ss updated version from 2.2 to 2.21
% 01/31/01: vhj added fc_cold=0, added cold map variables, added +eps to avoid dividing by zero
% 02/26/01: vhj added variable definition of fc_o2_map (used in NOx absorber emis.)
