%-------------------------------------------------------------------------------------
%
% M-file: cp_N2raw.m  [kJ/kmol,K respectively kJ/kg,K]
%
% Data from L. Wester, 1998
%
% Created: 000807 by Kristina Johansson
% Revision history:
%--------------------------------------------------------------------------------------
function f=cp_N2raw(T)

M_N2=28.0134; %[kg/kmol]

%y=M_N2*cp=Cp

a_min1=0;
a_0=28.151964;
a_1=13.197123;
a_2=-74.482113;
a_3=189.98363;
a_4=-226.61680;
a_5=142.04175;
a_6=-45.640429;
a_7=5.9487537;

y=a_min1*(T/1000)^(-1)+a_0*(T/1000)^(0)+a_1*(T/1000)^(1)+a_2*(T/1000)^(2)+a_3*(T/1000)^(3)+a_4*(T/1000)^(4)+a_5*(T/1000)^(5)+a_6*(T/1000)^(6)+a_7*(T/1000)^(7);
z=y/M_N2

f=[y z];
