%-------------------------------------------------------------------------------------
%
% M-file: dens_A(T)
% Last modified: 000121 by Kristina Johansson
% Created:000121
%-----------------------------------------------------------------------------------
%Values from AGA "Gas handbok", valid for pressures 1-5 bar,
%temperatures above 273.15 K, under 500 K
%Please observe: temperature [K], pressure [bar]
%Double interpolation, assuming linear relationship [kg/m3]
function f=dens_A(p,T)

if ((p>=1) & (p<2))
   if ((T>=273.15) & (T<288.15))
      X=(T-273.15)/(288.15-273.15)*(1.213-1.276)+1.276;
      Y=(T-273.15)/(288.15-273.15)*(2.416-2.554)+2.554;
      dens=(p-1)/(2-1)*(Y-X)+X;
   elseif ((T>=288.15) & (T<300))
      X=(T-288.15)/(300-288.15)*(1.165-1.213)+1.213;
      Y=(T-288.15)/(300-288.15)*(2.320-2.416)+2.416;
      dens=(p-1)/(2-1)*(Y-X)+X;
   elseif ((T>=300) & (T<350))
      X=(T-300)/(350-300)*(0.999-1.165)+1.165;
      Y=(T-300)/(350-300)*(1.987-2.320)+2.320;
      dens=(p-1)/(2-1)*(Y-X)+X;
   elseif ((T>=350) & (T<400))
      X=(T-350)/(400-350)*(0.874-0.999)+0.999;
      Y=(T-350)/(400-350)*(1.738-1.987)+1.987;
      dens=(p-1)/(2-1)*(Y-X)+X;
   elseif ((T>=400) & (T<450))
      X=(T-400)/(450-400)*(0.777-0.874)+0.874;
      Y=(T-400)/(450-400)*(1.545-1.738)+1.738;
      dens=(p-1)/(2-1)*(Y-X)+X;    
   elseif ((T>=450) & (T<500))
      X=(T-450)/(500-450)*(0.699-0.777)+0.699;
      Y=(T-450)/(500-450)*(1.390-1.545)+1.545;
      dens=(p-1)/(2-1)*(Y-X)+X;       
   elseif (T>=500)
      dens=0;
   end;
end;

if ((p>=2) & (p<5))
   if ((T>=273.15) & (T<288.15))
      X=(T-273.15)/(288.15-273.15)*(2.416-2.554)+2.554;
      Y=(T-273.15)/(288.15-273.15)*(6.053-6.397)+6.397;
      dens=(p-2)/(5-2)*(Y-X)+X;
   elseif ((T>=288.15) & (T<300))
      X=(T-288.15)/(300-288.15)*(2.320-2.416)+2.416;
      Y=(T-288.15)/(300-288.15)*(5.810-6.053)+6.053;
      dens=(p-2)/(5-2)*(Y-X)+X;
   elseif ((T>=300) & (T<350))
      X=(T-300)/(350-300)*(1.987-2.320)+2.320;
      Y=(T-300)/(350-300)*(4.972-5.810)+5.810;
      dens=(p-2)/(5-2)*(Y-X)+X;
   elseif ((T>=350) & (T<400))
      X=(T-350)/(400-350)*(1.738-1.987)+1.987;
      Y=(T-350)/(400-350)*(4.3248-4.972)+4.972;
      dens=(p-2)/(5-2)*(Y-X)+X;
   elseif ((T>=400) & (T<450))
      X=(T-400)/(450-400)*(1.545-1.738)+1.738;
      Y=(T-400)/(450-400)*(3.862-4.348)+4.348;
      dens=(p-2)/(5-2)*(Y-X)+X;   
   elseif ((T>=450) & (T<500))
      X=(T-450)/(500-450)*(1.390-1.545)+1.545;
      Y=(T-450)/(500-450)*(3.159-4.348)+4.348;
      dens=(p-2)/(5-2)*(Y-X)+X;    
   elseif (T>=500)
      dens=0;
   end;
end;

if ((p>=5) & (p<8))
   if ((T>=273.15) & (T<288.15))
      X=(T-273.15)/(288.15-273.15)*(6.053-6.397)+6.397;
      Y=(T-273.15)/(288.15-273.15)*(9.710-10.249)+10.249;
      dens=(p-5)/(8-5)*(Y-X)+X;
   elseif ((T>=288.15) & (T<300))
      X=(T-288.15)/(300-288.15)*(5.810-6.053)+6.053;
      Y=(T-288.15)/(300-288.15)*(9.319-9.710)+9.710;
      dens=(p-5)/(8-5)*(Y-X)+X;
   elseif ((T>=300) & (T<350))
      X=(T-300)/(350-300)*(4.972-5.810)+5.810;
      Y=(T-300)/(350-300)*(7.968-9.319)+9.319;
      dens=(p-5)/(8-5)*(Y-X)+X;
   elseif ((T>=350) & (T<400))
      X=(T-350)/(400-350)*(4.3248-4.972)+4.972;
      Y=(T-350)/(400-350)*(6.963-7.968)+7.968;
      dens=(p-5)/(8-5)*(Y-X)+X;
   elseif ((T>=400) & (T<450))
      X=(T-400)/(450-400)*(3.862-4.348)+4.348;
      Y=(T-400)/(450-400)*(6.158-6.963)+9.963;
      dens=(p-5)/(8-5)*(Y-X)+X;   
   elseif ((T>=450) & (T<500))
      X=(T-450)/(500-450)*(3.159-4.348)+4.348;
      Y=(T-450)/(500-450)*(5.564-6.185)+6.158;
      dens=(p-5)/(8-5)*(Y-X)+X;    
   elseif (T>=500)
      dens=0;
   end;
end;
f=dens;