%-------------------------------------------------------------------------------------
%
% M-file: dens_W(T)
% Last modified: 000126 by Kristina Johansson
% Created:991108
%-----------------------------------------------------------------------------------
%Values for water from "Inledande fluiddynamik", valid for temperatures above 10 C, under 100 C 
%[kg/m3]

function f=dens_W(T)
if T<10
   dens=0;
elseif ((T>=10) & (T<15))
   dens=(T-10)/(15-10)*(999.1-999.7)+999.7;
elseif ((T>=15) & (T<20))
   dens=(T-15)/(20-15)*(998.2-999.1)+999.1;
elseif ((T>=20) & (T<25))
   dens=(T-20)/(25-20)*(997.1-998.2)+998.2;
elseif ((T>=25) & (T<30))
   dens=(T-25)/(30-25)*(995.7-997.1)+997.1;
elseif ((T>=30) & (T<35))
   dens=(T-30)/(35-30)*(994.1-995.7)+995.7;      
elseif ((T>=35) & (T<40))
   dens=(T-35)/(40-35)*(992.2-994.1)+994.1;
elseif ((T>=40) & (T<45))
   dens=(T-40)/(45-40)*(990.2-992.2)+992.2;      
elseif ((T>=45) & (T<50))
   dens=(T-45)/(50-45)*(988.1-990.2)+990.2;
elseif ((T>=50) & (T<55))
   dens=(T-50)/(55-50)*(985.7-988.1)+988.1;      
elseif ((T>=55) & (T<60))
   dens=(T-55)/(60-55)*(983.2-985.7)+985.7;      
elseif ((T>=60) & (T<65))
   dens=(T-60)/(65-60)*(980.6-983.2)+983.2;      
elseif ((T>=65) & (T<70))
   dens=(T-65)/(70-65)*(977.8-980.6)+980.6;      
elseif ((T>=70) & (T<75))
   dens=(T-70)/(75-70)*(974.9-977.8)+977.8;
elseif ((T>=75) & (T<80))
   dens=(T-75)/(80-75)*(971.8-974.9)+974.9;
elseif ((T>=80) & (T<85))
   dens=(T-80)/(85-80)*(968.7-971.8)+971.8;
elseif ((T>=85) & (T<90))
   dens=(T-85)/(90-85)*(965.3-968.7)+968.7;
elseif ((T>=90) & (T<95))
   dens=(T-90)/(95-90)*(961.9-965.3)+965.3;
elseif ((T>=95) & (T<100))
   dens=(T-95)/(100-95)*(958.4-961.9)+961.9;
else T>100
   dens=0;
end;
f=dens;