%-------------------------------------------------------------------------------------
%
% M-file: h_air.m  [kJ/kg]  T in [K]
%
% Data from L. Wester, 1998
%
% Created: 000807 by Kristina Johansson
% Revision history:
%--------------------------------------------------------------------------------------
function f=h_air(T)

M_air=28.97; %[kg/kmol]

%y=M_air*h=H

a_0=-54.20000;
a_1=29438.265;
a_2=-805.41099;
a_3=-3997.2481;
a_4=17207.096;
a_5=-19647.986;
a_6=10813.917;
a_7=-2987.0543;
a_8=333.15502;
b=0;

y=a_0*(T/1000)^(0)+a_1*(T/1000)^(1)+a_2*(T/1000)^(2)+a_3*(T/1000)^(3)+a_4*(T/1000)^(4)+a_5*(T/1000)^(5)+a_6*(T/1000)^(6)+a_7*(T/1000)^(7)+a_8*(T/1000)^(8)+b*log(T/1000);
z=y/M_air;

f=[z];
