%------------------------------------------------------------------------------------
%
% M-file: k_H20l.m    (Thermal conductivity liquid water,  [W/(m,K)]
%
% Data from Hellsten, Gunnar, "Tabeller och diagram",
% 1992, Almqvist & Wiksell
% 
% Revision history:
% Created: 000816 by Kristina Johansson
% Modified: 
%------------------------------------------------------------------------------------------
function f=k_H2Ol(T)

%NOTE: temperature T in C, but the units are [W/(m*K)].

if T<0
   k=0;
elseif ((T>=0) & (T<5))
   k=(T-0)/(5-0)*(0.566-0.522)+0.522;
elseif ((T>=5) & (T<10))
   k=(T-5)/(10-5)*(0.578-0.566)+0.566;
elseif ((T>=10) & (T<15))
   k=(T-10)/(15-10)*(0.588-0.578)+0.578;
elseif ((T>=15) & (T<20))
   k=(T-15)/(20-15)*(0.598-0.588)+0.588;
elseif ((T>=20) & (T<25))
   k=(T-20)/(25-20)*(0.606-0.598)+0.598;
elseif ((T>=25) & (T<30))
   k=(T-25)/(30-25)*(0.614-0.606)+0.606;
elseif ((T>=30) & (T<35))
   k=(T-30)/(35-30)*(0.621-0.614)+0.614;
elseif ((T>=35) & (T<40))
   k=(T-35)/(40-35)*(0.628-0.621)+0.621;
elseif ((T>=40) & (T<45))
   k=(T-40)/(45-40)*(0.634-0.628)+0.628;
elseif ((T>=45) & (T<50))
   k=(T-45)/(50-45)*(0.641-0.634)+0.634;
elseif ((T>=50) & (T<55))
   k=(T-50)/(55-50)*(0.647-0.641)+0.641;
elseif ((T>=55) & (T<60))
   k=(T-55)/(60-55)*(0.652-0.647)+0.647;
elseif ((T>=60) & (T<65))
   k=(T-60)/(65-60)*(0.656-0.652)+0.652; 
elseif ((T>=65) & (T<70))
   k=(T-65)/(70-65)*(0.660-0.656)+0.656; 
elseif ((T>=70) & (T<75))
   k=(T-70)/(75-70)*(0.665-0.660)+0.660;
elseif ((T>=75) & (T<80))
   k=(T-75)/(80-75)*(0.669-0.665)+0.665;
elseif ((T>=80) & (T<85))
   k=(T-80)/(85-80)*(0.672-0.669)+0.669;
elseif ((T>=85) & (T<90))
   k=(T-85)/(90-85)*(0.676-0.672)+0.672;
elseif ((T>=90) & (T<95))
   k=(T-90)/(95-90)*(0.679-0.676)+0.676;
elseif ((T>=95) & (T<100))
   k=(T-95)/(100-95)*(0.682-0.679)+0.679;
else T>100
   k=0;
end;
f=k;

