% ADVISOR data file:  TEST_J1711.m
%
% Data source:
%
% Data confirmation:
%
% Notes:
% This test runs the SAE J1711 Test Procedure for hybrid vehicles.  % 
% Created on: 25-Feb-99
% By:  VHJ of NREL
%
% Revision history at end of file.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function fig = TEST_j1711(option)
% Setup figure for j1711 test

global vinf

%Initializations
drivetrain=vinf.drivetrain.name;
eval('h=vinf.test.OVC; test4exist=1;','test4exist=0;');
clear h
if ~test4exist; %set up the defaults
   vinf.test.OVC=0;
   vinf.test.AC.bool=0;
   vinf.test.EV=0;
   vinf.test.CV=0;
   vinf.test.SOC_correctF=1;
   vinf.test.SOC_correctH=1;
   vinf.test.SOC_correctU=1;
   vinf.test.SOC_correctS=1;
   vinf.test.ess_init_soc.UDDS=.5;
   vinf.test.ess_init_soc.HWFET=.5;
   vinf.test.ess_init_soc.US06=.5;
   vinf.test.ess_init_soc.SC03=.5;
end

% Return to main screen if non-hybrid selected
if strcmp(drivetrain,'conventional') | strcmp(drivetrain,'ev')
   h0 = figure('Color',[0.7 0.9 1], ...
      'MenuBar','none', ...
      'Name','J1711 Test Procedure Setup', ...
      'Position',[461 273 350 244]);
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[0.7 0.9 1], ...
      'FontSize',14, ...
      'FontWeight','bold', ...
      'HorizontalAlignment','left', ...
      'Position',[46 211 372 25], ...
      'String','J1711 Test Procedure Setup', ...
      'Style','text');
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[0.7 0.9 1], ...
      'HorizontalAlignment','left', ...
      'Position',[46 127 281 22], ...
      'String','J1711 Test Procedure is valid only for hybrid vehicles.', ...
      'Style','text');
   h1 = uicontrol('Parent',h0, ...
      'Callback','close(gcbf);SimSetupFig', ...
      'Position',[140 14 62 33], ...
      'String','Back');
   
elseif nargin==0
   
   % big window
   h0 = figure('Color',[0.7 0.9 1], ...
      'MenuBar','none', ...
      'Name','J1711 Test Procedure Setup', ...
      'NumberTitle','off', ...
      'Position',[461 143 350 374], ...
      'Tag','J1711_setup_figure');
   %menus
   adv_menu('j1711');
   
   % Labels and check boxes
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[0.7 0.9 1], ...
      'HorizontalAlignment','left', ...
      'FontSize',14, ...
      'FontWeight','bold', ...
      'Position',[46 340 372 25], ...
      'String','J1711 Test Procedure Setup', ...
      'Style','text');
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[0.7 0.9 1], ...
      'FontWeight','bold', ...
      'HorizontalAlignment','left', ...
      'Position',[25 314 296 19], ...
      'String','Additional Vehicle Options (optional input)', ...
      'Style','text');
   %boxes
   %OVC
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[0.7 0.9 1], ...
      'Callback','TEST_j1711(''OVC'')',...
      'Position',[40 295 178 16], ...
      'String','Off Vehicle Charge (OVC)', ...
      'Value',vinf.test.OVC,...
      'Style','checkbox', ...
      'Tag','OVC_box');
   %AC
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[0.7 0.9 1], ...
      'Callback','TEST_j1711(''AC'')',...
      'Position',[40 270 161 16], ...
      'String','Air Conditioning Equipped', ...
      'Value',vinf.test.AC.bool,...
      'Style','checkbox', ...
      'Tag','AC_box');
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[0.7 0.9 1], ...
      'HorizontalAlignment','left', ...
      'Position',[200 270 59 16], ...
      'Enable','off',...
      'String','Load (W)', ...
      'Style','text', ...
      'Tag','AC_load');
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[1 1 1], ...
      'Callback','TEST_j1711(''AC_value'')',...
      'Position',[259 270 54 20], ...
      'String','1000',...
      'Enable','off',...
      'Style','edit', ...
      'Tag','AC_load_value');
   %EV
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[0.7 0.9 1], ...
      'Callback','TEST_j1711(''EV'')',...
      'Position',[40 245 227 16], ...
      'String','Electric Vehicle mode-user selected (EV)', ...
      'Style','checkbox', ...
      'Value',vinf.test.EV,...
      'Enable','off',...
      'Tag','EV_box');
   %CV
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[0.7 0.9 1], ...
      'Callback','TEST_j1711(''CV'')',...
      'Position',[40 216 274 16], ...
      'String','Conventional Engine Only mode-user selected (CV)', ...
      'Value',vinf.test.CV,...
      'Style','checkbox', ...
      'Tag','CV_box');
   
   %Initial SOC specification
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[0.7 0.9 1], ...
      'FontWeight','bold', ...
      'HorizontalAlignment','left', ...
      'Position',[18 162 294 37], ...
      'String','Specify Initial State of Charge for Partial Charge Test (required input)', ...
      'Style','text');
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[0.7 0.9 1], ...
      'HorizontalAlignment','left', ...
      'Position',[40 140 43 20], ...
      'String','UDDS', ...
      'Style','text');
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[0.7 0.9 1], ...
      'HorizontalAlignment','left', ...
      'Position',[40 115 43 20], ...
      'String','HWFET', ...
      'Style','text');
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[0.7 0.9 1], ...
      'HorizontalAlignment','left', ...
      'Position',[40 90 43 20], ...
      'String','US06', ...
      'Style','text');
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[0.7 0.9 1], ...
      'HorizontalAlignment','left', ...
      'Position',[40 65 43 20], ...
      'String','SC03', ...
      'Style','text');
   % edit boxes
   h1 = uicontrol('Parent',h0, ...
      'Callback','TEST_j1711(''soc init'');', ...
      'BackgroundColor',[1 1 1], ...
      'Position',[90 140 59 20], ...
      'Style','edit', ...
      'String',num2str(vinf.test.ess_init_soc.UDDS),...
      'Tag','UDDS init_soc');
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[0.7 0.9 1], ...
      'Callback','TEST_j1711(''SOC UDDS'')',...
      'Position',[160 142 178 16], ...
      'String','Iterate to find initial SOC', ...
      'Style','checkbox', ...
      'Value',vinf.test.SOC_correctF,...
      'Tag','UDDS SOC_box');
   h1 = uicontrol('Parent',h0, ...
      'Callback','TEST_j1711(''soc init'');', ...
      'BackgroundColor',[1 1 1], ...
      'Position',[90 115 59 20], ...
      'Style','edit', ...
      'String',num2str(vinf.test.ess_init_soc.HWFET),...
      'Tag','HWFET init_soc');
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[0.7 0.9 1], ...
      'Callback','TEST_j1711(''SOC HWFET'')',...
      'Position',[160 117 178 16], ...
      'String','Iterate to find initial SOC', ...
      'Style','checkbox', ...
      'Value',vinf.test.SOC_correctH,...
      'Tag','HWFET SOC_box');
   h1 = uicontrol('Parent',h0, ...
      'Callback','TEST_j1711(''soc init'');', ...
      'BackgroundColor',[1 1 1], ...
      'Position',[90 90 59 20], ...
      'Style','edit', ...
      'String',num2str(vinf.test.ess_init_soc.US06),...
      'Tag','US06 init_soc');
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[0.7 0.9 1], ...
      'Callback','TEST_j1711(''SOC US06'')',...
      'Position',[160 92 178 16], ...
      'String','Iterate to find initial SOC', ...
      'Style','checkbox', ...
      'Value',vinf.test.SOC_correctU,...
      'Tag','US06 SOC_box');
   h1 = uicontrol('Parent',h0, ...
      'Callback','TEST_j1711(''soc init'');', ...
      'BackgroundColor',[1 1 1], ...
      'Position',[90 65 59 20], ...
      'Style','edit', ...
      'String',num2str(vinf.test.ess_init_soc.SC03),...
      'Tag','SC03 init_soc');
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[0.7 0.9 1], ...
      'Callback','TEST_j1711(''SOC SC03'')',...
      'Position',[160 67 178 16], ...
      'String','Iterate to find initial SOC', ...
      'Style','checkbox', ...
      'Value',vinf.test.SOC_correctS,...
      'Tag','SC03 SOC_box');
   
   
   %Back and Run buttons
   h1 = uicontrol('Parent',h0, ...
      'Callback','close(gcbf);j1711_execute;', ...
      'Position',[286 10 62 33], ...
      'String','Run');
   h1 = uicontrol('Parent',h0, ...
      'Callback','close(gcbf);SimSetupFig', ...
      'Position',[217 10 62 33], ...
      'String','Back');
   h1 = uicontrol('Parent',h0, ...
      'Callback','load_in_browser(''j1711_proc.html'');', ...
      'Position',[148 10 62 33], ...
      'String','Help');
   
   % Set figure to normalized for proper resizing
   h=findobj('type','uicontrol');
   g=findobj('type','axes');
   
   set([h; g],'units','normalized')
   
   TEST_j1711('OVC')
   TEST_j1711('AC')
   TEST_j1711('AC_value')
   TEST_j1711('EV')
   TEST_j1711('CV')
   TEST_j1711('soc init')
   TEST_j1711('SOC UDDS')
   TEST_j1711('SOC HWFET')
   TEST_j1711('SOC US06')
   TEST_j1711('SOC SC03')
   
   %center the figure on the screen
   set(h0,'units','pixels');
   position=get(h0,'position');
   screensize=get(0,'screensize');
   set(h0,'position', [(screensize(3)-position(3))/2  (screensize(4)-position(4))/2 ...
         position(3) position(4)])
end %nargin==0

if nargin > 0
   switch option
   case 'OVC'
      if get(findobj('tag','OVC_box'),'value')==1
         vinf.test.OVC=1;
         set(findobj('tag','EV_box'),'enable','on');
      else
         vinf.test.OVC=0;
         set(findobj('tag','EV_box'),'enable','off');
         set(findobj('tag','EV_box'),'value',0);
      end
   case 'AC'
      %set visibilities of load and edit box
      h=findobj('tag','AC_load');
      i=findobj('tag','AC_load_value');
      if get(findobj('tag','AC_box'),'value')==1
         vinf.test.AC.bool=1;
         set(h,'enable','on')
         set(i,'enable','on')
      else
         vinf.test.AC.bool=0;
         set(h,'enable','off')
         set(i,'enable','off','value',0)
      end %visibilities
      TEST_j1711('AC_value')
   case 'AC_value'
      if get(findobj('tag','AC_box'),'value')==1
         vinf.test.AC.load=str2num(get(findobj('tag','AC_load_value'),'string'));
      else
         vinf.test.AC.load=0;
      end
   case 'EV'
      if get(findobj('tag','EV_box'),'value')==1
         vinf.test.EV=1;
      else
         vinf.test.EV=0;
      end
   case 'CV'
      if get(findobj('tag','CV_box'),'value')==1
         vinf.test.CV=1;
      else
         vinf.test.CV=0;
      end
   case 'soc init'
      vinf.test.ess_init_soc.UDDS=str2num(get(findobj('tag','UDDS init_soc'),'string'));
      vinf.test.ess_init_soc.HWFET=str2num(get(findobj('tag','HWFET init_soc'),'string'));
      vinf.test.ess_init_soc.US06=str2num(get(findobj('tag','US06 init_soc'),'string'));
      vinf.test.ess_init_soc.SC03=str2num(get(findobj('tag','SC03 init_soc'),'string'));
   case 'SOC UDDS'
      if get(findobj('tag','UDDS SOC_box'),'value')==1
         vinf.test.SOC_correctF=1;
         set(findobj('tag','UDDS init_soc'),'enable','off');
      else
         vinf.test.SOC_correctF=0;
         set(findobj('tag','UDDS init_soc'),'enable','on');
      end
   case 'SOC HWFET'
      if get(findobj('tag','HWFET SOC_box'),'value')==1
         vinf.test.SOC_correctH=1;
         set(findobj('tag','HWFET init_soc'),'enable','off');
      else
         vinf.test.SOC_correctH=0;
         set(findobj('tag','HWFET init_soc'),'enable','on');
      end
   case 'SOC US06'
      if get(findobj('tag','US06 SOC_box'),'value')==1
         vinf.test.SOC_correctU=1;
         set(findobj('tag','US06 init_soc'),'enable','off');
      else
         vinf.test.SOC_correctU=0;
         set(findobj('tag','US06 init_soc'),'enable','on');
      end
   case 'SOC SC03'
      if get(findobj('tag','SC03 SOC_box'),'value')==1
         vinf.test.SOC_correctS=1;
         set(findobj('tag','SC03 init_soc'),'enable','off');
      else
         vinf.test.SOC_correctS=0;
         set(findobj('tag','SC03 init_soc'),'enable','on');
      end
   end %switch, cases
end %nargin>0


% Revision history
% 2/25/99 vhj file created
% 3/9/99 vhj changed EO to CV
% 3/10/99 vhj: added SOC correct for UDDS
% 4/12/99 vhj: added SOC correct for hwfet, us06, sc03
% 5/3/99: vhj: added call to from 'AC' case.  TEST_j1711('AC_value')
% 5/10/99: vhj: values maintained in gui
% 5/31/00: ss changed calls to gui_execute to SimSetupFigureControl
% 7/10/99:ss all references to FUDS are now UDDS
% 8/10/00: ss centered the figure on the screen
