function RC_results(action)

if nargin==0
   global binf;
   
   figcolor=[.4 .7 1]; %blueish
   butcolor1=[1 1 .64]; %yellow
   butcolor2=[1 .5 .5]; %coral
   butcolor3=[.34 .67 .67]; %greenish
   butcolor4=[.85 .85 .85]; %grey
   
   
   % figure and title
   h0 = figure('Color',[1 1 1], ...
      'MenuBar','figure', ...
      'Name','Battery Modeling Program: Results', ...
      'NumberTitle','off', ...
      'PaperPosition',[18 180 576 432], ...
      'Position',[478 201 690 586], ...
      'Visible','off',...
      'ToolBar','none');
   %Frame
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figcolor, ...
      'Position',[435 0 255 586], ...
      'Style','frame');
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figcolor, ...
      'FontSize',14, ...
      'FontWeight','bold', ...
      'Position',[504 532 174 40], ...
      'String','Results',...
      'Style','text');
   %Parameter Titles section
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figcolor, ...
      'Position',[ 450 491 30 30 ], ...
      'String','SOC (-)', ...
      'Style','text');
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figcolor, ...
      'Position',[ 481 491 38 30 ], ...
      'String','Re (mOhm)', ...
      'Style','text');
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figcolor, ...
      'Position',[ 530 491 25 30 ], ...
      'String','Rc', ...
      'Style','text');
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figcolor, ...
      'Position',[ 570 491 25 30 ], ...
      'String','Rt', ...
      'Style','text');
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figcolor, ...
      'Position',[ 610 491 25 30 ], ...
      'String','Cb (kF)', ...
      'Style','text');
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figcolor, ...
      'Position',[ 647 491 25 30 ], ...
      'String','Cc', ...
      'Style','text');
   
   yinc=25;
   size_x=34;
   for i=1:length(binf.RC.ess_soc)
      h1 = uicontrol('Parent',h0, ...
         'BackgroundColor',figcolor, ...
         'Position',[440 460-(i-1)*yinc 55 21], ...
         'String',' ', ...
         'Style','text');
      set(h1,'string',num2str(binf.RC.ess_soc(i)));
      h1 = uicontrol('Parent',h0, ...
         'BackgroundColor',[1 1 1], ...
         'Callback','RC_results(''plot R'')',...
         'Position',[485 465-(i-1)*yinc size_x 21], ...
         'Style','edit', ...
         'Tag',['re' num2str(i)]);
      set(h1,'string',num2str(binf.RC.ess_re(i)*1000));
      h1 = uicontrol('Parent',h0, ...
         'BackgroundColor',[1 1 1], ...
         'Callback','RC_results(''plot R'')',...
         'Position',[525 465-(i-1)*yinc size_x 21], ...
         'Style','edit', ...
         'Tag',['rc' num2str(i)]);
      set(h1,'string',num2str(binf.RC.ess_rc(i)*1000));
        h1 = uicontrol('Parent',h0, ...
         'BackgroundColor',[1 1 1], ...
         'Callback','RC_results(''plot R'')',...
         'Position',[565 465-(i-1)*yinc size_x 21], ...
         'Style','edit', ...
         'Tag',['rt' num2str(i)]);
      set(h1,'string',num2str(binf.RC.ess_rt(i)*1000));
      h1 = uicontrol('Parent',h0, ...
         'BackgroundColor',[1 1 1], ...
         'Callback','RC_results(''plot C'')',...
         'Position',[605 465-(i-1)*yinc size_x 21], ...
         'Style','edit', ...
         'Tag',['cb' num2str(i)]);
      set(h1,'string',num2str(binf.RC.ess_cb(i)/1000));
      h1 = uicontrol('Parent',h0, ...
         'BackgroundColor',[1 1 1], ...
         'Callback','RC_results(''plot C'')',...
         'Position',[645 465-(i-1)*yinc size_x 21], ...
         'Style','edit', ...
         'Tag',['cc' num2str(i)]);
      set(h1,'string',num2str(binf.RC.ess_cc(i)/1000));
    
  end
   
   %Axes
   h1 = axes('Parent',h0, ...
      'Units','pixels', ...
      'CameraUpVector',[0 1 0], ...
      'CameraUpVectorMode','manual', ...
      'Color',[1 1 1], ...
      'Position',[55 335 360 220], ...
      'Tag','R plot', ...
      'XColor',[0 0 0], ...
      'YColor',[0 0 0], ...
      'ZColor',[0 0 0]);
   h1 = axes('Parent',h0, ...
      'Units','pixels', ...
      'CameraUpVector',[0 1 0], ...
      'CameraUpVectorMode','manual', ...
      'Color',[1 1 1], ...
      'Position',[55 54 360 220], ...
      'Tag','C plot', ...
      'XColor',[0 0 0], ...
      'YColor',[0 0 0], ...
      'ZColor',[0 0 0]);
   
   %exit
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',butcolor4, ...
      'Callback','RC_results(''exit'')', ...
      'Position',[630 12 48 24], ...
      'String','Close');
   
   %set everything normalized
    h=findobj('type','uicontrol');
    set([h],'units','normalized')
    %_______set the figure size and location
    screensize=get(0,'screensize'); %this should be in pixels(the default)
    figsize=[(screensize(3)-690)/2 (screensize(4)-586)/2 690 586];
    set(gcf,'units','pixels','position',figsize,'visible','on');
    %_____________end set the figure size
   
   RC_results('plot R');
   RC_results('plot C');
   RC_results('plot eval pts');
   
end

if nargin>0
    global binf;
    switch action
    case 'plot eval pts'
        pulseind_new=binf.RC.pulseind_new;
        figure;hold on; zoom on;
        plot(binf.RC.data(:,1),binf.RC.data(:,2),'b');						%current
        plot(binf.RC.data(:,1),binf.RC.data(:,4),'k');						%Ahrs
        plot(binf.RC.data(:,1),binf.RC.data(:,3),'g');						%voltage
        xlabel('Time (sec)');
        ylabel('Data');
        title('Beginning and Ending points')
        plot(binf.RC.data(pulseind_new(:,1),1),binf.RC.data(pulseind_new(:,1),3),'rx'); %indb
        plot(binf.RC.data(pulseind_new(:,4),1),binf.RC.data(pulseind_new(:,4),3),'kx'); %inde
        plot(binf.RC.data(pulseind_new(:,1),1),binf.RC.data(pulseind_new(:,1),2),'ro'); %indb on current
        plot(binf.RC.data(pulseind_new(:,4),1),binf.RC.data(pulseind_new(:,4),2),'ko'); %inde on current
        legend('Current','Ah','Voltage','begin model','end model',-1)
        
    case 'plot R'
        RC_results('reassign values')

        h=findobj(gcf,'tag','R plot');
        tag='R plot';
        axes(h);
        global binf;
        zoom on; hold off;
        %Resistance plot
        plot(binf.RC.ess_soc,binf.RC.ess_re*1000,'b');
        hold on;
        plot(binf.RC.ess_soc,binf.RC.ess_rc*1000,'r');
        plot(binf.RC.ess_soc,binf.RC.ess_rt*1000,'g');
        plot(binf.RC.SOC_data,binf.RC.Re_data*1000,'b*');
        plot(binf.RC.SOC_data,binf.RC.Rc_data*1000,'r*');
        plot(binf.RC.SOC_data,binf.RC.Rt_data*1000,'g*');
        title(['Resistances vs. SOC at T=',num2str(round(binf.RC.temperature*10)/10),'C'])
        ylabel('Resistance (mOhms)');
        legend('Re model','Rc model','Rt model','Re data','Rc data','Rt data',-1)
        set(gca,'tag',tag);
        
    case 'plot C'
        RC_results('reassign values')

        h2=findobj(gcf,'tag','C plot'); 
        tag='C plot';
        axes(h2);
        global binf;
        zoom on; hold off;
         
        %Capacitance plot
        plot(binf.RC.ess_soc,binf.RC.ess_cb/1000,'b');
        hold on;
        plot(binf.RC.ess_soc,binf.RC.ess_cc/1000,'r');
        plot(binf.RC.SOC_data,binf.RC.Cb_data/1000,'b*');
        plot(binf.RC.SOC_data,binf.RC.Cc_data/1000,'r*');
        title(['Capacitances vs. SOC at T=',num2str(round(binf.RC.temperature*10)/10),'C'])
        ylabel('Capacitance (kF)');
        legend('Cb model','Cc model','Cb data','Cc data',-1)
        set(h2,'tag',tag);
        
    case 'reassign values'
        %Resistances dispayed in mOhms
        var_names={'re','rc','rt'};
        for i=1:length(binf.RC.ess_soc)
            for j=1:length(var_names);
                eval(['value=str2num(get(findobj(gcf,''tag'',''',var_names{j} num2str(i),'''),''string''));']);
                eval(['binf.RC.ess_',var_names{j},'(',num2str(i),')=value/1000;',]);
            end
        end
        %Capacitances displayed in kFarads
        var_names={'cb','cc'};
        for i=1:length(binf.RC.ess_soc)
            for j=1:length(var_names);
                eval(['value=str2num(get(findobj(gcf,''tag'',''',var_names{j} num2str(i),'''),''string''));']);
                eval(['binf.RC.ess_',var_names{j},'(',num2str(i),')=value*1000;',]);
            end
        end
    case 'exit'
        close(gcbf);
    end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Revision history
%03/09/01: vhj created from bat_results, binf.Rint -> binf.RC