function data_file_info(action,action2)
%action=case (e.g. get headings)
%action2=number of row heading (e.g. Time, current)

global binf

if nargin==0
    figcolor=[.8 .8 1]; %purpleish
    butcolor1=[1 .5 .25]; %orangeish
    popupcol=[.8 .8 .8];
    ex_col=[1 1 .8]; %yellowish
    
    %figure and title
    h0 = figure('Color',figcolor, ...
        'Name','Data File Information', ...
        'NumberTitle','off', ...
        'Position',[ 79 263 718 417 ], ...
        'Visible','off',...
        'ToolBar','none');
    h1 = uicontrol('Parent',h0, ...
        'BackgroundColor',figcolor, ...
        'FontSize',14, ...
        'FontWeight','bold', ...
        'Position',[17 386 227 22], ...
        'String','Data File Information', ...
        'Style','text', ...
        'Tag','StaticText1');
    
    %file fill in information section
    %Battery Name
    h1 = uicontrol('Parent',h0, ...
        'BackgroundColor',figcolor, ...
        'HorizontalAlignment','left', ...
        'Position',[90 350 94 17], ...
        'String','Battery Name:', ...
        'Style','text');
    try, eval(['binf.',binf.test_type,'.batname;']);
    catch, 
        try
            eval(['binf.',binf.test_type,'.batname=binf.peukert.batname;']); 
        catch
            eval(['binf.',binf.test_type,'.batname=''e.g. Hawker Genesis 12AH spiral wound lead acid''']); 
        end
    end
    h1 = uicontrol('Parent',h0, ...
        'BackgroundColor',[1 1 1], ...
        'HorizontalAlignment','left', ...
        'Position',[192 350 276 22], ...
        'String',eval(['binf.',binf.test_type,'.batname']), ...
        'Style','edit', ...
        'Tag','batname');
    
    
    %Battery Number
    h1 = uicontrol('Parent',h0, ...
        'BackgroundColor',figcolor, ...
        'HorizontalAlignment','left', ...
        'Position',[90 320 94 17], ...
        'String','Battery Number:', ...
        'Style','text');
    try, eval(['binf.',binf.test_type,'.batnum;']);
    catch, 
        try
            eval(['binf.',binf.test_type,'.batnum=binf.peukert.batnum;']); 
        catch
            eval(['binf.',binf.test_type,'.batnum=''e.g. 72'';']); 
        end
    end
    h1 = uicontrol('Parent',h0, ...
        'BackgroundColor',[1 1 1], ...
        'HorizontalAlignment','left', ...
        'Position',[192 320 276 22], ...
        'String',eval(['binf.',binf.test_type,'.batnum']), ...
        'Style','edit', ...
        'Tag','batnum');
    
    %Test Date
    h1 = uicontrol('Parent',h0, ...
        'BackgroundColor',figcolor, ...
        'HorizontalAlignment','left', ...
        'Position',[90 290 94 17], ...
        'String','Test Date:', ...
        'Style','text');
    try, eval(['binf.',binf.test_type,'.testdate;']);
    catch, 
        try
            eval(['binf.',binf.test_type,'.testdate=binf.peukert.testdate;']); 
        catch
            eval(['binf.',binf.test_type,'.testdate=''e.g. 9/9/99'';']); 
        end
    end
    h1 = uicontrol('Parent',h0, ...
        'BackgroundColor',[1 1 1], ...
        'HorizontalAlignment','left', ...
        'Position',[192 290 276 22], ...
        'String',eval(['binf.',binf.test_type,'.testdate']), ...
        'Style','edit', ...
        'Tag','testdate');
    
    %Test Description
    h1 = uicontrol('Parent',h0, ...
        'BackgroundColor',figcolor, ...
        'HorizontalAlignment','left', ...
        'Position',[90 260 94 17], ...
        'String','Test Description:', ...
        'Style','text');
    try, eval(['binf.',binf.test_type,'.testdescription;']);
    catch,eval(['binf.',binf.test_type,'.testdescription=''e.g. peukert capacity tests'';']); 
    end
    h1 = uicontrol('Parent',h0, ...
        'BackgroundColor',[1 1 1], ...
        'HorizontalAlignment','left', ...
        'Position',[192 260 276 22], ...
        'String',eval(['binf.',binf.test_type,'.testdescription']), ...
        'Style','edit', ...
        'Tag','testdescription');
    
    %Test Script
    h1 = uicontrol('Parent',h0, ...
        'BackgroundColor',figcolor, ...
        'HorizontalAlignment','left', ...
        'Position',[90 230 94 17], ...
        'String','Test Script:', ...
        'Style','text');
    try, eval(['binf.',binf.test_type,'.testscript;']);
    catch, eval(['binf.',binf.test_type,'.testscript=''e.g. Peukert1'';']); 
    end
    h1 = uicontrol('Parent',h0, ...
        'BackgroundColor',[1 1 1], ...
        'HorizontalAlignment','left', ...
        'Position',[192 230 276 22], ...
        'String',eval(['binf.',binf.test_type,'.testscript']), ...
        'Style','edit', ...
        'Tag','testscript');
    
    %Test Data Files
    h1 = uicontrol('Parent',h0, ...
        'BackgroundColor',figcolor, ...
        'HorizontalAlignment','left', ...
        'Position',[90 200 94 17], ...
        'String','Test Data Files:', ...
        'Style','text');
    h1 = uicontrol('Parent',h0, ...
        'BackgroundColor',popupcol, ...
        'Callback','set(findobj(''tag'',''data files''),''value'',1)',...
        'Position',[192 200 276 22], ...
        'String',eval(['binf.',binf.test_type,'.data_files']), ...
        'Style','popupmenu', ...
        'Tag','data files', ...
        'Value',1);
    
    %Rated Ah
    h1 = uicontrol('Parent',h0, ...
        'BackgroundColor',figcolor, ...
        'HorizontalAlignment','left', ...
        'Position',[90 170 94 17], ...
        'String','Rated Ah:', ...
        'Style','text');
    try, eval(['binf.',binf.test_type,'.ratedAh;']);
    catch
        try
            eval(['binf.',binf.test_type,'.ratedAh=binf.peukert.ratedAh;']); 
        catch
            eval(['binf.',binf.test_type,'.ratedAh=''e.g. 6''']); 
        end
    end
    h1 = uicontrol('Parent',h0, ...
        'BackgroundColor',[1 1 1], ...
        'HorizontalAlignment','left', ...
        'Position',[192 170 276 22], ...
        'String',eval(['binf.',binf.test_type,'.ratedAh']), ...
        'Style','edit', ...
        'Tag','ratedAh');
    
    %Data manipulation headings
    h1 = uicontrol('Parent',h0, ...
        'BackgroundColor',figcolor, ...
        'Position',[20 138 92 21], ...
        'String','Variable (y)', ...
        'Style','text', ...
        'Tag','StaticText4',...
        'FontWeight','bold',...
        'HorizontalAlignment','left');
    h1 = uicontrol('Parent',h0, ...
        'BackgroundColor',figcolor, ...
        'Position',[133 139 130 21], ...
        'String','Test Data Heading (x)', ...
        'Style','text',...
        'FontWeight','bold');
    h1 = uicontrol('Parent',h0, ...
        'BackgroundColor',figcolor, ...
        'Position',[339 139 191 21], ...
        'String','Conversion Equation y=f(x)', ...
        'Style','text',...
        'FontWeight','bold');
    h1 = uicontrol('Parent',h0, ...
        'BackgroundColor',figcolor, ...
        'Position',[591 140 127 21], ...
        'String','Example Conversion', ...
        'Style','text',...
        'FontWeight','bold');
    
    var_list={'Time (s)';'Current (A)';'Voltage (V)';'Capacity (Ah)';'Temperature (C)'};
    try, eval(['binf.',binf.test_type,'.equations;']);
    catch, 
        if binf.bitrode
            eval(['binf.',binf.test_type,'.equations={''y=.1*x'';''y=x'';''y=x'';''y=x'';''y=20*x''};']); 
        else
            eval(['binf.',binf.test_type,'.equations={''y=x'';''y=100*x'';''y=4*x'';''y=x'';''y=(x/0.086688-3.5553)*24.80866-0.34825''};']); 
        end
    end
    try, eval(['binf.',binf.test_type,'.var_column;']);
    catch, 
        %try
        %   eval(['binf.',binf.test_type,'.var_column=binf.peukert.var_column;']); 
        %catch
        eval(['binf.',binf.test_type,'.var_column=[1 1 1 1 1];']); 
        %end
    end
    %Data manipulation
    x=[20 120 304 610];
    y=[115];
    yinc=25;
    data_file_info('get headings')
    for i=1:length(var_list)
        %Variable Name
        h1 = uicontrol('Parent',h0, ...
            'BackgroundColor',figcolor, ...
            'Position',[x(1) y(1)-(i-1)*yinc 85 17], ...
            'String',var_list{i}, ...
            'Style','text',...
            'HorizontalAlignment','left');
        %Test Data Heading
        col_num=eval(['binf.',binf.test_type,'.var_column(',num2str(i),')']);
        h1 = uicontrol('Parent',h0, ...
            'BackgroundColor',popupcol, ...
            'Callback',['data_file_info(''heading #'',' num2str(i) ')'],...
            'Position',[x(2) y(1)-(i-1)*yinc 150 20], ...
            'String',eval(['binf.',binf.test_type,'.header_names']), ...
            'Style','popupmenu', ...
            'Tag',['heading' i], ...
            'Value',1);
        try,set(h1,'Value',col_num);end
        %Conversion Equation
        h1 = uicontrol('Parent',h0, ...
            'BackgroundColor',[1 1 1], ...
            'Callback',['data_file_info(''conversion equation'',' num2str(i) ')'],...
            'Position',[x(3) y(1)-(i-1)*yinc 255 20], ...
            'String',eval(['binf.',binf.test_type,'.equations(',num2str(i),',:)']), ...
            'Style','edit', ...
            'Tag',['equation' i]);
        %Example conversion
        h1 = uicontrol('Parent',h0, ...
            'BackgroundColor',ex_col, ...
            'Position',[x(4) y(1)-(i-1)*yinc 76 17], ...
            'Style','text', ...
            'Tag',['example' i]);
    end
    
    %Process Data Button
    h1 = uicontrol('Parent',h0, ...
        'BackgroundColor',butcolor1, ...
        'Callback','data_file_info(''process data'')',...
        'Position',[565 277 118 24], ...
        'String','Process Data', ...
        'Tag','Pushbutton1');
    
    for i=1:length(var_list)
        data_file_info('heading #',i);
    end
    
    h=findobj('type','uicontrol');
    set([h],'units','normalized')
    %_______set the figure size and location
    screensize=get(0,'screensize'); %this should be in pixels(the default)
    figsize=[(screensize(3)-718)/2 (screensize(4)-418)/2 718 418];
    set(gcf,'units','pixels','position',figsize,'visible','on');
    %_____________end set the figure size
    
end

if nargin>0
    switch action
    case 'get headings'
        global linedata;
        header_names=[];header_names_init=[];
        pathname=eval(['binf.',binf.test_type,'.path']);
        name=eval(['binf.',binf.test_type,'.data_files{1}']);
        fid=fopen([pathname eval(['binf.',binf.test_type,'.data_files{1}'])],'rt');
        line=fgetl(fid);
        %strip header
        if isstr(line)
            rem=line;
            i=1;
            while ~isempty(rem)
                if binf.bitrode %strcmp(name(end-2:end),'txt')
                    delim=['"'];
                    [heading,rem]=strtok(rem,delim);
                    %if ~isempty(rem) %!!missing last header w/ this
                    header_names_init{i}=heading;
                    %end
                    i=i+1;
                else %if strcmp(name(end-2:end),'dat')
                    [heading,rem]=strtok(rem);
                    if ~isempty(heading)
                        header_names{i}=heading;
                    end
                    i=i+1;
                end
            end
        end
        if binf.bitrode %strcmp(name(end-2:end),'txt')
            for j=1:length(header_names_init)/2
                header_names{j}=header_names_init{2*j-1};	%eliminate blank spaces in header names
            end
        end
        eval(['binf.',binf.test_type,'.header_names=header_names;']);
        linedata=fgetl(fid);
        no_header_lines=1; %store number of header lines
        while ~isstr(linedata)
            linedata=fgetl(fid);
            no_header_lines=no_header_lines+1;
        end
        linedata=sscanf(linedata,'%g')';
        eval(['binf.',binf.test_type,'.header_names=header_names;']);
        eval(['binf.',binf.test_type,'.no_header_lines=no_header_lines;']);
        fclose(fid);
    case 'heading #'
      global var_column
      %action2=number of row heading (e.g. Time, current)
      var_column(action2)=get(findobj('tag',['heading' action2]),'value');
      data_file_info('evaluate example conversion',action2);
   case 'conversion equation'
      data_file_info('evaluate example conversion',action2);
   case 'evaluate example conversion'
      global linedata var_column;
      raw_value=linedata(var_column(action2)); 
      equation=get(findobj('tag',['equation' action2]),'string');
      if isempty(equation)
         equation='y=x';
      end
      equation=strrep(equation,'x',num2str(raw_value));
      if iscellstr(equation)
         equation=char(equation);
      end
      eval([equation ';']);
      set(findobj('tag',['example' action2]),'string',num2str(y));
   case 'process data'
      global var_column
      
      %put data from gui into binf variable
      %User data inputs
      batname=get(findobj('tag','batname'),'string');
      batnum=get(findobj('tag','batnum'),'string');
      testdate=get(findobj('tag','testdate'),'string');
      testdescription=get(findobj('tag','testdescription'),'string');
      testscript=get(findobj('tag','testscript'),'string');
      ratedAh=get(findobj('tag','ratedAh'),'string');
      eval(['binf.',binf.test_type,'.batname=batname;']); 
      eval(['binf.',binf.test_type,'.batnum=batnum;']); 
      eval(['binf.',binf.test_type,'.testdate=testdate;']); 
      eval(['binf.',binf.test_type,'.testdescription=testdescription;']); 
      eval(['binf.',binf.test_type,'.testscript=testscript;']); 
      eval(['binf.',binf.test_type,'.ratedAh=str2num(ratedAh);']); 
      %Column numbers for variables
      vars={'Time (s)';'Current (A)';'Voltage (V)';'Capacity (Ah)';'Temperature (C)'};
      eval(['binf.',binf.test_type,'.vars=vars;']); 
      eval(['binf.',binf.test_type,'.var_column=var_column;']); %column number for variables
      %Conversion eqns
      eqns=[];
      for i=1:length(var_column)
         eqns=[eqns; get(findobj('tag',['equation' i]),'string')];
      end
      eval(['binf.',binf.test_type,'.equations=eqns;']); %column number for variables
      
      close(gcbf);
      h=waitbar(.05,'Processing Data.  See command window for updates.');
      
      process_data; %call function to process the data
   end
   
end

%Revision history
%5/99: vhj,ss created
%6/25/99: vhj remove ~isempty(rem) to avoid missing last header w/ Bitrode, already specified data used
%7/13/99: vhj added ratedAh capacity
%7/19/99: vhj added bitrode default eqns, save name, number, Ah, columns, from peukert inputs
% 8/11/99: ss under case 'get headings' added if statement when not bitrode  'if ~isempty(heading)'
%             this was to make sure that when there is a rem of a space(ABC) it doesn't add another heading
%              which would be empty.
%09/26/00: vhj/mz: added try statement to setting columns
%03/13/01: vhj center figure