function make_ADV_eng_file(action,var_name)
% Make ADVISOR engine file

global einf;
type='fc';

if nargin==0
   
   figcolor=[.8 .8 1];
   dy=80;
   dx=-22;
   big_dx=325;
   
   %figure
   h0 = figure('Color',figcolor, ...
      'Name','ADVISOR engine file generation', ...
      'NumberTitle','off', ...
      'PaperPosition',[18 30 576 432], ...
      'PaperUnits','points', ...
      'Position',[506+dx 100 652 631+dy], ...
      'ToolBar','none',...
      'visible','off');
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figcolor, ...
      'FontSize',14, ...
      'FontWeight','bold', ...
      'Position',[18+dx 597+dy 342 25], ...
      'String','ADVISOR engine file information', ...
      'Style','text');
   
   %Name of file
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figcolor, ...
      'HorizontalAlignment','left', ...
      'Position',[87+dx 569+dy 125 17], ...
      'String','Name of file to create', ...
      'Style','text');
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[1 1 1], ...
      'HorizontalAlignment','left', ...
      'Position',[189 569+dy big_dx 22], ...
      'String','FC_', ...
      'Style','edit', ...
      'Tag','file name');
   evalin('base','fc_max_pwr=(max(fc_map_spd.*fc_max_trq)/1000);');  % kW     peak engine power
   set(h1,'string',['FC_SI',evalin('base','num2str(round(fc_max_pwr))'),'.m']);
   
   %Gen'l file info
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figcolor, ...
      'HorizontalAlignment','left', ...
      'Position',[87+dx 539+dy 94 17], ...
      'String','General File Info', ...
      'Style','text');
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[1 1 1], ...
      'Position',[189 465+dy big_dx 94], ...
      'String',' ', ...
      'Style','listbox', ...
      'Tag','Listbox1', ...
      'Value',1);
   notes={'File created by engmodel using mat file: ',einf.filename,...
         'Points outside of data points extrapolated based on ','the following algorithm: ',...
         einf.algorithm};
   for i=1:length(einf.vars)
      tmp=['Map: ',einf.vars{i}];
      notes=cellstr(strvcat(char(notes),char(tmp)));
      eval(['tmp=einf.',einf.vars{i},'.avgerror;']);
      tmp=['  Average error (%): ',num2str(tmp)];
      notes=cellstr(strvcat(char(notes),char(tmp)));
      eval(['tmp=einf.',einf.vars{i},'.maxerror;']);
      tmp=['  Maximum error (g/s): ',num2str(tmp)];
      notes=cellstr(strvcat(char(notes),char(tmp)));
      eval(['tmp=einf.',einf.vars{i},'.maxerrorspd;']);
      tmp=['  max error at speed (rpm): ',num2str(tmp)];
      notes=cellstr(strvcat(char(notes),char(tmp)));
      eval(['tmp=einf.',einf.vars{i},'.maxerrortrq;']);
      tmp=['  max error at torque (Nm): ',num2str(tmp)];
      notes=cellstr(strvcat(char(notes),char(tmp)));
   end
   
   set(h1,'string',notes);
   
   %File info
   var_input={'Created by:',[type '_description'],[type '_version'],...
         [type '_proprietary'],[type '_validation'],[type '_fuel_type'],...
         [type '_disp'],[type '_emissions']};
   init_str={'--','X.XL Engine','3.1','(0=nonprop,1=prop)','(0=no valid,1=data agrees w/ source,2=1+data collection methods verified)','Gasoline','X.X','(0=no emis info, 1=info)'};
   dy_input=-30;
   dx_input=300;
   %create the names and edit boxes
   for i=1:length(var_input)
      h1 = uicontrol('Parent',h0, ...
         'BackgroundColor',figcolor, ...
         'HorizontalAlignment','left', ...
         'Position',[87+dx+dx_input*mod(i-1,2)*(i>2) 434+dy+(i-1)*dy_input*(i<3)+(dy_input+floor((i)/2)*dy_input-dy_input*mod(i-1,2))*(i>2) 110 17],...
         'String',var_input{i}, ...
         'Style','text');
      h1 = uicontrol('Parent',h0, ...
         'BackgroundColor',[1 1 1], ...
         'Callback',['make_ADV_eng_file(''edit'',''',var_input{i},''')'],...
         'HorizontalAlignment','left', ...
         'Position',[189+dx_input*mod(i-1,2)*(i>2) 434+dy+(i-1)*dy_input*(i<3)+(dy_input+floor((i)/2)*dy_input-dy_input*mod(i-1,2))*(i>2) big_dx*(i<3)+145*(i>=3) 22], ...
         'String',init_str{i}, ...
         'Style','edit', ...
         'Tag',var_input{i});
      make_ADV_eng_file('edit',var_input{i})
   end
   
   
   %Load defaults?
   h1 = uicontrol('Parent',h0, ...
      'Callback','make_ADV_eng_file(''engine defaults'')',...
      'Position',[87+dx 225+dy 175 24], ...
      'String','Load Default Parameters?', ...
      'Tag','load default box', ...
      'Value',0);
   
   var_input={[type '_base_mass (kg)'],[type '_acc_mass (kg)'],[type '_fuel_mass (kg)'],[type '_inertia (kg*m^2)'],...
         [type '_ext_sarea (m^2)'],[type '_fuel_den (g/l)'],[type '_tstat (C)'],...
         [type '_cp (J/kgK)'],[type '_h_cp (J/kgK)'],[type '_hood_sarea (m^2)'],[type '_emisv'],[type '_hood_emisv'],...
         [type '_h_air_flow (kg/s)'],[type '_cl2h_eff'],[type '_c2i_th_cond (W/K)'],[type '_i2x_th_cond (W/K)'],...
         [type '_h2x_th_cond (W/K)']};
   init_str={'1.8*fc_max_pwr','0.8*fc_max_pwr','0.6*fc_max_pwr','0.1*fc_pwr_scale',...
         '0.3*(fc_max_pwr/100)^0.67','749','96',...
         '500','500','1.5','.8','.9',...
         '0','.7','500','500','10'};
   dy_input=-30;
   dx_input=300;
   %create the names and edit boxes
   for i=1:length(var_input)
      h1 = uicontrol('Parent',h0, ...
         'BackgroundColor',figcolor, ...
         'HorizontalAlignment','left', ...
         'Position',[87+dx+dx_input*mod(i-1,2) 184+dy+(floor((i)/2)*dy_input-dy_input*mod(i-1,2)) 110 17],...
         'String',var_input{i}, ...
         'Style','text');
      h1 = uicontrol('Parent',h0, ...
         'BackgroundColor',[1 1 1], ...
         'Callback',['make_ADV_eng_file(''edit'',''',var_input{i},''')'],...
         'HorizontalAlignment','left', ...
         'Position',[189+dx_input*mod(i-1,2) 184+dy+(floor((i)/2)*dy_input-dy_input*mod(i-1,2)) 145 22], ...
         'String',init_str{i}, ...
         'Style','edit', ...
         'Tag',var_input{i});
      make_ADV_eng_file('edit',var_input{i})
   end

   %Help
   h1 = uicontrol('Parent',h0, ...
      'Callback','load_in_browser(''fuel_converter.html'');',...
      'Position',[430 10 80 24], ...
      'String','Help (thermal)', ...
      'Tag','load default box', ...
      'Value',0);
   %Make file
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[1 0.5 0.25], ...
      'Callback','make_ADV_eng_file(''make file'')', ...
      'Position',[520 10 110 24], ...
      'String','Make ADVISOR File');
   
   % Set figure to normalized for proper resizing
   h=findobj('type','uicontrol');
   g=findobj('type','axes');
   set([h; g],'units','normalized')
   
   %Center figure on screen
   screensize=get(0,'screensize');
   position=get(gcf,'position');
   position(1)=(screensize(3)-position(3))/2;
   position(2)=(screensize(4)-(position(4)+20))/2;
   set(gcf,'position',position,'visible','on')
   
   
end

if nargin>0
   switch action
   case 'edit'
      %disp('entering edit case')
      str_name=get(findobj('tag',var_name),'string');
      %find index where there's a space
      for i=1:length(var_name)
         if strcmp(var_name(i),' ')
            i=i-1;
            break
         end
      end
      var_name=var_name(1:i);
      %disp('after renaming var')
      evalin('base',[var_name,'=''',str_name,''';'])
   case 'engine defaults'
      var_input={[type '_base_mass (kg)'],[type '_acc_mass (kg)'],[type '_fuel_mass (kg)'],[type '_inertia (kg*m^2)'],...
            [type '_ext_sarea (m^2)'],[type '_fuel_den (g/l)'],[type '_tstat (C)'],...
            [type '_cp (J/kgK)'],[type '_h_cp (J/kgK)'],[type '_hood_sarea (m^2)'],[type '_emisv'],[type '_hood_emisv'],...
            [type '_h_air_flow (kg/s)'],[type '_cl2h_eff'],[type '_c2i_th_cond (W/K)'],[type '_i2x_th_cond (W/K)'],...
            [type '_h2x_th_cond (W/K)']};
      default_str={'1.8*fc_max_pwr','0.8*fc_max_pwr','0.6*fc_max_pwr','0.1*fc_pwr_scale',...
            '0.3*(fc_max_pwr/100)^0.67','749','96',...
            '500','500','1.5','.8','.9',...
            '0','.7','500','500','10'};
      for i=1:length(var_input)
         set(findobj('tag',var_input{i}),'string',default_str{i});
      end
      
   case 'make file'
      %%%%%%%%%%%%%%%%%%%%%%%%%%
      %Save
      %%%%%%%%%%%%%%%%%%%%%%%%%%
      filename=get(findobj('tag','file name'),'string');
      template='FC_template.m';
      
      %open the template and new file
      fid=fopen(template,'r');
      fid_new=fopen(filename,'w');
      
      entstr=fscanf(fid,'%c'); %read in entire file to a string (%c reads spaces)
      %Replace name
      entstr=strrep(entstr,'template_name',filename);
      %Notes
      %notes=['File created by engmodel using mat file: ',einf.filename,...
      %      ' Points outside of data points extrapolated based on ','the following algorithm: ',...
      %      einf.algorithm];
      notes=['File created by engmodel using mat file: ',einf.filename,...
            ';% Points outside of data points extrapolated based on the following algorithm: ',...
            einf.algorithm];
      for i=1:length(einf.vars)
         tmp=[';% Map: ',einf.vars{i}];
         notes=[notes,tmp];
         eval(['tmp=einf.',einf.vars{i},'.avgerror;']);
         tmp=[';%  Average error (%): ',num2str(tmp)];
         notes=[notes,tmp];
         eval(['tmp=einf.',einf.vars{i},'.maxerror;']);
         tmp=[';%  Maximum error (g/s): ',num2str(tmp)];
         notes=[notes,tmp];
         eval(['tmp=einf.',einf.vars{i},'.maxerrorspd;']);
         tmp=[';%  max error at speed (rpm): ',num2str(tmp)];
         notes=[notes,tmp];
         eval(['tmp=einf.',einf.vars{i},'.maxerrortrq;']);
         tmp=[';%  max error at torque (Nm): ',num2str(tmp)];
         notes=[notes,tmp];
      end
      entstr=strrep(entstr,'template_notes',notes);
      %Created by:
      entstr=strrep(entstr,'template_createdby',get(findobj('tag','Created by:'),'string'));
      %Date
      entstr=strrep(entstr,'template_date',datestr(now,0));
      %lhv
      entstr=strrep(entstr,'template_fuel_lhv',num2str(einf.lhv));
      %Replace all params input by user
      var_input={[type '_description'],[type '_version'],...
            [type '_proprietary'],[type '_validation'],[type '_fuel_type'],...
            [type '_disp'],[type '_emissions'],...
            [type '_base_mass (kg)'],[type '_acc_mass (kg)'],[type '_fuel_mass (kg)'],[type '_inertia (kg*m^2)'],...
            [type '_ext_sarea (m^2)'],[type '_fuel_den (g/l)'],[type '_tstat (C)'],...
            [type '_cp (J/kgK)'],[type '_h_cp (J/kgK)'],[type '_hood_sarea (m^2)'],[type '_emisv'],[type '_hood_emisv'],...
            [type '_h_air_flow (kg/s)'],[type '_cl2h_eff'],[type '_c2i_th_cond (W/K)'],[type '_i2x_th_cond (W/K)'],...
            [type '_h2x_th_cond (W/K)']};
      for i=1:length(var_input)
         var_name=var_input{i};
         for j=1:length(var_name)
            if strcmp(var_name(j),' ') %find space
               j=j-1;
               break
            end
         end
         var_name=var_name(1:j);	%eliminate units after space
         temp=strrep(var_name,type,''); %eliminate fc
         entstr=strrep(entstr,['template',temp],get(findobj('tag',var_input{i}),'string'));
      end
      
      %Maps
      entstr=strrep(entstr,'template_map_spd',mat2str(evalin('base','fc_map_spd'),4));
      entstr=strrep(entstr,'template_map_trq',mat2str(evalin('base','fc_map_trq'),4));
      entstr=strrep(entstr,'template_fuel_map',mat2str(evalin('base','fc_fuel_map'),4));
      %emis={'hc','co','nox','pm'};
      try, entstr=strrep(entstr,'template_hc_map',mat2str(evalin('base','fc_hc_map'),4));
      catch, entstr=strrep(entstr,'template_hc_map''','zeros(size(fc_fuel_map))'); end
      try, entstr=strrep(entstr,'template_co_map',mat2str(evalin('base','fc_co_map'),4));
      catch, entstr=strrep(entstr,'template_co_map''','zeros(size(fc_fuel_map))'); end
      try, entstr=strrep(entstr,'template_nox_map',mat2str(evalin('base','fc_nox_map'),4));
      catch, entstr=strrep(entstr,'template_nox_map''','zeros(size(fc_fuel_map))'); end
      try, entstr=strrep(entstr,'template_pm_map',mat2str(evalin('base','fc_pm_map'),4));
      catch, entstr=strrep(entstr,'template_pm_map''','zeros(size(fc_fuel_map))'); end
      try, entstr=strrep(entstr,'template_extmp_map',mat2str(evalin('base','fc_extmp_map'),4));
      catch, entstr=strrep(entstr,'template_extmp_map''','fc_ex_pwr_map./(fc_exflow_map*1089/1000) + 20'); end
      entstr=strrep(entstr,'template_max_trq',mat2str(evalin('base','fc_max_trq'),4));
      
      %Print to new file
      for i=1:length(entstr)-1
         if strcmp(entstr(i),';') & ~strcmp(entstr(i+1),' ')
            fprintf(fid_new,'%s',[entstr(i)]);
            fprintf(fid_new,'\n');
         else
            fprintf(fid_new,'%s',[entstr(i)]);
         end
      end
      
      %Close files
      fclose(fid);fclose(fid_new);
      close(gcf);
      helpdlg(['File saved as:',filename]);
      
   end
end


%Revision history
%12/17/99: vhj file created
%12/29/99: vhj replace emissions maps and ' (transpose) to have correct sizes of maps
%01/24/01: vhj updated version to 3.1, help goes to thermal now
% 2/7/01: ss centered figure and changed visible to 'off' during creation
%03/14/010: vhj added capablity to have data for extmp map
