function gctool_setup(option)

%
% GUI interface to setup gctool fuel cell
%

global vinf

if nargin<1
   option='load';
end

switch option
   
case 'load'
   

   figure_color=[1 1 .8];
   
   screen=get(0,'screensize');
   if screen<=[1 1 800 600]
      posfig=[50 50 700 300];
      line_height=18;
   else
      posfig=[50 50 700 300];
      line_height=18;
   end
   
   par_left=posfig(1);
   par_bottom=posfig(2);
   par_width=posfig(3);
   par_height=posfig(4);
   char_width=10;
   border=2*char_width;
   button_width=60;
   button_height=line_height+2;
   editbox_width=60;
   editbox_height=line_height;
   line_num=1;
   
   % create parent figure
   h0 = figure('Color',figure_color, ...
      'Position',posfig, ...
      'numbertitle','off',...
      'name','GCtool Fuel Cell Model Setup Window',...
      'windowstyle','modal');
   
   %set up the defaults if not already set.
   eval('vinf.gctool; test4exist=1;','test4exist=0;');
   if ~test4exist
      vinf.gctool.dv.name={...
            'net_power';...
         }; % add more design variables later
      vinf.gctool.dv.units={...
            '(W)';...
         };
      vinf.gctool.dv.value=[
         50000
      ];
      vinf.gctool.model.name='Hydrogen PEM';
      vinf.gctool.model.menu={'Steam Reformed Methanol PEM','Hydrogen PEM','POX Reformed Gasoline PEM'};
      %vinf.gctool.model.menu={'Steam Reformed Methanol PEM','Hydrogen PEM'};
      vinf.gctool.user_defined=0;
      vinf.gctool.filename='mymodel';
      vinf.gctool.filename_path='c:\';
   end
   
   % model selection section title
   line_num=line_num+1;
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figure_color, ...
      'Position',[border par_height-line_num*line_height par_width-2*border line_height], ...
      'String','Fuel Cell Model Selection', ...
      'Fontweight','bold',...
      'Style','text');
   
   % pre-defined model menu
   line_num=line_num+1;
   h1 = uicontrol('Parent',h0, ...
      'callback','gctool_setup(''pre_defined'')',...
      'BackgroundColor',figure_color, ...
      'Position',[border par_height-line_num*line_height 12*char_width line_height], ...
      'HorizontalAlignment','left',...
      'String','Pre-defined Model', ...
      'Fontweight','normal',...
      'Style','radiobutton',...
      'Tag','pre_defined_radiobutton', ...
      'value',~vinf.gctool.user_defined);
   h1 = uicontrol('Parent',h0, ...
      'Fontsize',8,...
      'Position',[border+12*char_width par_height-line_num*line_height 18*char_width line_height], ...
      'String',vinf.gctool.model.menu, ...
      'Style','popupmenu', ...
      'Tag','model_menu', ...
      'enable','on',...
      'Value',strmatch(vinf.gctool.model.name,vinf.gctool.model.menu,'exact'));
   
   % user defined radiobutton
   h1 = uicontrol('Parent',h0, ...
      'callback','gctool_setup(''user_defined'')',...
      'BackgroundColor',figure_color, ...
      'Position',[par_width/2 par_height-line_num*line_height 12*char_width line_height], ...
      'HorizontalAlignment','left',...
      'String','User-defined Model', ...
      'Fontweight','normal',...
      'Style','radiobutton',...
      'Tag','user_defined_radiobutton', ...
      'value',vinf.gctool.user_defined);
   % user defined file & pathname
   line_num=line_num+1;
   if vinf.gctool.user_defined
      str='on';
   else
      str='off';
   end
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figure_color, ...
      'Position',[par_width/2+2*char_width par_height-line_num*line_height 8*char_width editbox_height], ...
      'HorizontalAlignment','left',...
      'String','Path Info:', ...
      'Style','text');
   h1 = uicontrol('Parent',h0, ...
      'Position',[par_width/2+12*char_width par_height-line_num*line_height 18*char_width editbox_height], ...
      'String',vinf.gctool.filename_path, ...
      'HorizontalAlignment','left',...
      'Style','edit', ...
      'Tag','user_defined_path', ...
      'visible',str, ...
      'enable','on');
   line_num=line_num+1;
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figure_color, ...
      'Position',[par_width/2+2*char_width par_height-line_num*line_height 8*char_width editbox_height], ...
      'HorizontalAlignment','left',...
      'String','Filename:', ...
      'Style','text');
   h1 = uicontrol('Parent',h0, ...
      'Position',[par_width/2+12*char_width par_height-line_num*line_height 18*char_width editbox_height], ...
      'String',vinf.gctool.filename, ...
      'Style','edit', ...
      'HorizontalAlignment','left',...
      'Tag','user_defined_filename', ...
      'visible',str, ...
      'enable','on');
   line_num=line_num+1;
   
   % Design variables section title
   line_num=line_num+1;
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figure_color, ...
      'Position',[border par_height-line_num*line_height par_width-2*border line_height], ...
      'String','Design Variables', ...
      'Fontweight','bold',...
      'Style','text');
   % variable header
   line_num=line_num+1;
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figure_color, ...
      'Position',[border par_height-line_num*line_height 13*char_width line_height], ...
      'String','Variable Name', ...
      'Style','text');
   % units header
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figure_color, ...
      'Position',[border+13*char_width par_height-line_num*line_height 5*char_width line_height], ...
      'String','Units', ...
      'Style','text');
   % setting header
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figure_color, ...
      'Position',[border+18*char_width par_height-line_num*line_height 10*char_width line_height], ...
      'String','Value', ...
      'Style','text');
   for i=1:length(vinf.gctool.dv.name)
      line_num=line_num+1;
      %check box
      h1 = uicontrol('Parent',h0, ...
         'BackgroundColor',figure_color, ...
         'Position',[border par_height-line_num*line_height 13*char_width line_height], ...
         'String',vinf.gctool.dv.name{i}, ...
         'Style','text');
      % units
      h1 = uicontrol('Parent',h0, ...
         'BackgroundColor',figure_color, ...
         'Position',[border+13*char_width par_height-line_num*line_height 5*char_width line_height], ...
         'String',vinf.gctool.dv.units{i},...
         'Style','text');
      % value
      h1 = uicontrol('Parent',h0, ...
         'BackgroundColor',[1 1 1], ...
         'Position',[border+20*char_width par_height-line_num*line_height editbox_width line_height], ...
         'String',num2str(vinf.gctool.dv.value(i)),...
         'Style','edit', ...
         'enable','on', ...
         'Tag',['dv_',vinf.gctool.dv.name{i},'_value']);
   end
   
   line_num=line_num+1;
   
   % include additional statements as needed
   
   line_num=line_num+1;
   
   %run button
   h1 = uicontrol('Parent',h0, ...
      'CallBack','gctool_setup(''run'')',...
      'Position',[(par_width-4*button_width)/5 10 button_width button_height], ...
      'String','RUN', ...
      'Tag','Pushbutton1');
   
   %defaults button
   h1 = uicontrol('Parent',h0, ...
      'CallBack','gctool_setup(''defaults'')',...
      'Position',[2*(par_width-4*button_width)/5+1*button_width 10 button_width button_height], ...
      'String','DEFAULTS', ...
      'Tag','Pushbutton2');
   
   %cancel button
   h1 = uicontrol('Parent',h0, ...
      'CallBack','gctool_setup(''cancel'')',...
      'Position',[3*(par_width-4*button_width)/5+2*button_width 10 button_width button_height], ...
      'String','CANCEL', ...
      'Tag','Pushbutton3');
   
   %help button
   h1 = uicontrol('Parent',h0, ...
      'CallBack','load_in_browser(''gctool_help.html'');',...
      'Position',[4*(par_width-4*button_width)/5+3*button_width 10 button_width button_height], ...
      'String','HELP', ...
      'Tag','Pushbutton4');
   
case 'run'
   flag=0;
   eval('vinf.gctool.fullpath; test4exist=1;','test4exist=0;')
   if ~test4exist|(test4exist&~exist([vinf.gctool.fullpath,'gctool.exe']))
      h=warndlg('Please specify the location of GCtool.exe.','GCtool Location');
      uiwait(h);
      [f,p]=uigetfile('*.exe');
      if f~=0&strcmp(lower(f),'gctool.exe')
         flag=1;
      else
         h=warndlg('Unable to locate GCtool.exe.','GCtool Warning');
         uiwait(h);
      end
   else
      flag=1;
   end
   if flag
      % save the user inputs to the workspace
      if exist('p')
         vinf.gctool.fullpath=p;
      end
      for i=1:length(vinf.gctool.dv.name)
         vinf.gctool.dv.value(i)=str2num(get(findobj('tag',['dv_',vinf.gctool.dv.name{i},'_value']),'string'));
      end
      vinf.gctool.user_defined=get(findobj('tag','user_defined_radiobutton'),'value');
      vinf.gctool.model.name=vinf.gctool.model.menu{get(findobj('tag','model_menu'),'value')};
      vinf.gctool.filename=get(findobj('tag','user_defined_filename'),'string');
      vinf.gctool.filename_path=get(findobj('tag','user_defined_path'),'string');
      
      % process user inputs
      gctool_pre;
      
      % close the current figure
      close(gcbf)

   end
   
case 'defaults'
   
   vinf=rmfield(vinf,'gctool');
   close(gcbf);
   gctool_setup('load');
   
case 'cancel'
   close(gcbf);
   vinf.fuel_converter.name=vinf.fuel_converter.prev_name;
   set(findobj('tag','fuel_converter'),'value',strmatch(vinf.fuel_converter.name,optionlist('get','fuel_converter','junk','v02','fc'),'exact'))
      
case 'pre_defined'
   set(findobj('tag','pre_defined_radiobutton'),'value',1);
   set(findobj('tag','model_menu'),'enable','on'); 
   set(findobj('tag','user_defined_filename'),'enable','off'); 
   set(findobj('tag','user_defined_path'),'enable','off'); 
   set(findobj('tag','user_defined_radiobutton'),'value',0);
   for i=1:length(vinf.gctool.dv.name)
      set(findobj('tag',['dv_',vinf.gctool.dv.name{i},'_value']),'enable','on');
   end
   
case 'user_defined'
   set(findobj('tag','user_defined_radiobutton'),'value',1);
   set(findobj('tag','model_menu'),'enable','off'); 
   set(findobj('tag','pre_defined_radiobutton'),'value',0); 
   [f,p]=uigetfile('*.dat');
   if f==0
      gctool_setup('pre_defined')
   else
      set(findobj('tag','user_defined_path'),'visible','on');
      set(findobj('tag','user_defined_path'),'enable','on');
      set(findobj('tag','user_defined_path'),'string',[p]);
      set(findobj('tag','user_defined_filename'),'visible','on');
      set(findobj('tag','user_defined_filename'),'enable','on');
      set(findobj('tag','user_defined_filename'),'string',[f]);
      for i=1:length(vinf.gctool.dv.name)
         set(findobj('tag',['dv_',vinf.gctool.dv.name{i},'_value']),'enable','off');
      end
   end
   
end % case statements



% revision history
% 9/12/99:tm file created
%
%
