% ADVISOR Data file:  ESS_TT.M
%
% Data source:  
% 
% Data confidence level:  
%
% Notes:  This file loads baseline motor/Controller file and adjusts
% it to match the user defined techincal targets. 
%
% DO NOT EDIT THIS FILE!!!
%
% Created on:  3/4/99  
% By:  Tony Markel, NREL, Tony_Markel@nrel.gov
%
% Revision history at end of file.


eval('vinf.tt.energy_storage; test4exist=1;','test4exist=0;')
if ~test4exist
   % setup defaults
   vinf.tt.energy_storage.filename='ESS_PB25';
   vinf.tt.energy_storage.params.description{1}='Nominal voltage (V)';
   vinf.tt.energy_storage.params.value(1)=12.5;
   vinf.tt.energy_storage.params.description{2}='Minimum operating voltage (V)';
   vinf.tt.energy_storage.params.value(2)=9.5;
   vinf.tt.energy_storage.params.description{3}='Maximum operating voltage (V)';
   vinf.tt.energy_storage.params.value(3)=16.5;
   vinf.tt.energy_storage.params.description{4}='Useable SOC low (--)';
   vinf.tt.energy_storage.params.value(4)=0.4;
   vinf.tt.energy_storage.params.description{5}='Useable SOC high (--)';
   vinf.tt.energy_storage.params.value(5)=0.8;
   vinf.tt.energy_storage.params.description{6}='Specific energy (Wh/kg)';
   vinf.tt.energy_storage.params.value(6)=12;
   vinf.tt.energy_storage.params.description{7}='Discharge power to energy ratio (W/Wh)';
   vinf.tt.energy_storage.params.value(7)=10;
   vinf.tt.energy_storage.params.description{8}='Regen power to energy ratio (W/Wh)';
   vinf.tt.energy_storage.params.value(8)=19;
   vinf.tt.energy_storage.params.description{9}='Duration for discharge power calculation (s)';
   vinf.tt.energy_storage.params.value(9)=18;
   vinf.tt.energy_storage.params.description{10}='Duration for regen power calculation (s)';
   vinf.tt.energy_storage.params.value(10)=2;
   vinf.tt.energy_storage.params.description{11}='Maximum Ah capacity (Ah)';
   vinf.tt.energy_storage.params.value(11)=25;
end

vinf.tt.comp_name='energy_storage';

% prompt user for inputs
tt_setup

waithandle= waitbar(0,'Please wait...');

if eval(['~strcmp(vinf.',vinf.tt.comp_name,'.name,vinf.',vinf.tt.comp_name,'.prev_name)'])
   
   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   % FILE ID INFO
   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   ess_description='Technical Targets based Energy Storage System';
   ess_version=2003; % version of ADVISOR for which the file was generated
   ess_proprietary=0; % 0=> non-proprietary, 1=> proprietary, do not distribute
   ess_validation=0; % 0=> no validation, 1=> data agrees with source data, 
   % 2=> data matches source data and data collection methods have been verified
   disp(['Data loaded: ESS_TT - ',ess_description]);
   
   
   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   % DEFINE TECHNICAL TARGETS
   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   
   % (V) nominal module voltage
   tt_ess_nom_module_volts=vinf.tt.energy_storage.params.value(1);
   
   % (V) min and max operating voltage
   tt_ess_min_module_volts=vinf.tt.energy_storage.params.value(2);
   tt_ess_max_module_volts=vinf.tt.energy_storage.params.value(3);
   
   % (--) min and max operating soc
   tt_ess_min_soc=vinf.tt.energy_storage.params.value(4);
   tt_ess_max_soc=vinf.tt.energy_storage.params.value(5);
   
   % (Wh/kg) specific energy
   tt_ess_se=vinf.tt.energy_storage.params.value(6); 
   
   % (W/Wh) power to energy ratio
   tt_ess_dis_pe_ratio=vinf.tt.energy_storage.params.value(7);
   tt_ess_regen_pe_ratio=vinf.tt.energy_storage.params.value(8);
   
   % (s) constant power discharge/regen durations
   tt_dis_duration=vinf.tt.energy_storage.params.value(9);
   tt_regen_duration=vinf.tt.energy_storage.params.value(10);
   
   % max ah discharge capacity
   tt_ess_max_ah_cap=vinf.tt.energy_storage.params.value(11);
   
   waitbar(0.1,waithandle)
   
   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   % LOAD BASE DATA FILE
   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   
   % save current ess_description
   str=ess_description; 
   
   eval(vinf.tt.energy_storage.filename)
   
   % build new energy storage system description
   ess_description=['Tech Target Energy Storage System based on ',ess_description]; 
   
   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   % ADJUST DATA TO SATISFY TECHNICAL TARGETS
   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   
   % adjust VOC vector
   %ess_nom_module_volts=mean(ess_voc);
   ess_nom_module_volts=mean(mean(ess_voc));
   ess_voc=ess_voc*(tt_ess_nom_module_volts/ess_nom_module_volts);
   
   % set max amp hr capacity
   %ess_max_ah_cap=tt_ess_max_ah_cap;	
   ess_max_ah_cap=ones(size(ess_max_ah_cap))*tt_ess_max_ah_cap;	
   
   if ess_r_chg==ess_r_dis
      ess_r_chg=fliplr(ess_r_dis) % (ohm); no other data available
   end
   
   % initialization
   loop=1; % while loop flag
   tol=0.01; % convergence tolerance on the targets
   iter=1; % iteration counter
   
   % calculate ess parameters
   [ess_energy,ess_dis_pwr,ess_regen_pwr]=btry_specs(0,tt_ess_min_soc,tt_ess_max_soc,1,tt_ess_min_module_volts,tt_ess_max_module_volts,tt_dis_duration,tt_regen_duration);
   
   waitbar_value=0.2;
   waitbar(waitbar_value,waithandle)
   
   
   while loop&iter<5
      
      % adjust internal resistance
      ess_r_dis=ess_r_dis/(tt_ess_dis_pe_ratio/(ess_dis_pwr/ess_energy)); % (ohm)
      ess_r_chg=ess_r_chg/(tt_ess_regen_pe_ratio/(-ess_regen_pwr/ess_energy)); % (ohm)
      
      % update power and energy numbers
      [ess_energy,ess_dis_pwr,ess_regen_pwr]=btry_specs(0,tt_ess_min_soc,tt_ess_max_soc,1,tt_ess_min_module_volts,tt_ess_max_module_volts,tt_dis_duration,tt_regen_duration);

      % reset while loop flag if tolerance has been met
      if (abs(tt_ess_dis_pe_ratio-(ess_dis_pwr/ess_energy))<=tol*tt_ess_dis_pe_ratio)&(abs(tt_ess_regen_pe_ratio-(-ess_regen_pwr/ess_energy))<=tol*tt_ess_regen_pe_ratio)
         loop=0;
      else
         loop=1;
      end
      
      % increment counter
      iter=iter+1;
    
      waitbar_value=(1+waitbar_value)/2;
      waitbar(waitbar_value,waithandle)
      
   end % while ...
   
   waitbar_value=(1+waitbar_value)/2;
   waitbar(0.5,waithandle)
   
   if loop==1&iter==5 % if unsuccessful ...
      uiwait(warndlg('Unable to create this energy storage device. Please try different parameters.'))
      ess_tt
   else
      % set module mass
      ess_module_mass=ess_energy/tt_ess_se;
      
      % verify results
      [ess_energy,ess_dis_pwr,ess_regen_pwr]=btry_specs(1,tt_ess_min_soc,tt_ess_max_soc,1,tt_ess_min_module_volts,tt_ess_max_module_volts,tt_dis_duration,tt_regen_duration);
      
      % set min and max module voltage
      ess_min_volts=tt_ess_min_module_volts;
      ess_max_volts=tt_ess_max_module_volts;

      % display status
      disp([' ** nominal voltage set at ', num2str(tt_ess_nom_module_volts), ' V. ']);
      disp([' ** discharge power to energy ratio set at ', num2str(tt_ess_dis_pe_ratio), ' W/Wh. ']);
      disp([' ** specific energy set at ', num2str(tt_ess_se), ' Wh/kg. ']);
   end
else
   eval(['run ',eval(['vinf.',vinf.tt.comp_name,'.name'])])
end

close(waithandle)
clear waithandle waitbar_value

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% REVISION HISTORY
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 07/24/98 (tm): created from MC_TT.M
% 2/22/98:tm updated with revamped module specs and calculation routines
% 3/11/99:tm enclosed code in an if statement so that it is conditionally executed 
% 3/15/99:ss updated *_version to 2.1 from 2.0
% 9/10/99:tm updated to work with new thermal ess model
% 11/03/99:ss updated version from 2.2 to 2.21
% 8/18/00:tm added else condition, if tt canceled then rerun old file because gui clears the data
%