% ADVISOR Data file:  FC_TT_FC.M
%
% Data source:   
%
% Data confidence level:  
%
% Notes: This file can be used to define a fuel cell powerplant 
% based on technical targets. DO NOT EDIT THIS FILE!!!
%
% Created on:  02/17/99
% By:  Tony Markel, National Renewable Energy Laboratory, Tony_Markel@nrel.gov
%
% Revision history at end of file.
%

eval('vinf.tt.fuel_converter; test4exist=1;','test4exist=0;')

if ~test4exist|~strcmp(vinf.tt.fuel_converter.params.description{1},'System efficiency at 25% peak power (%)')   
   
   % setup defaults
   vinf.tt.fuel_converter.filename='FC_IFC50';
   vinf.tt.fuel_converter.params.description{1}='System efficiency at 25% peak power (%)';
   vinf.tt.fuel_converter.params.value(1)=50;
   vinf.tt.fuel_converter.params.description{2}='Specific power (W/kg)';
   vinf.tt.fuel_converter.params.value(2)=300;
   
end

vinf.tt.comp_name='fuel_converter';

% prompt user for inputs
tt_setup;

if eval(['~strcmp(vinf.',vinf.tt.comp_name,'.name,vinf.',vinf.tt.comp_name,'.prev_name)'])
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% FILE ID INFO
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
fc_description='Technical Targets based Fuel Converter - Fuel Cell'; 
fc_version=2003; % version of ADVISOR for which the file was generated
fc_proprietary=0; % 0=> non-proprietary, 1=> proprietary, do not distribute
fc_validation=0; % 1=> no validation, 1=> data agrees with source data, 
% 2=> data matches source data and data collection methods have been verified
fc_cold=0;      % boolean 0=no cold data; 1=cold data exists
disp(['Data loaded: FC_TT_FC - ',fc_description]);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DEFINE TECHNICAL TARGETS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% (%) system efficiency at 25% peak power
tt_fc_eff_25ppwr=vinf.tt.fuel_converter.params.value(1); 

% (W/kg) specific power
tt_fc_spwr=vinf.tt.fuel_converter.params.value(2); 


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% LOAD BASE DATA FILE
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% save current fc_description
str=fc_description; 

eval(vinf.tt.fuel_converter.filename)

% build new fuel converter description
fc_description=['Tech Target Fuel Converter based on ',fc_description]; 


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% ADJUST DATA TO SATISFY TECHNICAL TARGETS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% determine the efficiency at 25% peak power 
fc_eff_25ppwr=interp1(fc_pwr_map,fc_eff_map,0.25*max(fc_pwr_map));

% scale the entire fuel map by the ratio of the actual to the target brake thermal efficiency
fc_fuel_map=fc_fuel_map/(tt_fc_eff_25ppwr/(fc_eff_25ppwr*100));

% scale the mass of the fuel converter to satisfy specific power tech target
fc_mass=max(fc_pwr_map*fc_pwr_scale)/tt_fc_spwr;

disp([' ** system efficiency at 25% power set at ', num2str(tt_fc_eff_25ppwr), '. ']);
disp([' ** specific power set at ', num2str(tt_fc_spwr), '. ']);

% (g/s), engine out O2 indexed vertically by fc_map_spd and
% horizontally by fc_map_trq
fc_o2_map=zeros(size(fc_fuel_map));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Cold Engine Maps
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
fc_cold_tmp=20; %deg C
fc_fuel_map_cold=zeros(size(fc_fuel_map));
fc_hc_map_cold=zeros(size(fc_fuel_map));
fc_co_map_cold=zeros(size(fc_fuel_map));
fc_nox_map_cold=zeros(size(fc_fuel_map));
fc_pm_map_cold=zeros(size(fc_fuel_map));
%Process Cold Maps to generate Correction Factor Maps
names={'fc_fuel_map','fc_hc_map','fc_co_map','fc_nox_map','fc_pm_map'};
for i=1:length(names)
    %cold to hot raio, e.g. fc_fuel_map_c2h = fc_fuel_map_cold ./ fc_fuel_map
    eval([names{i},'_c2h=',names{i},'_cold./(',names{i},'+eps);'])
end

end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% REVISION HISTORY
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 02/17/99 (tm): file created
% 3/11/99:tm enclosed code in an if statement so that it is conditionally executed 
% 3/15/99:ss updated *_version to 2.1 from 2.0
% 9/21/99:tm removed all references to fc_map_spd and fc_map_trq - changed to pwr
% 11/03/99:ss updated version from 2.2 to 2.21
% 01/31/01: vhj added fc_cold=0, added cold map variables, added +eps to avoid dividing by zero
% 02/26/01: vhj added variable definition of fc_o2_map (used in NOx absorber emis.)
% 04/08/02: kh updated version from 3.2 to 2002