%------------------------------------------------------------------------------------
%
% M-file: Pr_H20l.m    (Pr- number for liquid water)
%
% Data from Hellsten, Gunnar, "Tabeller och diagram",
% 1992, Almqvist & Wiksell
% ("Tables and diagrams")
% 
% Revision history:
% Created: 08/16/00 by Kristina Haraldsson
% Modified: 03/21/02
%------------------------------------------------------------------------------------------
function f=Pr_H2Ol(T)

%NOTE: temperature T in [C].

if T<0
   Pr=0;
elseif ((T>=0) & (T<5))
   Pr=(T-0)/(5-0)*(11.3-13.7)+13.7;
elseif ((T>=5) & (T<10))
   Pr=(T-5)/(10-5)*(9.51-11.3)+11.3;
elseif ((T>=10) & (T<15))
   Pr=(T-10)/(15-10)*(8.09-9.51)+9.51;
elseif ((T>=15) & (T<20))
   Pr=(T-15)/(20-15)*(7.01-8.09)+8.09;
elseif ((T>=20) & (T<25))
   Pr=(T-20)/(25-20)*(6.18-7.01)+7.01;
elseif ((T>=25) & (T<30))
   Pr=(T-25)/(30-25)*(5.41-6.18)+6.18;
elseif ((T>=30) & (T<35))
   Pr=(T-30)/(35-30)*(4.85-5.41)+5.41;
elseif ((T>=35) & (T<40))
   Pr=(T-35)/(40-35)*(4.30-4.85)+4.85;
elseif ((T>=40) & (T<45))
   Pr=(T-40)/(45-40)*(3.95-4.30)+4.30;
elseif ((T>=45) & (T<50))
   Pr=(T-45)/(50-45)*(3.57-3.95)+3.95;
elseif ((T>=50) & (T<55))
   Pr=(T-50)/(55-50)*(3.27-3.57)+3.57;
elseif ((T>=55) & (T<60))
   Pr=(T-55)/(60-55)*(2.98-3.27)+3.27;
elseif ((T>=60) & (T<65))
   Pr=(T-60)/(65-60)*(2.76-2.98)+2.98; 
elseif ((T>=65) & (T<70))
   Pr=(T-65)/(70-65)*(2.57-2.76)+2.76; 
elseif ((T>=70) & (T<75))
   Pr=(T-70)/(75-70)*(2.39-2.57)+2.57;
elseif ((T>=75) & (T<80))
   Pr=(T-75)/(80-75)*(2.23-2.39)+2.39;
elseif ((T>=80) & (T<85))
   Pr=(T-80)/(85-80)*(2.10-2.23)+2.23;
elseif ((T>=85) & (T<90))
   Pr=(T-85)/(90-85)*(1.95-2.10)+2.10;
elseif ((T>=90) & (T<95))
   Pr=(T-90)/(95-90)*(1.85-1.95)+1.95;
elseif ((T>=95) & (T<100))
   Pr=(T-95)/(100-95)*(1.75-1.85)+1.85;
else T>100
   Pr=0;
end;
f=Pr;