%-------------------------------------------------------------------------------------
%
% M-file: h_O2.m  [kJ/kmol respectively kJ/kg] T in [K]
%
% Data from L. Wester, 1998
%
% Created: 000807 by Kristina Johansson
% Revision history:
%--------------------------------------------------------------------------------------
function f=h_O2(T)

M_O2=31.9988; %[kg/kmol]

%y=M_O2*h=H

a_0=-300.30000;
a_1=33051.759;
a_2=-20917.083;
a_3=49341.367;
a_4=-51255.572;
a_5=29073.599;
a_6=-8715.1202;
a_7=1082.4395;
a_8=0;
b=0;

y=a_0*(T/1000)^(0)+a_1*(T/1000)^(1)+a_2*(T/1000)^(2)+a_3*(T/1000)^(3)+a_4*(T/1000)^(4)+a_5*(T/1000)^(5)+a_6*(T/1000)^(6)+a_7*(T/1000)^(7)+a_8*(T/1000)^(8)+b*log(T/1000);
%z=y/M_O2;

f=[y];
