%---------------------------------------------------------------
%
% M-file: my_H.m
% Last modified: 991206 by Kristina Johansson
%----------------------------------------------------------------
function f=my_H(T)

%Values from "AGA Gas Handbok", valid for p=1 bar 
if T<273.15
   y=0;
elseif ((T>=273.15) & (T<275))
   y=(T-273.15)/(275-273.15)*(0.0000084-0.0000083)+0.0000083;
elseif ((T>=275) & (T<288.15))
   y=(T-275)/(288.15-275)*(0.0000086-0.0000084)+0.0000084;
elseif ((T>=288.15) & (T<300))
   y=(T-288.15)/(300-288.15)*(0.0000089-0.0000086)+0.0000086;
elseif ((T>=300) & (T<325))
   y=(T-300)/(325-300)*(0.0000094-0.0000089)+0.0000089;
elseif ((T>=325) & (T<350))
   y=(T-325)/(350-325)*(0.0000099-0.0000094)+0.0000094;      
elseif ((T>=350) & (T<375))
   y=(T-350)/(375-350)*(0.0000103-0.0000099)+0.0000099;
elseif ((T>=375) & (T<400))
   y=(T-375)/(400-375)*(0.0000108-0.0000103)+0.0000103;      
elseif ((T>=400) & (T<425))
   y=(T-400)/(425-400)*(0.0000112-0.0000108)+0.0000108;
   elseif ((T>=425) & (T<450))
   y=(T-425)/(450-425)*(0.0000117-0.0000112)+0.0000112;
elseif (T>=450)
   y=0;
end;
f=y;