% ADVISOR Data file:  MC_TT.m
%
% Data source:  
% 
% Data confidence level:  
%
% Notes:  This file loads baseline motor/Controller file and adjusts
% it to match the user defined techincal targets. 
%
% DO NOT EDIT THIS FILE!!!
%
% Created on:  02/17/99  
% By:  Tony Markel, NREL, Tony_Markel@nrel.gov
%
% Revision history at end of file.


eval('vinf.tt.motor_controller; test4exist=1;','test4exist=0;')

if ~test4exist
   
   % setup defaults
   vinf.tt.motor_controller.filename='MC_AC75';
   vinf.tt.motor_controller.params.description{1}='Minimum efficiency in 2 to 20% power range (%)';
   vinf.tt.motor_controller.params.value(1)=84;
   vinf.tt.motor_controller.params.description{2}='Specific power (W/kg)';
   vinf.tt.motor_controller.params.value(2)=750;
   
end

vinf.tt.comp_name='motor_controller';

% prompt user for inputs
tt_setup

if eval(['~strcmp(vinf.',vinf.tt.comp_name,'.name,vinf.',vinf.tt.comp_name,'.prev_name)'])
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% FILE ID INFO
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
mc_description='Technical Targets based Motor/Controller';
mc_version=2003; % version of ADVISOR for which the file was generated
mc_proprietary=0; % 0=> non-proprietary, 1=> proprietary, do not distribute
mc_validation=0; % 0=> no validation, 1=> data agrees with source data, 
% 2=> data matches source data and data collection methods have been verified
disp(['Data loaded: MC_TT - ',mc_description]);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DEFINE TECHNICAL TARGETS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% (%) minimum efficiency over 10% to 100% speed range at 20% torque
tt_mc_eff=vinf.tt.motor_controller.params.value(1)/100; 

% (W/kg) motor specific power
tt_mc_spwr=vinf.tt.motor_controller.params.value(2); 


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% LOAD BASE DATA FILE
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% save current mc_description
str=mc_description; 

eval(vinf.tt.motor_controller.filename)

% build new motor/controller description
mc_description=['Tech Target Motor/controller based on ',mc_description]; 


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% ADJUST DATA TO SATISFY TECHNICAL TARGETS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% create a 20% power island with the specified efficiency and leave the rest of the map as is
[T,w]=meshgrid(mc_map_trq,mc_map_spd);
mc_map_kW=T.*w/1000;
between_2_and_20_percent_pwr=(abs(mc_map_kW)<=0.2*max(max(mc_map_kW)))&(abs(mc_map_kW)>=0.02*max(max(mc_map_kW)));
mc_eff_map=mc_eff_map.*(1-between_2_and_20_percent_pwr)+tt_mc_eff*between_2_and_20_percent_pwr;

% scale the mass of the fuel converter to satisfy specific power tech target
mc_mass=max(mc_map_spd*mc_spd_scale.*mc_max_trq*mc_trq_scale)*(1/tt_mc_spwr);

disp([' ** minimum efficiency over 2 to 20% power range set at ', num2str(tt_mc_eff*100), ' %. ']);
disp([' ** specific power set at ', num2str(tt_mc_spwr), ' W/kg. ']);

end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% REVISION HISTORY
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 02/17/99 (tm): file created 
% 3/11/99:tm enclosed code in an if statement so that it is conditionally executed 
% 3/15/99:ss updated *_version to 2.1 from 2.0









% 11/03/99:ss updated version from 2.2 to 2.21
% 7/30/01:tm updated version from 3.1 to 3.2