%interpolator data
%c     @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
%c
%c           START OF SCALAR DATA FOR CIDI,DISC,PFI ENGINES
%c
%c     @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
%c
if dd
%c +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%c +++ Beginning of emission data for Direct 
%c +++ Injected Compression Ignition engine.
%c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%c
%c +++ Bore & stroke dimensions, and speed & load conditions for which
%c +++ simulations were performed. Must be listed from smallest to largest.
%c
%	data (boresdd(i),i=1,bptsdd)/
%     & 7.4295, 8.255, 9.0805/
boresdd=[7.4295, 8.255, 9.0805];
%c
%	data (stksdd(i),i=1,stptsdd)/
%     & 8.63775, 9.5975, 10.55725/
stksdd=[8.63775, 9.5975, 10.55725];
%c
%	data (rpmsdd(i),i=1,rpmptdd)/
%     & 1200, 1800, 2400/
rpmsdd=[1200, 1800, 2400];
%c
%	data (lddd(i),i=1,ldptsdd)/
%     & .4, .6, .8/
lddd=[.4, .6, .8];
%c
%c +++ Emission data for B-10%, S-10%; Bore = 7.4295, Stroke = 8.63775
%c +++ Line 1 = df2(ppm); 2=CO; 3=NO; 4=ISFC; 5=Ind Torque (N-M)
%c
%	data (((scldd(1,1,ld,irpm,ival),ld=1,ldptsdd),irpm=1,rpmptdd),
%     & ival=1,ivalsdd)/
%     1 1.105,0.981,0.966,1.089,1.043,1.008,0.981,1.000,0.992,
%     2 1.278,1.310,0.962,1.043,0.953,0.920,0.969,1.027,1.153,
%     3 0.992,1.028,1.020,1.005,1.009,1.003,1.019,1.005,1.043,
%     4 1.006,1.004,0.996,0.999,0.989,1.003,0.977,0.984,0.995,
%     5 10.709,14.685,19.124,11.117,16.104,20.538,11.185,16.459,20.972/
%
% 1 df2(ppm)                       row is indexed with ld and column is indexed with rpm, note the ' transpose necessary
scldd(1,1,1:ldptsdd,1:rpmptdd,1) = [1.105,0.981,0.966 ; 1.089,1.043,1.008 ; 0.981,1.000,0.992]';
% 2 CO
scldd(1,1,1:ldptsdd,1:rpmptdd,2) = [1.278,1.310,0.962 ; 1.043,0.953,0.920 ; 0.969,1.027,1.153]';
% 3 NO
scldd(1,1,1:ldptsdd,1:rpmptdd,3) = [0.992,1.028,1.020 ; 1.005,1.009,1.003 ; 1.019,1.005,1.043]';
% 4 ISFC
scldd(1,1,1:ldptsdd,1:rpmptdd,4) = [1.006,1.004,0.996 ; 0.999,0.989,1.003 ; 0.977,0.984,0.995]';
% 5 Ind Torque
scldd(1,1,1:ldptsdd,1:rpmptdd,5) = [10.709,14.685,19.124 ; 11.117,16.104,20.538 ; 11.185,16.459,20.972]';
%
%c
%c +++ Emission data for B-10%; Bore = 7.4295, Stroke = 9.5975
%c +++ Line 1 = df2(ppm); 2=CO; 3=NO; 4=ISFC; 5=Ind Torque (N-M)
%c
%	data (((scldd(1,2,ld,irpm,ival),ld=1,ldptsdd),irpm=1,rpmptdd),
%     & ival=1,ivalsdd)/
%     1 0.298,0.559,1.004,0.459,0.650,1.083,0.504,0.727,1.004,
%     2 0.269,0.460,1.420,0.662,0.521,1.934,0.851,0.620,1.836,
%     3 1.043,1.165,1.136,1.036,1.134,1.107,1.071,1.121,1.129,
%     4 0.951,0.940,0.999,0.966,0.974,1.017,0.958,0.980,0.989,
%     5 12.598,17.444,21.210,12.768,18.156,22.510,12.618,18.297,23.355/
scldd(1,2,1:ldptsdd,1:rpmptdd,1) = [0.298,0.559,1.004 ; 0.459,0.650,1.083 ; 0.504,0.727,1.004]';
scldd(1,2,1:ldptsdd,1:rpmptdd,2) = [0.269,0.460,1.420 ; 0.662,0.521,1.934 ; 0.851,0.620,1.836]';
scldd(1,2,1:ldptsdd,1:rpmptdd,3) = [1.043,1.165,1.136 ; 1.036,1.134,1.107 ; 1.071,1.121,1.129]';
scldd(1,2,1:ldptsdd,1:rpmptdd,4) = [0.951,0.940,0.999 ; 0.966,0.974,1.017 ; 0.958,0.980,0.989]';
scldd(1,2,1:ldptsdd,1:rpmptdd,5) = [12.598,17.444,21.210 ; 12.768,18.156,22.510 ; 12.618,18.297,23.355]';     
%c
%c +++ Emission data for B-10%, S+10%; Bore = 7.4295, Stroke = 10.55725
%c +++ Line 1 = df2(ppm); 2=CO; 3=NO; 4=ISFC; 5=Ind Torque (N-M)
%c
%    data (((scldd(1,3,ld,irpm,ival),ld=1,ldptsdd),irpm=1,rpmptdd),
%     & ival=1,ivalsdd)/
%     1 0.178,0.314,0.845,0.289,0.440,0.877,0.356,0.544,0.885,
%     2 0.147,0.256,1.589,0.650,0.538,1.698,1.500,1.004,1.384,
%     3 1.125,1.256,1.162,1.160,1.178,1.211,1.185,1.169,1.213,
%     4 0.898,0.885,0.952,0.914,0.930,0.959,0.921,0.945,0.963,
%     5 14.686,20.391,24.483,14.822,20.889,26.209,14.377,20.770,26.260/
scldd(1,3,1:ldptsdd,1:rpmptdd,1) = [0.178,0.314,0.845 ; 0.289,0.440,0.877 ; 0.356,0.544,0.885]';
scldd(1,3,1:ldptsdd,1:rpmptdd,2) = [0.147,0.256,1.589 ; 0.650,0.538,1.698 ; 1.500,1.004,1.384]';
scldd(1,3,1:ldptsdd,1:rpmptdd,3) = [1.125,1.256,1.162 ; 1.160,1.178,1.211 ; 1.185,1.169,1.213]';
scldd(1,3,1:ldptsdd,1:rpmptdd,4) = [0.898,0.885,0.952 ; 0.914,0.930,0.959 ; 0.921,0.945,0.963]';
scldd(1,3,1:ldptsdd,1:rpmptdd,5) = [14.686,20.391,24.483 ; 14.822,20.889,26.209 ; 14.377,20.770,26.260]';
%c
%c +++ Emission data for S-10%; Bore = 8.255, Stroke = 8.63775
%c +++ Line 1 = df2(ppm); 2=CO; 3=NO; 4=ISFC; 5=Ind Torque (N-M)
%c
%	data (((scldd(2,1,ld,irpm,ival),ld=1,ldptsdd),irpm=1,rpmptdd),
%     & ival=1,ivalsdd)/
%     1 0.195,0.353,0.603,0.362,0.484,0.683,0.469,0.652,0.802,
%     2 0.270,1.738,0.565,1.107,2.585,1.254,0.759,2.234,1.409,
%     3 1.115,1.122,1.071,1.112,1.104,1.030,1.092,1.039,1.077,
%     4 0.922,0.903,0.933,0.926,0.938,0.962,0.938,0.961,0.979,
%     5 14.440,20.156,25.212,14.799,20.957,26.434,14.351,20.759,26.259/
scldd(2,1,1:ldptsdd,1:rpmptdd,1) = [0.195,0.353,0.603 ; 0.362,0.484,0.683 ; 0.469,0.652,0.802]';
scldd(2,1,1:ldptsdd,1:rpmptdd,2) = [0.270,1.738,0.565 ; 1.107,2.585,1.254 ; 0.759,2.234,1.409]';
scldd(2,1,1:ldptsdd,1:rpmptdd,3) = [1.115,1.122,1.071 ; 1.112,1.104,1.030 ; 1.092,1.039,1.077]';
scldd(2,1,1:ldptsdd,1:rpmptdd,4) = [0.922,0.903,0.933 ; 0.926,0.938,0.962 ; 0.938,0.961,0.979]';
scldd(2,1,1:ldptsdd,1:rpmptdd,5) = [14.440,20.156,25.212 ; 14.799,20.957,26.434 ; 14.351,20.759,26.259]';
%c
%c +++ Emission data for Baseline engine; Bore = 8.255, Stroke = 9.5975
%c +++ Line 1 = df2(ppm); 2=CO; 3=NO; 4=ISFC; 5=Ind Torque (N-M)
%c
%	data (((scldd(2,2,ld,irpm,ival),ld=1,ldptsdd),irpm=1,rpmptdd),
%     & ival=1,ivalsdd)/
%     1 1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
%     2 1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
%     3 1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
%     4 1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
%     5 14.809,20.258,26.190,15.229,21.845,28.259,14.901,22.087,28.458/
scldd(2,2,1:ldptsdd,1:rpmptdd,1) = [1.000,1.000,1.000 ; 1.000,1.000,1.000 ; 1.000,1.000,1.000]';
scldd(2,2,1:ldptsdd,1:rpmptdd,2) = [1.000,1.000,1.000 ; 1.000,1.000,1.000 ; 1.000,1.000,1.000]';
scldd(2,2,1:ldptsdd,1:rpmptdd,3) = [1.000,1.000,1.000 ; 1.000,1.000,1.000 ; 1.000,1.000,1.000]';
scldd(2,2,1:ldptsdd,1:rpmptdd,4) = [1.000,1.000,1.000 ; 1.000,1.000,1.000 ; 1.000,1.000,1.000]';
scldd(2,2,1:ldptsdd,1:rpmptdd,5) = [14.809,20.258,26.190 ; 15.229,21.845,28.259 ; 14.901,22.087,28.458]';
%c
%c +++ Emission data for S+10%; Bore = 8.255, Stroke = 10.55725
%c +++ Line 1 = df2(ppm); 2=CO; 3=NO; 4=ISFC; 5=Ind Torque (N-M)
%c
%	data (((scldd(2,3,ld,irpm,ival),ld=1,ldptsdd),irpm=1,rpmptdd),
%     & ival=1,ivalsdd)/
%     1 0.310,0.575,1.069,0.474,0.655,1.030,0.540,0.757,1.060,
%     2 0.308,0.433,1.819,0.666,0.387,1.745,0.757,0.491,1.668,
%     3 1.031,1.194,1.125,1.041,1.124,1.079,1.050,1.078,1.017,
%     4 0.954,0.940,1.007,0.976,0.979,1.001,0.983,0.993,1.018,
%     5 17.078,23.709,28.617,17.145,24.516,31.005,16.598,24.338,30.609/
scldd(2,3,1:ldptsdd,1:rpmptdd,1) = [0.310,0.575,1.069 ; 0.474,0.655,1.030 ; 0.540,0.757,1.060]';
scldd(2,3,1:ldptsdd,1:rpmptdd,2) = [0.308,0.433,1.819 ; 0.666,0.387,1.745 ; 0.757,0.491,1.668]';
scldd(2,3,1:ldptsdd,1:rpmptdd,3) = [1.031,1.194,1.125 ; 1.041,1.124,1.079 ; 1.050,1.078,1.017]';
scldd(2,3,1:ldptsdd,1:rpmptdd,4) = [0.954,0.940,1.007 ; 0.976,0.979,1.001 ; 0.983,0.993,1.018]';
scldd(2,3,1:ldptsdd,1:rpmptdd,5) = [17.078,23.709,28.617 ; 17.145,24.516,31.005 ; 16.598,24.338,30.609]';
%c
%c +++ Emission data for B+10%, S-10%; Bore = 9.0805, Stroke = 8.63775
%c +++ Line 1 = df2(ppm); 2=CO; 3=NO; 4=ISFC; 5=Ind Torque (N-M)
%c
%	data (((scldd(3,1,ld,irpm,ival),ld=1,ldptsdd),irpm=1,rpmptdd),
%     & ival=1,ivalsdd)/
%     1 0.700,0.524,0.628,0.746,0.581,0.683,0.801,0.833,1.006,
%     2 0.747,1.259,0.834,2.040,2.497,0.858,4.379,3.777,1.586,
%     3 0.973,0.971,0.913,1.023,0.918,0.849,1.025,0.903,0.846,
%     4 0.986,0.922,0.918,0.999,0.933,0.954,0.981,0.989,1.026,
%     5 16.338,23.884,31.033,16.587,25.476,32.226,16.543,24.340,30.218/
scldd(3,1,1:ldptsdd,1:rpmptdd,1) = [0.700,0.524,0.628 ; 0.746,0.581,0.683 ; 0.801,0.833,1.006]';
scldd(3,1,1:ldptsdd,1:rpmptdd,2) = [0.747,1.259,0.834 ; 2.040,2.497,0.858 ; 4.379,3.777,1.586]';
scldd(3,1,1:ldptsdd,1:rpmptdd,3) = [0.973,0.971,0.913 ; 1.023,0.918,0.849 ; 1.025,0.903,0.846]';
scldd(3,1,1:ldptsdd,1:rpmptdd,4) = [0.986,0.922,0.918 ; 0.999,0.933,0.954 ; 0.981,0.989,1.026]';
scldd(3,1,1:ldptsdd,1:rpmptdd,5) = [16.338,23.884,31.033 ; 16.587,25.476,32.226 ; 16.543,24.340,30.218]';
%c
%c +++ Emission data for B+10%; Bore = 9.0805, Stroke = 9.5975
%c +++ Line 1 = df2(ppm); 2=CO; 3=NO; 4=ISFC; 5=Ind Torque (N-M)
%c
%	data (((scldd(3,2,ld,irpm,ival),ld=1,ldptsdd),irpm=1,rpmptdd),
%     & ival=1,ivalsdd)/
%     1 0.209,0.348,0.636,0.368,0.497,0.700,0.385,0.589,0.837,
%     2 0.418,1.681,0.611,0.858,2.286,1.227,0.565,1.539,1.306,
%     3 1.103,1.182,1.087,1.049,1.019,0.966,1.080,0.981,0.954,
%     4 0.915,0.897,0.926,0.945,0.950,0.962,0.959,0.972,1.000,
%     5 19.600,27.329,34.227,19.495,27.814,35.538,18.755,27.404,34.344/
scldd(3,2,1:ldptsdd,1:rpmptdd,1) = [0.209,0.348,0.636 ; 0.368,0.497,0.700 ; 0.385,0.589,0.837]';
scldd(3,2,1:ldptsdd,1:rpmptdd,2) = [0.418,1.681,0.611 ; 0.858,2.286,1.227 ; 0.565,1.539,1.306]';
scldd(3,2,1:ldptsdd,1:rpmptdd,3) = [1.103,1.182,1.087 ; 1.049,1.019,0.966 ; 1.080,0.981,0.954]';
scldd(3,2,1:ldptsdd,1:rpmptdd,4) = [0.915,0.897,0.926 ; 0.945,0.950,0.962 ; 0.959,0.972,1.000]';
scldd(3,2,1:ldptsdd,1:rpmptdd,5) = [19.600,27.329,34.227 ; 19.495,27.814,35.538 ; 18.755,27.404,34.344]';
%c
%c +++ Emission data for B+10%, S+10%; Bore = 9.0805, Stroke = 10.55725
%c +++ Line 1 = df2(ppm); 2=CO; 3=NO; 4=ISFC; 5=Ind Torque (N-M)
%c
%	data (((scldd(3,3,ld,irpm,ival),ld=1,ldptsdd),irpm=1,rpmptdd),
%     & ival=1,ivalsdd)/
%     1 0.961,0.947,1.005,0.948,0.949,0.998,0.977,1.002,1.054,
%     2 0.855,0.928,0.992,0.908,1.016,0.987,0.846,0.875,1.139,
%     3 0.998,1.012,1.018,1.000,0.981,0.941,1.027,0.994,0.973,
%     4 1.000,0.982,0.993,1.006,1.001,1.003,1.024,1.017,1.021,
%     5 19.738,27.488,35.164,20.121,28.997,37.444,19.218,28.682,36.816/
scldd(3,3,1:ldptsdd,1:rpmptdd,1) = [0.961,0.947,1.005 ; 0.948,0.949,0.998 ; 0.977,1.002,1.054]';
scldd(3,3,1:ldptsdd,1:rpmptdd,2) = [0.855,0.928,0.992 ; 0.908,1.016,0.987 ; 0.846,0.875,1.139]';
scldd(3,3,1:ldptsdd,1:rpmptdd,3) = [0.998,1.012,1.018 ; 1.000,0.981,0.941 ; 1.027,0.994,0.973]';
scldd(3,3,1:ldptsdd,1:rpmptdd,4) = [1.000,0.982,0.993 ; 1.006,1.001,1.003 ; 1.024,1.017,1.021]';
scldd(3,3,1:ldptsdd,1:rpmptdd,5) = [19.738,27.488,35.164 ; 20.121,28.997,37.444 ; 19.218,28.682,36.816]';
%c
%c ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%c +++ End of emission data for Direct Injected Compression +++++
%c +++ Ignition engine.                                     +++++
%c ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%c
elseif dg
%c +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%c +++ Beginning of emission data for Direct Injected Stratified Charge SI +++++
%c +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%c
%c +++ Bore & stroke dimensions, and speed & load conditions for which
%c +++ simulations were performed. Must be listed from smallest to largest.
%c
%	data (boresdg(i),i=1,bptsdg)/
%     & 6.827, 7.834, 8.841, 9.848/
boresdg=[6.827, 7.834, 8.841, 9.848];
%c
%	data (stksdg(i),i=1,stptsdg)/
%     & 6.827, 7.834, 8.841, 9.848/
stksdg=[6.827, 7.834, 8.841, 9.848];
%c
%	data (rpmsdg(i),i=1,rpmptdg)/
%     & 1200, 1800, 2400, 3000/
rpmsdg=[1200, 1800, 2400, 3000];
%c
%	data (lddg(i),i=1,ldptsdg)/
%     & .4, .6, .8, 1.0/
lddg=[.4, .6, .8, 1.0];
%c
%c +++ Emission data for (bore,stroke) = (1,1); Bore = 6.827; Stroke = 6.827
%c +++ Line 1 = gas(ppm); 2=CO; 3=NO; 4=ISFC; 5=Ind Torque (N-M)
%c
%	data (((scldg(1,1,ld,irpm,ival),ld=1,ldptsdg),irpm=1,rpmptdg),
%     & ival=1,ivalsdg)/
scldg(1,1,1:ldptsdg,1:rpmptdg,1) = [1.000,1.000,1.000,1.000 ; 1.000,1.000,1.000,1.000 ; 1.000,1.000,1.000,1.000 ; 1.000,1.000,1.000,1.000]';
scldg(1,1,1:ldptsdg,1:rpmptdg,2) = [1.000,1.000,1.000,1.000 ; 1.000,1.000,1.000,1.000 ; 1.000,1.000,1.000,1.000 ; 1.000,1.000,1.000,1.000]';
scldg(1,1,1:ldptsdg,1:rpmptdg,3) = [1.000,1.000,1.000,1.000 ; 1.000,1.000,1.000,1.000 ; 1.000,1.000,1.000,1.000 ; 1.000,1.000,1.000,1.000]';
scldg(1,1,1:ldptsdg,1:rpmptdg,4) = [1.000,1.000,1.000,1.000 ; 1.000,1.000,1.000,1.000 ; 1.000,1.000,1.000,1.000 ; 1.000,1.000,1.000,1.000]';
scldg(1,1,1:ldptsdg,1:rpmptdg,5) = [7.443,9.698,11.586,12.691 ; 6.868,7.871,9.422,10.700 ; 6.401,7.061,7.957,8.898 ; 6.077,6.519,7.105,8.119]';
%c
%c +++ Emission data for (bore,stroke) = (1,2); Bore = 6.827; Stroke = 7.834
%c +++ Line 1 = gas(ppm); 2=CO; 3=NO; 4=ISFC; 5=Ind Torque (N-M)
%c
%	data (((scldg(1,2,ld,irpm,ival),ld=1,ldptsdg),irpm=1,rpmptdg),
%ival=1,ivalsdg)/
scldg(1,2,1:ldptsdg,1:rpmptdg,1) = [1.132,1.110,0.942,0.982 ; 0.824,0.826,0.959,1.007 ; 0.748,1.056,1.012,1.021 ; 0.818,0.981,0.971,1.025]';
scldg(1,2,1:ldptsdg,1:rpmptdg,2) = [0.844,0.770,0.873,0.899 ; 1.025,1.070,1.021,1.044 ; 1.295,1.021,0.899,0.984 ; 1.147,1.140,1.094,0.984]';
scldg(1,2,1:ldptsdg,1:rpmptdg,3) = [0.980,0.970,1.025,1.010 ; 1.056,1.100,1.025,0.997 ; 1.138,0.958,0.990,0.982 ; 1.131,1.015,1.032,0.974]';
scldg(1,2,1:ldptsdg,1:rpmptdg,4) = [1.015,1.089,1.055,1.024 ; 0.929,0.938,0.993,1.006 ; 0.902,0.960,0.962,0.999 ; 0.920,0.891,0.910,1.004]';
scldg(1,2,1:ldptsdg,1:rpmptdg,5) = [8.418,10.216,12.603,14.217 ; 8.480,9.628,10.893,12.207 ; 8.143,8.438,9.492,10.223 ; 7.586,8.390,8.965,9.282]';
%c
%c +++ Emission data for (bore,stroke) = (1,3); Bore = 6.827; Stroke = 8.841
%c +++ Line 1 = gas(ppm); 2=CO; 3=NO; 4=ISFC; 5=Ind Torque (N-M)
%c
%	data (((scldg(1,3,ld,irpm,ival),ld=1,ldptsdg),irpm=1,rpmptdg),
%ival=1,ivalsdg)/
scldg(1,3,1:ldptsdg,1:rpmptdg,1) = [0.945,1.139,0.988,1.019 ; 0.493,0.813,1.057,1.060 ; 0.399,0.762,0.976,1.025 ; 0.470,0.764,0.873,0.993]';
scldg(1,3,1:ldptsdg,1:rpmptdg,2) = [0.738,0.694,0.725,0.838 ; 1.607,1.208,0.817,0.767 ; 2.138,1.595,1.140,0.946 ; 2.066,2.108,1.362,0.981]';
scldg(1,3,1:ldptsdg,1:rpmptdg,3) = [1.010,0.961,1.007,0.988 ; 1.165,1.109,0.966,0.958 ; 1.329,1.170,1.018,0.976 ; 1.382,1.209,1.130,1.009]';
scldg(1,3,1:ldptsdg,1:rpmptdg,4) = [0.946,1.088,1.085,1.054 ; 0.827,0.875,0.961,1.020 ; 0.770,0.788,0.857,0.935 ; 0.758,0.765,0.820,0.902]';
scldg(1,3,1:ldptsdg,1:rpmptdg,5) = [10.194,11.543,13.820,15.594 ; 10.754,11.642,12.696,13.587 ; 10.761,11.599,12.016,12.327 ; 10.380,11.027,11.224,11.653]';
%c
%c +++ Emission data for (bore,stroke) = (1,4); Bore = 6.827; Stroke = 9.848
%c +++ Line 1 = gas(ppm); 2=CO; 3=NO; 4=ISFC; 5=Ind Torque (N-M)
%c
%	data (((scldg(1,4,ld,irpm,ival),ld=1,ldptsdg),irpm=1,rpmptdg),
%ival=1,ivalsdg)]';
scldg(1,4,1:ldptsdg,1:rpmptdg,1) = [0.566,1.027,0.993,0.993 ; 0.258,0.672,0.918,1.029 ; 0.239,0.607,0.828,0.970 ; 0.242,0.648,0.847,0.940]';
scldg(1,4,1:ldptsdg,1:rpmptdg,2) = [0.869,0.624,0.663,0.817 ; 1.026,1.376,1.105,0.987 ; 1.231,1.562,1.075,0.899 ; 1.066,1.728,1.193,0.862]';
scldg(1,4,1:ldptsdg,1:rpmptdg,3) = [1.076,0.992,1.005,1.004 ; 1.242,1.190,1.050,0.979 ; 1.419,1.283,1.143,1.031 ; 1.546,1.312,1.159,1.069]';
scldg(1,4,1:ldptsdg,1:rpmptdg,4) = [0.883,1.020,1.059,1.022 ; 0.770,0.836,0.901,0.962 ; 0.719,0.740,0.801,0.894 ; 0.690,0.714,0.766,0.881]';
scldg(1,4,1:ldptsdg,1:rpmptdg,5) = [12.169,13.711,15.775,17.901 ; 12.876,13.576,15.088,16.050 ; 12.846,13.761,14.330,14.353 ; 12.713,13.154,13.375,13.289]';
%c
%c +++ Emission data for (bore,stroke) = (2,1); Bore = 7.834; Stroke = 6.827
%c +++ Line 1 = gas(ppm); 2=CO; 3=NO; 4=ISFC; 5=Ind Torque (N-M)
%c
%	data (((scldg(2,1,ld,irpm,ival),ld=1,ldptsdg),irpm=1,rpmptdg),
%ival=1,ivalsdg)]';
scldg(2,1,1:ldptsdg,1:rpmptdg,1) = [1.150,1.180,1.163,1.127 ; 1.302,1.033,1.082,1.026 ; 1.171,1.147,1.064,0.983 ; 1.057,1.102,1.078,1.011]';
scldg(2,1,1:ldptsdg,1:rpmptdg,2) = [0.957,0.835,0.783,0.683 ; 0.692,0.865,0.685,0.660 ; 0.596,0.611,0.598,0.689 ; 0.538,0.508,0.626,0.657]';
scldg(2,1,1:ldptsdg,1:rpmptdg,3) = [0.975,0.950,0.934,0.931 ; 0.900,0.981,0.959,0.983 ; 0.907,0.895,0.948,1.017 ; 0.959,0.907,0.920,0.988]';
scldg(2,1,1:ldptsdg,1:rpmptdg,4) = [1.010,1.010,1.050,1.041 ; 1.092,1.048,1.030,0.954 ; 1.091,1.102,1.051,0.921 ; 1.048,1.079,1.028,0.968]';
scldg(2,1,1:ldptsdg,1:rpmptdg,5) = [9.701,12.642,14.524,16.052 ; 8.281,9.883,12.050,14.767 ; 7.724,8.436,9.966,12.714 ; 7.636,7.949,9.100,11.043]';
%c
%c +++ Emission data for (bore,stroke) = (2,2); Bore = 7.834; Stroke = 7.834
%c +++ Line 1 = gas(ppm); 2=CO; 3=NO; 4=ISFC; 5=Ind Torque (N-M)
%c
%	data (((scldg(2,2,ld,irpm,ival),ld=1,ldptsdg),irpm=1,rpmptdg),
%ival=1,ivalsdg)]';
scldg(2,2,1:ldptsdg,1:rpmptdg,1) = [1.156,1.134,1.022,1.008 ; 1.042,0.995,1.031,1.006 ; 1.061,1.022,1.030,0.977 ; 1.092,1.022,1.002,1.004]';
scldg(2,2,1:ldptsdg,1:rpmptdg,2) = [0.914,0.749,0.882,0.877 ; 0.816,0.901,0.827,0.769 ; 0.771,0.851,0.699,0.787 ; 0.592,0.745,0.696,0.733]';
scldg(2,2,1:ldptsdg,1:rpmptdg,3) = [0.974,0.963,0.991,0.995 ; 0.985,1.001,0.983,1.010 ; 0.967,0.983,0.976,1.025 ; 0.934,0.978,0.998,0.998]';
scldg(2,2,1:ldptsdg,1:rpmptdg,4) = [1.030,1.073,1.048,0.978 ; 1.017,1.000,1.000,0.988 ; 1.077,1.040,1.028,0.978 ; 1.100,1.063,0.989,1.011]';
scldg(2,2,1:ldptsdg,1:rpmptdg,5) = [10.922,13.658,16.709,19.607 ; 10.204,11.885,14.238,16.363 ; 8.980,10.259,11.698,13.739 ; 8.348,9.266,10.853,12.138]';
%c
%c +++ Emission data for (bore,stroke) = (2,3); Bore = 7.834; Stroke = 8.841
%c +++ Line 1 = gas(ppm); 2=CO; 3=NO; 4=ISFC; 5=Ind Torque (N-M)
%c
%	data (((scldg(2,3,ld,irpm,ival),ld=1,ldptsdg),irpm=1,rpmptdg),
%ival=1,ivalsdg)/
scldg(2,3,1:ldptsdg,1:rpmptdg,1) = [1.239,1.111,1.041,1.011 ; 0.889,1.001,1.079,0.859 ; 0.785,1.035,1.043,0.722 ; 0.721,0.961,0.975,0.678]';
scldg(2,3,1:ldptsdg,1:rpmptdg,2) = [0.730,0.812,0.783,0.921 ; 0.954,0.812,0.692,1.261 ; 1.408,0.932,0.619,2.405 ; 1.197,1.013,0.867,3.899]';
scldg(2,3,1:ldptsdg,1:rpmptdg,3) = [0.961,0.970,0.984,0.992 ; 1.035,1.000,0.954,1.099 ; 1.118,0.976,0.964,1.268 ; 1.202,1.034,1.027,1.352]';
scldg(2,3,1:ldptsdg,1:rpmptdg,4) = [1.026,1.072,1.107,1.050 ; 0.935,0.983,1.062,0.885 ; 0.902,0.924,1.001,0.736 ; 0.877,0.880,0.915,0.672]';
scldg(2,3,1:ldptsdg,1:rpmptdg,5) = [12.370,15.429,17.855,20.609 ; 12.539,13.645,15.132,20.609 ; 12.097,13.019,13.560,20.609 ; 11.828,12.633,13.245,20.609]';
%c
%c +++ Emission data for (bore,stroke) = (2,4); Bore = 7.834; Stroke = 9.848
%c +++ Line 1 = gas(ppm); 2=CO; 3=NO; 4=ISFC; 5=Ind Torque (N-M)
%c
%	data (((scldg(2,4,ld,irpm,ival),ld=1,ldptsdg),irpm=1,rpmptdg),
%ival=1,ivalsdg)/
scldg(2,4,1:ldptsdg,1:rpmptdg,1) = [1.131,1.184,1.072,1.026 ; 0.682,0.930,1.096,1.100 ; 0.530,0.862,0.953,1.081 ; 0.503,0.829,0.920,1.022]';
scldg(2,4,1:ldptsdg,1:rpmptdg,2) = [0.733,0.692,0.704,0.886 ; 1.374,0.897,0.734,0.668 ; 1.841,1.263,0.873,0.683 ; 1.841,1.590,1.065,0.728]';
scldg(2,4,1:ldptsdg,1:rpmptdg,3) = [0.980,0.951,0.972,0.984 ; 1.103,1.040,0.944,0.930 ; 1.257,1.098,1.038,0.924 ; 1.358,1.150,1.084,0.978]';
scldg(2,4,1:ldptsdg,1:rpmptdg,4) = [0.980,1.091,1.127,1.053 ; 0.877,0.929,0.980,1.065 ; 0.815,0.844,0.918,1.025 ; 0.785,0.810,0.875,1.006]';
scldg(2,4,1:ldptsdg,1:rpmptdg,5) = [14.422,16.888,19.522,22.899 ; 14.884,16.097,18.270,19.076 ; 14.913,15.888,16.454,16.492 ; 14.713,15.282,15.422,15.326]';
%c
%c +++ Emission data for (bore,stroke) = (3,1); Bore = 8.841; Stroke = 6.827
%c +++ Line 1 = gas(ppm); 2=CO; 3=NO; 4=ISFC; 5=Ind Torque (N-M)
%c
%	data (((scldg(3,1,ld,irpm,ival),ld=1,ldptsdg),irpm=1,rpmptdg),
%ival=1,ivalsdg)/
scldg(3,1,1:ldptsdg,1:rpmptdg,1) = [1.438,1.575,1.326,1.236 ; 1.431,1.213,1.190,1.106 ; 1.120,1.294,1.155,1.026 ; 1.033,1.198,1.149,1.090]';
scldg(3,1,1:ldptsdg,1:rpmptdg,2) = [0.790,0.648,0.625,0.605 ; 0.500,0.543,0.534,0.500 ; 0.265,0.366,0.309,0.497 ; 0.150,0.213,0.211,0.335]';
scldg(3,1,1:ldptsdg,1:rpmptdg,3) = [0.927,0.843,0.864,0.874 ; 0.859,0.876,0.886,0.926 ; 0.935,0.790,0.870,0.977 ; 0.977,0.822,0.848,0.903]';
scldg(3,1,1:ldptsdg,1:rpmptdg,4) = [1.029,1.106,1.159,1.134 ; 1.114,1.143,1.072,0.975 ; 1.101,1.184,1.075,0.940 ; 1.095,1.153,1.125,1.059]';
scldg(3,1,1:ldptsdg,1:rpmptdg,5) = [12.140,14.700,16.773,18.758 ; 10.343,11.543,14.734,18.392 ; 9.748,9.995,12.409,15.871 ; 9.304,9.478,10.588,12.847]';
%c
%c +++ Emission data for (bore,stroke) = (3,2); Bore = 8.841; Stroke = 7.834
%c +++ Line 1 = gas(ppm); 2=CO; 3=NO; 4=ISFC; 5=Ind Torque (N-M)
%c
%	data (((scldg(3,2,ld,irpm,ival),ld=1,ldptsdg),irpm=1,rpmptdg),
%ival=1,ivalsdg)/
scldg(3,2,1:ldptsdg,1:rpmptdg,1) = [1.269,1.230,1.093,1.105 ; 1.268,1.090,1.104,1.011 ; 1.275,1.164,1.053,0.945 ; 1.251,1.114,1.040,0.978]';
scldg(3,2,1:ldptsdg,1:rpmptdg,2) = [0.817,0.831,0.812,0.677 ; 0.624,0.730,0.553,0.531 ; 0.474,0.487,0.442,0.593 ; 0.286,0.405,0.455,0.527]';
scldg(3,2,1:ldptsdg,1:rpmptdg,3) = [0.957,0.938,0.962,0.944 ; 0.910,0.948,0.946,0.994 ; 0.851,0.883,0.955,1.054 ; 0.822,0.897,0.960,1.027]';
scldg(3,2,1:ldptsdg,1:rpmptdg,4) = [1.030,1.025,1.089,1.055 ; 1.087,1.088,1.056,0.939 ; 1.169,1.145,1.031,0.910 ; 1.235,1.144,1.030,0.963]';
scldg(3,2,1:ldptsdg,1:rpmptdg,5) = [13.906,18.191,20.481,23.146 ; 12.161,13.918,17.172,21.918 ; 10.539,11.863,14.844,18.820 ; 9.466,10.962,13.271,16.220]';
%c
%c +++ Emission data for (bore,stroke) = (3,3); Bore = 8.841; Stroke = 8.841
%c +++ Line 1 = gas(ppm); 2=CO; 3=NO; 4=ISFC; 5=Ind Torque (N-M)
%c
%	data (((scldg(3,3,ld,irpm,ival),ld=1,ldptsdg),irpm=1,rpmptdg),
%ival=1,ivalsdg)/
scldg(3,3,1:ldptsdg,1:rpmptdg,1) = [1.253,1.256,1.094,1.079 ; 1.261,1.109,1.154,1.091 ; 1.125,1.096,1.071,1.033 ; 0.981,1.020,1.023,1.034]';
scldg(3,3,1:ldptsdg,1:rpmptdg,2) = [0.849,0.750,0.798,0.830 ; 0.642,0.663,0.610,0.627 ; 0.649,0.567,0.530,0.645 ; 0.590,0.590,0.518,0.612]';
scldg(3,3,1:ldptsdg,1:rpmptdg,3) = [0.958,0.931,0.962,0.958 ; 0.915,0.936,0.908,0.940 ; 0.933,0.930,0.940,0.968 ; 1.015,0.980,0.979,0.965]';
scldg(3,3,1:ldptsdg,1:rpmptdg,4) = [1.046,1.114,1.110,1.082 ; 1.065,1.079,1.094,1.077 ; 1.058,1.066,1.058,1.032 ; 1.004,0.998,0.988,1.039]';
scldg(3,3,1:ldptsdg,1:rpmptdg,5) = [15.454,18.894,22.665,25.477 ; 13.994,15.841,18.705,21.571 ; 13.135,14.372,16.329,18.725 ; 13.140,14.173,15.610,16.964]';
%c
%c +++ Emission data for (bore,stroke) = (3,4); Bore = 8.841; Stroke = 9.848
%c +++ Line 1 = gas(ppm); 2=CO; 3=NO; 4=ISFC; 5=Ind Torque (N-M)
%c
%	data (((scldg(3,4,ld,irpm,ival),ld=1,ldptsdg),irpm=1,rpmptdg),
%ival=1,ivalsdg)/
scldg(3,4,1:ldptsdg,1:rpmptdg,1) = [1.299,1.236,1.076,1.048 ; 1.082,1.065,1.135,1.174 ; 0.911,1.063,1.037,1.078 ; 0.778,0.943,1.005,1.034]';
scldg(3,4,1:ldptsdg,1:rpmptdg,2) = [0.753,0.685,0.762,0.831 ; 0.785,0.674,0.583,0.527 ; 0.880,0.714,0.541,0.531 ; 0.818,0.818,0.659,0.702]';
scldg(3,4,1:ldptsdg,1:rpmptdg,3) = [0.950,0.937,0.970,0.975 ; 0.972,0.961,0.921,0.880 ; 1.049,0.956,0.970,0.927 ; 1.159,1.049,0.996,0.963]';
scldg(3,4,1:ldptsdg,1:rpmptdg,4) = [1.041,1.115,1.096,1.079 ; 0.992,1.009,1.106,1.153 ; 0.966,0.946,1.022,1.104 ; 0.906,0.921,0.953,1.042]';
scldg(3,4,1:ldptsdg,1:rpmptdg,5) = [17.297,21.026,25.577,28.442 ; 16.759,18.860,20.600,22.450 ; 16.042,18.043,18.830,19.493 ; 16.235,17.123,18.024,18.852]';
%c
%c +++ Emission data for (bore,stroke) = (4,1); Bore = 9.848; Stroke = 6.827
%c +++ Line 1 = gas(ppm); 2=CO; 3=NO; 4=ISFC; 5=Ind Torque (N-M)
%c
%	data (((scldg(4,1,ld,irpm,ival),ld=1,ldptsdg),irpm=1,rpmptdg),
%ival=1,ivalsdg)/
scldg(4,1,1:ldptsdg,1:rpmptdg,1) = [1.838,1.700,1.505,1.299 ; 1.552,1.360,1.345,1.315 ; 1.139,1.378,1.225,1.113 ; 1.160,1.233,1.202,1.166]';
scldg(4,1,1:ldptsdg,1:rpmptdg,2) = [0.690,0.508,0.457,0.519 ; 0.296,0.396,0.350,0.401 ; 0.159,0.191,0.136,0.302 ; 0.038,0.060,0.096,0.135]';
scldg(4,1,1:ldptsdg,1:rpmptdg,3) = [0.860,0.810,0.790,0.839 ; 0.819,0.789,0.794,0.780 ; 0.927,0.730,0.812,0.892 ; 0.885,0.791,0.794,0.820]';
scldg(4,1,1:ldptsdg,1:rpmptdg,4) = [1.089,1.206,1.257,1.187 ; 1.154,1.236,1.201,1.256 ; 1.142,1.259,1.197,1.072 ; 1.225,1.189,1.181,1.198]';
scldg(4,1,1:ldptsdg,1:rpmptdg,5) = [14.220,16.730,19.180,22.242 ; 12.383,13.246,16.322,17.725 ; 11.666,11.663,13.835,17.274 ; 10.326,11.406,12.525,14.100]';
%c
%c +++ Emission data for (bore,stroke) = (4,2); Bore = 9.848; Stroke = 7.834
%c +++ Line 1 = gas(ppm); 2=CO; 3=NO; 4=ISFC; 5=Ind Torque (N-M)
%c
%    data (((scldg(4,2,ld,irpm,ival),ld=1,ldptsdg),irpm=1,rpmptdg),
%ival=1,ivalsdg)/
scldg(4,2,1:ldptsdg,1:rpmptdg,1) = [1.732,1.545,1.313,1.135 ; 1.486,1.228,1.180,1.035 ; 1.345,1.273,1.151,0.999 ; 1.263,1.173,1.122,1.066]';
scldg(4,2,1:ldptsdg,1:rpmptdg,2) = [0.747,0.615,0.498,0.556 ; 0.423,0.473,0.440,0.455 ; 0.290,0.306,0.286,0.428 ; 0.078,0.178,0.191,0.274]';
scldg(4,2,1:ldptsdg,1:rpmptdg,3) = [0.878,0.852,0.871,0.927 ; 0.842,0.866,0.894,0.978 ; 0.811,0.804,0.873,1.004 ; 0.812,0.846,0.876,0.930]';
scldg(4,2,1:ldptsdg,1:rpmptdg,4) = [1.095,1.106,1.155,1.032 ; 1.162,1.153,1.086,0.926 ; 1.223,1.200,1.084,0.959 ; 1.285,1.188,1.137,1.065]';
scldg(4,2,1:ldptsdg,1:rpmptdg,5) = [16.240,20.940,23.953,29.358 ; 14.113,16.288,20.723,27.575 ; 12.504,14.045,17.528,22.157 ; 11.292,13.093,14.923,18.202]';
%c
%c +++ Emission data for (bore,stroke) = (4,3); Bore = 9.848; Stroke = 8.841
%c +++ Line 1 = gas(ppm); 2=CO; 3=NO; 4=ISFC; 5=Ind Torque (N-M)
%c
%	data (((scldg(4,3,ld,irpm,ival),ld=1,ldptsdg),irpm=1,rpmptdg),
%ival=1,ivalsdg)/
scldg(4,3,1:ldptsdg,1:rpmptdg,1) = [1.431,1.393,1.169,1.129 ; 1.540,1.125,1.188,1.124 ; 1.252,1.139,1.082,1.035 ; 1.068,1.108,1.062,1.027]';
scldg(4,3,1:ldptsdg,1:rpmptdg,2) = [0.740,0.702,0.682,0.646 ; 0.514,0.581,0.484,0.431 ; 0.444,0.413,0.390,0.506 ; 0.257,0.338,0.378,0.463]';
scldg(4,3,1:ldptsdg,1:rpmptdg,3) = [0.930,0.894,0.930,0.930 ; 0.824,0.928,0.888,0.914 ; 0.864,0.901,0.933,0.969 ; 0.953,0.904,0.939,0.970]';
scldg(4,3,1:ldptsdg,1:rpmptdg,4) = [1.061,1.124,1.135,1.080 ; 1.176,1.144,1.154,1.107 ; 1.143,1.139,1.105,1.035 ; 1.084,1.062,1.035,1.034]';
scldg(4,3,1:ldptsdg,1:rpmptdg,5) = [18.913,23.239,27.522,31.651 ; 15.744,18.538,22.000,26.032 ; 15.102,16.698,19.410,23.153 ; 15.115,16.528,18.501,21.153]';
%c
%c +++ Emission data for (bore,stroke) = (4,4); Bore = 9.848; Stroke = 9.848
%c +++ Line 1 = gas(ppm); 2=CO; 3=NO; 4=ISFC; 5=Ind Torque (N-M)
%c
%	data (((scldg(4,4,ld,irpm,ival),ld=1,ldptsdg),irpm=1,rpmptdg),
%ival=1,ivalsdg)/
scldg(4,4,1:ldptsdg,1:rpmptdg,1) = [1.454,1.358,1.184,1.116 ; 1.285,1.104,1.144,1.138 ; 1.059,1.101,1.068,1.043 ; 0.907,1.030,1.008,1.038]';
scldg(4,4,1:ldptsdg,1:rpmptdg,2) = [0.666,0.655,0.668,0.775 ; 0.571,0.593,0.554,0.523 ; 0.501,0.508,0.467,0.558 ; 0.321,0.405,0.441,0.523]';
scldg(4,4,1:ldptsdg,1:rpmptdg,3) = [0.925,0.904,0.924,0.938 ; 0.906,0.940,0.914,0.905 ; 0.968,0.927,0.944,0.961 ; 1.067,0.972,0.992,0.959]';
scldg(4,4,1:ldptsdg,1:rpmptdg,4) = [1.077,1.148,1.144,1.133 ; 1.071,1.118,1.133,1.139 ; 1.051,1.085,1.075,1.071 ; 0.999,1.002,0.999,1.059]';
scldg(4,4,1:ldptsdg,1:rpmptdg,5) = [20.742,25.360,30.398,33.624 ; 19.253,21.139,24.958,28.184 ; 18.271,19.521,22.216,24.940 ; 18.264,19.514,21.357,23.014]';
%c
%c +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%c +++ End of emission data for Direct Injected Stratified Charge SI +++++
%c +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%c
elseif pg
%c +++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%c +++ Beginning of emission data for Port Injected SI +++++
%c +++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%c
%c +++ Bore & stroke dimensions, and speed & load conditions for which
%c +++ simulations were performed. Must be listed from smallest to largest.
%c
%	data (borespg(i),i=1,bptspg)/
%     & 6.67, 8.20, 9.73/
borespg=[6.67 8.20 9.73];
%c
%	data (stkspg(i),i=1,stptspg)/
%     & 7.16, 8.80, 10.44/
stkspg=[7.16, 8.80, 10.44];
%c
%	data (rpmspg(i),i=1,rpmptpg)/
%     & 600, 700, 800, 900, 1000, 1100, 1200, 1300, 1400, 1500, 1600,
%     & 1700, 1800, 1900, 2000, 2100, 2200, 2300, 2400, 2500, 2600,
%     & 2700, 2800, 2900, 3000, 3100, 3200, 3300, 3400, 3500, 3600,
%     & 3700, 3800, 3900, 4000, 4100, 4200, 4300, 4400, 4500, 4600,
%     & 4700, 4800, 4900, 5000, 5100, 5200/
rpmspg=[600, 700, 800, 900, 1000, 1100, 1200, 1300, 1400, 1500, 1600,...
     1700, 1800, 1900, 2000, 2100, 2200, 2300, 2400, 2500, 2600,...
     2700, 2800, 2900, 3000, 3100, 3200, 3300, 3400, 3500, 3600,...
     3700, 3800, 3900, 4000, 4100, 4200, 4300, 4400, 4500, 4600,...
     4700, 4800, 4900, 5000, 5100, 5200];
%c
%	data (ldpg(i),i=1,ldptspg)/
%     & 25.0, 30.0, 35.0, 40.0, 45.0, 50.0, 55.0, 60.0, 65.0, 70.0,
%     & 75.0, 80.0, 85.0, 90.0, 95.0, 100.0/
ldpg=[25.0, 30.0, 35.0, 40.0, 45.0, 50.0, 55.0, 60.0, 65.0, 70.0,...
      75.0, 80.0, 85.0, 90.0, 95.0, 100.0];
%c
%c +++ HC Scalar Data +++
%c
%c +++ HC data for (bore,stroke) = (1,1); Bore = 6.67; Stroke = 7.16
%c
	sclpg(1,1,1:ldptspg,1:rpmptpg,1)=...
	 [0.093,1.518,1.565,1.670,1.880,1.841,2.116,1.786,1.392,1.366, 1.761,2.151,1.964,1.833,1.571,1.711,
     0.749,1.872,2.070,1.914,2.175,2.179,1.886,1.446,1.237,1.718,2.022,2.052,2.306,2.301,2.165,2.058,
     2.521,2.351,2.542,2.288,2.543,2.395,2.008,1.750,1.399,2.249,2.608,2.171,2.544,2.055,1.985,1.845,
     2.488,2.092,2.137,2.272,2.457,2.250,1.877,1.318,1.363,1.651,2.207,2.270,2.486,2.442,2.136,2.106,
     2.075,2.386,1.856,1.768,1.607,1.627,1.173,1.180,1.432,1.845,2.554,3.010,3.443,3.772,5.064,7.330,
     -1.000,10.086,7.080,3.431,3.000,2.646,2.573,2.638,3.037,3.327,3.527,4.097,6.936,12.048,21.177,19.155,
     -1.000,14.058,55.883,42.564,20.652,19.751,10.298,11.060,6.860,20.049,18.293,33.856,9.922,6.418,3.780,2.334,
     -1.000,3.433,4.916,7.088,2.898,3.793,3.965,4.256,4.547,4.418,3.801,3.462,2.841,1.983,1.607,1.826,
     -1.000,1.826,1.240,1.822,1.451,1.934,1.446,2.362,2.414,2.419,2.272,2.059,1.679,1.222,1.145,0.796,
     -1.000,0.942,1.432,1.822,1.468,1.837,1.909,1.857,1.954,2.404,2.091,1.865,1.813,1.477,1.071,0.801,
     -1.000,0.933,1.441,1.438,1.301,1.589,1.313,1.817,1.999,1.860,2.144,1.540,1.458,1.164,0.968,0.754,
     -1.000,0.983,0.932,1.432,1.727,1.757,1.764,2.018,1.257,2.058,1.728,1.053,1.202,0.598,0.598,0.393,
     -1.000,-1.000,0.411,0.514,0.600,0.578,0.616,0.588,0.868,1.438,1.263,1.011,0.575,0.361,0.405,0.257,
     -1.000,-1.000,0.304,0.609,0.803,0.743,0.914,0.844,1.298,0.888,0.748,0.829,0.503,0.436,0.254,0.023,
     -1.000,-1.000,0.104,0.146,0.194,0.225,0.340,0.416,0.518,0.543,0.726,0.358,0.240,0.093,0.018,0.355,
     -1.000,-1.000,0.126,0.089,0.123,0.155,0.078,0.299,0.361,0.189,0.231,0.317,0.213,0.032,0.167,0.184,
     -1.000,-1.000,0.072,0.145,0.090,0.147,0.158,0.221,0.417,0.445,0.169,0.072,0.017,0.092,0.117,0.132,
     -1.000,-1.000,-1.000,0.147,0.137,0.035,0.086,0.150,0.543,0.340,0.127,0.079,0.212,0.525,0.511,0.705,
     -1.000,-1.000,-1.000,0.617,0.135,0.091,0.416,0.356,0.028,0.270,0.317,0.416,0.414,0.743,0.817,0.959,
     -1.000,-1.000,-1.000,1.248,0.677,0.731,0.666,0.891,0.451,0.563,0.651,0.595,0.803,1.095,1.417,1.740,
     -1.000,-1.000,-1.000,1.444,1.033,1.063,0.674,0.674,0.787,0.676,0.945,0.999,0.933,0.798,1.317,1.472,
     -1.000,-1.000,-1.000,1.500,0.981,1.120,1.006,0.685,0.994,0.698,0.804,1.038,1.161,1.523,1.000,1.581,
     -1.000,-1.000,-1.000,1.497,1.047,1.132,1.231,1.125,1.066,1.242,1.108,1.087,1.394,1.566,1.393,1.548,
     -1.000,-1.000,-1.000,-1.000,1.367,1.203,0.789,0.816,0.782,0.693,0.929,1.454,1.483,1.191,1.675,1.688,
     -1.000,-1.000,-1.000,-1.000,1.522,1.243,0.971,1.013,1.005,0.917,0.819,1.203,1.493,1.594,1.102,1.355,
     -1.000,-1.000,-1.000,-1.000,1.359,0.898,0.804,0.734,0.732,0.753,0.810,0.771,1.152,1.565,1.445,1.099,
     -1.000,-1.000,-1.000,-1.000,1.147,0.838,0.552,0.611,0.616,0.649,0.809,0.897,0.925,0.984,1.178,1.228,
     -1.000,-1.000,-1.000,-1.000,0.873,0.742,0.871,0.710,0.623,0.615,0.628,0.676,0.780,0.834,0.861,0.775,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.616,0.540,0.432,0.542,0.612,0.516,0.558,0.543,0.563,0.549,0.593,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.606,0.355,0.358,0.315,0.343,0.425,0.404,0.400,0.435,0.360,0.363,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.269,0.258,0.267,0.236,0.273,0.275,0.280,0.256,0.346,0.307,0.379,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.352,0.296,0.291,0.278,0.261,0.236,0.276,0.280,0.315,0.337,0.323,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.352,0.322,0.313,0.262,0.333,0.305,0.259,0.306,0.314,0.312,0.244,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.327,0.304,0.317,0.277,0.288,0.283,0.293,0.353,0.337,0.405,0.334,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.409,0.365,0.353,0.329,0.355,0.448,0.331,0.393,0.405,0.453,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.478,0.469,0.444,0.441,0.421,0.487,0.517,0.369,0.500,0.488,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.539,0.508,0.490,0.557,0.457,0.578,0.579,0.489,0.580,0.635,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.650,0.569,0.593,0.552,0.555,0.630,0.542,0.626,0.590,0.642,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.692,0.664,0.599,0.575,0.568,0.548,0.689,0.693,0.580,0.582,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.748,0.702,0.657,0.631,0.629,0.734,0.577,0.704,0.732,0.606,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.745,0.694,0.751,0.678,0.728,0.769,0.792,0.686,0.805,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.815,0.794,0.737,0.761,0.744,0.781,0.665,0.789,0.795,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.830,0.811,0.836,0.807,0.741,0.774,0.825,0.730,0.750,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.902,0.863,0.908,0.884,0.816,0.830,0.793,0.798,0.817,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.975,0.956,0.970,0.893,0.934,0.860,0.957,0.886,0.861,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.025,0.990,0.961,0.927,0.915,0.970,0.928,0.977,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.048,1.047,0.987,0.883,0.840,1.030,0.916,-1.000]';
     
%c
%c +++ HC data for (bore,stroke) = (1,2); Bore = 6.67; Stroke = 8.80
%c
     sclpg(1,2,1:ldptspg,1:rpmptpg,1)=...
     [0.068,1.252,1.370,1.229,1.257,1.570,1.782,1.469,1.187,1.435,1.683,1.864,1.658,1.638,1.702,1.650,
     0.700,1.628,1.759,1.793,1.962,2.029,1.753,1.335,1.461,1.885,2.014,2.023,2.152,2.155,2.154,2.127,
     2.631,2.000,2.077,2.056,2.214,1.917,1.708,1.630,1.455,2.107,2.220,1.773,2.173,1.715,1.660,1.690,
     1.945,1.564,1.793,1.851,1.809,1.735,1.586,1.390,1.466,1.608,2.061,2.050,2.042,1.890,1.656,1.526,
     1.739,1.749,1.712,1.538,1.394,1.518,1.046,1.189,1.388,1.606,1.835,2.107,2.347,2.502,3.281,4.581,
     -1.000,6.075,3.471,2.369,2.284,2.031,2.341,2.406,2.451,2.259,2.310,2.689,4.520,7.870,13.896,13.354,
     -1.000,9.457,27.717,28.829,14.116,16.327,9.824,8.580,5.633,14.301,14.276,26.975,6.975,4.215,2.597,1.686,
     -1.000,2.210,3.127,4.416,2.884,4.045,4.024,3.841,3.963,3.133,2.730,1.961,1.686,1.222,1.069,1.209,
     -1.000,1.419,0.767,1.179,1.420,1.621,1.212,1.948,1.942,1.863,1.623,1.467,1.188,0.919,0.734,0.516,
     -1.000,0.655,0.740,1.115,1.032,1.385,1.206,1.178,1.227,1.411,1.285,1.117,1.046,0.750,0.511,0.440,
     -1.000,0.518,0.748,0.704,0.836,0.918,1.218,1.070,1.152,1.082,1.168,0.804,0.755,0.649,0.457,0.375,
     -1.000,0.389,0.402,0.628,1.105,1.271,1.323,1.004,0.804,1.407,1.152,0.577,0.553,0.199,0.193,0.144,
     -1.000,-1.000,0.193,0.256,0.341,0.387,0.440,0.461,0.459,0.773,0.575,0.496,0.457,0.334,0.271,0.246,
     -1.000,-1.000,0.230,0.280,0.395,0.391,0.358,0.372,0.630,0.422,0.333,0.454,0.356,0.261,0.138,0.038,
     -1.000,-1.000,0.177,0.069,0.229,0.313,0.538,0.496,0.484,0.434,0.326,0.158,0.174,0.172,0.191,0.167,
     -1.000,-1.000,0.156,0.426,0.359,0.411,0.481,0.542,0.502,0.358,0.415,0.250,0.029,0.034,0.065,0.075,
     -1.000,-1.000,0.090,0.089,0.062,0.042,0.113,0.161,0.138,0.259,0.102,0.090,0.096,0.061,0.081,0.246,
     -1.000,-1.000,-1.000,0.412,0.124,0.201,0.026,0.046,0.185,0.161,0.190,0.261,0.287,0.397,0.524,0.495,
     -1.000,-1.000,-1.000,0.505,0.306,0.315,0.357,0.131,0.074,0.216,0.226,0.344,0.435,0.866,0.852,1.125,
     -1.000,-1.000,-1.000,0.887,0.710,0.706,0.709,0.849,0.723,0.596,0.526,0.679,0.630,0.694,0.759,0.704,
     -1.000,-1.000,-1.000,0.563,0.502,0.477,0.424,0.225,0.348,0.267,0.325,0.504,0.492,0.515,0.539,0.578,
     -1.000,-1.000,-1.000,0.599,0.481,0.288,0.212,0.372,0.444,0.509,0.451,0.576,0.683,0.787,0.624,0.710,
     -1.000,-1.000,-1.000,0.663,0.322,0.100,0.032,0.017,0.095,0.110,0.112,0.267,0.305,0.262,0.252,0.258,
     -1.000,-1.000,-1.000,-1.000,0.073,0.061,0.022,0.085,0.026,0.070,0.138,0.133,0.129,0.136,0.128,0.135,
     -1.000,-1.000,-1.000,-1.000,0.059,0.020,0.026,0.029,0.018,0.013,0.013,0.016,0.015,0.015,0.014,0.014,
     -1.000,-1.000,-1.000,-1.000,0.052,0.137,0.048,0.034,0.026,0.026,0.026,0.025,0.031,0.031,0.029,0.028,
     -1.000,-1.000,-1.000,-1.000,0.029,0.039,0.033,0.032,0.032,0.039,0.040,0.033,0.040,0.042,0.041,0.040,
     -1.000,-1.000,-1.000,-1.000,0.041,0.039,0.038,0.036,0.031,0.033,0.031,0.031,0.037,0.039,0.039,0.039,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.038,0.032,0.043,0.059,0.059,0.052,0.051,0.051,0.052,0.066,0.068,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.060,0.056,0.058,0.050,0.055,0.070,0.070,0.068,0.076,0.058,0.075,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.073,0.064,0.118,0.122,0.125,0.127,0.127,0.127,0.151,0.132,0.159,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.146,0.146,0.179,0.159,0.159,0.161,0.170,0.164,0.194,0.204,0.203,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.200,0.193,0.178,0.169,0.225,0.210,0.190,0.223,0.231,0.225,0.207,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.235,0.218,0.223,0.228,0.227,0.223,0.282,0.303,0.295,0.309,0.308,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.309,0.279,0.263,0.267,0.259,0.340,0.294,0.342,0.295,0.330,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.351,0.337,0.300,0.285,0.332,0.350,0.349,0.293,0.336,0.359,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.375,0.342,0.329,0.362,0.300,0.379,0.361,0.388,0.372,0.395,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.429,0.385,0.419,0.371,0.344,0.397,0.364,0.413,0.409,0.428,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.473,0.444,0.412,0.418,0.397,0.368,0.441,0.444,0.460,0.464,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.504,0.500,0.458,0.445,0.421,0.489,0.416,0.444,0.465,0.498,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.511,0.492,0.509,0.470,0.473,0.513,0.509,0.466,0.549,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.571,0.568,0.489,0.532,0.493,0.565,0.459,0.553,0.527,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.587,0.591,0.595,0.589,0.536,0.528,0.630,0.500,0.581,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.645,0.633,0.633,0.643,0.576,0.566,0.542,0.570,0.530,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.672,0.663,0.651,0.624,0.653,0.578,0.605,0.611,0.566,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.720,0.672,0.695,0.649,0.625,0.628,0.583,0.606,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.749,0.716,0.708,0.684,0.628,0.678,0.576,-1.000]';

 %c
%c +++ HC data for (bore,stroke) = (1,3); Bore = 6.67; Stroke = 10.44
%c
     sclpg(1,3,1:ldptspg,1:rpmptpg,1)=...
     [0.001,1.107,1.192,1.128,1.072,1.175,1.321,1.297,1.209,1.277,1.360,1.430,1.270,1.261,1.360,1.378,
     0.405,1.539,1.508,1.468,1.454,1.461,1.265,1.269,1.346,1.535,1.764,1.778,1.707,1.742,1.808,1.824,
     2.379,1.944,1.858,1.832,1.728,1.925,1.933,2.033,1.631,2.221,2.203,1.550,1.854,1.491,1.474,1.412,
     3.308,1.403,1.654,1.880,2.110,1.710,1.668,1.293,1.273,1.408,1.437,1.413,1.405,1.394,1.282,1.341,
     3.916,1.443,1.322,1.361,1.710,1.826,1.371,1.473,1.581,1.819,1.971,2.089,2.112,2.276,3.101,4.606,
     -1.000,5.983,4.675,2.965,3.183,3.035,2.936,2.721,2.677,2.707,2.404,2.627,4.531,8.071,15.037,14.870,
     -1.000,9.268,34.768,31.755,20.620,20.787,12.654,10.621,5.552,15.597,13.775,24.101,7.248,4.876,2.918,1.723,
     -1.000,2.003,2.893,3.602,2.512,3.162,3.273,3.354,3.489,2.786,2.205,2.066,1.741,1.241,1.085,1.291,
     -1.000,1.306,1.150,1.231,1.461,2.533,1.903,2.331,2.496,2.246,1.946,1.502,1.224,0.919,0.857,0.635,
     -1.000,0.717,0.991,1.012,0.934,1.344,1.664,1.610,1.460,1.437,1.198,1.072,1.066,0.951,0.748,0.656,
     -1.000,0.694,1.021,1.047,1.391,1.506,1.641,1.527,1.436,1.322,1.439,1.091,1.072,0.944,0.776,0.667,
     -1.000,0.697,0.789,1.445,1.444,1.582,1.655,1.694,1.156,1.602,1.219,0.761,0.900,0.493,0.430,0.310,
     -1.000,-1.000,0.289,0.437,0.427,0.535,0.632,0.483,0.496,0.801,0.689,0.596,0.539,0.518,0.465,0.421,
     -1.000,-1.000,0.358,0.381,0.630,0.608,0.661,0.526,0.768,0.601,0.584,0.587,0.390,0.342,0.288,0.257,
     -1.000,-1.000,0.252,0.297,0.417,0.494,0.698,0.624,0.422,0.394,0.393,0.326,0.230,0.177,0.178,0.147,
     -1.000,-1.000,0.116,0.135,0.122,0.267,0.261,0.389,0.266,0.191,0.222,0.213,0.014,0.079,0.139,0.148,
     -1.000,-1.000,0.135,0.056,0.127,0.151,0.046,0.082,0.014,0.015,0.012,0.011,0.024,0.027,0.020,0.030,
     -1.000,-1.000,-1.000,0.032,0.087,0.063,0.053,0.175,0.034,0.045,0.016,0.017,0.015,0.015,0.014,0.012,
     -1.000,-1.000,-1.000,0.018,0.095,0.243,0.174,0.235,0.066,0.065,0.083,0.024,0.030,0.038,0.031,0.036,
     -1.000,-1.000,-1.000,0.037,0.060,0.206,0.230,0.348,0.394,0.322,0.274,0.285,0.275,0.291,0.287,0.263,
     -1.000,-1.000,-1.000,0.202,0.273,0.351,0.344,0.255,0.332,0.270,0.323,0.313,0.283,0.318,0.307,0.279,
     -1.000,-1.000,-1.000,0.231,0.243,0.291,0.346,0.329,0.405,0.427,0.430,0.422,0.403,0.430,0.333,0.385,
     -1.000,-1.000,-1.000,0.325,0.310,0.297,0.294,0.299,0.313,0.383,0.391,0.386,0.366,0.353,0.326,0.294,
     -1.000,-1.000,-1.000,-1.000,0.270,0.324,0.229,0.224,0.198,0.196,0.245,0.243,0.235,0.225,0.219,0.201,
     -1.000,-1.000,-1.000,-1.000,0.174,0.186,0.159,0.121,0.136,0.138,0.141,0.178,0.171,0.163,0.160,0.155,
     -1.000,-1.000,-1.000,-1.000,0.136,0.128,0.122,0.085,0.088,0.091,0.091,0.089,0.112,0.111,0.107,0.102,
     -1.000,-1.000,-1.000,-1.000,0.083,0.083,0.078,0.050,0.040,0.048,0.049,0.041,0.049,0.050,0.049,0.048,
     -1.000,-1.000,-1.000,-1.000,0.042,0.041,0.043,0.017,0.014,0.016,0.014,0.014,0.017,0.017,0.017,0.016,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.018,0.015,0.014,0.058,0.072,0.061,0.063,0.059,0.059,0.134,0.072,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.067,0.064,0.068,0.070,0.075,0.091,0.088,0.084,0.088,0.072,0.089,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.084,0.077,0.080,0.082,0.088,0.086,0.090,0.084,0.097,0.086,0.101,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.094,0.096,0.104,0.099,0.098,0.098,0.102,0.097,0.114,0.124,0.109,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.114,0.111,0.125,0.111,0.139,0.134,0.116,0.136,0.139,0.132,0.117,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.132,0.123,0.153,0.135,0.135,0.135,0.166,0.165,0.159,0.161,0.157,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.151,0.142,0.142,0.152,0.158,0.187,0.163,0.190,0.172,0.183,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.181,0.187,0.206,0.202,0.230,0.230,0.239,0.204,0.235,0.249,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.228,0.220,0.211,0.226,0.193,0.231,0.227,0.235,0.220,0.237,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.270,0.222,0.214,0.202,0.200,0.235,0.206,0.232,0.228,0.238,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.259,0.238,0.239,0.236,0.236,0.217,0.260,0.263,0.262,0.258,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.308,0.262,0.285,0.249,0.247,0.288,0.235,0.283,0.291,0.295,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.287,0.273,0.299,0.277,0.286,0.313,0.314,0.263,0.311,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.330,0.322,0.291,0.302,0.287,0.304,0.260,0.309,0.298,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.348,0.339,0.299,0.300,0.276,0.279,0.310,0.261,0.308,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.401,0.309,0.321,0.314,0.291,0.285,0.271,0.278,0.267,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.435,0.334,0.316,0.308,0.310,0.284,0.300,0.316,0.280,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.356,0.304,0.336,0.308,0.307,0.313,0.285,0.313,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.411,0.345,0.322,0.313,0.302,0.330,0.279,-1.000]';
%c
%c +++ HC data for (bore,stroke) = (2,1); Bore = 8.20; Stroke = 7.16
%c
     sclpg(2,1,1:ldptspg,1:rpmptpg,1)=...
     [1.301,1.297,1.453,1.326,1.355,1.315,1.393,1.311,1.463,1.689,1.659,1.440,1.255,1.152,1.253,1.117,
     1.269,1.468,1.604,1.544,1.539,1.569,1.310,1.115,1.248,1.472,1.469,1.423,1.433,1.203,1.170,1.092,
     1.331,1.566,1.415,1.604,1.718,1.331,1.101,1.108,0.960,1.309,1.606,1.251,1.481,1.178,1.058,0.959,
     0.868,0.895,1.025,1.262,1.119,0.971,0.886,0.766,0.951,0.946,1.119,0.751,0.721,0.691,0.597,0.580,
     0.698,0.967,0.889,0.869,0.802,0.803,0.733,0.910,0.857,1.221,1.232,1.352,1.385,1.486,1.921,2.579,
     -1.000,2.407,1.857,1.329,1.190,1.166,1.270,1.235,1.206,1.463,1.474,1.534,2.339,3.469,5.337,4.068,
     -1.000,0.923,10.501,11.855,7.087,7.766,4.959,4.217,2.523,6.713,5.192,8.850,1.512,0.760,0.254,0.128,
     -1.000,0.612,0.397,0.921,0.556,0.981,1.165,1.094,0.298,0.210,0.052,0.135,0.307,0.354,0.355,0.990,
     -1.000,0.545,0.292,0.539,0.657,0.989,0.656,0.981,0.922,0.833,0.740,0.720,0.694,0.684,0.681,0.846,
     -1.000,0.629,0.739,0.679,0.885,1.033,0.616,0.523,0.561,1.059,1.058,1.053,1.171,1.270,1.088,1.225,
     -1.000,0.951,1.184,1.075,1.065,0.848,0.705,0.758,0.804,0.894,1.097,0.882,1.087,1.154,1.324,1.478,
     -1.000,1.629,1.437,1.662,1.184,1.317,1.769,1.525,1.078,1.187,1.077,0.853,1.261,1.045,1.222,1.086,
     -1.000,-1.000,0.865,1.070,0.915,0.762,0.846,0.916,0.973,1.587,1.432,1.319,1.595,1.593,1.763,1.833,
     -1.000,-1.000,1.215,1.351,1.824,1.230,1.759,1.373,2.316,1.525,1.460,2.392,2.113,1.911,1.955,1.936,
     -1.000,-1.000,2.152,1.745,2.154,2.161,2.740,2.913,1.602,1.707,2.334,1.542,1.812,1.992,2.703,2.535,
     -1.000,-1.000,2.115,1.837,1.618,1.826,1.788,2.129,1.871,1.764,2.271,2.528,2.371,2.852,2.480,2.609,
     -1.000,-1.000,1.775,1.998,1.538,2.641,2.218,2.232,2.141,2.508,2.060,1.654,2.530,2.539,2.135,2.559,
     -1.000,-1.000,-1.000,2.207,1.508,1.506,2.063,1.935,2.057,1.792,2.393,3.015,2.847,2.911,3.296,2.391,
     -1.000,-1.000,-1.000,2.432,2.342,2.061,2.627,2.808,2.736,2.711,2.780,3.872,2.567,3.539,2.801,3.535,
     -1.000,-1.000,-1.000,2.144,2.358,2.126,2.038,2.640,2.572,2.789,3.086,3.328,3.173,3.358,3.541,3.849,
     -1.000,-1.000,-1.000,2.249,1.861,1.743,1.911,1.728,2.226,1.822,2.031,2.128,2.147,2.261,2.186,2.083,
     -1.000,-1.000,-1.000,1.699,1.644,1.835,1.436,1.488,1.708,1.793,1.759,1.758,1.843,2.026,1.570,1.914,
     -1.000,-1.000,-1.000,1.482,1.056,1.113,1.188,1.133,1.212,1.465,1.440,1.457,1.362,1.374,1.298,1.242,
     -1.000,-1.000,-1.000,-1.000,1.246,1.309,1.029,1.028,1.059,1.131,1.367,1.298,1.228,1.230,1.184,1.189,
     -1.000,-1.000,-1.000,-1.000,1.106,1.030,0.992,1.107,1.135,1.169,1.198,1.471,1.554,1.497,1.405,1.380,
     -1.000,-1.000,-1.000,-1.000,1.318,1.295,1.302,1.142,1.240,1.253,1.255,1.159,1.555,1.684,1.450,1.397,
     -1.000,-1.000,-1.000,-1.000,1.230,1.250,1.280,1.150,1.239,1.505,1.508,1.302,1.615,1.631,1.672,1.515,
     -1.000,-1.000,-1.000,-1.000,1.252,1.321,1.586,1.349,1.286,1.428,1.298,1.321,1.689,1.770,1.689,1.721,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.429,1.284,1.085,1.356,1.650,1.332,1.333,1.343,1.395,1.701,1.598,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.290,1.299,1.549,1.356,1.242,1.569,1.581,1.492,1.579,1.322,1.680,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.363,1.264,1.385,1.200,1.181,1.257,1.334,1.252,1.514,1.381,1.606,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.256,1.287,1.399,1.357,1.352,1.358,1.294,1.367,1.501,1.530,1.496,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.498,1.631,1.327,1.270,1.580,1.509,1.290,1.570,1.563,1.513,1.368,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.431,1.332,1.380,1.272,1.291,1.259,1.649,1.514,1.503,1.611,1.567,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.566,1.352,1.287,1.253,1.323,1.469,1.284,1.502,1.402,1.500,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.492,1.285,1.283,1.276,1.568,1.594,1.631,1.273,1.566,1.642,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.468,1.611,1.394,1.413,1.308,1.621,1.590,1.687,1.648,1.666,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.509,1.554,1.461,1.284,1.290,1.602,1.404,1.582,1.631,1.600,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.554,1.576,1.682,1.330,1.359,1.372,1.658,1.606,1.697,1.733,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.588,1.554,1.665,1.667,1.520,1.666,1.446,1.800,1.772,1.785,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.672,1.676,1.699,1.671,1.479,1.765,1.753,1.514,1.825,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.574,1.694,1.714,1.538,1.415,1.642,1.440,1.778,1.715,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.579,1.551,1.708,1.643,1.356,1.415,1.708,1.504,1.752,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.660,1.547,1.665,1.808,1.604,1.548,1.390,1.467,1.477,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.634,1.492,1.606,1.606,1.782,1.616,1.630,1.645,1.532,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.572,1.490,1.634,1.678,1.622,1.586,1.509,1.582,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.523,1.540,1.583,1.705,1.650,1.731,1.437,-1.000]';
%c
%c +++ HC data for (bore,stroke) = (2,2); Bore = 8.20; Stroke = 8.80
%c
    sclpg(2,2,1:ldptspg,1:rpmptpg,1)=...
     [1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,-1.000]';
%c
%c +++ HC data for (bore,stroke) = (2,3); Bore = 8.20; Stroke = 10.44
%c
sclpg(2,3,1:ldptspg,1:rpmptpg,1)=...
     [1.100,0.757,0.828,0.790,0.747,0.794,1.147,1.132,1.102,1.111,1.071,0.973,0.821,0.793,0.845,0.858,
     1.725,0.940,1.032,0.956,1.047,1.062,0.937,0.860,0.850,0.805,0.756,0.730,0.790,0.725,0.749,0.777,
     2.409,0.924,0.931,1.041,1.143,1.097,0.965,0.855,0.654,0.852,0.879,0.703,0.876,0.716,0.727,0.718,
     2.194,0.741,0.868,1.146,1.424,1.199,1.082,0.760,0.698,0.673,0.958,0.976,0.962,0.862,0.594,0.603,
     4.768,0.543,0.656,0.676,0.499,0.577,0.618,0.587,0.423,0.475,0.540,0.626,0.722,0.816,1.045,1.387,
     -1.000,1.529,1.106,0.473,0.451,0.432,0.427,0.428,0.735,0.784,0.374,0.406,0.625,0.825,0.102,0.612,
     -1.000,0.328,2.120,3.418,2.830,2.608,0.750,0.353,0.188,0.723,0.868,3.433,0.975,0.736,0.466,0.314,
     -1.000,0.238,0.213,0.712,0.670,1.078,0.628,0.677,0.471,0.401,0.316,0.498,0.466,0.543,0.636,0.793,
     -1.000,0.443,0.474,0.459,0.598,0.635,0.532,0.802,0.642,0.607,0.710,0.829,0.557,0.483,0.538,0.381,
     -1.000,0.238,0.351,0.390,0.129,0.200,0.232,0.433,0.490,0.569,0.549,0.511,0.524,0.310,0.277,0.346,
     -1.000,0.122,0.211,0.114,0.083,0.131,0.131,0.179,0.482,0.475,0.590,0.463,0.528,0.577,0.702,0.768,
     -1.000,0.649,0.415,0.653,0.444,0.458,0.622,0.765,0.656,1.124,1.025,0.614,0.731,0.641,0.631,0.449,
     -1.000,-1.000,0.286,0.413,0.410,0.375,0.422,0.448,0.621,1.065,1.007,0.597,0.674,0.888,0.775,0.729,
     -1.000,-1.000,0.469,0.483,0.544,0.448,0.621,0.601,0.952,0.721,0.694,1.085,0.884,0.789,0.690,0.665,
     -1.000,-1.000,0.502,0.382,0.579,0.578,0.555,0.650,0.465,0.534,0.757,0.563,0.647,0.663,0.470,0.421,
     -1.000,-1.000,0.415,0.475,0.328,0.452,0.369,0.399,0.525,0.493,0.608,0.644,0.621,0.636,0.611,0.620,
     -1.000,-1.000,0.471,0.387,0.275,0.421,0.369,0.422,0.367,0.386,0.330,0.372,0.501,0.562,0.437,0.523,
     -1.000,-1.000,-1.000,0.362,0.332,0.395,0.665,0.552,0.576,0.464,0.650,0.631,0.696,0.751,0.673,0.622,
     -1.000,-1.000,-1.000,0.475,0.423,0.460,0.663,0.770,0.790,0.531,0.612,0.906,0.571,0.879,0.761,0.845,
     -1.000,-1.000,-1.000,0.642,0.525,0.548,0.564,0.728,0.768,0.859,0.687,0.830,0.859,0.927,0.916,0.919,
     -1.000,-1.000,-1.000,0.697,0.564,0.553,0.601,0.654,0.798,0.717,0.898,0.747,0.779,0.932,0.967,0.936,
     -1.000,-1.000,-1.000,0.624,0.635,0.634,0.571,0.588,0.762,0.789,0.847,0.702,0.716,0.795,0.720,0.958,
     -1.000,-1.000,-1.000,0.663,0.588,0.557,0.583,0.610,0.645,0.859,0.845,0.914,0.937,0.920,0.773,0.801,
     -1.000,-1.000,-1.000,-1.000,0.578,0.698,0.563,0.585,0.593,0.628,0.840,0.830,0.896,0.895,0.889,0.725,
     -1.000,-1.000,-1.000,-1.000,0.776,0.602,0.525,0.564,0.607,0.606,0.649,0.911,0.963,0.887,0.875,0.936,
     -1.000,-1.000,-1.000,-1.000,0.664,0.583,0.570,0.582,0.557,0.591,0.624,0.589,0.800,0.817,0.862,0.869,
     -1.000,-1.000,-1.000,-1.000,0.738,0.607,0.572,0.596,0.665,0.718,0.759,0.613,0.887,0.975,1.010,0.957,
     -1.000,-1.000,-1.000,-1.000,0.698,0.646,0.736,0.756,0.664,0.756,0.633,0.664,0.863,0.981,1.039,0.955,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.695,0.641,0.653,0.785,0.844,0.662,0.731,0.714,0.714,0.869,1.036,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.712,0.689,0.763,0.660,0.653,0.744,0.751,0.759,0.832,0.699,0.999,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.725,0.656,0.724,0.634,0.697,0.655,0.692,0.649,0.776,0.712,0.853,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.740,0.707,0.704,0.625,0.650,0.667,0.698,0.662,0.770,0.772,0.768,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.852,0.726,0.686,0.628,0.773,0.738,0.664,0.764,0.739,0.784,0.668,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.910,0.684,0.734,0.647,0.614,0.607,0.768,0.786,0.799,0.732,0.764,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.739,0.653,0.672,0.629,0.625,0.749,0.639,0.707,0.716,0.780,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.744,0.705,0.642,0.630,0.721,0.721,0.728,0.620,0.744,0.706,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.833,0.665,0.684,0.709,0.631,0.753,0.726,0.762,0.727,0.793,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.966,0.709,0.726,0.669,0.640,0.778,0.678,0.734,0.730,0.734,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.004,0.807,0.692,0.691,0.699,0.634,0.746,0.798,0.763,0.728,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.458,0.901,0.726,0.682,0.677,0.768,0.659,0.794,0.779,0.756,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.025,0.806,0.761,0.715,0.689,0.785,0.794,0.663,0.776,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.011,0.806,0.687,0.712,0.709,0.714,0.631,0.763,0.729,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.209,0.771,0.742,0.734,0.657,0.674,0.723,0.629,0.750,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.394,0.821,0.747,0.735,0.660,0.668,0.626,0.630,0.628,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,2.166,0.964,0.765,0.669,0.696,0.655,0.687,0.655,0.622,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.111,0.788,0.708,0.655,0.649,0.658,0.617,0.668,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.078,0.817,0.704,0.735,0.623,0.687,0.608,-1.000]';
%c
%c +++ HC data for (bore,stroke) = (3,1); Bore = 9.73; Stroke = 7.16
%c
sclpg(3,1,1:ldptspg,1:rpmptpg,1)=...
     [1.601,0.839,0.992,0.978,0.870,0.950,1.032,1.205,1.144,1.076,1.129,1.202,0.896,0.861,0.881,0.899,
     0.796,0.812,0.995,0.953,0.940,0.929,1.034,1.107,1.021,1.145,0.963,0.841,0.855,0.942,0.962,0.719,
     0.682,1.023,1.012,1.040,1.017,1.118,0.934,1.020,1.037,1.003,0.924,0.848,0.932,0.687,0.465,0.402,
     0.465,0.520,0.699,0.699,0.870,0.852,0.999,0.842,0.878,0.729,0.687,0.567,0.500,0.465,0.357,0.299,
     0.506,0.568,0.587,0.614,0.525,0.574,0.449,0.646,0.631,0.628,0.644,0.595,0.590,0.514,0.546,0.510,
     -1.000,0.929,0.560,0.971,0.630,0.996,0.931,1.101,0.889,0.421,0.711,0.672,0.784,0.503,2.175,3.178,
     -1.000,1.050,6.581,6.170,3.119,4.213,1.364,0.717,0.563,0.880,1.966,2.241,0.055,0.580,0.754,1.221,
     -1.000,0.428,0.063,0.767,0.528,0.730,0.121,0.621,0.418,0.531,0.026,0.857,0.854,0.944,0.954,1.224,
     -1.000,0.721,0.290,0.277,0.521,0.792,0.606,1.019,1.022,0.899,1.053,1.046,1.052,0.910,0.904,0.983,
     -1.000,0.536,0.831,0.652,0.308,0.806,0.758,0.744,0.791,1.014,1.013,0.781,1.086,1.398,0.899,1.082,
     -1.000,0.640,0.679,0.504,0.531,0.569,0.532,1.031,0.968,0.842,1.186,1.117,1.336,1.438,1.533,1.476,
     -1.000,1.206,1.042,1.129,1.132,1.572,1.564,1.383,1.192,2.330,1.647,1.059,1.634,1.317,1.452,1.051,
     -1.000,-1.000,0.517,0.650,0.729,0.458,0.474,0.511,0.670,1.363,1.327,1.439,1.102,1.169,1.110,1.113,
     -1.000,-1.000,0.497,0.581,0.675,0.399,0.868,0.566,0.898,0.759,0.677,1.283,1.214,1.174,0.854,0.870,
     -1.000,-1.000,0.399,0.487,0.359,0.423,0.572,0.985,0.578,0.652,0.884,0.604,0.776,0.873,0.979,0.967,
     -1.000,-1.000,0.267,0.360,0.347,0.370,0.424,0.704,0.729,0.644,0.989,1.113,1.124,0.923,0.890,0.970,
     -1.000,-1.000,0.487,0.520,0.422,0.768,0.673,0.967,0.721,0.884,0.805,0.731,0.906,1.085,0.686,0.862,
     -1.000,-1.000,-1.000,0.908,0.859,0.783,0.998,1.034,1.119,0.820,1.026,1.228,1.010,1.151,0.857,1.061,
     -1.000,-1.000,-1.000,0.994,0.948,0.850,1.105,1.199,1.253,0.949,1.030,1.489,1.226,1.226,1.071,1.313,
     -1.000,-1.000,-1.000,1.111,1.123,1.181,1.068,1.398,1.476,1.533,1.594,1.568,1.651,1.854,1.908,1.619,
     -1.000,-1.000,-1.000,1.350,1.296,1.205,1.261,1.135,1.498,1.268,1.622,1.723,1.419,1.657,1.714,1.730,
     -1.000,-1.000,-1.000,1.473,1.388,1.386,1.179,1.253,1.261,1.361,1.413,1.530,1.253,1.491,1.227,1.532,
     -1.000,-1.000,-1.000,1.383,1.154,1.054,1.097,1.028,1.038,1.271,1.350,1.388,1.466,1.457,1.205,1.210,
     -1.000,-1.000,-1.000,-1.000,1.173,1.381,0.976,1.084,1.128,1.101,1.326,1.373,1.380,1.441,1.472,1.212,
     -1.000,-1.000,-1.000,-1.000,1.202,1.202,1.002,1.048,1.099,1.074,1.014,1.333,1.365,1.394,1.446,1.470,
     -1.000,-1.000,-1.000,-1.000,1.344,1.153,1.066,1.024,1.100,1.212,1.157,1.087,1.412,1.459,1.448,1.510,
     -1.000,-1.000,-1.000,-1.000,1.306,1.212,1.133,1.069,1.151,1.440,1.565,1.114,1.370,1.458,1.512,1.519,
     -1.000,-1.000,-1.000,-1.000,1.352,1.316,1.301,1.320,1.102,1.257,1.219,1.331,1.484,1.543,1.429,1.496,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.344,1.166,1.119,1.266,1.432,1.191,1.231,1.312,1.208,1.446,1.481,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.252,1.224,1.268,1.105,1.031,1.298,1.339,1.373,1.349,1.112,1.483,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.254,1.159,1.138,1.058,1.134,1.164,1.145,1.193,1.448,1.184,1.419,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.299,1.285,1.190,1.103,1.080,1.148,1.126,1.165,1.431,1.460,1.315,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.352,1.261,1.157,1.027,1.328,1.257,1.143,1.249,1.334,1.366,1.249,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.268,1.165,1.246,1.051,1.056,1.100,1.313,1.230,1.248,1.345,1.386,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.229,1.130,1.095,1.012,1.104,1.386,1.144,1.382,1.159,1.365,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.230,1.221,1.099,1.111,1.239,1.308,1.317,1.099,1.258,1.322,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.334,1.240,1.251,1.253,1.006,1.237,1.263,1.347,1.332,1.475,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.304,1.240,1.209,1.116,1.134,1.266,1.071,1.389,1.279,1.402,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.250,1.288,1.194,1.148,1.183,1.053,1.306,1.384,1.331,1.308,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.336,1.241,1.330,1.200,1.168,1.295,1.129,1.400,1.467,1.401,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.334,1.281,1.324,1.281,1.260,1.446,1.373,1.222,1.388,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.408,1.349,1.276,1.307,1.207,1.343,1.127,1.372,1.372,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.414,1.432,1.367,1.278,1.156,1.205,1.396,1.235,1.381,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.374,1.395,1.349,1.426,1.247,1.220,1.165,1.209,1.153,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.346,1.384,1.439,1.281,1.390,1.337,1.353,1.276,1.249,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.387,1.398,1.415,1.301,1.328,1.240,1.203,1.314,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.359,1.328,1.281,1.329,1.275,1.355,1.199,-1.000]';
%c
%c +++ HC data for (bore,stroke) = (3,2); Bore = 9.73; Stroke = 8.80
%c
sclpg(3,2,1:ldptspg,1:rpmptpg,1)=...
     [1.202,0.748,0.850,0.705,0.757,0.805,1.128,1.251,1.020,0.950,1.019,0.931,0.798,0.714,0.745,0.800,
     0.657,0.815,0.717,0.859,0.909,1.086,1.076,1.078,1.032,0.929,0.917,0.734,0.755,0.549,0.553,0.575,
     0.971,0.905,0.769,0.951,0.840,1.134,1.230,1.176,0.796,0.972,0.847,0.643,0.796,0.634,0.558,0.490,
     0.896,0.620,0.599,0.711,0.950,0.715,0.684,0.560,0.631,0.434,0.508,0.446,0.400,0.417,0.347,0.288,
     1.254,0.490,0.537,0.530,0.661,0.500,0.398,0.382,0.387,0.516,0.551,0.565,0.524,0.193,0.230,0.296,
     -1.000,0.193,0.737,0.653,0.516,0.457,0.379,0.793,0.755,0.711,0.464,0.209,0.098,0.719,2.998,4.073,
     -1.000,0.580,3.584,3.649,1.765,0.681,0.488,0.537,0.302,1.212,1.316,6.580,2.604,1.161,1.267,1.228,
     -1.000,0.470,0.072,0.116,0.035,0.595,0.517,0.139,0.258,0.546,0.647,0.838,1.061,0.909,0.949,1.143,
     -1.000,0.400,0.279,0.473,0.286,0.698,0.450,0.763,0.435,0.608,0.938,0.906,0.821,0.759,0.677,0.669,
     -1.000,0.331,0.618,0.384,0.375,0.197,0.255,0.471,0.332,0.458,0.502,0.681,0.925,0.806,0.758,0.697,
     -1.000,0.286,0.615,0.275,0.588,0.314,0.571,0.388,0.498,0.492,0.949,0.701,0.896,0.867,0.913,0.850,
     -1.000,0.663,0.345,0.493,0.799,0.463,0.472,0.599,0.459,0.907,0.763,0.562,0.715,0.525,0.489,0.359,
     -1.000,-1.000,0.236,0.343,0.220,0.347,0.187,0.283,0.299,0.535,0.426,0.414,0.400,0.438,0.440,0.423,
     -1.000,-1.000,0.151,0.108,0.262,0.224,0.261,0.410,0.397,0.267,0.278,0.435,0.396,0.285,0.385,0.369,
     -1.000,-1.000,0.331,0.337,0.292,0.287,0.470,0.525,0.366,0.302,0.401,0.349,0.350,0.420,0.462,0.446,
     -1.000,-1.000,0.369,0.392,0.364,0.352,0.351,0.298,0.311,0.340,0.364,0.406,0.327,0.430,0.344,0.355,
     -1.000,-1.000,0.317,0.349,0.325,0.521,0.410,0.561,0.371,0.427,0.353,0.375,0.492,0.611,0.369,0.487,
     -1.000,-1.000,-1.000,0.505,0.457,0.475,0.594,0.560,0.702,0.438,0.545,0.610,0.605,0.634,0.648,0.491,
     -1.000,-1.000,-1.000,0.574,0.538,0.559,0.729,0.775,0.844,0.736,0.599,0.806,0.609,0.786,0.681,0.784,
     -1.000,-1.000,-1.000,0.660,0.671,0.737,0.756,0.864,0.865,0.893,0.891,1.061,1.155,1.123,1.011,1.018,
     -1.000,-1.000,-1.000,0.944,0.837,0.853,0.795,0.901,0.988,0.774,1.008,1.014,0.868,0.902,0.904,0.871,
     -1.000,-1.000,-1.000,0.858,0.902,0.949,0.785,0.820,1.038,0.964,0.954,0.922,1.016,1.173,1.011,1.018,
     -1.000,-1.000,-1.000,1.021,0.864,0.781,0.801,0.804,0.867,0.967,0.954,0.950,0.935,0.954,0.944,0.933,
     -1.000,-1.000,-1.000,-1.000,0.802,0.921,0.725,0.820,0.778,0.882,0.939,0.966,0.967,0.958,0.985,0.849,
     -1.000,-1.000,-1.000,-1.000,0.850,0.896,0.753,0.831,0.838,0.831,0.756,0.989,0.957,1.069,0.983,0.879,
     -1.000,-1.000,-1.000,-1.000,0.927,0.848,0.761,0.764,0.735,0.733,0.817,0.709,0.900,0.901,0.905,0.905,
     -1.000,-1.000,-1.000,-1.000,0.844,0.793,0.704,0.709,0.733,0.937,0.882,0.789,0.912,0.904,0.911,0.921,
     -1.000,-1.000,-1.000,-1.000,0.816,0.836,0.867,0.846,0.759,0.786,0.730,0.715,0.859,0.921,0.898,0.898,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.816,0.735,0.721,0.852,0.912,0.781,0.836,0.758,0.817,0.954,0.940,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.874,0.884,0.889,0.752,0.733,0.892,0.874,0.869,1.007,0.743,0.906,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.885,0.808,0.804,0.712,0.724,0.746,0.784,0.716,0.850,0.732,0.846,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.806,0.839,0.780,0.722,0.716,0.726,0.776,0.803,0.866,0.863,0.792,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.843,0.824,0.780,0.678,0.877,0.827,0.734,0.834,0.841,0.836,0.747,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.836,0.777,0.799,0.725,0.685,0.702,0.864,0.875,0.878,0.850,0.970,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.811,0.744,0.766,0.670,0.716,0.823,0.712,0.861,0.718,0.925,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.823,0.792,0.743,0.724,0.839,0.821,0.855,0.721,0.855,0.895,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.828,0.795,0.790,0.819,0.707,0.874,0.821,0.861,0.820,0.887,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.899,0.793,0.790,0.752,0.711,0.836,0.747,0.888,0.818,0.890,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.964,0.857,0.830,0.796,0.787,0.697,0.849,0.855,0.841,0.850,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.040,0.898,0.797,0.774,0.797,0.883,0.715,0.900,0.911,0.873,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.915,0.909,0.837,0.766,0.791,0.868,0.856,0.721,0.898,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.976,0.875,0.790,0.816,0.767,0.875,0.757,0.855,0.855,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.976,0.872,0.827,0.798,0.734,0.743,0.855,0.762,0.881,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.087,0.891,0.859,0.858,0.770,0.795,0.729,0.735,0.725,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.100,0.920,0.890,0.807,0.867,0.794,0.804,0.798,0.774,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.986,0.884,0.868,0.802,0.803,0.805,0.776,0.871,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.036,0.934,0.838,0.860,0.800,0.855,0.742,-1.000]';
%c
%c +++ HC data for (bore,stroke) = (3,3); Bore = 9.73; Stroke = 10.44
%c
sclpg(3,3,1:ldptspg,1:rpmptpg,1)=...
     [1.661,0.600,0.667,0.604,0.698,0.905,1.273,1.038,0.847,0.670,0.619,0.668,0.545,0.426,0.394,0.437,
     1.154,0.516,0.629,0.704,0.745,0.909,0.860,0.794,0.656,0.661,0.635,0.506,0.477,0.549,0.612,0.667,
     2.033,0.883,0.822,0.817,1.022,1.060,0.884,0.965,0.588,0.837,0.735,0.406,0.573,0.365,0.363,0.212,
     3.109,0.368,0.568,0.561,0.561,0.665,0.706,0.445,0.338,0.352,0.345,0.332,0.286,0.263,0.169,0.051,
     33.167,0.160,0.263,0.372,0.388,0.424,0.271,0.164,0.159,0.310,0.083,0.286,0.204,0.256,0.054,0.244,
     -1.000,0.444,0.903,0.558,0.289,0.721,0.282,0.585,0.259,0.248,0.220,0.095,0.412,0.739,1.928,4.365,
     -1.000,1.498,5.765,4.338,2.680,3.194,0.907,1.125,0.100,0.223,3.352,4.257,2.664,1.603,1.417,0.972,
     -1.000,0.361,0.432,0.638,0.213,0.066,0.595,0.542,0.232,0.508,0.549,0.466,0.450,0.430,0.391,0.505,
     -1.000,0.043,0.042,0.193,0.062,0.122,0.202,0.252,0.303,0.522,0.576,0.784,0.712,0.603,0.525,0.392,
     -1.000,0.257,0.239,0.081,0.194,0.256,0.025,0.303,0.356,0.455,0.424,0.439,0.457,0.436,0.407,0.379,
     -1.000,0.637,0.139,0.072,0.132,0.187,0.230,0.192,0.340,0.272,0.410,0.228,0.248,0.253,0.270,0.299,
     -1.000,3.046,0.042,0.145,0.063,0.062,0.187,0.186,0.167,0.278,0.208,0.109,0.129,0.109,0.095,0.079,
     -1.000,-1.000,0.088,0.107,0.036,0.033,0.057,0.054,0.061,0.110,0.085,0.107,0.092,0.134,0.066,0.073,
     -1.000,-1.000,0.074,0.082,0.090,0.130,0.163,0.121,0.192,0.130,0.137,0.215,0.192,0.196,0.155,0.136,
     -1.000,-1.000,0.184,0.138,0.191,0.203,0.236,0.231,0.137,0.143,0.194,0.136,0.172,0.184,0.182,0.196,
     -1.000,-1.000,0.283,0.190,0.169,0.197,0.214,0.221,0.191,0.176,0.214,0.228,0.233,0.254,0.255,0.273,
     -1.000,-1.000,0.410,0.261,0.230,0.307,0.261,0.246,0.222,0.220,0.172,0.174,0.224,0.269,0.217,0.261,
     -1.000,-1.000,-1.000,0.308,0.248,0.253,0.361,0.336,0.322,0.294,0.322,0.334,0.319,0.377,0.348,0.317,
     -1.000,-1.000,-1.000,0.431,0.353,0.360,0.504,0.514,0.492,0.361,0.376,0.457,0.334,0.422,0.364,0.425,
     -1.000,-1.000,-1.000,0.367,0.468,0.485,0.481,0.606,0.581,0.551,0.489,0.606,0.538,0.602,0.566,0.538,
     -1.000,-1.000,-1.000,0.528,0.573,0.577,0.554,0.558,0.694,0.524,0.577,0.576,0.504,0.661,0.724,0.572,
     -1.000,-1.000,-1.000,0.695,0.503,0.650,0.637,0.524,0.738,0.760,0.728,0.618,0.617,0.638,0.508,0.569,
     -1.000,-1.000,-1.000,1.179,0.546,0.607,0.604,0.621,0.623,0.654,0.734,0.641,0.628,0.579,0.555,0.531,
     -1.000,-1.000,-1.000,-1.000,0.728,0.764,0.444,0.525,0.519,0.594,0.745,0.632,0.599,0.677,0.567,0.574,
     -1.000,-1.000,-1.000,-1.000,0.815,0.537,0.489,0.647,0.528,0.546,0.537,0.756,0.651,0.625,0.610,0.661,
     -1.000,-1.000,-1.000,-1.000,0.830,0.539,0.511,0.529,0.538,0.555,0.552,0.628,0.785,0.670,0.670,0.660,
     -1.000,-1.000,-1.000,-1.000,1.021,0.578,0.511,0.628,0.652,0.614,0.645,0.622,0.743,0.749,0.741,0.611,
     -1.000,-1.000,-1.000,-1.000,1.476,0.688,0.576,0.580,0.514,0.562,0.524,0.555,0.737,0.659,0.746,0.639,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.758,0.521,0.533,0.759,0.784,0.541,0.564,0.568,0.574,0.771,0.764,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.886,0.638,0.607,0.530,0.635,0.815,0.642,0.641,0.700,0.567,0.691,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.082,0.637,0.665,0.651,0.567,0.568,0.558,0.555,0.764,0.653,0.761,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.514,0.758,0.744,0.510,0.528,0.506,0.528,0.522,0.606,0.603,0.582,
     -1.000,-1.000,-1.000,-1.000,-1.000,6.293,0.796,0.729,0.477,0.756,0.727,0.637,0.596,0.640,0.627,0.537,
     -1.000,-1.000,-1.000,-1.000,-1.000,8.305,0.965,0.658,0.585,0.493,0.516,0.632,0.611,0.600,0.638,0.641,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.101,0.666,0.573,0.504,0.506,0.616,0.611,0.595,0.538,0.592,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,3.312,0.789,0.693,0.628,0.564,0.565,0.605,0.585,0.708,0.604,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,5.034,0.891,0.651,0.593,0.492,0.626,0.622,0.645,0.720,0.611,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,6.594,1.092,0.685,0.564,0.601,0.672,0.551,0.630,0.630,0.623,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,6.100,1.310,0.742,0.623,0.581,0.520,0.623,0.646,0.650,0.615,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,5.673,3.510,0.954,0.706,0.639,0.647,0.524,0.654,0.652,0.648,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,4.329,1.093,0.857,0.618,0.587,0.660,0.633,0.545,0.656,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,4.609,1.467,0.764,0.757,0.699,0.623,0.554,0.651,0.613,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,4.727,1.523,0.932,0.725,0.619,0.581,0.633,0.542,0.688,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,4.132,2.984,1.198,0.775,0.626,0.589,0.539,0.549,0.530,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,3.743,3.510,1.260,0.808,0.712,0.662,0.601,0.577,0.544,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,3.688,1.525,0.957,0.726,0.685,0.607,0.562,0.594,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,3.589,2.855,1.016,0.746,0.698,0.641,0.532,-1.000]';
%c
%c +++ CO Scalar Data +++

%c +++ CO data for (bore,stroke) = (1,1); Bore = 6.67; Stroke = 7.16
%c
sclpg(1,1,1:ldptspg,1:rpmptpg,2)=...
     [1.013,0.901,0.966,0.998,1.007,1.019,1.019,1.024,1.022,1.018,1.016,1.020,1.015,1.019,1.019,1.014,
     1.060,0.928,0.995,1.019,1.022,1.016,1.017,1.022,1.017,1.016,1.019,1.016,1.014,1.018,1.013,1.016,
     1.058,0.958,1.011,1.031,1.030,1.027,1.030,1.028,1.026,1.022,1.025,1.025,1.022,1.015,1.018,1.019,
     1.108,0.991,1.031,1.040,1.032,1.036,1.030,1.036,1.030,1.032,1.026,1.030,1.026,1.025,1.022,1.021,
     1.121,1.011,1.045,1.039,1.044,1.042,1.041,1.035,1.040,1.038,1.034,1.030,1.027,1.028,1.022,1.021,
     -1.000,1.033,1.055,1.052,1.049,1.044,1.036,1.033,1.030,1.029,1.025,1.024,1.023,1.024,1.021,1.017,
     -1.000,1.048,1.062,1.055,1.049,1.048,1.041,1.035,1.040,1.035,1.030,1.027,1.022,1.023,1.020,1.016,
     -1.000,1.060,1.062,1.050,1.051,1.045,1.042,1.042,1.034,1.034,1.028,1.028,1.023,1.023,1.022,1.018,
     -1.000,1.096,1.072,1.065,1.057,1.054,1.051,1.047,1.044,1.037,1.033,1.031,1.030,1.028,1.025,1.025,
     -1.000,1.114,1.081,1.068,1.068,1.061,1.055,1.051,1.046,1.041,1.039,1.038,1.032,1.033,1.028,1.028,
     -1.000,1.150,1.106,1.085,1.068,1.062,1.056,1.048,1.045,1.047,1.046,1.039,1.037,1.035,1.036,1.034,
     -1.000,1.167,1.113,1.092,1.088,1.074,1.065,1.060,1.047,1.053,1.057,1.047,1.042,1.044,1.031,1.035,
     -1.000,-1.000,1.112,1.102,1.095,1.076,1.057,1.055,1.050,1.050,1.042,1.039,1.042,1.044,1.042,1.040,
     -1.000,-1.000,1.122,1.110,1.096,1.087,1.073,1.066,1.059,1.046,1.047,1.046,1.041,1.044,1.038,1.040,
     -1.000,-1.000,1.126,1.113,1.101,1.093,1.082,1.075,1.063,1.054,1.057,1.046,1.053,1.053,1.048,1.051,
     -1.000,-1.000,1.148,1.122,1.113,1.103,1.080,1.077,1.073,1.052,1.066,1.058,1.055,1.054,1.052,1.049,
     -1.000,-1.000,1.138,1.122,1.116,1.095,1.089,1.078,1.071,1.068,1.059,1.064,1.062,1.057,1.057,1.053,
     -1.000,-1.000,-1.000,1.127,1.112,1.104,1.089,1.084,1.079,1.075,1.076,1.069,1.066,1.074,1.066,1.071,
     -1.000,-1.000,-1.000,1.129,1.116,1.110,1.102,1.090,1.089,1.085,1.084,1.078,1.071,1.075,1.064,1.075,
     -1.000,-1.000,-1.000,1.156,1.146,1.126,1.118,1.099,1.096,1.092,1.084,1.086,1.086,1.076,1.075,1.069,
     -1.000,-1.000,-1.000,1.155,1.143,1.116,1.109,1.106,1.100,1.092,1.090,1.087,1.087,1.079,1.082,1.078,
     -1.000,-1.000,-1.000,1.162,1.143,1.121,1.112,1.107,1.099,1.102,1.097,1.092,1.088,1.084,1.084,1.082,
     -1.000,-1.000,-1.000,1.154,1.148,1.144,1.116,1.115,1.106,1.101,1.094,1.092,1.088,1.087,1.083,1.080,
     -1.000,-1.000,-1.000,-1.000,1.154,1.137,1.126,1.107,1.103,1.100,1.091,1.092,1.085,1.088,1.090,1.084,
     -1.000,-1.000,-1.000,-1.000,1.157,1.140,1.134,1.107,1.107,1.097,1.100,1.094,1.093,1.087,1.085,1.086,
     -1.000,-1.000,-1.000,-1.000,1.154,1.148,1.132,1.127,1.114,1.101,1.095,1.093,1.090,1.088,1.086,1.080,
     -1.000,-1.000,-1.000,-1.000,1.161,1.149,1.135,1.126,1.107,1.109,1.109,1.095,1.089,1.087,1.085,1.085,
     -1.000,-1.000,-1.000,-1.000,1.164,1.145,1.135,1.128,1.126,1.103,1.104,1.095,1.100,1.085,1.083,1.077,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.139,1.136,1.134,1.120,1.113,1.106,1.091,1.085,1.087,1.079,1.075,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.149,1.139,1.127,1.126,1.110,1.100,1.099,1.093,1.088,1.078,1.073,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.134,1.145,1.124,1.121,1.112,1.108,1.096,1.090,1.089,1.074,1.077,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.151,1.138,1.125,1.122,1.121,1.106,1.092,1.090,1.095,1.090,1.084,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.150,1.140,1.129,1.128,1.119,1.110,1.102,1.102,1.093,1.089,1.075,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.153,1.150,1.138,1.128,1.118,1.116,1.109,1.103,1.096,1.095,1.089,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.148,1.150,1.135,1.127,1.118,1.115,1.108,1.103,1.095,1.097,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.154,1.137,1.135,1.125,1.120,1.112,1.109,1.105,1.107,1.097,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.152,1.147,1.137,1.132,1.129,1.122,1.119,1.112,1.115,1.106,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.159,1.156,1.150,1.139,1.126,1.125,1.124,1.116,1.116,1.112,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.156,1.147,1.147,1.144,1.132,1.130,1.126,1.122,1.122,1.122,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.161,1.154,1.156,1.144,1.133,1.133,1.129,1.123,1.125,1.127,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.151,1.150,1.149,1.143,1.126,1.134,1.132,1.129,1.133,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.157,1.154,1.153,1.139,1.139,1.141,1.136,1.137,1.139,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.166,1.148,1.146,1.149,1.144,1.144,1.145,1.141,1.142,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.152,1.145,1.140,1.152,1.145,1.142,1.145,1.145,1.150,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.154,1.154,1.152,1.156,1.156,1.147,1.136,1.149,1.154,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.148,1.151,1.164,1.153,1.151,1.149,1.151,1.164,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.154,1.156,1.159,1.157,1.150,1.165,1.160,-1.000]';
%c
%c +++ CO data for (bore,stroke) = (1,2); Bore = 6.67; Stroke = 8.80
%c
sclpg(1,2,1:ldptspg,1:rpmptpg,2)=...
     [0.940,0.930,0.972,0.991,0.992,0.992,0.994,0.993,0.993,0.987,0.988,0.991,0.990,0.991,0.988,0.987,
     0.964,0.949,0.979,0.989,0.994,0.983,0.983,0.988,0.981,0.985,0.984,0.982,0.984,0.984,0.983,0.984,
     0.934,0.962,0.987,0.990,0.992,0.990,0.993,0.993,0.989,0.989,0.990,0.992,0.988,0.987,0.987,0.988,
     0.978,0.958,0.997,0.994,0.992,0.994,0.990,0.998,0.993,0.992,0.990,0.992,0.991,0.989,0.988,0.989,
     0.990,0.964,0.993,0.994,1.000,0.996,1.000,0.995,0.992,0.992,0.991,0.987,0.986,0.989,0.986,0.987,
     -1.000,0.975,1.009,0.997,0.995,1.000,0.996,0.997,0.989,0.993,0.992,0.990,0.989,0.986,0.986,0.987,
     -1.000,0.988,0.997,0.994,0.995,0.994,0.993,0.989,1.001,0.988,0.988,0.984,0.978,0.984,0.976,0.980,
     -1.000,0.981,0.996,0.986,0.986,0.983,0.985,0.989,0.985,0.986,0.981,0.988,0.982,0.980,0.981,0.977,
     -1.000,1.008,1.004,0.999,0.993,0.991,0.992,0.989,0.987,0.985,0.983,0.982,0.984,0.981,0.981,0.983,
     -1.000,1.016,1.005,0.995,0.993,0.997,0.988,0.988,0.987,0.988,0.988,0.985,0.985,0.989,0.982,0.983,
     -1.000,1.041,1.016,1.012,0.998,0.998,0.991,0.987,0.988,0.985,0.986,0.987,0.986,0.984,0.986,0.987,
     -1.000,1.034,1.021,1.006,1.004,1.004,1.000,0.993,0.986,0.991,0.988,0.985,0.983,0.985,0.980,0.982,
     -1.000,-1.000,1.014,1.014,1.005,0.995,0.990,0.986,0.988,0.987,0.984,0.982,0.989,0.985,0.985,0.985,
     -1.000,-1.000,1.016,1.019,1.010,0.999,0.995,1.000,0.993,0.989,0.986,0.986,0.981,0.984,0.986,0.988,
     -1.000,-1.000,1.023,1.019,1.011,1.000,1.006,0.998,0.995,0.982,0.995,0.987,0.995,0.993,0.989,0.989,
     -1.000,-1.000,1.032,1.014,1.009,1.012,1.001,0.997,0.993,0.983,0.993,0.997,0.992,0.994,0.995,0.993,
     -1.000,-1.000,1.027,1.019,1.017,1.013,1.007,1.000,0.995,0.996,0.990,0.992,0.996,0.990,0.996,0.994,
     -1.000,-1.000,-1.000,1.021,1.020,1.022,1.014,1.010,1.010,1.001,1.004,0.998,0.999,1.002,0.999,1.001,
     -1.000,-1.000,-1.000,1.022,1.020,1.018,1.025,1.011,1.015,1.013,1.008,1.008,0.999,1.007,1.002,1.009,
     -1.000,-1.000,-1.000,1.041,1.042,1.028,1.024,1.015,1.023,1.020,1.014,1.012,1.012,1.005,1.005,1.001,
     -1.000,-1.000,-1.000,1.035,1.030,1.015,1.017,1.013,1.010,1.009,1.011,1.014,1.013,1.009,1.009,1.006,
     -1.000,-1.000,-1.000,1.034,1.032,1.016,1.011,1.013,1.012,1.011,1.009,1.012,1.011,1.012,1.012,1.007,
     -1.000,-1.000,-1.000,1.029,1.026,1.027,1.013,1.014,1.012,1.010,1.007,1.007,1.004,1.013,1.010,1.003,
     -1.000,-1.000,-1.000,-1.000,1.039,1.030,1.024,1.006,1.011,1.010,1.004,1.006,1.003,1.002,1.002,1.001,
     -1.000,-1.000,-1.000,-1.000,1.032,1.020,1.025,1.004,1.005,1.007,1.007,1.002,1.000,1.001,0.999,1.000,
     -1.000,-1.000,-1.000,-1.000,1.024,1.027,1.020,1.022,1.016,1.005,1.002,1.003,0.999,0.998,1.000,0.996,
     -1.000,-1.000,-1.000,-1.000,1.032,1.027,1.026,1.021,1.003,1.009,1.010,1.000,0.998,0.997,0.998,0.999,
     -1.000,-1.000,-1.000,-1.000,1.036,1.031,1.023,1.023,1.018,1.001,1.007,1.004,1.004,0.997,0.998,0.998,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.020,1.021,1.029,1.025,1.016,1.010,1.003,1.001,1.002,0.996,0.997,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.030,1.033,1.026,1.022,1.019,1.010,1.011,1.006,1.001,1.000,0.997,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.024,1.037,1.021,1.023,1.019,1.018,1.006,1.004,1.006,0.997,1.005,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.032,1.029,1.016,1.027,1.025,1.015,1.005,1.007,1.012,1.009,1.008,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.029,1.027,1.024,1.032,1.022,1.016,1.013,1.013,1.011,1.011,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.028,1.028,1.025,1.034,1.018,1.026,1.020,1.017,1.016,1.013,1.015,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.024,1.031,1.023,1.022,1.022,1.018,1.017,1.014,1.015,1.013,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.028,1.021,1.031,1.028,1.019,1.019,1.020,1.018,1.021,1.020,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.031,1.029,1.025,1.021,1.032,1.022,1.024,1.020,1.023,1.016,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.034,1.029,1.031,1.028,1.025,1.024,1.025,1.027,1.023,1.021,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.034,1.030,1.028,1.023,1.019,1.025,1.024,1.029,1.027,1.025,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.034,1.031,1.036,1.030,1.025,1.023,1.026,1.028,1.033,1.027,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.030,1.029,1.030,1.020,1.019,1.021,1.025,1.023,1.030,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.032,1.031,1.034,1.019,1.028,1.029,1.029,1.028,1.039,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.038,1.022,1.029,1.030,1.032,1.027,1.030,1.027,1.032,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.027,1.023,1.022,1.030,1.027,1.026,1.029,1.028,1.029,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.026,1.029,1.029,1.034,1.030,1.030,1.015,1.025,1.029,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.025,1.026,1.030,1.025,1.024,1.022,1.027,1.036,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.025,1.029,1.028,1.037,1.032,1.037,1.030,-1.000]';
%c
%c +++ CO data for (bore,stroke) = (1,3); Bore = 6.67; Stroke = 10.44
%c
sclpg(1,3,1:ldptspg,1:rpmptpg,2)=...
    [0.831,0.916,0.934,0.942,0.943,0.952,0.950,0.953,0.954,0.950,0.950,0.952,0.950,0.949,0.949,0.947,
     0.832,0.913,0.937,0.941,0.943,0.935,0.937,0.944,0.935,0.938,0.941,0.941,0.943,0.942,0.941,0.944,
     0.812,0.910,0.932,0.938,0.937,0.940,0.941,0.944,0.941,0.940,0.944,0.947,0.942,0.941,0.942,0.945,
     0.813,0.923,0.922,0.928,0.925,0.936,0.936,0.943,0.939,0.942,0.945,0.948,0.946,0.944,0.944,0.945,
     0.808,0.898,0.925,0.926,0.933,0.934,0.936,0.935,0.934,0.936,0.937,0.935,0.937,0.938,0.935,0.934,
     -1.000,0.903,0.926,0.928,0.924,0.923,0.928,0.928,0.927,0.930,0.934,0.928,0.932,0.930,0.930,0.930,
     -1.000,0.895,0.917,0.918,0.921,0.924,0.927,0.924,0.929,0.929,0.926,0.924,0.921,0.922,0.922,0.921,
     -1.000,0.893,0.912,0.905,0.920,0.919,0.922,0.925,0.928,0.924,0.926,0.926,0.923,0.924,0.922,0.920,
     -1.000,0.864,0.908,0.911,0.906,0.919,0.921,0.922,0.923,0.924,0.927,0.927,0.928,0.929,0.927,0.925,
     -1.000,0.878,0.911,0.907,0.915,0.916,0.918,0.916,0.922,0.923,0.924,0.926,0.924,0.927,0.925,0.925,
     -1.000,0.841,0.916,0.919,0.910,0.914,0.917,0.914,0.915,0.917,0.918,0.920,0.920,0.918,0.929,0.926,
     -1.000,0.820,0.917,0.916,0.919,0.915,0.920,0.920,0.911,0.924,0.926,0.922,0.918,0.924,0.917,0.921,
     -1.000,-1.000,0.912,0.912,0.914,0.913,0.908,0.910,0.915,0.917,0.913,0.917,0.920,0.916,0.917,0.918,
     -1.000,-1.000,0.913,0.916,0.912,0.916,0.910,0.915,0.914,0.911,0.916,0.919,0.916,0.921,0.923,0.922,
     -1.000,-1.000,0.913,0.919,0.915,0.913,0.925,0.915,0.919,0.913,0.918,0.914,0.924,0.926,0.926,0.929,
     -1.000,-1.000,0.917,0.915,0.921,0.920,0.914,0.915,0.920,0.912,0.924,0.931,0.929,0.929,0.928,0.932,
     -1.000,-1.000,0.918,0.927,0.920,0.917,0.918,0.917,0.923,0.921,0.916,0.922,0.927,0.927,0.932,0.931,
     -1.000,-1.000,-1.000,0.915,0.923,0.921,0.919,0.922,0.925,0.922,0.930,0.926,0.928,0.936,0.934,0.937,
     -1.000,-1.000,-1.000,0.918,0.913,0.922,0.927,0.922,0.928,0.931,0.928,0.933,0.926,0.932,0.930,0.934,
     -1.000,-1.000,-1.000,0.935,0.931,0.923,0.931,0.923,0.924,0.924,0.928,0.930,0.935,0.927,0.929,0.927,
     -1.000,-1.000,-1.000,0.919,0.924,0.913,0.915,0.918,0.922,0.922,0.927,0.928,0.933,0.926,0.928,0.929,
     -1.000,-1.000,-1.000,0.919,0.919,0.907,0.914,0.915,0.915,0.923,0.919,0.921,0.927,0.926,0.928,0.926,
     -1.000,-1.000,-1.000,0.932,0.918,0.922,0.910,0.916,0.917,0.914,0.920,0.918,0.923,0.924,0.928,0.927,
     -1.000,-1.000,-1.000,-1.000,0.925,0.923,0.925,0.916,0.913,0.916,0.918,0.919,0.921,0.924,0.925,0.930,
     -1.000,-1.000,-1.000,-1.000,0.924,0.918,0.921,0.908,0.913,0.911,0.918,0.919,0.917,0.921,0.926,0.930,
     -1.000,-1.000,-1.000,-1.000,0.922,0.923,0.920,0.923,0.921,0.915,0.916,0.917,0.915,0.920,0.921,0.922,
     -1.000,-1.000,-1.000,-1.000,0.927,0.924,0.923,0.921,0.907,0.916,0.920,0.912,0.916,0.915,0.918,0.922,
     -1.000,-1.000,-1.000,-1.000,0.932,0.924,0.917,0.919,0.920,0.909,0.915,0.910,0.918,0.912,0.917,0.920,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.919,0.919,0.923,0.922,0.917,0.917,0.914,0.912,0.917,0.914,0.912,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.924,0.921,0.918,0.915,0.915,0.916,0.917,0.917,0.918,0.913,0.912,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.923,0.929,0.913,0.916,0.913,0.917,0.911,0.912,0.914,0.909,0.913,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.924,0.920,0.907,0.913,0.913,0.914,0.906,0.909,0.914,0.916,0.914,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.925,0.916,0.912,0.915,0.914,0.909,0.909,0.915,0.910,0.913,0.904,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.924,0.917,0.918,0.910,0.910,0.915,0.910,0.912,0.911,0.912,0.911,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.934,0.925,0.910,0.913,0.911,0.911,0.909,0.913,0.907,0.906,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.923,0.907,0.914,0.915,0.909,0.907,0.909,0.903,0.908,0.907,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.926,0.915,0.914,0.910,0.909,0.909,0.910,0.905,0.905,0.905,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.958,0.934,0.926,0.915,0.910,0.908,0.909,0.906,0.903,0.900,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.932,0.926,0.915,0.915,0.907,0.910,0.908,0.907,0.906,0.905,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.939,0.925,0.929,0.914,0.910,0.911,0.910,0.904,0.906,0.906,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.927,0.919,0.914,0.907,0.907,0.909,0.905,0.906,0.905,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.940,0.928,0.919,0.905,0.907,0.912,0.904,0.906,0.906,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.938,0.929,0.918,0.913,0.911,0.909,0.910,0.906,0.901,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.934,0.923,0.917,0.916,0.910,0.904,0.905,0.904,0.908,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.933,0.929,0.925,0.926,0.916,0.907,0.895,0.903,0.903,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.935,0.924,0.931,0.914,0.909,0.902,0.907,0.910,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.931,0.929,0.925,0.915,0.915,0.916,0.905,-1.000]';
%c
%c +++ CO data for (bore,stroke) = (2,1); Bore = 8.20; Stroke = 7.16
%c
sclpg(2,1,1:ldptspg,1:rpmptpg,2)=...
     [1.092,0.992,1.001,1.021,1.023,1.031,1.029,1.029,1.027,1.019,1.024,1.025,1.030,1.026,1.024,1.026,
     1.133,0.999,1.030,1.038,1.037,1.020,1.026,1.029,1.022,1.023,1.024,1.022,1.025,1.032,1.024,1.030,
     1.139,1.023,1.044,1.043,1.045,1.046,1.046,1.048,1.040,1.041,1.041,1.041,1.038,1.035,1.035,1.036,
     1.136,1.042,1.050,1.049,1.047,1.047,1.043,1.046,1.042,1.044,1.040,1.049,1.045,1.046,1.042,1.042,
     1.163,1.066,1.061,1.061,1.061,1.056,1.054,1.049,1.049,1.047,1.046,1.042,1.042,1.043,1.038,1.041,
     -1.000,1.075,1.073,1.062,1.057,1.050,1.050,1.049,1.043,1.044,1.043,1.041,1.042,1.039,1.040,1.040,
     -1.000,1.084,1.073,1.065,1.059,1.059,1.055,1.049,1.048,1.044,1.041,1.038,1.036,1.038,1.034,1.033,
     -1.000,1.090,1.083,1.065,1.059,1.051,1.057,1.054,1.050,1.051,1.044,1.045,1.041,1.041,1.041,1.035,
     -1.000,1.108,1.086,1.086,1.072,1.068,1.066,1.062,1.058,1.055,1.052,1.054,1.050,1.050,1.050,1.051,
     -1.000,1.141,1.094,1.075,1.079,1.084,1.069,1.062,1.062,1.062,1.061,1.059,1.058,1.057,1.052,1.053,
     -1.000,1.162,1.109,1.096,1.082,1.072,1.078,1.067,1.065,1.061,1.062,1.058,1.056,1.052,1.054,1.056,
     -1.000,1.157,1.109,1.090,1.095,1.082,1.076,1.067,1.069,1.073,1.071,1.064,1.060,1.060,1.054,1.056,
     -1.000,-1.000,1.109,1.099,1.096,1.080,1.065,1.065,1.064,1.067,1.061,1.061,1.063,1.063,1.073,1.066,
     -1.000,-1.000,1.126,1.114,1.109,1.098,1.085,1.080,1.075,1.066,1.067,1.063,1.058,1.064,1.065,1.067,
     -1.000,-1.000,1.129,1.125,1.107,1.098,1.095,1.091,1.084,1.070,1.075,1.066,1.074,1.079,1.071,1.077,
     -1.000,-1.000,1.158,1.128,1.111,1.110,1.099,1.092,1.093,1.076,1.087,1.079,1.080,1.080,1.078,1.077,
     -1.000,-1.000,1.138,1.117,1.122,1.108,1.099,1.087,1.088,1.087,1.078,1.079,1.081,1.078,1.078,1.075,
     -1.000,-1.000,-1.000,1.119,1.124,1.112,1.099,1.094,1.091,1.085,1.088,1.086,1.082,1.083,1.086,1.082,
     -1.000,-1.000,-1.000,1.124,1.113,1.110,1.111,1.101,1.100,1.098,1.093,1.087,1.079,1.084,1.074,1.082,
     -1.000,-1.000,-1.000,1.134,1.126,1.112,1.112,1.101,1.101,1.096,1.091,1.089,1.088,1.080,1.076,1.071,
     -1.000,-1.000,-1.000,1.136,1.121,1.100,1.099,1.104,1.093,1.093,1.089,1.086,1.082,1.080,1.076,1.071,
     -1.000,-1.000,-1.000,1.117,1.120,1.100,1.104,1.096,1.091,1.094,1.092,1.087,1.084,1.078,1.077,1.074,
     -1.000,-1.000,-1.000,1.113,1.110,1.114,1.093,1.094,1.087,1.091,1.086,1.083,1.077,1.076,1.072,1.071,
     -1.000,-1.000,-1.000,-1.000,1.119,1.112,1.110,1.095,1.083,1.084,1.079,1.085,1.078,1.075,1.073,1.070,
     -1.000,-1.000,-1.000,-1.000,1.122,1.119,1.110,1.088,1.087,1.081,1.087,1.083,1.079,1.084,1.079,1.079,
     -1.000,-1.000,-1.000,-1.000,1.120,1.116,1.112,1.109,1.099,1.088,1.085,1.084,1.077,1.076,1.084,1.076,
     -1.000,-1.000,-1.000,-1.000,1.132,1.120,1.114,1.115,1.090,1.096,1.092,1.083,1.077,1.076,1.075,1.082,
     -1.000,-1.000,-1.000,-1.000,1.139,1.122,1.113,1.114,1.109,1.089,1.091,1.082,1.083,1.073,1.075,1.076,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.116,1.118,1.125,1.115,1.101,1.097,1.085,1.083,1.087,1.079,1.077,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.131,1.122,1.115,1.107,1.111,1.098,1.097,1.092,1.088,1.079,1.075,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.120,1.134,1.113,1.113,1.115,1.112,1.097,1.092,1.091,1.082,1.085,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.126,1.126,1.112,1.111,1.110,1.099,1.098,1.094,1.097,1.093,1.088,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.126,1.116,1.120,1.118,1.110,1.104,1.111,1.105,1.097,1.093,1.085,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.121,1.125,1.128,1.119,1.108,1.111,1.107,1.110,1.104,1.101,1.098,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.117,1.128,1.122,1.118,1.110,1.111,1.103,1.111,1.096,1.099,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.125,1.132,1.130,1.119,1.112,1.109,1.106,1.113,1.115,1.109,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.128,1.122,1.122,1.124,1.117,1.113,1.115,1.107,1.109,1.112,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.136,1.126,1.127,1.132,1.118,1.116,1.115,1.111,1.111,1.121,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.129,1.129,1.123,1.133,1.121,1.120,1.118,1.121,1.120,1.121,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.133,1.129,1.130,1.126,1.124,1.129,1.124,1.121,1.123,1.127,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.128,1.127,1.129,1.122,1.127,1.128,1.126,1.126,1.127,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.138,1.131,1.128,1.122,1.132,1.137,1.126,1.128,1.136,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.135,1.127,1.126,1.127,1.144,1.138,1.137,1.134,1.133,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.123,1.127,1.122,1.129,1.127,1.129,1.140,1.134,1.138,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.133,1.132,1.134,1.134,1.131,1.135,1.121,1.130,1.140,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.126,1.130,1.135,1.128,1.129,1.133,1.134,1.149,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.127,1.135,1.134,1.134,1.132,1.138,1.139,-1.000]';
%c
%c +++ CO data for (bore,stroke) = (2,2); Bore = 8.20; Stroke = 8.80
%c
sclpg(2,2,1:ldptspg,1:rpmptpg,2)=...
     [1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,-1.000]';
%c
%c +++ CO data for (bore,stroke) = (2,3); Bore = 8.20; Stroke = 10.44
%c
sclpg(2,3,1:ldptspg,1:rpmptpg,2)=...
     [0.855,0.968,0.939,0.942,0.950,0.952,0.951,0.953,0.952,0.949,0.951,0.958,0.955,0.953,0.951,0.953,
     0.853,0.951,0.932,0.938,0.941,0.932,0.936,0.943,0.940,0.944,0.944,0.946,0.946,0.952,0.948,0.950,
     0.822,0.933,0.930,0.932,0.937,0.937,0.945,0.949,0.946,0.949,0.952,0.950,0.950,0.947,0.950,0.955,
     0.829,0.927,0.924,0.925,0.926,0.931,0.934,0.939,0.938,0.943,0.942,0.947,0.942,0.945,0.946,0.955,
     0.766,0.906,0.917,0.921,0.935,0.930,0.940,0.940,0.941,0.941,0.944,0.943,0.946,0.947,0.945,0.947,
     -1.000,0.899,0.921,0.921,0.928,0.928,0.932,0.937,0.932,0.937,0.943,0.943,0.947,0.946,0.948,0.951,
     -1.000,0.886,0.904,0.912,0.921,0.928,0.928,0.929,0.935,0.935,0.930,0.934,0.935,0.936,0.935,0.938,
     -1.000,0.864,0.897,0.896,0.906,0.908,0.917,0.925,0.925,0.928,0.932,0.935,0.934,0.935,0.939,0.934,
     -1.000,0.831,0.899,0.903,0.907,0.915,0.921,0.924,0.925,0.929,0.929,0.932,0.939,0.938,0.934,0.939,
     -1.000,0.789,0.892,0.893,0.900,0.909,0.914,0.916,0.923,0.923,0.926,0.927,0.931,0.932,0.930,0.931,
     -1.000,0.729,0.889,0.898,0.895,0.904,0.908,0.908,0.919,0.919,0.922,0.925,0.925,0.928,0.931,0.933,
     -1.000,0.662,0.880,0.899,0.900,0.903,0.907,0.913,0.908,0.924,0.926,0.924,0.923,0.927,0.924,0.924,
     -1.000,-1.000,0.874,0.887,0.903,0.900,0.896,0.900,0.909,0.914,0.915,0.920,0.925,0.927,0.930,0.925,
     -1.000,-1.000,0.874,0.883,0.890,0.897,0.903,0.905,0.909,0.905,0.914,0.918,0.915,0.917,0.924,0.924,
     -1.000,-1.000,0.867,0.883,0.887,0.888,0.901,0.905,0.905,0.901,0.909,0.907,0.914,0.918,0.917,0.918,
     -1.000,-1.000,0.870,0.878,0.881,0.895,0.903,0.906,0.900,0.900,0.912,0.911,0.912,0.914,0.915,0.916,
     -1.000,-1.000,0.875,0.875,0.880,0.884,0.890,0.896,0.896,0.905,0.900,0.905,0.914,0.912,0.916,0.916,
     -1.000,-1.000,-1.000,0.876,0.879,0.885,0.889,0.893,0.904,0.902,0.908,0.914,0.914,0.919,0.921,0.921,
     -1.000,-1.000,-1.000,0.867,0.879,0.885,0.893,0.894,0.899,0.907,0.908,0.911,0.916,0.918,0.914,0.925,
     -1.000,-1.000,-1.000,0.882,0.885,0.891,0.889,0.892,0.896,0.901,0.909,0.912,0.917,0.914,0.922,0.921,
     -1.000,-1.000,-1.000,0.878,0.887,0.884,0.886,0.891,0.893,0.897,0.904,0.913,0.915,0.915,0.920,0.920,
     -1.000,-1.000,-1.000,0.871,0.874,0.873,0.882,0.888,0.891,0.896,0.897,0.914,0.914,0.915,0.919,0.920,
     -1.000,-1.000,-1.000,0.874,0.878,0.882,0.881,0.887,0.890,0.893,0.898,0.902,0.902,0.907,0.918,0.920,
     -1.000,-1.000,-1.000,-1.000,0.883,0.878,0.882,0.881,0.885,0.890,0.892,0.897,0.900,0.904,0.907,0.917,
     -1.000,-1.000,-1.000,-1.000,0.884,0.875,0.893,0.880,0.879,0.886,0.892,0.893,0.896,0.902,0.903,0.910,
     -1.000,-1.000,-1.000,-1.000,0.873,0.880,0.877,0.878,0.891,0.886,0.889,0.894,0.895,0.898,0.900,0.902,
     -1.000,-1.000,-1.000,-1.000,0.871,0.874,0.881,0.882,0.869,0.889,0.892,0.893,0.891,0.895,0.897,0.900,
     -1.000,-1.000,-1.000,-1.000,0.873,0.875,0.875,0.876,0.880,0.874,0.890,0.886,0.895,0.891,0.894,0.897,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.871,0.873,0.883,0.876,0.878,0.888,0.880,0.888,0.892,0.893,0.892,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.874,0.876,0.880,0.881,0.878,0.889,0.892,0.891,0.889,0.887,0.886,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.874,0.885,0.869,0.880,0.874,0.882,0.878,0.888,0.889,0.883,0.886,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.880,0.883,0.865,0.875,0.876,0.876,0.870,0.879,0.890,0.887,0.886,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.886,0.875,0.876,0.874,0.880,0.874,0.876,0.880,0.885,0.880,0.876,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.877,0.883,0.876,0.874,0.875,0.881,0.877,0.876,0.875,0.884,0.875,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.883,0.879,0.876,0.874,0.876,0.874,0.871,0.880,0.866,0.866,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.894,0.875,0.881,0.873,0.868,0.873,0.874,0.869,0.871,0.871,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.885,0.882,0.875,0.875,0.871,0.873,0.878,0.872,0.868,0.862,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.892,0.889,0.888,0.890,0.875,0.872,0.874,0.874,0.871,0.863,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.904,0.898,0.886,0.877,0.873,0.872,0.868,0.866,0.870,0.867,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.871,0.903,0.892,0.888,0.878,0.876,0.872,0.870,0.871,0.869,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.896,0.890,0.890,0.877,0.874,0.872,0.867,0.868,0.866,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.898,0.901,0.891,0.880,0.877,0.878,0.869,0.865,0.865,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.884,0.910,0.891,0.888,0.888,0.888,0.874,0.866,0.863,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.868,0.913,0.894,0.907,0.886,0.883,0.874,0.869,0.864,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.829,0.907,0.907,0.898,0.892,0.886,0.866,0.869,0.869,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.885,0.898,0.906,0.893,0.883,0.879,0.874,0.869,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.907,0.924,0.916,0.906,0.891,0.890,0.876,-1.000]';
%c
%c +++ CO data for (bore,stroke) = (3,1); Bore = 9.73; Stroke = 7.16
%c
sclpg(3,1,1:ldptspg,1:rpmptpg,2)=...
     [1.146,1.052,1.029,1.033,1.036,1.040,1.044,1.044,1.041,1.035,1.037,1.036,1.036,1.035,1.033,1.030,
     1.168,1.055,1.046,1.046,1.050,1.035,1.036,1.037,1.028,1.031,1.033,1.033,1.032,1.035,1.033,1.038,
     1.138,1.060,1.059,1.054,1.049,1.044,1.049,1.048,1.044,1.044,1.049,1.048,1.043,1.040,1.043,1.046,
     1.162,1.085,1.058,1.061,1.052,1.059,1.055,1.057,1.053,1.057,1.054,1.056,1.054,1.052,1.052,1.051,
     1.141,1.075,1.065,1.057,1.067,1.065,1.064,1.058,1.058,1.064,1.060,1.055,1.058,1.059,1.056,1.054,
     -1.000,1.094,1.076,1.066,1.065,1.057,1.058,1.052,1.052,1.055,1.057,1.056,1.055,1.055,1.056,1.055,
     -1.000,1.097,1.074,1.070,1.069,1.067,1.069,1.069,1.066,1.061,1.055,1.052,1.050,1.052,1.055,1.050,
     -1.000,1.095,1.072,1.065,1.067,1.062,1.065,1.066,1.061,1.061,1.058,1.062,1.058,1.061,1.060,1.055,
     -1.000,1.110,1.086,1.079,1.076,1.075,1.071,1.068,1.065,1.063,1.063,1.064,1.064,1.065,1.061,1.069,
     -1.000,1.132,1.082,1.077,1.074,1.075,1.074,1.067,1.067,1.066,1.066,1.069,1.066,1.068,1.069,1.070,
     -1.000,1.131,1.096,1.096,1.082,1.078,1.078,1.067,1.071,1.068,1.070,1.071,1.068,1.066,1.066,1.070,
     -1.000,1.146,1.094,1.079,1.093,1.086,1.079,1.077,1.067,1.075,1.080,1.072,1.073,1.075,1.064,1.069,
     -1.000,-1.000,1.087,1.088,1.088,1.078,1.068,1.068,1.066,1.064,1.065,1.064,1.070,1.064,1.063,1.060,
     -1.000,-1.000,1.082,1.085,1.081,1.075,1.071,1.080,1.076,1.068,1.079,1.066,1.058,1.063,1.066,1.065,
     -1.000,-1.000,1.083,1.088,1.072,1.072,1.074,1.070,1.068,1.070,1.071,1.062,1.065,1.065,1.061,1.058,
     -1.000,-1.000,1.085,1.083,1.078,1.078,1.074,1.073,1.074,1.069,1.071,1.066,1.062,1.063,1.065,1.063,
     -1.000,-1.000,1.086,1.075,1.086,1.079,1.076,1.066,1.066,1.065,1.058,1.063,1.062,1.056,1.064,1.062,
     -1.000,-1.000,-1.000,1.078,1.084,1.088,1.078,1.077,1.075,1.072,1.073,1.069,1.070,1.071,1.066,1.068,
     -1.000,-1.000,-1.000,1.088,1.079,1.094,1.090,1.082,1.077,1.080,1.076,1.072,1.067,1.075,1.067,1.070,
     -1.000,-1.000,-1.000,1.096,1.100,1.090,1.092,1.085,1.083,1.080,1.076,1.079,1.081,1.072,1.069,1.068,
     -1.000,-1.000,-1.000,1.096,1.095,1.081,1.082,1.087,1.085,1.080,1.080,1.080,1.082,1.076,1.076,1.075,
     -1.000,-1.000,-1.000,1.086,1.099,1.083,1.080,1.081,1.081,1.081,1.079,1.078,1.081,1.075,1.079,1.073,
     -1.000,-1.000,-1.000,1.099,1.098,1.098,1.079,1.093,1.089,1.083,1.080,1.079,1.075,1.076,1.080,1.077,
     -1.000,-1.000,-1.000,-1.000,1.100,1.092,1.092,1.075,1.077,1.078,1.084,1.081,1.078,1.074,1.076,1.074,
     -1.000,-1.000,-1.000,-1.000,1.098,1.092,1.094,1.076,1.075,1.075,1.085,1.083,1.082,1.080,1.076,1.080,
     -1.000,-1.000,-1.000,-1.000,1.089,1.101,1.095,1.094,1.085,1.078,1.080,1.088,1.080,1.081,1.080,1.077,
     -1.000,-1.000,-1.000,-1.000,1.095,1.103,1.093,1.097,1.076,1.085,1.083,1.090,1.082,1.080,1.081,1.083,
     -1.000,-1.000,-1.000,-1.000,1.100,1.096,1.098,1.093,1.093,1.080,1.077,1.075,1.080,1.074,1.081,1.081,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.087,1.101,1.097,1.098,1.084,1.085,1.074,1.072,1.081,1.075,1.075,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.103,1.096,1.100,1.090,1.093,1.085,1.086,1.082,1.080,1.076,1.074,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.088,1.107,1.097,1.095,1.089,1.090,1.085,1.082,1.084,1.075,1.082,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.092,1.093,1.087,1.090,1.094,1.088,1.085,1.085,1.088,1.084,1.085,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.085,1.093,1.096,1.094,1.090,1.088,1.086,1.090,1.085,1.085,1.076,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.087,1.096,1.093,1.093,1.088,1.089,1.089,1.092,1.089,1.089,1.087,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.089,1.099,1.097,1.094,1.090,1.089,1.091,1.089,1.088,1.087,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.096,1.093,1.099,1.090,1.089,1.088,1.087,1.087,1.100,1.093,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.089,1.084,1.091,1.092,1.102,1.099,1.098,1.095,1.098,1.089,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.094,1.092,1.105,1.098,1.091,1.093,1.102,1.093,1.097,1.095,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.102,1.095,1.096,1.097,1.089,1.096,1.098,1.096,1.095,1.101,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.087,1.096,1.092,1.096,1.099,1.101,1.102,1.095,1.100,1.104,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.097,1.092,1.097,1.092,1.093,1.096,1.100,1.101,1.110,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.085,1.099,1.094,1.091,1.099,1.103,1.100,1.102,1.103,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.087,1.080,1.089,1.101,1.108,1.105,1.102,1.100,1.106,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.085,1.080,1.083,1.092,1.099,1.103,1.102,1.098,1.110,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.079,1.087,1.091,1.108,1.100,1.097,1.086,1.098,1.101,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.085,1.086,1.093,1.096,1.092,1.102,1.103,1.106,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.086,1.091,1.102,1.104,1.098,1.110,1.101,-1.000]';
%c
%c +++ CO data for (bore,stroke) = (3,2); Bore = 9.73; Stroke = 8.80
%c
sclpg(3,2,1:ldptspg,1:rpmptpg,2)=...
     [1.041,1.055,0.999,1.007,0.997,1.000,1.002,1.002,1.005,1.002,1.000,1.006,1.006,1.006,1.006,1.005,
     1.018,1.036,1.010,1.005,1.003,0.992,0.996,1.001,0.995,0.997,1.000,1.002,1.006,1.003,1.004,1.006,
     0.975,1.021,1.012,1.000,1.005,1.008,1.007,1.008,1.006,1.005,1.009,1.007,1.005,1.003,1.005,1.008,
     0.978,1.014,0.994,0.999,0.997,1.000,1.001,1.008,1.005,1.014,1.016,1.019,1.016,1.020,1.017,1.017,
     0.946,1.012,0.993,0.990,1.002,1.005,1.012,1.006,1.007,1.007,1.010,1.006,1.010,1.013,1.016,1.014,
     -1.000,1.005,0.998,0.996,1.000,1.003,1.004,1.005,1.006,1.011,1.012,1.011,1.009,1.011,1.010,1.013,
     -1.000,0.992,0.986,0.996,1.003,1.003,1.005,1.005,1.006,1.003,1.009,1.006,1.002,1.003,1.008,1.010,
     -1.000,0.971,0.980,0.988,0.993,0.988,0.995,0.998,0.999,1.001,0.998,1.002,1.000,1.003,1.003,0.997,
     -1.000,0.957,0.973,0.983,0.984,0.992,0.991,0.997,1.001,1.000,1.001,1.003,1.005,1.005,1.002,1.005,
     -1.000,0.919,0.975,0.965,0.986,0.989,0.996,0.992,0.996,0.995,1.004,1.003,1.008,1.007,1.006,1.004,
     -1.000,0.890,0.973,0.982,0.980,0.985,0.992,0.992,1.000,1.002,1.003,1.010,1.013,1.007,1.007,1.008,
     -1.000,0.833,0.973,0.976,0.986,0.988,0.995,0.999,0.994,1.001,1.000,0.994,0.992,1.001,0.990,0.993,
     -1.000,-1.000,0.960,0.971,0.973,0.980,0.980,0.978,0.987,0.986,0.989,0.994,0.995,0.998,0.994,0.993,
     -1.000,-1.000,0.960,0.964,0.976,0.974,0.980,0.979,0.987,0.981,0.985,0.984,0.980,0.987,0.988,0.985,
     -1.000,-1.000,0.956,0.974,0.968,0.972,0.985,0.985,0.985,0.982,0.985,0.980,0.988,0.987,0.986,0.989,
     -1.000,-1.000,0.957,0.966,0.970,0.979,0.981,0.980,0.983,0.976,0.985,0.984,0.988,0.986,0.991,0.988,
     -1.000,-1.000,0.948,0.958,0.973,0.972,0.971,0.982,0.983,0.983,0.980,0.984,0.988,0.986,0.992,0.994,
     -1.000,-1.000,-1.000,0.957,0.967,0.975,0.973,0.981,0.986,0.986,0.991,0.991,0.991,0.995,0.995,0.999,
     -1.000,-1.000,-1.000,0.948,0.964,0.971,0.978,0.979,0.995,0.994,0.992,0.994,0.989,0.997,0.991,0.998,
     -1.000,-1.000,-1.000,0.964,0.971,0.972,0.978,0.978,0.983,0.989,0.988,0.989,0.998,0.993,1.000,0.997,
     -1.000,-1.000,-1.000,0.955,0.965,0.962,0.969,0.979,0.982,0.990,0.989,0.987,0.996,0.997,1.003,1.005,
     -1.000,-1.000,-1.000,0.950,0.959,0.956,0.965,0.980,0.978,0.984,0.985,0.994,0.991,0.992,0.997,0.996,
     -1.000,-1.000,-1.000,0.951,0.954,0.966,0.967,0.980,0.980,0.978,0.986,0.987,0.987,0.992,0.994,0.995,
     -1.000,-1.000,-1.000,-1.000,0.966,0.960,0.969,0.968,0.968,0.981,0.980,0.986,0.989,0.989,0.992,0.995,
     -1.000,-1.000,-1.000,-1.000,0.957,0.958,0.963,0.961,0.969,0.977,0.986,0.984,0.986,0.986,0.989,1.001,
     -1.000,-1.000,-1.000,-1.000,0.950,0.964,0.963,0.974,0.972,0.974,0.979,0.983,0.982,0.986,0.988,0.987,
     -1.000,-1.000,-1.000,-1.000,0.951,0.956,0.963,0.967,0.959,0.976,0.981,0.971,0.975,0.982,0.987,0.988,
     -1.000,-1.000,-1.000,-1.000,0.951,0.949,0.956,0.964,0.966,0.959,0.971,0.972,0.987,0.979,0.984,0.985,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.940,0.956,0.967,0.963,0.967,0.967,0.967,0.973,0.980,0.984,0.985,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.947,0.956,0.965,0.963,0.963,0.965,0.974,0.974,0.985,0.975,0.981,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.940,0.958,0.957,0.963,0.962,0.975,0.962,0.970,0.973,0.971,0.983,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.947,0.949,0.960,0.956,0.968,0.963,0.964,0.963,0.976,0.975,0.974,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.946,0.946,0.949,0.967,0.958,0.962,0.964,0.968,0.970,0.968,0.960,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.944,0.943,0.958,0.951,0.962,0.965,0.965,0.963,0.967,0.971,0.963,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.945,0.955,0.950,0.959,0.956,0.968,0.958,0.964,0.966,0.958,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.953,0.949,0.957,0.963,0.954,0.964,0.963,0.959,0.959,0.953,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.949,0.946,0.948,0.952,0.963,0.960,0.965,0.961,0.959,0.952,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.950,0.949,0.956,0.954,0.962,0.955,0.965,0.958,0.958,0.949,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.946,0.953,0.950,0.950,0.953,0.959,0.957,0.954,0.959,0.956,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.949,0.951,0.956,0.955,0.953,0.952,0.959,0.955,0.953,0.959,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.952,0.954,0.957,0.954,0.960,0.952,0.954,0.957,0.949,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.961,0.960,0.950,0.956,0.956,0.956,0.948,0.949,0.951,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.952,0.952,0.961,0.957,0.960,0.968,0.950,0.950,0.949,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.947,0.952,0.948,0.960,0.954,0.950,0.953,0.950,0.952,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.943,0.954,0.962,0.964,0.961,0.953,0.943,0.947,0.945,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.953,0.960,0.960,0.959,0.955,0.949,0.946,0.948,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.951,0.960,0.964,0.961,0.956,0.953,0.953,-1.000]';
%c
%c +++ CO data for (bore,stroke) = (3,3); Bore = 9.73; Stroke = 10.44
%c
sclpg(3,3,1:ldptspg,1:rpmptpg,2)=...
     [0.851,1.015,0.946,0.949,0.943,0.945,0.947,0.954,0.955,0.954,0.957,0.960,0.963,0.967,0.965,0.968,
     0.853,0.979,0.940,0.951,0.953,0.943,0.950,0.955,0.951,0.955,0.957,0.958,0.958,0.962,0.959,0.962,
     0.795,0.939,0.925,0.932,0.935,0.936,0.942,0.946,0.948,0.955,0.956,0.959,0.957,0.960,0.962,0.972,
     0.757,0.928,0.907,0.925,0.928,0.934,0.942,0.947,0.950,0.955,0.954,0.961,0.959,0.961,0.960,0.966,
     0.446,0.906,0.903,0.913,0.923,0.933,0.940,0.939,0.943,0.952,0.957,0.949,0.953,0.959,0.961,0.963,
     -1.000,0.872,0.900,0.907,0.920,0.919,0.931,0.933,0.937,0.947,0.944,0.949,0.955,0.956,0.957,0.961,
     -1.000,0.840,0.892,0.908,0.920,0.924,0.927,0.934,0.936,0.936,0.940,0.941,0.942,0.950,0.946,0.951,
     -1.000,0.734,0.873,0.886,0.900,0.906,0.911,0.921,0.931,0.928,0.931,0.934,0.936,0.940,0.939,0.937,
     -1.000,0.667,0.865,0.882,0.888,0.894,0.913,0.918,0.924,0.927,0.926,0.935,0.938,0.940,0.937,0.942,
     -1.000,0.620,0.859,0.864,0.879,0.895,0.900,0.905,0.915,0.923,0.930,0.931,0.932,0.934,0.934,0.933,
     -1.000,0.559,0.844,0.864,0.873,0.883,0.895,0.893,0.907,0.910,0.914,0.923,0.921,0.924,0.928,0.925,
     -1.000,0.481,0.837,0.848,0.869,0.878,0.888,0.892,0.889,0.900,0.905,0.902,0.914,0.907,0.911,0.916,
     -1.000,-1.000,0.823,0.846,0.865,0.868,0.871,0.880,0.886,0.893,0.895,0.902,0.904,0.913,0.911,0.912,
     -1.000,-1.000,0.826,0.847,0.858,0.871,0.873,0.881,0.889,0.886,0.896,0.899,0.898,0.909,0.906,0.908,
     -1.000,-1.000,0.782,0.840,0.847,0.864,0.876,0.877,0.884,0.882,0.890,0.891,0.904,0.907,0.906,0.909,
     -1.000,-1.000,0.751,0.824,0.845,0.856,0.867,0.878,0.880,0.880,0.894,0.896,0.899,0.903,0.907,0.912,
     -1.000,-1.000,0.693,0.818,0.841,0.850,0.861,0.864,0.876,0.886,0.885,0.893,0.902,0.901,0.907,0.908,
     -1.000,-1.000,-1.000,0.843,0.842,0.852,0.855,0.866,0.871,0.884,0.894,0.898,0.898,0.904,0.914,0.915,
     -1.000,-1.000,-1.000,0.812,0.821,0.846,0.861,0.863,0.884,0.880,0.885,0.889,0.899,0.904,0.905,0.913,
     -1.000,-1.000,-1.000,0.816,0.830,0.834,0.858,0.863,0.875,0.881,0.887,0.895,0.905,0.901,0.910,0.910,
     -1.000,-1.000,-1.000,0.811,0.824,0.825,0.844,0.855,0.867,0.872,0.881,0.888,0.903,0.898,0.903,0.906,
     -1.000,-1.000,-1.000,0.775,0.824,0.818,0.831,0.847,0.869,0.871,0.881,0.889,0.889,0.904,0.899,0.908,
     -1.000,-1.000,-1.000,0.730,0.820,0.830,0.828,0.851,0.865,0.865,0.874,0.876,0.880,0.887,0.894,0.892,
     -1.000,-1.000,-1.000,-1.000,0.818,0.827,0.836,0.835,0.846,0.869,0.870,0.879,0.881,0.890,0.889,0.892,
     -1.000,-1.000,-1.000,-1.000,0.818,0.823,0.831,0.826,0.839,0.846,0.856,0.873,0.879,0.883,0.884,0.886,
     -1.000,-1.000,-1.000,-1.000,0.813,0.829,0.831,0.838,0.841,0.844,0.849,0.864,0.873,0.871,0.875,0.878,
     -1.000,-1.000,-1.000,-1.000,0.804,0.831,0.829,0.833,0.828,0.843,0.849,0.860,0.861,0.869,0.873,0.875,
     -1.000,-1.000,-1.000,-1.000,0.756,0.854,0.827,0.834,0.839,0.836,0.843,0.846,0.860,0.860,0.865,0.869,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.821,0.830,0.832,0.831,0.836,0.841,0.842,0.845,0.852,0.856,0.861,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.824,0.831,0.829,0.827,0.839,0.839,0.843,0.844,0.846,0.841,0.838,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.812,0.847,0.826,0.832,0.840,0.844,0.836,0.843,0.858,0.848,0.848,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.779,0.825,0.820,0.828,0.835,0.832,0.831,0.838,0.840,0.839,0.832,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.607,0.824,0.820,0.833,0.832,0.831,0.834,0.835,0.828,0.831,0.822,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.413,0.830,0.844,0.830,0.830,0.833,0.833,0.832,0.828,0.833,0.825,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.816,0.835,0.836,0.835,0.832,0.832,0.831,0.827,0.822,0.819,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.789,0.828,0.832,0.830,0.831,0.826,0.828,0.825,0.823,0.819,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.650,0.829,0.842,0.835,0.837,0.831,0.828,0.826,0.821,0.814,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.498,0.825,0.868,0.840,0.835,0.832,0.831,0.825,0.821,0.812,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.486,0.805,0.850,0.836,0.834,0.836,0.834,0.826,0.822,0.819,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.473,0.731,0.834,0.848,0.842,0.840,0.834,0.825,0.826,0.819,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.653,0.823,0.851,0.839,0.837,0.835,0.831,0.828,0.822,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.600,0.799,0.856,0.842,0.848,0.841,0.831,0.827,0.827,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.546,0.781,0.849,0.851,0.859,0.844,0.837,0.830,0.827,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.564,0.703,0.811,0.859,0.853,0.852,0.843,0.833,0.828,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.546,0.655,0.809,0.857,0.859,0.856,0.835,0.838,0.834,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.628,0.786,0.842,0.856,0.853,0.847,0.840,0.843,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.612,0.718,0.846,0.890,0.860,0.854,0.849,-1.000]';
%c
%c +++ NOx S%calar Data +++
%c
%c +++ NOx data for (bore,stroke) = (1,1); Bore = 6.67; Stroke = 7.16
%c
sclpg(1,1,1:ldptspg,1:rpmptpg,3)=...
     [1.103,0.762,0.961,0.973,0.980,0.983,0.982,0.983,0.982,0.984,0.984,0.982,0.982,0.981,0.983,0.982,
     1.287,0.840,0.948,0.974,0.980,0.989,0.985,0.984,0.983,0.982,0.983,0.981,0.982,0.983,0.980,0.983,
     1.289,0.870,0.963,0.980,0.983,0.982,0.983,0.984,0.983,0.982,0.981,0.981,0.985,0.981,0.981,0.983,
     1.496,0.915,0.984,0.988,0.997,0.985,0.988,0.985,0.983,0.983,0.983,0.983,0.983,0.983,0.982,0.983,
     1.802,0.961,1.003,0.990,1.007,0.989,0.987,0.984,0.982,0.983,0.983,0.984,0.983,0.983,0.982,0.982,
     -1.000,1.007,1.029,1.009,0.997,0.993,0.987,0.974,0.978,0.983,0.982,0.982,0.982,0.982,0.981,0.982,
     -1.000,1.053,1.053,1.020,1.006,0.998,0.989,0.978,0.991,0.978,0.980,0.983,0.982,0.982,0.981,0.981,
     -1.000,1.105,1.017,1.026,1.018,1.003,0.996,0.992,0.985,0.984,0.990,0.982,0.981,0.981,0.981,0.979,
     -1.000,1.085,1.088,1.095,1.032,1.015,1.005,0.998,0.992,0.987,0.985,0.984,0.983,0.982,0.982,0.981,
     -1.000,1.158,1.082,1.077,1.016,0.999,1.015,1.004,0.984,0.991,0.988,0.987,0.984,0.984,0.983,0.982,
     -1.000,1.285,1.160,1.067,1.105,1.038,1.018,1.026,1.014,0.996,0.984,0.982,0.987,0.985,0.984,0.984,
     -1.000,1.491,1.129,1.149,1.103,1.096,1.060,1.038,1.035,1.000,0.988,0.993,0.989,0.984,0.987,0.983,
     -1.000,-1.000,1.157,1.137,1.086,1.075,1.069,1.047,1.029,1.005,1.005,0.998,0.995,0.989,0.987,0.985,
     -1.000,-1.000,1.271,1.176,1.153,1.056,1.062,1.039,1.021,1.022,1.015,1.007,0.999,0.991,0.991,0.988,
     -1.000,-1.000,1.415,1.207,1.198,1.004,1.051,1.028,1.054,1.039,1.010,1.013,0.998,0.994,0.997,0.991,
     -1.000,-1.000,1.426,1.365,1.105,1.115,1.093,1.031,1.054,1.072,1.003,1.010,1.003,0.998,0.994,0.990,
     -1.000,-1.000,1.489,1.359,1.200,1.118,1.132,1.050,1.055,1.015,1.043,1.019,0.996,1.003,0.990,0.995,
     -1.000,-1.000,-1.000,1.432,1.218,1.147,1.128,1.063,1.041,1.051,1.017,1.024,1.013,1.000,1.002,0.994,
     -1.000,-1.000,-1.000,1.482,1.397,1.230,1.174,1.078,1.060,1.103,1.055,1.038,1.045,1.018,1.027,1.005,
     -1.000,-1.000,-1.000,1.436,1.293,1.299,1.162,1.140,1.073,1.051,1.031,1.027,1.019,1.036,1.016,1.006,
     -1.000,-1.000,-1.000,1.564,1.398,1.377,1.223,1.173,1.093,1.127,1.045,1.031,1.003,1.026,1.009,1.002,
     -1.000,-1.000,-1.000,1.469,1.446,1.440,1.318,1.243,1.147,1.087,1.062,1.041,1.029,1.039,1.012,1.007,
     -1.000,-1.000,-1.000,1.770,1.425,1.299,1.370,1.240,1.174,1.138,1.100,1.076,1.035,1.025,1.017,1.009,
     -1.000,-1.000,-1.000,-1.000,1.496,1.349,1.283,1.311,1.242,1.153,1.115,1.091,1.064,1.051,1.026,1.027,
     -1.000,-1.000,-1.000,-1.000,1.567,1.540,1.332,1.342,1.281,1.203,1.138,1.106,1.086,1.061,1.061,1.038,
     -1.000,-1.000,-1.000,-1.000,1.885,1.529,1.440,1.279,1.257,1.245,1.191,1.151,1.119,1.076,1.059,1.040,
     -1.000,-1.000,-1.000,-1.000,1.855,1.589,1.416,1.381,1.354,1.179,1.150,1.176,1.138,1.112,1.071,1.059,
     -1.000,-1.000,-1.000,-1.000,1.762,1.649,1.472,1.413,1.282,1.315,1.201,1.203,1.102,1.100,1.082,1.082,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.694,1.507,1.416,1.244,1.237,1.235,1.226,1.180,1.155,1.120,1.096,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.713,1.603,1.444,1.354,1.312,1.243,1.160,1.124,1.139,1.138,1.112,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.968,1.611,1.563,1.375,1.359,1.294,1.231,1.224,1.116,1.154,1.101,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.831,1.672,1.637,1.505,1.350,1.368,1.306,1.256,1.144,1.116,1.088,
     -1.000,-1.000,-1.000,-1.000,-1.000,2.155,1.732,1.701,1.484,1.389,1.241,1.289,1.156,1.155,1.129,1.209,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.957,1.756,1.542,1.535,1.494,1.408,1.334,1.287,1.179,1.197,1.157,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.966,1.648,1.632,1.483,1.469,1.328,1.379,1.260,1.282,1.155,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.998,1.896,1.697,1.615,1.502,1.347,1.362,1.359,1.225,1.260,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,2.124,1.915,1.781,1.625,1.510,1.429,1.361,1.350,1.217,1.275,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,2.135,1.948,1.746,1.735,1.640,1.485,1.490,1.339,1.245,1.261,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,2.179,1.964,1.917,1.725,1.646,1.545,1.389,1.400,1.347,1.306,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,2.262,2.124,1.956,1.798,1.711,1.624,1.522,1.447,1.403,1.426,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,2.367,2.022,1.746,1.730,1.757,1.526,1.531,1.540,1.425,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,2.463,2.096,1.927,1.938,1.782,1.541,1.595,1.545,1.420,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,2.102,2.283,2.129,1.962,1.771,1.784,1.537,1.611,1.621,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,2.392,1.934,2.240,1.758,1.879,1.859,1.762,1.699,1.647,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,2.591,2.181,2.091,2.081,1.744,1.843,1.937,1.796,1.743,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,2.398,2.010,1.837,1.992,1.971,1.968,1.854,1.517,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,2.492,2.280,2.023,2.021,2.136,1.822,1.865,-1.000]';
%c
%c +++ NOx data for (bore,stroke) = (1,2); Bore = 6.67; Stroke = 8.80
%c
sclpg(1,2,1:ldptspg,1:rpmptpg,3)=...
     [0.877,0.873,1.017,0.993,0.987,0.991,0.990,0.989,0.991,0.990,0.990,0.990,0.991,0.989,0.991,0.990,
     0.927,0.907,0.972,0.996,0.994,0.998,0.992,0.990,0.988,0.988,0.988,0.988,0.988,0.988,0.988,0.988,
     0.801,0.823,0.953,0.984,0.988,0.987,0.989,0.990,0.988,0.987,0.987,0.987,0.989,0.985,0.985,0.987,
     0.981,0.916,0.912,0.965,0.989,0.990,0.988,0.990,0.989,0.988,0.988,0.988,0.988,0.989,0.988,0.988,
     0.985,1.010,0.989,0.989,0.973,0.978,0.984,0.985,0.986,0.988,0.988,0.989,0.988,0.988,0.988,0.988,
     -1.000,1.016,0.935,0.936,0.950,0.978,0.980,0.974,0.978,0.987,0.988,0.988,0.989,0.989,0.989,0.990,
     -1.000,0.999,1.002,0.996,0.970,0.993,0.966,0.972,0.980,0.983,0.982,0.987,0.988,0.988,0.987,0.988,
     -1.000,1.055,1.020,1.032,0.995,0.989,0.990,0.992,0.988,0.989,0.995,0.985,0.987,0.988,0.989,0.988,
     -1.000,1.001,0.978,0.973,1.005,0.995,0.995,0.993,0.990,0.989,0.988,0.988,0.988,0.988,0.988,0.988,
     -1.000,1.037,1.039,1.017,1.008,0.975,1.016,0.992,0.979,0.991,0.991,0.989,0.989,0.990,0.989,0.989,
     -1.000,1.045,1.079,0.952,1.016,1.010,0.998,1.014,1.009,1.001,0.982,0.985,0.990,0.989,0.990,0.990,
     -1.000,1.196,0.985,1.093,1.026,1.025,1.011,0.998,1.013,0.995,0.992,0.991,0.990,0.986,0.989,0.988,
     -1.000,-1.000,0.982,1.024,1.038,1.051,1.008,0.999,0.998,0.995,0.992,0.990,0.985,0.990,0.986,0.987,
     -1.000,-1.000,1.107,1.037,1.055,1.019,1.011,0.984,0.979,0.999,0.994,0.994,0.990,0.991,0.991,0.991,
     -1.000,-1.000,1.156,1.047,1.073,0.954,0.961,0.985,1.006,1.033,0.983,0.995,0.986,0.987,0.994,0.992,
     -1.000,-1.000,1.135,1.097,1.057,1.015,1.032,1.015,1.039,1.049,1.000,0.985,1.007,0.985,0.987,0.987,
     -1.000,-1.000,1.210,1.127,1.084,0.971,1.049,0.991,1.009,0.985,1.021,1.000,0.985,0.995,0.994,0.994,
     -1.000,-1.000,-1.000,1.150,1.162,0.982,0.974,0.968,1.001,1.011,0.990,1.002,1.001,1.000,0.997,0.996,
     -1.000,-1.000,-1.000,1.177,1.121,1.083,0.991,1.005,0.975,1.035,1.019,1.016,1.025,1.005,1.014,1.001,
     -1.000,-1.000,-1.000,1.181,1.065,1.120,1.084,1.052,0.979,0.977,0.971,0.995,0.995,1.006,1.004,0.998,
     -1.000,-1.000,-1.000,1.173,1.118,1.168,1.080,1.055,1.043,1.032,1.000,0.974,0.976,0.993,0.992,0.990,
     -1.000,-1.000,-1.000,1.128,1.134,1.199,1.135,1.109,1.054,1.004,1.026,0.998,0.995,0.997,0.978,0.990,
     -1.000,-1.000,-1.000,1.392,1.129,1.097,1.167,1.081,1.102,1.046,1.031,1.023,1.014,0.975,0.976,0.990,
     -1.000,-1.000,-1.000,-1.000,1.057,1.031,1.081,1.131,1.118,1.054,1.035,1.032,1.020,1.012,1.009,1.005,
     -1.000,-1.000,-1.000,-1.000,1.145,1.256,1.097,1.197,1.121,1.055,1.047,1.032,1.020,1.017,1.011,1.008,
     -1.000,-1.000,-1.000,-1.000,1.322,1.224,1.158,1.076,1.100,1.110,1.085,1.036,1.026,1.044,1.016,1.008,
     -1.000,-1.000,-1.000,-1.000,1.349,1.100,1.126,1.084,1.151,1.037,1.074,1.078,1.064,1.053,1.045,1.017,
     -1.000,-1.000,-1.000,-1.000,1.323,1.140,1.145,1.111,1.127,1.187,1.071,1.055,1.047,1.029,1.026,1.020,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.338,1.193,1.143,1.005,1.065,1.088,1.064,1.050,1.078,1.059,1.049,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.337,1.210,1.155,1.170,1.076,1.047,1.040,1.021,1.080,1.038,1.060,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.363,1.185,1.218,1.120,1.151,1.130,1.088,1.069,1.023,1.079,1.013,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.276,1.204,1.364,1.154,1.123,1.129,1.150,1.085,1.042,1.028,1.021,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.305,1.283,1.198,1.110,1.140,1.043,1.167,1.061,1.048,1.041,1.132,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.497,1.318,1.238,1.140,1.195,1.126,1.102,1.128,1.017,1.050,1.046,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.338,1.283,1.338,1.271,1.136,1.108,1.146,1.113,1.117,1.051,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.397,1.368,1.184,1.204,1.149,1.129,1.121,1.149,1.044,1.078,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.550,1.352,1.339,1.266,1.128,1.158,1.081,1.116,1.064,1.134,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.415,1.390,1.260,1.331,1.207,1.179,1.217,1.091,1.069,1.101,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.469,1.315,1.427,1.399,1.197,1.189,1.108,1.112,1.091,1.077,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.371,1.581,1.340,1.436,1.314,1.273,1.309,1.114,1.122,1.198,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.532,1.423,1.295,1.393,1.360,1.198,1.189,1.280,1.169,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.526,1.409,1.310,1.364,1.266,1.189,1.215,1.201,1.097,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.249,1.462,1.326,1.355,1.310,1.328,1.247,1.270,1.210,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.358,1.217,1.430,1.247,1.317,1.357,1.328,1.373,1.276,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.495,1.308,1.351,1.351,1.233,1.316,1.397,1.396,1.313,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.476,1.249,1.319,1.363,1.395,1.437,1.335,1.108,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.595,1.361,1.334,1.165,1.301,1.233,1.292,-1.000]';
%c
%c +++ NOx data for (bore,stroke) = (1,3); Bore = 6.67; Stroke = 10.44
%c
sclpg(1,3,1:ldptspg,1:rpmptpg,3)=...
     [0.490,0.858,0.977,0.988,0.990,0.992,0.994,0.994,0.995,0.995,0.995,0.995,0.995,0.993,0.995,0.995,
     0.407,0.934,0.938,0.976,0.983,0.995,0.991,0.993,0.991,0.992,0.992,0.992,0.991,0.992,0.992,0.993,
     0.340,0.818,0.926,0.950,0.967,0.979,0.985,0.991,0.991,0.992,0.992,0.993,0.994,0.991,0.991,0.995,
     0.299,0.866,0.886,0.959,0.981,0.981,0.991,0.986,0.988,0.992,0.993,0.994,0.994,0.995,0.994,0.995,
     0.288,0.890,0.905,0.949,0.970,0.979,0.974,0.987,0.985,0.991,0.992,0.992,0.992,0.993,0.993,0.992,
     -1.000,0.949,0.963,0.892,0.943,0.969,0.979,0.973,0.980,0.989,0.991,0.991,0.992,0.992,0.992,0.993,
     -1.000,0.877,0.865,0.900,0.932,0.951,0.950,0.961,0.986,0.981,0.985,0.990,0.990,0.991,0.991,0.992,
     -1.000,0.812,0.896,0.945,0.920,0.938,0.955,0.967,0.965,0.980,0.988,0.988,0.990,0.991,0.992,0.991,
     -1.000,0.795,0.878,0.913,0.960,0.923,0.944,0.958,0.989,0.975,0.982,0.985,0.988,0.990,0.992,0.992,
     -1.000,0.776,0.907,0.891,0.930,0.945,0.957,0.982,0.976,0.990,0.976,0.992,0.984,0.993,0.990,0.991,
     -1.000,0.771,0.920,0.868,0.953,0.935,0.954,0.980,0.966,0.987,0.981,0.985,0.992,0.988,0.988,0.990,
     -1.000,0.695,0.886,0.890,0.917,0.965,0.945,0.959,0.977,0.974,0.980,0.981,0.991,0.988,0.992,0.991,
     -1.000,-1.000,0.793,0.878,0.900,0.920,0.965,0.969,0.960,0.985,0.970,0.989,0.991,0.984,0.987,0.989,
     -1.000,-1.000,0.783,0.867,0.931,0.874,0.983,0.946,0.951,0.976,0.968,0.990,0.978,0.983,0.987,0.993,
     -1.000,-1.000,0.902,0.937,0.937,0.869,0.873,0.934,1.000,0.979,0.965,0.967,0.980,0.984,0.986,0.995,
     -1.000,-1.000,0.790,0.874,0.836,0.907,0.946,0.925,1.004,1.023,0.947,0.960,0.980,0.982,0.985,0.989,
     -1.000,-1.000,0.876,1.062,0.907,0.842,0.957,0.924,0.972,0.951,0.995,1.001,0.975,0.979,0.975,0.975,
     -1.000,-1.000,-1.000,0.918,0.951,0.922,0.863,0.892,0.939,0.965,0.963,0.983,0.986,0.965,0.969,0.977,
     -1.000,-1.000,-1.000,0.991,0.875,0.957,0.865,0.877,0.908,0.983,0.948,0.989,1.004,0.990,1.005,0.993,
     -1.000,-1.000,-1.000,0.788,0.866,0.915,0.854,0.865,0.886,0.956,0.921,0.958,0.971,0.984,0.989,0.988,
     -1.000,-1.000,-1.000,0.867,0.963,0.942,0.903,0.924,0.947,0.922,0.918,0.928,0.947,0.962,0.971,0.976,
     -1.000,-1.000,-1.000,0.808,0.947,0.920,0.948,0.918,0.964,0.886,0.955,0.963,0.932,0.961,0.951,0.971,
     -1.000,-1.000,-1.000,1.091,0.879,0.838,0.940,0.917,0.968,0.936,0.920,0.955,0.921,0.932,0.944,0.953,
     -1.000,-1.000,-1.000,-1.000,0.843,0.880,0.983,1.070,0.918,0.967,0.949,0.958,0.964,0.924,0.977,0.924,
     -1.000,-1.000,-1.000,-1.000,0.878,0.955,0.970,0.940,0.957,0.919,0.977,0.984,0.955,0.909,0.930,0.943,
     -1.000,-1.000,-1.000,-1.000,0.943,0.907,0.875,0.978,1.027,0.965,0.936,0.975,0.947,0.962,0.967,0.972,
     -1.000,-1.000,-1.000,-1.000,0.801,0.875,0.907,0.975,0.942,0.878,0.901,0.961,0.947,0.952,0.962,0.972,
     -1.000,-1.000,-1.000,-1.000,0.791,0.833,0.850,0.921,0.980,0.954,0.921,0.960,0.947,0.941,0.958,0.966,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.859,0.831,0.922,0.776,0.865,0.922,1.069,0.930,0.982,0.951,0.951,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.794,0.835,0.858,0.961,0.968,0.981,0.843,0.897,0.911,0.976,0.948,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.773,0.790,0.881,0.904,0.960,0.861,0.909,0.917,0.895,0.969,0.944,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.861,0.769,0.850,0.889,0.903,0.838,0.890,0.905,0.888,0.870,0.909,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.842,0.930,0.847,0.874,0.899,0.863,0.954,0.939,0.966,0.890,0.988,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.749,0.858,0.766,0.840,0.919,0.904,0.907,0.962,0.923,0.874,0.882,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.728,0.748,0.838,0.820,0.886,0.857,0.953,0.817,0.900,0.863,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.880,0.845,0.931,0.858,0.824,0.831,0.903,0.858,0.913,0.854,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.787,0.849,0.758,0.792,0.842,0.871,0.850,0.890,0.859,0.838,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.550,0.680,0.698,0.783,0.790,0.856,0.916,0.837,0.842,0.884,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.753,0.837,0.887,0.953,0.818,0.838,0.811,0.827,0.840,0.846,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.765,0.859,0.984,0.850,0.869,0.795,0.839,0.801,0.864,0.919,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.802,0.775,0.748,0.770,0.807,0.746,0.798,0.854,0.820,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.687,0.878,0.823,0.878,0.894,0.709,0.813,0.846,0.769,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.671,0.898,0.811,0.872,0.840,0.903,0.738,0.777,0.785,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.682,0.648,0.931,0.729,0.830,0.842,0.887,0.813,0.787,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.774,0.664,0.752,0.908,0.710,0.776,0.882,0.962,0.809,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.769,0.637,0.820,0.798,0.821,0.878,0.725,0.660,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.692,0.731,0.756,0.725,0.873,0.858,0.821,-1.000]';
%c
%c +++ NOx data for (bore,stroke) = (2,1); Bore = 8.20; Stroke = 7.16
%c
sclpg(2,1,1:ldptspg,1:rpmptpg,3)=...
     [1.376,0.949,0.999,1.002,0.996,0.991,0.992,0.992,0.992,0.992,0.992,0.992,0.993,0.991,0.993,0.993,
     1.519,1.000,0.984,0.990,0.991,0.997,0.994,0.993,0.990,0.990,0.989,0.989,0.989,0.989,0.989,0.990,
     1.508,0.969,0.992,1.008,0.993,0.985,0.990,0.994,0.993,0.993,0.992,0.993,0.995,0.991,0.991,0.993,
     1.589,1.030,0.976,1.014,1.022,1.003,0.997,0.996,0.994,0.993,0.992,0.992,0.994,0.992,0.993,0.993,
     1.809,1.029,1.015,1.034,1.019,1.009,1.003,0.997,0.993,0.994,0.993,0.993,0.992,0.992,0.991,0.991,
     -1.000,1.111,1.030,1.013,1.001,1.026,1.014,0.990,0.991,0.995,0.994,0.993,0.992,0.992,0.991,0.991,
     -1.000,1.138,1.089,1.051,1.007,1.004,0.999,0.995,0.999,0.993,0.991,0.993,0.992,0.992,0.991,0.991,
     -1.000,1.178,1.062,1.065,1.042,1.021,1.002,0.997,1.000,0.995,1.001,0.993,0.993,0.992,0.992,0.990,
     -1.000,1.237,1.124,1.053,1.062,1.039,1.025,1.015,1.007,1.001,0.998,0.994,0.994,0.993,0.993,0.993,
     -1.000,1.287,1.152,1.137,1.107,1.030,1.034,1.019,1.000,1.007,1.003,1.000,0.997,0.995,0.994,0.993,
     -1.000,1.377,1.281,1.093,1.089,1.088,1.021,1.030,1.020,1.011,0.998,0.996,0.999,0.996,0.995,0.994,
     -1.000,1.620,1.182,1.207,1.068,1.082,1.081,1.050,1.026,1.006,1.002,1.007,1.002,0.995,0.997,0.994,
     -1.000,-1.000,1.205,1.183,1.182,1.091,1.088,1.063,1.046,1.022,1.021,1.007,1.004,1.001,0.997,0.995,
     -1.000,-1.000,1.260,1.237,1.223,1.074,1.081,1.058,1.039,1.042,1.032,1.021,1.012,1.008,1.004,0.999,
     -1.000,-1.000,1.452,1.219,1.257,1.091,1.066,1.098,1.055,1.055,1.026,1.028,1.012,1.002,1.010,1.006,
     -1.000,-1.000,1.262,1.236,1.147,1.171,1.120,1.113,1.079,1.075,1.020,1.037,1.020,1.013,1.008,1.004,
     -1.000,-1.000,1.436,1.394,1.200,1.137,1.188,1.092,1.101,1.054,1.075,1.033,1.022,1.018,1.003,1.007,
     -1.000,-1.000,-1.000,1.455,1.232,1.158,1.108,1.079,1.089,1.087,1.049,1.053,1.027,1.022,1.021,1.004,
     -1.000,-1.000,-1.000,1.425,1.371,1.226,1.148,1.099,1.077,1.122,1.091,1.069,1.056,1.040,1.031,1.021,
     -1.000,-1.000,-1.000,1.342,1.301,1.269,1.157,1.111,1.089,1.063,1.045,1.057,1.046,1.047,1.035,1.023,
     -1.000,-1.000,-1.000,1.370,1.322,1.340,1.255,1.127,1.129,1.109,1.053,1.041,1.029,1.039,1.029,1.018,
     -1.000,-1.000,-1.000,1.444,1.360,1.379,1.246,1.231,1.142,1.086,1.067,1.049,1.038,1.047,1.019,1.027,
     -1.000,-1.000,-1.000,1.633,1.363,1.295,1.323,1.206,1.199,1.098,1.072,1.056,1.040,1.031,1.022,1.016,
     -1.000,-1.000,-1.000,-1.000,1.425,1.196,1.253,1.229,1.215,1.179,1.143,1.069,1.047,1.036,1.027,1.020,
     -1.000,-1.000,-1.000,-1.000,1.492,1.370,1.270,1.306,1.250,1.188,1.169,1.106,1.083,1.051,1.036,1.031,
     -1.000,-1.000,-1.000,-1.000,1.658,1.464,1.439,1.233,1.230,1.228,1.186,1.118,1.117,1.098,1.049,1.031,
     -1.000,-1.000,-1.000,-1.000,1.537,1.435,1.393,1.273,1.311,1.159,1.173,1.170,1.135,1.111,1.094,1.043,
     -1.000,-1.000,-1.000,-1.000,1.532,1.500,1.368,1.226,1.235,1.286,1.186,1.188,1.123,1.124,1.109,1.071,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.606,1.401,1.277,1.158,1.303,1.215,1.220,1.180,1.161,1.127,1.080,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.526,1.463,1.365,1.410,1.240,1.180,1.152,1.120,1.138,1.140,1.118,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.656,1.479,1.464,1.308,1.273,1.230,1.226,1.182,1.115,1.165,1.110,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.548,1.424,1.516,1.423,1.350,1.332,1.247,1.207,1.141,1.114,1.091,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.847,1.771,1.489,1.398,1.323,1.197,1.232,1.145,1.154,1.127,1.190,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.817,1.610,1.409,1.438,1.410,1.290,1.308,1.224,1.135,1.160,1.133,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.844,1.544,1.500,1.401,1.402,1.226,1.289,1.172,1.305,1.150,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.882,1.599,1.487,1.445,1.370,1.304,1.327,1.245,1.176,1.190,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.884,1.839,1.601,1.429,1.404,1.358,1.252,1.314,1.227,1.221,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.762,1.838,1.519,1.505,1.454,1.405,1.421,1.289,1.255,1.203,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.843,1.688,1.841,1.550,1.511,1.446,1.317,1.287,1.313,1.277,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.884,1.861,1.855,1.757,1.570,1.445,1.441,1.390,1.356,1.337,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,2.041,1.918,1.600,1.702,1.560,1.432,1.451,1.477,1.367,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.986,1.846,1.830,1.698,1.533,1.365,1.478,1.450,1.358,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.822,1.866,1.910,1.781,1.533,1.545,1.416,1.510,1.468,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,2.035,1.570,1.996,1.672,1.733,1.670,1.547,1.562,1.527,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,2.577,1.719,1.749,1.862,1.652,1.813,1.738,1.702,1.594,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.995,1.632,1.691,1.876,1.791,1.744,1.655,1.372,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.992,1.813,1.744,1.712,1.862,1.638,1.635,-1.000]';
%c
%c +++ NOx data for (bore,stroke) = (2,2); Bore = 8.20; Stroke = 8.80
%c
sclpg(2,2,1:ldptspg,1:rpmptpg,3)=...
     [1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,-1.000]';
%c
%c +++ NOx data for (bore,stroke) = (2,3); Bore = 8.20; Stroke = 10.44
%c
sclpg(2,3,1:ldptspg,1:rpmptpg,3)=...
     [0.555,1.012,1.010,1.007,0.997,1.002,1.004,1.005,1.006,1.006,1.006,1.006,1.007,1.005,1.006,1.006,
     0.470,0.991,0.981,0.979,0.992,1.005,1.004,1.005,1.004,1.004,1.005,1.004,1.003,1.004,1.004,1.004,
     0.369,0.957,0.945,0.985,0.983,0.999,0.995,1.002,1.004,1.005,1.006,1.006,1.008,1.005,1.005,1.007,
     0.369,1.001,0.961,0.946,0.985,0.994,0.999,1.002,1.003,1.004,1.005,1.005,1.006,1.007,1.007,1.009,
     0.185,0.966,0.944,0.958,0.960,0.990,0.990,0.996,1.000,1.002,1.004,1.005,1.005,1.005,1.005,1.005,
     -1.000,0.943,0.996,0.957,0.977,0.982,0.992,0.977,0.994,1.002,1.002,1.004,1.005,1.006,1.006,1.008,
     -1.000,0.847,0.926,0.929,0.967,0.936,0.989,0.985,0.992,0.994,0.997,1.003,1.004,1.005,1.005,1.006,
     -1.000,0.746,0.909,0.972,0.943,0.962,0.979,0.992,0.994,0.992,1.009,0.998,1.001,1.004,1.005,1.005,
     -1.000,0.658,0.840,0.930,0.993,0.953,0.974,0.986,0.991,0.996,0.998,0.997,1.004,1.004,1.004,1.005,
     -1.000,0.557,0.769,0.902,0.947,0.967,0.959,0.972,0.974,0.990,0.996,0.998,1.001,1.002,1.003,1.003,
     -1.000,0.422,0.872,0.814,0.924,0.955,0.971,1.002,0.977,0.983,0.982,0.990,0.998,1.001,1.002,1.004,
     -1.000,0.304,0.770,0.829,0.869,0.945,0.960,0.979,1.001,0.964,0.976,0.992,0.995,0.994,1.000,0.999,
     -1.000,-1.000,0.700,0.833,0.824,0.890,0.943,0.961,0.979,0.989,0.993,0.996,1.001,0.990,1.004,0.996,
     -1.000,-1.000,0.701,0.841,0.901,0.868,0.902,0.927,0.950,0.975,0.990,0.997,0.996,0.990,0.989,0.992,
     -1.000,-1.000,0.738,0.778,0.931,0.845,0.860,0.889,0.935,0.970,0.966,0.988,0.983,0.989,1.000,1.001,
     -1.000,-1.000,0.663,0.730,0.759,0.875,0.831,0.870,0.952,0.966,0.942,0.968,0.978,0.984,0.989,0.992,
     -1.000,-1.000,0.550,0.698,0.774,0.799,0.882,0.853,0.902,0.883,0.937,0.954,0.958,0.978,0.976,0.989,
     -1.000,-1.000,-1.000,0.676,0.748,0.770,0.867,0.827,0.869,0.912,0.917,0.932,0.946,0.960,0.970,0.977,
     -1.000,-1.000,-1.000,0.702,0.721,0.790,0.857,0.885,0.887,0.910,0.925,0.946,0.958,0.970,0.988,0.973,
     -1.000,-1.000,-1.000,0.561,0.707,0.787,0.819,0.827,0.859,0.893,0.864,0.911,0.931,0.958,0.952,0.960,
     -1.000,-1.000,-1.000,0.689,0.833,0.747,0.796,0.846,0.840,0.902,0.904,0.873,0.898,0.931,0.949,0.957,
     -1.000,-1.000,-1.000,0.604,0.696,0.735,0.768,0.823,0.862,0.856,0.879,0.858,0.878,0.919,0.921,0.949,
     -1.000,-1.000,-1.000,0.623,0.717,0.681,0.738,0.798,0.839,0.877,0.867,0.895,0.911,0.930,0.906,0.924,
     -1.000,-1.000,-1.000,-1.000,0.568,0.628,0.720,0.767,0.813,0.848,0.883,0.875,0.898,0.917,0.933,0.908,
     -1.000,-1.000,-1.000,-1.000,0.528,0.650,0.629,0.740,0.823,0.825,0.864,0.888,0.911,0.902,0.917,0.938,
     -1.000,-1.000,-1.000,-1.000,0.629,0.623,0.698,0.749,0.738,0.807,0.844,0.833,0.859,0.884,0.900,0.917,
     -1.000,-1.000,-1.000,-1.000,0.565,0.643,0.632,0.692,0.845,0.722,0.797,0.812,0.875,0.900,0.916,0.904,
     -1.000,-1.000,-1.000,-1.000,0.506,0.613,0.682,0.699,0.755,0.872,0.765,0.824,0.834,0.878,0.898,0.883,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.619,0.649,0.764,0.651,0.768,0.738,0.838,0.835,0.860,0.842,0.893,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.572,0.634,0.702,0.828,0.740,0.682,0.720,0.750,0.806,0.852,0.871,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.545,0.655,0.688,0.630,0.743,0.721,0.787,0.751,0.751,0.826,0.820,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.479,0.520,0.652,0.624,0.676,0.724,0.781,0.752,0.728,0.747,0.769,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.422,0.579,0.605,0.662,0.727,0.625,0.731,0.701,0.689,0.748,0.790,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.447,0.592,0.577,0.634,0.721,0.640,0.677,0.741,0.733,0.688,0.736,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.516,0.556,0.683,0.656,0.740,0.646,0.701,0.637,0.782,0.730,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.596,0.560,0.551,0.629,0.630,0.708,0.653,0.705,0.700,0.673,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.463,0.584,0.590,0.564,0.635,0.683,0.596,0.647,0.636,0.710,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.423,0.582,0.609,0.743,0.704,0.661,0.729,0.718,0.736,0.652,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.486,0.534,0.607,0.601,0.644,0.630,0.591,0.653,0.711,0.599,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.327,0.571,0.552,0.639,0.588,0.581,0.639,0.664,0.691,0.606,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.447,0.523,0.564,0.597,0.576,0.586,0.641,0.696,0.678,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.494,0.575,0.560,0.671,0.609,0.589,0.613,0.639,0.619,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.388,0.613,0.534,0.575,0.664,0.747,0.612,0.610,0.630,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.384,0.511,0.640,0.641,0.639,0.716,0.621,0.679,0.635,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.235,0.474,0.524,0.577,0.541,0.658,0.633,0.602,0.589,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.434,0.425,0.546,0.632,0.628,0.693,0.628,0.510,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.529,0.593,0.582,0.597,0.582,0.597,0.578,-1.000]';
%c
%c +++ NOx data for (bore,stroke) = (3,1); Bore = 9.73; Stroke = 7.16
%c
sclpg(3,1,1:ldptspg,1:rpmptpg,3)=...
     [1.570,1.030,1.019,1.010,1.000,0.996,0.998,0.998,0.999,0.998,0.998,0.998,0.999,0.997,0.999,0.999,
     1.698,1.075,1.016,1.008,0.997,1.004,1.000,0.998,0.996,0.996,0.996,0.996,0.995,0.996,0.996,0.996,
     1.629,0.969,1.000,1.014,1.005,1.001,0.997,0.999,0.998,0.998,0.998,0.998,0.999,0.996,0.996,0.998,
     1.828,1.081,1.000,1.016,1.022,1.007,1.003,1.001,1.000,0.999,0.998,0.998,0.998,0.998,0.997,0.998,
     1.629,1.119,1.001,1.043,1.017,1.010,1.006,1.002,1.001,0.999,0.999,0.999,0.998,0.998,0.998,0.998,
     -1.000,1.163,1.087,1.029,0.996,1.025,1.017,0.997,0.998,1.002,0.999,0.999,0.999,0.998,0.998,0.998,
     -1.000,1.181,1.106,1.071,1.052,1.032,1.020,1.000,1.004,0.999,0.998,1.000,0.998,0.998,0.998,0.997,
     -1.000,1.195,1.105,1.107,1.057,1.038,1.027,1.018,1.004,1.002,1.005,0.998,0.999,0.999,0.999,0.997,
     -1.000,1.171,1.078,1.052,1.074,1.055,1.037,1.026,1.015,1.008,1.004,1.001,1.000,0.999,0.999,1.000,
     -1.000,1.180,1.131,1.104,1.080,1.061,1.048,1.030,1.009,1.014,1.009,1.006,1.003,1.001,1.000,0.999,
     -1.000,1.268,1.189,1.044,1.099,1.075,1.028,1.056,1.030,1.019,1.006,1.004,1.006,1.003,1.001,1.000,
     -1.000,1.368,1.132,1.181,1.078,1.095,1.063,1.047,1.050,1.025,1.011,1.014,1.010,1.003,1.003,1.000,
     -1.000,-1.000,1.069,1.104,1.080,1.050,1.067,1.052,1.038,1.027,1.020,1.013,1.005,1.006,1.000,0.999,
     -1.000,-1.000,1.201,1.178,1.135,1.050,1.105,1.038,1.028,1.034,1.017,1.020,1.011,1.009,1.002,1.000,
     -1.000,-1.000,1.310,1.141,1.199,1.068,1.054,1.065,1.051,1.046,1.017,1.024,1.007,1.005,1.009,1.005,
     -1.000,-1.000,1.200,1.136,1.097,1.132,1.101,1.076,1.070,1.054,1.021,1.028,1.020,1.014,1.005,1.002,
     -1.000,-1.000,1.235,1.269,1.126,1.097,1.119,1.078,1.065,1.028,1.058,1.035,1.011,1.017,0.997,1.004,
     -1.000,-1.000,-1.000,1.290,1.249,1.113,1.079,1.064,1.079,1.061,1.030,1.038,1.015,1.013,1.015,1.006,
     -1.000,-1.000,-1.000,1.277,1.258,1.127,1.109,1.076,1.056,1.083,1.063,1.050,1.058,1.019,1.025,1.009,
     -1.000,-1.000,-1.000,1.241,1.192,1.255,1.110,1.086,1.068,1.051,1.037,1.036,1.031,1.036,1.027,1.019,
     -1.000,-1.000,-1.000,1.254,1.267,1.262,1.209,1.088,1.081,1.095,1.049,1.039,1.013,1.024,1.020,1.015,
     -1.000,-1.000,-1.000,1.302,1.225,1.287,1.228,1.192,1.078,1.065,1.053,1.043,1.013,1.048,1.009,1.017,
     -1.000,-1.000,-1.000,1.329,1.164,1.197,1.253,1.119,1.095,1.076,1.060,1.050,1.038,1.032,1.011,1.021,
     -1.000,-1.000,-1.000,-1.000,1.189,1.156,1.162,1.217,1.185,1.116,1.072,1.058,1.046,1.033,1.030,1.023,
     -1.000,-1.000,-1.000,-1.000,1.293,1.288,1.174,1.241,1.200,1.119,1.074,1.065,1.055,1.045,1.034,1.032,
     -1.000,-1.000,-1.000,-1.000,1.480,1.255,1.266,1.161,1.169,1.186,1.120,1.074,1.054,1.051,1.041,1.031,
     -1.000,-1.000,-1.000,-1.000,1.328,1.197,1.269,1.175,1.237,1.113,1.140,1.082,1.064,1.053,1.047,1.043,
     -1.000,-1.000,-1.000,-1.000,1.301,1.281,1.170,1.188,1.153,1.235,1.134,1.160,1.107,1.086,1.053,1.046,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.352,1.176,1.212,1.072,1.185,1.166,1.177,1.149,1.141,1.113,1.096,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.262,1.266,1.172,1.242,1.153,1.121,1.109,1.088,1.112,1.093,1.082,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.338,1.257,1.238,1.195,1.222,1.197,1.169,1.144,1.087,1.140,1.064,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.384,1.251,1.310,1.278,1.179,1.206,1.183,1.161,1.105,1.084,1.074,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.468,1.340,1.268,1.228,1.201,1.108,1.192,1.082,1.106,1.096,1.158,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.456,1.280,1.233,1.239,1.269,1.235,1.164,1.143,1.078,1.113,1.096,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.376,1.262,1.274,1.222,1.261,1.173,1.213,1.138,1.174,1.105,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.355,1.349,1.226,1.315,1.211,1.183,1.222,1.199,1.112,1.131,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.601,1.432,1.465,1.277,1.174,1.161,1.145,1.178,1.121,1.187,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.334,1.411,1.244,1.321,1.326,1.232,1.224,1.188,1.123,1.160,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.232,1.274,1.398,1.338,1.343,1.248,1.175,1.215,1.188,1.132,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.407,1.363,1.499,1.354,1.319,1.225,1.266,1.224,1.220,1.212,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.480,1.344,1.258,1.409,1.372,1.280,1.260,1.309,1.183,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.558,1.364,1.411,1.444,1.326,1.198,1.264,1.262,1.180,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.419,1.541,1.519,1.422,1.295,1.339,1.247,1.346,1.275,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.422,1.274,1.538,1.352,1.389,1.369,1.321,1.365,1.304,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.529,1.391,1.445,1.429,1.298,1.451,1.480,1.404,1.388,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.486,1.340,1.356,1.439,1.465,1.375,1.344,1.160,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.447,1.280,1.248,1.289,1.435,1.305,1.365,-1.000]';
%c
%c +++ NOx data for (bore,stroke) = (3,2); Bore = 9.73; Stroke = 8.80
%c
sclpg(3,2,1:ldptspg,1:rpmptpg,3)=...
     [1.279,1.049,1.043,1.008,1.004,1.005,1.006,1.006,1.007,1.008,1.006,1.008,1.009,1.007,1.009,1.009,
     1.052,1.129,1.031,1.008,1.007,1.013,1.009,1.007,1.005,1.004,1.004,1.004,1.007,1.006,1.004,1.004,
     0.915,1.034,0.951,0.999,0.993,1.000,1.003,1.006,1.006,1.006,1.006,1.007,1.008,1.005,1.005,1.007,
     0.873,1.013,0.964,0.994,1.014,1.012,1.009,1.006,1.006,1.007,1.007,1.008,1.008,1.009,1.009,1.009,
     0.694,1.002,0.982,1.034,1.034,1.001,1.006,1.004,1.005,1.006,1.007,1.007,1.006,1.006,1.006,1.008,
     -1.000,1.034,0.979,0.984,0.995,1.031,1.022,1.005,0.997,1.006,1.006,1.006,1.007,1.007,1.007,1.008,
     -1.000,0.934,0.998,0.975,0.995,0.999,1.003,1.004,1.010,1.005,1.001,1.007,1.006,1.006,1.005,1.007,
     -1.000,0.946,0.984,0.962,0.982,1.008,0.995,0.999,1.002,1.003,1.011,1.005,1.005,1.005,1.006,1.005,
     -1.000,0.906,0.912,0.993,0.964,0.981,1.007,1.012,1.000,1.001,1.003,1.004,1.005,1.005,1.005,1.006,
     -1.000,0.790,0.852,0.996,0.966,0.974,0.987,1.008,0.998,1.008,1.002,1.002,1.005,1.005,1.005,1.005,
     -1.000,0.807,0.945,0.886,0.990,1.031,0.977,1.006,1.013,0.996,1.001,0.997,1.006,1.004,1.004,1.005,
     -1.000,0.686,0.884,0.958,0.941,1.000,0.975,0.985,1.008,0.996,0.998,1.007,1.006,1.003,1.005,1.003,
     -1.000,-1.000,0.840,0.899,0.919,0.943,0.991,1.019,1.005,1.004,0.990,0.997,0.999,1.002,1.001,1.002,
     -1.000,-1.000,0.814,0.920,0.960,0.928,0.947,0.963,0.979,0.999,1.005,1.005,1.002,0.995,1.005,1.003,
     -1.000,-1.000,0.894,0.875,0.942,0.847,0.962,0.931,0.969,1.001,0.983,1.016,0.994,1.004,1.004,1.005,
     -1.000,-1.000,0.815,0.886,0.880,0.919,0.937,0.945,1.001,0.995,0.984,1.004,0.992,1.004,0.997,0.997,
     -1.000,-1.000,0.831,0.846,0.869,0.854,1.006,0.917,0.958,0.948,0.996,1.003,0.990,1.005,0.986,0.998,
     -1.000,-1.000,-1.000,0.896,0.897,0.892,0.912,0.903,0.924,0.957,0.953,0.984,0.986,0.993,0.995,0.987,
     -1.000,-1.000,-1.000,0.885,0.870,0.864,0.906,0.931,0.891,0.966,0.968,0.980,1.002,0.991,1.004,0.996,
     -1.000,-1.000,-1.000,0.759,0.862,0.904,0.891,0.912,0.936,0.960,0.966,0.996,1.006,1.003,0.991,0.992,
     -1.000,-1.000,-1.000,0.784,0.889,0.864,0.951,0.903,0.926,0.943,0.961,0.967,0.961,0.961,0.974,0.981,
     -1.000,-1.000,-1.000,0.658,0.800,0.897,0.934,0.890,0.912,0.935,0.946,0.936,0.973,0.999,0.989,0.987,
     -1.000,-1.000,-1.000,0.946,0.769,0.893,0.879,0.875,0.900,0.955,0.944,0.954,0.962,0.974,0.981,0.987,
     -1.000,-1.000,-1.000,-1.000,0.731,0.786,0.920,0.895,0.959,0.909,0.923,0.945,0.959,0.965,0.976,0.960,
     -1.000,-1.000,-1.000,-1.000,0.768,0.846,0.835,1.018,0.907,0.883,0.917,0.933,0.944,0.982,0.966,0.958,
     -1.000,-1.000,-1.000,-1.000,0.823,0.781,0.869,0.832,0.896,0.916,0.896,0.917,0.931,0.947,0.958,0.964,
     -1.000,-1.000,-1.000,-1.000,0.809,0.733,0.802,0.842,0.907,0.831,0.898,0.969,0.947,0.932,0.950,0.958,
     -1.000,-1.000,-1.000,-1.000,0.694,0.825,0.729,0.828,0.907,0.967,0.909,0.922,0.884,0.918,0.939,0.948,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.770,0.780,0.813,0.803,0.923,0.934,0.902,0.923,0.985,0.926,0.936,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.785,0.764,0.748,0.866,0.889,0.871,0.866,0.882,0.867,0.937,0.920,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.804,0.784,0.785,0.793,0.871,0.830,0.957,0.897,0.883,0.919,0.875,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.684,0.739,0.724,0.857,0.823,0.880,0.850,0.958,0.876,0.887,0.856,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.713,0.780,0.811,0.721,0.831,0.783,0.889,0.831,0.845,0.857,0.932,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.650,0.690,0.638,0.836,0.767,0.850,0.838,0.891,0.875,0.848,0.921,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.670,0.640,0.818,0.784,0.862,0.785,0.856,0.856,0.861,0.905,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.641,0.738,0.721,0.730,0.791,0.754,0.820,0.867,0.840,0.880,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.665,0.729,0.803,0.779,0.747,0.819,0.760,0.814,0.792,0.867,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.630,0.705,0.678,0.807,0.774,0.787,0.779,0.834,0.769,0.837,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.571,0.630,0.820,0.816,0.825,0.769,0.754,0.762,0.744,0.759,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.604,0.722,0.703,0.755,0.830,0.787,0.777,0.794,0.807,0.785,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.701,0.835,0.667,0.730,0.740,0.747,0.775,0.785,0.795,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.579,0.675,0.722,0.771,0.753,0.749,0.826,0.762,0.741,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.584,0.709,0.672,0.745,0.695,0.694,0.729,0.830,0.803,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.559,0.560,0.797,0.714,0.748,0.819,0.753,0.764,0.737,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.637,0.643,0.733,0.749,0.713,0.790,0.772,0.798,0.804,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.689,0.667,0.676,0.718,0.748,0.762,0.766,0.719,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.666,0.695,0.606,0.680,0.770,0.711,0.679,-1.000]';
%c
%c +++ NOx data for (bore,stroke) = (3,3); Bore = 9.73; Stroke = 10.44
%c
sclpg(3,3,1:ldptspg,1:rpmptpg,3)=...
     [0.567,1.023,1.005,1.010,1.009,1.011,1.012,1.013,1.014,1.013,1.015,1.011,1.016,1.011,1.016,1.016,
     0.488,1.042,0.972,0.974,0.992,1.008,1.012,1.013,1.013,1.013,1.013,1.014,1.014,1.014,1.014,1.014,
     0.328,0.941,0.945,0.970,0.989,0.998,1.006,1.011,1.011,1.013,1.014,1.015,1.017,1.014,1.014,1.017,
     0.194,0.886,0.880,0.995,0.989,1.000,0.999,1.010,1.009,1.012,1.013,1.014,1.015,1.016,1.015,1.016,
     0.002,0.818,0.881,0.978,0.976,0.980,0.993,1.000,1.006,1.007,1.011,1.013,1.013,1.014,1.015,1.015,
     -1.000,0.870,0.842,0.902,0.948,0.997,1.007,0.990,1.000,1.006,1.010,1.011,1.013,1.014,1.015,1.016,
     -1.000,0.722,0.925,0.874,0.929,0.930,0.957,0.978,1.004,0.998,1.005,1.012,1.011,1.012,1.013,1.014,
     -1.000,0.584,0.834,0.934,0.888,0.926,0.972,0.976,0.991,0.996,1.010,1.006,1.007,1.010,1.012,1.011,
     -1.000,0.358,0.753,0.875,0.957,0.976,0.939,0.960,0.977,0.988,0.994,1.003,1.006,1.009,1.010,1.011,
     -1.000,0.235,0.670,0.823,0.852,0.939,0.962,0.955,0.964,0.976,0.989,0.996,1.001,1.005,1.007,1.009,
     -1.000,0.127,0.683,0.719,0.864,0.910,0.948,0.959,1.001,0.976,0.990,0.981,0.992,0.998,1.003,1.008,
     -1.000,0.052,0.563,0.736,0.794,0.885,0.927,0.952,0.984,0.983,0.980,0.982,0.985,0.991,0.994,0.998,
     -1.000,-1.000,0.528,0.667,0.724,0.816,0.889,0.929,0.952,0.973,0.965,0.992,0.997,1.002,0.991,0.997,
     -1.000,-1.000,0.486,0.623,0.712,0.756,0.838,0.880,0.920,0.956,0.976,0.987,0.991,1.000,0.994,1.002,
     -1.000,-1.000,0.487,0.631,0.708,0.659,0.760,0.896,0.894,0.941,0.942,0.973,0.978,0.986,0.988,1.002,
     -1.000,-1.000,0.419,0.563,0.594,0.717,0.783,0.805,0.870,0.926,0.913,0.951,0.965,0.977,0.986,0.993,
     -1.000,-1.000,0.295,0.547,0.582,0.644,0.790,0.803,0.813,0.841,0.906,0.935,0.943,0.968,0.970,0.986,
     -1.000,-1.000,-1.000,0.444,0.548,0.604,0.680,0.711,0.823,0.829,0.853,0.901,0.917,0.961,0.963,0.972,
     -1.000,-1.000,-1.000,0.455,0.573,0.596,0.655,0.712,0.713,0.874,0.905,0.900,0.926,0.926,0.958,0.960,
     -1.000,-1.000,-1.000,0.422,0.517,0.605,0.606,0.680,0.704,0.757,0.805,0.831,0.872,0.933,0.932,0.945,
     -1.000,-1.000,-1.000,0.407,0.464,0.589,0.586,0.672,0.705,0.776,0.804,0.847,0.827,0.922,0.942,0.936,
     -1.000,-1.000,-1.000,0.314,0.495,0.533,0.602,0.721,0.679,0.726,0.738,0.786,0.852,0.848,0.881,0.895,
     -1.000,-1.000,-1.000,0.289,0.450,0.487,0.557,0.590,0.632,0.722,0.740,0.814,0.846,0.850,0.882,0.897,
     -1.000,-1.000,-1.000,-1.000,0.361,0.428,0.557,0.666,0.717,0.656,0.704,0.756,0.790,0.797,0.853,0.880,
     -1.000,-1.000,-1.000,-1.000,0.346,0.492,0.560,0.589,0.667,0.725,0.753,0.716,0.758,0.795,0.819,0.874,
     -1.000,-1.000,-1.000,-1.000,0.369,0.428,0.518,0.525,0.629,0.693,0.706,0.707,0.721,0.781,0.815,0.842,
     -1.000,-1.000,-1.000,-1.000,0.287,0.380,0.485,0.492,0.584,0.596,0.684,0.668,0.707,0.716,0.751,0.778,
     -1.000,-1.000,-1.000,-1.000,0.211,0.495,0.421,0.467,0.523,0.614,0.638,0.722,0.645,0.707,0.705,0.739,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.363,0.379,0.503,0.436,0.521,0.598,0.686,0.723,0.765,0.699,0.696,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.323,0.422,0.432,0.506,0.484,0.543,0.586,0.627,0.697,0.739,0.728,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.295,0.436,0.459,0.405,0.508,0.597,0.600,0.621,0.552,0.614,0.619,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.195,0.316,0.387,0.474,0.538,0.535,0.591,0.578,0.589,0.623,0.640,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.028,0.327,0.336,0.417,0.406,0.438,0.506,0.517,0.597,0.608,0.642,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.002,0.314,0.403,0.422,0.451,0.518,0.523,0.532,0.536,0.544,0.616,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.291,0.340,0.432,0.467,0.487,0.511,0.476,0.504,0.582,0.545,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.092,0.326,0.328,0.373,0.425,0.441,0.517,0.464,0.473,0.509,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.037,0.298,0.405,0.387,0.391,0.462,0.478,0.515,0.447,0.494,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.007,0.285,0.420,0.383,0.435,0.466,0.505,0.481,0.507,0.489,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.005,0.211,0.377,0.351,0.406,0.400,0.403,0.449,0.477,0.449,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.003,0.070,0.284,0.375,0.391,0.443,0.431,0.456,0.451,0.465,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.042,0.287,0.337,0.359,0.401,0.426,0.418,0.446,0.443,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.025,0.211,0.360,0.405,0.438,0.364,0.448,0.458,0.395,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.010,0.191,0.349,0.367,0.440,0.413,0.367,0.424,0.478,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.013,0.060,0.262,0.334,0.396,0.341,0.388,0.433,0.423,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.008,0.039,0.211,0.335,0.311,0.422,0.408,0.413,0.409,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.031,0.161,0.264,0.349,0.372,0.379,0.393,0.340,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.024,0.072,0.277,0.400,0.384,0.336,0.362,-1.000]';
%c
%c +++ BSFC S%calar Data +++
%c
%c +++ BSFC data for (bore,stroke) = (1,1); Bore = 6.67; Stroke = 7.16
%c
sclpg(1,1,1:ldptspg,1:rpmptpg,4)=...
     [1.140,1.099,1.066,1.055,1.048,1.037,1.046,1.030,1.035,1.040,1.031,1.023,1.027,1.024,1.027,1.022,
     1.051,1.065,1.039,1.034,1.027,1.036,1.033,1.028,1.028,1.028,1.023,1.025,1.024,1.021,1.026,1.022,
     1.021,1.051,1.042,1.029,1.023,1.022,1.016,1.014,1.015,1.014,1.007,1.005,1.009,1.013,1.011,1.009,
     0.977,1.048,1.038,1.039,1.027,1.022,1.022,1.011,1.021,1.007,1.014,1.007,1.012,1.015,1.011,1.011,
     0.879,1.027,1.039,1.037,1.035,1.028,1.019,1.029,1.020,1.017,1.017,1.018,1.017,1.009,1.016,1.012,
     -1.000,1.036,1.028,1.024,1.023,1.020,1.018,1.016,1.017,1.016,1.019,1.018,1.013,1.008,1.013,1.024,
     -1.000,1.011,1.021,1.029,1.027,1.022,1.020,1.027,1.007,1.010,1.009,1.016,1.014,1.012,1.010,1.013,
     -1.000,0.992,1.013,1.023,1.009,1.013,1.013,1.006,1.022,1.015,1.014,1.007,1.015,1.008,1.009,1.006,
     -1.000,0.973,1.020,1.017,1.014,1.007,1.006,1.005,1.005,1.014,1.016,1.010,1.008,1.008,1.011,1.003,
     -1.000,0.981,0.995,1.012,1.007,1.007,1.006,1.004,1.010,1.006,1.007,1.001,1.010,1.007,1.014,1.009,
     -1.000,0.967,0.968,1.002,1.003,1.012,1.010,1.012,1.012,1.008,1.004,1.006,1.003,1.004,0.998,1.003,
     -1.000,0.938,0.973,0.988,0.989,1.005,1.005,1.005,1.015,1.006,0.999,1.003,1.002,1.004,1.005,1.007,
     -1.000,-1.000,0.955,0.971,0.981,0.998,1.006,1.004,1.006,1.004,1.009,1.011,1.005,1.001,1.002,1.002,
     -1.000,-1.000,0.954,0.975,0.989,1.004,1.000,0.997,1.002,1.012,1.003,1.001,1.003,1.002,1.003,1.000,
     -1.000,-1.000,0.927,0.962,0.964,0.989,0.986,0.990,0.997,1.001,0.999,1.002,0.997,0.995,0.995,0.996,
     -1.000,-1.000,0.917,0.967,0.984,0.979,0.995,1.000,0.987,1.001,0.994,0.998,0.993,0.995,0.998,0.999,
     -1.000,-1.000,0.868,0.949,0.971,0.985,0.975,0.982,0.995,0.995,0.996,0.990,0.994,0.994,0.994,0.991,
     -1.000,-1.000,-1.000,0.938,0.965,0.978,0.991,0.988,0.995,0.997,0.991,0.994,1.000,0.989,0.998,0.990,
     -1.000,-1.000,-1.000,0.924,0.950,0.980,0.976,0.992,0.986,0.988,0.988,0.989,0.990,0.989,0.996,0.990,
     -1.000,-1.000,-1.000,0.908,0.926,0.964,0.977,0.987,0.995,0.994,0.997,0.988,0.985,0.991,0.992,0.999,
     -1.000,-1.000,-1.000,0.905,0.922,0.955,0.983,0.977,0.985,0.988,0.991,0.988,0.989,0.993,0.985,0.993,
     -1.000,-1.000,-1.000,0.892,0.921,0.949,0.967,0.974,0.981,0.982,0.984,0.991,0.985,0.984,0.982,0.989,
     -1.000,-1.000,-1.000,0.839,0.908,0.936,0.958,0.966,0.976,0.977,0.986,0.986,0.990,0.988,0.985,0.985,
     -1.000,-1.000,-1.000,-1.000,0.900,0.920,0.952,0.966,0.972,0.981,0.983,0.983,0.989,0.987,0.980,0.986,
     -1.000,-1.000,-1.000,-1.000,0.884,0.919,0.942,0.966,0.962,0.983,0.977,0.983,0.979,0.986,0.985,0.980,
     -1.000,-1.000,-1.000,-1.000,0.845,0.906,0.938,0.946,0.964,0.971,0.973,0.976,0.980,0.979,0.981,0.987,
     -1.000,-1.000,-1.000,-1.000,0.836,0.889,0.923,0.938,0.955,0.957,0.961,0.974,0.977,0.976,0.978,0.970,
     -1.000,-1.000,-1.000,-1.000,0.814,0.880,0.913,0.939,0.938,0.962,0.961,0.966,0.965,0.979,0.976,0.979,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.878,0.913,0.918,0.941,0.946,0.954,0.961,0.967,0.968,0.971,0.973,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.854,0.891,0.918,0.933,0.949,0.955,0.956,0.961,0.956,0.966,0.970,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.835,0.867,0.913,0.929,0.944,0.945,0.954,0.956,0.955,0.971,0.958,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.799,0.852,0.898,0.916,0.924,0.941,0.949,0.953,0.948,0.948,0.956,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.789,0.850,0.890,0.911,0.918,0.935,0.946,0.939,0.956,0.954,0.957,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.756,0.828,0.876,0.906,0.919,0.927,0.930,0.938,0.948,0.950,0.954,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.810,0.848,0.889,0.915,0.912,0.922,0.930,0.937,0.939,0.950,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.789,0.847,0.878,0.904,0.916,0.934,0.928,0.931,0.931,0.943,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.767,0.831,0.867,0.892,0.910,0.913,0.916,0.929,0.927,0.935,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.734,0.812,0.848,0.865,0.900,0.906,0.909,0.924,0.929,0.934,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.697,0.787,0.831,0.863,0.890,0.901,0.913,0.915,0.920,0.923,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.667,0.760,0.810,0.854,0.883,0.887,0.908,0.917,0.915,0.919,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.737,0.808,0.835,0.876,0.888,0.896,0.902,0.909,0.910,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.702,0.777,0.827,0.850,0.872,0.873,0.895,0.897,0.906,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.695,0.761,0.813,0.838,0.868,0.867,0.883,0.897,0.900,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.672,0.750,0.794,0.832,0.851,0.867,0.872,0.889,0.891,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.635,0.724,0.780,0.814,0.831,0.864,0.873,0.878,0.880,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.706,0.766,0.786,0.829,0.845,0.854,0.876,0.869,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.686,0.745,0.780,0.812,0.840,0.839,0.865,-1.000]';
%c
%c +++ BSFC data for (bore,stroke) = (1,2); Bore = 6.67; Stroke = 8.80
%c
sclpg(1,2,1:ldptspg,1:rpmptpg,4)=...
     [1.174,1.059,1.035,1.034,1.036,1.025,1.020,1.015,1.019,1.023,1.015,1.011,1.015,1.006,1.009,1.007,
     1.132,1.028,1.025,1.020,1.013,1.020,1.023,1.013,1.015,1.013,1.014,1.016,1.011,1.011,1.012,1.011,
     1.157,1.036,1.039,1.027,1.017,1.018,1.006,1.001,1.010,1.005,1.002,0.999,1.004,1.002,1.003,1.004,
     1.109,1.068,1.022,1.037,1.020,1.013,1.016,1.002,1.009,1.004,1.009,1.004,1.003,1.010,1.002,1.003,
     1.043,1.068,1.046,1.040,1.025,1.025,1.009,1.015,1.014,1.010,1.007,1.010,1.006,0.999,1.006,0.999,
     -1.000,1.049,1.028,1.028,1.020,1.007,1.012,1.000,1.013,1.006,1.004,1.004,1.005,1.007,1.005,1.005,
     -1.000,1.030,1.040,1.032,1.029,1.018,1.017,1.017,0.995,1.004,1.005,1.013,1.010,1.005,1.008,1.003,
     -1.000,1.012,1.011,1.017,1.014,1.021,1.014,1.004,1.016,1.011,1.018,1.004,1.011,1.009,1.003,1.005,
     -1.000,1.033,1.035,1.024,1.018,1.013,1.011,1.010,1.012,1.016,1.014,1.012,1.004,1.011,1.009,1.000,
     -1.000,1.025,1.011,1.019,1.015,1.015,1.009,1.015,1.013,1.009,1.006,1.009,1.010,1.003,1.016,1.008,
     -1.000,1.035,0.998,1.018,1.015,1.011,1.012,1.011,1.005,1.010,1.007,1.002,1.002,1.005,0.999,1.001,
     -1.000,1.010,1.016,1.011,1.015,1.006,1.006,1.012,1.014,1.005,1.002,1.008,1.006,1.009,1.000,0.998,
     -1.000,-1.000,1.004,0.995,1.003,1.008,1.008,1.010,1.004,1.003,1.005,1.010,0.997,1.002,1.005,0.998,
     -1.000,-1.000,1.009,1.004,1.007,1.017,1.007,1.000,1.006,1.001,1.009,1.002,1.006,1.000,0.996,0.999,
     -1.000,-1.000,0.987,0.998,0.995,1.016,1.007,1.001,1.006,1.016,1.002,1.003,0.995,0.995,0.993,0.994,
     -1.000,-1.000,0.970,1.006,1.013,0.997,0.996,1.004,0.997,1.002,0.999,0.999,0.996,0.996,0.995,1.001,
     -1.000,-1.000,0.949,0.991,1.007,1.006,0.993,0.998,1.008,1.002,1.003,1.001,1.001,1.003,1.000,0.997,
     -1.000,-1.000,-1.000,1.000,0.996,1.000,1.002,1.004,0.998,1.010,1.000,1.005,1.003,0.999,1.004,0.999,
     -1.000,-1.000,-1.000,0.989,0.995,1.005,0.995,1.007,0.999,0.993,1.001,0.992,0.998,0.998,0.999,0.993,
     -1.000,-1.000,-1.000,0.964,0.974,0.996,0.995,1.001,1.001,1.000,1.005,0.997,0.991,1.000,0.996,1.005,
     -1.000,-1.000,-1.000,0.985,0.974,0.988,1.004,1.005,0.999,1.004,0.997,0.998,0.997,0.994,0.994,1.000,
     -1.000,-1.000,-1.000,0.968,0.983,0.987,1.005,1.003,0.999,1.003,1.002,1.001,0.997,0.988,0.992,0.997,
     -1.000,-1.000,-1.000,0.944,0.987,0.986,0.988,1.000,0.995,0.999,1.000,0.999,0.999,0.995,0.990,0.994,
     -1.000,-1.000,-1.000,-1.000,0.984,0.967,0.979,0.999,0.990,0.996,1.001,0.993,0.997,0.999,0.994,0.994,
     -1.000,-1.000,-1.000,-1.000,0.954,0.970,0.976,0.995,0.995,0.999,0.994,0.997,1.002,0.997,0.996,0.993,
     -1.000,-1.000,-1.000,-1.000,0.931,0.970,0.980,0.983,0.986,0.996,0.999,0.999,0.999,0.994,0.992,0.997,
     -1.000,-1.000,-1.000,-1.000,0.934,0.970,0.972,0.984,0.992,0.984,0.979,0.995,0.994,0.991,0.989,0.988,
     -1.000,-1.000,-1.000,-1.000,0.919,0.956,0.972,0.977,0.977,0.993,0.984,0.993,0.983,0.995,0.988,0.991,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.967,0.990,0.960,0.969,0.980,0.983,0.992,0.989,0.990,0.989,0.991,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.942,0.963,0.969,0.975,0.983,0.986,0.982,0.991,0.987,0.991,0.986,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.931,0.943,0.970,0.975,0.977,0.972,0.982,0.984,0.983,0.990,0.981,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.913,0.935,0.967,0.963,0.965,0.981,0.981,0.982,0.976,0.982,0.978,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.905,0.936,0.964,0.971,0.960,0.979,0.981,0.976,0.978,0.975,0.980,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.889,0.927,0.954,0.958,0.968,0.971,0.968,0.973,0.981,0.981,0.974,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.924,0.939,0.963,0.971,0.968,0.974,0.971,0.979,0.971,0.981,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.911,0.940,0.950,0.957,0.972,0.969,0.964,0.966,0.967,0.970,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.877,0.928,0.945,0.964,0.967,0.963,0.970,0.968,0.961,0.969,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.858,0.918,0.938,0.939,0.953,0.960,0.962,0.963,0.970,0.976,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.842,0.896,0.921,0.951,0.970,0.965,0.969,0.959,0.967,0.965,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.826,0.876,0.907,0.947,0.952,0.957,0.957,0.968,0.958,0.967,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.869,0.908,0.921,0.956,0.958,0.964,0.966,0.970,0.963,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.849,0.894,0.929,0.944,0.954,0.944,0.960,0.959,0.954,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.851,0.887,0.917,0.931,0.936,0.952,0.948,0.966,0.964,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.839,0.876,0.906,0.929,0.944,0.947,0.945,0.955,0.968,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.809,0.864,0.903,0.919,0.930,0.944,0.956,0.954,0.955,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.854,0.891,0.907,0.933,0.942,0.946,0.961,0.948,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.858,0.882,0.908,0.919,0.935,0.931,0.956,-1.000]';
%c
%c +++ BSFC data for (bore,stroke) = (1,3); Bore = 6.67; Stroke = 10.44
%c
sclpg(1,3,1:ldptspg,1:rpmptpg,4)=...
     [1.386,1.066,1.060,1.042,1.040,1.032,1.029,1.018,1.016,1.020,1.015,1.011,1.015,1.011,1.009,1.014,
     1.411,1.048,1.038,1.025,1.019,1.019,1.023,1.013,1.026,1.019,1.019,1.018,1.013,1.012,1.013,1.011,
     1.600,1.078,1.045,1.030,1.021,1.020,1.014,1.004,1.012,1.007,1.002,1.001,1.006,1.003,1.003,1.003,
     1.859,1.058,1.046,1.031,1.033,1.015,1.013,1.006,1.016,1.005,1.009,1.001,1.005,1.008,1.001,1.000,
     2.375,1.068,1.040,1.036,1.026,1.018,1.021,1.018,1.022,1.010,1.006,1.012,1.006,1.002,1.005,1.002,
     -1.000,1.067,1.038,1.028,1.021,1.012,1.007,1.008,1.012,1.009,1.005,1.013,1.002,1.004,1.005,1.009,
     -1.000,1.066,1.051,1.036,1.019,1.016,1.007,1.016,0.998,1.002,1.003,1.006,1.005,1.005,1.004,1.008,
     -1.000,1.076,1.044,1.037,1.017,1.014,1.011,1.004,1.012,1.014,1.010,1.000,1.007,0.999,1.000,1.005,
     -1.000,1.110,1.063,1.035,1.025,1.019,1.012,1.006,1.013,1.014,1.009,1.005,1.001,0.999,1.000,1.001,
     -1.000,1.106,1.061,1.039,1.021,1.014,1.014,1.015,1.010,1.007,1.007,1.003,1.006,1.002,1.007,1.003,
     -1.000,1.150,1.042,1.027,1.027,1.025,1.011,1.015,1.017,1.011,1.008,1.001,1.004,1.009,0.992,0.998,
     -1.000,1.175,1.087,1.038,1.021,1.017,1.018,1.007,1.021,1.006,1.008,1.011,1.011,1.007,1.006,1.002,
     -1.000,-1.000,1.063,1.034,1.030,1.023,1.017,1.019,1.010,1.006,1.015,1.002,0.998,1.007,1.007,1.002,
     -1.000,-1.000,1.108,1.052,1.037,1.032,1.022,1.006,1.014,1.018,1.007,0.996,1.010,1.006,0.996,1.006,
     -1.000,-1.000,1.116,1.065,1.021,1.033,1.011,1.021,1.006,1.008,1.009,1.011,1.001,1.001,0.999,0.993,
     -1.000,-1.000,1.138,1.084,1.049,1.025,1.023,1.025,1.004,1.009,1.007,0.994,0.994,1.002,1.001,0.996,
     -1.000,-1.000,1.129,1.083,1.061,1.044,1.011,1.016,1.009,1.013,1.015,1.006,1.008,0.999,0.998,1.004,
     -1.000,-1.000,-1.000,1.087,1.053,1.038,1.031,1.020,1.013,1.027,1.003,1.011,1.010,1.000,1.006,0.999,
     -1.000,-1.000,-1.000,1.100,1.065,1.048,1.027,1.029,1.014,1.003,1.020,1.000,1.008,1.007,1.003,1.006,
     -1.000,-1.000,-1.000,1.099,1.036,1.054,1.033,1.031,1.025,1.032,1.020,1.010,0.996,1.012,1.005,1.014,
     -1.000,-1.000,-1.000,1.139,1.064,1.044,1.056,1.038,1.025,1.022,1.009,1.009,0.999,1.010,1.001,1.004,
     -1.000,-1.000,-1.000,1.148,1.075,1.055,1.039,1.036,1.033,1.020,1.021,1.023,1.007,1.001,1.003,1.007,
     -1.000,-1.000,-1.000,1.167,1.092,1.054,1.045,1.036,1.025,1.024,1.027,1.027,1.011,1.009,1.007,1.005,
     -1.000,-1.000,-1.000,-1.000,1.094,1.058,1.042,1.048,1.032,1.033,1.022,1.017,1.019,1.015,1.012,1.010,
     -1.000,-1.000,-1.000,-1.000,1.099,1.068,1.051,1.046,1.031,1.036,1.022,1.019,1.023,1.023,1.010,1.002,
     -1.000,-1.000,-1.000,-1.000,1.076,1.066,1.061,1.047,1.043,1.029,1.022,1.027,1.027,1.020,1.019,1.018,
     -1.000,-1.000,-1.000,-1.000,1.127,1.091,1.066,1.049,1.038,1.028,1.022,1.038,1.024,1.025,1.021,1.012,
     -1.000,-1.000,-1.000,-1.000,1.183,1.085,1.074,1.052,1.037,1.032,1.025,1.030,1.018,1.030,1.018,1.017,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.091,1.090,1.042,1.039,1.035,1.022,1.033,1.030,1.021,1.019,1.029,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.111,1.077,1.058,1.053,1.041,1.036,1.031,1.026,1.017,1.022,1.026,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.139,1.086,1.069,1.049,1.048,1.033,1.029,1.027,1.023,1.023,1.018,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.164,1.080,1.083,1.057,1.046,1.043,1.038,1.029,1.024,1.016,1.017,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.220,1.129,1.085,1.060,1.044,1.046,1.047,1.024,1.040,1.016,1.030,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.217,1.148,1.075,1.077,1.056,1.041,1.042,1.040,1.041,1.026,1.022,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.143,1.089,1.079,1.067,1.046,1.044,1.039,1.030,1.024,1.032,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.172,1.142,1.097,1.064,1.056,1.062,1.036,1.043,1.035,1.029,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.180,1.136,1.098,1.070,1.067,1.052,1.038,1.038,1.041,1.030,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.234,1.136,1.102,1.071,1.066,1.051,1.047,1.049,1.048,1.049,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.242,1.178,1.124,1.107,1.070,1.059,1.051,1.048,1.039,1.044,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.328,1.191,1.148,1.108,1.094,1.058,1.060,1.068,1.045,1.038,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.233,1.158,1.128,1.105,1.076,1.064,1.057,1.046,1.046,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.233,1.157,1.130,1.104,1.093,1.057,1.066,1.044,1.048,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.273,1.215,1.130,1.114,1.105,1.091,1.069,1.066,1.062,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.403,1.231,1.159,1.129,1.098,1.098,1.098,1.057,1.052,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.491,1.260,1.194,1.143,1.106,1.116,1.087,1.068,1.056,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.292,1.222,1.148,1.121,1.099,1.085,1.089,1.052,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.384,1.233,1.160,1.141,1.122,1.103,1.098,-1.000]';
%c
%c +++ BSFC data for (bore,stroke) = (2,1); Bore = 8.20; Stroke = 7.16
%c
sclpg(2,1,1:ldptspg,1:rpmptpg,4)=...
     [0.970,1.010,1.023,1.019,1.025,1.018,1.023,1.012,1.016,1.023,1.014,1.014,1.015,1.010,1.015,1.015,
     0.922,1.005,1.001,1.009,1.004,1.019,1.012,1.013,1.019,1.018,1.018,1.022,1.018,1.009,1.022,1.015,
     0.902,1.008,1.014,1.014,1.009,1.012,1.011,1.000,1.012,1.005,1.003,1.003,1.004,1.004,1.007,1.006,
     0.859,1.006,1.008,1.017,1.004,1.004,1.010,1.005,1.014,1.005,1.013,1.005,1.009,1.008,1.008,1.007,
     0.778,0.991,1.007,1.005,1.009,1.010,1.009,1.012,1.012,1.011,1.014,1.013,1.010,1.005,1.010,0.999,
     -1.000,0.985,0.998,0.998,1.006,1.003,1.001,0.998,1.006,1.007,1.008,1.011,1.005,1.009,1.006,1.011,
     -1.000,0.981,0.985,1.002,1.005,1.002,1.001,1.006,0.994,1.001,1.006,1.010,1.008,1.006,1.007,1.011,
     -1.000,0.961,0.980,0.992,0.995,1.005,1.002,1.001,1.008,1.003,1.006,1.000,1.008,1.001,1.001,1.008,
     -1.000,0.951,0.997,0.992,0.993,0.993,0.995,0.999,1.001,1.005,1.007,1.000,1.001,0.998,1.004,1.000,
     -1.000,0.944,0.980,0.999,0.993,0.989,1.001,1.003,1.000,0.993,0.995,0.995,0.997,0.998,1.007,1.002,
     -1.000,0.938,0.947,0.977,0.993,1.000,0.997,0.998,0.998,1.000,0.998,0.995,0.996,1.003,1.001,0.998,
     -1.000,0.905,0.958,0.979,0.992,0.993,0.996,1.001,1.002,0.996,0.997,0.998,0.998,1.003,0.997,1.000,
     -1.000,-1.000,0.935,0.961,0.973,0.988,0.999,1.002,1.002,0.998,1.002,1.005,1.000,1.003,0.994,1.007,
     -1.000,-1.000,0.928,0.963,0.967,0.993,0.989,0.992,0.997,1.003,0.997,1.004,1.006,1.000,1.002,1.002,
     -1.000,-1.000,0.933,0.949,0.956,0.981,0.985,0.981,0.989,1.001,0.997,1.003,0.994,0.997,0.997,0.995,
     -1.000,-1.000,0.899,0.952,0.987,0.971,0.986,0.988,0.979,0.992,0.993,0.999,0.991,0.995,0.996,0.999,
     -1.000,-1.000,0.857,0.944,0.964,0.970,0.969,0.985,0.983,0.987,0.992,0.993,0.992,0.995,0.997,0.998,
     -1.000,-1.000,-1.000,0.932,0.949,0.970,0.979,0.982,0.986,0.995,0.990,0.993,1.000,0.993,0.994,0.997,
     -1.000,-1.000,-1.000,0.925,0.946,0.974,0.965,0.978,0.979,0.978,0.984,0.987,0.996,0.988,0.998,0.989,
     -1.000,-1.000,-1.000,0.896,0.924,0.962,0.970,0.977,0.979,0.987,0.989,0.986,0.979,0.988,0.991,0.998,
     -1.000,-1.000,-1.000,0.906,0.924,0.949,0.977,0.972,0.983,0.979,0.987,0.983,0.986,0.982,0.984,0.996,
     -1.000,-1.000,-1.000,0.897,0.915,0.949,0.961,0.970,0.982,0.980,0.979,0.985,0.982,0.982,0.984,0.983,
     -1.000,-1.000,-1.000,0.854,0.920,0.930,0.957,0.971,0.974,0.972,0.982,0.981,0.983,0.985,0.984,0.981,
     -1.000,-1.000,-1.000,-1.000,0.910,0.928,0.937,0.964,0.975,0.977,0.981,0.975,0.983,0.985,0.985,0.982,
     -1.000,-1.000,-1.000,-1.000,0.886,0.917,0.940,0.961,0.965,0.984,0.973,0.981,0.985,0.975,0.980,0.977,
     -1.000,-1.000,-1.000,-1.000,0.860,0.921,0.936,0.949,0.964,0.971,0.973,0.980,0.986,0.982,0.970,0.986,
     -1.000,-1.000,-1.000,-1.000,0.854,0.909,0.937,0.943,0.961,0.960,0.964,0.976,0.984,0.986,0.979,0.974,
     -1.000,-1.000,-1.000,-1.000,0.831,0.889,0.929,0.946,0.946,0.963,0.961,0.973,0.972,0.983,0.975,0.979,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.896,0.926,0.926,0.938,0.953,0.958,0.962,0.969,0.968,0.973,0.980,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.868,0.910,0.930,0.949,0.946,0.957,0.961,0.967,0.964,0.975,0.977,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.858,0.884,0.931,0.944,0.946,0.945,0.952,0.964,0.962,0.970,0.964,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.836,0.878,0.914,0.928,0.940,0.955,0.955,0.960,0.954,0.960,0.964,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.816,0.881,0.909,0.925,0.935,0.950,0.946,0.949,0.960,0.961,0.958,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.787,0.858,0.896,0.921,0.938,0.946,0.941,0.946,0.954,0.956,0.956,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.852,0.878,0.905,0.927,0.930,0.944,0.953,0.942,0.958,0.960,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.818,0.871,0.893,0.920,0.928,0.945,0.940,0.946,0.940,0.949,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.796,0.860,0.891,0.911,0.936,0.931,0.939,0.948,0.946,0.946,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.769,0.841,0.880,0.890,0.922,0.923,0.928,0.945,0.948,0.946,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.744,0.815,0.863,0.889,0.916,0.917,0.933,0.941,0.934,0.940,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.712,0.794,0.842,0.884,0.905,0.908,0.922,0.930,0.929,0.938,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.778,0.837,0.867,0.905,0.908,0.915,0.921,0.926,0.931,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.747,0.815,0.859,0.884,0.899,0.893,0.924,0.925,0.927,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.748,0.808,0.846,0.874,0.888,0.902,0.912,0.916,0.926,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.727,0.792,0.829,0.865,0.887,0.896,0.899,0.918,0.922,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.700,0.771,0.812,0.848,0.869,0.889,0.904,0.907,0.909,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.746,0.802,0.824,0.867,0.880,0.887,0.911,0.897,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.737,0.787,0.820,0.846,0.871,0.881,0.903,-1.000]';
%c
%c +++ BSFC data for (bore,stroke) = (2,2); Bore = 8.20; Stroke = 8.80
%c
sclpg(2,2,1:ldptspg,1:rpmptpg,4)=...
     [1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.000,1.000,1.000,1.000,1.000,1.000,1.000,-1.000]';
%c
%c +++ BSFC data for (bore,stroke) = (2,3); Bore = 8.20; Stroke = 10.44
%c
sclpg(2,3,1:ldptspg,1:rpmptpg,4)=...
     [1.115,1.009,1.006,1.006,0.994,0.996,0.999,0.994,0.996,1.002,0.998,0.988,0.994,0.995,0.996,0.995,
     1.198,0.997,1.002,0.994,0.988,0.989,1.000,0.992,0.998,0.998,1.002,1.000,1.000,0.997,1.003,1.001,
     1.344,1.020,1.005,1.002,0.999,1.001,0.988,0.988,0.998,0.987,0.986,0.987,0.992,0.994,0.989,0.986,
     1.619,1.008,1.001,1.010,0.998,0.997,0.996,0.994,1.002,0.992,0.997,0.988,0.999,1.003,0.995,0.988,
     2.332,1.009,1.007,1.011,1.007,1.007,0.995,1.001,1.001,1.002,0.998,1.001,0.994,0.993,0.996,0.994,
     -1.000,1.020,1.015,1.003,1.000,1.002,0.997,0.999,1.002,1.001,0.998,1.002,0.993,0.994,1.001,1.000,
     -1.000,1.030,1.035,1.015,1.001,1.010,1.002,1.007,0.993,0.992,0.997,1.000,0.999,1.003,1.000,0.999,
     -1.000,1.041,1.013,1.017,1.002,1.006,0.999,0.987,1.000,1.003,1.004,0.999,1.004,1.001,0.996,1.003,
     -1.000,1.078,1.046,1.024,1.010,1.003,0.996,0.997,1.001,0.997,1.006,1.006,0.995,0.995,1.005,0.996,
     -1.000,1.131,1.032,1.020,1.004,1.008,1.003,1.003,0.998,1.001,0.997,0.998,0.997,0.999,1.004,1.002,
     -1.000,1.190,1.042,1.027,1.020,1.011,1.010,1.007,1.001,1.004,1.003,0.994,0.998,0.998,0.995,0.995,
     -1.000,1.387,1.098,1.027,1.022,1.010,1.014,1.005,1.011,1.002,1.001,0.998,1.000,1.002,0.998,1.003,
     -1.000,-1.000,1.096,1.040,1.011,1.013,1.014,1.010,1.006,1.004,1.005,1.007,1.001,1.002,0.999,1.011,
     -1.000,-1.000,1.126,1.063,1.041,1.026,1.012,1.007,1.005,1.018,1.003,0.994,1.005,1.010,1.001,1.005,
     -1.000,-1.000,1.153,1.068,1.028,1.039,1.019,1.003,1.006,1.008,1.003,1.002,1.000,1.000,0.997,1.003,
     -1.000,-1.000,1.167,1.097,1.073,1.027,1.019,1.014,1.002,1.003,1.002,1.006,0.996,1.001,1.000,1.007,
     -1.000,-1.000,1.202,1.118,1.078,1.048,1.025,1.010,1.014,1.007,1.011,1.009,0.999,1.001,1.003,1.002,
     -1.000,-1.000,-1.000,1.113,1.075,1.059,1.033,1.034,1.016,1.022,1.009,1.006,1.009,1.004,1.002,1.004,
     -1.000,-1.000,-1.000,1.157,1.089,1.068,1.032,1.034,1.023,1.011,1.015,1.007,1.003,1.004,1.011,1.001,
     -1.000,-1.000,-1.000,1.185,1.097,1.060,1.055,1.038,1.038,1.029,1.019,1.013,1.006,1.014,1.008,1.017,
     -1.000,-1.000,-1.000,1.260,1.146,1.072,1.060,1.040,1.037,1.031,1.024,1.017,1.014,1.014,1.005,1.015,
     -1.000,-1.000,-1.000,1.325,1.165,1.112,1.064,1.042,1.036,1.031,1.035,1.022,1.019,1.013,1.011,1.011,
     -1.000,-1.000,-1.000,1.367,1.188,1.108,1.079,1.054,1.044,1.031,1.032,1.027,1.028,1.029,1.014,1.009,
     -1.000,-1.000,-1.000,-1.000,1.241,1.112,1.085,1.064,1.048,1.047,1.036,1.029,1.029,1.031,1.026,1.015,
     -1.000,-1.000,-1.000,-1.000,1.256,1.146,1.091,1.074,1.061,1.050,1.039,1.037,1.029,1.032,1.032,1.021,
     -1.000,-1.000,-1.000,-1.000,1.282,1.183,1.107,1.084,1.059,1.050,1.041,1.041,1.040,1.031,1.035,1.035,
     -1.000,-1.000,-1.000,-1.000,1.413,1.205,1.123,1.092,1.082,1.048,1.037,1.044,1.038,1.031,1.033,1.023,
     -1.000,-1.000,-1.000,-1.000,1.494,1.221,1.162,1.102,1.069,1.065,1.046,1.050,1.034,1.039,1.035,1.038,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.308,1.184,1.131,1.090,1.073,1.056,1.049,1.041,1.043,1.043,1.038,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.352,1.184,1.142,1.123,1.082,1.060,1.056,1.051,1.040,1.043,1.041,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.429,1.223,1.169,1.118,1.098,1.072,1.064,1.054,1.045,1.049,1.039,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.534,1.234,1.189,1.140,1.107,1.083,1.088,1.064,1.044,1.044,1.045,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.786,1.343,1.195,1.151,1.105,1.102,1.081,1.069,1.067,1.057,1.050,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.890,1.411,1.259,1.159,1.121,1.097,1.080,1.071,1.067,1.052,1.056,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.436,1.261,1.191,1.140,1.110,1.098,1.084,1.076,1.071,1.078,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.608,1.295,1.195,1.154,1.147,1.118,1.085,1.077,1.071,1.078,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.706,1.387,1.244,1.182,1.153,1.114,1.095,1.093,1.082,1.076,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.979,1.474,1.287,1.207,1.156,1.126,1.112,1.102,1.095,1.089,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,2.414,1.594,1.311,1.212,1.182,1.138,1.133,1.112,1.100,1.096,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,3.520,1.703,1.371,1.258,1.210,1.148,1.131,1.119,1.100,1.097,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.904,1.421,1.270,1.211,1.179,1.141,1.124,1.114,1.107,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,2.198,1.510,1.323,1.249,1.183,1.152,1.139,1.117,1.120,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,2.777,1.640,1.373,1.268,1.212,1.176,1.163,1.127,1.123,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,4.219,1.835,1.431,1.335,1.235,1.194,1.174,1.147,1.137,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,10.898,2.066,1.474,1.351,1.239,1.209,1.182,1.153,1.138,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,2.400,1.617,1.391,1.293,1.212,1.200,1.182,1.149,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,3.266,1.832,1.539,1.329,1.250,1.188,1.179,-1.000]';
%c
%c +++ BSFC data for (bore,stroke) = (3,1); Bore = 9.73; Stroke = 7.16
%c
sclpg(3,1,1:ldptspg,1:rpmptpg,4)=...
     [0.926,0.985,1.010,1.007,1.007,1.001,1.012,1.002,1.007,1.010,1.004,1.005,1.011,1.005,1.008,1.012,
     0.886,0.979,0.984,0.993,0.995,1.003,1.004,1.004,1.014,1.012,1.012,1.012,1.013,1.012,1.017,1.013,
     0.869,0.983,0.994,0.994,1.002,1.002,1.001,0.997,1.003,1.002,0.996,1.001,1.008,1.008,1.005,1.002,
     0.858,0.985,0.998,1.001,1.004,0.996,1.001,0.996,1.002,0.997,0.999,0.999,1.002,1.008,1.001,1.005,
     0.809,0.979,0.992,1.005,0.998,1.005,1.003,1.009,1.006,1.000,1.002,1.009,0.998,0.995,1.000,1.002,
     -1.000,0.976,0.988,0.999,1.004,1.002,0.997,1.007,1.008,1.007,1.009,1.009,1.009,1.007,1.007,1.012,
     -1.000,0.966,0.984,0.994,0.991,0.997,1.002,1.001,0.997,1.001,1.007,1.012,1.010,1.010,1.010,1.013,
     -1.000,0.964,0.979,1.004,0.999,1.000,1.000,0.997,1.008,1.008,1.011,1.006,1.013,1.006,1.005,1.009,
     -1.000,0.954,1.000,0.995,0.997,0.990,0.997,0.998,1.004,1.008,1.010,1.008,1.004,1.003,1.010,1.003,
     -1.000,0.958,0.981,0.993,0.998,0.992,0.993,1.000,1.002,1.001,1.003,1.001,1.008,1.009,1.008,1.008,
     -1.000,0.964,0.963,0.984,0.996,0.995,1.002,1.005,1.002,1.007,1.000,0.999,1.004,1.010,1.010,1.007,
     -1.000,0.934,0.977,0.990,0.985,0.991,1.003,0.998,1.009,1.003,0.999,1.005,0.997,0.999,1.006,1.002,
     -1.000,-1.000,0.960,0.975,0.986,0.999,1.001,1.003,1.006,1.008,1.005,1.006,1.001,1.007,1.008,1.010,
     -1.000,-1.000,0.974,0.974,0.988,1.007,0.998,0.995,0.995,1.008,0.997,1.003,1.010,1.003,1.004,1.005,
     -1.000,-1.000,0.953,0.963,0.977,0.994,0.998,0.999,1.006,0.996,0.999,1.001,1.000,1.000,0.996,1.005,
     -1.000,-1.000,0.933,0.967,0.992,0.984,0.993,1.000,0.993,1.001,1.001,1.005,1.000,1.003,1.002,1.004,
     -1.000,-1.000,0.896,0.964,0.981,0.987,0.986,0.996,1.000,1.002,1.006,0.997,1.006,1.010,1.009,1.004,
     -1.000,-1.000,-1.000,0.968,0.977,0.984,0.997,0.996,1.000,1.006,1.002,1.006,1.010,1.004,1.011,1.007,
     -1.000,-1.000,-1.000,0.946,0.974,0.988,0.987,0.997,0.999,0.999,1.001,1.002,1.000,1.002,1.006,1.009,
     -1.000,-1.000,-1.000,0.939,0.960,0.989,0.992,0.995,1.000,1.005,1.007,1.001,0.994,1.005,1.009,1.013,
     -1.000,-1.000,-1.000,0.947,0.963,0.978,1.000,0.999,0.994,0.999,1.000,0.999,1.002,1.004,1.003,1.003,
     -1.000,-1.000,-1.000,0.951,0.960,0.984,0.993,0.992,0.998,1.005,1.002,1.005,1.007,0.999,0.998,1.006,
     -1.000,-1.000,-1.000,0.915,0.955,0.965,0.987,0.992,0.995,0.999,1.002,1.003,1.004,1.004,0.999,1.002,
     -1.000,-1.000,-1.000,-1.000,0.961,0.965,0.978,0.997,0.998,1.002,0.999,1.000,1.003,1.009,0.999,1.002,
     -1.000,-1.000,-1.000,-1.000,0.936,0.965,0.976,0.990,0.994,1.005,1.000,1.000,1.001,1.000,1.003,0.997,
     -1.000,-1.000,-1.000,-1.000,0.918,0.952,0.971,0.977,0.994,1.001,1.003,0.997,1.007,1.000,1.003,1.008,
     -1.000,-1.000,-1.000,-1.000,0.919,0.955,0.971,0.980,0.994,0.989,0.989,0.997,1.000,1.006,1.001,0.996,
     -1.000,-1.000,-1.000,-1.000,0.913,0.945,0.970,0.980,0.983,0.987,0.996,1.002,0.996,1.007,1.003,1.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.952,0.969,0.965,0.976,0.984,0.986,0.996,0.999,0.998,1.002,1.004,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.934,0.955,0.969,0.978,0.985,0.992,0.990,0.996,0.994,1.006,1.005,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.925,0.937,0.971,0.978,0.985,0.984,0.986,0.989,0.991,1.001,0.997,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.908,0.932,0.968,0.968,0.979,0.986,0.984,0.987,0.984,0.992,0.992,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.914,0.926,0.968,0.970,0.976,0.985,0.987,0.986,0.994,0.989,0.993,
     -1.000,-1.000,-1.000,-1.000,-1.000,0.875,0.935,0.955,0.973,0.974,0.982,0.978,0.988,0.988,0.989,0.988,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.923,0.937,0.964,0.981,0.974,0.983,0.982,0.985,0.987,0.994,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.908,0.939,0.958,0.969,0.980,0.986,0.985,0.987,0.973,0.986,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.904,0.942,0.952,0.962,0.977,0.978,0.976,0.980,0.974,0.984,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.871,0.927,0.941,0.946,0.967,0.975,0.976,0.979,0.986,0.984,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.857,0.897,0.927,0.944,0.964,0.970,0.973,0.977,0.982,0.983,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.833,0.887,0.919,0.946,0.954,0.959,0.965,0.982,0.974,0.978,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.879,0.919,0.935,0.955,0.962,0.968,0.974,0.970,0.971,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.864,0.897,0.938,0.946,0.960,0.955,0.979,0.972,0.980,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.857,0.897,0.924,0.935,0.955,0.962,0.965,0.971,0.974,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.845,0.892,0.918,0.939,0.949,0.950,0.966,0.976,0.967,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.814,0.867,0.907,0.923,0.936,0.955,0.965,0.963,0.962,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.856,0.898,0.921,0.937,0.955,0.957,0.970,0.960,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.855,0.894,0.911,0.922,0.942,0.940,0.964,-1.000]';
%c
%c +++ BSFC data for (bore,stroke) = (3,2); Bore = 9.73; Stroke = 8.80
%c
sclpg(3,2,1:ldptspg,1:rpmptpg,4)=...
     [0.930,0.966,0.994,0.983,0.995,0.992,0.995,0.990,0.990,1.000,0.996,0.993,0.999,0.995,0.997,0.999,
     0.971,0.974,0.982,0.978,0.980,0.988,0.992,0.993,1.000,1.001,1.001,1.005,1.000,1.007,1.008,1.005,
     0.985,0.979,0.987,0.994,0.987,0.990,0.988,0.984,0.992,0.989,0.984,0.991,0.992,0.993,0.994,0.994,
     1.032,0.989,0.990,0.997,0.993,0.990,0.994,0.995,1.004,0.988,0.994,0.989,0.994,0.995,0.994,0.996,
     1.119,0.982,0.999,1.004,0.998,1.005,0.991,1.005,1.005,1.002,1.002,1.010,1.001,0.998,0.998,1.001,
     -1.000,0.991,0.997,1.002,1.000,0.993,0.995,0.996,1.004,0.998,0.997,1.001,1.008,1.003,1.004,1.006,
     -1.000,0.999,1.002,1.010,0.995,0.998,0.995,0.993,0.992,0.999,0.993,1.002,1.008,1.014,1.009,1.005,
     -1.000,1.003,1.004,0.996,0.996,1.004,1.003,1.000,1.003,1.003,1.004,0.999,1.008,1.000,1.003,1.010,
     -1.000,1.006,1.022,1.002,1.007,1.000,1.005,0.998,1.000,1.009,1.010,1.004,1.000,1.000,1.007,1.002,
     -1.000,1.040,1.014,1.018,0.995,1.002,0.998,1.004,1.003,1.005,1.003,1.009,0.995,1.004,1.007,1.006,
     -1.000,1.054,1.000,1.015,1.003,1.009,1.011,1.014,1.001,1.009,1.005,1.000,0.990,1.004,1.006,1.003,
     -1.000,1.067,1.035,1.017,1.006,1.011,1.008,1.002,1.009,1.006,1.008,1.008,1.012,0.997,1.007,1.011,
     -1.000,-1.000,1.041,1.014,1.014,1.012,1.011,1.017,1.006,1.012,1.010,1.005,1.004,0.999,1.009,1.008,
     -1.000,-1.000,1.055,1.031,1.012,1.023,1.015,1.011,1.006,1.013,1.005,1.007,1.011,1.016,1.007,1.017,
     -1.000,-1.000,1.050,1.020,1.015,1.027,1.005,1.008,1.011,1.008,1.014,1.007,1.006,1.012,1.009,1.006,
     -1.000,-1.000,1.080,1.042,1.038,1.022,1.016,1.022,1.000,1.012,1.008,1.010,1.003,1.010,1.004,1.017,
     -1.000,-1.000,1.059,1.064,1.041,1.032,1.011,1.006,1.010,1.011,1.012,1.005,1.010,1.008,1.013,1.006,
     -1.000,-1.000,-1.000,1.049,1.036,1.027,1.030,1.023,1.011,1.024,1.017,1.007,1.016,1.011,1.014,1.014,
     -1.000,-1.000,-1.000,1.084,1.046,1.040,1.028,1.020,1.011,1.010,1.014,1.010,1.014,1.009,1.017,1.016,
     -1.000,-1.000,-1.000,1.085,1.046,1.049,1.033,1.033,1.030,1.016,1.022,1.018,1.010,1.018,1.014,1.021,
     -1.000,-1.000,-1.000,1.147,1.048,1.053,1.044,1.029,1.025,1.021,1.021,1.019,1.012,1.014,1.010,1.012,
     -1.000,-1.000,-1.000,1.170,1.085,1.060,1.050,1.033,1.029,1.027,1.029,1.024,1.018,1.018,1.012,1.022,
     -1.000,-1.000,-1.000,1.191,1.094,1.054,1.048,1.037,1.029,1.031,1.020,1.024,1.026,1.023,1.019,1.017,
     -1.000,-1.000,-1.000,-1.000,1.107,1.059,1.040,1.047,1.037,1.027,1.029,1.026,1.022,1.025,1.017,1.023,
     -1.000,-1.000,-1.000,-1.000,1.129,1.074,1.061,1.045,1.038,1.038,1.027,1.029,1.030,1.029,1.023,1.016,
     -1.000,-1.000,-1.000,-1.000,1.159,1.083,1.061,1.039,1.043,1.042,1.040,1.033,1.034,1.029,1.028,1.032,
     -1.000,-1.000,-1.000,-1.000,1.209,1.119,1.068,1.058,1.057,1.036,1.025,1.040,1.039,1.035,1.026,1.024,
     -1.000,-1.000,-1.000,-1.000,1.259,1.125,1.083,1.057,1.040,1.051,1.036,1.041,1.025,1.036,1.027,1.025,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.163,1.109,1.054,1.049,1.034,1.040,1.047,1.040,1.034,1.028,1.030,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.182,1.105,1.078,1.057,1.049,1.052,1.039,1.041,1.031,1.040,1.035,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.245,1.118,1.102,1.069,1.062,1.040,1.044,1.042,1.037,1.045,1.035,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.251,1.143,1.102,1.076,1.049,1.057,1.059,1.050,1.030,1.034,1.041,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.326,1.179,1.124,1.077,1.073,1.055,1.048,1.046,1.048,1.047,1.045,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.369,1.218,1.150,1.107,1.078,1.061,1.045,1.047,1.041,1.040,1.047,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.252,1.160,1.113,1.089,1.068,1.050,1.064,1.044,1.037,1.048,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.270,1.172,1.121,1.094,1.087,1.066,1.048,1.051,1.051,1.054,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.308,1.204,1.143,1.108,1.080,1.069,1.059,1.056,1.048,1.051,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.401,1.232,1.164,1.097,1.073,1.079,1.066,1.065,1.057,1.074,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.453,1.251,1.178,1.117,1.097,1.082,1.076,1.077,1.070,1.056,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.574,1.285,1.174,1.135,1.112,1.090,1.078,1.079,1.068,1.058,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.308,1.224,1.149,1.127,1.096,1.098,1.079,1.081,1.072,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.410,1.220,1.179,1.126,1.112,1.087,1.093,1.078,1.077,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.527,1.268,1.176,1.141,1.123,1.105,1.104,1.093,1.088,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.678,1.313,1.209,1.180,1.138,1.112,1.107,1.106,1.097,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.951,1.414,1.251,1.168,1.132,1.136,1.105,1.095,1.092,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.466,1.293,1.185,1.156,1.127,1.114,1.118,1.094,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.569,1.314,1.213,1.144,1.132,1.116,1.118,-1.000]';
%c
%c +++ BSFC data for (bore,stroke) = (3,3); Bore = 9.73; Stroke = 10.44
%c
sclpg(3,3,1:ldptspg,1:rpmptpg,4)=...
     [1.062,0.980,0.986,0.976,0.985,0.984,0.990,0.982,0.992,0.992,0.992,0.986,0.995,0.987,0.993,0.992,
     1.154,0.977,0.982,0.971,0.972,0.980,0.983,0.985,0.992,0.989,0.989,0.994,0.994,0.989,0.995,0.993,
     1.401,0.987,0.991,0.984,0.985,0.987,0.986,0.983,0.991,0.985,0.985,0.987,0.990,0.988,0.990,0.982,
     1.965,1.005,1.007,1.007,0.993,0.994,0.995,0.984,0.993,0.986,0.996,0.985,0.993,0.995,0.992,0.989,
     -1.000,1.015,1.013,1.007,1.006,0.997,0.996,1.002,0.998,0.998,0.990,1.003,0.999,0.995,0.997,0.993,
     -1.000,1.023,1.026,1.009,0.996,1.002,0.997,0.999,0.999,0.995,1.005,1.003,0.997,0.998,1.000,1.002,
     -1.000,1.053,1.023,1.025,1.005,1.008,1.004,1.000,0.995,1.000,0.999,1.006,1.001,0.998,1.006,1.000,
     -1.000,1.106,1.039,1.020,1.011,1.009,1.013,1.001,0.994,1.008,1.005,1.003,1.010,1.001,1.007,1.005,
     -1.000,1.164,1.060,1.027,1.017,1.016,0.999,1.007,1.007,1.009,1.021,1.001,1.001,1.001,1.006,1.002,
     -1.000,1.301,1.072,1.045,1.032,1.010,1.014,1.021,1.018,1.013,1.004,1.003,1.005,1.005,1.010,1.010,
     -1.000,1.654,1.097,1.048,1.025,1.016,1.012,1.022,1.009,1.016,1.013,1.004,1.010,1.007,1.004,1.009,
     -1.000,3.553,1.156,1.065,1.031,1.023,1.016,1.011,1.019,1.011,1.011,1.019,1.001,1.019,1.006,1.011,
     -1.000,-1.000,1.195,1.078,1.042,1.033,1.029,1.019,1.017,1.007,1.016,1.013,1.015,1.000,1.019,1.011,
     -1.000,-1.000,1.246,1.113,1.066,1.042,1.031,1.022,1.013,1.015,1.010,1.007,1.014,1.004,1.012,1.020,
     -1.000,-1.000,1.316,1.160,1.071,1.054,1.029,1.022,1.018,1.019,1.019,1.016,1.005,1.011,1.016,1.017,
     -1.000,-1.000,1.397,1.215,1.119,1.067,1.044,1.030,1.018,1.021,1.018,1.017,1.010,1.012,1.011,1.014,
     -1.000,-1.000,1.556,1.251,1.146,1.085,1.038,1.042,1.032,1.023,1.025,1.014,1.010,1.012,1.015,1.016,
     -1.000,-1.000,-1.000,1.312,1.159,1.109,1.075,1.057,1.044,1.038,1.025,1.021,1.036,1.023,1.014,1.017,
     -1.000,-1.000,-1.000,1.387,1.201,1.127,1.075,1.070,1.042,1.037,1.035,1.034,1.020,1.022,1.020,1.019,
     -1.000,-1.000,-1.000,1.515,1.219,1.167,1.098,1.073,1.067,1.056,1.043,1.039,1.020,1.032,1.022,1.030,
     -1.000,-1.000,-1.000,1.673,1.276,1.178,1.125,1.080,1.068,1.061,1.049,1.039,1.033,1.031,1.024,1.035,
     -1.000,-1.000,-1.000,1.899,1.380,1.222,1.147,1.110,1.064,1.062,1.062,1.050,1.041,1.036,1.036,1.037,
     -1.000,-1.000,-1.000,2.452,1.485,1.233,1.181,1.119,1.089,1.071,1.064,1.054,1.057,1.052,1.042,1.044,
     -1.000,-1.000,-1.000,-1.000,1.635,1.270,1.184,1.148,1.099,1.079,1.074,1.055,1.057,1.053,1.052,1.042,
     -1.000,-1.000,-1.000,-1.000,1.754,1.367,1.224,1.163,1.119,1.109,1.091,1.071,1.065,1.055,1.058,1.053,
     -1.000,-1.000,-1.000,-1.000,2.147,1.432,1.254,1.183,1.141,1.118,1.113,1.083,1.072,1.073,1.065,1.064,
     -1.000,-1.000,-1.000,-1.000,2.747,1.563,1.318,1.198,1.163,1.128,1.105,1.094,1.087,1.077,1.071,1.064,
     -1.000,-1.000,-1.000,-1.000,4.249,1.851,1.369,1.261,1.169,1.143,1.120,1.100,1.094,1.087,1.083,1.072,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.988,1.444,1.259,1.196,1.149,1.131,1.107,1.102,1.096,1.088,1.080,
     -1.000,-1.000,-1.000,-1.000,-1.000,2.379,1.562,1.318,1.232,1.180,1.145,1.126,1.124,1.100,1.115,1.112,
     -1.000,-1.000,-1.000,-1.000,-1.000,3.078,1.716,1.406,1.280,1.193,1.158,1.137,1.118,1.103,1.112,1.102,
     -1.000,-1.000,-1.000,-1.000,-1.000,5.350,1.863,1.413,1.303,1.206,1.194,1.150,1.133,1.124,1.110,1.111,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,2.169,1.548,1.344,1.253,1.201,1.166,1.148,1.143,1.125,1.119,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,2.560,1.707,1.437,1.278,1.220,1.187,1.158,1.159,1.134,1.135,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,3.676,1.817,1.471,1.348,1.227,1.204,1.167,1.160,1.141,1.150,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.973,1.546,1.367,1.272,1.238,1.195,1.178,1.160,1.159,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,2.494,1.714,1.400,1.315,1.252,1.215,1.192,1.166,1.180,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,3.290,1.908,1.493,1.368,1.309,1.217,1.200,1.191,1.195,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,4.533,2.053,1.562,1.384,1.306,1.255,1.234,1.203,1.197,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,2.298,1.724,1.473,1.355,1.288,1.266,1.212,1.206,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,2.882,1.789,1.520,1.388,1.303,1.266,1.230,1.214,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,4.027,2.074,1.635,1.480,1.329,1.297,1.261,1.242,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,7.293,2.378,1.731,1.505,1.379,1.321,1.309,1.252,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,3.024,1.897,1.577,1.441,1.343,1.305,1.293,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,3.755,2.077,1.625,1.512,1.406,1.327,1.297,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,6.047,2.296,1.752,1.551,1.442,1.388,1.315,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,2.865,2.037,1.662,1.474,1.417,-1.000]';
%c
%c +++ Brake Torque Data +++
%c
%c +++ Brake Torque data for (bore,stroke) = (1,1); Bore = 6.67; Stroke = 7.16
%c
sclpg(1,1,1:ldptspg,1:rpmptpg,5)=...
     [1.114,2.865,4.377,5.730,7.082,8.435,9.748,11.141,12.454,13.807,15.239,16.632,18.024,19.337,20.690,22.242,
     1.125,2.899,4.331,5.661,7.026,8.356,9.720,11.084,12.516,13.881,15.313,16.643,18.075,19.406,20.770,22.168,
     1.074,2.895,4.297,5.640,7.013,8.385,9.758,11.071,12.533,13.846,15.249,16.681,18.054,19.367,20.770,22.142,
     1.008,2.838,4.165,5.517,6.897,8.276,9.629,11.061,12.388,13.846,15.173,16.579,17.931,19.337,20.637,22.043,
     0.955,2.793,4.106,5.443,6.780,8.189,9.549,10.886,12.295,13.679,15.040,16.473,17.738,19.194,20.531,21.940,
     -1.000,2.669,4.015,5.382,6.728,8.117,9.462,10.851,12.240,13.608,14.953,16.364,17.753,19.207,20.531,21.725,
     -1.000,2.626,3.959,5.292,6.625,7.998,9.370,10.683,12.136,13.488,14.921,16.254,17.646,19.059,20.451,21.784,
     -1.000,2.534,3.838,5.179,6.611,7.988,9.329,10.743,11.992,13.424,14.820,16.215,17.593,18.952,20.292,21.816,
     -1.000,2.473,3.769,5.099,6.497,7.895,9.276,10.658,12.056,13.369,14.750,16.097,17.513,18.860,20.207,21.691,
     -1.000,2.355,3.692,5.029,6.398,7.767,9.151,10.584,11.921,13.305,14.658,16.138,17.380,18.796,20.149,21.534,
     -1.000,2.283,3.581,4.924,6.311,7.654,9.042,10.400,11.743,13.190,14.593,15.876,17.353,18.741,20.173,21.441,
     -1.000,2.177,3.525,4.845,6.263,7.541,8.945,10.308,11.656,13.046,14.549,15.883,17.273,18.621,19.913,21.303,
     -1.000,-1.000,3.382,4.775,6.141,7.467,8.807,10.226,11.539,12.945,14.258,15.624,17.003,18.462,19.815,21.234,
     -1.000,-1.000,3.279,4.636,5.968,7.325,8.707,10.077,11.434,12.753,14.198,15.530,16.937,18.282,19.639,21.096,
     -1.000,-1.000,3.199,4.524,5.933,7.281,8.618,9.991,11.316,12.713,14.061,15.410,16.795,18.168,19.528,20.961,
     -1.000,-1.000,3.035,4.388,5.775,7.139,8.424,9.799,11.209,12.494,13.937,15.268,16.632,18.030,19.360,20.713,
     -1.000,-1.000,2.952,4.297,5.675,6.988,8.377,9.777,11.036,12.403,13.781,15.203,16.494,17.872,19.294,20.694,
     -1.000,-1.000,-1.000,4.173,5.512,6.871,8.200,9.570,10.878,12.331,13.649,15.009,16.317,17.780,19.026,20.531,
     -1.000,-1.000,-1.000,4.058,5.411,6.724,8.087,9.380,10.773,12.106,13.508,14.831,16.234,17.557,18.850,20.272,
     -1.000,-1.000,-1.000,3.887,5.290,6.618,7.955,9.263,10.590,11.956,13.283,14.696,16.014,17.399,18.726,20.082,
     -1.000,-1.000,-1.000,3.783,5.179,6.473,7.786,9.200,10.477,11.799,13.130,14.508,15.857,17.124,18.520,19.879,
     -1.000,-1.000,-1.000,3.661,5.013,6.384,7.675,9.010,10.354,11.724,13.077,14.324,15.694,17.038,18.409,19.682,
     -1.000,-1.000,-1.000,3.581,4.911,6.190,7.546,8.918,10.189,11.570,12.815,14.153,15.458,16.882,18.152,19.491,
     -1.000,-1.000,-1.000,-1.000,4.766,6.100,7.351,8.726,10.051,11.344,12.653,13.970,15.287,16.687,18.053,19.263,
     -1.000,-1.000,-1.000,-1.000,4.568,5.929,7.242,8.523,9.947,11.149,12.533,13.815,15.207,16.425,17.746,19.091,
     -1.000,-1.000,-1.000,-1.000,4.474,5.799,7.070,8.425,9.719,11.090,12.406,13.685,15.048,16.311,17.605,18.906,
     -1.000,-1.000,-1.000,-1.000,4.379,5.715,6.975,8.303,9.646,10.937,12.220,13.518,14.831,16.167,17.427,18.808,
     -1.000,-1.000,-1.000,-1.000,4.247,5.520,6.858,8.117,9.506,10.707,12.038,13.412,14.671,15.916,17.232,18.469,
     -1.000,-1.000,-1.000,-1.000,-1.000,5.371,6.677,8.019,9.254,10.596,11.909,13.222,14.485,15.791,17.048,18.382,
     -1.000,-1.000,-1.000,-1.000,-1.000,5.232,6.562,7.824,9.147,10.368,11.691,13.008,14.324,15.661,16.970,18.171,
     -1.000,-1.000,-1.000,-1.000,-1.000,5.100,6.419,7.679,8.972,10.232,11.519,12.785,14.132,15.431,16.605,17.978,
     -1.000,-1.000,-1.000,-1.000,-1.000,4.994,6.239,7.575,8.801,10.124,11.382,12.633,13.930,15.227,16.563,17.789,
     -1.000,-1.000,-1.000,-1.000,-1.000,4.806,6.107,7.382,8.663,9.926,11.220,12.439,13.771,15.002,16.234,17.515,
     -1.000,-1.000,-1.000,-1.000,-1.000,4.646,5.968,7.217,8.447,9.751,11.031,12.292,13.602,14.783,16.013,17.232,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,5.837,7.108,8.320,9.573,10.868,12.163,13.435,14.598,15.870,17.135,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,5.654,6.917,8.117,9.346,10.644,11.849,13.113,14.411,15.652,16.822,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,5.440,6.724,7.946,9.208,10.476,11.738,13.005,14.153,15.455,16.620,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,5.324,6.596,7.839,9.072,10.254,11.548,12.825,13.963,15.207,16.389,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,5.198,6.364,7.623,8.882,10.070,11.302,12.528,13.743,14.997,16.218,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,5.040,6.196,7.454,8.653,9.809,11.109,12.250,13.502,14.685,15.926,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,6.072,7.255,8.485,9.669,10.862,12.087,13.338,14.500,15.704,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,5.973,7.081,8.305,9.549,10.733,11.942,13.120,14.329,15.416,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,5.720,6.898,8.067,9.311,10.425,11.772,12.906,14.006,15.224,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,5.535,6.670,7.883,9.057,10.256,11.445,12.697,13.749,14.938,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,5.381,6.484,7.659,8.847,10.089,11.101,12.338,13.488,14.649,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,6.291,7.466,8.693,9.821,10.996,12.157,13.238,14.357,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,6.157,7.277,8.475,9.558,10.624,11.914,12.983,-1.000]';
%c
%c +++ Brake Torque data for (bore,stroke) = (1,2); Bore = 6.67; Stroke = 8.80
%c
sclpg(1,2,1:ldptspg,1:rpmptpg,5)=...
     [1.313,3.661,5.491,7.043,8.714,10.425,12.175,13.807,15.438,17.149,18.860,20.571,22.202,24.112,25.743,27.534,
     1.228,3.649,5.320,6.957,8.628,10.300,11.937,13.676,15.449,17.155,18.826,20.463,22.270,23.941,25.715,27.318,
     1.104,3.551,5.192,6.834,8.535,10.176,11.966,13.608,15.279,16.980,18.651,20.412,22.083,23.784,25.485,27.036,
     1.035,3.342,5.119,6.685,8.409,10.080,11.724,13.528,15.226,16.844,18.515,20.213,21.990,23.635,25.359,27.056,
     0.955,3.199,4.894,6.541,8.260,9.907,11.674,13.393,15.016,16.735,18.454,20.173,21.820,23.587,25.186,27.001,
     -1.000,3.147,4.818,6.446,8.139,9.918,11.503,13.326,14.867,16.668,18.404,20.119,21.725,23.352,25.132,26.912,
     -1.000,3.064,4.635,6.326,7.958,9.669,11.340,13.011,14.881,16.453,18.164,19.775,21.486,23.316,24.908,26.778,
     -1.000,2.957,4.591,6.244,7.897,9.531,11.220,12.983,14.581,16.307,17.868,19.705,21.394,22.955,24.773,26.518,
     -1.000,2.762,4.399,6.054,7.725,9.396,11.084,12.755,14.409,16.063,17.837,19.406,21.247,22.765,24.504,26.380,
     -1.000,2.642,4.281,5.921,7.560,9.215,10.918,12.573,14.276,15.947,17.650,19.290,20.945,22.775,24.303,26.054,
     -1.000,2.477,4.073,5.730,7.416,9.117,10.758,12.444,14.160,15.801,17.472,19.158,20.904,22.560,24.276,25.917,
     -1.000,2.345,3.960,5.589,7.218,8.945,10.645,12.217,13.945,15.644,17.371,18.958,20.671,22.272,24.098,25.881,
     -1.000,-1.000,3.753,5.464,7.069,8.754,10.438,12.096,13.793,15.478,17.109,18.727,20.558,22.123,23.741,25.637,
     -1.000,-1.000,3.581,5.265,6.886,8.519,10.215,11.924,13.520,15.354,16.812,18.508,20.192,21.901,23.697,25.306,
     -1.000,-1.000,3.450,5.061,6.708,8.308,9.943,11.650,13.285,14.849,16.652,18.323,20.054,21.689,23.396,25.127,
     -1.000,-1.000,3.297,4.877,6.525,8.208,9.879,11.505,13.096,14.756,16.404,18.110,19.690,21.429,23.123,24.646,
     -1.000,-1.000,3.071,4.731,6.326,7.965,9.614,11.275,12.805,14.508,16.169,17.786,19.413,21.008,22.766,24.427,
     -1.000,-1.000,-1.000,4.474,6.155,7.785,9.446,11.013,12.715,14.293,15.922,17.511,19.244,20.842,22.410,24.122,
     -1.000,-1.000,-1.000,4.317,5.929,7.580,9.211,10.763,12.434,14.115,15.667,17.408,18.969,20.531,22.232,23.923,
     -1.000,-1.000,-1.000,4.154,5.749,7.363,9.024,10.600,12.261,13.875,15.441,17.084,18.707,20.302,21.992,23.577,
     -1.000,-1.000,-1.000,3.921,5.573,7.162,8.769,10.330,11.973,13.525,15.242,16.803,18.456,20.099,21.624,23.249,
     -1.000,-1.000,-1.000,3.776,5.314,6.994,8.471,10.089,11.777,13.316,14.943,16.552,18.135,19.877,21.406,22.971,
     -1.000,-1.000,-1.000,3.538,5.082,6.667,8.356,9.899,11.536,13.088,14.674,16.251,17.845,19.585,21.136,22.654,
     -1.000,-1.000,-1.000,-1.000,4.898,6.577,8.133,9.665,11.352,12.883,14.382,16.044,17.658,19.214,20.794,22.375,
     -1.000,-1.000,-1.000,-1.000,4.735,6.318,7.926,9.446,11.021,12.629,14.220,15.764,17.252,18.916,20.483,22.011,
     -1.000,-1.000,-1.000,-1.000,4.513,6.068,7.632,9.226,10.843,12.383,13.916,15.464,17.096,18.629,20.223,21.809,
     -1.000,-1.000,-1.000,-1.000,4.320,5.827,7.453,8.952,10.556,12.146,13.757,15.227,16.816,18.427,19.957,21.434,
     -1.000,-1.000,-1.000,-1.000,4.116,5.636,7.198,8.782,10.338,11.806,13.434,14.975,16.538,18.028,19.656,21.124,
     -1.000,-1.000,-1.000,-1.000,-1.000,5.371,6.839,8.587,10.139,11.593,13.130,14.626,16.227,17.715,19.239,20.784,
     -1.000,-1.000,-1.000,-1.000,-1.000,5.184,6.712,8.267,9.822,11.289,12.817,14.392,15.831,17.325,18.942,20.524,
     -1.000,-1.000,-1.000,-1.000,-1.000,4.967,6.479,8.004,9.536,11.088,12.606,14.039,15.557,17.049,18.561,20.073,
     -1.000,-1.000,-1.000,-1.000,-1.000,4.723,6.207,7.736,9.285,10.820,12.253,13.756,15.253,16.763,18.169,19.789,
     -1.000,-1.000,-1.000,-1.000,-1.000,4.486,6.019,7.451,8.978,10.523,11.949,13.438,14.902,16.510,17.943,19.362,
     -1.000,-1.000,-1.000,-1.000,-1.000,4.199,5.736,7.199,8.772,10.204,11.680,13.149,14.636,16.007,17.415,19.019,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,5.461,6.935,8.362,9.866,11.280,12.736,14.288,15.577,17.165,18.579,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,5.194,6.679,8.111,9.619,10.976,12.554,13.945,15.378,16.723,18.214,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,5.002,6.412,7.833,9.197,10.720,12.147,13.460,14.938,16.427,17.706,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,4.752,6.157,7.545,8.977,10.449,11.814,13.175,14.618,15.940,17.194,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,4.460,5.865,7.265,8.567,9.880,11.345,12.734,14.205,15.480,16.825,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,4.170,5.576,6.976,8.244,9.666,10.960,12.425,13.714,15.099,16.276,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,5.299,6.700,8.039,9.300,10.644,11.900,13.239,14.459,15.819,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,5.044,6.334,7.670,8.950,10.276,11.586,12.892,14.136,15.477,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,4.720,6.028,7.351,8.654,10.052,11.176,12.553,13.593,14.856,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,4.434,5.773,7.045,8.326,9.525,10.826,12.127,13.262,14.246,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,4.197,5.448,6.689,7.974,9.201,10.428,11.540,12.739,13.846,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,5.173,6.427,7.597,8.824,10.003,11.155,12.269,13.388,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,4.848,6.106,7.281,8.503,9.646,10.835,11.859,-1.000]';
%c
%c +++ Brake Torque data for (bore,stroke) = (1,3); Bore = 6.67; Stroke = 10.44
%c
sclpg(1,3,1:ldptspg,1:rpmptpg,5)=...
     [1.233,4.257,6.247,8.196,10.146,12.136,14.165,16.154,18.183,20.213,22.162,24.231,26.181,28.250,30.359,32.229,
     1.125,4.195,6.105,8.083,10.027,12.073,13.983,16.063,17.939,20.019,21.997,24.010,26.124,28.102,30.217,32.161,
     0.895,3.939,5.998,7.938,9.937,11.877,13.876,15.906,17.875,19.874,21.874,23.933,25.873,27.932,29.961,31.871,
     0.690,3.926,5.809,7.825,9.682,11.751,13.767,15.783,17.719,19.709,21.698,23.741,25.757,27.773,29.789,31.884,
     0.454,3.700,5.706,7.616,9.621,11.626,13.488,15.589,17.451,19.576,21.653,23.587,25.592,27.597,29.627,31.632,
     -1.000,3.559,5.513,7.466,9.441,11.481,13.478,15.431,17.384,19.402,21.508,23.331,25.523,27.476,29.494,31.469,
     -1.000,3.382,5.292,7.301,9.311,11.260,13.329,15.179,17.268,19.218,21.267,23.276,25.246,27.295,29.285,31.155,
     -1.000,3.159,5.068,7.033,9.072,11.110,13.057,15.077,17.005,18.915,20.990,23.065,25.067,27.050,29.015,31.017,
     -1.000,2.882,4.894,6.855,8.833,10.794,12.806,14.818,16.677,18.689,20.838,22.731,24.811,26.823,28.818,30.728,
     -1.000,2.753,4.615,6.621,8.610,10.568,12.510,14.483,16.536,18.478,20.436,22.505,24.430,26.483,28.536,30.494,
     -1.000,2.462,4.402,6.446,8.341,10.280,12.354,14.249,16.129,18.203,20.158,22.187,24.172,26.052,28.379,30.170,
     -1.000,2.205,4.129,6.137,8.131,10.069,12.007,14.057,15.883,17.933,19.857,21.767,23.733,25.755,27.679,29.813,
     -1.000,-1.000,3.926,5.875,7.759,9.775,11.764,13.674,15.677,17.653,19.443,21.672,23.635,25.372,27.322,29.483,
     -1.000,-1.000,3.606,5.591,7.501,9.474,11.396,13.457,15.279,17.226,19.262,21.323,23.057,25.017,27.241,28.912,
     -1.000,-1.000,3.342,5.240,7.293,9.179,11.185,12.927,15.076,17.046,18.860,20.746,22.799,24.685,26.654,28.875,
     -1.000,-1.000,3.047,4.991,7.003,8.901,10.777,12.676,14.665,16.598,18.496,20.736,22.509,24.339,26.272,28.341,
     -1.000,-1.000,2.789,4.731,6.630,8.518,10.548,12.425,14.411,16.212,18.089,20.075,21.942,24.014,26.011,27.726,
     -1.000,-1.000,-1.000,4.474,6.404,8.304,10.214,12.123,14.044,15.829,17.915,19.690,21.652,23.655,25.451,27.496,
     -1.000,-1.000,-1.000,4.188,6.058,8.007,9.897,11.748,13.707,15.677,17.298,19.477,21.227,23.048,25.137,26.828,
     -1.000,-1.000,-1.000,3.915,5.873,7.639,9.607,11.431,13.331,15.011,17.074,18.974,20.989,22.660,24.666,26.499,
     -1.000,-1.000,-1.000,3.618,5.509,7.410,9.173,11.064,12.956,14.820,16.849,18.649,20.715,22.276,24.222,26.196,
     -1.000,-1.000,-1.000,3.378,5.226,7.091,8.966,10.752,12.573,14.554,16.331,18.099,20.142,22.043,23.838,25.650,
     -1.000,-1.000,-1.000,2.993,4.894,6.736,8.611,10.462,12.329,14.094,15.876,17.624,19.712,21.605,23.319,25.195,
     -1.000,-1.000,-1.000,-1.000,4.651,6.429,8.257,10.010,11.920,13.665,15.575,17.362,19.189,21.083,22.820,24.647,
     -1.000,-1.000,-1.000,-1.000,4.305,6.112,7.902,9.748,11.594,13.321,15.207,17.014,18.677,20.428,22.473,24.295,
     -1.000,-1.000,-1.000,-1.000,4.066,5.830,7.539,9.303,11.082,13.061,14.855,16.496,18.290,20.061,21.794,23.665,
     -1.000,-1.000,-1.000,-1.000,3.693,5.431,7.192,8.975,10.855,12.578,14.324,15.928,17.875,19.554,21.284,23.060,
     -1.000,-1.000,-1.000,-1.000,3.284,5.165,6.858,8.659,10.410,12.219,13.941,15.626,17.377,18.997,20.864,22.564,
     -1.000,-1.000,-1.000,-1.000,-1.000,4.915,6.502,8.335,10.048,11.740,13.573,15.131,16.852,18.642,20.306,21.802,
     -1.000,-1.000,-1.000,-1.000,-1.000,4.495,6.214,7.912,9.577,11.275,13.008,14.665,16.418,18.110,19.828,21.336,
     -1.000,-1.000,-1.000,-1.000,-1.000,4.118,5.789,7.547,9.258,10.856,12.560,14.251,15.902,17.500,19.244,20.730,
     -1.000,-1.000,-1.000,-1.000,-1.000,3.710,5.471,7.104,8.769,10.401,12.098,13.711,15.401,16.931,18.634,20.228,
     -1.000,-1.000,-1.000,-1.000,-1.000,3.311,5.020,6.766,8.444,10.008,11.629,13.143,14.852,16.284,18.106,19.406,
     -1.000,-1.000,-1.000,-1.000,-1.000,3.024,4.622,6.470,7.921,9.592,11.220,12.628,14.195,15.677,17.360,18.890,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,4.399,5.998,7.532,9.143,10.671,12.187,13.733,15.291,16.807,18.257,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,3.959,5.438,7.005,8.722,10.236,11.645,13.212,14.539,15.972,17.573,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,3.615,5.138,6.685,8.293,9.743,11.215,12.710,14.080,15.353,16.887,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,3.198,4.869,6.329,7.789,9.294,10.787,12.148,13.486,14.801,16.045,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,2.876,4.303,5.806,7.222,8.860,10.260,11.682,12.946,14.340,15.528,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,2.451,3.921,5.316,6.865,8.234,9.788,11.093,12.303,13.698,15.014,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,3.555,5.055,6.352,7.863,9.300,10.592,11.900,13.193,14.308,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,3.286,4.663,6.060,7.406,8.696,10.113,11.342,12.709,13.750,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,2.949,4.178,5.710,6.958,8.221,9.455,10.828,11.981,13.110,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,2.470,3.868,5.223,6.548,7.868,8.989,10.080,11.600,12.697,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,2.091,3.495,4.775,6.088,7.396,8.456,9.755,10.953,12.066,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,3.188,4.405,5.683,7.003,8.187,9.311,10.387,11.572,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,2.782,4.081,5.367,6.469,7.621,8.700,9.852,-1.000]';
%c
%c +++ Brake Torque data for (bore,stroke) = (2,1); Bore = 8.20; Stroke = 7.16
%c
sclpg(2,1,1:ldptspg,1:rpmptpg,5)=...
     [1.989,4.775,6.923,8.913,10.942,13.051,15.120,17.229,19.258,21.327,23.436,25.465,27.574,29.802,31.751,33.820,
     1.944,4.672,6.787,8.765,10.845,12.857,15.006,17.018,19.099,21.179,23.259,25.237,27.386,29.671,31.513,33.695,
     1.820,4.536,6.595,8.594,10.713,12.742,14.772,16.920,18.920,21.038,23.097,25.216,27.365,29.424,31.423,33.452,
     1.724,4.430,6.446,8.488,10.637,12.653,14.669,16.764,18.807,20.876,22.865,24.987,27.083,29.311,31.168,33.343,
     1.647,4.321,6.350,8.427,10.480,12.510,14.515,16.687,18.693,20.770,22.751,24.948,26.953,29.078,31.107,33.494,
     -1.000,4.189,6.185,8.269,10.287,12.392,14.476,16.603,18.621,20.661,22.745,24.806,26.955,28.930,31.122,33.140,
     -1.000,4.019,6.127,8.137,10.146,12.255,14.344,16.373,18.482,20.491,22.560,24.629,26.718,28.907,30.896,32.866,
     -1.000,3.893,5.913,7.988,10.027,12.065,14.159,16.215,18.254,20.421,22.459,24.571,26.628,28.685,30.778,32.761,
     -1.000,3.752,5.713,7.810,9.890,11.954,14.017,16.046,18.127,20.207,22.339,24.385,26.448,28.580,30.575,32.672,
     -1.000,3.597,5.523,7.544,9.629,11.777,13.719,15.836,17.985,20.149,22.186,24.303,26.372,28.409,30.415,32.499,
     -1.000,3.447,5.386,7.475,9.460,11.504,13.653,15.727,17.786,19.874,21.948,24.008,26.156,28.081,30.110,32.274,
     -1.000,3.300,5.266,7.232,9.254,11.347,13.425,15.391,17.596,19.674,21.753,23.817,25.938,27.861,30.038,32.074,
     -1.000,-1.000,5.066,7.082,9.138,11.181,13.157,15.239,17.242,19.390,21.393,23.436,25.518,27.494,29.815,31.552,
     -1.000,-1.000,4.913,6.886,8.984,10.944,13.030,15.028,17.038,19.136,21.235,23.031,25.142,27.266,29.251,31.374,
     -1.000,-1.000,4.608,6.685,8.761,10.791,12.724,14.885,16.902,18.860,20.889,22.871,25.043,26.977,28.994,31.202,
     -1.000,-1.000,4.490,6.503,8.424,10.572,12.528,14.631,16.689,18.644,20.633,22.611,24.726,26.761,28.762,30.762,
     -1.000,-1.000,4.308,6.272,8.334,10.385,12.371,14.335,16.462,18.458,20.466,22.430,24.481,26.456,28.507,30.493,
     -1.000,-1.000,-1.000,6.082,8.158,10.131,12.175,14.158,16.161,18.196,20.157,22.202,24.143,26.209,28.316,30.236,
     -1.000,-1.000,-1.000,5.859,7.898,9.878,11.986,13.956,15.965,18.004,20.004,21.924,23.863,26.002,27.922,30.100,
     -1.000,-1.000,-1.000,5.682,7.697,9.664,11.717,13.713,15.795,17.685,19.729,21.715,23.787,25.793,27.741,29.784,
     -1.000,-1.000,-1.000,5.445,7.465,9.448,11.395,13.507,15.371,17.483,19.392,21.477,23.469,25.590,27.445,29.346,
     -1.000,-1.000,-1.000,5.208,7.286,9.231,11.229,13.192,15.129,17.215,19.293,21.203,23.210,25.200,27.154,29.293,
     -1.000,-1.000,-1.000,5.005,6.957,9.004,10.965,12.926,14.904,17.010,18.894,20.906,22.901,24.948,26.798,28.921,
     -1.000,-1.000,-1.000,-1.000,6.742,8.710,10.801,12.694,14.571,16.604,18.564,20.654,22.589,24.606,26.466,28.524,
     -1.000,-1.000,-1.000,-1.000,6.509,8.523,10.456,12.414,14.388,16.218,18.374,20.252,22.154,24.375,26.221,28.194,
     -1.000,-1.000,-1.000,-1.000,6.238,8.140,10.173,12.121,14.062,16.080,18.067,19.915,21.856,23.796,26.091,27.793,
     -1.000,-1.000,-1.000,-1.000,6.050,7.938,9.833,11.884,13.824,15.779,17.674,19.636,21.471,23.373,25.440,27.387,
     -1.000,-1.000,-1.000,-1.000,5.853,7.741,9.614,11.546,13.564,15.438,17.420,19.308,21.146,23.063,25.132,26.977,
     -1.000,-1.000,-1.000,-1.000,-1.000,7.436,9.353,11.340,13.320,15.110,17.097,19.092,20.959,22.911,24.716,26.563,
     -1.000,-1.000,-1.000,-1.000,-1.000,7.230,9.079,10.975,12.844,14.904,16.745,18.662,20.545,22.468,24.344,26.186,
     -1.000,-1.000,-1.000,-1.000,-1.000,6.937,8.866,10.677,12.553,14.589,16.499,18.402,20.186,22.089,24.026,25.869,
     -1.000,-1.000,-1.000,-1.000,-1.000,6.639,8.498,10.491,12.298,14.163,16.021,18.002,19.873,21.770,23.557,25.454,
     -1.000,-1.000,-1.000,-1.000,-1.000,6.439,8.217,10.152,12.050,13.821,15.719,17.786,19.526,21.417,23.138,25.186,
     -1.000,-1.000,-1.000,-1.000,-1.000,6.146,8.013,9.892,11.710,13.504,15.322,17.287,19.246,21.021,22.814,24.700,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,7.675,9.579,11.447,13.315,15.070,16.860,18.651,20.740,22.220,24.291,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,7.511,9.340,11.151,12.874,14.772,16.554,18.336,20.182,22.080,23.897,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,7.185,8.970,10.754,12.596,14.290,16.200,17.916,19.627,21.475,23.350,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,6.940,8.739,10.438,12.286,13.974,15.890,17.650,19.215,21.058,22.935,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,6.614,8.437,10.108,11.953,13.624,15.496,17.183,18.806,20.786,22.452,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,6.377,8.080,9.820,11.539,13.274,15.093,16.812,18.616,20.260,21.916,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,7.800,9.554,11.210,12.897,14.744,16.462,18.201,19.846,21.413,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,7.589,9.184,10.916,12.607,14.344,16.127,17.615,19.297,20.978,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,7.122,8.798,10.554,12.185,14.001,15.597,17.263,18.954,20.466,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,6.836,8.507,10.236,11.868,13.457,15.177,16.960,18.343,19.893,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,6.451,8.160,9.941,11.531,13.116,14.735,16.296,17.891,19.452,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,7.953,9.568,11.197,12.737,14.319,15.953,17.348,18.991,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,7.603,9.205,10.839,12.391,13.897,15.375,16.886,-1.000]';
%c
%c +++ Brake Torque data for (bore,stroke) = (2,2); Bore = 8.20; Stroke = 8.80
%c
sclpg(2,2,1:ldptspg,1:rpmptpg,5)=...
     [2.308,5.849,8.555,11.021,13.608,16.114,18.780,21.168,23.754,26.499,28.926,31.393,34.099,36.645,39.232,41.858,
     2.114,5.661,8.151,10.675,13.164,15.825,18.382,20.906,23.635,26.192,28.750,31.376,33.968,36.492,39.254,41.676,
     1.940,5.491,8.057,10.504,13.041,15.577,18.084,20.501,23.247,25.664,28.111,30.737,33.393,35.959,38.525,40.972,
     1.724,5.358,7.799,10.372,12.865,15.358,17.931,20.372,23.104,25.465,28.144,30.558,33.237,35.969,38.277,40.903,
     1.456,5.109,7.639,10.170,12.701,15.231,17.690,20.412,22.894,25.401,27.956,30.653,33.041,35.476,38.149,40.632,
     -1.000,4.905,7.357,9.875,12.392,14.932,17.427,19.945,22.571,25.132,27.736,30.341,32.793,35.332,37.937,40.628,
     -1.000,4.655,7.162,9.708,12.175,14.682,17.209,19.775,22.123,24.669,27.315,29.981,32.507,35.074,37.600,40.207,
     -1.000,4.389,6.831,9.384,11.845,14.452,16.913,19.429,22.074,24.589,27.179,29.566,32.321,34.616,37.150,39.905,
     -1.000,4.161,6.685,9.123,11.647,14.136,16.643,19.150,21.725,24.334,26.994,29.313,31.871,34.377,36.969,39.408,
     -1.000,3.931,6.334,8.865,11.316,13.815,16.329,18.924,21.470,23.953,26.436,28.998,31.560,34.107,36.860,39.216,
     -1.000,3.715,5.938,8.535,11.056,13.578,16.100,18.636,21.098,23.679,26.126,28.529,31.155,33.751,36.153,38.705,
     -1.000,3.412,5.814,8.243,10.729,13.215,15.770,18.270,20.910,23.269,25.797,28.339,30.895,33.366,35.810,38.394,
     -1.000,-1.000,5.411,7.865,10.332,12.918,15.438,17.971,20.385,22.905,25.425,27.985,30.346,32.879,35.372,37.985,
     -1.000,-1.000,5.189,7.614,10.064,12.628,15.065,17.490,19.991,22.629,25.029,27.379,30.017,32.405,34.943,37.481,
     -1.000,-1.000,4.858,7.246,9.645,12.271,14.587,17.069,19.588,22.190,24.554,27.096,29.436,31.859,34.342,36.968,
     -1.000,-1.000,4.525,7.026,9.515,11.823,14.313,16.825,19.076,21.668,24.055,26.568,28.898,31.490,33.957,36.446,
     -1.000,-1.000,4.102,6.685,9.126,11.546,13.825,16.364,18.816,21.236,23.754,26.120,28.529,30.992,33.509,35.940,
     -1.000,-1.000,-1.000,6.352,8.750,11.189,13.660,16.016,18.434,21.050,23.261,25.773,28.295,30.568,33.090,35.498,
     -1.000,-1.000,-1.000,6.018,8.395,10.902,13.170,15.657,17.994,20.362,22.849,25.216,27.733,30.031,32.637,34.915,
     -1.000,-1.000,-1.000,5.596,7.926,10.447,12.882,15.317,17.724,20.111,22.555,24.828,27.063,29.689,32.086,34.750,
     -1.000,-1.000,-1.000,5.371,7.639,10.063,12.579,14.921,17.253,19.631,22.018,24.369,26.756,29.125,31.375,33.992,
     -1.000,-1.000,-1.000,5.058,7.312,9.753,12.113,14.474,16.888,19.240,21.636,23.979,26.243,28.568,30.911,33.387,
     -1.000,-1.000,-1.000,4.587,6.974,9.225,11.698,14.077,16.413,18.766,21.119,23.447,25.817,28.222,30.387,32.749,
     -1.000,-1.000,-1.000,-1.000,6.635,8.841,11.204,13.682,15.995,18.325,20.646,22.902,25.363,27.718,29.916,32.221,
     -1.000,-1.000,-1.000,-1.000,6.183,8.515,10.823,13.274,15.549,17.953,20.197,22.512,24.812,27.112,29.388,31.537,
     -1.000,-1.000,-1.000,-1.000,5.730,8.117,10.420,12.707,15.086,17.489,19.769,22.033,24.428,26.569,28.825,31.259,
     -1.000,-1.000,-1.000,-1.000,5.454,7.759,10.027,12.287,14.704,16.846,19.054,21.531,23.828,26.074,28.245,30.334,
     -1.000,-1.000,-1.000,-1.000,5.078,7.343,9.629,11.893,14.107,16.458,18.650,21.016,23.049,25.530,27.679,29.863,
     -1.000,-1.000,-1.000,-1.000,-1.000,7.043,9.282,11.368,13.629,15.855,18.116,20.440,22.680,24.800,27.012,29.294,
     -1.000,-1.000,-1.000,-1.000,-1.000,6.582,8.779,10.968,13.226,15.402,17.646,19.794,22.025,24.092,26.513,28.634,
     -1.000,-1.000,-1.000,-1.000,-1.000,6.194,8.256,10.604,12.766,14.941,16.990,19.238,21.433,23.489,25.823,27.719,
     -1.000,-1.000,-1.000,-1.000,-1.000,5.710,7.781,10.162,12.201,14.337,16.595,18.737,20.867,22.796,24.912,27.086,
     -1.000,-1.000,-1.000,-1.000,-1.000,5.353,7.514,9.694,11.811,13.809,16.058,18.181,20.123,22.403,24.313,26.443,
     -1.000,-1.000,-1.000,-1.000,-1.000,4.873,7.052,9.200,11.337,13.436,15.481,17.458,19.601,21.670,23.592,25.636,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,6.661,8.672,10.815,12.975,14.843,16.914,18.985,20.919,22.906,25.091,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,6.190,8.315,10.277,12.368,14.411,16.519,18.272,20.269,22.091,24.159,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,5.701,7.821,9.834,11.868,13.920,15.779,17.661,19.616,21.446,23.322,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,5.252,7.384,9.316,11.198,13.325,15.223,17.078,18.993,20.886,22.680,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,4.796,6.815,8.790,10.792,12.783,14.649,16.554,18.285,20.108,21.866,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,4.371,6.303,8.250,10.287,12.207,13.979,15.884,17.767,19.348,21.077,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,5.927,7.915,9.695,11.755,13.545,15.258,17.038,18.715,20.297,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,5.465,7.325,9.295,11.134,12.953,14.486,16.427,18.001,19.586,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,5.073,6.913,8.778,10.554,12.369,14.031,15.707,17.368,18.944,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,4.716,6.470,8.283,10.071,11.790,13.471,15.108,16.687,18.192,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,4.273,6.011,7.778,9.516,11.154,12.892,14.520,15.995,17.385,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,5.622,7.354,8.913,10.748,12.316,13.842,15.461,16.604,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,5.261,6.877,8.530,10.119,11.739,13.135,14.811,-1.000]';
%c
%c +++ Brake Torque data for (bore,stroke) = (2,3); Bore = 8.20; Stroke = 10.44
%c
sclpg(2,3,1:ldptspg,1:rpmptpg,5)=...
     [2.348,6.764,9.907,12.772,16.035,18.939,22.043,24.987,28.011,31.115,34.099,37.401,40.386,43.370,46.473,49.617,
     1.978,6.616,9.481,12.551,15.586,18.723,21.554,24.692,27.795,30.831,33.695,36.867,39.902,42.972,45.973,49.008,
     1.582,6.237,9.311,12.205,15.219,18.174,21.396,24.261,27.275,30.468,33.452,36.556,39.540,42.494,45.747,48.851,
     1.141,6.101,8.992,11.910,14.961,17.905,20.982,23.926,26.950,30.027,33.025,36.208,39.020,42.043,45.120,48.569,
     0.668,5.777,8.714,11.602,14.610,17.523,20.650,23.682,26.595,29.555,32.706,35.762,38.818,41.802,44.834,47.866,
     -1.000,5.447,8.269,11.286,14.259,17.189,20.227,23.179,26.174,29.190,32.337,35.267,38.523,41.474,44.231,47.464,
     -1.000,5.093,7.858,10.902,13.946,16.751,19.795,22.699,25.803,28.887,31.831,34.915,37.859,40.783,43.847,47.010,
     -1.000,4.720,7.621,10.486,13.553,16.509,19.503,22.698,25.489,28.372,31.329,34.341,37.389,40.162,43.413,46.277,
     -1.000,4.263,7.162,10.061,13.079,16.080,19.116,22.066,24.982,28.136,30.950,33.661,37.055,39.971,42.682,45.956,
     -1.000,3.804,6.828,9.756,12.732,15.549,18.557,21.566,24.669,27.470,30.494,33.470,36.510,39.439,42.415,45.311,
     -1.000,3.342,6.282,9.281,12.190,15.160,18.069,21.023,24.052,26.977,29.871,32.960,35.914,38.928,41.868,44.792,
     -1.000,2.514,5.786,8.889,11.712,14.689,17.526,20.559,23.452,26.429,29.406,32.468,35.375,38.211,41.216,44.025,
     -1.000,-1.000,5.371,8.329,11.366,14.244,17.083,20.040,22.932,25.876,28.767,31.645,34.590,37.534,40.531,43.091,
     -1.000,-1.000,4.951,7.815,10.655,13.671,16.611,19.450,22.403,25.092,28.233,31.274,33.988,36.576,39.868,42.658,
     -1.000,-1.000,4.476,7.353,10.277,13.035,15.923,18.991,21.832,24.757,27.645,30.582,33.375,36.228,39.188,41.981,
     -1.000,-1.000,4.081,6.878,9.640,12.641,15.506,18.451,21.224,24.192,27.011,29.807,32.786,35.617,38.493,41.130,
     -1.000,-1.000,3.581,6.370,9.148,12.023,14.834,17.927,20.607,23.559,26.304,29.060,32.164,34.931,37.796,40.595,
     -1.000,-1.000,-1.000,6.010,8.709,11.449,14.438,17.033,20.085,22.856,25.679,28.638,31.440,34.211,37.159,39.848,
     -1.000,-1.000,-1.000,5.421,8.187,10.982,13.856,16.562,19.357,22.272,24.967,27.862,30.856,33.472,36.178,39.172,
     -1.000,-1.000,-1.000,4.908,7.601,10.552,13.168,16.005,18.650,21.467,24.418,27.139,29.880,32.601,35.533,38.235,
     -1.000,-1.000,-1.000,4.352,6.923,9.944,12.717,15.481,18.061,20.779,23.598,26.398,29.199,31.825,34.699,37.307,
     -1.000,-1.000,-1.000,3.846,6.472,9.204,12.105,14.890,17.595,20.248,22.786,25.765,28.321,31.106,33.838,36.597,
     -1.000,-1.000,-1.000,3.342,5.985,8.671,11.425,14.230,16.873,19.636,22.202,24.888,27.446,30.080,32.971,35.767,
     -1.000,-1.000,-1.000,-1.000,5.433,8.216,10.809,13.583,16.259,18.786,21.502,24.087,26.796,29.348,31.867,34.822,
     -1.000,-1.000,-1.000,-1.000,4.966,7.584,10.313,12.947,15.494,18.199,20.817,23.348,26.006,28.473,30.940,33.637,
     -1.000,-1.000,-1.000,-1.000,4.420,6.946,9.680,12.168,14.963,17.581,20.192,22.595,25.175,27.701,30.034,32.637,
     -1.000,-1.000,-1.000,-1.000,3.760,6.438,9.087,11.593,14.115,16.868,19.390,21.844,24.395,26.969,29.252,31.737,
     -1.000,-1.000,-1.000,-1.000,3.270,5.947,8.327,11.011,13.579,16.017,18.636,21.037,23.562,26.000,28.351,30.572,
     -1.000,-1.000,-1.000,-1.000,-1.000,5.259,7.801,10.118,12.751,15.209,17.800,20.271,22.764,24.976,27.223,29.694,
     -1.000,-1.000,-1.000,-1.000,-1.000,4.686,7.319,9.597,11.896,14.522,17.114,19.385,21.738,24.071,26.452,28.668,
     -1.000,-1.000,-1.000,-1.000,-1.000,4.138,6.585,8.972,11.472,13.774,16.154,18.482,20.916,23.164,25.385,27.521,
     -1.000,-1.000,-1.000,-1.000,-1.000,3.523,6.117,8.375,10.633,12.969,15.453,17.434,19.957,22.305,24.383,26.493,
     -1.000,-1.000,-1.000,-1.000,-1.000,2.808,5.334,7.897,10.102,12.402,14.582,16.900,18.986,21.241,23.289,25.488,
     -1.000,-1.000,-1.000,-1.000,-1.000,2.381,4.713,7.040,9.537,11.790,14.000,16.111,18.303,20.353,22.514,24.345,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,4.363,6.559,8.744,11.107,13.136,15.249,17.356,19.349,21.235,23.139,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,3.564,6.079,8.257,10.388,12.257,14.481,16.595,18.563,20.368,22.121,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,3.075,5.281,7.509,9.657,11.681,13.778,15.785,17.587,19.388,21.196,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,2.415,4.636,6.834,8.828,11.059,13.091,14.890,16.733,18.538,20.248,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.790,3.934,6.267,8.437,10.314,12.365,14.080,15.887,17.655,19.289,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.109,3.379,5.597,7.671,9.581,11.629,13.465,15.242,16.908,18.478,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,2.813,5.133,7.141,9.160,10.909,12.762,14.485,16.068,17.547,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,2.230,4.444,6.527,8.335,10.321,11.942,13.719,15.345,16.655,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.626,3.825,5.909,7.774,9.574,11.255,12.802,14.612,16.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.979,3.177,5.296,6.996,8.926,10.602,12.151,13.734,15.118,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,0.344,2.602,4.827,6.508,8.403,9.984,11.536,13.054,14.400,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,2.083,4.138,5.893,7.696,9.460,10.785,12.264,13.584,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.414,3.388,5.064,7.029,8.732,10.339,11.758,-1.000]';
%c
%c +++ Brake Torque data for (bore,stroke) = (3,1); Bore = 9.73; Stroke = 7.16
%c
sclpg(3,1,1:ldptspg,1:rpmptpg,5)=...
     [2.944,6.923,9.828,12.732,15.717,18.701,21.526,24.470,27.335,30.399,33.343,36.208,39.033,42.176,45.081,47.866,
     2.831,6.753,9.686,12.516,15.415,18.348,21.281,24.146,27.079,30.046,32.945,35.912,38.811,41.744,44.643,47.542,
     2.656,6.565,9.460,12.325,15.160,18.084,20.979,23.873,26.887,29.722,32.736,35.601,38.406,41.301,44.315,47.269,
     2.387,6.340,9.125,12.069,14.881,17.905,20.796,23.741,26.765,29.603,32.627,35.412,38.409,41.274,44.245,47.057,
     2.172,6.112,9.000,11.793,14.825,17.642,20.459,23.467,26.380,29.483,32.324,35.189,38.317,41.277,44.142,46.911,
     -1.000,5.882,8.681,11.524,14.389,17.362,20.336,23.027,26.022,28.930,31.882,34.833,37.676,40.628,43.623,46.488,
     -1.000,5.650,8.515,11.419,14.324,17.149,19.994,22.958,25.783,28.648,31.493,34.377,37.322,40.286,43.151,45.956,
     -1.000,5.344,8.154,10.927,13.883,16.877,19.723,22.680,25.471,28.354,31.237,34.120,37.040,39.905,42.825,45.800,
     -1.000,5.150,7.861,10.743,13.659,16.660,19.474,22.373,25.169,28.068,31.052,33.781,36.850,39.766,42.443,45.581,
     -1.000,4.870,7.576,10.488,13.289,16.282,19.210,22.059,24.971,27.868,30.653,33.661,36.335,39.184,42.399,45.089,
     -1.000,4.581,7.281,10.206,13.026,15.995,18.815,21.665,24.589,27.424,30.438,33.258,36.123,38.854,41.554,44.583,
     -1.000,4.367,7.050,9.788,12.821,15.672,18.425,21.402,24.196,27.061,30.108,32.861,36.105,38.871,41.427,44.601,
     -1.000,-1.000,6.724,9.563,12.374,15.239,18.130,21.048,23.780,26.605,29.616,32.494,35.452,38.131,40.969,43.914,
     -1.000,-1.000,6.370,9.311,12.087,14.827,17.767,20.682,23.597,26.361,29.439,31.965,34.754,37.795,40.710,43.600,
     -1.000,-1.000,6.112,8.988,11.734,14.622,17.296,20.137,22.942,26.189,28.887,31.763,34.545,37.362,40.405,43.079,
     -1.000,-1.000,5.843,8.697,11.448,14.278,17.075,19.883,22.657,25.510,28.307,31.115,33.923,36.856,39.777,42.585,
     -1.000,-1.000,5.545,8.312,11.134,13.944,16.646,19.457,22.256,25.045,27.845,30.883,33.390,36.103,39.087,42.093,
     -1.000,-1.000,-1.000,7.857,10.691,13.556,16.275,19.078,21.818,24.724,27.402,30.205,32.997,35.831,38.488,41.415,
     -1.000,-1.000,-1.000,7.669,10.295,13.180,15.906,18.661,21.357,24.152,26.977,29.702,32.667,35.313,38.177,40.704,
     -1.000,-1.000,-1.000,7.219,9.922,12.653,15.489,18.296,21.037,23.711,26.480,29.316,32.133,34.807,37.462,40.394,
     -1.000,-1.000,-1.000,6.887,9.558,12.313,15.040,17.776,20.641,23.295,26.068,28.832,31.586,34.203,36.912,39.942,
     -1.000,-1.000,-1.000,6.455,9.204,11.910,14.598,17.383,20.098,22.759,25.606,28.285,30.876,33.803,36.588,39.179,
     -1.000,-1.000,-1.000,6.130,8.859,11.536,14.213,16.976,19.687,22.347,25.033,27.753,30.472,33.303,35.955,38.632,
     -1.000,-1.000,-1.000,-1.000,8.413,11.105,13.789,16.423,19.140,21.791,24.614,27.232,30.023,32.575,35.431,37.991,
     -1.000,-1.000,-1.000,-1.000,8.069,10.695,13.361,16.075,18.693,21.287,24.056,26.802,29.476,32.181,34.712,37.465,
     -1.000,-1.000,-1.000,-1.000,7.624,10.358,12.976,15.649,18.182,20.878,23.511,26.338,28.840,31.574,34.123,36.773,
     -1.000,-1.000,-1.000,-1.000,7.266,9.900,12.504,15.122,17.748,20.427,23.023,25.783,28.379,30.856,33.542,36.190,
     -1.000,-1.000,-1.000,-1.000,6.865,9.484,12.081,14.693,17.276,20.017,22.369,25.074,27.650,30.211,32.887,35.528,
     -1.000,-1.000,-1.000,-1.000,-1.000,9.058,11.670,14.275,16.880,19.379,22.055,24.575,27.103,29.736,32.152,34.778,
     -1.000,-1.000,-1.000,-1.000,-1.000,8.669,11.234,13.799,16.357,18.880,21.411,24.044,26.540,29.044,31.533,34.084,
     -1.000,-1.000,-1.000,-1.000,-1.000,8.250,10.823,13.316,15.862,18.376,20.876,23.509,26.048,28.475,30.969,33.316,
     -1.000,-1.000,-1.000,-1.000,-1.000,7.788,10.272,12.833,15.356,17.776,20.395,22.989,25.493,27.919,30.209,32.874,
     -1.000,-1.000,-1.000,-1.000,-1.000,7.269,10.014,12.307,14.883,17.245,19.796,22.334,24.696,27.259,29.703,32.135,
     -1.000,-1.000,-1.000,-1.000,-1.000,6.954,9.353,11.882,14.281,16.852,19.203,21.712,24.100,26.609,28.978,31.427,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,8.958,11.435,13.817,16.228,18.639,20.991,23.575,25.861,28.242,30.713,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,8.519,10.982,13.264,15.698,18.062,20.502,22.720,25.096,27.769,29.981,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,7.884,10.322,12.778,15.222,17.564,19.860,22.242,24.572,27.028,29.069,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,7.606,9.966,12.353,14.679,17.022,19.271,21.591,23.884,26.127,28.393,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,7.102,9.566,11.844,14.205,16.424,18.686,21.041,23.157,25.316,27.541,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,6.679,8.976,11.236,13.571,15.921,18.117,20.457,22.446,24.653,26.786,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,8.542,10.816,13.011,15.377,17.557,19.659,21.813,24.034,26.079,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,8.020,10.316,12.455,14.756,16.874,19.007,20.973,23.152,24.975,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,7.565,9.713,11.966,14.205,16.284,18.318,20.461,22.441,24.435,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,7.133,9.228,11.391,13.540,15.664,17.876,19.678,21.540,23.683,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,6.727,8.847,10.891,13.078,15.088,17.046,18.965,20.942,22.813,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,8.407,10.434,12.311,14.530,16.323,18.303,20.171,21.903,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,7.910,9.839,11.941,13.975,15.811,17.790,19.484,-1.000]';
%c
%c +++ Brake Torque data for (bore,stroke) = (3,2); Bore = 9.73; Stroke = 8.80
%c
sclpg(3,2,1:ldptspg,1:rpmptpg,5)=...
     [3.462,8.515,12.056,15.756,19.258,22.839,26.579,30.120,33.781,37.362,40.903,44.563,48.105,51.845,55.545,59.086,
     3.001,8.117,11.630,15.313,18.860,22.475,26.056,29.569,33.252,36.833,40.448,43.893,47.815,50.952,54.772,58.353,
     2.686,7.848,11.399,14.772,18.502,22.083,25.694,29.275,32.915,36.466,40.197,43.628,47.418,50.910,54.550,58.012,
     2.255,7.507,10.955,14.483,18.064,21.619,25.200,28.674,32.229,36.102,39.683,43.290,46.898,50.664,54.033,57.641,
     1.767,7.210,10.576,14.037,17.690,21.128,24.876,28.314,31.775,35.428,39.009,42.447,46.171,49.728,53.476,56.818,
     -1.000,6.793,10.179,13.629,17.167,20.857,24.329,27.888,31.361,35.137,38.805,42.299,45.468,49.244,52.803,56.493,
     -1.000,6.386,9.788,13.250,16.910,20.392,24.013,27.673,31.015,34.417,38.376,41.738,44.981,48.304,52.024,55.883,
     -1.000,5.950,9.311,12.947,16.436,19.907,23.377,26.940,30.558,34.120,37.665,41.227,44.716,48.279,51.658,55.166,
     -1.000,5.627,8.918,12.482,15.910,19.491,22.850,26.550,30.080,33.474,37.089,40.550,44.319,47.832,51.123,54.840,
     -1.000,5.109,8.467,11.857,15.597,18.955,22.536,26.006,29.587,32.929,36.526,39.805,43.959,47.142,50.834,54.176,
     -1.000,4.715,7.983,11.429,15.040,18.397,21.844,25.261,29.051,32.363,35.884,39.451,43.539,46.508,49.820,53.476,
     -1.000,4.199,7.541,10.954,14.478,17.849,21.388,24.955,28.465,31.822,35.248,38.759,42.143,46.286,49.263,52.690,
     -1.000,-1.000,6.937,10.464,13.780,17.335,20.810,24.139,27.786,31.075,34.590,38.356,41.699,45.465,48.502,52.163,
     -1.000,-1.000,6.521,9.889,13.394,16.724,20.179,23.572,27.178,30.595,34.176,37.393,40.836,43.977,47.872,50.875,
     -1.000,-1.000,6.076,9.442,12.736,16.103,19.672,23.002,26.392,30.068,33.160,36.848,40.155,43.270,46.827,50.575,
     -1.000,-1.000,5.457,8.901,12.221,15.529,18.996,22.282,25.908,29.137,32.570,35.980,39.436,42.733,46.405,49.258,
     -1.000,-1.000,5.013,8.236,11.644,14.953,18.350,21.942,25.197,28.518,31.892,35.398,38.555,42.006,45.262,48.951,
     -1.000,-1.000,-1.000,7.889,11.127,14.469,17.708,21.029,24.558,27.755,30.983,34.699,37.855,41.166,44.498,47.778,
     -1.000,-1.000,-1.000,7.172,10.494,13.837,17.040,20.491,23.883,27.166,30.379,33.751,37.023,40.405,43.589,46.752,
     -1.000,-1.000,-1.000,6.637,9.836,13.092,16.492,19.691,22.976,26.509,29.631,32.802,36.115,39.362,42.829,46.104,
     -1.000,-1.000,-1.000,5.950,9.412,12.451,15.821,19.154,22.340,25.627,28.841,32.009,35.553,38.656,41.898,45.387,
     -1.000,-1.000,-1.000,5.447,8.639,11.919,15.067,18.427,21.663,24.864,27.985,31.292,34.492,37.605,41.027,43.962,
     -1.000,-1.000,-1.000,4.792,8.108,11.272,14.494,17.760,20.966,24.027,27.446,30.455,33.550,36.867,39.919,43.134,
     -1.000,-1.000,-1.000,-1.000,7.598,10.702,13.912,16.999,20.152,23.429,26.458,29.570,32.937,35.975,39.144,42.009,
     -1.000,-1.000,-1.000,-1.000,6.852,10.067,13.083,16.377,19.457,22.552,25.783,28.807,31.807,34.839,38.078,41.253,
     -1.000,-1.000,-1.000,-1.000,6.115,9.457,12.507,15.702,18.690,21.802,24.805,27.939,31.028,34.000,36.996,40.038,
     -1.000,-1.000,-1.000,-1.000,5.528,8.662,11.877,14.816,17.860,21.038,24.112,26.910,29.901,32.975,36.138,38.898,
     -1.000,-1.000,-1.000,-1.000,4.912,8.059,11.163,14.259,17.290,20.090,23.186,26.123,29.227,32.055,35.166,38.045,
     -1.000,-1.000,-1.000,-1.000,-1.000,7.415,10.420,13.573,16.466,19.548,22.300,25.081,28.100,31.042,34.026,36.926,
     -1.000,-1.000,-1.000,-1.000,-1.000,6.746,9.815,12.741,15.743,18.560,21.343,24.351,27.113,30.026,32.802,35.673,
     -1.000,-1.000,-1.000,-1.000,-1.000,5.955,9.045,11.923,14.927,17.726,20.703,23.363,26.194,28.926,31.579,34.278,
     -1.000,-1.000,-1.000,-1.000,-1.000,5.465,8.278,11.362,14.092,17.105,19.744,22.305,25.144,28.087,30.616,33.035,
     -1.000,-1.000,-1.000,-1.000,-1.000,4.781,7.677,10.529,13.570,15.995,19.017,21.756,24.181,26.964,29.295,31.908,
     -1.000,-1.000,-1.000,-1.000,-1.000,4.193,6.929,9.733,12.530,15.407,18.131,20.837,23.402,26.083,28.489,30.656,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,6.320,9.018,11.823,14.634,17.153,20.030,22.148,24.965,27.490,29.818,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,5.776,8.495,11.121,13.835,16.292,19.128,21.573,23.885,26.028,28.363,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,5.116,7.702,10.356,13.005,15.773,18.127,20.537,22.896,25.209,27.324,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,4.369,7.090,9.616,12.336,15.112,17.239,19.637,21.847,24.234,25.855,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,3.814,6.424,8.860,11.606,14.085,16.456,18.757,20.732,22.962,25.251,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,3.194,5.740,8.324,10.838,13.199,15.486,17.894,20.027,22.022,24.245,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,5.257,7.588,10.063,12.513,14.921,16.805,19.119,20.983,22.918,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,4.500,7.060,9.326,11.825,13.994,16.061,18.108,20.145,21.943,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,3.835,6.351,8.838,11.021,13.210,15.309,17.124,19.123,20.964,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,3.211,5.754,8.029,10.144,12.370,14.504,16.356,18.114,19.898,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,2.478,4.908,7.286,9.645,11.750,13.550,15.699,17.461,19.046,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,4.410,6.642,8.866,11.033,13.027,14.820,16.510,18.148,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,3.843,6.092,8.282,10.481,12.318,14.026,15.788,-1.000]';
%c
%c +++ Brake Torque data for (bore,stroke) = (3,3); Bore = 9.73; Stroke = 10.44
%c
sclpg(3,3,1:ldptspg,1:rpmptpg,5)=...
     [3.422,9.748,14.125,18.462,22.680,26.897,31.194,35.531,39.550,44.086,48.144,52.680,56.659,61.314,65.413,69.829,
     2.762,9.345,13.437,17.871,22.066,26.397,30.626,34.787,39.118,43.586,47.849,52.010,56.307,60.843,65.106,69.369,
     2.029,8.923,13.071,17.278,21.516,25.694,29.901,34.049,38.376,42.733,46.821,51.148,55.446,59.802,64.010,68.665,
     1.247,8.409,12.308,16.499,20.849,24.934,29.205,33.635,37.852,42.070,46.075,50.664,54.723,59.153,63.185,67.827,
     -3.318,7.878,11.889,16.019,20.173,24.518,28.600,32.873,37.123,41.301,45.884,49.704,53.834,58.084,62.405,66.797,
     -1.000,7.379,11.177,15.387,19.728,23.721,27.975,32.055,36.396,40.758,44.578,48.962,53.281,57.469,61.680,65.934,
     -1.000,6.724,10.743,14.762,19.039,23.018,27.235,31.552,35.551,39.610,43.967,48.025,52.402,56.878,60.539,65.194,
     -1.000,5.858,9.990,14.177,18.272,22.496,26.389,30.778,35.351,38.895,43.266,47.269,51.438,55.716,59.518,64.127,
     -1.000,5.133,9.481,13.557,17.649,21.605,26.073,29.910,34.088,38.214,42.000,46.638,50.867,54.977,58.916,63.230,
     -1.000,4.218,8.754,12.796,16.727,21.040,24.956,28.871,33.056,37.195,41.571,45.757,49.831,53.969,58.219,62.070,
     -1.000,2.939,7.863,12.116,16.279,20.337,24.425,28.200,32.527,36.451,40.480,44.792,48.746,53.043,57.191,60.966,
     -1.000,1.152,7.218,11.347,15.546,19.520,23.635,27.707,31.653,35.698,39.798,43.534,48.505,51.580,56.214,60.175,
     -1.000,-1.000,6.379,10.557,14.629,18.661,22.627,26.831,30.717,35.014,38.741,42.932,46.659,51.407,54.471,59.060,
     -1.000,-1.000,5.755,9.738,13.708,17.905,21.825,25.758,29.980,34.026,38.046,41.979,45.824,50.172,53.753,57.396,
     -1.000,-1.000,5.025,8.714,12.892,16.974,20.961,24.888,28.934,32.957,36.681,40.787,45.001,48.606,52.294,56.389,
     -1.000,-1.000,4.343,7.912,12.016,15.950,20.019,24.135,27.875,31.865,35.708,39.709,43.620,47.633,51.555,55.340,
     -1.000,-1.000,3.462,7.173,11.058,15.105,19.207,22.918,26.868,30.883,34.681,38.761,42.744,46.509,50.362,54.116,
     -1.000,-1.000,-1.000,6.415,10.338,14.127,18.092,21.880,25.721,29.800,33.620,37.606,40.927,44.965,49.355,52.926,
     -1.000,-1.000,-1.000,5.620,9.350,13.319,17.219,20.879,24.938,28.578,32.358,35.959,40.356,43.788,47.856,51.467,
     -1.000,-1.000,-1.000,4.660,8.547,12.128,16.215,20.054,23.673,27.416,31.350,34.893,38.952,42.456,46.524,50.201,
     -1.000,-1.000,-1.000,3.976,7.722,11.321,15.215,19.108,22.698,26.215,30.053,33.836,37.646,41.209,44.854,48.343,
     -1.000,-1.000,-1.000,3.245,6.667,10.398,14.103,17.737,21.990,25.376,28.825,32.591,36.155,39.842,43.228,46.871,
     -1.000,-1.000,-1.000,2.234,5.781,9.609,13.019,16.890,20.591,24.214,27.736,31.265,34.574,38.197,41.727,44.933,
     -1.000,-1.000,-1.000,-1.000,4.915,8.784,12.225,15.699,19.502,23.157,26.499,30.179,33.554,37.045,40.148,43.787,
     -1.000,-1.000,-1.000,-1.000,4.170,7.639,11.197,14.785,18.311,21.629,25.027,28.807,32.141,35.627,38.619,41.778,
     -1.000,-1.000,-1.000,-1.000,3.050,6.831,10.350,13.692,17.166,20.608,23.658,27.423,30.951,33.754,37.057,40.315,
     -1.000,-1.000,-1.000,-1.000,2.231,5.864,9.281,12.884,16.174,19.404,22.642,26.149,29.304,32.542,35.616,38.563,
     -1.000,-1.000,-1.000,-1.000,1.331,4.529,8.442,11.626,15.199,18.433,21.508,24.929,27.744,31.064,33.914,37.069,
     -1.000,-1.000,-1.000,-1.000,-1.000,3.974,7.576,10.926,14.134,17.378,20.391,23.761,26.619,29.498,32.425,35.445,
     -1.000,-1.000,-1.000,-1.000,-1.000,3.042,6.480,9.911,13.042,16.227,19.378,22.270,25.026,28.061,30.537,33.027,
     -1.000,-1.000,-1.000,-1.000,-1.000,2.155,5.411,8.773,11.983,15.339,18.170,21.108,24.125,26.937,29.411,31.844,
     -1.000,-1.000,-1.000,-1.000,-1.000,1.123,4.633,8.285,11.053,14.298,16.950,20.047,22.841,25.280,27.977,30.358,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.721,3.757,7.099,10.240,13.080,16.114,18.960,21.411,24.024,26.575,29.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-3.673,2.932,5.968,9.017,12.273,15.065,17.636,20.415,22.643,25.306,27.356,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,1.880,5.210,8.272,11.089,14.181,16.664,19.421,21.593,24.034,26.135,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-0.035,4.536,7.424,10.335,13.154,15.617,18.039,20.362,22.604,24.706,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.898,3.314,6.264,9.527,12.141,14.608,16.944,19.246,21.566,23.174,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-3.259,2.321,5.269,8.322,11.015,13.347,16.212,18.349,20.370,22.019,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-3.532,1.535,4.552,7.574,10.341,12.729,15.111,17.048,19.261,21.052,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-3.979,-0.732,3.783,6.467,9.183,11.581,13.995,15.979,18.250,19.985,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-2.003,2.828,5.818,8.491,10.878,13.177,15.243,17.267,18.995,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-2.606,1.849,4.734,7.385,9.646,12.186,14.222,16.107,17.803,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-3.442,0.945,3.845,6.555,8.997,11.305,13.299,14.871,17.000,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-3.323,-0.619,2.816,5.656,8.117,10.324,12.497,14.285,15.708,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-3.901,-2.077,2.110,4.827,7.429,9.325,11.364,13.383,14.902,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-2.542,1.222,4.054,6.563,8.636,10.551,12.288,14.020,
     -1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-1.000,-3.122,-0.331,3.071,5.270,7.630,9.756,11.491,-1.000]';
%c
%c +++++++++++++++++++++++++++++++++++++++++++++++++++
%c +++ End of emission data for Port Injected SI +++++
%c +++++++++++++++++++++++++++++++++++++++++++++++++++
end