function display(cyc)
if length(cyc)>1
    for i=1:length(cyc)
        display(cyc(i));
    end
    return
end

[P, K, A, R, accel, dhdt, dist] = specificPower(cyc);
[velbar, accbar, decbar, velmax, accmax, decmax, hist, driveTime, velbarDrive, nStarts, nStops] = cycStats(cyc); 

disp(['Cycle Audit Class: ', cyc.name])
disp('--------------------------------------------------------------------------------------------')
disp(['Max Time  : ',num2str(max(cyc.t)),' seconds'])
disp(['Idle Time : ',num2str(max(cyc.t)-driveTime),' seconds (',num2str( (max(cyc.t)-driveTime)*100/max(cyc.t) ),'%)'])
disp(['Drive Time: ',num2str(driveTime),' seconds (',num2str(driveTime*100/max(cyc.t)),'%)'])
disp(['# Starts  : ',num2str(nStarts) ])
disp(['# Stops   : ',num2str(nStops)  ])
disp('--------------------------------------------------------------------------------------------')
disp(['Statistics                            : '])
disp(['-- average velocity (over whole cycle): ', num2str(velbar), ' m/s'])
disp(['-- average velocity while driving     : ', num2str(velbarDrive), ' m/s'])
disp(['-- average acceleration during accel  : ', num2str(accbar), ' m/s/s'])
disp(['-- average deceleration during decel  : ', num2str(decbar), ' m/s/s'])
disp(['-- peak velocity                      : ', num2str(velmax), ' m/s'])
disp(['-- peak acceleration                  : ', num2str(accmax), ' m/s/s'])
disp(['-- peak deceleration                  : ', num2str(decmax), ' m/s/s'])
disp(['-- distance traveled                  : ', num2str(max(dist)), ' m, ', num2str(max(dist)/1609.344),' miles'])
disp('--------------------------------------------------------------------------------------------')
disp(['Deltas                                : '])
disp(['-- height differential                : ', num2str(cyc.h(end)-cyc.h(1)), ' m'])
disp(['-- velocity differential              : ', num2str(cyc.v(end)-cyc.v(1)), ' m/s'])
disp('--------------------------------------------------------------------------------------------')
disp(['Specific Energy                       : '])
disp(['-- Specific Potential Energy          : ', num2str(P.E),' (J/kg/G), ',num2str(P.E/3600),' (Wh/kg/G)'])
disp(['-- Specific Kinetic Energy            : ', num2str(K.E),' (J/kg), ',num2str(K.E/3600),' (Wh/kg)'])
disp(['-- Specific Aerodynamic Energy        : ', num2str(A.E),' (J/rho/CD/FA), ',num2str(A.E/3600),' (Wh/rho/CD/FA)'])
disp(['-- Specific Rolling Resistance Energy : ', num2str(R.E),' (J/G/kg/RRC0), ',num2str(R.E/3600),' (Wh/G/kg/RRC0)'])
disp('--------------------------------------------------------------------------------------------')
disp(['Specific Energy use                   : '])
disp(['-- Specific Potential Energy use      : ', num2str(P.Eexpend),' (J/kg/G), ',num2str(P.Eexpend/3600),' (Wh/kg/G)'])
disp(['-- Specific Kinetic Energy use        : ', num2str(K.Eexpend),' (J/kg), ',num2str(K.Eexpend/3600),' (Wh/kg)'])
disp(['-- Specific Aerodynamic Energy use    : ', num2str(A.Eexpend),' (J/rho/CD/FA), ',num2str(A.Eexpend/3600),' (Wh/rho/CD/FA)'])
disp(['-- Specific Roll. Resist. Energy use  : ', num2str(R.Eexpend),' (J/G/kg/RRC0), ',num2str(R.Eexpend/3600),' (Wh/G/kg/RRC0)'])
disp('--------------------------------------------------------------------------------------------')
disp(['Specific Energy gain                  : '])
disp(['-- Specific Potential Energy gain     : ', num2str(P.Eregen),' (J/kg/G), ',num2str(P.Eregen/3600),' (Wh/kg/G)'])
disp(['-- Specific Kinetic Energy gain       : ', num2str(K.Eregen),' (J/kg), ',num2str(K.Eregen/3600),' (Wh/kg)'])
disp(['-- Specific Aerodynamic Energy gain   : ', num2str(A.Eregen),' (J/rho/CD/FA), ',num2str(A.Eregen/3600),' (Wh/rho/CD/FA)'])
disp(['-- Specific Roll. Resist. Energy gain : ', num2str(R.Eregen),' (J/G/kg/RRC0), ',num2str(R.Eregen/3600),' (Wh/G/kg/RRC0)'])
disp('--------------------------------------------------------------------------------------------')
disp(['Ave. Specific Power use               : '])
disp(['-- Ave. Specific Potential Power use  : ', num2str(P.PaveExpend),' (W/kg/G)'])
disp(['-- Ave. Specific Kinetic Power use    : ', num2str(K.PaveExpend),' (W/kg)'])
disp(['-- Specific Aerodynamic Power use     : ', num2str(A.PaveExpend),' (W/rho/CD/FA)'])
disp(['-- Specific Roll. Resist. Power use   : ', num2str(R.PaveExpend),' (W/G/kg/RRC0)'])
disp('--------------------------------------------------------------------------------------------')
disp(['Ave. Specific Power gain              : '])
disp(['-- Ave. Specific Potential Power gain : ', num2str(P.PaveRegen),' (W/kg/G)'])
disp(['-- Ave. Specific Kinetic Power gain   : ', num2str(K.PaveRegen),' (W/kg)'])
disp(['-- Specific Aerodynamic Power gain    : ', num2str(A.PaveRegen),' (W/rho/CD/FA)'])
disp(['-- Specific Roll. Resist. Power gain  : ', num2str(R.PaveRegen),' (W/G/kg/RRC0)'])
disp('--------------------------------------------------------------------------------------------')
disp(['Speed Histogram -- by time            :'])
for i=1:size(hist.vel.bin,1)
    disp(['--  ', num2str(hist.vel.bin(i,1)),' to ', num2str(hist.vel.bin(i,2)),' mph :', num2str(hist.vel.time(i)),' seconds, ', num2str(hist.vel.percentTime(i)*100),'% '])
end
disp(['Acceleration Histogram -- by time     :'])
for i=1:size(hist.acc.bin,1)
    disp(['--  ', num2str(hist.acc.bin(i,1)),' to ', num2str(hist.acc.bin(i,2)),' m/s/s :', num2str(hist.acc.time(i)),' seconds, ', num2str(hist.acc.percentTime(i)*100),'% '])
end
[hist, cumdist] = distanceHist(cyc, hist.vel.bin, 0);
disp(['Speed Histogram -- by distance        :'])
for i=1:size(hist.vel.bin,1)
    disp(['--  ', num2str(hist.vel.bin(i,1)),' to ', num2str(hist.vel.bin(i,2)),' mph :', num2str(hist.vel.distance(i)),' meters, ', num2str(hist.vel.percentDist(i)*100),'% '])
end
disp(['Acceleration Histogram -- by distance :'])
for i=1:size(hist.acc.bin,1)
    disp(['--  ', num2str(hist.acc.bin(i,1)),' to ', num2str(hist.acc.bin(i,2)),' m/s/s :', num2str(hist.acc.distance(i)),' meters, ', num2str(hist.acc.percentDist(i)*100),'% '])
end
disp( 'KEY                                   :')
disp( '.. G is acceleration of gravity (m/s/s), ')
disp( '.. RRC0 is the zeroth (speed independent) rolling resistance coefficient: N of rolling resistance/N of weight on the tires')
disp( '.. rho is the density of air (kg/m/m/m),')
disp( '.. CD is the coefficient of drag, ')
disp( '.. FA is vehicle frontal area (m*m),')
disp( '.. ''kg'' refers to the vehicle mass')
disp('--------------------------------------------------------------------------------------------')