function CreateModelFile(NewModelName,Directory,Data,DataNames)
%   function CreateModelFile(NewModelName,Directory,Data,DataNames)
%       This model creates a file NewModelName in directory Directory with the Data corresponding to the DataNames

%   Store current directory to restore after function call
CurrentWorkingDir=cd;

cd(Directory);
clear([NewModelName,'.m']);

file=[NewModelName];
ext_name='.m';
file_name=strcat(Directory,file,ext_name);

%   Write new file
fid=fopen(file_name,'w');
fprintf(fid,'%% This file is generated by CreateModelFile.m\n');
fprintf(fid,'%%     It stores data for specific models\n');
fprintf(fid,['function [Data]=',file,'\n']);
%fprintf(fid,' v1 = %f; v2 = %f; v3 = %f;\n',Data(1:3,1));

if ~isempty(DataNames) & length(DataNames)==length(Data)
    for i=1:length(Data)
        %fprintf(fid,[DataNames(i),'=%f;\n'],Data(i));
        fprintf(fid,[DataNames{i},'=',num2str(Data(i)),';','\n']);
    end
    fprintf(fid,['Data=([']);
    for i=1:(length(DataNames)-1)
        fprintf(fid,[DataNames{i},' ']);
    end
    fprintf(fid,[DataNames{length(DataNames)}]);
    fprintf(fid,']);');
else
    
    
    
    
end

fclose(fid);

%   Restore original working dir
cd(CurrentWorkingDir);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Revision notes
% 08/02/01: ab file created (first working)