function Names=GetLoadNames(Type)
%=====================================================================================
% GetLoadNames(Type)
%   This function returns the Type of LoadNames
%=====================================================================================

switch Type
case 'All'
    Names={'RearDefrost'
        'HeatedSeats'
        'Radio'
        'RearWipers'
        'FrontWipers'
        'TurnSignals'
        'Misc'
        'FrontHVAC'
        'RearHVAC'
        'Engine'
        'ExternalLights'
        'RadiatorCoolingFan'
        'BrakeLights'
        'Starter'
        'PowerLoad1'
        'PowerLoad2'
        'PowerLoad3'
        'CurrentLoad1'
        'SpeedLoad1'};
    
case 'CycleDependent'
    Names={'Misc'
        'Engine'
        'Starter'
        'BrakeLights'};
    
case 'LoadChoice'
    Names={'HeatedSeats'
        'Radio'
        'FrontHVAC'
        'RearHVAC'
        'ExternalLights'
        'RadiatorCoolingFan'};
    
case 'StandardVehType'
    Names={'Large_Car_1'
        'Large_Car_2'
        'Large_Car_3'
        'Large_Car_Ave'
        'Mid_Sized_Car_1'
        'Mid_Sized_Car_2'
        'Mid_Sized_Car_3'
        'Mid_Sized_Car_Ave'
        'Pickup_1'
        'Sub_Compact_Car_1'
        'Sub_Compact_Car_2'
        'Sub_Compact_Car_3'
        'Sub_Compact_Car_4'
        'Sub_Compact_Car_Ave'
        'SUV_1'
        'SUV_2'
        'SUV_3'
        'SUV_4'
        'SUV_Ave'};
    
case 'UserDefined'
    Names={'RearDefrost'
        'HeatedSeats'
        'Radio'
        'RearWipers'
        'FrontWipers'
        'TurnSignals'
        'Misc'
        'FrontHVAC'
        'RearHVAC'
        'Engine'
        'ExternalLights'
        'RadiatorCoolingFan'
        'BrakeLights'
        'Starter'
        'PowerLoad1'
        'PowerLoad2'
        'PowerLoad3'
        'CurrentLoad1'
        'SpeedLoad1'};
    
case 'UserDefinedSV'
    Names={'RearDefrost'
        'HeatedSeats'
        'Radio'
        'RearWipers'
        'FrontWipers'
        'TurnSignals'
        'Misc'
        'FrontHVAC'
        'RearHVAC'
        'Engine'
        'ExternalLights'
        'RadiatorCoolingFan'
        'BrakeLights'
        'Starter'};
    
case 'Volt42OnlyLoad'
    Names={'PowerLoad1'
        'PowerLoad2'
        'PowerLoad3'
        'CurrentLoad1'
        'SpeedLoad1'};
    
case 'Volt14OnlyLoad'
    Names={'RearDefrost'
        'HeatedSeats'
        'Radio'
        'RearWipers'
        'FrontWipers'
        'TurnSignals'
        'Misc'
        'FrontHVAC'
        'RearHVAC'
        'Engine'
        'ExternalLights'
        'RadiatorCoolingFan'
        'BrakeLights'};
    
case 'Volt42Or14Loads'
    Names={'Starter'};
    
case 'CurrentLoad'
    Names={'RearDefrost'
        'HeatedSeats'
        'Radio'
        'RearWipers'
        'FrontWipers'
        'TurnSignals'
        'Misc'
        'FrontHVAC'
        'RearHVAC'
        'Engine'
        'ExternalLights'
        'RadiatorCoolingFan'
        'BrakeLights'
        'CurrentLoad1'};
    
case 'PowerLoad'
    Names={'PowerLoad1'
        'PowerLoad2'
        'PowerLoad3'
        'Starter'};
    
case 'SpeedLoad'
    Names={'SpeedLoad1'};
    
case 'SingleCurrentLoad'
    Names={''};
    
case 'StandardVehTypeNames'
    Names={'BrakeLights\V14\Large_Car_1'
        'BrakeLights\V14\Mid_Sized_Car_1'
        'BrakeLights\V14\Sub_Compact_Car_1'
        'BrakeLights\V14\Small_SUV_1'
        'CurrentLoad1\Default'
        'Engine\V14\Large_Car_1'
        'Engine\V14\Mid_Sized_Car_1'
        'Engine\V14\Sub_Compact_Car_1'
        'Engine\V14\Small_SUV_1'
        'ExternalLights\V14\Large_Car_1'
        'ExternalLights\V14\Mid_Sized_Car_1'         
        'ExternalLights\V14\Small_SUV_1'                   
        'ExternalLights\V14\Sub_Compact_Car_1'           
        'FrontHVAC\V14\Large_Car_1'                      
        'FrontHVAC\V14\Mid_Sized_Car_1'                  
        'FrontHVAC\V14\Small_SUV_1'                            
        'FrontHVAC\V14\Sub_Compact_Car_1'                    
        'FrontWipers\V14\Large_Car_1'                              
        'FrontWipers\V14\Mid_Sized_Car_1'                          
        'FrontWipers\V14\Small_SUV_1'                                    
        'FrontWipers\V14\Sub_Compact_Car_1'                            
        'HeatedSeats\V14\Large_Car_1'                        
        'HeatedSeats\V14\Small_SUV_1'                              
        'Misc\V14\Large_Car_1'                                     
        'Misc\V14\Mid_Sized_Car_1'                                 
        'Misc\V14\Small_SUV_1'                                           
        'Misc\V14\Sub_Compact_Car_1'                                   
        'PowerLoad1\V42\Catalyst_Heater'                                
        'PowerLoad2\V42\Oil_Pump'                                 
        'PowerLoad3\V42\Water_Pump'                                 
        'RadiatorCoolingFan\V14\Large_Car_1'                 
        'RadiatorCoolingFan\V14\Mid_Sized_Car_1'             
        'RadiatorCoolingFan\V14\Sub_Compact_Car_1'               
        'Radio\V14\Large_Car_1'                             
        'Radio\V14\Mid_Sized_Car_1'                         
        'Radio\V14\Small_SUV_1'                                   
        'Radio\V14\Sub_Compact_Car_1'                           
        'RearDefrost\V14\Large_Car_1'                             
        'RearDefrost\V14\Mid_Sized_Car_1'                          
        'RearDefrost\V14\Small_SUV_1'                                    
        'RearDefrost\V14\Sub_Compact_Car_1'                            
        'RearHVAC\V14\Minivan'                                   
        'RearWipers\V14\Small_SUV_1'                                     
        'SpeedLoad1\V42\ElectMagValvtrn'                                 
        'Starter\V14\Default'   
        'Starter\V42\Default'
        'TurnSignals\V14\Large_Car_1'                              
        'TurnSignals\V14\Mid_Sized_Car_1'                          
        'TurnSignals\V14\Small_SUV_1'                                    
        'TurnSignals\V14\Sub_Compact_Car_1'};
    
case 'StandardSaberVehTypes'
    Names={'BrakeLights\V14\Large_Car_1'
        'BrakeLights\V14\Mid_Sized_Car_1'
        'BrakeLights\V14\Sub_Compact_Car_1'
        'BrakeLights\V14\Small_SUV_1'
        'Engine\V14\Large_Car_1'
        'Engine\V14\Mid_Sized_Car_1'
        'Engine\V14\Sub_Compact_Car_1'
        'Engine\V14\Small_SUV_1'
        'ExternalLights\V14\Large_Car_1'
        'ExternalLights\V14\Mid_Sized_Car_1'         
        'ExternalLights\V14\Small_SUV_1'                   
        'ExternalLights\V14\Sub_Compact_Car_1'           
        'FrontHVAC\V14\Large_Car_1'                      
        'FrontHVAC\V14\Mid_Sized_Car_1'                  
        'FrontHVAC\V14\Small_SUV_1'                            
        'FrontHVAC\V14\Sub_Compact_Car_1'                    
        'FrontWipers\V14\Large_Car_1'                              
        'FrontWipers\V14\Mid_Sized_Car_1'                          
        'FrontWipers\V14\Small_SUV_1'                                    
        'FrontWipers\V14\Sub_Compact_Car_1'                            
        'HeatedSeats\V14\Large_Car_1'                        
        'HeatedSeats\V14\Small_SUV_1'                              
        'Misc\V14\Large_Car_1'                                     
        'Misc\V14\Mid_Sized_Car_1'                                 
        'Misc\V14\Small_SUV_1'                                           
        'Misc\V14\Sub_Compact_Car_1'                                   
        'RadiatorCoolingFan\V14\Large_Car_1'                 
        'RadiatorCoolingFan\V14\Mid_Sized_Car_1'             
        'RadiatorCoolingFan\V14\Sub_Compact_Car_1'               
        'Radio\V14\Large_Car_1'                             
        'Radio\V14\Mid_Sized_Car_1'                         
        'Radio\V14\Small_SUV_1'                                   
        'Radio\V14\Sub_Compact_Car_1'                           
        'RearDefrost\V14\Large_Car_1'                             
        'RearDefrost\V14\Mid_Sized_Car_1'                          
        'RearDefrost\V14\Small_SUV_1'                                    
        'RearDefrost\V14\Sub_Compact_Car_1'                            
        'RearWipers\V14\Small_SUV_1'                                     
        'TurnSignals\V14\Large_Car_1'                              
        'TurnSignals\V14\Mid_Sized_Car_1'                          
        'TurnSignals\V14\Small_SUV_1'                                    
        'TurnSignals\V14\Sub_Compact_Car_1'};
        
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Revision notes
% 08/02/01: ab file created (first working)