function fig = gui_ftp_results()
% This is the machine-generated representation of a Handle Graphics object
% and its children.  Note that handle values may change when these objects
% are re-created. This may cause problems with any callbacks written to
% depend on the value of the handle at the time the object was saved.
%
% To reopen this object, just type the name of the M-file at the MATLAB
% prompt. The M-file and its associated MAT-file must be on your path.
global vinf

%colors for all items of figure
figure_color=[.7 0.9 1];

screen=get(0,'screensize');

h0 = figure('Color',figure_color, ...
   'MenuBar','none',...
	'Name',['FTP Results--',advisor_ver('info')], ...
   'NumberTitle','off', ...
   'Position',[(screen(3)-509)/2 (screen(4)-363)/2 509 363], ...
   'Tag','ftp_results_figure');

%load advisor menubar
adv_menu('ftp results')


%title
h1 = uicontrol('Parent',h0, ...
   'BackgroundColor',figure_color, ...
	'FontSize',12, ...
	'Position',[15 331 372 25], ...
	'String','FTP Results', ...
	'Style','text', ...
	'Tag','StaticText1');

%Fuel Economy Section
%Title
if strcmp(vinf.units,'metric')
   str='Fuel Consumption (L/100 km)';
else
   str='Fuel Economy (mpg)';
end
h1 = uicontrol('Parent',h0, ...
   'BackgroundColor',figure_color, ...
	'FontWeight','bold', ...
	'Position',[34 300 170 18], ...
	'String',str, ...
	'Style','text');

%Headings
if strcmp(vinf.units,'metric')
   str='L/100 km';
else
   str='mpg';
end
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',figure_color, ...
	'Position',[80 282 123 18], ...
	'String',str, ...
	'Style','text');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',figure_color, ...
	'Position',[80 252 123 18], ...
	'String','Gasoline Equivalent', ...
	'Style','text');

%fuel economy values
if strcmp(vinf.units,'metric')
   str=evalin('base','num2str(round(10*units(''gpm2lp100km'')/mpg)/10)');
	str2=evalin('base','num2str(round(10*units(''gpm2lp100km'')/mpgge)/10)');   
else
   str=evalin('base','num2str(round(10*mpg)/10)');
	str2=evalin('base','num2str(round(10*mpgge)/10)');
end

h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',[1 1 1], ...
	'FontWeight','bold', ...
	'Position',[200 282 58 18], ...
	'String',str, ...
	'Style','text', ...
	'Tag','mpg');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',[1 1 1], ...
	'FontWeight','bold', ...
	'Position',[200 252 59 18], ...
	'String',str2, ...
	'Style','text', ...
	'Tag','gaseq');

%Emissions Section
%title
if strcmp(vinf.units,'metric')
   str='Emissions (grams/km)';
else
   str='Emissions (grams/mile)';
end
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',figure_color, ...
	'FontWeight','bold', ...
	'Position',[34 216 140 18], ...
	'String',str, ...
	'Style','text');
%headings
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',figure_color, ...
	'Position',[27   178    109    18], ...
	'String','Bag 1 (0-505 sec)', ...
	'Style','text');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',figure_color, ...
	'Position',[27 145 109 18], ...
	'String','Bag 2 (505-1374 sec)', ...
	'Style','text');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',figure_color, ...
	'Position',[27 112 109 18], ...
	'String','Bag 3 (1974-end sec)', ...
   'Style','text');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',figure_color, ...
	'Position',[27 79 109 18], ...
    'FontWeight','bold',...
	'String','Weighted Total', ...
   'Style','text');


h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',figure_color, ...
	'Position',[296 202 58 18], ...
	'String','NOx', ...
	'Style','text');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',figure_color, ...
	'Position',[226 202 58 18], ...
	'String','CO', ...
	'Style','text');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',figure_color, ...
	'Position',[153 202 58 18], ...
	'String','HC', ...
   'Style','text');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',figure_color, ...
	'Position',[366 202 58 18], ...
	'String','PM', ...
	'Style','text');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',figure_color, ...
	'Position',[436 202 58 18], ...
	'String','Fuel', ...
	'Style','text');

%emissions values
%BAG1
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',[1 1 1], ...
	'FontWeight','bold', ...
	'Position',[153   178    58    18], ...
	'String',evalin('base','num2str(round(1000*hc_gpm1*units(''gpm2gpkm''))/1000)'), ...
	'Style','text', ...
	'Tag','bag1 hc');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',[1 1 1], ...
	'FontWeight','bold', ...
	'Position',[226   178    58    18], ...
	'String',evalin('base','num2str(round(1000*co_gpm1*units(''gpm2gpkm''))/1000)'), ...
	'Style','text', ...
	'Tag','bag1 co');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',[1 1 1], ...
	'FontWeight','bold', ...
	'Position',[296   178    58    18], ...
	'String',evalin('base','num2str(round(1000*nox_gpm1*units(''gpm2gpkm''))/1000)'), ...
	'Style','text', ...
	'Tag','bag1 nox');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',[1 1 1], ...
	'FontWeight','bold', ...
	'Position',[366   178    58    18], ...
	'String',evalin('base','num2str(round(1000*pm_gpm1*units(''gpm2gpkm''))/1000)'), ...
	'Style','text', ...
	'Tag','bag1 pm');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',[1 1 1], ...
	'FontWeight','bold', ...
	'Position',[436   178    58    18], ...
	'String',evalin('base','num2str(round(1000*fuel_gpm1*units(''gpm2gpkm''))/1000)'), ...
	'Style','text', ...
	'Tag','bag1 fuel');

%BAG2
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',[1 1 1], ...
	'FontWeight','bold', ...
	'Position',[153   145    58    18], ...
	'String',evalin('base','num2str(round(1000*hc_gpm2*units(''gpm2gpkm''))/1000)'), ...
	'Style','text', ...
	'Tag','bag2 hc');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',[1 1 1], ...
	'FontWeight','bold', ...
	'Position',[226   145    58    18], ...
	'String',evalin('base','num2str(round(1000*co_gpm2*units(''gpm2gpkm''))/1000)'), ...
	'Style','text', ...
	'Tag','bag2 co');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',[1 1 1], ...
	'FontWeight','bold', ...
	'Position',[296   145    58    18], ...
	'String',evalin('base','num2str(round(1000*nox_gpm2*units(''gpm2gpkm''))/1000)'), ...
	'Style','text', ...
	'Tag','bag2 nox');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',[1 1 1], ...
	'FontWeight','bold', ...
	'Position',[366   145    58    18], ...
	'String',evalin('base','num2str(round(1000*pm_gpm2*units(''gpm2gpkm''))/1000)'), ...
	'Style','text', ...
	'Tag','bag2 pm');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',[1 1 1], ...
	'FontWeight','bold', ...
	'Position',[436   145    58    18], ...
	'String',evalin('base','num2str(round(1000*fuel_gpm2*units(''gpm2gpkm''))/1000)'), ...
	'Style','text', ...
	'Tag','bag2 fuel');

%BAG3
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',[1 1 1], ...
	'FontWeight','bold', ...
	'Position',[153   117    58    18], ...
	'String',evalin('base','num2str(round(1000*hc_gpm3*units(''gpm2gpkm''))/1000)'), ...
	'Style','text', ...
	'Tag','bag3 hc');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',[1 1 1], ...
	'FontWeight','bold', ...
	'Position',[226   117    58    18], ...
	'String',evalin('base','num2str(round(1000*co_gpm3*units(''gpm2gpkm''))/1000)'), ...
	'Style','text', ...
	'Tag','bag3 co');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',[1 1 1], ...
	'FontWeight','bold', ...
	'Position',[296   117    58    18], ...
	'String',evalin('base','num2str(round(1000*nox_gpm3*units(''gpm2gpkm''))/1000)'), ...
	'Style','text', ...
	'Tag','bag3 nox');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',[1 1 1], ...
	'FontWeight','bold', ...
	'Position',[366   117    58    18], ...
	'String',evalin('base','num2str(round(1000*pm_gpm3*units(''gpm2gpkm''))/1000)'), ...
	'Style','text', ...
	'Tag','bag3 pm');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',[1 1 1], ...
	'FontWeight','bold', ...
	'Position',[436   117    58    18], ...
	'String',evalin('base','num2str(round(1000*fuel_gpm3*units(''gpm2gpkm''))/1000)'), ...
	'Style','text', ...
	'Tag','bag3 fuel');

%weighted total
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',[1 1 1], ...
	'FontWeight','bold', ...
	'Position',[153   79    58    18], ...
	'String',evalin('base','num2str(round(1000*hc_gpm*units(''gpm2gpkm''))/1000)'), ...
	'Style','text', ...
	'Tag','total hc');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',[1 1 1], ...
	'FontWeight','bold', ...
	'Position',[226   79    58    18], ...
	'String',evalin('base','num2str(round(1000*co_gpm*units(''gpm2gpkm''))/1000)'), ...
	'Style','text', ...
	'Tag','total co');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',[1 1 1], ...
	'FontWeight','bold', ...
	'Position',[296   79    58    18], ...
	'String',evalin('base','num2str(round(1000*nox_gpm*units(''gpm2gpkm''))/1000)'), ...
	'Style','text', ...
	'Tag','total nox');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',[1 1 1], ...
	'FontWeight','bold', ...
	'Position',[366   79    58    18], ...
	'String',evalin('base','num2str(round(1000*pm_gpm*units(''gpm2gpkm''))/1000)'), ...
	'Style','text', ...
	'Tag','total pm');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',[1 1 1], ...
	'FontWeight','bold', ...
	'Position',[436   79    58    18], ...
	'String',evalin('base','num2str(round(1000*fuel_gpm*units(''gpm2gpkm''))/1000)'), ...
	'Style','text', ...
	'Tag','total fuel');

notestr='Note:  Total fuel and emissions is weighted as follows: Total=(0.43*Bag1+Bag2+0.57*Bag3)/(.43dist1+dist2+.57dist3)   where Bag* is in grams and dist* is in miles or km depending on units';

h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',figure_color, ...
	'Position',[22 35 373 43], ...
	'String',notestr, ...
	'Style','text');

h1=uicontrol('Parent',h0,...
   'callback','close(gcbf);',...
   'position',[300 4 75 30],...
   'string','Close');

if nargout > 0, fig = h0; end


%Revision history
%9/24/99: vhj was displaying mpgge, now displaying mpg
% 7/21/00 ss: updated name for version info to advisor_ver.
% 1/30/01:tm added text boxes to display fuel bag results
% 2/2/01:tm fixed units label for base fuel economy
%