function gui_init_cond(option)
% function gui_init_cond(option)    ADVISOR 2.0
% This function lets the user select initial conditions for the simulation run
% <option> can be the string 'update' so that the edited variables will be updated

global vinf

drive=vinf.drivetrain.name;

if nargin==0
   
   %set up colors
   figure_color=[.8 .8 1];
   
 	tempnames=fieldnames(vinf.init_conds);%get all the names of the variables pertaining to initial conditions
   height=70+25*max(size(tempnames)); 
    
   if get(0,'screensize')==[1 1 1024 768]
      posfig=[503 154 394 height];
   else
      posfig=[350 100 394 height];
   end
   
   
   h0 = figure('Color',figure_color, ...
      'Position',posfig, ...
      'Tag','Fig2',...
      'NumberTitle','off',...
      'Name',['Initial Conditions--',advisor_ver('info')],...
      'Windowstyle','modal');
   
   %Title
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figure_color, ...
      'Position',[59 height-30 245 21], ...
      'String','Initial Conditions for simulation run', ...
      'Style','text', ...
      'Tag','StaticText1');
   
	x1=31; x2=171; y=height-55; w1=128; w2=79'; h=20;
   
	for tempindex=1:max(size(tempnames))
      
      display_this_one='on'; %start out with this set to 'on' then modify where appropriate
      
      if strcmp(drive,'conventional')&(strncmp('mc',tempnames{tempindex},2)|strncmp('ess_',tempnames{tempindex},4))
            display_this_one='off';
         
      end
      if strcmp(drive,'ev')&(strncmp('fc',tempnames{tempindex},2)|strncmp('ex',tempnames{tempindex},2))
         display_this_one='off';
      end
      
      if strncmp('ess_',tempnames{tempindex},4) & ~isfield(vinf,'energy_storage')
          display_this_one='off';
      end
      
      if strncmp('ess2',tempnames{tempindex},4) & ~isfield(vinf,'energy_storage2')
          display_this_one='off';
      end
      
      if display_this_one
         h1 = uicontrol('Parent',h0, ...
            'BackgroundColor',figure_color, ...
            'Position',[x1 y w1 h], ...
            'String',tempnames{tempindex}, ...
            'Style','text',...
            'enable',display_this_one);
         h1 = uicontrol('Parent',h0, ...
            'BackgroundColor',[1 1 1], ...
            'Position',[x2 y w2 h], ...
            'String',num2str(eval(['vinf.init_conds.',tempnames{tempindex}])),...
            'Style','edit', ...
            'Tag',tempnames{tempindex},...
            'enable',display_this_one);
         
         y=y-25;%lower y for the next uicontrol
         
      end

   end
  
  
   %done, cancel, view variable definitions, load defaults
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[0.8 0.8 0.8],...
      'CallBack','gui_init_cond(''load hot'')',...
      'Position',[293 139 90 25], ...
      'String','Load Hot');
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[0.8 0.8 0.8],...
      'CallBack','gui_init_cond(''load ambient'')',...
      'Position',[293 109 90 25], ...
      'String','Load Ambient');
	h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[0.8 0.8 0.8],...
      'CallBack','gui_init_cond(''load defaults'')',...
      'Position',[293 79 90 25], ...
      'String','Load Defaults');
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[0.8 0.8 0.8],...
      'CallBack','close(gcbf)',...
      'Position',[293 49 90 25], ...
      'String','Cancel');
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[0.8 0.8 0.8],...
      'CallBack','gui_init_cond(''update'');close(gcbf);',...
      'Position',[293 9 90 25], ...
      'String','Done');
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[0.8 0.8 0.8],...
      'CallBack','load_in_browser(''advisor_appendices.html'');',...
      'Position',[20 9 120 25], ...
      'String','view variable definitions');
   
end; %if nargin==0


if nargin>0
   
   switch option
   case 'update'
      tempnames=fieldnames(vinf.init_conds);%get all the names of the variables pertaining to initial conditions
      for tempindex=1:max(size(tempnames))
         eval(['vinf.init_conds.',tempnames{tempindex},'=str2num(get(findobj(''tag'',''',tempnames{tempindex},'''),''string''));']);
      end; %for loop   
   case 'load defaults'
      evalin('base','init_conds;');
      close(gcbf);
      gui_init_cond;
   case 'load ambient'
      evalin('base','init_conds_amb;');
      close(gcbf);
      gui_init_cond;
   case 'load hot'
      evalin('base','init_conds_hot;');
      close(gcbf);
      gui_init_cond;

   otherwise
   end;% end switch option
  
end;%if nargin>0

% 7/21/00 ss: updated name for version info to advisor_ver.
% 2/01/00 kw: added a comma into line 29, column 37 to avoid warning about "MATLAB will require that whitespace, a comma,
%             or a semicolon separate elements of a matrix."
