/*---------------------------------------------------------*/
/*
Definitions used in the database and interface routines
*/
/*---------------------------------------------------------*/

#if _MSC_VER > 1000
#pragma once
#endif

#include "DBError.h"

#ifndef DEFS_H
#define DEFS_H

#ifndef BOOL
typedef int BOOL;
#endif

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

#ifndef vMAX
#define vMAX(x,y) (((x) > (y)) ? (x) : (y))
#endif

#ifndef vMIN
#define vMIN(x,y) (((x) > (y)) ? (y) : (x))
#endif

#define LOWER_BND	-1.0e30
#define UPPER_BND	1.0e30

#define CONS_SCALE	1.0

///////////////////////////////////////////////////////////////////////////////
// DOT routine definitions
#define DOT_MMFD 0
#define DOT_SLP 2
#define DOT_SQP 3
#define DOT_BFGS 0
#define DOT_FR 2
#define FFD_GRAD 0
#define FCD_GRAD -1
#define USER_GRAD 1
#define DOT_START 0
#define DOT_DONE 0
#define EVAL_RESP 1
#define CALC_GRAD 2

#ifdef __cplusplus
extern "C" {
#endif

///////////////////////////////////////////////////////////////////////////////
// The Design_Step enumeration defines constants used to determine what step 
// the design modules are executing. Normally, design modules return these 
// constants to the calling routine to indicate what it requires the calling 
// routine to provide. The calling routine passes the F_INIT flag at the start, 
// after which, the design module returns different flags depending on the step 
// it is currently executing. The calling routine must provide the requested 
// data to the design module until F_DONE or F_ERROR is returned. The calling 
// routine should simply call the design module routine again (in an iterative 
// process) when the design module returns F_INIT or F_GRAD_INIT.
//
// F_INIT - Initialize a design module run. Required in the first call. When
//			discrete optimization is being performed, the design module will
//			return this flag to indicate that it is starting optimization of
//			a new node in the branch and bound tree. When a design module 
//			returns this flag, the routine is not required to do anything.
// F_DONE - The design module has completed.
// F_RESP - The design module is requesting responses be calculated for the 
//			provided design variable values.
// F_GRAD - The design module is requesting gradients of responses be calculated 
//			at the provided design variable values in support or finite 
//			difference gradient calculations.
// F_GRAD_INIT - The design module is calculting dependent response gradients.
//			The calling routine does not need to do anything.
// F_USER_GRAD - The design module is requesting that gradients be calculated at 
//			the design point defined by the passed design variable values for the 
//			specified responses.
// F_ERROR - The design module detected an error. The log file will contain 
//			details. Depending on the type of error, you may also get information 
//			from the CResult object from the database.
enum Design_Step { F_INIT, F_DONE, F_RESP, F_GRAD, F_GRAD_INIT, F_USER_GRAD, 
					F_ERROR };

///////////////////////////////////////////////////////////////////////////////
// The Grad enumeration is used internally to determine how gradients are 
// calculated.
//
// FFD - internal first forward difference
// CD - internal central difference
// analytic - external (user supplied) gradients
enum Grad { FFD, CD, analytic };

///////////////////////////////////////////////////////////////////////////////
// The Type enumeration is used internally to classify the type of an input or
// response. The meanings should be evident.
enum Type { independent = 0, linked = 1, synthetic = 2, constant = 3, passfail = 3,
			discrete = 4, integer = 5 };

///////////////////////////////////////////////////////////////////////////////
// The Subjects enumeration is used internally to classify the subjects of 
// link, synthetic, objective, and constraint specifications. The meanings
// should be evident.
enum Subjects { IndDVar = 20, LinkDVar = 21, SynDVar = 22, ConstDVar = 23, 
				IndDResp = 24, LinkDResp = 25, SynDResp = 26 };

///////////////////////////////////////////////////////////////////////////////
// The Goal enumeration is used internally to classify the type of objective.
enum Goal { minimize, maximize, target };

///////////////////////////////////////////////////////////////////////////////
// The Method enumeration is used internally to specify the type of 
// optimization algorithm to employ
enum Method { SQP = 0, SLP = 1, MMFD = 2, BFGS = 0, FR = 1 };

///////////////////////////////////////////////////////////////////////////////
// The DOEMethod enumeration is used internally to specify the type of 
// statistical design to used in DOE or as a starting strategy in RSA.
enum DOEMethod { Factorial = 0, Composite = 1, Box = 2, Plackett = 3, Notz = 4, 
				Koshal = 5, Rech = 6, Hybrid = 7, Taguchi = 8, Simplex = 9, 
				Random = 10, UserDOE = 11, Taylor = 99 };

///////////////////////////////////////////////////////////////////////////////
// The DOEModel enumeration is used internally to specify the approximation
// models that DOE and RSA will generate.
enum DOEModel { Linear = 0, LinearInter = 1, QuadNoInter = 2, FullQuad = 3, 
				MixedFwdRegr = 4 };

///////////////////////////////////////////////////////////////////////////////
// The DOETask enumeration is used internally to indicate what DOE must perform
enum DOETask { Points = 0, PointsResps = 1, PointsRespsModels = 2 };

///////////////////////////////////////////////////////////////////////////////
// The DOEStatus enumeration is used by DOE and the GUI for real-time 
// monitoring of a DOE run from the GUI.
enum DOEStatus { DOEStarted = 0, DOECreatingPoints = 1, DOECreatingPointsDone = 2, 
				DOECalcResps = 3, DOECalcRespsDone = 4, DOECreatingModels = 5,
				DOECreatingModelsDone = 6, DOECompleted = 7 };

///////////////////////////////////////////////////////////////////////////////
// The Task enumeration is used to specify the type of design module that a
// design task is associated.
enum Task { DGO, RSA, DOE, GA };

///////////////////////////////////////////////////////////////////////////////
// The RunStatus enumeration is used with the CResult object to classify the
// status of a task. This is used by the reporting module and GUI.
enum RunStatus { NotRun = 0, Running = 1, Done = 2, RunTimeError = 4 };

///////////////////////////////////////////////////////////////////////////////
// The StopCode enumeration defines why a design module finished if a run-time
// error was not detected.
enum StopCode { Normal = 0, AbsHard = 1, RelHard = 2, KTCond = 3, NullSearch = 4, 
				WKStorage = 10, XL_XU = 11, GStorage = 12, GZero = 13, 
				MaxIter = 14, SoftConv = 15, SynthError = 16, MatlabError = 17, 
				NoFeasibleSoln = 18, NothingAddedRemoved = 51, SameTermAddedRemoved = 52, 
				NumTermsEqNumPnts_1 = 53, AllTermsAdded = 54, SameModel = 55, 
				ErrClearingRegrParams = 61, ErrCovMatrix = 62, ErrPValues = 63, 
				ErrAddPoint = 64, ErrRegrCoeffs = 65, SingularMatrix = 66, 
				ErrSumSqDueToErr = 67, ErrSetTolerForTerms = 68, ErrMoveTerm = 69, 
				ApproxHalt = 90 };

#ifdef __cplusplus
}
#endif

#endif		/* DEFS_H */
