// Database Error Codes: Used by the database interface error
//		reporting facility
//////////////////////////////////////////////////////////////////////

#ifndef DBERROR_H
#define DBERROR_H

#define DB_SUCCESS		1	// no error

#define DB_NONE			0	// no error

#define DB_LOCK			-1	// lock error

#define DB_FAIL			-2	// general failure

#define DB_FILENAME			-3	// file name specification error
#define DB_NO_ACCESS		-4	// read/write access violation
#define DB_CREATE_ERROR		-5	// file could not be created
#define DB_OPEN_ERROR		-6	// file could not be opened
#define DB_BAD_TYPE			-7	// not a VBD file
#define DB_NO_DATABASE		-8	// no database attached to the application
#define DB_OBJECT_EXISTS	-9	// specified object already exists
#define DB_BAD_ARGS			-10	// argument list is invalid
#define DB_NOT_FOUND		-11	// object not found
#define DB_METHOD			-12	// bad CTask method
#define DB_BAD_CAT_TYPE		-13	// Type does not match input flag
#define DB_NOT_VAR			-14	// Catalog object expected to be a variable
#define DB_NOT_RESP			-15	// Catalog object expected to be a response
#define DB_BAD_ID			-16	// Invalid database ID
#define DB_BAD_ARRAY		-17	// Array argument is invalid
#define DB_SIZE_ARG			-18 // Array size argument is invalid
#define DB_OUT_OF_MEM		-19 // out of memory
#define DB_NOT_FREED		-20	// buffer could not be freed - not allocated or already freed
#define DB_MEM_LEAK			-21	// memory leak, allocated memory not freed
#define DB_ALLOC_SIZE		-22	// allocation size is <= 0
#define DB_POINT_NUM		-23	// point number is invalid or already exists
#define DB_CT_VALUE			-24 // Constraint tolerance must be negative
#define DB_VCT_VALUE		-25	// Violated constraint tolerance must be positive
#define DB_STEP_SIZE		-26 // Finite difference step size must be positive
#define DB_CONV_TOL			-27	// Convergence tolerance must be positive
#define DB_RESULT_OBJ_EX	-28	// Result object already exists
#define DB_PNT_OBJ_EX		-29	// Point object already exists
#define DB_ITER_OBJ_EX		-30	// Iteration object already exists
#define DB_CHKSUM			-31	// Read checksum error - data is corrupted
#define DB_BAD_CLASSID		-32	// Read bad class ID - data is corrupted
#define DB_WRITE_ERR		-33	// File not writable
#define DB_READ_OBJ			-34	// Read object failure
#define DB_WRITE_OBJ		-35	// Write object failure
#define DB_FIND_OBJ			-36	// Find object failure
#define DB_NO_TASK_OBJ		-37	// Specified task object not found
#define DB_LOG_FILE			-38	// Log file error
#define DB_BAD_TYPE_ENUM	-39	// Type enumeration not valid
#define DB_FILE_NOT_READY	-40	// File not ready (failed or closed file)
#define DB_INVALID_ENUM		-41	// Value of an enumeration is outside of the definition
#define DB_BAD_INDEX_OR_LEN	-42	// Transfer index or length of an object is <= 0
#define DB_NO_OBJECTIVE		-43 // No objective defined for direct or response surface optimization
#define DB_BAD_TASK_TYPE	-44 // Task type on the CDesignControl object is invalid
#define DB_NO_ANAL_EXE		-45	// Analysis program is required but one was not specified
#define DB_NO_GPOINTS		-46	// GUI design points object was not found
#define DB_BAD_DV_MATRIX	-47	// Number of columns in the design variable matrix does not match number of design variables
#define DB_BAD_RESP_MATRIX	-48	// Number of columns in the response matrix does not match number of responses
#define DB_BAD_DOE_DESIGN	-49	// Invalid DOE design type
#define DB_NUM_DOPT_PNTS	-50 // The number of supplied points is less than the number of d-optimal points
#define DB_NUM_DOE_RESP		-51 // No independent responses -- cannot generate approximations
#define DB_BAD_DOE_MODEL	-52	// Invalid approximate model type
#define DB_PNTS_MFREGR		-53	// The number of points for fixed-forward regression must be greater than 1
#define DB_NOT_ENOUGH_PNTS	-54	// There are more terms in the model than points + 1
#define DB_NO_QUAD_APPROX	-55	// The given DOE design type cannot generate quadratic approximation models
#define	DB_ONLY_LIN_APPROX	-56	// Only linear approximation models can be generated
#define DB_ONLY_11_APPROX	-57	// Only linear with interaction approximation models can be generated
#define DB_NO_11_APPROX		-58	// No linear with interaction terms type approximations can be generated
#define DB_NO_22_APPROX		-59	// Pure quadratic design cannot generate full quadratic approximations
#define DB_BOX_1			-60	// Box-Behnken designs for 1 design variable may only have design option 1
#define DB_BOX_12			-61	// Box-Behnken designs for 2 design variables may only have design options 1, 2, or 12
#define DB_HYBRID_3			-62	// Invalid hybrid design option for 3 design variables
#define DB_HYBRID_4			-63	// Invalid hybrid design option for 4 design variables
#define DB_HYBRID_6			-64	// Invalid hybrid design option for 6 design variables
#define DB_HYBRID_DVAR		-65	// Hybrid designs are valid for 3, 4, or 6 design variables
#define DB_TAGUCHI_4		-66	// Taguchi designs with 4 design variables cannot use Latin Square design options
#define DB_TAGUCHI_5		-67	// Taguchi designs with >=5 && <14 design variables cannot use Latin Square or L9 design options
#define DB_TAGUCHI_14		-68	// Taguchi designs with >= 14 && <41 design variables can only use L81 design option
#define DB_TAGUCHI_41		-69	// Taguchi designs are only valid for less than 41 design variables
#define DB_PLACKETT_12		-70	// Plackett-Burman designs for >12 design variables must use a design option with greater than 12 points
#define DB_PLACKETT_20		-71	// Plackett-Burman designs for >20 design variables must use a design option with greater than 20 points
#define DB_PLACKETT_24		-72	// Plackett-Burman designs for >24 design variables must use a design option with greater than 24 points
#define DB_PLACKETT_28		-73	// Plackett-Burman designs for >28 design variables must use a design option with greater than 28 points
#define DB_PLACKETT_36		-74	// Plackett-Burman designs are not valid for more than 35 design variables
#define DB_NO_GRAD_EXE		-75	// Gradient program not found
#define DB_NO_LOG			-76	// Log file not provided
#define DB_NO_USER_PNTS		-77	// User provided design points must be supplied
#define DB_SML_DV			-78	// The number of dvar at a point is less than the number of dvar in the user's design matrix
#define DB_LRG_DV			-79	// The number of dvar at a point is greater than the number of dvar in the user's design matrix
#define DB_SML_RESP			-80	// The number of responses at a point is less than the number of responses in the user's design matrix
#define DB_LRG_RESP			-81	// The number of responses at a point is greater than the number of responses in the user's design matrix
#define DB_NO_FILE			-82	// Specified file does not exist
#define DB_DBFILE_ERROR		-83	// Errors detected in file header or heap
#define DB_NO_TMP_FILE		-84	// Temporary file could not be created
#define DB_REBUILD_DATA		-85	// Rebuild data file failed
#define DB_REBUILD_INDEX	-86	// Rebuild index file failed
#define DB_MIN_DPOINTS		-87	// The minimum number of design points to evaluate is less than or equal to zero
#define DB_MINMAX_DPOINTS	-88	// The minimum number of design points to evaluate is greater than the maximum 
#define DB_MAX_DPOINTS		-89	// The maximum number of design points to evaluate is less than or equal to zero
#define DB_ENGINE_EXCEPTION -90	// Database engine exception was caught
#define DB_EXCEPTION		-91	// Database exception was caught
#define DB_RM_OBJ			-92	// Remove object failed
#define DB_EXPIRED			-93 // License expired
#define DB_NO_VX_FILE		-94	// No vx file find for the specified database
#define DB_NO_VDB_FILE		-95	// No vdb file find for the specified database

#endif
