% ADVISOR Data file:  FC_CI205cat3126_emis.m
%
% Data source: Engine Specification Sheet from Caterpillar for 3126E engine (275 hp/205 kW) (gives 
%              fuel consumptionpoints at brake torque) and 13 mode test data from Battelle over
%              European Stationary Cycle (ESC, also known as OICA/ACEA--fuel economy, NOx, CO, HC at 
%					13 points).
%
% Data confidence level: No evaluations/comparisons performed 
%
% Notes: 
% File created by engmodel using mat file: cat3126.mat
% Points outside of data points extrapolated based on the following algorithm: polynomial;
% Map: fc_fuel_map;
%  Average error (%): 0.24818;
%  Maximum error (g/s): 0.082495; (0.67731%)
%  max error at speed (rpm): 2200;
%  max error at torque (Nm): 890;
% Map: fc_hc_map;
%  Average error (%): 0.6856;
%  Maximum error (g/s): -0.00022388; (-2.7346%)
%  max error at speed (rpm): 2200;
%  max error at torque (Nm): 890;
% Map: fc_co_map;
%  Average error (%): 2.5402;
%  Maximum error (g/s): 0.0032304; (19.1852%)
%  max error at speed (rpm): 1440.2;
%  max error at torque (Nm): 263.8042;
% Map: fc_nox_map;
%  Average error (%): 0.76643;
%  Maximum error (g/s): 0.021806; (3.9308%)
%  max error at speed (rpm): 1440.2;
%  max error at torque (Nm): 263.8042
%
% Created on:  03-Jan-2002 14:28:18
% By: Michael O'Keefe, NREL, Michael_O'Keefe@nrel.gov
%
% Revision history at end of file.
%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% FILE ID INFO
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
fc_description='Caterpillar 3126E (7.2L) Diesel Engine (350 ppm S diesel fuel)';  
fc_version=2003;  				% version of ADVISOR for which the file was generated
fc_proprietary=0;  	% 0=> non-proprietary, 1=> proprietary, do not distribute
fc_validation=0;  		% 1=> no validation, 1=> data agrees with source data, 
							% 2=> data matches source data and data collection methods have been verified
fc_fuel_type='Diesel 350 ppm S'; 
fc_disp=7.2;  			% (L), engine displacement
fc_emis=1;			% boolean 0=no emis data; 1=emis data; note: no PM data
fc_cold=0;      % boolean 0=no cold data; 1=cold data exists
disp(['Data loaded: FC_CI205cat3126_emis.m - ',fc_description]); 


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SPEED & TORQUE RANGES over which data is defined
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% (rad/s), speed range of the engine
fc_map_spd=[73.3 75.4 77.49 79.59 81.68 83.78 85.87 87.96 90.06 92.15 94.25 96.34 98.44 100.5 102.6 104.7 106.8 108.9 111 113.1 115.2 117.3 119.4 121.5 123.6 125.7 127.8 129.9 131.9 134 136.1 138.2 140.3 142.4 144.5 146.6 148.7 150.8 152.9 155 157.1 159.2 161.3 163.4 165.5 167.6 169.6 171.7 173.8 175.9 178 180.1 182.2 184.3 186.4 188.5 190.6 192.7 194.8 196.9 199 201.1 203.2 205.3 207.3 209.4 211.5 213.6 215.7 217.8 219.9 222 224.1 226.2 228.3 230.4 232.5 234.6 236.7 238.8 240.9 242.9 245 247.1 249.2 251.3]; 

% (N*m), torque range of the engine
fc_map_trq=[1 21 41 61 81 101 121 141 161 181 201 221 241 261 281 301 321 341 361 381 401 421 441 461 481 501 521 541 561 581 601 621 641 661 681 701 721 741 761 781 801 821 841 861 881 901 921 941 961 981 1001 1021 1041 1061 1081]; 


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% FUEL USE AND EMISSIONS MAPS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% (g/s), fuel use map indexed vertically by fc_map_spd and 
% horizontally by fc_map_trq
%fc_fuel_map=[0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149;
%0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149;
%0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149;
%0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.149 0.01528 0.03959 0.06476 0.09076 0.1175 0.145 0.1731 0.2018 0.2311 0.2609 0.2911 0.3217 0.3526 0.3837 0.4151 0.4466 0.4782 0.5098 0.5414 0.5728 0.6042 0.6353 0.6661 0.6966 0.7267 0.7564 0.7856 0.8142 0.8421 0.8694 0.8959 0.9217 0.9466 0.9705 0.9935 1.015 1.036 1.056 1.075 1.092 1.108;
%0.3271 0.3629 0.391 0.4126 0.4286 0.4398 0.4469 0.4507 0.4516 0.4502 0.447 0.4423 0.4366 0.4302 0.4234 0.4164 0.4095 0.4029 0.3967 0.3911 0.3863 0.3823 0.3794 0.3774 0.3766 0.377 0.3787 0.3816 0.3859 0.3914 0.3984 0.4067 0.4164 0.4274 0.4397 0.4535 0.4685 0.4848 0.5023 0.5211 0.5411 0.5623 0.5845 0.6079 0.6323 0.6576 0.6839 0.7111 0.7392 0.768 0.7976 0.8278 0.8587 0.8901 0.9221 0.9545 0.9873 1.02 1.054 1.088 1.121 1.155 1.189 1.223 1.257 1.291 1.324 1.358 1.391 1.423 1.456 1.487 1.519 1.549 1.579 1.608 1.637 1.664 1.691 1.717 1.742 1.765 1.788 1.809 1.829 1.848;
%0.7156 0.7523 0.7814 0.804 0.821 0.8333 0.8415 0.8463 0.8483 0.8481 0.846 0.8426 0.8381 0.8329 0.8274 0.8217 0.8161 0.8107 0.8059 0.8017 0.7983 0.7957 0.7942 0.7937 0.7944 0.7963 0.7995 0.804 0.8098 0.817 0.8256 0.8356 0.8469 0.8596 0.8737 0.8892 0.906 0.9241 0.9434 0.9641 0.9859 1.009 1.033 1.058 1.085 1.112 1.14 1.17 1.2 1.231 1.262 1.295 1.328 1.361 1.395 1.43 1.465 1.5 1.536 1.572 1.608 1.645 1.681 1.717 1.754 1.79 1.826 1.862 1.897 1.932 1.967 2.001 2.035 2.068 2.101 2.133 2.164 2.194 2.224 2.252 2.28 2.306 2.332 2.356 2.379 2.401;
%0.9979 1.036 1.066 1.089 1.107 1.121 1.13 1.136 1.139 1.14 1.139 1.137 1.133 1.129 1.125 1.121 1.116 1.112 1.109 1.106 1.104 1.103 1.103 1.104 1.106 1.109 1.114 1.12 1.128 1.136 1.147 1.158 1.171 1.186 1.202 1.219 1.237 1.257 1.278 1.301 1.325 1.349 1.376 1.403 1.431 1.46 1.491 1.522 1.554 1.587 1.621 1.655 1.69 1.726 1.762 1.799 1.837 1.874 1.912 1.95 1.989 2.028 2.066 2.105 2.144 2.182 2.221 2.259 2.297 2.335 2.372 2.409 2.446 2.481 2.517 2.551 2.585 2.618 2.65 2.682 2.712 2.741 2.769 2.797 2.822 2.847;
%1.215 1.254 1.285 1.31 1.329 1.343 1.353 1.36 1.365 1.367 1.367 1.366 1.364 1.361 1.358 1.355 1.352 1.349 1.347 1.346 1.345 1.345 1.347 1.349 1.353 1.358 1.364 1.372 1.381 1.391 1.403 1.416 1.431 1.447 1.465 1.483 1.504 1.525 1.548 1.573 1.598 1.625 1.653 1.682 1.713 1.744 1.776 1.809 1.844 1.879 1.914 1.951 1.988 2.026 2.065 2.104 2.143 2.183 2.223 2.264 2.305 2.346 2.387 2.428 2.469 2.51 2.551 2.592 2.633 2.673 2.713 2.752 2.791 2.83 2.868 2.905 2.941 2.977 3.012 3.046 3.079 3.111 3.142 3.172 3.201 3.229;
%1.391 1.431 1.463 1.489 1.509 1.524 1.536 1.544 1.549 1.552 1.554 1.554 1.553 1.552 1.55 1.548 1.546 1.545 1.544 1.544 1.545 1.546 1.549 1.553 1.558 1.565 1.573 1.582 1.592 1.604 1.618 1.633 1.649 1.667 1.686 1.707 1.729 1.752 1.777 1.803 1.831 1.859 1.889 1.92 1.953 1.986 2.02 2.055 2.092 2.129 2.167 2.205 2.245 2.285 2.326 2.367 2.409 2.451 2.493 2.536 2.579 2.623 2.666 2.71 2.753 2.797 2.84 2.883 2.927 2.969 3.012 3.054 3.095 3.137 3.177 3.217 3.256 3.295 3.332 3.369 3.405 3.44 3.474 3.507 3.538 3.569;
%1.54 1.581 1.614 1.64 1.662 1.678 1.691 1.7 1.706 1.711 1.713 1.714 1.715 1.715 1.714 1.713 1.713 1.713 1.714 1.715 1.717 1.72 1.724 1.73 1.737 1.744 1.754 1.765 1.777 1.79 1.805 1.822 1.84 1.86 1.881 1.903 1.927 1.952 1.979 2.007 2.036 2.067 2.098 2.131 2.165 2.201 2.237 2.274 2.313 2.352 2.392 2.433 2.474 2.516 2.559 2.603 2.647 2.691 2.736 2.781 2.827 2.872 2.918 2.964 3.01 3.056 3.102 3.148 3.193 3.239 3.284 3.328 3.372 3.416 3.459 3.502 3.544 3.585 3.625 3.665 3.704 3.741 3.778 3.814 3.848 3.882;
%1.671 1.712 1.746 1.774 1.796 1.814 1.827 1.838 1.845 1.851 1.854 1.857 1.858 1.859 1.86 1.861 1.862 1.863 1.865 1.868 1.871 1.876 1.882 1.888 1.897 1.906 1.917 1.929 1.943 1.958 1.975 1.993 2.013 2.034 2.057 2.081 2.106 2.133 2.162 2.192 2.223 2.255 2.289 2.324 2.36 2.397 2.436 2.475 2.515 2.557 2.599 2.642 2.685 2.73 2.775 2.82 2.867 2.913 2.96 3.008 3.056 3.104 3.152 3.2 3.249 3.297 3.345 3.394 3.442 3.49 3.537 3.584 3.631 3.677 3.723 3.769 3.813 3.857 3.9 3.943 3.984 4.025 4.064 4.103 4.14 4.176;
%1.789 1.832 1.867 1.895 1.919 1.937 1.952 1.963 1.972 1.978 1.983 1.987 1.99 1.992 1.994 1.996 1.998 2.001 2.004 2.008 2.013 2.019 2.026 2.035 2.044 2.055 2.068 2.082 2.097 2.114 2.132 2.152 2.173 2.196 2.221 2.247 2.274 2.303 2.333 2.365 2.398 2.432 2.468 2.504 2.543 2.582 2.622 2.663 2.706 2.749 2.793 2.838 2.884 2.931 2.978 3.026 3.074 3.123 3.173 3.222 3.272 3.323 3.373 3.424 3.475 3.526 3.577 3.627 3.678 3.728 3.778 3.828 3.878 3.927 3.975 4.023 4.07 4.117 4.163 4.208 4.252 4.296 4.338 4.379 4.42 4.459;
%1.9 1.943 1.979 2.009 2.033 2.052 2.068 2.081 2.09 2.098 2.104 2.109 2.113 2.117 2.12 2.123 2.127 2.131 2.135 2.141 2.147 2.154 2.163 2.173 2.184 2.196 2.21 2.226 2.243 2.261 2.281 2.303 2.326 2.35 2.376 2.404 2.433 2.464 2.496 2.529 2.564 2.601 2.638 2.677 2.717 2.758 2.8 2.844 2.888 2.933 2.98 3.027 3.075 3.124 3.173 3.223 3.274 3.326 3.378 3.431 3.483 3.535 3.587 3.64 3.692 3.744 3.796 3.849 3.901 3.953 4.005 4.057 4.116 4.168 4.219 4.269 4.319 4.369 4.417 4.465 4.512 4.558 4.604 4.648 4.691 4.733;
%2.005 2.049 2.086 2.117 2.142 2.163 2.179 2.193 2.204 2.213 2.22 2.226 2.231 2.236 2.24 2.245 2.25 2.255 2.261 2.268 2.276 2.284 2.294 2.306 2.318 2.332 2.348 2.365 2.383 2.403 2.425 2.448 2.473 2.499 2.527 2.556 2.587 2.62 2.654 2.689 2.748 2.796 2.843 2.89 2.937 2.984 3.031 3.078 3.125 3.172 3.219 3.266 3.313 3.36 3.407 3.454 3.503 3.555 3.608 3.66 3.712 3.764 3.817 3.869 3.921 3.973 4.026 4.078 4.13 4.182 4.235 4.287 4.398 4.403 4.457 4.51 4.563 4.615 4.667 4.717 4.767 4.816 4.864 4.911 4.957 5.002;
%2.107 2.152 2.19 2.221 2.248 2.269 2.287 2.302 2.314 2.324 2.332 2.34 2.346 2.352 2.358 2.364 2.37 2.376 2.384 2.392 2.401 2.411 2.423 2.435 2.45 2.465 2.482 2.501 2.521 2.542 2.566 2.59 2.617 2.645 2.674 2.705 2.738 2.775 2.838 2.908 2.982 3.034 3.081 3.128 3.175 3.222 3.269 3.316 3.363 3.41 3.457 3.504 3.551 3.598 3.645 3.692 3.739 3.786 3.837 3.889 3.941 3.994 4.046 4.098 4.15 4.203 4.255 4.307 4.359 4.412 4.464 4.516 4.628 4.636 4.692 4.748 4.804 4.859 4.913 4.966 5.019 5.07 5.121 5.171 5.22 5.268;
%2.207 2.253 2.292 2.324 2.352 2.374 2.393 2.409 2.422 2.433 2.443 2.451 2.459 2.466 2.473 2.48 2.488 2.496 2.504 2.514 2.525 2.536 2.549 2.563 2.579 2.596 2.614 2.635 2.656 2.679 2.704 2.731 2.759 2.789 2.82 2.853 2.868 2.931 2.994 3.057 3.122 3.195 3.269 3.343 3.413 3.46 3.507 3.554 3.601 3.648 3.695 3.742 3.789 3.836 3.883 3.93 3.977 4.024 4.071 4.119 4.171 4.223 4.275 4.327 4.38 4.432 4.484 4.536 4.589 4.641 4.693 4.745 4.857 4.999 4.926 4.984 5.043 5.1 5.157 5.213 5.268 5.323 5.377 5.43 5.482 5.532;
%2.306 2.353 2.393 2.427 2.455 2.479 2.499 2.516 2.53 2.542 2.553 2.563 2.571 2.58 2.588 2.596 2.605 2.615 2.625 2.635 2.647 2.66 2.675 2.69 2.708 2.726 2.746 2.768 2.791 2.816 2.842 2.87 2.9 2.932 2.965 2.962 3.025 3.088 3.151 3.214 3.276 3.339 3.409 3.483 3.557 3.63 3.704 3.778 3.839 3.886 3.933 3.98 4.027 4.074 4.121 4.168 4.215 4.262 4.309 4.356 4.403 4.452 4.505 4.557 4.609 4.661 4.714 4.766 4.818 4.87 4.923 4.975 5.086 5.228 5.158 5.22 5.281 5.341 5.4 5.459 5.517 5.575 5.632 5.687 5.742 5.796;
%2.405 2.453 2.494 2.529 2.558 2.583 2.604 2.622 2.637 2.651 2.663 2.674 2.684 2.693 2.703 2.713 2.723 2.733 2.745 2.757 2.77 2.785 2.8 2.818 2.836 2.856 2.878 2.901 2.926 2.952 2.98 3.01 3.042 3.075 3.055 3.118 3.181 3.244 3.307 3.37 3.433 3.496 3.558 3.622 3.696 3.77 3.844 3.918 3.991 4.065 4.139 4.213 4.265 4.312 4.359 4.406 4.453 4.5 4.547 4.594 4.641 4.688 4.735 4.786 4.838 4.891 4.943 4.995 5.047 5.1 5.152 5.204 5.316 5.457 5.599 5.455 5.519 5.581 5.644 5.706 5.767 5.827 5.886 5.945 6.002 6.059;
%2.505 2.554 2.596 2.632 2.662 2.688 2.71 2.729 2.746 2.76 2.773 2.785 2.796 2.807 2.818 2.829 2.84 2.852 2.865 2.879 2.893 2.909 2.927 2.945 2.965 2.987 3.01 3.035 3.061 3.089 3.119 3.15 3.184 3.149 3.212 3.275 3.338 3.401 3.463 3.526 3.589 3.652 3.715 3.778 3.84 3.91 3.983 4.057 4.131 4.205 4.279 4.353 4.426 4.5 4.574 4.644 4.691 4.738 4.785 4.832 4.879 4.926 4.973 5.02 5.068 5.12 5.172 5.224 5.277 5.329 5.381 5.433 5.545 5.686 5.828 5.691 5.757 5.823 5.888 5.952 6.016 6.079 6.141 6.203 6.263 6.323;
%2.606 2.656 2.699 2.735 2.767 2.793 2.817 2.837 2.855 2.87 2.884 2.898 2.91 2.922 2.934 2.947 2.959 2.972 2.987 3.002 3.018 3.035 3.054 3.074 3.095 3.118 3.143 3.169 3.197 3.227 3.258 3.292 3.242 3.305 3.368 3.431 3.494 3.557 3.62 3.683 3.746 3.808 3.871 3.934 3.997 4.06 4.123 4.197 4.271 4.345 4.418 4.492 4.566 4.64 4.714 4.787 4.861 4.935 5.009 5.07 5.117 5.164 5.211 5.258 5.305 5.352 5.402 5.454 5.506 5.558 5.611 5.663 5.774 5.916 6.057 6.199 5.997 6.065 6.133 6.2 6.267 6.332 6.397 6.462 6.525 6.588;
%2.707 2.758 2.802 2.84 2.872 2.9 2.925 2.946 2.965 2.982 2.997 3.011 3.025 3.038 3.052 3.065 3.079 3.094 3.109 3.126 3.143 3.162 3.182 3.203 3.226 3.251 3.277 3.305 3.335 3.366 3.399 3.335 3.398 3.461 3.524 3.587 3.65 3.713 3.776 3.839 3.902 3.965 4.028 4.09 4.153 4.216 4.279 4.342 4.41 4.484 4.558 4.632 4.706 4.779 4.853 4.927 5.001 5.075 5.149 5.222 5.296 5.37 5.444 5.496 5.543 5.59 5.637 5.684 5.735 5.788 5.84 5.892 6.004 6.145 6.287 6.428 6.237 6.308 6.379 6.449 6.518 6.587 6.655 6.722 6.788 6.853;
%2.811 2.863 2.907 2.946 2.979 3.008 3.034 3.056 3.076 3.094 3.111 3.126 3.141 3.156 3.17 3.185 3.2 3.216 3.233 3.251 3.27 3.29 3.311 3.334 3.359 3.385 3.413 3.442 3.473 3.506 3.429 3.492 3.555 3.618 3.681 3.744 3.807 3.87 3.933 3.996 4.058 4.121 4.184 4.247 4.31 4.372 4.435 4.498 4.561 4.624 4.698 4.771 4.845 4.919 4.993 5.067 5.141 5.214 5.288 5.362 5.436 5.51 5.583 5.657 5.731 5.805 5.875 5.922 5.969 6.017 6.069 6.121 6.233 6.374 6.516 6.657 6.799 6.553 6.626 6.699 6.771 6.842 6.913 6.983 7.052 7.121;
%2.915 2.968 3.014 3.053 3.088 3.118 3.144 3.168 3.189 3.208 3.226 3.243 3.259 3.274 3.29 3.306 3.323 3.34 3.358 3.377 3.398 3.419 3.442 3.467 3.493 3.52 3.55 3.581 3.613 3.522 3.585 3.648 3.711 3.774 3.837 3.9 3.963 4.026 4.089 4.152 4.215 4.278 4.34 4.403 4.466 4.529 4.592 4.654 4.717 4.78 4.843 4.911 4.985 5.059 5.132 5.206 5.28 5.354 5.428 5.502 5.575 5.649 5.723 5.797 5.871 5.945 6.018 6.092 6.166 6.24 6.301 6.351 6.462 6.604 6.745 6.887 7.028 6.799 6.875 6.95 7.025 7.1 7.173 7.246 7.318 7.389;
%3.021 3.075 3.122 3.162 3.198 3.229 3.256 3.281 3.303 3.323 3.342 3.36 3.378 3.395 3.412 3.429 3.447 3.466 3.485 3.506 3.527 3.55 3.575 3.601 3.628 3.657 3.688 3.721 3.615 3.678 3.741 3.804 3.868 3.931 3.994 4.057 4.12 4.183 4.245 4.308 4.371 4.434 4.497 4.56 4.622 4.685 4.748 4.811 4.874 4.936 4.999 5.062 5.125 5.198 5.272 5.346 5.42 5.494 5.567 5.641 5.715 5.789 5.863 5.937 6.01 6.084 6.158 6.235 6.319 6.404 6.488 6.572 6.692 6.833 6.975 7.116 7.257 7.399 7.125 7.203 7.281 7.358 7.435 7.51 7.585 7.659;
%3.128 3.183 3.231 3.273 3.309 3.341 3.37 3.396 3.419 3.44 3.46 3.479 3.498 3.516 3.535 3.553 3.572 3.592 3.613 3.635 3.658 3.683 3.708 3.736 3.765 3.796 3.828 3.709 3.772 3.835 3.898 3.961 4.024 4.087 4.15 4.213 4.276 4.339 4.402 4.465 4.528 4.59 4.653 4.716 4.779 4.842 4.904 4.967 5.03 5.093 5.156 5.218 5.281 5.344 5.412 5.486 5.559 5.633 5.71 5.794 5.879 5.963 6.048 6.132 6.217 6.301 6.386 6.47 6.555 6.639 6.724 6.808 6.925 7.062 7.204 7.345 7.487 7.628 7.377 7.458 7.538 7.618 7.697 7.776 7.854 7.931;
%3.237 3.293 3.342 3.384 3.422 3.455 3.485 3.512 3.536 3.559 3.58 3.6 3.62 3.639 3.659 3.679 3.699 3.721 3.743 3.766 3.79 3.816 3.844 3.873 3.903 3.935 3.802 3.865 3.928 3.991 4.054 4.117 4.18 4.243 4.306 4.369 4.432 4.495 4.558 4.621 4.684 4.747 4.81 4.872 4.935 4.998 5.061 5.124 5.186 5.251 5.325 5.399 5.473 5.547 5.621 5.695 5.776 5.861 5.945 6.03 6.114 6.199 6.283 6.368 6.452 6.537 6.621 6.706 6.79 6.875 6.959 7.044 7.161 7.295 7.433 7.575 7.716 7.858 7.999 7.713 7.797 7.879 7.962 8.043 8.124 8.203;
%3.347 3.404 3.454 3.498 3.536 3.57 3.601 3.629 3.654 3.678 3.701 3.722 3.743 3.764 3.785 3.806 3.828 3.85 3.874 3.898 3.924 3.951 3.98 4.011 4.043 3.895 3.959 4.022 4.085 4.148 4.211 4.274 4.337 4.4 4.463 4.526 4.589 4.652 4.715 4.777 4.841 4.915 4.989 5.063 5.137 5.211 5.285 5.359 5.433 5.507 5.58 5.654 5.728 5.802 5.876 5.95 6.024 6.098 6.181 6.266 6.35 6.435 6.519 6.604 6.688 6.773 6.857 6.942 7.026 7.111 7.195 7.28 7.397 7.531 7.664 7.804 7.945 8.087 8.228 7.971 8.057 8.142 8.227 8.311 8.395 8.478;
%3.459 3.517 3.567 3.612 3.652 3.687 3.719 3.748 3.774 3.799 3.823 3.845 3.867 3.889 3.912 3.934 3.957 3.981 4.006 4.032 4.059 4.088 4.118 4.15 3.989 4.052 4.115 4.178 4.241 4.304 4.367 4.43 4.493 4.556 4.619 4.682 4.745 4.811 4.908 5.001 5.094 5.17 5.244 5.318 5.392 5.466 5.54 5.614 5.688 5.762 5.836 5.91 5.983 6.057 6.131 6.205 6.279 6.353 6.427 6.501 6.586 6.67 6.755 6.839 6.924 7.008 7.093 7.177 7.262 7.346 7.431 7.515 7.633 7.766 7.9 8.034 8.175 8.316 8.458 8.599 8.318 8.406 8.494 8.581 8.668 8.753;
%3.572 3.63 3.682 3.728 3.768 3.804 3.837 3.867 3.895 3.921 3.946 3.97 3.993 4.016 4.04 4.063 4.088 4.113 4.139 4.167 4.195 4.225 4.257 4.082 4.145 4.208 4.271 4.334 4.397 4.46 4.523 4.586 4.649 4.713 4.776 4.84 4.906 4.971 5.068 5.166 5.262 5.355 5.448 5.54 5.633 5.721 5.795 5.869 5.943 6.017 6.091 6.165 6.239 6.313 6.386 6.46 6.534 6.608 6.682 6.756 6.83 6.906 6.991 7.075 7.16 7.244 7.329 7.413 7.498 7.582 7.667 7.751 7.868 8.002 8.136 8.269 8.404 8.546 8.687 8.829 8.58 8.671 8.762 8.852 8.941 9.03;
%3.685 3.745 3.798 3.844 3.886 3.923 3.957 3.988 4.017 4.044 4.07 4.095 4.12 4.144 4.169 4.194 4.22 4.246 4.274 4.303 4.333 4.364 4.176 4.239 4.302 4.365 4.428 4.491 4.554 4.617 4.68 4.743 4.806 4.869 4.935 5 5.066 5.132 5.229 5.326 5.424 5.521 5.616 5.709 5.801 5.894 5.987 6.079 6.172 6.265 6.346 6.42 6.494 6.568 6.642 6.716 6.789 6.863 6.937 7.011 7.085 7.159 7.233 7.311 7.395 7.48 7.564 7.649 7.733 7.818 7.902 7.987 8.104 8.238 8.371 8.505 8.639 8.775 8.916 9.058 9.199 8.938 9.031 9.124 9.216 9.308;
%3.8 3.861 3.914 3.962 4.005 4.043 4.078 4.11 4.14 4.169 4.196 4.222 4.248 4.273 4.299 4.326 4.353 4.38 4.409 4.44 4.471 4.269 4.332 4.395 4.458 4.521 4.584 4.647 4.71 4.773 4.836 4.899 4.963 5.029 5.095 5.161 5.227 5.292 5.389 5.487 5.584 5.681 5.779 5.876 5.969 6.062 6.155 6.248 6.34 6.433 6.526 6.618 6.711 6.804 6.896 6.971 7.045 7.119 7.192 7.266 7.34 7.414 7.488 7.562 7.636 7.716 7.8 7.885 7.969 8.054 8.138 8.223 8.34 8.473 8.607 8.741 8.875 9.008 9.146 9.287 9.429 9.205 9.301 9.397 9.492 9.587;
%3.916 3.977 4.032 4.081 4.124 4.164 4.2 4.233 4.264 4.294 4.322 4.349 4.376 4.403 4.43 4.458 4.486 4.516 4.546 4.577 4.362 4.425 4.488 4.551 4.614 4.677 4.74 4.804 4.867 4.93 4.993 5.058 5.124 5.19 5.256 5.321 5.387 5.453 5.55 5.647 5.745 5.842 5.939 6.037 6.134 6.23 6.323 6.416 6.508 6.601 6.694 6.787 6.879 6.972 7.065 7.157 7.25 7.343 7.435 7.522 7.595 7.669 7.743 7.817 7.891 7.965 8.039 8.12 8.205 8.289 8.374 8.458 8.576 8.709 8.843 8.977 9.11 9.244 9.378 9.516 9.658 9.799 9.573 9.671 9.769 9.866;
%4.032 4.095 4.15 4.2 4.245 4.285 4.322 4.357 4.389 4.42 4.449 4.478 4.506 4.534 4.562 4.591 4.621 4.651 4.683 4.456 4.519 4.582 4.645 4.708 4.771 4.834 4.897 4.96 5.023 5.087 5.153 5.219 5.284 5.35 5.416 5.482 5.548 5.613 5.71 5.808 5.905 6.002 6.1 6.197 6.294 6.392 6.489 6.584 6.677 6.769 6.862 6.955 7.047 7.14 7.233 7.326 7.418 7.511 7.604 7.696 7.789 7.882 7.975 8.067 8.146 8.22 8.294 8.368 8.442 8.525 8.61 8.694 8.811 8.945 9.079 9.212 9.346 9.48 9.613 9.747 9.887 10.03 9.844 9.946 10.05 10.15;
%4.149 4.213 4.27 4.32 4.366 4.408 4.446 4.481 4.515 4.546 4.577 4.607 4.636 4.666 4.695 4.725 4.756 4.788 4.549 4.612 4.675 4.738 4.801 4.864 4.927 4.99 5.053 5.116 5.182 5.247 5.313 5.379 5.445 5.511 5.576 5.642 5.708 5.774 5.871 5.968 6.066 6.163 6.26 6.358 6.455 6.552 6.65 6.747 6.844 6.937 7.03 7.123 7.216 7.308 7.401 7.494 7.586 7.679 7.772 7.865 7.957 8.05 8.143 8.235 8.328 8.421 8.514 8.606 8.697 8.771 8.845 8.93 9.047 9.181 9.314 9.448 9.582 9.715 9.849 9.983 10.12 10.26 10.4 10.22 10.33 10.43;
%4.267 4.332 4.389 4.441 4.488 4.53 4.57 4.606 4.641 4.674 4.705 4.736 4.767 4.798 4.828 4.86 4.892 4.642 4.705 4.768 4.832 4.895 4.958 5.021 5.084 5.147 5.211 5.276 5.342 5.408 5.474 5.54 5.605 5.671 5.737 5.803 5.869 5.934 6.031 6.129 6.226 6.323 6.421 6.518 6.615 6.713 6.81 6.907 7.005 7.102 7.198 7.291 7.384 7.477 7.569 7.662 7.755 7.847 7.94 8.033 8.125 8.218 8.311 8.404 8.496 8.589 8.682 8.774 8.867 8.96 9.057 9.17 9.283 9.416 9.55 9.684 9.817 9.951 10.08 10.22 10.35 10.49 10.63 10.5 10.6 10.71;
%4.385 4.451 4.509 4.562 4.61 4.654 4.694 4.732 4.767 4.801 4.834 4.866 4.898 4.93 4.962 4.995 4.736 4.799 4.862 4.925 4.988 5.051 5.114 5.177 5.24 5.305 5.371 5.437 5.503 5.568 5.634 5.7 5.766 5.832 5.897 5.963 6.029 6.095 6.192 6.289 6.387 6.484 6.581 6.679 6.776 6.873 6.971 7.068 7.165 7.263 7.36 7.457 7.552 7.645 7.737 7.83 7.923 8.016 8.108 8.201 8.294 8.386 8.479 8.572 8.667 8.78 8.893 9.006 9.119 9.232 9.345 9.458 9.571 9.684 9.797 9.919 10.05 10.19 10.32 10.45 10.59 10.72 10.86 10.77 10.88 10.99;
%4.504 4.57 4.63 4.684 4.732 4.777 4.819 4.857 4.894 4.929 4.963 4.997 5.03 5.063 5.096 4.829 4.892 4.955 5.018 5.081 5.144 5.207 5.27 5.334 5.4 5.466 5.531 5.597 5.663 5.729 5.795 5.861 5.926 5.992 6.058 6.124 6.19 6.255 6.352 6.45 6.547 6.644 6.742 6.839 6.936 7.034 7.131 7.228 7.326 7.423 7.52 7.618 7.715 7.812 7.906 7.998 8.091 8.184 8.278 8.391 8.504 8.617 8.73 8.843 8.956 9.069 9.182 9.295 9.408 9.521 9.634 9.747 9.86 9.973 10.09 10.2 10.31 10.42 10.56 10.69 10.82 10.96 11.09 11.23 11.16 11.27;
%4.623 4.69 4.751 4.805 4.855 4.901 4.943 4.983 5.021 5.057 5.093 5.127 5.162 5.196 4.923 4.986 5.049 5.112 5.175 5.238 5.301 5.364 5.429 5.495 5.56 5.626 5.692 5.758 5.824 5.889 5.955 6.021 6.087 6.153 6.218 6.284 6.35 6.416 6.513 6.61 6.708 6.805 6.902 7 7.097 7.194 7.292 7.389 7.486 7.583 7.681 7.778 7.876 7.991 8.105 8.22 8.335 8.45 8.565 8.68 8.793 8.906 9.019 9.132 9.245 9.357 9.47 9.583 9.696 9.809 9.922 10.04 10.15 10.26 10.37 10.49 10.6 10.71 10.83 10.94 11.06 11.19 11.33 11.46 11.44 11.56;
%4.742 4.81 4.871 4.927 4.978 5.025 5.068 5.109 5.148 5.186 5.222 5.258 5.293 5.016 5.079 5.142 5.205 5.268 5.331 5.394 5.458 5.523 5.589 5.655 5.721 5.787 5.852 5.918 5.984 6.05 6.116 6.181 6.247 6.313 6.379 6.445 6.511 6.576 6.673 6.771 6.868 6.965 7.063 7.16 7.257 7.355 7.452 7.565 7.68 7.795 7.91 8.025 8.14 8.255 8.37 8.485 8.599 8.714 8.829 8.944 9.059 9.174 9.289 9.404 9.519 9.634 9.749 9.864 9.979 10.09 10.21 10.32 10.44 10.55 10.66 10.78 10.89 11 11.11 11.23 11.34 11.45 11.57 11.7 11.83 11.84;
%4.861 4.93 4.992 5.049 5.101 5.149 5.194 5.236 5.276 5.314 5.352 5.389 5.425 5.172 5.235 5.298 5.361 5.424 5.487 5.552 5.618 5.684 5.75 5.816 5.881 5.947 6.013 6.079 6.145 6.21 6.276 6.342 6.408 6.474 6.539 6.605 6.671 6.737 6.834 6.931 7.028 7.14 7.255 7.37 7.485 7.599 7.714 7.829 7.944 8.059 8.174 8.289 8.404 8.519 8.634 8.749 8.864 8.979 9.093 9.208 9.323 9.438 9.553 9.668 9.783 9.898 10.01 10.13 10.24 10.36 10.47 10.59 10.7 10.82 10.93 11.05 11.16 11.28 11.39 11.51 11.62 11.74 11.85 11.97 12.08 12.12;
%4.98 5.05 5.113 5.171 5.224 5.273 5.318 5.362 5.403 5.442 5.481 5.519 5.266 5.329 5.392 5.455 5.518 5.581 5.647 5.713 5.779 5.844 5.91 5.976 6.042 6.108 6.173 6.239 6.305 6.371 6.437 6.502 6.568 6.634 6.7 6.766 6.841 6.929 7.022 7.145 7.268 7.382 7.494 7.606 7.717 7.829 7.942 8.056 8.17 8.284 8.399 8.513 8.627 8.742 8.856 8.97 9.084 9.199 9.313 9.427 9.542 9.656 9.77 9.885 9.999 10.11 10.23 10.34 10.46 10.57 10.68 10.8 10.91 11.03 11.14 11.26 11.37 11.48 11.6 11.71 11.83 11.94 12.06 12.17 12.28 12.41;
%5.098 5.169 5.234 5.292 5.346 5.396 5.443 5.487 5.53 5.571 5.61 5.359 5.422 5.485 5.548 5.611 5.676 5.742 5.807 5.873 5.939 6.005 6.071 6.136 6.202 6.268 6.334 6.4 6.466 6.531 6.597 6.663 6.729 6.806 6.894 6.982 7.07 7.158 7.246 7.334 7.432 7.555 7.679 7.802 7.925 8.048 8.171 8.294 8.408 8.52 8.632 8.743 8.855 8.967 9.079 9.191 9.302 9.414 9.526 9.638 9.749 9.861 9.973 10.08 10.2 10.31 10.42 10.54 10.65 10.77 10.88 10.99 11.11 11.22 11.34 11.45 11.57 11.68 11.79 11.91 12.02 12.14 12.31 12.44 12.56 12.69;
%5.217 5.289 5.354 5.414 5.469 5.52 5.568 5.613 5.656 5.698 5.452 5.515 5.578 5.641 5.705 5.771 5.836 5.902 5.968 6.034 6.1 6.165 6.231 6.297 6.363 6.429 6.494 6.56 6.626 6.692 6.772 6.86 6.948 7.036 7.123 7.211 7.299 7.387 7.475 7.563 7.651 7.739 7.843 7.966 8.089 8.212 8.335 8.458 8.582 8.705 8.828 8.951 9.074 9.197 9.32 9.434 9.546 9.658 9.77 9.881 9.993 10.1 10.22 10.33 10.44 10.55 10.66 10.78 10.89 11 11.11 11.22 11.33 11.45 11.56 11.67 11.78 11.89 12 12.12 12.32 12.45 12.58 12.71 12.84 12.97;
%5.334 5.407 5.474 5.535 5.591 5.643 5.692 5.738 5.783 5.546 5.609 5.672 5.735 5.799 5.865 5.931 5.997 6.063 6.128 6.194 6.26 6.326 6.392 6.457 6.523 6.589 6.655 6.737 6.825 6.913 7.001 7.089 7.177 7.265 7.353 7.441 7.529 7.617 7.705 7.793 7.881 7.969 8.057 8.145 8.254 8.377 8.5 8.623 8.746 8.869 8.992 9.115 9.238 9.361 9.485 9.608 9.731 9.854 9.977 10.1 10.22 10.35 10.46 10.57 10.68 10.8 10.91 11.02 11.13 11.24 11.35 11.47 11.58 11.69 11.8 11.91 12.03 12.12 12.32 12.46 12.59 12.72 12.86 12.99 13.12 13.25;
%5.452 5.526 5.593 5.655 5.712 5.765 5.815 5.863 5.639 5.702 5.765 5.828 5.894 5.96 6.026 6.091 6.157 6.223 6.289 6.355 6.421 6.486 6.552 6.618 6.702 6.79 6.878 6.966 7.054 7.142 7.23 7.318 7.406 7.494 7.582 7.67 7.758 7.846 7.934 8.022 8.11 8.198 8.286 8.374 8.462 8.55 8.665 8.788 8.911 9.034 9.157 9.28 9.403 9.526 9.649 9.772 9.895 10.02 10.14 10.26 10.39 10.51 10.63 10.76 10.88 11 11.13 11.25 11.37 11.49 11.6 11.71 11.82 11.93 12.03 12.12 12.31 12.45 12.58 12.72 12.86 12.99 13.13 13.26 13.4 13.54;
%5.569 5.644 5.712 5.775 5.833 5.887 5.938 5.732 5.795 5.859 5.923 5.989 6.055 6.12 6.186 6.252 6.318 6.384 6.449 6.515 6.581 6.668 6.756 6.844 6.932 7.02 7.108 7.196 7.284 7.372 7.46 7.548 7.636 7.724 7.812 7.9 7.988 8.076 8.164 8.252 8.34 8.428 8.516 8.604 8.692 8.78 8.868 8.956 9.075 9.198 9.321 9.444 9.568 9.691 9.814 9.937 10.06 10.18 10.31 10.43 10.55 10.68 10.8 10.92 11.04 11.17 11.29 11.41 11.54 11.66 11.79 11.92 12.01 12.11 12.29 12.43 12.57 12.71 12.85 12.98 13.12 13.26 13.4 13.54 13.68 13.82;
%5.685 5.761 5.83 5.894 5.953 6.008 5.826 5.889 5.952 6.018 6.083 6.149 6.215 6.281 6.347 6.412 6.478 6.545 6.633 6.721 6.809 6.897 6.985 7.073 7.161 7.249 7.337 7.425 7.513 7.601 7.689 7.777 7.865 7.953 8.041 8.129 8.217 8.305 8.393 8.481 8.569 8.657 8.745 8.833 8.921 9.009 9.097 9.185 9.273 9.363 9.486 9.609 9.732 9.855 9.978 10.1 10.22 10.35 10.47 10.59 10.72 10.84 10.96 11.09 11.21 11.33 11.46 11.59 11.72 11.85 11.99 12.12 12.26 12.4 12.54 12.68 12.82 12.96 13.11 13.25 13.39 13.53 13.67 13.81 13.96 14.1;
%5.8 5.877 5.947 6.012 6.072 5.919 5.982 6.046 6.112 6.178 6.244 6.31 6.376 6.441 6.511 6.599 6.687 6.775 6.863 6.951 7.039 7.127 7.215 7.303 7.391 7.479 7.567 7.655 7.743 7.831 7.919 8.007 8.095 8.183 8.271 8.359 8.447 8.535 8.623 8.711 8.799 8.887 8.975 9.063 9.151 9.239 9.327 9.415 9.503 9.591 9.679 9.774 9.897 10.02 10.14 10.27 10.39 10.51 10.64 10.76 10.88 11 11.13 11.26 11.39 11.53 11.67 11.81 11.93 12.07 12.21 12.36 12.5 12.64 12.79 12.93 13.08 13.22 13.36 13.51 13.65 13.8 13.94 14.09 14.23 14.38;
%5.914 5.992 6.063 6.129 6.013 6.076 6.141 6.207 6.273 6.339 6.404 6.476 6.564 6.652 6.74 6.828 6.916 7.004 7.092 7.18 7.268 7.356 7.444 7.532 7.62 7.708 7.796 7.884 7.972 8.06 8.148 8.236 8.324 8.412 8.5 8.588 8.676 8.764 8.852 8.94 9.028 9.116 9.204 9.292 9.38 9.468 9.556 9.644 9.732 9.82 9.908 9.996 10.08 10.18 10.31 10.43 10.55 10.68 10.8 10.94 11.08 11.22 11.37 11.51 11.65 11.73 11.88 12.02 12.16 12.31 12.45 12.6 12.74 12.89 13.04 13.18 13.33 13.48 13.62 13.77 13.92 14.07 14.21 14.36 14.51 14.65;
%6.028 6.106 6.179 6.106 6.17 6.236 6.302 6.367 6.442 6.53 6.618 6.706 6.794 6.882 6.97 7.058 7.146 7.234 7.322 7.41 7.498 7.586 7.674 7.762 7.85 7.938 8.026 8.114 8.202 8.29 8.378 8.466 8.554 8.642 8.73 8.818 8.906 8.994 9.081 9.169 9.257 9.345 9.433 9.521 9.609 9.697 9.785 9.873 9.961 10.05 10.14 10.22 10.3 10.38 10.47 10.6 10.74 10.88 11.01 11.15 11.29 11.39 11.53 11.67 11.81 11.96 12.1 12.25 12.39 12.54 12.69 12.84 12.98 13.13 13.28 13.43 13.58 13.73 13.88 14.03 14.18 14.33 14.48 14.63 14.78 14.93;
%6.14 6.22 6.199 6.265 6.331 6.407 6.495 6.583 6.671 6.759 6.847 6.935 7.023 7.111 7.199 7.287 7.375 7.463 7.551 7.639 7.727 7.815 7.903 7.991 8.079 8.167 8.255 8.343 8.431 8.519 8.606 8.686 8.766 8.846 8.926 9.006 9.085 9.165 9.245 9.325 9.405 9.485 9.564 9.644 9.724 9.804 9.884 9.963 10.04 10.12 10.2 10.28 10.36 10.49 10.62 10.75 10.91 11.04 11.18 11.32 11.46 11.6 11.75 11.89 12.04 12.18 12.33 12.48 12.62 12.77 12.92 13.07 13.22 13.38 13.53 13.68 13.83 13.98 14.14 14.29 14.44 14.6 14.75 14.9 15.05 15.21;
%6.251 6.294 6.373 6.461 6.549 6.637 6.725 6.813 6.901 6.989 7.071 7.151 7.23 7.31 7.39 7.47 7.55 7.63 7.709 7.789 7.869 7.949 8.029 8.109 8.188 8.268 8.348 8.428 8.508 8.588 8.667 8.747 8.827 8.907 8.987 9.067 9.146 9.226 9.306 9.386 9.466 9.546 9.625 9.705 9.785 9.865 9.945 10.02 10.1 10.18 10.26 10.37 10.56 10.7 10.83 10.97 11.11 11.25 11.39 11.53 11.67 11.81 11.96 12.11 12.25 12.4 12.55 12.7 12.85 13 13.16 13.31 13.46 13.62 13.77 13.93 14.08 14.24 14.39 14.55 14.7 14.86 15.02 15.17 15.33 15.48;
%6.361 6.442 6.518 6.587 6.653 6.714 6.773 6.829 6.947 7.021 7.095 7.17 7.244 7.318 7.392 7.466 7.544 7.624 7.703 7.782 7.862 7.941 8.02 8.1 8.179 8.259 8.338 8.417 8.497 8.576 8.656 8.735 8.814 8.894 8.973 9.053 9.132 9.211 9.291 9.37 9.45 9.529 9.608 9.688 9.77 9.858 9.946 10.11 10.23 10.36 10.49 10.62 10.75 10.89 11.03 11.17 11.31 11.45 11.59 11.73 11.88 12.03 12.17 12.32 12.47 12.62 12.77 12.93 13.08 13.24 13.39 13.55 13.7 13.86 14.02 14.17 14.33 14.49 14.65 14.81 14.96 15.12 15.28 15.44 15.6 15.76;
%6.469 6.552 6.628 6.699 6.765 6.828 6.887 6.945 7 7.055 7.109 7.162 7.216 7.27 7.325 7.381 7.438 7.496 7.556 7.618 7.681 8.008 8.082 8.157 8.231 8.305 8.379 8.454 8.528 8.602 8.676 8.75 8.825 8.899 8.973 9.047 9.122 9.196 9.283 9.373 9.464 9.554 9.645 9.791 9.911 10.03 10.16 10.28 10.41 10.54 10.67 10.81 10.94 11.08 11.22 11.36 11.5 11.65 11.79 11.94 12.09 12.23 12.38 12.54 12.69 12.84 13 13.15 13.31 13.46 13.62 13.78 13.94 14.1 14.26 14.42 14.58 14.74 14.9 15.06 15.22 15.38 15.55 15.71 15.87 16.03;
%6.576 6.66 6.737 6.809 6.876 6.94 7 7.059 7.116 7.171 7.226 7.281 7.336 7.391 7.447 7.505 7.563 7.623 7.684 7.747 7.812 7.879 7.948 8.02 8.093 8.169 8.248 8.329 8.412 8.498 8.586 8.677 8.771 8.866 8.965 9.144 9.218 9.292 9.383 9.494 9.607 9.722 9.84 9.96 10.08 10.21 10.33 10.46 10.59 10.72 10.86 10.99 11.13 11.27 11.41 11.55 11.7 11.85 11.99 12.14 12.29 12.44 12.59 12.75 12.9 13.06 13.22 13.37 13.53 13.69 13.85 14.01 14.17 14.34 14.5 14.66 14.82 14.99 15.15 15.31 15.48 15.64 15.81 15.97 16.14 16.3]'; 

fc_fuel_map=[  1.4900000e-001  1.7990884e-001  3.5125058e-001  5.2259233e-001  6.9393408e-001  7.1560000e-001  9.9790000e-001  1.2150000e+000  1.3910000e+000  1.5400000e+000  1.6710000e+000  1.7890000e+000  1.9000000e+000  2.0050000e+000  2.1070000e+000  2.2070000e+000  2.3060000e+000  2.4050000e+000  2.5050000e+000  2.6060000e+000  2.7070000e+000  2.8110000e+000  2.9150000e+000  3.0210000e+000  3.1280000e+000  3.2370000e+000  3.3470000e+000  3.4590000e+000  3.5720000e+000  3.6850000e+000  3.8000000e+000  3.9160000e+000  4.0320000e+000  4.1490000e+000  4.2670000e+000  4.3850000e+000  4.5040000e+000  4.6230000e+000  4.7420000e+000  4.8610000e+000  4.9800000e+000  5.0980000e+000  5.2170000e+000  5.3340000e+000  5.4520000e+000  5.5690000e+000  5.6850000e+000  5.8000000e+000  5.9140000e+000  6.0280000e+000  6.1400000e+000  6.2510000e+000  6.3610000e+000  6.4690000e+000  6.5760000e+000
  1.4900000e-001  1.8506311e-001  3.6131370e-001  5.3756428e-001  7.1381487e-001  7.5230000e-001  1.0360000e+000  1.2540000e+000  1.4310000e+000  1.5810000e+000  1.7120000e+000  1.8320000e+000  1.9430000e+000  2.0490000e+000  2.1520000e+000  2.2530000e+000  2.3530000e+000  2.4530000e+000  2.5540000e+000  2.6560000e+000  2.7580000e+000  2.8630000e+000  2.9680000e+000  3.0750000e+000  3.1830000e+000  3.2930000e+000  3.4040000e+000  3.5170000e+000  3.6300000e+000  3.7450000e+000  3.8610000e+000  3.9770000e+000  4.0950000e+000  4.2130000e+000  4.3320000e+000  4.4510000e+000  4.5700000e+000  4.6900000e+000  4.8100000e+000  4.9300000e+000  5.0500000e+000  5.1690000e+000  5.2890000e+000  5.4070000e+000  5.5260000e+000  5.6440000e+000  5.7610000e+000  5.8770000e+000  5.9920000e+000  6.1060000e+000  6.2200000e+000  6.2940000e+000  6.4420000e+000  6.5520000e+000  6.6600000e+000
  1.4900000e-001  1.9019285e-001  3.7132889e-001  5.5246494e-001  7.3360098e-001  7.8140000e-001  1.0660000e+000  1.2850000e+000  1.4630000e+000  1.6140000e+000  1.7460000e+000  1.8670000e+000  1.9790000e+000  2.0860000e+000  2.1900000e+000  2.2920000e+000  2.3930000e+000  2.4940000e+000  2.5960000e+000  2.6990000e+000  2.8020000e+000  2.9070000e+000  3.0140000e+000  3.1220000e+000  3.2310000e+000  3.3420000e+000  3.4540000e+000  3.5670000e+000  3.6820000e+000  3.7980000e+000  3.9140000e+000  4.0320000e+000  4.1500000e+000  4.2700000e+000  4.3890000e+000  4.5090000e+000  4.6300000e+000  4.7510000e+000  4.8710000e+000  4.9920000e+000  5.1130000e+000  5.2340000e+000  5.3540000e+000  5.4740000e+000  5.5930000e+000  5.7120000e+000  5.8300000e+000  5.9470000e+000  6.0630000e+000  6.1790000e+000  6.1990000e+000  6.3730000e+000  6.5180000e+000  6.6280000e+000  6.7370000e+000
  1.4900000e-001  1.9534712e-001  3.8139201e-001  5.6743689e-001  7.5348177e-001  8.0400000e-001  1.0890000e+000  1.3100000e+000  1.4890000e+000  1.6400000e+000  1.7740000e+000  1.8950000e+000  2.0090000e+000  2.1170000e+000  2.2210000e+000  2.3240000e+000  2.4270000e+000  2.5290000e+000  2.6320000e+000  2.7350000e+000  2.8400000e+000  2.9460000e+000  3.0530000e+000  3.1620000e+000  3.2730000e+000  3.3840000e+000  3.4980000e+000  3.6120000e+000  3.7280000e+000  3.8440000e+000  3.9620000e+000  4.0810000e+000  4.2000000e+000  4.3200000e+000  4.4410000e+000  4.5620000e+000  4.6840000e+000  4.8050000e+000  4.9270000e+000  5.0490000e+000  5.1710000e+000  5.2920000e+000  5.4140000e+000  5.5350000e+000  5.6550000e+000  5.7750000e+000  5.8940000e+000  6.0120000e+000  6.1290000e+000  6.1060000e+000  6.2650000e+000  6.4610000e+000  6.5870000e+000  6.6990000e+000  6.8090000e+000
  1.4900000e-001  2.0047686e-001  3.9140720e-001  5.8233754e-001  7.7326788e-001  8.2100000e-001  1.1070000e+000  1.3290000e+000  1.5090000e+000  1.6620000e+000  1.7960000e+000  1.9190000e+000  2.0330000e+000  2.1420000e+000  2.2480000e+000  2.3520000e+000  2.4550000e+000  2.5580000e+000  2.6620000e+000  2.7670000e+000  2.8720000e+000  2.9790000e+000  3.0880000e+000  3.1980000e+000  3.3090000e+000  3.4220000e+000  3.5360000e+000  3.6520000e+000  3.7680000e+000  3.8860000e+000  4.0050000e+000  4.1240000e+000  4.2450000e+000  4.3660000e+000  4.4880000e+000  4.6100000e+000  4.7320000e+000  4.8550000e+000  4.9780000e+000  5.1010000e+000  5.2240000e+000  5.3460000e+000  5.4690000e+000  5.5910000e+000  5.7120000e+000  5.8330000e+000  5.9530000e+000  6.0720000e+000  6.0130000e+000  6.1700000e+000  6.3310000e+000  6.5490000e+000  6.6530000e+000  6.7650000e+000  6.8760000e+000
  1.4900000e-001  2.0563114e-001  4.0147031e-001  5.9730949e-001  7.9314867e-001  8.3330000e-001  1.1210000e+000  1.3430000e+000  1.5240000e+000  1.6780000e+000  1.8140000e+000  1.9370000e+000  2.0520000e+000  2.1630000e+000  2.2690000e+000  2.3740000e+000  2.4790000e+000  2.5830000e+000  2.6880000e+000  2.7930000e+000  2.9000000e+000  3.0080000e+000  3.1180000e+000  3.2290000e+000  3.3410000e+000  3.4550000e+000  3.5700000e+000  3.6870000e+000  3.8040000e+000  3.9230000e+000  4.0430000e+000  4.1640000e+000  4.2850000e+000  4.4080000e+000  4.5300000e+000  4.6540000e+000  4.7770000e+000  4.9010000e+000  5.0250000e+000  5.1490000e+000  5.2730000e+000  5.3960000e+000  5.5200000e+000  5.6430000e+000  5.7650000e+000  5.8870000e+000  6.0080000e+000  5.9190000e+000  6.0760000e+000  6.2360000e+000  6.4070000e+000  6.6370000e+000  6.7140000e+000  6.8280000e+000  6.9400000e+000
  1.4900000e-001  2.1076087e-001  4.1148551e-001  6.1221014e-001  8.1293478e-001  8.4150000e-001  1.1300000e+000  1.3530000e+000  1.5360000e+000  1.6910000e+000  1.8270000e+000  1.9520000e+000  2.0680000e+000  2.1790000e+000  2.2870000e+000  2.3930000e+000  2.4990000e+000  2.6040000e+000  2.7100000e+000  2.8170000e+000  2.9250000e+000  3.0340000e+000  3.1440000e+000  3.2560000e+000  3.3700000e+000  3.4850000e+000  3.6010000e+000  3.7190000e+000  3.8370000e+000  3.9570000e+000  4.0780000e+000  4.2000000e+000  4.3220000e+000  4.4460000e+000  4.5700000e+000  4.6940000e+000  4.8190000e+000  4.9430000e+000  5.0680000e+000  5.1940000e+000  5.3180000e+000  5.4430000e+000  5.5680000e+000  5.6920000e+000  5.8150000e+000  5.9380000e+000  5.8260000e+000  5.9820000e+000  6.1410000e+000  6.3020000e+000  6.4950000e+000  6.7250000e+000  6.7730000e+000  6.8870000e+000  7.0000000e+000
  1.4900000e-001  2.1589060e-001  4.2150070e-001  6.2711080e-001  8.3272090e-001  8.4630000e-001  1.1360000e+000  1.3600000e+000  1.5440000e+000  1.7000000e+000  1.8380000e+000  1.9630000e+000  2.0810000e+000  2.1930000e+000  2.3020000e+000  2.4090000e+000  2.5160000e+000  2.6220000e+000  2.7290000e+000  2.8370000e+000  2.9460000e+000  3.0560000e+000  3.1680000e+000  3.2810000e+000  3.3960000e+000  3.5120000e+000  3.6290000e+000  3.7480000e+000  3.8670000e+000  3.9880000e+000  4.1100000e+000  4.2330000e+000  4.3570000e+000  4.4810000e+000  4.6060000e+000  4.7320000e+000  4.8570000e+000  4.9830000e+000  5.1090000e+000  5.2360000e+000  5.3620000e+000  5.4870000e+000  5.6130000e+000  5.7380000e+000  5.8630000e+000  5.7320000e+000  5.8890000e+000  6.0460000e+000  6.2070000e+000  6.3670000e+000  6.5830000e+000  6.8130000e+000  6.8290000e+000  6.9450000e+000  7.0590000e+000
  1.4900000e-001  2.2104488e-001  4.3156381e-001  6.4208275e-001  8.5260168e-001  8.4830000e-001  1.1390000e+000  1.3650000e+000  1.5490000e+000  1.7060000e+000  1.8450000e+000  1.9720000e+000  2.0900000e+000  2.2040000e+000  2.3140000e+000  2.4220000e+000  2.5300000e+000  2.6370000e+000  2.7460000e+000  2.8550000e+000  2.9650000e+000  3.0760000e+000  3.1890000e+000  3.3030000e+000  3.4190000e+000  3.5360000e+000  3.6540000e+000  3.7740000e+000  3.8950000e+000  4.0170000e+000  4.1400000e+000  4.2640000e+000  4.3890000e+000  4.5150000e+000  4.6410000e+000  4.7670000e+000  4.8940000e+000  5.0210000e+000  5.1480000e+000  5.2760000e+000  5.4030000e+000  5.5300000e+000  5.6560000e+000  5.7830000e+000  5.6390000e+000  5.7950000e+000  5.9520000e+000  6.1120000e+000  6.2730000e+000  6.4420000e+000  6.6710000e+000  6.9010000e+000  6.9470000e+000  7.0000000e+000  7.1160000e+000
  1.4900000e-001  2.2617461e-001  4.4157901e-001  6.5698340e-001  8.7238780e-001  8.4810000e-001  1.1400000e+000  1.3670000e+000  1.5520000e+000  1.7110000e+000  1.8510000e+000  1.9780000e+000  2.0980000e+000  2.2130000e+000  2.3240000e+000  2.4330000e+000  2.5420000e+000  2.6510000e+000  2.7600000e+000  2.8700000e+000  2.9820000e+000  3.0940000e+000  3.2080000e+000  3.3230000e+000  3.4400000e+000  3.5590000e+000  3.6780000e+000  3.7990000e+000  3.9210000e+000  4.0440000e+000  4.1690000e+000  4.2940000e+000  4.4200000e+000  4.5460000e+000  4.6740000e+000  4.8010000e+000  4.9290000e+000  5.0570000e+000  5.1860000e+000  5.3140000e+000  5.4420000e+000  5.5710000e+000  5.6980000e+000  5.5460000e+000  5.7020000e+000  5.8590000e+000  6.0180000e+000  6.1780000e+000  6.3390000e+000  6.5300000e+000  6.7590000e+000  6.9890000e+000  7.0210000e+000  7.0550000e+000  7.1710000e+000
  1.4900000e-001  2.3132889e-001  4.5164212e-001  6.7195535e-001  8.9226858e-001  8.4600000e-001  1.1390000e+000  1.3670000e+000  1.5540000e+000  1.7130000e+000  1.8540000e+000  1.9830000e+000  2.1040000e+000  2.2200000e+000  2.3320000e+000  2.4430000e+000  2.5530000e+000  2.6630000e+000  2.7730000e+000  2.8840000e+000  2.9970000e+000  3.1110000e+000  3.2260000e+000  3.3420000e+000  3.4600000e+000  3.5800000e+000  3.7010000e+000  3.8230000e+000  3.9460000e+000  4.0700000e+000  4.1960000e+000  4.3220000e+000  4.4490000e+000  4.5770000e+000  4.7050000e+000  4.8340000e+000  4.9630000e+000  5.0930000e+000  5.2220000e+000  5.3520000e+000  5.4810000e+000  5.6100000e+000  5.4520000e+000  5.6090000e+000  5.7650000e+000  5.9230000e+000  6.0830000e+000  6.2440000e+000  6.4040000e+000  6.6180000e+000  6.8470000e+000  7.0710000e+000  7.0950000e+000  7.1090000e+000  7.2260000e+000
  1.4900000e-001  2.3645863e-001  4.6165732e-001  6.8685601e-001  9.1205470e-001  8.4260000e-001  1.1370000e+000  1.3660000e+000  1.5540000e+000  1.7140000e+000  1.8570000e+000  1.9870000e+000  2.1090000e+000  2.2260000e+000  2.3400000e+000  2.4510000e+000  2.5630000e+000  2.6740000e+000  2.7850000e+000  2.8980000e+000  3.0110000e+000  3.1260000e+000  3.2430000e+000  3.3600000e+000  3.4790000e+000  3.6000000e+000  3.7220000e+000  3.8450000e+000  3.9700000e+000  4.0950000e+000  4.2220000e+000  4.3490000e+000  4.4780000e+000  4.6070000e+000  4.7360000e+000  4.8660000e+000  4.9970000e+000  5.1270000e+000  5.2580000e+000  5.3890000e+000  5.5190000e+000  5.3590000e+000  5.5150000e+000  5.6720000e+000  5.8280000e+000  5.9890000e+000  6.1490000e+000  6.3100000e+000  6.4760000e+000  6.7060000e+000  6.9350000e+000  7.1510000e+000  7.1700000e+000  7.1620000e+000  7.2810000e+000
  1.4900000e-001  2.4161290e-001  4.7172043e-001  7.0182796e-001  9.3193548e-001  8.3810000e-001  1.1330000e+000  1.3640000e+000  1.5530000e+000  1.7150000e+000  1.8580000e+000  1.9900000e+000  2.1130000e+000  2.2310000e+000  2.3460000e+000  2.4590000e+000  2.5710000e+000  2.6840000e+000  2.7960000e+000  2.9100000e+000  3.0250000e+000  3.1410000e+000  3.2590000e+000  3.3780000e+000  3.4980000e+000  3.6200000e+000  3.7430000e+000  3.8670000e+000  3.9930000e+000  4.1200000e+000  4.2480000e+000  4.3760000e+000  4.5060000e+000  4.6360000e+000  4.7670000e+000  4.8980000e+000  5.0300000e+000  5.1620000e+000  5.2930000e+000  5.4250000e+000  5.2660000e+000  5.4220000e+000  5.5780000e+000  5.7350000e+000  5.8940000e+000  6.0550000e+000  6.2150000e+000  6.3760000e+000  6.5640000e+000  6.7940000e+000  7.0230000e+000  7.2300000e+000  7.2440000e+000  7.2160000e+000  7.3360000e+000
  1.4900000e-001  2.4666900e-001  4.8159187e-001  7.1651473e-001  9.5143759e-001  8.3290000e-001  1.1290000e+000  1.3610000e+000  1.5520000e+000  1.7150000e+000  1.8590000e+000  1.9920000e+000  2.1170000e+000  2.2360000e+000  2.3520000e+000  2.4660000e+000  2.5800000e+000  2.6930000e+000  2.8070000e+000  2.9220000e+000  3.0380000e+000  3.1560000e+000  3.2740000e+000  3.3950000e+000  3.5160000e+000  3.6390000e+000  3.7640000e+000  3.8890000e+000  4.0160000e+000  4.1440000e+000  4.2730000e+000  4.4030000e+000  4.5340000e+000  4.6660000e+000  4.7980000e+000  4.9300000e+000  5.0630000e+000  5.1960000e+000  5.0160000e+000  5.1720000e+000  5.3290000e+000  5.4850000e+000  5.6410000e+000  5.7990000e+000  5.9600000e+000  6.1200000e+000  6.2810000e+000  6.4410000e+000  6.6520000e+000  6.8820000e+000  7.1110000e+000  7.3100000e+000  7.3180000e+000  7.2700000e+000  7.3910000e+000
  1.4900000e-001  2.5182328e-001  4.9165498e-001  7.3148668e-001  9.7131837e-001  8.2740000e-001  1.1250000e+000  1.3580000e+000  1.5500000e+000  1.7140000e+000  1.8600000e+000  1.9940000e+000  2.1200000e+000  2.2400000e+000  2.3580000e+000  2.4730000e+000  2.5880000e+000  2.7030000e+000  2.8180000e+000  2.9340000e+000  3.0520000e+000  3.1700000e+000  3.2900000e+000  3.4120000e+000  3.5350000e+000  3.6590000e+000  3.7850000e+000  3.9120000e+000  4.0400000e+000  4.1690000e+000  4.2990000e+000  4.4300000e+000  4.5620000e+000  4.6950000e+000  4.8280000e+000  4.9620000e+000  5.0960000e+000  4.9230000e+000  5.0790000e+000  5.2350000e+000  5.3920000e+000  5.5480000e+000  5.7050000e+000  5.8650000e+000  6.0260000e+000  6.1860000e+000  6.3470000e+000  6.5110000e+000  6.7400000e+000  6.9700000e+000  7.1990000e+000  7.3900000e+000  7.3920000e+000  7.3250000e+000  7.4470000e+000
  1.4900000e-001  2.5697756e-001  5.0171809e-001  7.4645863e-001  9.9119916e-001  8.2170000e-001  1.1210000e+000  1.3550000e+000  1.5480000e+000  1.7130000e+000  1.8610000e+000  1.9960000e+000  2.1230000e+000  2.2450000e+000  2.3640000e+000  2.4800000e+000  2.5960000e+000  2.7130000e+000  2.8290000e+000  2.9470000e+000  3.0650000e+000  3.1850000e+000  3.3060000e+000  3.4290000e+000  3.5530000e+000  3.6790000e+000  3.8060000e+000  3.9340000e+000  4.0630000e+000  4.1940000e+000  4.3260000e+000  4.4580000e+000  4.5910000e+000  4.7250000e+000  4.8600000e+000  4.9950000e+000  4.8290000e+000  4.9860000e+000  5.1420000e+000  5.2980000e+000  5.4550000e+000  5.6110000e+000  5.7710000e+000  5.9310000e+000  6.0910000e+000  6.2520000e+000  6.4120000e+000  6.5990000e+000  6.8280000e+000  7.0580000e+000  7.2870000e+000  7.4700000e+000  7.4660000e+000  7.3810000e+000  7.5050000e+000
  1.4900000e-001  2.6213184e-001  5.1178121e-001  7.6143058e-001  1.0110799e+000  8.1610000e-001  1.1160000e+000  1.3520000e+000  1.5460000e+000  1.7130000e+000  1.8620000e+000  1.9980000e+000  2.1270000e+000  2.2500000e+000  2.3700000e+000  2.4880000e+000  2.6050000e+000  2.7230000e+000  2.8400000e+000  2.9590000e+000  3.0790000e+000  3.2000000e+000  3.3230000e+000  3.4470000e+000  3.5720000e+000  3.6990000e+000  3.8280000e+000  3.9570000e+000  4.0880000e+000  4.2200000e+000  4.3530000e+000  4.4860000e+000  4.6210000e+000  4.7560000e+000  4.8920000e+000  4.7360000e+000  4.8920000e+000  5.0490000e+000  5.2050000e+000  5.3610000e+000  5.5180000e+000  5.6760000e+000  5.8360000e+000  5.9970000e+000  6.1570000e+000  6.3180000e+000  6.4780000e+000  6.6870000e+000  6.9160000e+000  7.1460000e+000  7.3750000e+000  7.5500000e+000  7.5440000e+000  7.4380000e+000  7.5630000e+000
  1.4900000e-001  2.6728612e-001  5.2184432e-001  7.7640252e-001  1.0309607e+000  8.1070000e-001  1.1120000e+000  1.3490000e+000  1.5450000e+000  1.7130000e+000  1.8630000e+000  2.0010000e+000  2.1310000e+000  2.2550000e+000  2.3760000e+000  2.4960000e+000  2.6150000e+000  2.7330000e+000  2.8520000e+000  2.9720000e+000  3.0940000e+000  3.2160000e+000  3.3400000e+000  3.4660000e+000  3.5920000e+000  3.7210000e+000  3.8500000e+000  3.9810000e+000  4.1130000e+000  4.2460000e+000  4.3800000e+000  4.5160000e+000  4.6510000e+000  4.7880000e+000  4.6420000e+000  4.7990000e+000  4.9550000e+000  5.1120000e+000  5.2680000e+000  5.4240000e+000  5.5810000e+000  5.7420000e+000  5.9020000e+000  6.0630000e+000  6.2230000e+000  6.3840000e+000  6.5450000e+000  6.7750000e+000  7.0040000e+000  7.2340000e+000  7.4630000e+000  7.6300000e+000  7.6240000e+000  7.4960000e+000  7.6230000e+000
  1.4900000e-001  2.7244039e-001  5.3190743e-001  7.9137447e-001  1.0508415e+000  8.0590000e-001  1.1090000e+000  1.3470000e+000  1.5440000e+000  1.7140000e+000  1.8650000e+000  2.0040000e+000  2.1350000e+000  2.2610000e+000  2.3840000e+000  2.5040000e+000  2.6250000e+000  2.7450000e+000  2.8650000e+000  2.9870000e+000  3.1090000e+000  3.2330000e+000  3.3580000e+000  3.4850000e+000  3.6130000e+000  3.7430000e+000  3.8740000e+000  4.0060000e+000  4.1390000e+000  4.2740000e+000  4.4090000e+000  4.5460000e+000  4.6830000e+000  4.5490000e+000  4.7050000e+000  4.8620000e+000  5.0180000e+000  5.1750000e+000  5.3310000e+000  5.4870000e+000  5.6470000e+000  5.8070000e+000  5.9680000e+000  6.1280000e+000  6.2890000e+000  6.4490000e+000  6.6330000e+000  6.8630000e+000  7.0920000e+000  7.3220000e+000  7.5510000e+000  7.7090000e+000  7.7030000e+000  7.5560000e+000  7.6840000e+000
  1.4900000e-001  2.7759467e-001  5.4197055e-001  8.0634642e-001  1.0707223e+000  8.0170000e-001  1.1060000e+000  1.3460000e+000  1.5440000e+000  1.7150000e+000  1.8680000e+000  2.0080000e+000  2.1410000e+000  2.2680000e+000  2.3920000e+000  2.5140000e+000  2.6350000e+000  2.7570000e+000  2.8790000e+000  3.0020000e+000  3.1260000e+000  3.2510000e+000  3.3770000e+000  3.5060000e+000  3.6350000e+000  3.7660000e+000  3.8980000e+000  4.0320000e+000  4.1670000e+000  4.3030000e+000  4.4400000e+000  4.5770000e+000  4.4560000e+000  4.6120000e+000  4.7680000e+000  4.9250000e+000  5.0810000e+000  5.2380000e+000  5.3940000e+000  5.5520000e+000  5.7130000e+000  5.8730000e+000  6.0340000e+000  6.1940000e+000  6.3550000e+000  6.5150000e+000  6.7210000e+000  6.9510000e+000  7.1800000e+000  7.4100000e+000  7.6390000e+000  7.7890000e+000  7.7820000e+000  7.6180000e+000  7.7470000e+000
  1.4900000e-001  2.8274895e-001  5.5203366e-001  8.2131837e-001  1.0906031e+000  7.9830000e-001  1.1040000e+000  1.3450000e+000  1.5450000e+000  1.7170000e+000  1.8710000e+000  2.0130000e+000  2.1470000e+000  2.2760000e+000  2.4010000e+000  2.5250000e+000  2.6470000e+000  2.7700000e+000  2.8930000e+000  3.0180000e+000  3.1430000e+000  3.2700000e+000  3.3980000e+000  3.5270000e+000  3.6580000e+000  3.7900000e+000  3.9240000e+000  4.0590000e+000  4.1950000e+000  4.3330000e+000  4.4710000e+000  4.3620000e+000  4.5190000e+000  4.6750000e+000  4.8320000e+000  4.9880000e+000  5.1440000e+000  5.3010000e+000  5.4580000e+000  5.6180000e+000  5.7790000e+000  5.9390000e+000  6.1000000e+000  6.2600000e+000  6.4210000e+000  6.5810000e+000  6.8090000e+000  7.0390000e+000  7.2680000e+000  7.4980000e+000  7.7270000e+000  7.8690000e+000  7.8620000e+000  7.6810000e+000  7.8120000e+000
  1.4900000e-001  2.8790323e-001  5.6209677e-001  8.3629032e-001  1.1104839e+000  7.9570000e-001  1.1030000e+000  1.3450000e+000  1.5460000e+000  1.7200000e+000  1.8760000e+000  2.0190000e+000  2.1540000e+000  2.2840000e+000  2.4110000e+000  2.5360000e+000  2.6600000e+000  2.7850000e+000  2.9090000e+000  3.0350000e+000  3.1620000e+000  3.2900000e+000  3.4190000e+000  3.5500000e+000  3.6830000e+000  3.8160000e+000  3.9510000e+000  4.0880000e+000  4.2250000e+000  4.3640000e+000  4.2690000e+000  4.4250000e+000  4.5820000e+000  4.7380000e+000  4.8950000e+000  5.0510000e+000  5.2070000e+000  5.3640000e+000  5.5230000e+000  5.6840000e+000  5.8440000e+000  6.0050000e+000  6.1650000e+000  6.3260000e+000  6.4860000e+000  6.6680000e+000  6.8970000e+000  7.1270000e+000  7.3560000e+000  7.5860000e+000  7.8150000e+000  7.9490000e+000  7.9410000e+000  8.0080000e+000  7.8790000e+000
  1.4900000e-001  2.9305750e-001  5.7215989e-001  8.5126227e-001  1.1303647e+000  7.9420000e-001  1.1030000e+000  1.3470000e+000  1.5490000e+000  1.7240000e+000  1.8820000e+000  2.0260000e+000  2.1630000e+000  2.2940000e+000  2.4230000e+000  2.5490000e+000  2.6750000e+000  2.8000000e+000  2.9270000e+000  3.0540000e+000  3.1820000e+000  3.3110000e+000  3.4420000e+000  3.5750000e+000  3.7080000e+000  3.8440000e+000  3.9800000e+000  4.1180000e+000  4.2570000e+000  4.1760000e+000  4.3320000e+000  4.4880000e+000  4.6450000e+000  4.8010000e+000  4.9580000e+000  5.1140000e+000  5.2700000e+000  5.4290000e+000  5.5890000e+000  5.7500000e+000  5.9100000e+000  6.0710000e+000  6.2310000e+000  6.3920000e+000  6.5520000e+000  6.7560000e+000  6.9850000e+000  7.2150000e+000  7.4440000e+000  7.6740000e+000  7.9030000e+000  8.0290000e+000  8.0200000e+000  8.0820000e+000  7.9480000e+000
  1.4900000e-001  2.9821178e-001  5.8222300e-001  8.6623422e-001  1.1502454e+000  7.9370000e-001  1.1040000e+000  1.3490000e+000  1.5530000e+000  1.7300000e+000  1.8880000e+000  2.0350000e+000  2.1730000e+000  2.3060000e+000  2.4350000e+000  2.5630000e+000  2.6900000e+000  2.8180000e+000  2.9450000e+000  3.0740000e+000  3.2030000e+000  3.3340000e+000  3.4670000e+000  3.6010000e+000  3.7360000e+000  3.8730000e+000  4.0110000e+000  4.1500000e+000  4.0820000e+000  4.2390000e+000  4.3950000e+000  4.5510000e+000  4.7080000e+000  4.8640000e+000  5.0210000e+000  5.1770000e+000  5.3340000e+000  5.4950000e+000  5.6550000e+000  5.8160000e+000  5.9760000e+000  6.1360000e+000  6.2970000e+000  6.4570000e+000  6.6180000e+000  6.8440000e+000  7.0730000e+000  7.3030000e+000  7.5320000e+000  7.7620000e+000  7.9910000e+000  8.1090000e+000  8.1000000e+000  8.1570000e+000  8.0200000e+000
  1.4900000e-001  3.0336606e-001  5.9228612e-001  8.8120617e-001  1.1701262e+000  7.9440000e-001  1.1060000e+000  1.3530000e+000  1.5580000e+000  1.7370000e+000  1.8970000e+000  2.0440000e+000  2.1840000e+000  2.3180000e+000  2.4500000e+000  2.5790000e+000  2.7080000e+000  2.8360000e+000  2.9650000e+000  3.0950000e+000  3.2260000e+000  3.3590000e+000  3.4930000e+000  3.6280000e+000  3.7650000e+000  3.9030000e+000  4.0430000e+000  3.9890000e+000  4.1450000e+000  4.3020000e+000  4.4580000e+000  4.6140000e+000  4.7710000e+000  4.9270000e+000  5.0840000e+000  5.2400000e+000  5.4000000e+000  5.5600000e+000  5.7210000e+000  5.8810000e+000  6.0420000e+000  6.2020000e+000  6.3630000e+000  6.5230000e+000  6.7020000e+000  6.9320000e+000  7.1610000e+000  7.3910000e+000  7.6200000e+000  7.8500000e+000  8.0790000e+000  8.1880000e+000  8.1790000e+000  8.2310000e+000  8.0930000e+000
  1.4900000e-001  3.0852034e-001  6.0234923e-001  8.9617812e-001  1.1900070e+000  7.9630000e-001  1.1090000e+000  1.3580000e+000  1.5650000e+000  1.7440000e+000  1.9060000e+000  2.0550000e+000  2.1960000e+000  2.3320000e+000  2.4650000e+000  2.5960000e+000  2.7260000e+000  2.8560000e+000  2.9870000e+000  3.1180000e+000  3.2510000e+000  3.3850000e+000  3.5200000e+000  3.6570000e+000  3.7960000e+000  3.9350000e+000  3.8950000e+000  4.0520000e+000  4.2080000e+000  4.3650000e+000  4.5210000e+000  4.6770000e+000  4.8340000e+000  4.9900000e+000  5.1470000e+000  5.3050000e+000  5.4660000e+000  5.6260000e+000  5.7870000e+000  5.9470000e+000  6.1080000e+000  6.2680000e+000  6.4290000e+000  6.5890000e+000  6.7900000e+000  7.0200000e+000  7.2490000e+000  7.4790000e+000  7.7080000e+000  7.9380000e+000  8.1670000e+000  8.2680000e+000  8.2590000e+000  8.3050000e+000  8.1690000e+000
  1.4900000e-001  3.1367461e-001  6.1241234e-001  9.1115007e-001  1.2098878e+000  7.9950000e-001  1.1140000e+000  1.3640000e+000  1.5730000e+000  1.7540000e+000  1.9170000e+000  2.0680000e+000  2.2100000e+000  2.3480000e+000  2.4820000e+000  2.6140000e+000  2.7460000e+000  2.8780000e+000  3.0100000e+000  3.1430000e+000  3.2770000e+000  3.4130000e+000  3.5500000e+000  3.6880000e+000  3.8280000e+000  3.8020000e+000  3.9590000e+000  4.1150000e+000  4.2710000e+000  4.4280000e+000  4.5840000e+000  4.7400000e+000  4.8970000e+000  5.0530000e+000  5.2110000e+000  5.3710000e+000  5.5310000e+000  5.6920000e+000  5.8520000e+000  6.0130000e+000  6.1730000e+000  6.3340000e+000  6.4940000e+000  6.6550000e+000  6.8780000e+000  7.1080000e+000  7.3370000e+000  7.5670000e+000  7.7960000e+000  8.0260000e+000  8.2550000e+000  8.3480000e+000  8.3380000e+000  8.3790000e+000  8.2480000e+000
  1.4900000e-001  3.1882889e-001  6.2247546e-001  9.2612202e-001  1.2297686e+000  8.0400000e-001  1.1200000e+000  1.3720000e+000  1.5820000e+000  1.7650000e+000  1.9290000e+000  2.0820000e+000  2.2260000e+000  2.3650000e+000  2.5010000e+000  2.6350000e+000  2.7680000e+000  2.9010000e+000  3.0350000e+000  3.1690000e+000  3.3050000e+000  3.4420000e+000  3.5810000e+000  3.7210000e+000  3.7090000e+000  3.8650000e+000  4.0220000e+000  4.1780000e+000  4.3340000e+000  4.4910000e+000  4.6470000e+000  4.8040000e+000  4.9600000e+000  5.1160000e+000  5.2760000e+000  5.4370000e+000  5.5970000e+000  5.7580000e+000  5.9180000e+000  6.0790000e+000  6.2390000e+000  6.4000000e+000  6.5600000e+000  6.7370000e+000  6.9660000e+000  7.1960000e+000  7.4250000e+000  7.6550000e+000  7.8840000e+000  8.1140000e+000  8.3430000e+000  8.4280000e+000  8.4170000e+000  8.4540000e+000  8.3290000e+000
  1.4900000e-001  3.2373773e-001  6.3205937e-001  9.4038102e-001  1.2487027e+000  8.0980000e-001  1.1280000e+000  1.3810000e+000  1.5920000e+000  1.7770000e+000  1.9430000e+000  2.0970000e+000  2.2430000e+000  2.3830000e+000  2.5210000e+000  2.6560000e+000  2.7910000e+000  2.9260000e+000  3.0610000e+000  3.1970000e+000  3.3350000e+000  3.4730000e+000  3.6130000e+000  3.6150000e+000  3.7720000e+000  3.9280000e+000  4.0850000e+000  4.2410000e+000  4.3970000e+000  4.5540000e+000  4.7100000e+000  4.8670000e+000  5.0230000e+000  5.1820000e+000  5.3420000e+000  5.5030000e+000  5.6630000e+000  5.8240000e+000  5.9840000e+000  6.1450000e+000  6.3050000e+000  6.4660000e+000  6.6260000e+000  6.8250000e+000  7.0540000e+000  7.2840000e+000  7.5130000e+000  7.7430000e+000  7.9720000e+000  8.2020000e+000  8.4310000e+000  8.5080000e+000  8.4970000e+000  8.5280000e+000  8.4120000e+000
  1.4900000e-001  3.2889201e-001  6.4212249e-001  9.5535297e-001  1.2685835e+000  8.1700000e-001  1.1360000e+000  1.3910000e+000  1.6040000e+000  1.7900000e+000  1.9580000e+000  2.1140000e+000  2.2610000e+000  2.4030000e+000  2.5420000e+000  2.6790000e+000  2.8160000e+000  2.9520000e+000  3.0890000e+000  3.2270000e+000  3.3660000e+000  3.5060000e+000  3.5220000e+000  3.6780000e+000  3.8350000e+000  3.9910000e+000  4.1480000e+000  4.3040000e+000  4.4600000e+000  4.6170000e+000  4.7730000e+000  4.9300000e+000  5.0870000e+000  5.2470000e+000  5.4080000e+000  5.5680000e+000  5.7290000e+000  5.8890000e+000  6.0500000e+000  6.2100000e+000  6.3710000e+000  6.5310000e+000  6.6920000e+000  6.9130000e+000  7.1420000e+000  7.3720000e+000  7.6010000e+000  7.8310000e+000  8.0600000e+000  8.2900000e+000  8.5190000e+000  8.5880000e+000  8.5760000e+000  8.6020000e+000  8.4980000e+000
  1.4900000e-001  3.3404628e-001  6.5218560e-001  9.7032492e-001  1.2884642e+000  8.2560000e-001  1.1470000e+000  1.4030000e+000  1.6180000e+000  1.8050000e+000  1.9750000e+000  2.1320000e+000  2.2810000e+000  2.4250000e+000  2.5660000e+000  2.7040000e+000  2.8420000e+000  2.9800000e+000  3.1190000e+000  3.2580000e+000  3.3990000e+000  3.4290000e+000  3.5850000e+000  3.7410000e+000  3.8980000e+000  4.0540000e+000  4.2110000e+000  4.3670000e+000  4.5230000e+000  4.6800000e+000  4.8360000e+000  4.9930000e+000  5.1530000e+000  5.3130000e+000  5.4740000e+000  5.6340000e+000  5.7950000e+000  5.9550000e+000  6.1160000e+000  6.2760000e+000  6.4370000e+000  6.5970000e+000  6.7720000e+000  7.0010000e+000  7.2300000e+000  7.4600000e+000  7.6890000e+000  7.9190000e+000  8.1480000e+000  8.3780000e+000  8.6060000e+000  8.6670000e+000  8.6560000e+000  8.6760000e+000  8.5860000e+000
  1.4900000e-001  3.3920056e-001  6.6224871e-001  9.8529687e-001  1.3083450e+000  8.3560000e-001  1.1580000e+000  1.4160000e+000  1.6330000e+000  1.8220000e+000  1.9930000e+000  2.1520000e+000  2.3030000e+000  2.4480000e+000  2.5900000e+000  2.7310000e+000  2.8700000e+000  3.0100000e+000  3.1500000e+000  3.2920000e+000  3.3350000e+000  3.4920000e+000  3.6480000e+000  3.8040000e+000  3.9610000e+000  4.1170000e+000  4.2740000e+000  4.4300000e+000  4.5860000e+000  4.7430000e+000  4.8990000e+000  5.0580000e+000  5.2190000e+000  5.3790000e+000  5.5400000e+000  5.7000000e+000  5.8610000e+000  6.0210000e+000  6.1810000e+000  6.3420000e+000  6.5020000e+000  6.6630000e+000  6.8600000e+000  7.0890000e+000  7.3180000e+000  7.5480000e+000  7.7770000e+000  8.0070000e+000  8.2360000e+000  8.4660000e+000  8.6860000e+000  8.7470000e+000  8.7350000e+000  8.7500000e+000  8.6770000e+000
  1.4900000e-001  3.4435484e-001  6.7231183e-001  1.0002688e+000  1.3282258e+000  8.4690000e-001  1.1710000e+000  1.4310000e+000  1.6490000e+000  1.8400000e+000  2.0130000e+000  2.1730000e+000  2.3260000e+000  2.4730000e+000  2.6170000e+000  2.7590000e+000  2.9000000e+000  3.0420000e+000  3.1840000e+000  3.2420000e+000  3.3980000e+000  3.5550000e+000  3.7110000e+000  3.8680000e+000  4.0240000e+000  4.1800000e+000  4.3370000e+000  4.4930000e+000  4.6490000e+000  4.8060000e+000  4.9630000e+000  5.1240000e+000  5.2840000e+000  5.4450000e+000  5.6050000e+000  5.7660000e+000  5.9260000e+000  6.0870000e+000  6.2470000e+000  6.4080000e+000  6.5680000e+000  6.7290000e+000  6.9480000e+000  7.1770000e+000  7.4060000e+000  7.6360000e+000  7.8650000e+000  8.0950000e+000  8.3240000e+000  8.5540000e+000  8.7660000e+000  8.8270000e+000  8.8140000e+000  8.8250000e+000  8.7710000e+000
  1.4900000e-001  3.4950912e-001  6.8237494e-001  1.0152408e+000  1.3481066e+000  8.5960000e-001  1.1860000e+000  1.4470000e+000  1.6670000e+000  1.8600000e+000  2.0340000e+000  2.1960000e+000  2.3500000e+000  2.4990000e+000  2.6450000e+000  2.7890000e+000  2.9320000e+000  3.0750000e+000  3.1490000e+000  3.3050000e+000  3.4610000e+000  3.6180000e+000  3.7740000e+000  3.9310000e+000  4.0870000e+000  4.2430000e+000  4.4000000e+000  4.5560000e+000  4.7130000e+000  4.8690000e+000  5.0290000e+000  5.1900000e+000  5.3500000e+000  5.5110000e+000  5.6710000e+000  5.8320000e+000  5.9920000e+000  6.1530000e+000  6.3130000e+000  6.4740000e+000  6.6340000e+000  6.8060000e+000  7.0360000e+000  7.2650000e+000  7.4940000e+000  7.7240000e+000  7.9530000e+000  8.1830000e+000  8.4120000e+000  8.6420000e+000  8.8460000e+000  8.9070000e+000  8.8940000e+000  8.8990000e+000  8.8660000e+000
  1.4900000e-001  3.5466339e-001  6.9243806e-001  1.0302127e+000  1.3679874e+000  8.7370000e-001  1.2020000e+000  1.4650000e+000  1.6860000e+000  1.8810000e+000  2.0570000e+000  2.2210000e+000  2.3760000e+000  2.5270000e+000  2.6740000e+000  2.8200000e+000  2.9650000e+000  3.0550000e+000  3.2120000e+000  3.3680000e+000  3.5240000e+000  3.6810000e+000  3.8370000e+000  3.9940000e+000  4.1500000e+000  4.3060000e+000  4.4630000e+000  4.6190000e+000  4.7760000e+000  4.9350000e+000  5.0950000e+000  5.2560000e+000  5.4160000e+000  5.5760000e+000  5.7370000e+000  5.8970000e+000  6.0580000e+000  6.2180000e+000  6.3790000e+000  6.5390000e+000  6.7000000e+000  6.8940000e+000  7.1230000e+000  7.3530000e+000  7.5820000e+000  7.8120000e+000  8.0410000e+000  8.2710000e+000  8.5000000e+000  8.7300000e+000  8.9260000e+000  8.9870000e+000  8.9730000e+000  8.9730000e+000  8.9650000e+000
  1.4900000e-001  3.5981767e-001  7.0250117e-001  1.0451847e+000  1.3878682e+000  8.8920000e-001  1.2190000e+000  1.4830000e+000  1.7070000e+000  1.9030000e+000  2.0810000e+000  2.2470000e+000  2.4040000e+000  2.5560000e+000  2.7050000e+000  2.8530000e+000  2.9620000e+000  3.1180000e+000  3.2750000e+000  3.4310000e+000  3.5870000e+000  3.7440000e+000  3.9000000e+000  4.0570000e+000  4.2130000e+000  4.3690000e+000  4.5260000e+000  4.6820000e+000  4.8400000e+000  5.0000000e+000  5.1610000e+000  5.3210000e+000  5.4820000e+000  5.6420000e+000  5.8030000e+000  5.9630000e+000  6.1240000e+000  6.2840000e+000  6.4450000e+000  6.6050000e+000  6.7660000e+000  6.9820000e+000  7.2110000e+000  7.4410000e+000  7.6700000e+000  7.9000000e+000  8.1290000e+000  8.3590000e+000  8.5880000e+000  8.8180000e+000  9.0060000e+000  9.0670000e+000  9.0530000e+000  9.0470000e+000  9.1440000e+000
  1.4900000e-001  3.6497195e-001  7.1256428e-001  1.0601566e+000  1.4077489e+000  9.0600000e-001  1.2370000e+000  1.5040000e+000  1.7290000e+000  1.9270000e+000  2.1060000e+000  2.2740000e+000  2.4330000e+000  2.5870000e+000  2.7380000e+000  2.8680000e+000  3.0250000e+000  3.1810000e+000  3.3380000e+000  3.4940000e+000  3.6500000e+000  3.8070000e+000  3.9630000e+000  4.1200000e+000  4.2760000e+000  4.4320000e+000  4.5890000e+000  4.7450000e+000  4.9060000e+000  5.0660000e+000  5.2270000e+000  5.3870000e+000  5.5480000e+000  5.7080000e+000  5.8690000e+000  6.0290000e+000  6.1900000e+000  6.3500000e+000  6.5110000e+000  6.6710000e+000  6.8410000e+000  7.0700000e+000  7.2990000e+000  7.5290000e+000  7.7580000e+000  7.9880000e+000  8.2170000e+000  8.4470000e+000  8.6760000e+000  8.9060000e+000  9.0850000e+000  9.1460000e+000  9.1320000e+000  9.1220000e+000  9.2180000e+000
  1.4900000e-001  3.7012623e-001  7.2262740e-001  1.0751286e+000  1.4276297e+000  9.2410000e-001  1.2570000e+000  1.5250000e+000  1.7520000e+000  1.9520000e+000  2.1330000e+000  2.3030000e+000  2.4640000e+000  2.6200000e+000  2.7750000e+000  2.9310000e+000  3.0880000e+000  3.2440000e+000  3.4010000e+000  3.5570000e+000  3.7130000e+000  3.8700000e+000  4.0260000e+000  4.1830000e+000  4.3390000e+000  4.4950000e+000  4.6520000e+000  4.8110000e+000  4.9710000e+000  5.1320000e+000  5.2920000e+000  5.4530000e+000  5.6130000e+000  5.7740000e+000  5.9340000e+000  6.0950000e+000  6.2550000e+000  6.4160000e+000  6.5760000e+000  6.7370000e+000  6.9290000e+000  7.1580000e+000  7.3870000e+000  7.6170000e+000  7.8460000e+000  8.0760000e+000  8.3050000e+000  8.5350000e+000  8.7640000e+000  8.9940000e+000  9.1650000e+000  9.2260000e+000  9.2110000e+000  9.1960000e+000  9.2920000e+000
  1.4900000e-001  3.7528050e-001  7.3269051e-001  1.0901005e+000  1.4475105e+000  9.4340000e-001  1.2780000e+000  1.5480000e+000  1.7770000e+000  1.9790000e+000  2.1620000e+000  2.3330000e+000  2.4960000e+000  2.6540000e+000  2.8380000e+000  2.9940000e+000  3.1510000e+000  3.3070000e+000  3.4630000e+000  3.6200000e+000  3.7760000e+000  3.9330000e+000  4.0890000e+000  4.2450000e+000  4.4020000e+000  4.5580000e+000  4.7150000e+000  4.9080000e+000  5.0680000e+000  5.2290000e+000  5.3890000e+000  5.5500000e+000  5.7100000e+000  5.8710000e+000  6.0310000e+000  6.1920000e+000  6.3520000e+000  6.5130000e+000  6.6730000e+000  6.8340000e+000  7.0220000e+000  7.2460000e+000  7.4750000e+000  7.7050000e+000  7.9340000e+000  8.1640000e+000  8.3930000e+000  8.6230000e+000  8.8520000e+000  9.0810000e+000  9.2450000e+000  9.3060000e+000  9.2910000e+000  9.2830000e+000  9.3830000e+000
  1.4900000e-001  3.8043478e-001  7.4275362e-001  1.1050725e+000  1.4673913e+000  9.6410000e-001  1.3010000e+000  1.5730000e+000  1.8030000e+000  2.0070000e+000  2.1920000e+000  2.3650000e+000  2.5290000e+000  2.6890000e+000  2.9080000e+000  3.0570000e+000  3.2140000e+000  3.3700000e+000  3.5260000e+000  3.6830000e+000  3.8390000e+000  3.9960000e+000  4.1520000e+000  4.3080000e+000  4.4650000e+000  4.6210000e+000  4.7770000e+000  5.0010000e+000  5.1660000e+000  5.3260000e+000  5.4870000e+000  5.6470000e+000  5.8080000e+000  5.9680000e+000  6.1290000e+000  6.2890000e+000  6.4500000e+000  6.6100000e+000  6.7710000e+000  6.9310000e+000  7.1450000e+000  7.3340000e+000  7.5630000e+000  7.7930000e+000  8.0220000e+000  8.2520000e+000  8.4810000e+000  8.7110000e+000  8.9400000e+000  9.1690000e+000  9.3250000e+000  9.3860000e+000  9.3700000e+000  9.3730000e+000  9.4940000e+000
  1.4900000e-001  3.8558906e-001  7.5281674e-001  1.1200444e+000  1.4872721e+000  9.8590000e-001  1.3250000e+000  1.5980000e+000  1.8310000e+000  2.0360000e+000  2.2230000e+000  2.3980000e+000  2.5640000e+000  2.7480000e+000  2.9820000e+000  3.1220000e+000  3.2760000e+000  3.4330000e+000  3.5890000e+000  3.7460000e+000  3.9020000e+000  4.0580000e+000  4.2150000e+000  4.3710000e+000  4.5280000e+000  4.6840000e+000  4.8410000e+000  5.0940000e+000  5.2620000e+000  5.4240000e+000  5.5840000e+000  5.7450000e+000  5.9050000e+000  6.0660000e+000  6.2260000e+000  6.3870000e+000  6.5470000e+000  6.7080000e+000  6.8680000e+000  7.0280000e+000  7.2680000e+000  7.4320000e+000  7.6510000e+000  7.8810000e+000  8.1100000e+000  8.3400000e+000  8.5690000e+000  8.7990000e+000  9.0280000e+000  9.2570000e+000  9.4050000e+000  9.4660000e+000  9.4500000e+000  9.4640000e+000  9.6070000e+000
  1.4900000e-001  3.9074334e-001  7.6287985e-001  1.1350164e+000  1.5071529e+000  1.0090000e+000  1.3490000e+000  1.6250000e+000  1.8590000e+000  2.0670000e+000  2.2550000e+000  2.4320000e+000  2.6010000e+000  2.7960000e+000  3.0340000e+000  3.1950000e+000  3.3390000e+000  3.4960000e+000  3.6520000e+000  3.8080000e+000  3.9650000e+000  4.1210000e+000  4.2780000e+000  4.4340000e+000  4.5900000e+000  4.7470000e+000  4.9150000e+000  5.1700000e+000  5.3550000e+000  5.5210000e+000  5.6810000e+000  5.8420000e+000  6.0020000e+000  6.1630000e+000  6.3230000e+000  6.4840000e+000  6.6440000e+000  6.8050000e+000  6.9650000e+000  7.1400000e+000  7.3820000e+000  7.5550000e+000  7.7390000e+000  7.9690000e+000  8.1980000e+000  8.4280000e+000  8.6570000e+000  8.8870000e+000  9.1160000e+000  9.3450000e+000  9.4850000e+000  9.5460000e+000  9.5290000e+000  9.5540000e+000  9.7220000e+000
  1.4900000e-001  3.9589762e-001  7.7294296e-001  1.1499883e+000  1.5270337e+000  1.0330000e+000  1.3760000e+000  1.6530000e+000  1.8890000e+000  2.0980000e+000  2.2890000e+000  2.4680000e+000  2.6380000e+000  2.8430000e+000  3.0810000e+000  3.2690000e+000  3.4090000e+000  3.5580000e+000  3.7150000e+000  3.8710000e+000  4.0280000e+000  4.1840000e+000  4.3400000e+000  4.4970000e+000  4.6530000e+000  4.8100000e+000  4.9890000e+000  5.2440000e+000  5.4480000e+000  5.6160000e+000  5.7790000e+000  5.9390000e+000  6.1000000e+000  6.2600000e+000  6.4210000e+000  6.5810000e+000  6.7420000e+000  6.9020000e+000  7.0630000e+000  7.2550000e+000  7.4940000e+000  7.6790000e+000  7.8430000e+000  8.0570000e+000  8.2860000e+000  8.5160000e+000  8.7450000e+000  8.9750000e+000  9.2040000e+000  9.4330000e+000  9.5640000e+000  9.6250000e+000  9.6080000e+000  9.6450000e+000  9.8400000e+000
  1.4900000e-001  4.0105189e-001  7.8300608e-001  1.1649603e+000  1.5469144e+000  1.0580000e+000  1.4030000e+000  1.6820000e+000  1.9200000e+000  2.1310000e+000  2.3240000e+000  2.5040000e+000  2.6770000e+000  2.8900000e+000  3.1280000e+000  3.3430000e+000  3.4830000e+000  3.6220000e+000  3.7780000e+000  3.9340000e+000  4.0900000e+000  4.2470000e+000  4.4030000e+000  4.5600000e+000  4.7160000e+000  4.8720000e+000  5.0630000e+000  5.3180000e+000  5.5400000e+000  5.7090000e+000  5.8760000e+000  6.0370000e+000  6.1970000e+000  6.3580000e+000  6.5180000e+000  6.6790000e+000  6.8390000e+000  7.0000000e+000  7.1600000e+000  7.3700000e+000  7.6060000e+000  7.8020000e+000  7.9660000e+000  8.1450000e+000  8.3740000e+000  8.6040000e+000  8.8330000e+000  9.0630000e+000  9.2920000e+000  9.5210000e+000  9.6440000e+000  9.7050000e+000  9.6880000e+000  9.7910000e+000  9.9600000e+000
  1.4900000e-001  4.0620617e-001  7.9306919e-001  1.1799322e+000  1.5667952e+000  1.0850000e+000  1.4310000e+000  1.7130000e+000  1.9530000e+000  2.1650000e+000  2.3600000e+000  2.5430000e+000  2.7170000e+000  2.9370000e+000  3.1750000e+000  3.4130000e+000  3.5570000e+000  3.6960000e+000  3.8400000e+000  3.9970000e+000  4.1530000e+000  4.3100000e+000  4.4660000e+000  4.6220000e+000  4.7790000e+000  4.9350000e+000  5.1370000e+000  5.3920000e+000  5.6330000e+000  5.8010000e+000  5.9690000e+000  6.1340000e+000  6.2940000e+000  6.4550000e+000  6.6150000e+000  6.7760000e+000  6.9360000e+000  7.0970000e+000  7.2570000e+000  7.4850000e+000  7.7170000e+000  7.9250000e+000  8.0890000e+000  8.2540000e+000  8.4620000e+000  8.6920000e+000  8.9210000e+000  9.1510000e+000  9.3800000e+000  9.6090000e+000  9.7240000e+000  9.7850000e+000  9.7700000e+000  9.9110000e+000  1.0080000e+001
  1.4900000e-001  4.1136045e-001  8.0313230e-001  1.1949042e+000  1.5866760e+000  1.1120000e+000  1.4600000e+000  1.7440000e+000  1.9860000e+000  2.2010000e+000  2.3970000e+000  2.5820000e+000  2.7580000e+000  2.9840000e+000  3.2220000e+000  3.4600000e+000  3.6300000e+000  3.7700000e+000  3.9100000e+000  4.0600000e+000  4.2160000e+000  4.3720000e+000  4.5290000e+000  4.6850000e+000  4.8420000e+000  4.9980000e+000  5.2110000e+000  5.4660000e+000  5.7210000e+000  5.8940000e+000  6.0620000e+000  6.2300000e+000  6.3920000e+000  6.5520000e+000  6.7130000e+000  6.8730000e+000  7.0340000e+000  7.1940000e+000  7.3550000e+000  7.5990000e+000  7.8290000e+000  8.0480000e+000  8.2120000e+000  8.3770000e+000  8.5500000e+000  8.7800000e+000  9.0090000e+000  9.2390000e+000  9.4680000e+000  9.6970000e+000  9.8040000e+000  9.8650000e+000  9.8580000e+000  1.0030000e+001  1.0210000e+001
  1.4900000e-001  4.1626928e-001  8.1271622e-001  1.2091632e+000  1.6056101e+000  1.1400000e+000  1.4910000e+000  1.7760000e+000  2.0200000e+000  2.2370000e+000  2.4360000e+000  2.6220000e+000  2.8000000e+000  3.0310000e+000  3.2690000e+000  3.5070000e+000  3.7040000e+000  3.8440000e+000  3.9830000e+000  4.1230000e+000  4.2790000e+000  4.4350000e+000  4.5920000e+000  4.7480000e+000  4.9040000e+000  5.0610000e+000  5.2850000e+000  5.5400000e+000  5.7950000e+000  5.9870000e+000  6.1550000e+000  6.3230000e+000  6.4890000e+000  6.6500000e+000  6.8100000e+000  6.9710000e+000  7.1310000e+000  7.2920000e+000  7.4520000e+000  7.7140000e+000  7.9420000e+000  8.1710000e+000  8.3350000e+000  8.5000000e+000  8.6650000e+000  8.8680000e+000  9.0970000e+000  9.3270000e+000  9.5560000e+000  9.7850000e+000  9.8840000e+000  9.9450000e+000  9.9460000e+000  1.0160000e+001  1.0330000e+001
  1.4900000e-001  4.2142356e-001  8.2277934e-001  1.2241351e+000  1.6254909e+000  1.1700000e+000  1.5220000e+000  1.8090000e+000  2.0550000e+000  2.2740000e+000  2.4750000e+000  2.6630000e+000  2.8440000e+000  3.0780000e+000  3.3160000e+000  3.5540000e+000  3.7780000e+000  3.9180000e+000  4.0570000e+000  4.1970000e+000  4.3420000e+000  4.4980000e+000  4.6540000e+000  4.8110000e+000  4.9670000e+000  5.1240000e+000  5.3590000e+000  5.6140000e+000  5.8690000e+000  6.0790000e+000  6.2480000e+000  6.4160000e+000  6.5840000e+000  6.7470000e+000  6.9070000e+000  7.0680000e+000  7.2280000e+000  7.3890000e+000  7.5650000e+000  7.8290000e+000  8.0560000e+000  8.2940000e+000  8.4580000e+000  8.6230000e+000  8.7880000e+000  8.9560000e+000  9.1850000e+000  9.4150000e+000  9.6440000e+000  9.8730000e+000  9.9630000e+000  1.0020000e+001  1.0110000e+001  1.0280000e+001  1.0460000e+001
  1.4900000e-001  4.2657784e-001  8.3284245e-001  1.2391071e+000  1.6453717e+000  1.2000000e+000  1.5540000e+000  1.8440000e+000  2.0920000e+000  2.3130000e+000  2.5150000e+000  2.7060000e+000  2.8880000e+000  3.1250000e+000  3.3630000e+000  3.6010000e+000  3.8390000e+000  3.9910000e+000  4.1310000e+000  4.2710000e+000  4.4100000e+000  4.5610000e+000  4.7170000e+000  4.8740000e+000  5.0300000e+000  5.1860000e+000  5.4330000e+000  5.6880000e+000  5.9430000e+000  6.1720000e+000  6.3400000e+000  6.5080000e+000  6.6770000e+000  6.8440000e+000  7.0050000e+000  7.1650000e+000  7.3260000e+000  7.4860000e+000  7.6800000e+000  7.9440000e+000  8.1700000e+000  8.4080000e+000  8.5820000e+000  8.7460000e+000  8.9110000e+000  9.0750000e+000  9.2730000e+000  9.5030000e+000  9.7320000e+000  9.9610000e+000  1.0040000e+001  1.0100000e+001  1.0230000e+001  1.0410000e+001  1.0590000e+001
  1.4900000e-001  4.3173212e-001  8.4290556e-001  1.2540790e+000  1.6652525e+000  1.2310000e+000  1.5870000e+000  1.8790000e+000  2.1290000e+000  2.3520000e+000  2.5570000e+000  2.7490000e+000  2.9330000e+000  3.1720000e+000  3.4100000e+000  3.6480000e+000  3.8860000e+000  4.0650000e+000  4.2050000e+000  4.3450000e+000  4.4840000e+000  4.6240000e+000  4.7800000e+000  4.9360000e+000  5.0930000e+000  5.2510000e+000  5.5070000e+000  5.7620000e+000  6.0170000e+000  6.2650000e+000  6.4330000e+000  6.6010000e+000  6.7690000e+000  6.9370000e+000  7.1020000e+000  7.2630000e+000  7.4230000e+000  7.5830000e+000  7.7950000e+000  8.0590000e+000  8.2840000e+000  8.5200000e+000  8.7050000e+000  8.8690000e+000  9.0340000e+000  9.1980000e+000  9.3630000e+000  9.5910000e+000  9.8200000e+000  1.0050000e+001  1.0120000e+001  1.0180000e+001  1.0360000e+001  1.0540000e+001  1.0720000e+001
  1.4900000e-001  4.3688640e-001  8.5296868e-001  1.2690510e+000  1.6851332e+000  1.2620000e+000  1.6210000e+000  1.9140000e+000  2.1670000e+000  2.3920000e+000  2.5990000e+000  2.7930000e+000  2.9800000e+000  3.2190000e+000  3.4570000e+000  3.6950000e+000  3.9330000e+000  4.1390000e+000  4.2790000e+000  4.4180000e+000  4.5580000e+000  4.6980000e+000  4.8430000e+000  4.9990000e+000  5.1560000e+000  5.3250000e+000  5.5800000e+000  5.8360000e+000  6.0910000e+000  6.3460000e+000  6.5260000e+000  6.6940000e+000  6.8620000e+000  7.0300000e+000  7.1980000e+000  7.3600000e+000  7.5200000e+000  7.6810000e+000  7.9100000e+000  8.1740000e+000  8.3990000e+000  8.6320000e+000  8.8280000e+000  8.9920000e+000  9.1570000e+000  9.3210000e+000  9.4860000e+000  9.6790000e+000  9.9080000e+000  1.0140000e+001  1.0200000e+001  1.0260000e+001  1.0490000e+001  1.0670000e+001  1.0860000e+001
  1.4900000e-001  4.4204067e-001  8.6303179e-001  1.2840229e+000  1.7050140e+000  1.2950000e+000  1.6550000e+000  1.9510000e+000  2.2050000e+000  2.4330000e+000  2.6420000e+000  2.8380000e+000  3.0270000e+000  3.2660000e+000  3.5040000e+000  3.7420000e+000  3.9800000e+000  4.2130000e+000  4.3530000e+000  4.4920000e+000  4.6320000e+000  4.7710000e+000  4.9110000e+000  5.0620000e+000  5.2180000e+000  5.3990000e+000  5.6540000e+000  5.9100000e+000  6.1650000e+000  6.4200000e+000  6.6180000e+000  6.7870000e+000  6.9550000e+000  7.1230000e+000  7.2910000e+000  7.4570000e+000  7.6180000e+000  7.7780000e+000  8.0250000e+000  8.2890000e+000  8.5130000e+000  8.7430000e+000  8.9510000e+000  9.1150000e+000  9.2800000e+000  9.4440000e+000  9.6090000e+000  9.7740000e+000  9.9960000e+000  1.0220000e+001  1.0280000e+001  1.0370000e+001  1.0620000e+001  1.0810000e+001  1.0990000e+001
  1.4900000e-001  4.4719495e-001  8.7309490e-001  1.2989949e+000  1.7248948e+000  1.3280000e+000  1.6900000e+000  1.9880000e+000  2.2450000e+000  2.4740000e+000  2.6850000e+000  2.8840000e+000  3.0750000e+000  3.3130000e+000  3.5510000e+000  3.7890000e+000  4.0270000e+000  4.2650000e+000  4.4260000e+000  4.5660000e+000  4.7060000e+000  4.8450000e+000  4.9850000e+000  5.1250000e+000  5.2810000e+000  5.4730000e+000  5.7280000e+000  5.9830000e+000  6.2390000e+000  6.4940000e+000  6.7110000e+000  6.8790000e+000  7.0470000e+000  7.2160000e+000  7.3840000e+000  7.5520000e+000  7.7150000e+000  7.8760000e+000  8.1400000e+000  8.4040000e+000  8.6270000e+000  8.8550000e+000  9.0740000e+000  9.2380000e+000  9.4030000e+000  9.5680000e+000  9.7320000e+000  9.8970000e+000  1.0080000e+001  1.0300000e+001  1.0360000e+001  1.0560000e+001  1.0750000e+001  1.0940000e+001  1.1130000e+001
  1.4900000e-001  4.5234923e-001  8.8315802e-001  1.3139668e+000  1.7447756e+000  1.3610000e+000  1.7260000e+000  2.0260000e+000  2.2850000e+000  2.5160000e+000  2.7300000e+000  2.9310000e+000  3.1240000e+000  3.3600000e+000  3.5980000e+000  3.8360000e+000  4.0740000e+000  4.3120000e+000  4.5000000e+000  4.6400000e+000  4.7790000e+000  4.9190000e+000  5.0590000e+000  5.1980000e+000  5.3440000e+000  5.5470000e+000  5.8020000e+000  6.0570000e+000  6.3130000e+000  6.5680000e+000  6.8040000e+000  6.9720000e+000  7.1400000e+000  7.3080000e+000  7.4770000e+000  7.6450000e+000  7.8120000e+000  7.9910000e+000  8.2550000e+000  8.5190000e+000  8.7420000e+000  8.9670000e+000  9.1970000e+000  9.3610000e+000  9.5260000e+000  9.6910000e+000  9.8550000e+000  1.0020000e+001  1.0180000e+001  1.0380000e+001  1.0490000e+001  1.0700000e+001  1.0890000e+001  1.1080000e+001  1.1270000e+001
  1.4900000e-001  4.5750351e-001  8.9322113e-001  1.3289388e+000  1.7646564e+000  1.3950000e+000  1.7620000e+000  2.0650000e+000  2.3260000e+000  2.5590000e+000  2.7750000e+000  2.9780000e+000  3.1730000e+000  3.4070000e+000  3.6450000e+000  3.8830000e+000  4.1210000e+000  4.3590000e+000  4.5740000e+000  4.7140000e+000  4.8530000e+000  4.9930000e+000  5.1320000e+000  5.2720000e+000  5.4120000e+000  5.6210000e+000  5.8760000e+000  6.1310000e+000  6.3860000e+000  6.6420000e+000  6.8960000e+000  7.0650000e+000  7.2330000e+000  7.4010000e+000  7.5690000e+000  7.7370000e+000  7.9060000e+000  8.1050000e+000  8.3700000e+000  8.6340000e+000  8.8560000e+000  9.0790000e+000  9.3200000e+000  9.4850000e+000  9.6490000e+000  9.8140000e+000  9.9780000e+000  1.0140000e+001  1.0310000e+001  1.0470000e+001  1.0620000e+001  1.0830000e+001  1.1030000e+001  1.1220000e+001  1.1410000e+001
  1.4900000e-001  4.6265778e-001  9.0328424e-001  1.3439107e+000  1.7845372e+000  1.4300000e+000  1.7990000e+000  2.1040000e+000  2.3670000e+000  2.6030000e+000  2.8200000e+000  3.0260000e+000  3.2230000e+000  3.4540000e+000  3.6920000e+000  3.9300000e+000  4.1680000e+000  4.4060000e+000  4.6440000e+000  4.7870000e+000  4.9270000e+000  5.0670000e+000  5.2060000e+000  5.3460000e+000  5.4860000e+000  5.6950000e+000  5.9500000e+000  6.2050000e+000  6.4600000e+000  6.7160000e+000  6.9710000e+000  7.1570000e+000  7.3260000e+000  7.4940000e+000  7.6620000e+000  7.8300000e+000  7.9980000e+000  8.2200000e+000  8.4850000e+000  8.7490000e+000  8.9700000e+000  9.1910000e+000  9.4340000e+000  9.6080000e+000  9.7720000e+000  9.9370000e+000  1.0100000e+001  1.0270000e+001  1.0430000e+001  1.0600000e+001  1.0750000e+001  1.0970000e+001  1.1170000e+001  1.1360000e+001  1.1550000e+001
  1.4900000e-001  4.6781206e-001  9.1334736e-001  1.3588827e+000  1.8044180e+000  1.4650000e+000  1.8370000e+000  2.1430000e+000  2.4090000e+000  2.6470000e+000  2.8670000e+000  3.0740000e+000  3.2740000e+000  3.5030000e+000  3.7390000e+000  3.9770000e+000  4.2150000e+000  4.4530000e+000  4.6910000e+000  4.8610000e+000  5.0010000e+000  5.1410000e+000  5.2800000e+000  5.4200000e+000  5.5590000e+000  5.7760000e+000  6.0240000e+000  6.2790000e+000  6.5340000e+000  6.7890000e+000  7.0450000e+000  7.2500000e+000  7.4180000e+000  7.5860000e+000  7.7550000e+000  7.9230000e+000  8.0910000e+000  8.3350000e+000  8.5990000e+000  8.8640000e+000  9.0840000e+000  9.3020000e+000  9.5460000e+000  9.7310000e+000  9.8950000e+000  1.0060000e+001  1.0220000e+001  1.0390000e+001  1.0550000e+001  1.0740000e+001  1.0910000e+001  1.1110000e+001  1.1310000e+001  1.1500000e+001  1.1700000e+001
  1.4900000e-001  4.7296634e-001  9.2341047e-001  1.3738546e+000  1.8242987e+000  1.5000000e+000  1.8740000e+000  2.1830000e+000  2.4510000e+000  2.6910000e+000  2.9130000e+000  3.1230000e+000  3.3260000e+000  3.5550000e+000  3.7860000e+000  4.0240000e+000  4.2620000e+000  4.5000000e+000  4.7380000e+000  4.9350000e+000  5.0750000e+000  5.2140000e+000  5.3540000e+000  5.4940000e+000  5.6330000e+000  5.8610000e+000  6.0980000e+000  6.3530000e+000  6.6080000e+000  6.8630000e+000  7.1190000e+000  7.3430000e+000  7.5110000e+000  7.6790000e+000  7.8470000e+000  8.0160000e+000  8.1840000e+000  8.4500000e+000  8.7140000e+000  8.9790000e+000  9.1990000e+000  9.4140000e+000  9.6580000e+000  9.8540000e+000  1.0020000e+001  1.0180000e+001  1.0350000e+001  1.0510000e+001  1.0680000e+001  1.0880000e+001  1.1040000e+001  1.1250000e+001  1.1450000e+001  1.1650000e+001  1.1850000e+001
  1.4900000e-001  4.7812062e-001  9.3347359e-001  1.3888266e+000  1.8441795e+000  1.5360000e+000  1.9120000e+000  2.2230000e+000  2.4930000e+000  2.7360000e+000  2.9600000e+000  3.1730000e+000  3.3780000e+000  3.6080000e+000  3.8370000e+000  4.0710000e+000  4.3090000e+000  4.5470000e+000  4.7850000e+000  5.0090000e+000  5.1490000e+000  5.2880000e+000  5.4280000e+000  5.5670000e+000  5.7100000e+000  5.9450000e+000  6.1810000e+000  6.4270000e+000  6.6820000e+000  6.9370000e+000  7.1920000e+000  7.4350000e+000  7.6040000e+000  7.7720000e+000  7.9400000e+000  8.1080000e+000  8.2780000e+000  8.5650000e+000  8.8290000e+000  9.0930000e+000  9.3130000e+000  9.5260000e+000  9.7700000e+000  9.9770000e+000  1.0140000e+001  1.0310000e+001  1.0470000e+001  1.0640000e+001  1.0800000e+001  1.1010000e+001  1.1180000e+001  1.1390000e+001  1.1590000e+001  1.1790000e+001  1.1990000e+001
  1.4900000e-001  4.8327489e-001  9.4353670e-001  1.4037985e+000  1.8640603e+000  1.5720000e+000  1.9500000e+000  2.2640000e+000  2.5360000e+000  2.7810000e+000  3.0080000e+000  3.2220000e+000  3.4310000e+000  3.6600000e+000  3.8890000e+000  4.1190000e+000  4.3560000e+000  4.5940000e+000  4.8320000e+000  5.0700000e+000  5.2220000e+000  5.3620000e+000  5.5020000e+000  5.6410000e+000  5.7940000e+000  6.0300000e+000  6.2660000e+000  6.5010000e+000  6.7560000e+000  7.0110000e+000  7.2660000e+000  7.5220000e+000  7.6960000e+000  7.8650000e+000  8.0330000e+000  8.2010000e+000  8.3910000e+000  8.6800000e+000  8.9440000e+000  9.2080000e+000  9.4270000e+000  9.6380000e+000  9.8810000e+000  1.0100000e+001  1.0260000e+001  1.0430000e+001  1.0590000e+001  1.0760000e+001  1.0940000e+001  1.1150000e+001  1.1320000e+001  1.1530000e+001  1.1730000e+001  1.1940000e+001  1.2140000e+001
  1.4900000e-001  4.8842917e-001  9.5359981e-001  1.4187705e+000  1.8839411e+000  1.6080000e+000  1.9890000e+000  2.3050000e+000  2.5790000e+000  2.8270000e+000  3.0560000e+000  3.2720000e+000  3.4830000e+000  3.7120000e+000  3.9410000e+000  4.1710000e+000  4.4030000e+000  4.6410000e+000  4.8790000e+000  5.1170000e+000  5.2960000e+000  5.4360000e+000  5.5750000e+000  5.7150000e+000  5.8790000e+000  6.1140000e+000  6.3500000e+000  6.5860000e+000  6.8300000e+000  7.0850000e+000  7.3400000e+000  7.5950000e+000  7.7890000e+000  7.9570000e+000  8.1250000e+000  8.2940000e+000  8.5040000e+000  8.7930000e+000  9.0590000e+000  9.3230000e+000  9.5420000e+000  9.7490000e+000  9.9930000e+000  1.0220000e+001  1.0390000e+001  1.0550000e+001  1.0720000e+001  1.0880000e+001  1.1080000e+001  1.1290000e+001  1.1460000e+001  1.1670000e+001  1.1880000e+001  1.2090000e+001  1.2290000e+001
  1.4900000e-001  4.9358345e-001  9.6366293e-001  1.4337424e+000  1.9038219e+000  1.6450000e+000  2.0280000e+000  2.3460000e+000  2.6230000e+000  2.8720000e+000  3.1040000e+000  3.3230000e+000  3.5350000e+000  3.7640000e+000  3.9940000e+000  4.2230000e+000  4.4520000e+000  4.6880000e+000  4.9260000e+000  5.1640000e+000  5.3700000e+000  5.5100000e+000  5.6490000e+000  5.7890000e+000  5.9630000e+000  6.1990000e+000  6.4350000e+000  6.6700000e+000  6.9060000e+000  7.1590000e+000  7.4140000e+000  7.6690000e+000  7.8820000e+000  8.0500000e+000  8.2180000e+000  8.3860000e+000  8.6170000e+000  8.9060000e+000  9.1740000e+000  9.4380000e+000  9.6560000e+000  9.8610000e+000  1.0100000e+001  1.0350000e+001  1.0510000e+001  1.0680000e+001  1.0840000e+001  1.1000000e+001  1.1220000e+001  1.1390000e+001  1.1600000e+001  1.1810000e+001  1.2030000e+001  1.2230000e+001  1.2440000e+001
  1.4900000e-001  4.9873773e-001  9.7372604e-001  1.4487144e+000  1.9237027e+000  1.6810000e+000  2.0660000e+000  2.3870000e+000  2.6660000e+000  2.9180000e+000  3.1520000e+000  3.3730000e+000  3.5870000e+000  3.8170000e+000  4.0460000e+000  4.2750000e+000  4.5050000e+000  4.7350000e+000  4.9730000e+000  5.2110000e+000  5.4440000e+000  5.5830000e+000  5.7230000e+000  5.8630000e+000  6.0480000e+000  6.2830000e+000  6.5190000e+000  6.7550000e+000  6.9910000e+000  7.2330000e+000  7.4880000e+000  7.7430000e+000  7.9750000e+000  8.1430000e+000  8.3110000e+000  8.4790000e+000  8.7300000e+000  9.0190000e+000  9.2890000e+000  9.5530000e+000  9.7700000e+000  9.9730000e+000  1.0220000e+001  1.0460000e+001  1.0630000e+001  1.0800000e+001  1.0960000e+001  1.1130000e+001  1.1370000e+001  1.1530000e+001  1.1750000e+001  1.1960000e+001  1.2170000e+001  1.2380000e+001  1.2590000e+001
  1.4900000e-001  5.0389201e-001  9.8378915e-001  1.4636863e+000  1.9435835e+000  1.7170000e+000  2.1050000e+000  2.4280000e+000  2.7100000e+000  2.9640000e+000  3.2000000e+000  3.4240000e+000  3.6400000e+000  3.8690000e+000  4.0980000e+000  4.3270000e+000  4.5570000e+000  4.7860000e+000  5.0200000e+000  5.2580000e+000  5.4960000e+000  5.6570000e+000  5.7970000e+000  5.9370000e+000  6.1320000e+000  6.3680000e+000  6.6040000e+000  6.8390000e+000  7.0750000e+000  7.3110000e+000  7.5620000e+000  7.8170000e+000  8.0670000e+000  8.2350000e+000  8.4040000e+000  8.5720000e+000  8.8430000e+000  9.1320000e+000  9.4040000e+000  9.6680000e+000  9.8850000e+000  1.0080000e+001  1.0330000e+001  1.0570000e+001  1.0760000e+001  1.0920000e+001  1.1090000e+001  1.1260000e+001  1.1510000e+001  1.1670000e+001  1.1890000e+001  1.2110000e+001  1.2320000e+001  1.2540000e+001  1.2750000e+001
  1.4900000e-001  5.0880084e-001  9.9337307e-001  1.4779453e+000  1.9625175e+000  1.7540000e+000  2.1440000e+000  2.4690000e+000  2.7530000e+000  3.0100000e+000  3.2490000e+000  3.4750000e+000  3.6920000e+000  3.9210000e+000  4.1500000e+000  4.3800000e+000  4.6090000e+000  4.8380000e+000  5.0680000e+000  5.3050000e+000  5.5430000e+000  5.7310000e+000  5.8710000e+000  6.0100000e+000  6.2170000e+000  6.4520000e+000  6.6880000e+000  6.9240000e+000  7.1600000e+000  7.3950000e+000  7.6360000e+000  7.8910000e+000  8.1460000e+000  8.3280000e+000  8.4960000e+000  8.6670000e+000  8.9560000e+000  9.2450000e+000  9.5190000e+000  9.7830000e+000  9.9990000e+000  1.0200000e+001  1.0440000e+001  1.0680000e+001  1.0880000e+001  1.1040000e+001  1.1210000e+001  1.1390000e+001  1.1650000e+001  1.1810000e+001  1.2040000e+001  1.2250000e+001  1.2470000e+001  1.2690000e+001  1.2900000e+001
  1.4900000e-001  5.1395512e-001  1.0034362e+000  1.4929173e+000  1.9823983e+000  1.7900000e+000  2.1820000e+000  2.5100000e+000  2.7970000e+000  3.0560000e+000  3.2970000e+000  3.5260000e+000  3.7440000e+000  3.9730000e+000  4.2030000e+000  4.4320000e+000  4.6610000e+000  4.8910000e+000  5.1200000e+000  5.3520000e+000  5.5900000e+000  5.8050000e+000  5.9450000e+000  6.0840000e+000  6.3010000e+000  6.5370000e+000  6.7730000e+000  7.0080000e+000  7.2440000e+000  7.4800000e+000  7.7160000e+000  7.9650000e+000  8.2200000e+000  8.4210000e+000  8.5890000e+000  8.7800000e+000  9.0690000e+000  9.3570000e+000  9.6340000e+000  9.8980000e+000  1.0110000e+001  1.0310000e+001  1.0550000e+001  1.0800000e+001  1.1000000e+001  1.1170000e+001  1.1330000e+001  1.1530000e+001  1.1730000e+001  1.1960000e+001  1.2180000e+001  1.2400000e+001  1.2620000e+001  1.2840000e+001  1.3060000e+001
  1.4900000e-001  5.1910940e-001  1.0134993e+000  1.5078892e+000  2.0022791e+000  1.8260000e+000  2.2210000e+000  2.5510000e+000  2.8400000e+000  3.1020000e+000  3.3450000e+000  3.5770000e+000  3.7960000e+000  4.0260000e+000  4.2550000e+000  4.4840000e+000  4.7140000e+000  4.9430000e+000  5.1720000e+000  5.4020000e+000  5.6370000e+000  5.8750000e+000  6.0180000e+000  6.1580000e+000  6.3860000e+000  6.6210000e+000  6.8570000e+000  7.0930000e+000  7.3290000e+000  7.5640000e+000  7.8000000e+000  8.0390000e+000  8.2940000e+000  8.5140000e+000  8.6820000e+000  8.8930000e+000  9.1820000e+000  9.4700000e+000  9.7490000e+000  1.0010000e+001  1.0230000e+001  1.0420000e+001  1.0660000e+001  1.0910000e+001  1.1130000e+001  1.1290000e+001  1.1460000e+001  1.1670000e+001  1.1880000e+001  1.2100000e+001  1.2330000e+001  1.2550000e+001  1.2770000e+001  1.3000000e+001  1.3220000e+001
  1.4900000e-001  5.2426367e-001  1.0235624e+000  1.5228612e+000  2.0221599e+000  1.8620000e+000  2.2590000e+000  2.5920000e+000  2.8830000e+000  3.1480000e+000  3.3940000e+000  3.6270000e+000  3.8490000e+000  4.0780000e+000  4.3070000e+000  4.5360000e+000  4.7660000e+000  4.9950000e+000  5.2240000e+000  5.4540000e+000  5.6840000e+000  5.9220000e+000  6.0920000e+000  6.2350000e+000  6.4700000e+000  6.7060000e+000  6.9420000e+000  7.1770000e+000  7.4130000e+000  7.6490000e+000  7.8850000e+000  8.1200000e+000  8.3680000e+000  8.6060000e+000  8.7740000e+000  9.0060000e+000  9.2950000e+000  9.5830000e+000  9.8640000e+000  1.0130000e+001  1.0340000e+001  1.0540000e+001  1.0780000e+001  1.1020000e+001  1.1250000e+001  1.1410000e+001  1.1590000e+001  1.1810000e+001  1.2020000e+001  1.2250000e+001  1.2480000e+001  1.2700000e+001  1.2930000e+001  1.3150000e+001  1.3370000e+001
  1.4900000e-001  5.2941795e-001  1.0336255e+000  1.5378331e+000  2.0420407e+000  1.8970000e+000  2.2970000e+000  2.6330000e+000  2.9270000e+000  3.1930000e+000  3.4420000e+000  3.6780000e+000  3.9010000e+000  4.1300000e+000  4.3590000e+000  4.5890000e+000  4.8180000e+000  5.0470000e+000  5.2770000e+000  5.5060000e+000  5.7350000e+000  5.9690000e+000  6.1660000e+000  6.3190000e+000  6.5550000e+000  6.7900000e+000  7.0260000e+000  7.2620000e+000  7.4980000e+000  7.7330000e+000  7.9690000e+000  8.2050000e+000  8.4420000e+000  8.6970000e+000  8.8670000e+000  9.1190000e+000  9.4080000e+000  9.6960000e+000  9.9790000e+000  1.0240000e+001  1.0460000e+001  1.0650000e+001  1.0890000e+001  1.1130000e+001  1.1370000e+001  1.1540000e+001  1.1720000e+001  1.1930000e+001  1.2160000e+001  1.2390000e+001  1.2620000e+001  1.2850000e+001  1.3080000e+001  1.3310000e+001  1.3530000e+001
  1.4900000e-001  5.3457223e-001  1.0436886e+000  1.5528050e+000  2.0619215e+000  1.9320000e+000  2.3350000e+000  2.6730000e+000  2.9690000e+000  3.2390000e+000  3.4900000e+000  3.7280000e+000  3.9530000e+000  4.1820000e+000  4.4120000e+000  4.6410000e+000  4.8700000e+000  5.1000000e+000  5.3290000e+000  5.5580000e+000  5.7880000e+000  6.0170000e+000  6.2400000e+000  6.4040000e+000  6.6390000e+000  6.8750000e+000  7.1110000e+000  7.3460000e+000  7.5820000e+000  7.8180000e+000  8.0540000e+000  8.2890000e+000  8.5250000e+000  8.7710000e+000  8.9600000e+000  9.2320000e+000  9.5210000e+000  9.8090000e+000  1.0090000e+001  1.0360000e+001  1.0570000e+001  1.0770000e+001  1.1000000e+001  1.1240000e+001  1.1490000e+001  1.1660000e+001  1.1850000e+001  1.2070000e+001  1.2310000e+001  1.2540000e+001  1.2770000e+001  1.3000000e+001  1.3240000e+001  1.3460000e+001  1.3690000e+001
  1.4900000e-001  5.3972651e-001  1.0537518e+000  1.5677770e+000  2.0818022e+000  1.9670000e+000  2.3720000e+000  2.7130000e+000  3.0120000e+000  3.2840000e+000  3.5370000e+000  3.7780000e+000  4.0050000e+000  4.2350000e+000  4.4640000e+000  4.6930000e+000  4.9230000e+000  5.1520000e+000  5.3810000e+000  5.6110000e+000  5.8400000e+000  6.0690000e+000  6.3010000e+000  6.4880000e+000  6.7240000e+000  6.9590000e+000  7.1950000e+000  7.4310000e+000  7.6670000e+000  7.9020000e+000  8.1380000e+000  8.3740000e+000  8.6100000e+000  8.8450000e+000  9.0570000e+000  9.3450000e+000  9.6340000e+000  9.9220000e+000  1.0210000e+001  1.0470000e+001  1.0680000e+001  1.0880000e+001  1.1110000e+001  1.1350000e+001  1.1600000e+001  1.1790000e+001  1.1990000e+001  1.2210000e+001  1.2450000e+001  1.2690000e+001  1.2920000e+001  1.3160000e+001  1.3390000e+001  1.3620000e+001  1.3850000e+001
  1.4900000e-001  5.4488079e-001  1.0638149e+000  1.5827489e+000  2.1016830e+000  2.0010000e+000  2.4090000e+000  2.7520000e+000  3.0540000e+000  3.3280000e+000  3.5840000e+000  3.8280000e+000  4.0570000e+000  4.2870000e+000  4.5160000e+000  4.7450000e+000  4.9750000e+000  5.2040000e+000  5.4330000e+000  5.6630000e+000  5.8920000e+000  6.1210000e+000  6.3510000e+000  6.5720000e+000  6.8080000e+000  7.0440000e+000  7.2800000e+000  7.5150000e+000  7.7510000e+000  7.9870000e+000  8.2230000e+000  8.4580000e+000  8.6940000e+000  8.9300000e+000  9.1700000e+000  9.4580000e+000  9.7470000e+000  1.0040000e+001  1.0320000e+001  1.0590000e+001  1.0800000e+001  1.0990000e+001  1.1220000e+001  1.1470000e+001  1.1710000e+001  1.1920000e+001  1.2120000e+001  1.2360000e+001  1.2600000e+001  1.2840000e+001  1.3070000e+001  1.3310000e+001  1.3550000e+001  1.3780000e+001  1.4010000e+001
  1.4900000e-001  5.5003506e-001  1.0738780e+000  1.5977209e+000  2.1215638e+000  2.0350000e+000  2.4460000e+000  2.7910000e+000  3.0950000e+000  3.3720000e+000  3.6310000e+000  3.8780000e+000  4.1160000e+000  4.3980000e+000  4.6280000e+000  4.8570000e+000  5.0860000e+000  5.3160000e+000  5.5450000e+000  5.7740000e+000  6.0040000e+000  6.2330000e+000  6.4620000e+000  6.6920000e+000  6.9250000e+000  7.1610000e+000  7.3970000e+000  7.6330000e+000  7.8680000e+000  8.1040000e+000  8.3400000e+000  8.5760000e+000  8.8110000e+000  9.0470000e+000  9.2830000e+000  9.5710000e+000  9.8600000e+000  1.0150000e+001  1.0440000e+001  1.0700000e+001  1.0910000e+001  1.1110000e+001  1.1330000e+001  1.1580000e+001  1.1820000e+001  1.2010000e+001  1.2260000e+001  1.2500000e+001  1.2740000e+001  1.2980000e+001  1.3220000e+001  1.3460000e+001  1.3700000e+001  1.3940000e+001  1.4170000e+001
  1.4900000e-001  5.5518934e-001  1.0839411e+000  1.6126928e+000  2.1414446e+000  2.0680000e+000  2.4810000e+000  2.8300000e+000  3.1370000e+000  3.4160000e+000  3.6770000e+000  3.9270000e+000  4.1680000e+000  4.4030000e+000  4.6360000e+000  4.9990000e+000  5.2280000e+000  5.4570000e+000  5.6860000e+000  5.9160000e+000  6.1450000e+000  6.3740000e+000  6.6040000e+000  6.8330000e+000  7.0620000e+000  7.2950000e+000  7.5310000e+000  7.7660000e+000  8.0020000e+000  8.2380000e+000  8.4730000e+000  8.7090000e+000  8.9450000e+000  9.1810000e+000  9.4160000e+000  9.6840000e+000  9.9730000e+000  1.0260000e+001  1.0550000e+001  1.0820000e+001  1.1030000e+001  1.1220000e+001  1.1450000e+001  1.1690000e+001  1.1930000e+001  1.2110000e+001  1.2400000e+001  1.2640000e+001  1.2890000e+001  1.3130000e+001  1.3380000e+001  1.3620000e+001  1.3860000e+001  1.4100000e+001  1.4340000e+001
  1.4900000e-001  5.6034362e-001  1.0940042e+000  1.6276648e+000  2.1613254e+000  2.1010000e+000  2.5170000e+000  2.8680000e+000  3.1770000e+000  3.4590000e+000  3.7230000e+000  3.9750000e+000  4.2190000e+000  4.4570000e+000  4.6920000e+000  4.9260000e+000  5.1580000e+000  5.5990000e+000  5.8280000e+000  6.0570000e+000  6.2870000e+000  6.5160000e+000  6.7450000e+000  6.9750000e+000  7.2040000e+000  7.4330000e+000  7.6640000e+000  7.9000000e+000  8.1360000e+000  8.3710000e+000  8.6070000e+000  8.8430000e+000  9.0790000e+000  9.3140000e+000  9.5500000e+000  9.7970000e+000  1.0090000e+001  1.0370000e+001  1.0660000e+001  1.0930000e+001  1.1140000e+001  1.1340000e+001  1.1560000e+001  1.1800000e+001  1.2030000e+001  1.2290000e+001  1.2540000e+001  1.2790000e+001  1.3040000e+001  1.3280000e+001  1.3530000e+001  1.3770000e+001  1.4020000e+001  1.4260000e+001  1.4500000e+001
  1.4900000e-001  5.6549790e-001  1.1040673e+000  1.6426367e+000  2.1812062e+000  2.1330000e+000  2.5510000e+000  2.9050000e+000  3.2170000e+000  3.5020000e+000  3.7690000e+000  4.0230000e+000  4.2690000e+000  4.5100000e+000  4.7480000e+000  4.9840000e+000  5.2200000e+000  5.4550000e+000  5.6910000e+000  6.1990000e+000  6.4280000e+000  6.6570000e+000  6.8870000e+000  7.1160000e+000  7.3450000e+000  7.5750000e+000  7.8040000e+000  8.0340000e+000  8.2690000e+000  8.5050000e+000  8.7410000e+000  8.9770000e+000  9.2120000e+000  9.4480000e+000  9.6840000e+000  9.9190000e+000  1.0200000e+001  1.0490000e+001  1.0780000e+001  1.1050000e+001  1.1260000e+001  1.1450000e+001  1.1670000e+001  1.1910000e+001  1.2120000e+001  1.2430000e+001  1.2680000e+001  1.2930000e+001  1.3180000e+001  1.3430000e+001  1.3680000e+001  1.3930000e+001  1.4170000e+001  1.4420000e+001  1.4660000e+001
  1.4900000e-001  5.7065217e-001  1.1141304e+000  1.6576087e+000  2.2010870e+000  2.1640000e+000  2.5850000e+000  2.9410000e+000  3.2560000e+000  3.5440000e+000  3.8130000e+000  4.0700000e+000  4.3190000e+000  4.5630000e+000  4.8040000e+000  5.0430000e+000  5.2810000e+000  5.5190000e+000  5.7570000e+000  5.9970000e+000  6.2370000e+000  6.7990000e+000  7.0280000e+000  7.2570000e+000  7.4870000e+000  7.7160000e+000  7.9450000e+000  8.1750000e+000  8.4040000e+000  8.6390000e+000  8.8750000e+000  9.1100000e+000  9.3460000e+000  9.5820000e+000  9.8170000e+000  1.0050000e+001  1.0310000e+001  1.0600000e+001  1.0890000e+001  1.1160000e+001  1.1370000e+001  1.1570000e+001  1.1780000e+001  1.2030000e+001  1.2310000e+001  1.2570000e+001  1.2820000e+001  1.3080000e+001  1.3330000e+001  1.3580000e+001  1.3830000e+001  1.4080000e+001  1.4330000e+001  1.4580000e+001  1.4820000e+001
  1.4900000e-001  5.7580645e-001  1.1241935e+000  1.6725806e+000  2.2209677e+000  2.1940000e+000  2.6180000e+000  2.9770000e+000  3.2950000e+000  3.5850000e+000  3.8570000e+000  4.1170000e+000  4.3690000e+000  4.6150000e+000  4.8590000e+000  5.1000000e+000  5.3410000e+000  5.5810000e+000  5.8230000e+000  6.0650000e+000  6.3080000e+000  6.5530000e+000  6.7990000e+000  7.3990000e+000  7.6280000e+000  7.8580000e+000  8.0870000e+000  8.3160000e+000  8.5460000e+000  8.7750000e+000  9.0080000e+000  9.2440000e+000  9.4800000e+000  9.7150000e+000  9.9510000e+000  1.0190000e+001  1.0420000e+001  1.0710000e+001  1.1000000e+001  1.1280000e+001  1.1480000e+001  1.1680000e+001  1.1890000e+001  1.2120000e+001  1.2450000e+001  1.2710000e+001  1.2960000e+001  1.3220000e+001  1.3480000e+001  1.3730000e+001  1.3980000e+001  1.4240000e+001  1.4490000e+001  1.4740000e+001  1.4990000e+001
  1.4900000e-001  5.8096073e-001  1.1342567e+000  1.6875526e+000  2.2408485e+000  2.2240000e+000  2.6500000e+000  3.0120000e+000  3.3320000e+000  3.6250000e+000  3.9000000e+000  4.1630000e+000  4.4170000e+000  4.6670000e+000  4.9130000e+000  5.1570000e+000  5.4000000e+000  5.6440000e+000  5.8880000e+000  6.1330000e+000  6.3790000e+000  6.6260000e+000  6.8750000e+000  7.1250000e+000  7.3770000e+000  7.9990000e+000  8.2280000e+000  8.4580000e+000  8.6870000e+000  8.9160000e+000  9.1460000e+000  9.3780000e+000  9.6130000e+000  9.8490000e+000  1.0080000e+001  1.0320000e+001  1.0560000e+001  1.0830000e+001  1.1110000e+001  1.1390000e+001  1.1600000e+001  1.1790000e+001  1.2000000e+001  1.2320000e+001  1.2580000e+001  1.2850000e+001  1.3110000e+001  1.3360000e+001  1.3620000e+001  1.3880000e+001  1.4140000e+001  1.4390000e+001  1.4650000e+001  1.4900000e+001  1.5150000e+001
  1.4900000e-001  5.8611501e-001  1.1443198e+000  1.7025245e+000  2.2607293e+000  2.2520000e+000  2.6820000e+000  3.0460000e+000  3.3690000e+000  3.6650000e+000  3.9430000e+000  4.2080000e+000  4.4650000e+000  4.7170000e+000  4.9660000e+000  5.2130000e+000  5.4590000e+000  5.7060000e+000  5.9520000e+000  6.2000000e+000  6.4490000e+000  6.6990000e+000  6.9500000e+000  7.2030000e+000  7.4580000e+000  7.7130000e+000  7.9710000e+000  8.5990000e+000  8.8290000e+000  9.0580000e+000  9.2870000e+000  9.5160000e+000  9.7470000e+000  9.9830000e+000  1.0220000e+001  1.0450000e+001  1.0690000e+001  1.0940000e+001  1.1230000e+001  1.1510000e+001  1.1710000e+001  1.1910000e+001  1.2120000e+001  1.2460000e+001  1.2720000e+001  1.2980000e+001  1.3250000e+001  1.3510000e+001  1.3770000e+001  1.4030000e+001  1.4290000e+001  1.4550000e+001  1.4810000e+001  1.5060000e+001  1.5310000e+001
  1.4900000e-001  5.9126928e-001  1.1543829e+000  1.7174965e+000  2.2806101e+000  2.2800000e+000  2.7120000e+000  3.0790000e+000  3.4050000e+000  3.7040000e+000  3.9840000e+000  4.2520000e+000  4.5120000e+000  4.7670000e+000  5.0190000e+000  5.2680000e+000  5.5170000e+000  5.7670000e+000  6.0160000e+000  6.2670000e+000  6.5180000e+000  6.7710000e+000  7.0250000e+000  7.2810000e+000  7.5380000e+000  7.7970000e+000  8.0570000e+000  8.3180000e+000  8.5800000e+000  9.1990000e+000  9.4290000e+000  9.6580000e+000  9.8870000e+000  1.0120000e+001  1.0350000e+001  1.0590000e+001  1.0820000e+001  1.1060000e+001  1.1340000e+001  1.1620000e+001  1.1830000e+001  1.2020000e+001  1.2320000e+001  1.2590000e+001  1.2860000e+001  1.3120000e+001  1.3390000e+001  1.3650000e+001  1.3920000e+001  1.4180000e+001  1.4440000e+001  1.4700000e+001  1.4960000e+001  1.5220000e+001  1.5480000e+001
  1.4900000e-001  5.9617812e-001  1.1639668e+000  1.7317555e+000  2.2995442e+000  2.3060000e+000  2.7410000e+000  3.1110000e+000  3.4400000e+000  3.7410000e+000  4.0250000e+000  4.2960000e+000  4.5580000e+000  4.8160000e+000  5.0700000e+000  5.3230000e+000  5.5750000e+000  5.8270000e+000  6.0790000e+000  6.3320000e+000  6.5870000e+000  6.8420000e+000  7.1000000e+000  7.3580000e+000  7.6180000e+000  7.8790000e+000  8.1420000e+000  8.4060000e+000  8.6710000e+000  8.9380000e+000  9.2050000e+000  9.7990000e+000  1.0030000e+001  1.0260000e+001  1.0490000e+001  1.0720000e+001  1.0960000e+001  1.1190000e+001  1.1450000e+001  1.1740000e+001  1.1940000e+001  1.2140000e+001  1.2450000e+001  1.2720000e+001  1.2990000e+001  1.3260000e+001  1.3530000e+001  1.3800000e+001  1.4070000e+001  1.4330000e+001  1.4600000e+001  1.4860000e+001  1.5120000e+001  1.5380000e+001  1.5640000e+001
  1.4900000e-001  6.0133240e-001  1.1740299e+000  1.7467274e+000  2.3194250e+000  2.3320000e+000  2.7690000e+000  3.1420000e+000  3.4740000e+000  3.7780000e+000  4.0640000e+000  4.3380000e+000  4.6040000e+000  4.8640000e+000  5.1210000e+000  5.3770000e+000  5.6320000e+000  5.8860000e+000  6.1410000e+000  6.3970000e+000  6.6550000e+000  6.9130000e+000  7.1730000e+000  7.4350000e+000  7.6970000e+000  7.9620000e+000  8.2270000e+000  8.4940000e+000  8.7620000e+000  9.0310000e+000  9.3010000e+000  9.5730000e+000  9.8440000e+000  1.0400000e+001  1.0630000e+001  1.0860000e+001  1.1090000e+001  1.1330000e+001  1.1570000e+001  1.1850000e+001  1.2060000e+001  1.2310000e+001  1.2580000e+001  1.2860000e+001  1.3130000e+001  1.3400000e+001  1.3670000e+001  1.3940000e+001  1.4210000e+001  1.4480000e+001  1.4750000e+001  1.5020000e+001  1.5280000e+001  1.5550000e+001  1.5810000e+001
  1.4900000e-001  6.0648668e-001  1.1840930e+000  1.7616994e+000  2.3393058e+000  2.3560000e+000  2.7970000e+000  3.1720000e+000  3.5070000e+000  3.8140000e+000  4.1030000e+000  4.3790000e+000  4.6480000e+000  4.9110000e+000  5.1710000e+000  5.4300000e+000  5.6870000e+000  5.9450000e+000  6.2030000e+000  6.4620000e+000  6.7220000e+000  6.9830000e+000  7.2460000e+000  7.5100000e+000  7.7760000e+000  8.0430000e+000  8.3110000e+000  8.5810000e+000  8.8520000e+000  9.1240000e+000  9.3970000e+000  9.6710000e+000  9.9460000e+000  1.0220000e+001  1.0500000e+001  1.0770000e+001  1.1230000e+001  1.1460000e+001  1.1700000e+001  1.1970000e+001  1.2170000e+001  1.2440000e+001  1.2710000e+001  1.2990000e+001  1.3260000e+001  1.3540000e+001  1.3810000e+001  1.4090000e+001  1.4360000e+001  1.4630000e+001  1.4900000e+001  1.5170000e+001  1.5440000e+001  1.5710000e+001  1.5970000e+001
  1.4900000e-001  6.1164095e-001  1.1941561e+000  1.7766713e+000  2.3591865e+000  2.3790000e+000  2.8220000e+000  3.2010000e+000  3.5380000e+000  3.8480000e+000  4.1400000e+000  4.4200000e+000  4.6910000e+000  4.9570000e+000  5.2200000e+000  5.4820000e+000  5.7420000e+000  6.0020000e+000  6.2630000e+000  6.5250000e+000  6.7880000e+000  7.0520000e+000  7.3180000e+000  7.5850000e+000  7.8540000e+000  8.1240000e+000  8.3950000e+000  8.6680000e+000  8.9410000e+000  9.2160000e+000  9.4920000e+000  9.7690000e+000  1.0050000e+001  1.0330000e+001  1.0600000e+001  1.0880000e+001  1.1160000e+001  1.1440000e+001  1.1830000e+001  1.2080000e+001  1.2280000e+001  1.2560000e+001  1.2840000e+001  1.3120000e+001  1.3400000e+001  1.3680000e+001  1.3960000e+001  1.4230000e+001  1.4510000e+001  1.4780000e+001  1.5050000e+001  1.5330000e+001  1.5600000e+001  1.5870000e+001  1.6140000e+001
  1.4900000e-001  6.1679523e-001  1.2042193e+000  1.7916433e+000  2.3790673e+000  2.4010000e+000  2.8470000e+000  3.2290000e+000  3.5690000e+000  3.8820000e+000  4.1760000e+000  4.4590000e+000  4.7330000e+000  5.0020000e+000  5.2680000e+000  5.5320000e+000  5.7960000e+000  6.0590000e+000  6.3230000e+000  6.5880000e+000  6.8530000e+000  7.1210000e+000  7.3890000e+000  7.6590000e+000  7.9310000e+000  8.2030000e+000  8.4780000e+000  8.7530000e+000  9.0300000e+000  9.3080000e+000  9.5870000e+000  9.8660000e+000  1.0150000e+001  1.0430000e+001  1.0710000e+001  1.0990000e+001  1.1270000e+001  1.1560000e+001  1.1840000e+001  1.2120000e+001  1.2410000e+001  1.2690000e+001  1.2970000e+001  1.3250000e+001  1.3540000e+001  1.3820000e+001  1.4100000e+001  1.4380000e+001  1.4650000e+001  1.4930000e+001  1.5210000e+001  1.5480000e+001  1.5760000e+001  1.6030000e+001  1.6300000e+001];


% (g/s), engine out HC emissions indexed vertically by fc_map_spd and
% horizontally by fc_map_trq
fc_hc_map=[0.4424 0.4406 0.4388 0.4371 0.4355 0.4339 0.4324 0.431 0.4296 0.4283 0.427 0.4257 0.4245 0.4234 0.4222 0.4212 0.4201 0.4191 0.4182 0.4172 0.4163 0.4155 0.4146 0.4138 0.413 0.4123 0.4116 0.4109 0.4102 0.4096 0.409 0.4084 0.4078 0.4073 0.4068 0.4063 0.4059 0.4054 0.405 0.4046 0.4042 0.4039 0.4036 0.4033 0.403 0.4027 0.4025 0.4023 0.4021 0.4019 0.4018 0.4017 0.4016 0.4015 0.4014 0.4014 0.4013 0.4013 0.4014 0.4014 0.4015 0.4016 0.4017 0.4018 0.4019 0.4021 0.4023 0.4025 0.4027 0.403 0.4032 0.4035 0.4038 0.4042 0.4045 0.4049 0.4053 0.4057 0.4061 0.4066 0.4071 0.4075 0.4081 0.4086 0.4092 0.4097;
0.1525 0.1507 0.149 0.1473 0.1457 0.1442 0.1427 0.1413 0.1399 0.1386 0.1373 0.1361 0.1349 0.1338 0.1327 0.1316 0.1306 0.1296 0.1287 0.1278 0.1269 0.126 0.1252 0.1244 0.1237 0.1229 0.1222 0.1216 0.1209 0.1203 0.1197 0.1191 0.1186 0.1181 0.1176 0.1171 0.1166 0.1162 0.1158 0.1154 0.1151 0.1147 0.1144 0.1141 0.1138 0.1136 0.1134 0.1132 0.113 0.1128 0.1127 0.1125 0.1124 0.1123 0.1123 0.1122 0.1122 0.1122 0.1122 0.1123 0.1123 0.1124 0.1125 0.1126 0.1128 0.1129 0.1131 0.1133 0.1135 0.1138 0.114 0.1143 0.1146 0.1149 0.1153 0.1156 0.116 0.1164 0.1168 0.1173 0.1177 0.1182 0.1187 0.1192 0.1198 0.1203;
0.1051 0.1033 0.1016 0.09994 0.09836 0.09686 0.09541 0.09401 0.09267 0.09138 0.09013 0.08894 0.08778 0.08667 0.0856 0.08456 0.08356 0.0826 0.08167 0.08078 0.07992 0.07909 0.07829 0.07752 0.07678 0.07606 0.07538 0.07472 0.07408 0.07348 0.07289 0.07234 0.0718 0.07129 0.07081 0.07034 0.0699 0.06948 0.06909 0.06872 0.06836 0.06803 0.06773 0.06744 0.06717 0.06693 0.0667 0.0665 0.06631 0.06615 0.06601 0.06588 0.06578 0.0657 0.06563 0.06559 0.06557 0.06556 0.06558 0.06561 0.06567 0.06574 0.06584 0.06595 0.06609 0.06624 0.06641 0.06661 0.06682 0.06705 0.0673 0.06757 0.06786 0.06817 0.0685 0.06885 0.06922 0.06961 0.07002 0.07044 0.07089 0.07136 0.07185 0.07236 0.07288 0.07343;
0.08237 0.08062 0.07894 0.07733 0.07579 0.07431 0.07289 0.07152 0.0702 0.06894 0.06772 0.06654 0.06541 0.06432 0.06327 0.06226 0.06128 0.06034 0.05943 0.05856 0.05771 0.0569 0.05612 0.05537 0.05464 0.05394 0.05327 0.05263 0.05201 0.05142 0.05085 0.0503 0.04978 0.04928 0.04881 0.04836 0.04793 0.04752 0.04713 0.04677 0.04642 0.0461 0.0458 0.04552 0.04526 0.04501 0.04479 0.04459 0.04441 0.04425 0.04411 0.04399 0.04389 0.04381 0.04374 0.0437 0.04367 0.04367 0.04368 0.04372 0.04377 0.04384 0.04393 0.04404 0.04417 0.04432 0.04448 0.04467 0.04487 0.04509 0.04534 0.0456 0.04588 0.04618 0.0465 0.04684 0.04719 0.04757 0.04796 0.04838 0.04881 0.04927 0.04974 0.05023 0.05074 0.05127;
0.06911 0.06739 0.06574 0.06416 0.06264 0.06119 0.05979 0.05845 0.05716 0.05592 0.05472 0.05357 0.05246 0.0514 0.05037 0.04938 0.04842 0.0475 0.04661 0.04576 0.04494 0.04414 0.04338 0.04264 0.04193 0.04125 0.0406 0.03997 0.03936 0.03878 0.03823 0.0377 0.03719 0.0367 0.03624 0.03579 0.03537 0.03498 0.0346 0.03424 0.03391 0.03359 0.03329 0.03302 0.03276 0.03253 0.03231 0.03212 0.03194 0.03178 0.03164 0.03152 0.03142 0.03134 0.03128 0.03123 0.03121 0.0312 0.03121 0.03124 0.03129 0.03136 0.03145 0.03155 0.03167 0.03182 0.03198 0.03215 0.03235 0.03257 0.0328 0.03305 0.03332 0.03361 0.03392 0.03425 0.03459 0.03495 0.03534 0.03574 0.03616 0.0366 0.03705 0.03753 0.03802 0.03854;
0.06058 0.05889 0.05727 0.05571 0.05423 0.0528 0.05143 0.05011 0.04885 0.04763 0.04646 0.04534 0.04425 0.04321 0.0422 0.04123 0.0403 0.0394 0.03853 0.03769 0.03689 0.03611 0.03537 0.03465 0.03396 0.03329 0.03265 0.03204 0.03145 0.03088 0.03034 0.02982 0.02932 0.02885 0.0284 0.02797 0.02756 0.02717 0.0268 0.02645 0.02612 0.02581 0.02553 0.02526 0.02501 0.02478 0.02457 0.02437 0.0242 0.02404 0.02391 0.02379 0.02369 0.02361 0.02355 0.0235 0.02348 0.02347 0.02348 0.0235 0.02355 0.02361 0.0237 0.0238 0.02391 0.02405 0.0242 0.02437 0.02456 0.02477 0.02499 0.02524 0.0255 0.02578 0.02607 0.02639 0.02672 0.02707 0.02744 0.02783 0.02823 0.02866 0.0291 0.02956 0.03004 0.03053;
0.05477 0.05311 0.05151 0.04999 0.04853 0.04713 0.04579 0.0445 0.04326 0.04207 0.04092 0.03982 0.03876 0.03774 0.03675 0.0358 0.03489 0.03401 0.03316 0.03235 0.03156 0.03081 0.03008 0.02938 0.0287 0.02805 0.02743 0.02683 0.02625 0.0257 0.02517 0.02467 0.02418 0.02372 0.02328 0.02286 0.02246 0.02208 0.02172 0.02138 0.02106 0.02076 0.02047 0.02021 0.01997 0.01974 0.01954 0.01935 0.01918 0.01903 0.01889 0.01878 0.01868 0.0186 0.01853 0.01849 0.01846 0.01845 0.01846 0.01849 0.01853 0.01859 0.01867 0.01876 0.01887 0.019 0.01915 0.01931 0.01949 0.01969 0.01991 0.02014 0.02039 0.02066 0.02095 0.02125 0.02157 0.02191 0.02227 0.02264 0.02303 0.02344 0.02387 0.02431 0.02477 0.02525;
0.05065 0.04902 0.04745 0.04596 0.04453 0.04316 0.04184 0.04057 0.03936 0.03819 0.03707 0.03599 0.03496 0.03396 0.033 0.03207 0.03118 0.03032 0.02949 0.02869 0.02793 0.02719 0.02648 0.02579 0.02514 0.0245 0.02389 0.02331 0.02275 0.02221 0.0217 0.0212 0.02073 0.02028 0.01985 0.01944 0.01905 0.01868 0.01833 0.018 0.01769 0.01739 0.01712 0.01686 0.01662 0.0164 0.0162 0.01602 0.01585 0.0157 0.01557 0.01545 0.01536 0.01528 0.01521 0.01517 0.01514 0.01513 0.01514 0.01516 0.0152 0.01525 0.01533 0.01542 0.01552 0.01565 0.01579 0.01594 0.01612 0.01631 0.01652 0.01674 0.01698 0.01724 0.01752 0.01781 0.01812 0.01844 0.01878 0.01914 0.01952 0.01992 0.02033 0.02075 0.0212 0.02166;
0.04764 0.04604 0.0445 0.04304 0.04163 0.04029 0.039 0.03776 0.03657 0.03543 0.03433 0.03328 0.03226 0.03129 0.03035 0.02944 0.02857 0.02773 0.02693 0.02615 0.0254 0.02468 0.02399 0.02332 0.02268 0.02206 0.02147 0.0209 0.02035 0.01983 0.01933 0.01885 0.01839 0.01795 0.01753 0.01713 0.01675 0.01639 0.01605 0.01573 0.01542 0.01513 0.01487 0.01462 0.01438 0.01417 0.01397 0.01379 0.01363 0.01348 0.01335 0.01324 0.01314 0.01306 0.013 0.01296 0.01293 0.01291 0.01292 0.01294 0.01297 0.01303 0.0131 0.01318 0.01328 0.0134 0.01353 0.01368 0.01385 0.01403 0.01423 0.01445 0.01468 0.01493 0.01519 0.01547 0.01577 0.01608 0.01641 0.01676 0.01712 0.0175 0.01789 0.01831 0.01873 0.01918;
0.04538 0.0438 0.0423 0.04086 0.03949 0.03817 0.0369 0.03569 0.03453 0.03341 0.03234 0.03131 0.03032 0.02936 0.02845 0.02756 0.02672 0.0259 0.02511 0.02435 0.02362 0.02292 0.02225 0.0216 0.02097 0.02037 0.01979 0.01924 0.01871 0.0182 0.01771 0.01724 0.01679 0.01637 0.01596 0.01557 0.0152 0.01485 0.01452 0.0142 0.01391 0.01363 0.01337 0.01312 0.01289 0.01269 0.01249 0.01232 0.01216 0.01201 0.01189 0.01177 0.01168 0.0116 0.01154 0.01149 0.01146 0.01145 0.01145 0.01147 0.0115 0.01155 0.01161 0.01169 0.01179 0.0119 0.01203 0.01217 0.01233 0.01251 0.0127 0.0129 0.01312 0.01336 0.01361 0.01388 0.01417 0.01447 0.01478 0.01512 0.01547 0.01583 0.01621 0.01661 0.01702 0.01745;
0.04364 0.04209 0.04062 0.03921 0.03786 0.03657 0.03533 0.03414 0.03301 0.03192 0.03087 0.02986 0.02889 0.02796 0.02707 0.02621 0.02538 0.02458 0.02381 0.02308 0.02237 0.02168 0.02102 0.02039 0.01978 0.0192 0.01864 0.0181 0.01758 0.01709 0.01661 0.01616 0.01572 0.0153 0.01491 0.01453 0.01417 0.01383 0.0135 0.0132 0.01291 0.01264 0.01238 0.01215 0.01193 0.01172 0.01153 0.01136 0.0112 0.01106 0.01094 0.01083 0.01074 0.01066 0.0106 0.01055 0.01052 0.0105 0.0105 0.01052 0.01055 0.01059 0.01065 0.01073 0.01082 0.01092 0.01104 0.01118 0.01133 0.0115 0.01168 0.01188 0.01209 0.01231 0.01256 0.01281 0.01309 0.01337 0.01368 0.014 0.01433 0.01468 0.01505 0.01543 0.01582 0.01623;
0.04226 0.04074 0.0393 0.03791 0.03659 0.03533 0.03412 0.03296 0.03185 0.03078 0.02976 0.02878 0.02783 0.02692 0.02605 0.02521 0.0244 0.02363 0.02288 0.02216 0.02147 0.02081 0.02017 0.01955 0.01896 0.01839 0.01785 0.01732 0.01682 0.01634 0.01587 0.01543 0.01501 0.01461 0.01422 0.01385 0.0135 0.01317 0.01286 0.01256 0.01228 0.01201 0.01177 0.01153 0.01132 0.01112 0.01094 0.01077 0.01061 0.01048 0.01035 0.01025 0.01016 0.01008 0.01002 0.009969 0.009937 0.009919 0.009917 0.009929 0.009955 0.009997 0.01005 0.01012 0.01021 0.01031 0.01042 0.01055 0.01069 0.01085 0.01103 0.01121 0.01142 0.01163 0.01186 0.01211 0.01237 0.01265 0.01294 0.01324 0.01356 0.0139 0.01424 0.01461 0.01499 0.01538;
0.04114 0.03965 0.03823 0.03688 0.03559 0.03435 0.03317 0.03203 0.03095 0.02991 0.02891 0.02795 0.02703 0.02614 0.02529 0.02447 0.02369 0.02293 0.0222 0.02151 0.02083 0.02019 0.01956 0.01897 0.01839 0.01784 0.01731 0.0168 0.01631 0.01584 0.0154 0.01497 0.01456 0.01416 0.01379 0.01343 0.01309 0.01277 0.01246 0.01218 0.0119 0.01165 0.0114 0.01118 0.01097 0.01077 0.0106 0.01043 0.01028 0.01015 0.01003 0.009922 0.009831 0.009755 0.009693 0.009645 0.009612 0.009937 0.01003 0.01013 0.01022 0.01032 0.01041 0.01051 0.0106 0.0107 0.01079 0.01089 0.01098 0.01108 0.01118 0.01127 0.011 0.01121 0.01143 0.01166 0.01191 0.01217 0.01245 0.01274 0.01305 0.01337 0.0137 0.01405 0.01441 0.01479;
0.0402 0.03874 0.03735 0.03602 0.03476 0.03355 0.03239 0.03129 0.03023 0.02921 0.02823 0.0273 0.0264 0.02554 0.02471 0.02392 0.02315 0.02241 0.02171 0.02103 0.02037 0.01975 0.01914 0.01856 0.018 0.01747 0.01695 0.01646 0.01599 0.01553 0.0151 0.01468 0.01428 0.0139 0.01354 0.01319 0.01286 0.01255 0.01225 0.01197 0.01182 0.01169 0.01155 0.01142 0.01129 0.01116 0.01103 0.0109 0.01076 0.01063 0.0105 0.01037 0.01024 0.01011 0.009974 0.009842 0.009806 0.009901 0.009997 0.01009 0.01019 0.01028 0.01038 0.01047 0.01057 0.01066 0.01076 0.01085 0.01095 0.01104 0.01114 0.01124 0.01116 0.01096 0.01117 0.01139 0.01163 0.01188 0.01214 0.01242 0.01271 0.01302 0.01334 0.01367 0.01402 0.01438;
0.03938 0.03795 0.03659 0.0353 0.03406 0.03288 0.03175 0.03066 0.02963 0.02864 0.02769 0.02678 0.0259 0.02506 0.02426 0.02348 0.02274 0.02202 0.02134 0.02068 0.02004 0.01943 0.01885 0.01828 0.01774 0.01722 0.01672 0.01624 0.01578 0.01534 0.01492 0.01452 0.01413 0.01376 0.01341 0.01308 0.01276 0.01233 0.01222 0.01217 0.01214 0.01203 0.0119 0.01176 0.01163 0.0115 0.01137 0.01124 0.01111 0.01097 0.01084 0.01071 0.01058 0.01045 0.01032 0.01018 0.01005 0.00992 0.009961 0.01006 0.01015 0.01025 0.01034 0.01044 0.01053 0.01063 0.01072 0.01082 0.01091 0.01101 0.0111 0.0112 0.01113 0.01084 0.01104 0.01125 0.01147 0.01171 0.01196 0.01223 0.0125 0.01279 0.0131 0.01341 0.01374 0.01409;
0.03865 0.03725 0.03592 0.03465 0.03344 0.03229 0.03118 0.03013 0.02912 0.02815 0.02723 0.02634 0.02549 0.02467 0.02389 0.02313 0.02241 0.02172 0.02105 0.02041 0.01979 0.0192 0.01863 0.01809 0.01756 0.01706 0.01658 0.01611 0.01567 0.01524 0.01483 0.01444 0.01407 0.01371 0.01337 0.01305 0.01226 0.01242 0.01231 0.01219 0.01209 0.01207 0.01204 0.01202 0.01197 0.01184 0.01171 0.01158 0.01145 0.01132 0.01118 0.01105 0.01092 0.01079 0.01066 0.01053 0.01039 0.01026 0.01013 0.01002 0.01012 0.01021 0.01031 0.0104 0.0105 0.01059 0.01069 0.01078 0.01088 0.01097 0.01107 0.01116 0.01109 0.01093 0.01099 0.01119 0.0114 0.01163 0.01187 0.01212 0.01238 0.01266 0.01294 0.01324 0.01356 0.01388;
0.03797 0.0366 0.0353 0.03406 0.03288 0.03175 0.03068 0.02965 0.02866 0.02772 0.02682 0.02596 0.02513 0.02434 0.02357 0.02284 0.02214 0.02147 0.02082 0.0202 0.0196 0.01903 0.01848 0.01795 0.01744 0.01696 0.01649 0.01604 0.01561 0.0152 0.0148 0.01442 0.01406 0.01372 0.01339 0.01219 0.01235 0.01251 0.01239 0.01228 0.01216 0.01205 0.01199 0.01197 0.01194 0.01192 0.01189 0.01187 0.01179 0.01166 0.01153 0.01139 0.01126 0.01113 0.011 0.01087 0.01074 0.0106 0.01047 0.01034 0.01021 0.01018 0.01027 0.01037 0.01046 0.01056 0.01065 0.01075 0.01084 0.01094 0.01103 0.01113 0.01106 0.0109 0.011 0.01119 0.01139 0.0116 0.01183 0.01206 0.01231 0.01257 0.01285 0.01313 0.01343 0.01374;
0.03733 0.03599 0.03472 0.03351 0.03235 0.03125 0.0302 0.0292 0.02824 0.02733 0.02645 0.02561 0.0248 0.02403 0.02329 0.02259 0.0219 0.02125 0.02062 0.02002 0.01945 0.01889 0.01836 0.01785 0.01736 0.01688 0.01643 0.016 0.01558 0.01518 0.0148 0.01444 0.01409 0.01375 0.01212 0.01228 0.01244 0.01259 0.01248 0.01237 0.01225 0.01214 0.01202 0.01192 0.01189 0.01187 0.01184 0.01182 0.01179 0.01177 0.01174 0.01172 0.0116 0.01147 0.01134 0.01121 0.01108 0.01095 0.01081 0.01068 0.01055 0.01042 0.01029 0.01033 0.01043 0.01052 0.01062 0.01071 0.01081 0.0109 0.011 0.01109 0.01102 0.01086 0.0107 0.01122 0.01141 0.01161 0.01182 0.01204 0.01228 0.01252 0.01278 0.01305 0.01333 0.01362;
0.03671 0.0354 0.03415 0.03297 0.03184 0.03077 0.02975 0.02877 0.02784 0.02695 0.02609 0.02528 0.0245 0.02375 0.02303 0.02234 0.02169 0.02105 0.02045 0.01986 0.0193 0.01877 0.01825 0.01776 0.01728 0.01683 0.01639 0.01597 0.01557 0.01519 0.01482 0.01447 0.01413 0.01205 0.01221 0.01237 0.01252 0.01268 0.01257 0.01245 0.01234 0.01222 0.01211 0.01199 0.01188 0.01182 0.01179 0.01177 0.01174 0.01172 0.01169 0.01167 0.01164 0.01162 0.01159 0.01155 0.01142 0.01129 0.01115 0.01102 0.01089 0.01076 0.01063 0.0105 0.01039 0.01049 0.01058 0.01068 0.01077 0.01087 0.01096 0.01106 0.01099 0.01083 0.01067 0.01127 0.01145 0.01163 0.01183 0.01204 0.01226 0.01249 0.01274 0.01299 0.01325 0.01353;
0.03609 0.03481 0.03359 0.03244 0.03134 0.03029 0.0293 0.02835 0.02744 0.02657 0.02574 0.02495 0.02419 0.02347 0.02277 0.02211 0.02147 0.02086 0.02027 0.01971 0.01917 0.01865 0.01815 0.01768 0.01722 0.01678 0.01636 0.01596 0.01557 0.0152 0.01484 0.0145 0.01198 0.01214 0.0123 0.01245 0.01261 0.01277 0.01266 0.01254 0.01243 0.01231 0.0122 0.01208 0.01197 0.01185 0.01174 0.01172 0.01169 0.01167 0.01164 0.01162 0.01159 0.01157 0.01154 0.01152 0.01149 0.01147 0.01144 0.01136 0.01123 0.0111 0.01097 0.01084 0.01071 0.01057 0.01055 0.01064 0.01074 0.01083 0.01093 0.01102 0.01095 0.01079 0.01063 0.01048 0.01149 0.01166 0.01185 0.01204 0.01225 0.01247 0.01269 0.01293 0.01318 0.01344;
0.03547 0.03421 0.03303 0.0319 0.03083 0.02981 0.02884 0.02792 0.02704 0.02619 0.02539 0.02462 0.02389 0.02319 0.02251 0.02187 0.02125 0.02066 0.02009 0.01955 0.01903 0.01853 0.01805 0.01759 0.01715 0.01673 0.01632 0.01593 0.01556 0.01521 0.01486 0.01191 0.01207 0.01223 0.01238 0.01254 0.0127 0.01286 0.01274 0.01263 0.01251 0.0124 0.01228 0.01217 0.01205 0.01194 0.01182 0.01171 0.01164 0.01162 0.01159 0.01157 0.01154 0.01152 0.01149 0.01147 0.01144 0.01142 0.01139 0.01137 0.01134 0.01132 0.01129 0.01118 0.01105 0.01092 0.01078 0.01065 0.0107 0.0108 0.01089 0.01099 0.01092 0.01076 0.0106 0.01044 0.01153 0.01169 0.01186 0.01204 0.01224 0.01244 0.01265 0.01287 0.0131 0.01334;
0.03483 0.03361 0.03245 0.03136 0.03031 0.02932 0.02838 0.02748 0.02662 0.02581 0.02503 0.02428 0.02357 0.02289 0.02224 0.02162 0.02102 0.02045 0.01991 0.01938 0.01888 0.0184 0.01794 0.0175 0.01707 0.01667 0.01628 0.0159 0.01554 0.0152 0.01184 0.012 0.01216 0.01231 0.01247 0.01263 0.01279 0.01294 0.01283 0.01271 0.0126 0.01248 0.01237 0.01225 0.01214 0.01202 0.01191 0.01179 0.01168 0.01156 0.01154 0.01151 0.01149 0.01146 0.01144 0.01142 0.01139 0.01137 0.01134 0.01132 0.01129 0.01127 0.01124 0.01122 0.01119 0.01117 0.01113 0.01099 0.01086 0.01076 0.01086 0.01095 0.01088 0.01072 0.01056 0.01041 0.01025 0.01171 0.01186 0.01203 0.01221 0.0124 0.01259 0.0128 0.01301 0.01324;
0.03419 0.03299 0.03186 0.03079 0.02978 0.02882 0.0279 0.02703 0.0262 0.0254 0.02465 0.02393 0.02324 0.02258 0.02196 0.02136 0.02078 0.02023 0.0197 0.0192 0.01872 0.01825 0.01781 0.01739 0.01698 0.01659 0.01621 0.01586 0.01551 0.01177 0.01193 0.01209 0.01225 0.0124 0.01256 0.01272 0.01287 0.01303 0.01292 0.0128 0.01269 0.01257 0.01246 0.01234 0.01223 0.01211 0.012 0.01188 0.01177 0.01165 0.01154 0.01146 0.01144 0.01141 0.01139 0.01136 0.01134 0.01131 0.01129 0.01126 0.01124 0.01121 0.01119 0.01117 0.01114 0.01112 0.01109 0.01107 0.01104 0.01102 0.01094 0.01092 0.01084 0.01069 0.01053 0.01037 0.01021 0.01171 0.01185 0.01201 0.01217 0.01234 0.01252 0.01271 0.01291 0.01312;
0.03352 0.03236 0.03126 0.03022 0.02923 0.02829 0.0274 0.02656 0.02575 0.02498 0.02425 0.02356 0.02289 0.02226 0.02165 0.02107 0.02052 0.01999 0.01948 0.019 0.01854 0.01809 0.01766 0.01726 0.01687 0.01649 0.01613 0.01579 0.0117 0.01186 0.01202 0.01218 0.01233 0.01249 0.01265 0.0128 0.01296 0.01312 0.013 0.01289 0.01277 0.01266 0.01254 0.01243 0.01231 0.0122 0.01208 0.01197 0.01185 0.01174 0.01162 0.01151 0.01139 0.01136 0.01134 0.01131 0.01129 0.01126 0.01124 0.01121 0.01119 0.01116 0.01114 0.01111 0.01109 0.01106 0.01104 0.01101 0.01099 0.01096 0.01093 0.01091 0.01081 0.01065 0.01049 0.01034 0.01018 0.01002 0.01182 0.01196 0.01211 0.01227 0.01243 0.01261 0.01279 0.01298;
0.03283 0.0317 0.03063 0.02962 0.02866 0.02775 0.02688 0.02606 0.02529 0.02454 0.02384 0.02317 0.02252 0.02191 0.02133 0.02077 0.02024 0.01973 0.01924 0.01878 0.01833 0.01791 0.0175 0.01711 0.01673 0.01638 0.01603 0.01164 0.01179 0.01195 0.01211 0.01226 0.01242 0.01258 0.01273 0.01289 0.01305 0.0132 0.01309 0.01298 0.01286 0.01275 0.01263 0.01252 0.0124 0.01229 0.01217 0.01206 0.01194 0.01182 0.01171 0.01159 0.01148 0.01136 0.01129 0.01126 0.01124 0.01121 0.01119 0.01116 0.01113 0.01111 0.01108 0.01105 0.01103 0.011 0.01097 0.01095 0.01092 0.01089 0.01087 0.01084 0.01075 0.01062 0.01046 0.0103 0.01014 0.009984 0.01177 0.0119 0.01203 0.01218 0.01233 0.01248 0.01265 0.01282;
0.03213 0.03102 0.02998 0.029 0.02807 0.02718 0.02635 0.02555 0.0248 0.02408 0.0234 0.02275 0.02213 0.02155 0.02098 0.02045 0.01994 0.01945 0.01898 0.01854 0.01811 0.0177 0.01731 0.01694 0.01658 0.01624 0.01157 0.01172 0.01188 0.01204 0.01219 0.01235 0.01251 0.01266 0.01282 0.01298 0.01313 0.01329 0.01318 0.01306 0.01295 0.01283 0.01272 0.0126 0.01249 0.01237 0.01226 0.01214 0.01203 0.01191 0.0118 0.01168 0.01157 0.01145 0.01134 0.01123 0.01118 0.01115 0.01112 0.01109 0.01107 0.01104 0.01101 0.01099 0.01096 0.01093 0.01091 0.01088 0.01085 0.01083 0.0108 0.01077 0.01069 0.01057 0.01042 0.01026 0.01011 0.009949 0.009791 0.01182 0.01194 0.01206 0.0122 0.01234 0.01249 0.01265;
0.0314 0.03033 0.02931 0.02836 0.02745 0.0266 0.02579 0.02502 0.02429 0.0236 0.02294 0.02232 0.02172 0.02116 0.02062 0.0201 0.01961 0.01915 0.0187 0.01827 0.01787 0.01748 0.0171 0.01675 0.01641 0.0115 0.01165 0.01181 0.01197 0.01212 0.01228 0.01244 0.01259 0.01275 0.01291 0.01306 0.01322 0.01338 0.01326 0.01315 0.01303 0.01292 0.01281 0.01269 0.01258 0.01246 0.01235 0.01223 0.01212 0.01201 0.01189 0.01178 0.01166 0.01155 0.01143 0.01132 0.01121 0.01109 0.01105 0.01103 0.011 0.01097 0.01095 0.01092 0.01089 0.01087 0.01084 0.01081 0.01079 0.01076 0.01073 0.01071 0.01062 0.0105 0.01038 0.01023 0.01007 0.009913 0.009755 0.01171 0.01182 0.01193 0.01205 0.01217 0.01231 0.01245;
0.03065 0.02961 0.02862 0.02769 0.02682 0.02599 0.02521 0.02446 0.02376 0.0231 0.02246 0.02186 0.02129 0.02075 0.02023 0.01974 0.01927 0.01882 0.0184 0.01799 0.0176 0.01723 0.01688 0.01654 0.01143 0.01158 0.01174 0.0119 0.01205 0.01221 0.01237 0.01252 0.01268 0.01284 0.01299 0.01315 0.01331 0.01332 0.01321 0.01316 0.01312 0.01301 0.0129 0.01279 0.01267 0.01256 0.01244 0.01233 0.01221 0.0121 0.01199 0.01187 0.01176 0.01164 0.01153 0.01141 0.0113 0.01119 0.01107 0.01096 0.01093 0.01091 0.01088 0.01085 0.01083 0.0108 0.01077 0.01075 0.01072 0.01069 0.01067 0.01064 0.01055 0.01043 0.01031 0.01019 0.01004 0.009878 0.00972 0.009562 0.01167 0.01177 0.01188 0.01199 0.0121 0.01222;
0.02988 0.02887 0.02791 0.02701 0.02616 0.02536 0.0246 0.02389 0.02321 0.02257 0.02196 0.02139 0.02084 0.02032 0.01982 0.01935 0.0189 0.01848 0.01807 0.01768 0.01731 0.01696 0.01663 0.01136 0.01151 0.01167 0.01183 0.01198 0.01214 0.0123 0.01245 0.01261 0.01277 0.01292 0.01308 0.01317 0.01318 0.01318 0.01308 0.01297 0.01288 0.01284 0.01279 0.01275 0.01271 0.01265 0.01254 0.01242 0.01231 0.01219 0.01208 0.01197 0.01185 0.01174 0.01162 0.01151 0.01139 0.01128 0.01116 0.01105 0.01094 0.01084 0.01081 0.01079 0.01076 0.01073 0.01071 0.01068 0.01065 0.01063 0.0106 0.01057 0.01048 0.01036 0.01025 0.01013 0.01 0.009843 0.009685 0.009527 0.01151 0.01159 0.01168 0.01178 0.01188 0.01198;
0.02909 0.02811 0.02718 0.02631 0.02549 0.02471 0.02398 0.02329 0.02264 0.02203 0.02144 0.02089 0.02036 0.01987 0.01939 0.01895 0.01852 0.01811 0.01773 0.01736 0.01701 0.01667 0.01129 0.01144 0.0116 0.01176 0.01191 0.01207 0.01223 0.01238 0.01254 0.0127 0.01285 0.01301 0.01303 0.01304 0.01304 0.01305 0.01294 0.01284 0.01273 0.01262 0.01255 0.01251 0.01247 0.01243 0.01239 0.01234 0.0123 0.01226 0.01217 0.01206 0.01194 0.01183 0.01172 0.0116 0.01149 0.01137 0.01126 0.01114 0.01103 0.01092 0.0108 0.01072 0.01069 0.01067 0.01064 0.01061 0.01059 0.01056 0.01053 0.01051 0.01042 0.0103 0.01018 0.01006 0.009939 0.009808 0.00965 0.009492 0.009334 0.0114 0.01147 0.01155 0.01163 0.01172;
0.02828 0.02733 0.02643 0.02559 0.02479 0.02405 0.02334 0.02268 0.02205 0.02146 0.0209 0.02037 0.01987 0.0194 0.01895 0.01852 0.01812 0.01773 0.01736 0.01702 0.01668 0.01122 0.01137 0.01153 0.01169 0.01184 0.012 0.01216 0.01231 0.01247 0.01263 0.01278 0.01288 0.01289 0.01289 0.0129 0.01291 0.01292 0.01281 0.0127 0.0126 0.01249 0.01238 0.01228 0.01223 0.01218 0.01214 0.0121 0.01206 0.01202 0.01198 0.01193 0.01189 0.01185 0.01181 0.0117 0.01158 0.01147 0.01135 0.01124 0.01112 0.01101 0.0109 0.01078 0.01067 0.0106 0.01057 0.01055 0.01052 0.01049 0.01047 0.01044 0.01035 0.01023 0.01011 0.009992 0.009872 0.009753 0.009614 0.009456 0.009298 0.01118 0.01124 0.0113 0.01137 0.01144;
0.02746 0.02653 0.02566 0.02485 0.02408 0.02336 0.02269 0.02205 0.02145 0.02088 0.02035 0.01984 0.01936 0.01891 0.01848 0.01808 0.01769 0.01733 0.01698 0.01665 0.01115 0.0113 0.01146 0.01162 0.01177 0.01193 0.01209 0.01224 0.0124 0.01256 0.01271 0.01274 0.01275 0.01275 0.01276 0.01277 0.01277 0.01278 0.01268 0.01257 0.01246 0.01236 0.01225 0.01214 0.01204 0.01194 0.0119 0.01186 0.01182 0.01178 0.01173 0.01169 0.01165 0.01161 0.01157 0.01153 0.01148 0.01144 0.0114 0.01133 0.01122 0.0111 0.01099 0.01088 0.01076 0.01065 0.01053 0.01048 0.01045 0.01043 0.0104 0.01037 0.01028 0.01016 0.01004 0.009925 0.009805 0.009686 0.009566 0.009421 0.009263 0.009105 0.01099 0.01104 0.01109 0.01114;
0.02662 0.02572 0.02488 0.02409 0.02335 0.02266 0.02201 0.0214 0.02083 0.02029 0.01978 0.01929 0.01884 0.01841 0.018 0.01762 0.01726 0.01691 0.01659 0.01108 0.01123 0.01139 0.01155 0.0117 0.01186 0.01202 0.01217 0.01233 0.01249 0.01259 0.0126 0.01261 0.01261 0.01262 0.01263 0.01263 0.01264 0.01265 0.01254 0.01244 0.01233 0.01222 0.01212 0.01201 0.0119 0.0118 0.01169 0.01162 0.01158 0.01153 0.01149 0.01145 0.01141 0.01137 0.01132 0.01128 0.01124 0.0112 0.01116 0.01112 0.01107 0.01103 0.01099 0.01095 0.01085 0.01074 0.01063 0.01051 0.0104 0.01036 0.01033 0.01031 0.01022 0.0101 0.009978 0.009858 0.009738 0.009619 0.009499 0.00938 0.009228 0.00907 0.01073 0.01076 0.01079 0.01083;
0.02576 0.02489 0.02408 0.02332 0.02261 0.02195 0.02133 0.02074 0.02019 0.01968 0.01919 0.01873 0.0183 0.01789 0.01751 0.01715 0.01681 0.01648 0.01101 0.01116 0.01132 0.01148 0.01163 0.01179 0.01195 0.0121 0.01226 0.01242 0.01245 0.01246 0.01247 0.01247 0.01248 0.01249 0.01249 0.0125 0.01251 0.01251 0.01241 0.0123 0.0122 0.01209 0.01198 0.01187 0.01177 0.01166 0.01155 0.01145 0.01134 0.01129 0.01125 0.01121 0.01117 0.01112 0.01108 0.01104 0.011 0.01096 0.01092 0.01087 0.01083 0.01079 0.01075 0.01071 0.01067 0.01062 0.01058 0.01054 0.01049 0.01038 0.01027 0.01024 0.01015 0.01003 0.009911 0.009791 0.009672 0.009552 0.009432 0.009313 0.009192 0.009034 0.008876 0.01046 0.01048 0.0105;
0.02489 0.02406 0.02327 0.02254 0.02186 0.02122 0.02063 0.02007 0.01954 0.01905 0.01859 0.01816 0.01775 0.01737 0.01701 0.01667 0.01634 0.01094 0.01109 0.01125 0.01141 0.01156 0.01172 0.01188 0.01203 0.01219 0.0123 0.01231 0.01232 0.01232 0.01233 0.01234 0.01235 0.01235 0.01236 0.01237 0.01237 0.01238 0.01227 0.01217 0.01206 0.01195 0.01185 0.01174 0.01163 0.01153 0.01142 0.01131 0.01121 0.0111 0.01101 0.01097 0.01092 0.01088 0.01084 0.0108 0.01076 0.01072 0.01067 0.01063 0.01059 0.01055 0.01051 0.01046 0.01042 0.01038 0.01034 0.0103 0.01026 0.01021 0.01017 0.01013 0.01008 0.009963 0.009844 0.009724 0.009605 0.009485 0.009365 0.009246 0.009126 0.008999 0.008841 0.01016 0.01016 0.01016;
0.02402 0.02321 0.02245 0.02175 0.0211 0.02049 0.01992 0.01938 0.01889 0.01842 0.01798 0.01757 0.01719 0.01683 0.01649 0.01617 0.01087 0.01102 0.01118 0.01134 0.01149 0.01165 0.01181 0.01196 0.01212 0.01216 0.01217 0.01218 0.01218 0.01219 0.0122 0.0122 0.01221 0.01222 0.01223 0.01223 0.01224 0.01225 0.01214 0.01203 0.01193 0.01182 0.01171 0.01161 0.0115 0.01139 0.01129 0.01118 0.01107 0.01097 0.01086 0.01075 0.01068 0.01064 0.0106 0.01056 0.01052 0.01047 0.01043 0.01039 0.01035 0.01031 0.01026 0.01022 0.01018 0.01014 0.01009 0.01005 0.01 0.009958 0.009914 0.009869 0.009825 0.00978 0.009736 0.009657 0.009538 0.009418 0.009299 0.009179 0.009059 0.00894 0.008806 0.009843 0.009827 0.009813;
0.02313 0.02235 0.02163 0.02095 0.02033 0.01974 0.0192 0.01869 0.01822 0.01778 0.01737 0.01698 0.01662 0.01628 0.01597 0.0108 0.01095 0.01111 0.01127 0.01142 0.01158 0.01174 0.01189 0.01202 0.01202 0.01203 0.01204 0.01204 0.01205 0.01206 0.01206 0.01207 0.01208 0.01208 0.01209 0.0121 0.01211 0.01211 0.01201 0.0119 0.01179 0.01169 0.01158 0.01147 0.01137 0.01126 0.01115 0.01105 0.01094 0.01083 0.01073 0.01062 0.01051 0.01041 0.01036 0.01031 0.01027 0.01023 0.01019 0.01014 0.0101 0.01006 0.01001 0.009967 0.009922 0.009878 0.009833 0.009789 0.009744 0.0097 0.009655 0.009611 0.009566 0.009522 0.009478 0.009433 0.009389 0.009344 0.009232 0.009112 0.008992 0.008873 0.008753 0.008613 0.009486 0.009455;
0.02224 0.02149 0.02079 0.02015 0.01955 0.01899 0.01847 0.01799 0.01755 0.01713 0.01674 0.01638 0.01604 0.01573 0.01073 0.01088 0.01104 0.0112 0.01135 0.01151 0.01167 0.01182 0.01188 0.01188 0.01189 0.0119 0.0119 0.01191 0.01192 0.01192 0.01193 0.01194 0.01194 0.01195 0.01196 0.01196 0.01197 0.01198 0.01187 0.01177 0.01166 0.01155 0.01145 0.01134 0.01123 0.01113 0.01102 0.01091 0.01081 0.0107 0.01059 0.01049 0.01038 0.01031 0.01024 0.01017 0.01009 0.01002 0.009952 0.009886 0.009842 0.009797 0.009753 0.009708 0.009664 0.00962 0.009575 0.009531 0.009486 0.009442 0.009397 0.009353 0.009308 0.009264 0.009219 0.009175 0.00913 0.009086 0.009041 0.008997 0.008926 0.008806 0.008686 0.008567 0.009138 0.009091;
0.02134 0.02062 0.01995 0.01934 0.01876 0.01824 0.01775 0.01729 0.01687 0.01648 0.01612 0.01578 0.01546 0.01066 0.01081 0.01097 0.01113 0.01128 0.01144 0.0116 0.01173 0.01173 0.01174 0.01175 0.01176 0.01176 0.01177 0.01178 0.01178 0.01179 0.0118 0.0118 0.01181 0.01182 0.01182 0.01183 0.01184 0.01184 0.01174 0.01163 0.01153 0.01142 0.01131 0.01121 0.0111 0.01099 0.01089 0.01081 0.01074 0.01067 0.0106 0.01053 0.01045 0.01038 0.01031 0.01024 0.01017 0.0101 0.01003 0.009956 0.009885 0.009814 0.009742 0.009671 0.0096 0.009529 0.009457 0.009386 0.009315 0.009244 0.009173 0.009101 0.00905 0.009005 0.008961 0.008916 0.008872 0.008827 0.008783 0.008738 0.008694 0.008649 0.008605 0.0085 0.00838 0.008722;
0.02044 0.01975 0.01911 0.01852 0.01798 0.01748 0.01701 0.01659 0.01619 0.01582 0.01548 0.01517 0.01488 0.01074 0.0109 0.01106 0.01121 0.01137 0.01153 0.01159 0.01159 0.0116 0.01161 0.01161 0.01162 0.01163 0.01164 0.01164 0.01165 0.01166 0.01166 0.01167 0.01168 0.01168 0.01169 0.0117 0.0117 0.01171 0.01161 0.0115 0.01139 0.01131 0.01124 0.01117 0.0111 0.01103 0.01096 0.01089 0.01081 0.01074 0.01067 0.0106 0.01053 0.01046 0.01039 0.01032 0.01025 0.01017 0.0101 0.01003 0.00996 0.009889 0.009818 0.009747 0.009675 0.009604 0.009533 0.009462 0.00939 0.009319 0.009248 0.009177 0.009106 0.009034 0.008963 0.008892 0.008821 0.008749 0.008678 0.008607 0.008536 0.008465 0.008393 0.008322 0.008257 0.00835;
0.01954 0.01888 0.01827 0.01771 0.01719 0.01672 0.01628 0.01588 0.01551 0.01517 0.01485 0.01456 0.01067 0.01083 0.01099 0.01115 0.0113 0.01144 0.01145 0.01145 0.01146 0.01147 0.01147 0.01148 0.01149 0.01149 0.0115 0.01151 0.01152 0.01152 0.01153 0.01154 0.01154 0.01155 0.01156 0.01156 0.01157 0.01156 0.01155 0.01144 0.01134 0.01126 0.01119 0.01113 0.01106 0.01099 0.01092 0.01085 0.01077 0.0107 0.01063 0.01055 0.01048 0.01041 0.01033 0.01026 0.01019 0.01011 0.01004 0.009968 0.009894 0.009821 0.009748 0.009675 0.009602 0.009529 0.009455 0.009382 0.009309 0.009236 0.009163 0.00909 0.009016 0.008943 0.00887 0.008797 0.008724 0.008651 0.008577 0.008504 0.008431 0.008358 0.008285 0.008212 0.008076 0.007977;
0.01864 0.01801 0.01743 0.0169 0.01641 0.01596 0.01555 0.01518 0.01483 0.01451 0.01422 0.0106 0.01076 0.01092 0.01108 0.01123 0.0113 0.01131 0.01131 0.01132 0.01133 0.01133 0.01134 0.01135 0.01135 0.01136 0.01137 0.01137 0.01138 0.01139 0.0114 0.0114 0.01141 0.01141 0.01141 0.0114 0.0114 0.0114 0.0114 0.01139 0.01136 0.01126 0.01115 0.01105 0.01095 0.01084 0.01074 0.01063 0.01056 0.01049 0.01042 0.01035 0.01028 0.01022 0.01015 0.01008 0.01001 0.009942 0.009874 0.009805 0.009737 0.009668 0.0096 0.009531 0.009463 0.009393 0.00932 0.009247 0.009174 0.0091 0.009027 0.008954 0.008881 0.008808 0.008735 0.008661 0.008588 0.008515 0.008442 0.008369 0.008296 0.008222 0.007949 0.007836 0.007722 0.007606;
0.01774 0.01714 0.01659 0.01609 0.01563 0.01521 0.01482 0.01447 0.01415 0.01386 0.01054 0.01069 0.01085 0.01101 0.01115 0.01116 0.01116 0.01117 0.01118 0.01119 0.01119 0.0112 0.01121 0.01121 0.01122 0.01123 0.01123 0.01124 0.01125 0.01125 0.01126 0.01125 0.01125 0.01125 0.01124 0.01124 0.01124 0.01123 0.01123 0.01123 0.01123 0.01122 0.01118 0.01107 0.01097 0.01086 0.01076 0.01066 0.01055 0.01045 0.01035 0.01024 0.01014 0.01003 0.009931 0.009854 0.009786 0.009717 0.009649 0.00958 0.009512 0.009443 0.009375 0.009306 0.009238 0.009169 0.009101 0.009032 0.008964 0.008895 0.008827 0.008758 0.00869 0.008621 0.008553 0.008485 0.008416 0.008348 0.008279 0.008211 0.00788 0.007756 0.00763 0.007502 0.007371 0.007238;
0.01685 0.01628 0.01576 0.01528 0.01485 0.01446 0.0141 0.01378 0.01348 0.01047 0.01062 0.01078 0.01094 0.01101 0.01102 0.01102 0.01103 0.01104 0.01104 0.01105 0.01106 0.01107 0.01107 0.01108 0.01109 0.01109 0.0111 0.0111 0.0111 0.01109 0.01109 0.01109 0.01108 0.01108 0.01108 0.01108 0.01107 0.01107 0.01107 0.01106 0.01106 0.01106 0.01106 0.01105 0.01099 0.01089 0.01078 0.01068 0.01058 0.01047 0.01037 0.01026 0.01016 0.01006 0.009953 0.009849 0.009746 0.009642 0.009538 0.009434 0.009331 0.009227 0.00915 0.009081 0.009013 0.008944 0.008876 0.008807 0.008739 0.00867 0.008602 0.008534 0.008465 0.008397 0.008328 0.00826 0.008191 0.008187 0.007866 0.007733 0.007597 0.007458 0.007317 0.007172 0.007025 0.006876;
0.01597 0.01543 0.01493 0.01449 0.01408 0.01372 0.01339 0.01309 0.0104 0.01055 0.01071 0.01086 0.01087 0.01088 0.01088 0.01089 0.0109 0.0109 0.01091 0.01092 0.01092 0.01093 0.01094 0.01095 0.01094 0.01094 0.01094 0.01094 0.01093 0.01093 0.01093 0.01092 0.01092 0.01092 0.01091 0.01091 0.01091 0.01091 0.0109 0.0109 0.0109 0.01089 0.01089 0.01089 0.01089 0.01088 0.0108 0.0107 0.0106 0.01049 0.01039 0.01029 0.01018 0.01008 0.009975 0.009871 0.009768 0.009664 0.00956 0.009457 0.009353 0.009249 0.009145 0.009042 0.008938 0.008834 0.008731 0.008627 0.008523 0.008446 0.008377 0.008309 0.00824 0.008187 0.008187 0.008187 0.007901 0.007761 0.007618 0.007471 0.007321 0.007167 0.00701 0.00685 0.006687 0.00652;
0.0151 0.01458 0.01412 0.0137 0.01332 0.01298 0.01268 0.01033 0.01048 0.01064 0.01072 0.01073 0.01074 0.01074 0.01075 0.01076 0.01076 0.01077 0.01078 0.01078 0.01079 0.01079 0.01079 0.01078 0.01078 0.01078 0.01077 0.01077 0.01077 0.01076 0.01076 0.01076 0.01076 0.01075 0.01075 0.01075 0.01074 0.01074 0.01074 0.01074 0.01073 0.01073 0.01073 0.01072 0.01072 0.01072 0.01072 0.01071 0.01062 0.01052 0.01041 0.01031 0.0102 0.0101 0.009997 0.009893 0.00979 0.009686 0.009582 0.009479 0.009375 0.009271 0.009167 0.009064 0.00896 0.008856 0.008753 0.008649 0.008545 0.008442 0.00831 0.008187 0.008187 0.008187 0.00798 0.007835 0.007687 0.007535 0.007378 0.007218 0.007054 0.006885 0.006713 0.006537 0.006357 0.006173;
0.01423 0.01375 0.01331 0.01292 0.01257 0.01226 0.01026 0.01041 0.01057 0.01058 0.01059 0.01059 0.0106 0.01061 0.01062 0.01062 0.01063 0.01064 0.01063 0.01063 0.01063 0.01062 0.01062 0.01062 0.01062 0.01061 0.01061 0.01061 0.0106 0.0106 0.0106 0.01059 0.01059 0.01059 0.01059 0.01058 0.01058 0.01058 0.01057 0.01057 0.01057 0.01057 0.01056 0.01056 0.01056 0.01055 0.01055 0.01055 0.01055 0.01054 0.01043 0.01033 0.01023 0.01012 0.01002 0.009915 0.009812 0.009708 0.009604 0.009501 0.009397 0.009293 0.00919 0.009086 0.008982 0.008878 0.00875 0.008614 0.008479 0.008343 0.008208 0.00824 0.008098 0.007951 0.0078 0.007645 0.007484 0.007319 0.00715 0.006976 0.006797 0.006614 0.006426 0.006234 0.006038 0.005837;
0.01338 0.01292 0.01252 0.01216 0.01183 0.01019 0.01034 0.01043 0.01044 0.01045 0.01045 0.01046 0.01047 0.01047 0.01048 0.01048 0.01047 0.01047 0.01047 0.01047 0.01046 0.01046 0.01046 0.01045 0.01045 0.01045 0.01044 0.01044 0.01044 0.01044 0.01043 0.01043 0.01043 0.01042 0.01042 0.01042 0.01042 0.01041 0.01041 0.01041 0.0104 0.0104 0.0104 0.0104 0.01039 0.01039 0.01039 0.01038 0.01038 0.01038 0.01038 0.01035 0.01025 0.01014 0.01004 0.009937 0.009834 0.00973 0.009626 0.009523 0.009419 0.009315 0.00919 0.009054 0.008918 0.008783 0.008666 0.008554 0.008527 0.008391 0.00825 0.008104 0.007952 0.007796 0.007634 0.007466 0.007294 0.007117 0.006934 0.006746 0.006553 0.006355 0.006152 0.005944 0.005732 0.005514;
0.01254 0.01212 0.01174 0.0114 0.01012 0.01027 0.01029 0.0103 0.01031 0.01031 0.01032 0.01032 0.01032 0.01032 0.01032 0.01031 0.01031 0.01031 0.0103 0.0103 0.0103 0.0103 0.01029 0.01029 0.01029 0.01028 0.01028 0.01028 0.01027 0.01027 0.01027 0.01027 0.01026 0.01026 0.01026 0.01025 0.01025 0.01025 0.01025 0.01024 0.01024 0.01024 0.01023 0.01023 0.01023 0.01023 0.01022 0.01022 0.01022 0.01021 0.01021 0.01021 0.01021 0.01017 0.01006 0.009959 0.009856 0.009752 0.009629 0.009494 0.009378 0.009266 0.009153 0.009041 0.008929 0.008828 0.008702 0.00857 0.008432 0.008288 0.008138 0.007983 0.007821 0.007654 0.007481 0.007303 0.007118 0.006928 0.006732 0.006531 0.006324 0.006111 0.005893 0.005669 0.005439 0.005205;
0.01172 0.01132 0.01098 0.01005 0.01014 0.01015 0.01016 0.01017 0.01017 0.01017 0.01016 0.01016 0.01016 0.01015 0.01015 0.01015 0.01015 0.01014 0.01014 0.01014 0.01013 0.01013 0.01013 0.01013 0.01012 0.01012 0.01012 0.01011 0.01011 0.01011 0.0101 0.0101 0.0101 0.0101 0.01009 0.01009 0.01009 0.01008 0.01008 0.01008 0.01008 0.01007 0.01007 0.01007 0.01006 0.01006 0.01006 0.01006 0.01005 0.01005 0.01005 0.01005 0.01005 0.01006 0.01006 0.009984 0.009874 0.009765 0.009655 0.009545 0.009435 0.009237 0.00913 0.009016 0.008896 0.00877 0.008637 0.008498 0.008353 0.008201 0.008042 0.007877 0.007706 0.007529 0.007345 0.007155 0.006958 0.006756 0.006547 0.006331 0.00611 0.005883 0.005649 0.005409 0.005164 0.004912;
0.01092 0.01055 0.009976 0.01 0.01001 0.01001 0.01001 0.01001 0.01 0.01 0.009998 0.009995 0.009992 0.00999 0.009987 0.009984 0.009981 0.009978 0.009975 0.009972 0.009969 0.009966 0.009964 0.009961 0.009958 0.009955 0.009952 0.009949 0.009946 0.009943 0.009941 0.009945 0.009949 0.009953 0.009957 0.009961 0.009965 0.009969 0.009973 0.009977 0.009981 0.009985 0.009989 0.009993 0.009997 0.01 0.01001 0.01001 0.01001 0.01002 0.01002 0.01003 0.01003 0.01004 0.01005 0.01005 0.009671 0.009594 0.00951 0.00942 0.009322 0.009217 0.009106 0.008988 0.008862 0.00873 0.008591 0.008444 0.008291 0.008131 0.007964 0.00779 0.007609 0.007421 0.007226 0.007025 0.006816 0.006601 0.006379 0.00615 0.005914 0.005672 0.005423 0.005168 0.004905 0.004637;
0.01014 0.009856 0.009857 0.009854 0.009851 0.009848 0.009845 0.009843 0.00984 0.009837 0.009839 0.009843 0.009847 0.009851 0.009855 0.009859 0.009863 0.009867 0.009871 0.009875 0.009879 0.009883 0.009887 0.009891 0.009895 0.009899 0.009903 0.009907 0.009912 0.009916 0.00992 0.009924 0.009928 0.009932 0.009936 0.00994 0.009944 0.009948 0.009952 0.009956 0.00996 0.009964 0.009968 0.009972 0.009976 0.00998 0.009984 0.009988 0.009992 0.009996 0.01 0.01001 0.009926 0.009876 0.00982 0.009756 0.009684 0.009606 0.00952 0.009426 0.009326 0.009217 0.009102 0.008978 0.008848 0.008709 0.008564 0.00841 0.00825 0.008081 0.007905 0.007722 0.007531 0.007333 0.007127 0.006914 0.006694 0.006466 0.006231 0.005988 0.005738 0.005481 0.005217 0.004945 0.004667 0.004381;
0.009373 0.009064 0.008801 0.008581 0.008399 0.008251 0.008134 0.008046 0.009789 0.009789 0.009789 0.009789 0.009789 0.009789 0.009789 0.009789 0.009791 0.009795 0.009799 0.009803 0.009806 0.00981 0.009814 0.009817 0.009821 0.009825 0.009828 0.009832 0.009836 0.00984 0.009843 0.009847 0.009851 0.009854 0.009858 0.009862 0.009866 0.009869 0.009873 0.009877 0.00988 0.009884 0.009888 0.009892 0.009901 0.009919 0.009937 0.01009 0.01008 0.01006 0.01004 0.01 0.009961 0.009912 0.009855 0.009791 0.009719 0.009638 0.00955 0.009454 0.00935 0.009238 0.009118 0.00899 0.008854 0.00871 0.008558 0.008397 0.008229 0.008052 0.007868 0.007675 0.007475 0.007266 0.00705 0.006825 0.006592 0.006352 0.006104 0.005847 0.005583 0.005311 0.005032 0.004744 0.004449 0.004146;
0.008633 0.008353 0.00812 0.007928 0.007773 0.007653 0.007563 0.0075 0.007462 0.007446 0.007449 0.00747 0.007506 0.007556 0.007617 0.007689 0.00777 0.007858 0.007952 0.008052 0.008155 0.009789 0.009789 0.009789 0.009789 0.009789 0.009789 0.009789 0.009789 0.009789 0.009789 0.009789 0.009789 0.009789 0.009789 0.009789 0.009789 0.009789 0.009811 0.009829 0.009848 0.009866 0.009884 0.01009 0.01012 0.01013 0.01014 0.01014 0.01013 0.01011 0.01009 0.01006 0.01002 0.00997 0.009914 0.009849 0.009776 0.009694 0.009604 0.009505 0.009398 0.009282 0.009158 0.009025 0.008883 0.008733 0.008575 0.008407 0.008231 0.008047 0.007853 0.007651 0.007441 0.007222 0.006994 0.006758 0.006514 0.006261 0.005999 0.005729 0.005451 0.005164 0.004869 0.004566 0.004254 0.003935;
0.007917 0.007667 0.007462 0.007299 0.007172 0.007079 0.007016 0.006979 0.006967 0.006976 0.007003 0.007048 0.007108 0.00718 0.007264 0.007357 0.007459 0.007568 0.007682 0.007801 0.007923 0.008048 0.008175 0.008303 0.00843 0.008557 0.008682 0.008806 0.008927 0.009044 0.009159 0.009269 0.009374 0.009475 0.009571 0.009789 0.009789 0.009789 0.009894 0.009958 0.01002 0.01007 0.01011 0.01015 0.01017 0.01019 0.0102 0.01021 0.0102 0.01019 0.01017 0.01014 0.0101 0.01005 0.009996 0.009931 0.009857 0.009774 0.009681 0.00958 0.00947 0.00935 0.009222 0.009084 0.008937 0.008781 0.008616 0.008441 0.008258 0.008065 0.007863 0.007652 0.007432 0.007202 0.006964 0.006716 0.00646 0.006194 0.005919 0.005636 0.005343 0.005042 0.004731 0.004412 0.004084 0.003747]'; 

% (g/s), engine out CO emissions indexed vertically by fc_map_spd and
% horizontally by fc_map_trq
fc_co_map=[2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016;
2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016;
2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016;
2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016;
2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016;
2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016;
2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016;
2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016;
2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016;
0.01075 0.003782 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 0.001221 0.003249 0.005418 0.007733 0.0102 0.01282;
0.02657 0.01963 0.01367 0.008584 0.004268 0.000636 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 0.0002234 0.0005669 0.0009703 0.001438 0.001976 0.002587 0.003277 0.004051 0.004913 0.005869 0.006922 0.008078 0.009342 0.01072 0.01221 0.01383 0.01557 0.01744 0.01945 0.0216 0.02389 0.02633 0.02893;
0.03692 0.03 0.02407 0.01901 0.01472 0.01112 0.008119 0.005653 0.003656 0.002073 0.0008521 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 0.000368 0.0009121 0.001491 0.002093 0.002707 0.003325 0.003938 0.004539 0.005122 0.005683 0.006217 0.006721 0.007193 0.00763 0.008031 0.008395 0.008723 0.009013 0.009268 0.009487 0.009672 0.009824 0.009947 0.01004 0.01011 0.01016 0.01018 0.01019 0.01019 0.01018 0.01016 0.01014 0.01012 0.0101 0.0101 0.01011 0.01013 0.01018 0.01026 0.01037 0.01051 0.0107 0.01093 0.01121 0.01154 0.01193 0.01239 0.01292 0.01352 0.0142 0.01496 0.01581 0.01675 0.01779 0.01893 0.02017 0.02153 0.02301 0.02461 0.02633 0.02818 0.03017 0.0323 0.03457 0.03699 0.03957;
0.04337 0.03649 0.03059 0.02556 0.02129 0.01771 0.01474 0.0123 0.01033 0.008769 0.007571 0.006688 0.006079 0.005706 0.005536 0.005539 0.005687 0.005956 0.006326 0.006775 0.007288 0.007849 0.008445 0.009062 0.009692 0.01032 0.01095 0.01156 0.01216 0.01273 0.01328 0.01379 0.01428 0.01472 0.01513 0.0155 0.01584 0.01614 0.0164 0.01662 0.01681 0.01697 0.0171 0.0172 0.01727 0.01732 0.01734 0.01736 0.01735 0.01734 0.01732 0.0173 0.01727 0.01726 0.01725 0.01725 0.01728 0.0188 0.01891 0.01903 0.01915 0.01926 0.01938 0.01949 0.01961 0.01973 0.01984 0.01996 0.02007 0.02019 0.0203 0.02042 0.02374 0.02476 0.02589 0.02712 0.02846 0.02992 0.0315 0.0332 0.03504 0.037 0.03911 0.04137 0.04377 0.04632;
0.04707 0.04021 0.03434 0.02934 0.0251 0.02155 0.0186 0.01618 0.01424 0.0127 0.01153 0.01067 0.01008 0.009731 0.009582 0.009605 0.009773 0.01006 0.01045 0.01092 0.01145 0.01203 0.01264 0.01327 0.01391 0.01456 0.0152 0.01583 0.01644 0.01702 0.01758 0.0181 0.0186 0.01905 0.01947 0.01985 0.0202 0.0205 0.02077 0.021 0.01714 0.01726 0.01738 0.0175 0.01762 0.01773 0.01785 0.01797 0.01809 0.01821 0.01833 0.01845 0.01856 0.01868 0.0188 0.01892 0.01904 0.01915 0.01927 0.01938 0.0195 0.01961 0.01973 0.01985 0.01996 0.02008 0.02019 0.02031 0.02043 0.02054 0.02066 0.02077 0.02254 0.02897 0.03008 0.0313 0.03263 0.03407 0.03563 0.03731 0.03913 0.04108 0.04317 0.0454 0.04778 0.05031;
0.04882 0.04199 0.03615 0.03117 0.02696 0.02344 0.02051 0.01812 0.0162 0.01469 0.01354 0.0127 0.01214 0.01181 0.01168 0.01173 0.01191 0.01222 0.01263 0.01311 0.01366 0.01426 0.01488 0.01553 0.01619 0.01685 0.01751 0.01815 0.01877 0.01937 0.01993 0.02047 0.02097 0.02144 0.02187 0.02225 0.02261 0.01741 0.01732 0.01738 0.01749 0.01761 0.01773 0.01785 0.01796 0.01808 0.0182 0.01832 0.01844 0.01856 0.01867 0.01879 0.01891 0.01903 0.01915 0.01927 0.01938 0.0195 0.01962 0.01974 0.01985 0.01997 0.02008 0.0202 0.02031 0.02043 0.02055 0.02066 0.02078 0.02089 0.02101 0.02113 0.02289 0.03124 0.03234 0.03354 0.03485 0.03627 0.03781 0.03948 0.04128 0.04321 0.04527 0.04748 0.04984 0.05235;
0.04922 0.04242 0.03661 0.03166 0.02748 0.02398 0.02108 0.01872 0.01682 0.01533 0.01421 0.01339 0.01285 0.01254 0.01243 0.0125 0.01271 0.01303 0.01346 0.01396 0.01453 0.01514 0.01578 0.01645 0.01712 0.0178 0.01846 0.01912 0.01975 0.02036 0.02094 0.02149 0.022 0.02247 0.02291 0.02331 0.01893 0.01806 0.01797 0.0179 0.01785 0.01796 0.01808 0.0182 0.01831 0.01843 0.01855 0.01867 0.01879 0.0189 0.01902 0.01914 0.01926 0.01938 0.0195 0.01961 0.01973 0.01985 0.01997 0.02009 0.0202 0.02032 0.02044 0.02055 0.02067 0.02078 0.0209 0.02101 0.02113 0.02125 0.02136 0.02148 0.02324 0.02584 0.03324 0.03442 0.03572 0.03712 0.03865 0.0403 0.04208 0.04399 0.04603 0.04822 0.05056 0.05305;
0.04872 0.04195 0.03616 0.03124 0.02709 0.02361 0.02074 0.0184 0.01653 0.01507 0.01396 0.01317 0.01265 0.01237 0.01228 0.01237 0.01259 0.01294 0.01338 0.01391 0.01449 0.01512 0.01578 0.01646 0.01715 0.01784 0.01852 0.01918 0.01983 0.02045 0.02104 0.0216 0.02212 0.02261 0.02305 0.02045 0.01958 0.01871 0.01863 0.01855 0.01847 0.01839 0.01843 0.01855 0.01867 0.01878 0.0189 0.01902 0.01913 0.01925 0.01937 0.01949 0.01961 0.01973 0.01984 0.01996 0.02008 0.0202 0.02032 0.02044 0.02055 0.02067 0.02079 0.0209 0.02102 0.02114 0.02125 0.02137 0.02148 0.0216 0.02171 0.02183 0.0236 0.0262 0.03324 0.03441 0.03568 0.03707 0.03858 0.04021 0.04197 0.04386 0.04589 0.04806 0.05037 0.05284;
0.04764 0.0409 0.03514 0.03025 0.02612 0.02267 0.01983 0.01752 0.01567 0.01423 0.01315 0.01238 0.01188 0.01162 0.01155 0.01166 0.01191 0.01227 0.01273 0.01327 0.01388 0.01452 0.0152 0.01589 0.0166 0.0173 0.018 0.01868 0.01933 0.01997 0.02057 0.02114 0.02167 0.02216 0.02197 0.0211 0.02023 0.01937 0.01928 0.0192 0.01912 0.01904 0.01896 0.01891 0.01902 0.01914 0.01926 0.01937 0.01949 0.01961 0.01972 0.01984 0.01996 0.02007 0.02019 0.02031 0.02043 0.02055 0.02067 0.02078 0.0209 0.02102 0.02114 0.02126 0.02137 0.02149 0.0216 0.02172 0.02184 0.02195 0.02207 0.02218 0.02395 0.02655 0.02915 0.03382 0.03508 0.03645 0.03794 0.03955 0.04129 0.04316 0.04517 0.04732 0.04961 0.05205;
0.04623 0.03952 0.03379 0.02893 0.02483 0.02141 0.01859 0.0163 0.01448 0.01306 0.01201 0.01126 0.01079 0.01054 0.0105 0.01062 0.01089 0.01128 0.01176 0.01232 0.01293 0.0136 0.01429 0.015 0.01572 0.01644 0.01715 0.01784 0.01851 0.01916 0.01977 0.02035 0.02089 0.02349 0.02262 0.02176 0.02089 0.02002 0.01993 0.01985 0.01977 0.0197 0.01962 0.01954 0.01946 0.01949 0.01961 0.01973 0.01984 0.01996 0.02008 0.02019 0.02031 0.02043 0.02054 0.02066 0.02078 0.0209 0.02101 0.02113 0.02125 0.02137 0.02149 0.02161 0.02172 0.02184 0.02196 0.02207 0.02219 0.0223 0.02242 0.02253 0.0243 0.0269 0.0295 0.0329 0.03414 0.0355 0.03697 0.03856 0.04028 0.04213 0.04412 0.04625 0.04852 0.05094;
0.04468 0.038 0.0323 0.02746 0.02339 0.02 0.0172 0.01494 0.01314 0.01175 0.01072 0.009997 0.009544 0.009323 0.0093 0.009446 0.009733 0.01014 0.01064 0.01121 0.01185 0.01253 0.01324 0.01396 0.0147 0.01543 0.01615 0.01686 0.01754 0.0182 0.01883 0.01942 0.02501 0.02414 0.02328 0.02241 0.02154 0.02067 0.02058 0.02051 0.02043 0.02035 0.02027 0.02019 0.02011 0.02003 0.01997 0.02008 0.0202 0.02031 0.02043 0.02055 0.02066 0.02078 0.0209 0.02101 0.02113 0.02125 0.02136 0.02148 0.0216 0.02172 0.02184 0.02195 0.02207 0.02219 0.02231 0.02242 0.02254 0.02266 0.02277 0.02289 0.02465 0.02725 0.02985 0.03245 0.03306 0.0344 0.03586 0.03743 0.03913 0.04096 0.04293 0.04504 0.04729 0.04969;
0.04313 0.03648 0.0308 0.02599 0.02195 0.01858 0.01581 0.01358 0.0118 0.01044 0.009427 0.008727 0.008296 0.008097 0.008096 0.008262 0.008569 0.008992 0.009511 0.0101 0.01076 0.01145 0.01218 0.01292 0.01367 0.01442 0.01515 0.01587 0.01657 0.01724 0.01787 0.02653 0.02567 0.0248 0.02393 0.02306 0.02219 0.02132 0.02124 0.02116 0.02108 0.021 0.02092 0.02084 0.02076 0.02069 0.02061 0.02053 0.02055 0.02067 0.02079 0.0209 0.02102 0.02114 0.02125 0.02137 0.02149 0.0216 0.02172 0.02183 0.02195 0.02207 0.02218 0.0223 0.02242 0.02254 0.02266 0.02278 0.02289 0.02301 0.02312 0.02324 0.02501 0.0276 0.0302 0.0328 0.03198 0.0333 0.03474 0.03629 0.03797 0.03979 0.04173 0.04382 0.04605 0.04842;
0.04167 0.03505 0.0294 0.02462 0.0206 0.01726 0.01452 0.01231 0.01056 0.009214 0.008228 0.007552 0.007143 0.006966 0.006985 0.007172 0.007499 0.007942 0.008479 0.009091 0.009761 0.01047 0.01121 0.01197 0.01274 0.0135 0.01425 0.01498 0.01569 0.01637 0.02806 0.02719 0.02632 0.02545 0.02458 0.02371 0.02284 0.02198 0.02189 0.02181 0.02173 0.02165 0.02157 0.0215 0.02142 0.02134 0.02126 0.02118 0.0211 0.02102 0.02114 0.02126 0.02137 0.02149 0.02161 0.02172 0.02184 0.02196 0.02207 0.02219 0.02231 0.02242 0.02254 0.02266 0.02277 0.02289 0.02301 0.02312 0.02324 0.02336 0.02348 0.02359 0.02536 0.02796 0.03056 0.03315 0.03575 0.03229 0.03371 0.03525 0.03691 0.0387 0.04063 0.04269 0.0449 0.04726;
0.04037 0.03378 0.02816 0.02341 0.01942 0.01611 0.01339 0.0112 0.009478 0.00816 0.007198 0.006544 0.006158 0.006002 0.006043 0.00625 0.006596 0.007059 0.007614 0.008245 0.008932 0.009661 0.01042 0.01119 0.01197 0.01275 0.01351 0.01426 0.01498 0.02958 0.02871 0.02784 0.02697 0.0261 0.02523 0.02437 0.0235 0.02263 0.02254 0.02246 0.02238 0.02231 0.02223 0.02215 0.02207 0.02199 0.02191 0.02183 0.02175 0.02168 0.0216 0.02161 0.02173 0.02185 0.02196 0.02208 0.0222 0.02231 0.02243 0.02254 0.02266 0.02278 0.02289 0.02301 0.02313 0.02324 0.02336 0.02348 0.02359 0.02371 0.02383 0.02394 0.02571 0.02831 0.03091 0.03351 0.03611 0.03145 0.03285 0.03437 0.03602 0.03779 0.03969 0.04174 0.04392 0.04626;
0.0393 0.03274 0.02715 0.02242 0.01846 0.01517 0.01248 0.01032 0.008618 0.007325 0.006386 0.005755 0.005391 0.005257 0.005318 0.005546 0.005913 0.006394 0.006968 0.007617 0.008321 0.009067 0.009841 0.01063 0.01142 0.01222 0.01299 0.01375 0.0311 0.03023 0.02936 0.02849 0.02762 0.02676 0.02589 0.02502 0.02415 0.02328 0.02319 0.02312 0.02304 0.02296 0.02288 0.0228 0.02272 0.02264 0.02256 0.02249 0.02241 0.02233 0.02225 0.02217 0.02209 0.0222 0.02232 0.02243 0.02255 0.02267 0.02278 0.0229 0.02302 0.02313 0.02325 0.02337 0.02348 0.0236 0.02372 0.02384 0.02399 0.02413 0.02428 0.02443 0.02606 0.02866 0.03126 0.03386 0.03646 0.03906 0.03221 0.03371 0.03534 0.03709 0.03898 0.041 0.04317 0.04548;
0.03848 0.03194 0.02638 0.02168 0.01775 0.01449 0.01182 0.009686 0.008011 0.006742 0.005826 0.005218 0.004877 0.004764 0.004847 0.005095 0.005482 0.005982 0.006575 0.007242 0.007964 0.008727 0.009516 0.01032 0.01113 0.01194 0.01273 0.03262 0.03175 0.03088 0.03001 0.02915 0.02828 0.02741 0.02654 0.02567 0.0248 0.02393 0.02385 0.02377 0.02369 0.02361 0.02353 0.02345 0.02337 0.0233 0.02322 0.02314 0.02306 0.02298 0.0229 0.02282 0.02274 0.02267 0.02267 0.02279 0.0229 0.02302 0.02315 0.02329 0.02344 0.02359 0.02374 0.02388 0.02403 0.02418 0.02433 0.02447 0.02462 0.02477 0.02491 0.02506 0.02661 0.02901 0.03161 0.03421 0.03681 0.03941 0.03183 0.03331 0.03492 0.03665 0.03851 0.04052 0.04266 0.04495;
0.03793 0.03142 0.02589 0.02122 0.01731 0.01408 0.01144 0.009328 0.007678 0.006432 0.00554 0.004955 0.004636 0.004545 0.004649 0.004917 0.005324 0.005844 0.006455 0.00714 0.007879 0.008659 0.009465 0.01029 0.01111 0.01193 0.03414 0.03327 0.0324 0.03153 0.03067 0.0298 0.02893 0.02806 0.02719 0.02632 0.02546 0.02459 0.0245 0.02442 0.02434 0.02426 0.02418 0.02411 0.02403 0.02395 0.02387 0.02379 0.02371 0.02364 0.0236 0.02356 0.02351 0.02347 0.02343 0.02339 0.02348 0.02363 0.02378 0.02393 0.02407 0.02422 0.02437 0.02452 0.02466 0.02481 0.02496 0.02511 0.02525 0.0254 0.02555 0.02569 0.02725 0.0295 0.03197 0.03456 0.03716 0.03976 0.04236 0.03318 0.03476 0.03648 0.03832 0.0403 0.04243 0.04469;
0.03766 0.03119 0.02568 0.02104 0.01716 0.01395 0.01134 0.009252 0.007627 0.006406 0.005537 0.004975 0.004678 0.004609 0.004734 0.005023 0.005449 0.005988 0.006619 0.007321 0.008078 0.008875 0.009697 0.01053 0.01137 0.03566 0.03479 0.03392 0.03306 0.03219 0.03132 0.03045 0.02958 0.02871 0.02784 0.02698 0.02611 0.02524 0.02515 0.02507 0.025 0.02496 0.02491 0.02487 0.02483 0.02479 0.02475 0.0247 0.02466 0.02462 0.02458 0.02454 0.0245 0.02445 0.02441 0.02437 0.02433 0.02429 0.02441 0.02456 0.02471 0.02485 0.025 0.02515 0.0253 0.02544 0.02559 0.02574 0.02589 0.02603 0.02618 0.02633 0.02788 0.03014 0.03239 0.03492 0.03751 0.04011 0.04271 0.03333 0.0349 0.03659 0.03842 0.04038 0.04248 0.04472;
0.03768 0.03124 0.02576 0.02114 0.01729 0.01411 0.01152 0.009462 0.007862 0.006664 0.005819 0.00528 0.005006 0.004958 0.005104 0.005414 0.00586 0.006418 0.007067 0.007787 0.008562 0.009375 0.01021 0.01107 0.03718 0.03631 0.03545 0.03458 0.03371 0.03284 0.03197 0.0311 0.03023 0.02937 0.0285 0.02763 0.02676 0.0266 0.02614 0.02603 0.02598 0.02594 0.02589 0.02585 0.02581 0.02577 0.02573 0.02569 0.02564 0.0256 0.02556 0.02552 0.02548 0.02543 0.02539 0.02535 0.02531 0.02527 0.02522 0.02519 0.02534 0.02549 0.02563 0.02578 0.02593 0.02608 0.02622 0.02637 0.02652 0.02667 0.02681 0.02696 0.02851 0.03077 0.03303 0.03528 0.03787 0.04047 0.04306 0.04566 0.03531 0.03699 0.03879 0.04073 0.04281 0.04503;
0.03798 0.03157 0.02612 0.02153 0.0177 0.01455 0.01199 0.009952 0.008376 0.007203 0.006382 0.005865 0.005613 0.005587 0.005754 0.006084 0.00655 0.007128 0.007795 0.008534 0.009326 0.01016 0.01101 0.0387 0.03783 0.03697 0.0361 0.03523 0.03436 0.03349 0.03262 0.03176 0.03089 0.03002 0.02915 0.02861 0.02847 0.02832 0.02786 0.02739 0.02701 0.02696 0.02691 0.02685 0.0268 0.02675 0.02671 0.02667 0.02662 0.02658 0.02654 0.0265 0.02646 0.02641 0.02637 0.02633 0.02629 0.02625 0.02621 0.02616 0.02612 0.02612 0.02627 0.02641 0.02656 0.02671 0.02686 0.027 0.02715 0.0273 0.02745 0.02759 0.02914 0.0314 0.03366 0.03592 0.03822 0.04082 0.04342 0.04601 0.03601 0.03767 0.03945 0.04137 0.04343 0.04563;
0.03855 0.03216 0.02674 0.02218 0.01838 0.01526 0.01272 0.01071 0.00916 0.008011 0.007213 0.00672 0.00649 0.006486 0.006674 0.007024 0.00751 0.008107 0.008793 0.00955 0.01036 0.01121 0.04022 0.03936 0.03849 0.03762 0.03675 0.03588 0.03501 0.03415 0.03328 0.03241 0.03154 0.03067 0.03047 0.03033 0.03019 0.03004 0.02958 0.02911 0.02865 0.02818 0.02794 0.02788 0.02783 0.02778 0.02773 0.02767 0.02762 0.02757 0.02752 0.02748 0.02744 0.0274 0.02735 0.02731 0.02727 0.02723 0.02719 0.02714 0.0271 0.02706 0.02702 0.02705 0.02719 0.02734 0.02749 0.02764 0.02778 0.02793 0.02808 0.02823 0.02978 0.03203 0.03429 0.03655 0.03881 0.04117 0.04377 0.04637 0.04897 0.03861 0.04038 0.04228 0.04431 0.04649;
0.03938 0.03302 0.02763 0.02309 0.01932 0.01622 0.01371 0.01173 0.0102 0.009075 0.008301 0.00783 0.007622 0.00764 0.007849 0.00822 0.008726 0.009342 0.01005 0.01082 0.01165 0.04175 0.04088 0.04001 0.03914 0.03827 0.0374 0.03653 0.03567 0.0348 0.03393 0.03306 0.03248 0.03234 0.0322 0.03205 0.03191 0.03177 0.0313 0.03084 0.03037 0.0299 0.02944 0.02897 0.02886 0.02881 0.02876 0.0287 0.02865 0.0286 0.02855 0.02849 0.02844 0.02839 0.02833 0.02829 0.02825 0.02821 0.02817 0.02812 0.02808 0.02804 0.028 0.02796 0.02792 0.02798 0.02812 0.02827 0.02842 0.02856 0.02871 0.02886 0.03041 0.03267 0.03493 0.03718 0.03944 0.0417 0.04412 0.04672 0.04932 0.03982 0.04156 0.04344 0.04545 0.04761;
0.04044 0.03411 0.02875 0.02424 0.02049 0.01742 0.01494 0.01298 0.01148 0.01038 0.009626 0.009178 0.008993 0.009032 0.009262 0.009654 0.01018 0.01081 0.01154 0.01233 0.04327 0.0424 0.04153 0.04066 0.03979 0.03892 0.03806 0.03719 0.03632 0.03545 0.03458 0.03435 0.0342 0.03406 0.03392 0.03377 0.03363 0.03349 0.03302 0.03256 0.03209 0.03162 0.03116 0.03069 0.03022 0.02984 0.02979 0.02974 0.02968 0.02963 0.02958 0.02952 0.02947 0.02942 0.02937 0.02931 0.02926 0.02921 0.02915 0.02911 0.02906 0.02902 0.02898 0.02894 0.0289 0.02885 0.02881 0.0289 0.02905 0.0292 0.02934 0.02949 0.03104 0.0333 0.03556 0.03782 0.04007 0.04233 0.04459 0.04707 0.04967 0.05227 0.04298 0.04484 0.04683 0.04897;
0.04172 0.03542 0.03008 0.02561 0.02189 0.01884 0.01638 0.01445 0.01297 0.0119 0.01117 0.01074 0.01058 0.01064 0.01089 0.0113 0.01185 0.0125 0.01325 0.04479 0.04392 0.04305 0.04218 0.04131 0.04045 0.03958 0.03871 0.03784 0.03697 0.03635 0.03621 0.03607 0.03592 0.03578 0.03564 0.03549 0.03535 0.03521 0.03474 0.03428 0.03381 0.03334 0.03288 0.03241 0.03194 0.03148 0.03101 0.03077 0.03072 0.03066 0.03061 0.03056 0.0305 0.03045 0.0304 0.03034 0.03029 0.03024 0.03019 0.03013 0.03008 0.03003 0.02997 0.02992 0.02988 0.02983 0.02979 0.02975 0.02971 0.02983 0.02998 0.03013 0.03168 0.03393 0.03619 0.03845 0.04071 0.04296 0.04522 0.04748 0.05002 0.05262 0.04462 0.04645 0.04843 0.05054;
0.0432 0.03692 0.03162 0.02717 0.02347 0.02045 0.01802 0.01611 0.01466 0.01361 0.01291 0.0125 0.01236 0.01245 0.01272 0.01315 0.01372 0.01439 0.04631 0.04544 0.04457 0.0437 0.04283 0.04197 0.0411 0.04023 0.03936 0.03849 0.03822 0.03807 0.03793 0.03779 0.03764 0.0375 0.03736 0.03721 0.03707 0.03693 0.03646 0.036 0.03553 0.03506 0.0346 0.03413 0.03366 0.0332 0.03273 0.03226 0.0318 0.03169 0.03164 0.03159 0.03154 0.03148 0.03143 0.03138 0.03132 0.03127 0.03122 0.03116 0.03111 0.03106 0.03101 0.03095 0.0309 0.03085 0.03079 0.03074 0.03069 0.03065 0.03061 0.03076 0.03231 0.03457 0.03682 0.03908 0.04134 0.0436 0.04585 0.04811 0.05038 0.05297 0.05557 0.04827 0.05022 0.05231;
0.04484 0.0386 0.03332 0.0289 0.02523 0.02224 0.01984 0.01795 0.01652 0.0155 0.01482 0.01444 0.01432 0.01442 0.01472 0.01517 0.01575 0.04783 0.04696 0.04609 0.04522 0.04436 0.04349 0.04262 0.04175 0.04088 0.04023 0.04008 0.03994 0.0398 0.03965 0.03951 0.03937 0.03922 0.03908 0.03894 0.03879 0.03865 0.03819 0.03772 0.03725 0.03679 0.03632 0.03585 0.03539 0.03492 0.03445 0.03399 0.03352 0.03305 0.03267 0.03262 0.03257 0.03251 0.03246 0.03241 0.03236 0.0323 0.03225 0.0322 0.03214 0.03209 0.03204 0.03198 0.03193 0.03188 0.03183 0.03177 0.03172 0.03167 0.03175 0.03234 0.03294 0.0352 0.03746 0.03971 0.04197 0.04423 0.04649 0.04874 0.051 0.05333 0.05592 0.05025 0.05218 0.05425;
0.04664 0.04042 0.03517 0.03078 0.02714 0.02417 0.02179 0.01994 0.01853 0.01753 0.01687 0.01652 0.01642 0.01655 0.01686 0.01733 0.04935 0.04848 0.04761 0.04675 0.04588 0.04501 0.04414 0.04327 0.0424 0.04209 0.04195 0.0418 0.04166 0.04152 0.04137 0.04123 0.04109 0.04094 0.0408 0.04066 0.04051 0.04037 0.03991 0.03944 0.03897 0.03851 0.03804 0.03757 0.03711 0.03664 0.03617 0.03571 0.03524 0.03477 0.03431 0.03384 0.0336 0.03355 0.03349 0.03344 0.03339 0.03333 0.03328 0.03323 0.03318 0.03312 0.03307 0.03302 0.03306 0.03365 0.03425 0.03484 0.03543 0.03603 0.03662 0.03722 0.03781 0.0384 0.039 0.04035 0.0426 0.04486 0.04712 0.04938 0.05163 0.05389 0.05628 0.05238 0.05429 0.05634;
0.04855 0.04237 0.03714 0.03278 0.02917 0.02623 0.02387 0.02204 0.02066 0.01968 0.01905 0.01872 0.01864 0.01879 0.01913 0.05087 0.05 0.04914 0.04827 0.0474 0.04653 0.04566 0.04479 0.0441 0.04395 0.04381 0.04367 0.04352 0.04338 0.04324 0.04309 0.04295 0.04281 0.04266 0.04252 0.04238 0.04223 0.04209 0.04163 0.04116 0.04069 0.04023 0.03976 0.03929 0.03883 0.03836 0.03789 0.03743 0.03696 0.03649 0.03603 0.03556 0.03509 0.03463 0.03452 0.03447 0.03442 0.03437 0.03437 0.03496 0.03556 0.03615 0.03674 0.03734 0.03793 0.03853 0.03912 0.03971 0.04031 0.0409 0.0415 0.04209 0.04268 0.04328 0.04387 0.04447 0.04506 0.04565 0.04775 0.05001 0.05227 0.05453 0.05678 0.05923 0.05652 0.05854;
0.05056 0.0444 0.03921 0.03487 0.03129 0.02837 0.02605 0.02424 0.02289 0.02193 0.02132 0.02101 0.02096 0.02113 0.05239 0.05152 0.05066 0.04979 0.04892 0.04805 0.04718 0.04631 0.04596 0.04582 0.04568 0.04553 0.04539 0.04525 0.0451 0.04496 0.04482 0.04467 0.04453 0.04439 0.04424 0.0441 0.04396 0.04381 0.04335 0.04288 0.04242 0.04195 0.04148 0.04102 0.04055 0.04008 0.03961 0.03915 0.03868 0.03821 0.03775 0.03728 0.03682 0.03725 0.03767 0.0381 0.03852 0.03895 0.03937 0.03984 0.04043 0.04102 0.04162 0.04221 0.04281 0.0434 0.04399 0.04459 0.04518 0.04578 0.04637 0.04696 0.04756 0.04815 0.04875 0.04934 0.04993 0.05053 0.05112 0.05172 0.0529 0.05516 0.05742 0.05967 0.05885 0.06085;
0.05264 0.04651 0.04135 0.03704 0.03348 0.03059 0.02829 0.02651 0.02518 0.02425 0.02366 0.02337 0.02335 0.05391 0.05305 0.05218 0.05131 0.05044 0.04957 0.0487 0.04797 0.04783 0.04768 0.04754 0.0474 0.04725 0.04711 0.04697 0.04682 0.04668 0.04654 0.04639 0.04625 0.04611 0.04596 0.04582 0.04568 0.04553 0.04507 0.0446 0.04414 0.04367 0.0432 0.04274 0.04227 0.0418 0.04134 0.04167 0.0421 0.04252 0.04295 0.04337 0.0438 0.04422 0.04465 0.04508 0.0455 0.04593 0.04635 0.04678 0.0472 0.04763 0.04805 0.04848 0.04891 0.04933 0.04976 0.05018 0.05061 0.05103 0.05146 0.05188 0.05243 0.05303 0.05362 0.05422 0.05481 0.0554 0.056 0.05659 0.05719 0.05778 0.05837 0.06031 0.06256 0.06322;
0.05476 0.04866 0.04352 0.03924 0.03571 0.03285 0.03058 0.02882 0.02751 0.02661 0.02604 0.02578 0.02577 0.05457 0.0537 0.05283 0.05196 0.05109 0.05022 0.04983 0.04969 0.04955 0.0494 0.04926 0.04912 0.04897 0.04883 0.04869 0.04854 0.0484 0.04826 0.04811 0.04797 0.04783 0.04768 0.04754 0.0474 0.04725 0.04679 0.04632 0.04586 0.0461 0.04652 0.04695 0.04737 0.0478 0.04822 0.04865 0.04907 0.0495 0.04993 0.05035 0.05078 0.0512 0.05163 0.05205 0.05248 0.0529 0.05333 0.05376 0.05418 0.05461 0.05503 0.05546 0.05588 0.05631 0.05673 0.05716 0.05759 0.05801 0.05844 0.05886 0.05929 0.05971 0.06014 0.06056 0.06099 0.06142 0.06184 0.06227 0.06269 0.06312 0.06354 0.06397 0.06444 0.06563;
0.05689 0.05082 0.04572 0.04146 0.03796 0.03512 0.03288 0.03114 0.02986 0.02898 0.02844 0.0282 0.05609 0.05522 0.05435 0.05348 0.05261 0.05184 0.0517 0.05155 0.05141 0.05127 0.05112 0.05098 0.05084 0.05069 0.05055 0.05041 0.05026 0.05012 0.04998 0.04983 0.04969 0.04955 0.0494 0.04926 0.04924 0.0494 0.04955 0.04966 0.04978 0.05007 0.05042 0.05076 0.05111 0.05145 0.0518 0.05217 0.05254 0.0529 0.05327 0.05364 0.05401 0.05437 0.05474 0.05511 0.05547 0.05584 0.05621 0.05658 0.05694 0.05731 0.05768 0.05805 0.05841 0.05878 0.05915 0.05952 0.05988 0.06025 0.06062 0.06099 0.06135 0.06172 0.06209 0.06246 0.06282 0.06319 0.06356 0.06393 0.06429 0.06466 0.06503 0.06539 0.06612 0.06806;
0.05902 0.05297 0.04789 0.04367 0.04019 0.03738 0.03516 0.03346 0.0322 0.03134 0.03083 0.05761 0.05674 0.05587 0.055 0.05414 0.05371 0.05356 0.05342 0.05328 0.05313 0.05299 0.05285 0.0527 0.05256 0.05242 0.05227 0.05213 0.05199 0.05184 0.0517 0.05156 0.05141 0.05142 0.05158 0.05173 0.05189 0.05204 0.0522 0.05236 0.0525 0.05262 0.05273 0.05285 0.05297 0.05308 0.0532 0.05332 0.05361 0.05395 0.0543 0.05464 0.05499 0.05533 0.05567 0.05602 0.05636 0.05671 0.05705 0.05739 0.05774 0.05808 0.05842 0.05877 0.05911 0.05946 0.05983 0.0602 0.06056 0.06093 0.0613 0.06167 0.06203 0.0624 0.06277 0.06314 0.0635 0.06387 0.06424 0.06461 0.06497 0.06534 0.06514 0.06678 0.06856 0.07048;
0.0611 0.05509 0.05004 0.04584 0.04239 0.03961 0.03741 0.03573 0.0345 0.03366 0.05913 0.05826 0.05739 0.05652 0.05571 0.05557 0.05543 0.05528 0.05514 0.055 0.05485 0.05471 0.05457 0.05442 0.05428 0.05414 0.05399 0.05385 0.05371 0.05356 0.05361 0.05376 0.05392 0.05407 0.05423 0.05438 0.05454 0.05469 0.05485 0.055 0.05516 0.05532 0.05545 0.05557 0.05569 0.0558 0.05592 0.05604 0.05616 0.05627 0.05639 0.05651 0.05662 0.05674 0.05686 0.05715 0.05749 0.05783 0.05818 0.05852 0.05887 0.05921 0.05955 0.0599 0.06024 0.06059 0.06093 0.06127 0.06162 0.06196 0.0623 0.06265 0.06299 0.06334 0.06368 0.06402 0.06437 0.06471 0.06506 0.0654 0.0647 0.06608 0.06758 0.0692 0.07096 0.07285;
0.06312 0.05713 0.05211 0.04794 0.04452 0.04176 0.03959 0.03794 0.03673 0.06065 0.05978 0.05891 0.05805 0.05758 0.05743 0.05729 0.05715 0.057 0.05686 0.05672 0.05657 0.05643 0.05629 0.05614 0.056 0.05586 0.05571 0.05579 0.05595 0.0561 0.05626 0.05641 0.05657 0.05672 0.05688 0.05703 0.05719 0.05734 0.0575 0.05765 0.05781 0.05796 0.05812 0.05827 0.05841 0.05852 0.05864 0.05876 0.05888 0.05899 0.05911 0.05923 0.05934 0.05946 0.05958 0.05969 0.05981 0.05993 0.06005 0.06016 0.06028 0.0604 0.06068 0.06103 0.06137 0.06171 0.06206 0.0624 0.06275 0.06309 0.06343 0.06378 0.06412 0.06447 0.06481 0.06515 0.0655 0.06552 0.06473 0.06587 0.06711 0.06847 0.06995 0.07156 0.07329 0.07516;
0.06504 0.05909 0.05409 0.04995 0.04656 0.04383 0.04168 0.04005 0.06217 0.0613 0.06044 0.05958 0.05944 0.0593 0.05915 0.05901 0.05887 0.05872 0.05858 0.05844 0.05829 0.05815 0.05801 0.05786 0.05797 0.05813 0.05828 0.05844 0.05859 0.05875 0.05891 0.05906 0.05922 0.05937 0.05953 0.05968 0.05984 0.05999 0.06015 0.0603 0.06046 0.06061 0.06077 0.06092 0.06108 0.06123 0.06136 0.06148 0.06159 0.06171 0.06183 0.06195 0.06206 0.06218 0.0623 0.06241 0.06253 0.06265 0.06277 0.06288 0.063 0.06312 0.06323 0.06335 0.06347 0.06358 0.0637 0.06382 0.06394 0.06422 0.06456 0.06491 0.06525 0.06552 0.06552 0.06552 0.06518 0.06609 0.0671 0.06821 0.06944 0.07078 0.07224 0.07382 0.07554 0.07738;
0.06685 0.06093 0.05596 0.05184 0.04848 0.04577 0.04366 0.06369 0.06282 0.06196 0.06145 0.06131 0.06116 0.06102 0.06088 0.06073 0.06059 0.06045 0.0603 0.06016 0.06002 0.06016 0.06031 0.06047 0.06062 0.06078 0.06093 0.06109 0.06124 0.0614 0.06155 0.06171 0.06186 0.06202 0.06218 0.06233 0.06249 0.06264 0.0628 0.06295 0.06311 0.06326 0.06342 0.06357 0.06373 0.06388 0.06404 0.06419 0.06431 0.06443 0.06455 0.06467 0.06478 0.0649 0.06502 0.06513 0.06525 0.06537 0.06549 0.0656 0.06572 0.06584 0.06595 0.06607 0.06619 0.0663 0.06642 0.06654 0.06666 0.06677 0.06617 0.06552 0.06552 0.06552 0.06596 0.06666 0.06746 0.06835 0.06934 0.07044 0.07164 0.07296 0.0744 0.07597 0.07766 0.07948;
0.06852 0.06262 0.05768 0.05359 0.05025 0.04758 0.06521 0.06435 0.06348 0.06331 0.06317 0.06303 0.06288 0.06274 0.0626 0.06245 0.06231 0.06218 0.06234 0.0625 0.06265 0.06281 0.06296 0.06312 0.06327 0.06343 0.06358 0.06374 0.06389 0.06405 0.0642 0.06436 0.06451 0.06467 0.06482 0.06498 0.06513 0.06529 0.06545 0.0656 0.06576 0.06591 0.06607 0.06622 0.06638 0.06653 0.06669 0.06684 0.067 0.06715 0.06727 0.06739 0.0675 0.06762 0.06774 0.06785 0.06797 0.06809 0.0682 0.06832 0.06844 0.06856 0.06867 0.06879 0.06891 0.06902 0.06849 0.06778 0.06706 0.06634 0.06563 0.06656 0.067 0.06753 0.06813 0.06882 0.06959 0.07047 0.07144 0.07252 0.0737 0.07501 0.07643 0.07797 0.07964 0.08144;
0.07001 0.06414 0.05924 0.05517 0.05186 0.06674 0.06587 0.06532 0.06518 0.06503 0.06489 0.06475 0.0646 0.06446 0.06437 0.06452 0.06468 0.06483 0.06499 0.06514 0.0653 0.06545 0.06561 0.06577 0.06592 0.06608 0.06623 0.06639 0.06654 0.0667 0.06685 0.06701 0.06716 0.06732 0.06747 0.06763 0.06778 0.06794 0.06809 0.06825 0.06841 0.06856 0.06872 0.06887 0.06903 0.06918 0.06934 0.06949 0.06965 0.0698 0.06996 0.07011 0.07022 0.07034 0.07046 0.07057 0.07069 0.07081 0.07092 0.07104 0.07116 0.07128 0.07082 0.0701 0.06938 0.06867 0.06805 0.06746 0.06771 0.06795 0.06824 0.0686 0.06903 0.06954 0.07013 0.0708 0.07156 0.07242 0.07337 0.07443 0.0756 0.07688 0.07828 0.0798 0.08145 0.08323;
0.07131 0.06548 0.0606 0.05656 0.06826 0.06739 0.06719 0.06704 0.0669 0.06676 0.06661 0.06655 0.06671 0.06686 0.06702 0.06717 0.06733 0.06748 0.06764 0.06779 0.06795 0.0681 0.06826 0.06841 0.06857 0.06872 0.06888 0.06904 0.06919 0.06935 0.0695 0.06966 0.06981 0.06997 0.07012 0.07028 0.07043 0.07059 0.07074 0.0709 0.07105 0.07121 0.07136 0.07152 0.07168 0.07183 0.07199 0.07214 0.0723 0.07245 0.07261 0.07276 0.07292 0.07306 0.07318 0.07329 0.07341 0.07353 0.07314 0.07243 0.07181 0.07122 0.07063 0.07003 0.06944 0.06926 0.06932 0.06944 0.0696 0.06982 0.07011 0.07045 0.07087 0.07136 0.07193 0.07259 0.07333 0.07417 0.07511 0.07615 0.0773 0.07856 0.07994 0.08144 0.08307 0.08483;
0.0724 0.06659 0.06174 0.06978 0.06919 0.06905 0.06891 0.06876 0.06873 0.06889 0.06904 0.0692 0.06936 0.06951 0.06967 0.06982 0.06998 0.07013 0.07029 0.07044 0.0706 0.07075 0.07091 0.07106 0.07122 0.07137 0.07153 0.07168 0.07184 0.072 0.07215 0.07231 0.07246 0.07262 0.07277 0.07293 0.07308 0.07324 0.07339 0.07355 0.0737 0.07386 0.07401 0.07417 0.07432 0.07448 0.07463 0.07479 0.07495 0.0751 0.07526 0.07535 0.07537 0.0754 0.07542 0.07502 0.07444 0.07386 0.07328 0.0727 0.07212 0.07109 0.07101 0.07096 0.07094 0.07096 0.07102 0.07112 0.07127 0.07148 0.07175 0.07209 0.07249 0.07296 0.07352 0.07416 0.07489 0.07571 0.07663 0.07765 0.07878 0.08003 0.08138 0.08286 0.08447 0.08621;
0.07324 0.06746 0.0713 0.07106 0.07091 0.07092 0.07107 0.07123 0.07138 0.07154 0.07169 0.07185 0.072 0.07216 0.07231 0.07247 0.07263 0.07278 0.07294 0.07309 0.07325 0.0734 0.07356 0.07371 0.07387 0.07402 0.07418 0.07433 0.07449 0.07464 0.07479 0.07481 0.07483 0.07485 0.07488 0.0749 0.07492 0.07494 0.07496 0.07498 0.075 0.07502 0.07505 0.07507 0.07509 0.07511 0.07513 0.07515 0.07517 0.0752 0.07522 0.07524 0.07526 0.07532 0.07538 0.07539 0.07325 0.0731 0.07296 0.07282 0.0727 0.07259 0.07251 0.07245 0.07242 0.07242 0.07247 0.07256 0.0727 0.0729 0.07316 0.07348 0.07386 0.07433 0.07487 0.07549 0.0762 0.07701 0.07791 0.07891 0.08002 0.08125 0.08259 0.08405 0.08563 0.08735;
0.07382 0.07306 0.0731 0.07326 0.07341 0.07357 0.07372 0.07388 0.07403 0.07419 0.07425 0.07427 0.07429 0.07431 0.07433 0.07435 0.07438 0.0744 0.07442 0.07444 0.07446 0.07448 0.0745 0.07453 0.07455 0.07457 0.07459 0.07461 0.07463 0.07465 0.07468 0.0747 0.07472 0.07474 0.07476 0.07478 0.0748 0.07483 0.07485 0.07487 0.07489 0.07491 0.07493 0.07495 0.07498 0.075 0.07502 0.07504 0.07506 0.07508 0.0751 0.07515 0.07506 0.07495 0.07481 0.07467 0.07452 0.07436 0.07421 0.07407 0.07394 0.07383 0.07373 0.07366 0.07363 0.07362 0.07366 0.07374 0.07387 0.07405 0.0743 0.0746 0.07498 0.07542 0.07595 0.07656 0.07725 0.07804 0.07892 0.07991 0.081 0.0822 0.08352 0.08496 0.08652 0.08822;
0.07411 0.06839 0.06362 0.0597 0.05653 0.05401 0.05207 0.05064 0.07398 0.07398 0.07398 0.07398 0.07398 0.07398 0.07398 0.07398 0.074 0.07402 0.07403 0.07405 0.07407 0.07409 0.07411 0.07413 0.07415 0.07417 0.07419 0.07421 0.07423 0.07425 0.07427 0.07429 0.07431 0.07433 0.07435 0.07437 0.07439 0.07441 0.07443 0.07445 0.07447 0.07449 0.07451 0.07453 0.07458 0.07467 0.07477 0.0763 0.07631 0.07629 0.07624 0.07616 0.07606 0.07593 0.0758 0.07565 0.07549 0.07534 0.07518 0.07503 0.07489 0.07477 0.07467 0.07459 0.07454 0.07453 0.07456 0.07463 0.07475 0.07492 0.07515 0.07544 0.0758 0.07623 0.07674 0.07733 0.07801 0.07878 0.07965 0.08062 0.08169 0.08287 0.08417 0.08559 0.08713 0.0888;
0.07409 0.0684 0.06366 0.05976 0.05662 0.05413 0.05222 0.05081 0.04986 0.04928 0.04905 0.04911 0.04941 0.04993 0.05062 0.05146 0.05243 0.05349 0.05462 0.05581 0.05704 0.07398 0.07398 0.07398 0.07398 0.07398 0.07398 0.07398 0.07398 0.07398 0.07398 0.07398 0.07398 0.07398 0.07398 0.07398 0.07398 0.07398 0.0741 0.0742 0.07429 0.07439 0.07449 0.0765 0.07669 0.07683 0.07693 0.07698 0.077 0.07697 0.07692 0.07684 0.07674 0.07661 0.07647 0.07632 0.07616 0.076 0.07584 0.07568 0.07554 0.07541 0.0753 0.07521 0.07515 0.07513 0.07515 0.0752 0.07531 0.07547 0.07569 0.07597 0.07631 0.07673 0.07722 0.0778 0.07846 0.07921 0.08006 0.08101 0.08207 0.08323 0.08451 0.0859 0.08743 0.08907;
0.07374 0.06807 0.06336 0.0595 0.05637 0.05391 0.05203 0.05065 0.04972 0.04917 0.04896 0.04904 0.04937 0.0499 0.05062 0.05148 0.05246 0.05354 0.05469 0.0559 0.05715 0.05841 0.05969 0.06096 0.06222 0.06346 0.06467 0.06583 0.06696 0.06803 0.06905 0.07002 0.07093 0.07178 0.07256 0.07398 0.07398 0.07398 0.07507 0.07554 0.07595 0.07631 0.0766 0.07685 0.07704 0.07718 0.07728 0.07733 0.07735 0.07733 0.07727 0.07719 0.07708 0.07696 0.07681 0.07666 0.07649 0.07632 0.07616 0.076 0.07584 0.07571 0.07559 0.07549 0.07543 0.0754 0.0754 0.07545 0.07554 0.07569 0.07589 0.07616 0.07649 0.07689 0.07737 0.07793 0.07858 0.07931 0.08014 0.08107 0.08211 0.08325 0.08451 0.08589 0.08739 0.08901]'; 

% (g/s), engine out NOx emissions indexed vertically by fc_map_spd and
% horizontally by fc_map_trq
fc_nox_map =[2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016;
0.2046 0.1945 0.1867 0.1808 0.1767 0.174 0.1726 0.1722 0.1727 0.1739 0.1758 0.178 0.1807 0.1835 0.1866 0.1897 0.1929 0.196 0.199 0.2019 0.2046 0.2071 0.2093 0.2112 0.2128 0.2141 0.215 0.2156 0.2159 0.2157 0.2151 0.2142 0.2129 0.2112 0.2091 0.2066 0.2038 0.2005 0.1969 0.1929 0.1886 0.1839 0.1789 0.1736 0.168 0.162 0.1558 0.1493 0.1425 0.1355 0.1282 0.1208 0.1131 0.1052 0.09719 0.08899 0.08065 0.07218 0.0636 0.05492 0.04617 0.03734 0.02848 0.01958 0.01066 0.001748 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016 2.22e-016;
0.4937 0.4835 0.4757 0.4698 0.4656 0.4629 0.4614 0.461 0.4615 0.4627 0.4645 0.4668 0.4694 0.4723 0.4753 0.4785 0.4816 0.4848 0.4878 0.4907 0.4934 0.4959 0.4981 0.5 0.5017 0.503 0.504 0.5046 0.5049 0.5048 0.5043 0.5034 0.5021 0.5005 0.4984 0.496 0.4932 0.4901 0.4865 0.4826 0.4784 0.4738 0.4689 0.4636 0.4581 0.4522 0.4461 0.4397 0.433 0.4261 0.419 0.4116 0.4041 0.3963 0.3884 0.3804 0.3721 0.3638 0.3554 0.3468 0.3382 0.3295 0.3208 0.3121 0.3033 0.2946 0.2858 0.2771 0.2685 0.2599 0.2514 0.2431 0.2348 0.2267 0.2187 0.2109 0.2032 0.1958 0.1886 0.1816 0.1748 0.1684 0.1621 0.1562 0.1506 0.1453;
0.6053 0.5951 0.5872 0.5813 0.5771 0.5743 0.5728 0.5724 0.5729 0.5741 0.5758 0.5781 0.5807 0.5836 0.5866 0.5898 0.5929 0.5961 0.5991 0.602 0.6047 0.6072 0.6095 0.6115 0.6131 0.6145 0.6155 0.6162 0.6165 0.6164 0.616 0.6151 0.6139 0.6123 0.6103 0.608 0.6053 0.6022 0.5987 0.5949 0.5907 0.5862 0.5814 0.5762 0.5708 0.565 0.559 0.5527 0.5461 0.5393 0.5323 0.5251 0.5176 0.51 0.5022 0.4943 0.4862 0.478 0.4697 0.4613 0.4528 0.4443 0.4357 0.4271 0.4185 0.41 0.4014 0.3929 0.3844 0.376 0.3677 0.3595 0.3514 0.3434 0.3356 0.328 0.3206 0.3133 0.3063 0.2995 0.293 0.2867 0.2807 0.275 0.2697 0.2646;
0.6532 0.643 0.6351 0.6291 0.6249 0.6221 0.6206 0.6201 0.6206 0.6217 0.6235 0.6257 0.6283 0.6312 0.6342 0.6374 0.6406 0.6437 0.6467 0.6497 0.6524 0.6549 0.6572 0.6592 0.6609 0.6623 0.6633 0.664 0.6644 0.6644 0.664 0.6632 0.662 0.6605 0.6586 0.6563 0.6536 0.6506 0.6472 0.6435 0.6394 0.635 0.6302 0.6252 0.6198 0.6142 0.6082 0.602 0.5956 0.5889 0.582 0.5748 0.5675 0.56 0.5524 0.5445 0.5366 0.5285 0.5204 0.5121 0.5038 0.4954 0.487 0.4786 0.4701 0.4617 0.4533 0.4449 0.4366 0.4284 0.4202 0.4122 0.4043 0.3965 0.3889 0.3815 0.3743 0.3672 0.3604 0.3538 0.3475 0.3414 0.3357 0.3302 0.325 0.3202;
0.6714 0.6611 0.6531 0.6471 0.6429 0.6401 0.6385 0.638 0.6384 0.6396 0.6413 0.6436 0.6462 0.649 0.6521 0.6552 0.6584 0.6615 0.6646 0.6675 0.6703 0.6728 0.6751 0.6771 0.6789 0.6803 0.6814 0.6821 0.6825 0.6825 0.6822 0.6815 0.6804 0.6789 0.677 0.6748 0.6722 0.6693 0.6659 0.6623 0.6583 0.6539 0.6493 0.6443 0.639 0.6335 0.6276 0.6215 0.6152 0.6086 0.6018 0.5948 0.5876 0.5802 0.5727 0.565 0.5572 0.5493 0.5412 0.5331 0.5249 0.5167 0.5084 0.5001 0.4919 0.4836 0.4753 0.4671 0.459 0.451 0.443 0.4352 0.4274 0.4199 0.4124 0.4052 0.3982 0.3913 0.3847 0.3783 0.3722 0.3664 0.3608 0.3555 0.3506 0.346;
0.6738 0.6635 0.6555 0.6494 0.6451 0.6423 0.6407 0.6402 0.6406 0.6417 0.6435 0.6457 0.6483 0.6511 0.6542 0.6573 0.6605 0.6636 0.6667 0.6697 0.6724 0.675 0.6773 0.6794 0.6811 0.6826 0.6837 0.6845 0.6849 0.685 0.6847 0.684 0.683 0.6815 0.6798 0.6776 0.6751 0.6722 0.6689 0.6653 0.6614 0.6572 0.6526 0.6477 0.6425 0.6371 0.6313 0.6253 0.6191 0.6126 0.6059 0.5991 0.592 0.5847 0.5773 0.5697 0.5621 0.5543 0.5464 0.5384 0.5304 0.5223 0.5142 0.506 0.4979 0.4898 0.4817 0.4737 0.4657 0.4578 0.45 0.4424 0.4348 0.4275 0.4202 0.4132 0.4063 0.3997 0.3933 0.3871 0.3812 0.3755 0.3702 0.3652 0.3604 0.356;
0.6675 0.6571 0.649 0.643 0.6386 0.6358 0.6342 0.6336 0.634 0.6351 0.6368 0.639 0.6416 0.6445 0.6475 0.6506 0.6538 0.657 0.6601 0.663 0.6658 0.6684 0.6707 0.6728 0.6746 0.6761 0.6773 0.6781 0.6785 0.6787 0.6784 0.6778 0.6768 0.6754 0.6737 0.6716 0.6691 0.6663 0.6632 0.6597 0.6558 0.6516 0.6472 0.6424 0.6373 0.6319 0.6263 0.6204 0.6143 0.6079 0.6013 0.5945 0.5876 0.5804 0.5731 0.5657 0.5582 0.5505 0.5427 0.5349 0.527 0.5191 0.5111 0.5031 0.4952 0.4872 0.4793 0.4714 0.4636 0.4559 0.4483 0.4408 0.4335 0.4263 0.4192 0.4124 0.4057 0.3993 0.3931 0.3871 0.3814 0.376 0.3708 0.366 0.3615 0.3573;
0.6562 0.6458 0.6377 0.6316 0.6272 0.6243 0.6226 0.6221 0.6224 0.6235 0.6252 0.6274 0.63 0.6328 0.6359 0.639 0.6422 0.6454 0.6485 0.6514 0.6542 0.6568 0.6592 0.6613 0.6631 0.6646 0.6658 0.6667 0.6672 0.6674 0.6672 0.6666 0.6657 0.6644 0.6627 0.6607 0.6583 0.6555 0.6524 0.649 0.6452 0.6411 0.6367 0.632 0.627 0.6218 0.6162 0.6104 0.6044 0.5982 0.5917 0.585 0.5782 0.5712 0.564 0.5567 0.5493 0.5418 0.5342 0.5265 0.5187 0.5109 0.5031 0.4953 0.4875 0.4797 0.4719 0.4642 0.4566 0.4491 0.4416 0.4343 0.4271 0.4201 0.4133 0.4066 0.4002 0.3939 0.3879 0.3821 0.3766 0.3714 0.3665 0.3619 0.3576 0.3537;
0.6421 0.6317 0.6235 0.6174 0.613 0.61 0.6084 0.6078 0.6081 0.6092 0.6109 0.6131 0.6156 0.6185 0.6215 0.6246 0.6278 0.631 0.6341 0.6371 0.6399 0.6425 0.6449 0.647 0.6489 0.6504 0.6517 0.6526 0.6531 0.6533 0.6532 0.6526 0.6518 0.6505 0.6489 0.6469 0.6446 0.6419 0.6389 0.6356 0.6319 0.6279 0.6236 0.619 0.6141 0.6089 0.6035 0.5978 0.5918 0.5857 0.5793 0.5728 0.5661 0.5592 0.5521 0.545 0.5377 0.5303 0.5228 0.5153 0.5077 0.5 0.4923 0.4847 0.477 0.4694 0.4618 0.4543 0.4468 0.4394 0.4322 0.4251 0.4181 0.4112 0.4046 0.3981 0.3918 0.3858 0.38 0.3744 0.3691 0.3641 0.3594 0.355 0.351 0.3472;
0.6267 0.6162 0.608 0.6018 0.5974 0.5944 0.5927 0.5921 0.5924 0.5935 0.5951 0.5973 0.5999 0.6027 0.6057 0.6089 0.6121 0.6152 0.6183 0.6213 0.6242 0.6268 0.6292 0.6314 0.6333 0.6348 0.6361 0.637 0.6376 0.6379 0.6378 0.6373 0.6365 0.6353 0.6338 0.6319 0.6296 0.627 0.6241 0.6208 0.6172 0.6132 0.609 0.6045 0.5997 0.5946 0.5893 0.5837 0.5779 0.5718 0.5656 0.5592 0.5526 0.5458 0.5389 0.5318 0.5247 0.5174 0.5101 0.5027 0.4952 0.4877 0.4802 0.4727 0.4652 0.4577 0.4503 0.4429 0.4356 0.4284 0.4214 0.4144 0.4076 0.401 0.3945 0.3882 0.3821 0.3763 0.3707 0.3653 0.3602 0.3554 0.3509 0.3468 0.3429 0.3394;
0.6107 0.6002 0.5919 0.5857 0.5812 0.5782 0.5765 0.5759 0.5762 0.5772 0.5789 0.581 0.5836 0.5864 0.5894 0.5926 0.5958 0.5989 0.6021 0.6051 0.6079 0.6106 0.613 0.6152 0.6171 0.6187 0.62 0.621 0.6216 0.6219 0.6219 0.6215 0.6207 0.6196 0.6181 0.6162 0.6141 0.6115 0.6086 0.6054 0.6019 0.5981 0.5939 0.5895 0.5848 0.5798 0.5746 0.5691 0.5634 0.5575 0.5513 0.545 0.5385 0.5319 0.5251 0.5182 0.5111 0.504 0.4968 0.4896 0.4822 0.4749 0.4675 0.4602 0.4528 0.4455 0.4382 0.431 0.4239 0.4169 0.41 0.4032 0.3966 0.3901 0.3839 0.3778 0.3719 0.3662 0.3608 0.3557 0.3508 0.3462 0.342 0.338 0.3344 0.3311;
0.5948 0.5842 0.5759 0.5696 0.5651 0.5621 0.5604 0.5597 0.56 0.561 0.5626 0.5648 0.5673 0.5701 0.5731 0.5763 0.5795 0.5827 0.5858 0.5888 0.5917 0.5944 0.5968 0.5991 0.601 0.6026 0.604 0.605 0.6057 0.606 0.606 0.6056 0.6049 0.6038 0.6024 0.6006 0.5985 0.5961 0.5933 0.5901 0.5867 0.5829 0.5789 0.5745 0.5699 0.565 0.5599 0.5545 0.5489 0.5431 0.5371 0.5309 0.5245 0.518 0.5113 0.5045 0.4976 0.5036 0.496 0.4884 0.4809 0.4733 0.4657 0.4581 0.4505 0.443 0.4354 0.4278 0.4202 0.4126 0.4051 0.3975 0.3856 0.3794 0.3733 0.3674 0.3617 0.3562 0.351 0.3461 0.3414 0.337 0.333 0.3292 0.3258 0.3228;
0.5792 0.5686 0.5602 0.554 0.5494 0.5463 0.5446 0.5439 0.5441 0.5451 0.5468 0.5489 0.5514 0.5542 0.5572 0.5604 0.5636 0.5668 0.5699 0.573 0.5759 0.5786 0.581 0.5833 0.5852 0.5869 0.5883 0.5893 0.5901 0.5905 0.5905 0.5902 0.5895 0.5885 0.5871 0.5854 0.5834 0.581 0.5783 0.5752 0.5488 0.5461 0.5434 0.5406 0.5379 0.5351 0.5324 0.5296 0.5269 0.5242 0.5214 0.5187 0.5159 0.5132 0.5104 0.5077 0.5029 0.4953 0.4878 0.4802 0.4726 0.465 0.4574 0.4499 0.4423 0.4347 0.4271 0.4196 0.412 0.4044 0.3968 0.3892 0.3949 0.3689 0.363 0.3573 0.3518 0.3466 0.3416 0.3369 0.3324 0.3282 0.3244 0.3209 0.3177 0.3149;
0.5642 0.5535 0.5452 0.5389 0.5343 0.5312 0.5294 0.5287 0.5289 0.5299 0.5315 0.5336 0.5361 0.5389 0.542 0.5451 0.5483 0.5515 0.5547 0.5577 0.5606 0.5633 0.5658 0.5681 0.5701 0.5718 0.5732 0.5743 0.5751 0.5755 0.5756 0.5753 0.5747 0.5738 0.5725 0.5708 0.5688 0.5496 0.5451 0.5394 0.5331 0.5298 0.5271 0.5243 0.5216 0.5188 0.5161 0.5134 0.5106 0.5079 0.5051 0.5024 0.4997 0.4969 0.4942 0.4914 0.4887 0.4859 0.4795 0.4719 0.4644 0.4568 0.4492 0.4416 0.434 0.4265 0.4189 0.4113 0.4037 0.3961 0.3886 0.381 0.3866 0.3591 0.3534 0.3479 0.3426 0.3376 0.3328 0.3282 0.324 0.32 0.3164 0.3131 0.3101 0.3075;
0.55 0.5393 0.5309 0.5245 0.5199 0.5168 0.5149 0.5142 0.5144 0.5154 0.517 0.5191 0.5216 0.5244 0.5274 0.5305 0.5338 0.537 0.5401 0.5432 0.5461 0.5488 0.5514 0.5537 0.5557 0.5574 0.5589 0.56 0.5608 0.5613 0.5614 0.5612 0.5607 0.5598 0.5585 0.5569 0.5446 0.5437 0.5391 0.5346 0.5297 0.5235 0.5172 0.511 0.5053 0.5026 0.4998 0.4971 0.4943 0.4916 0.4889 0.4861 0.4834 0.4806 0.4779 0.4751 0.4724 0.4697 0.4669 0.4637 0.4561 0.4485 0.441 0.4334 0.4258 0.4182 0.4106 0.4031 0.3955 0.3879 0.3803 0.3727 0.3784 0.3907 0.3445 0.3392 0.3341 0.3293 0.3247 0.3203 0.3163 0.3126 0.3091 0.306 0.3033 0.3009;
0.5366 0.5258 0.5174 0.511 0.5063 0.5032 0.5013 0.5006 0.5007 0.5017 0.5033 0.5054 0.5079 0.5107 0.5137 0.5168 0.52 0.5232 0.5264 0.5295 0.5324 0.5352 0.5377 0.54 0.5421 0.5439 0.5454 0.5465 0.5474 0.5479 0.5481 0.5479 0.5474 0.5466 0.5454 0.5396 0.5386 0.5377 0.5332 0.5286 0.524 0.5194 0.5138 0.5076 0.5013 0.4951 0.4888 0.4826 0.4781 0.4753 0.4726 0.4698 0.4671 0.4644 0.4616 0.4589 0.4561 0.4534 0.4506 0.4479 0.4452 0.4403 0.4327 0.4251 0.4175 0.41 0.4024 0.3948 0.3872 0.3796 0.3721 0.3645 0.3701 0.3824 0.3365 0.3314 0.3265 0.3218 0.3174 0.3133 0.3094 0.3059 0.3027 0.2998 0.2973 0.2952;
0.524 0.5132 0.5048 0.4983 0.4936 0.4904 0.4886 0.4878 0.4879 0.4889 0.4904 0.4925 0.495 0.4978 0.5008 0.5039 0.5072 0.5104 0.5136 0.5167 0.5196 0.5224 0.525 0.5273 0.5294 0.5312 0.5327 0.5339 0.5348 0.5354 0.5356 0.5355 0.535 0.5343 0.5345 0.5336 0.5327 0.5318 0.5272 0.5226 0.5181 0.5135 0.5089 0.5041 0.4979 0.4916 0.4854 0.4792 0.4729 0.4667 0.4604 0.4542 0.4508 0.4481 0.4453 0.4426 0.4398 0.4371 0.4344 0.4316 0.4289 0.4261 0.4234 0.4169 0.4093 0.4017 0.3941 0.3866 0.379 0.3714 0.3638 0.3562 0.3619 0.3742 0.3865 0.3243 0.3196 0.3152 0.311 0.3071 0.3034 0.3001 0.2971 0.2945 0.2922 0.2903;
0.5124 0.5015 0.493 0.4865 0.4818 0.4786 0.4767 0.4759 0.476 0.4769 0.4785 0.4805 0.483 0.4858 0.4888 0.4919 0.4952 0.4984 0.5016 0.5047 0.5077 0.5105 0.513 0.5154 0.5175 0.5194 0.5209 0.5222 0.5231 0.5237 0.524 0.5239 0.5235 0.5295 0.5286 0.5276 0.5267 0.5258 0.5213 0.5167 0.5121 0.5075 0.5029 0.4984 0.4938 0.4882 0.482 0.4757 0.4695 0.4632 0.457 0.4508 0.4445 0.4383 0.432 0.4263 0.4236 0.4208 0.4181 0.4153 0.4126 0.4099 0.4071 0.4044 0.401 0.3935 0.3859 0.3783 0.3707 0.3632 0.3556 0.348 0.3536 0.3659 0.3782 0.3182 0.3137 0.3094 0.3054 0.3017 0.2983 0.2952 0.2924 0.29 0.2879 0.2862;
0.5016 0.4907 0.4821 0.4756 0.4708 0.4676 0.4657 0.4648 0.4649 0.4658 0.4674 0.4694 0.4719 0.4747 0.4777 0.4808 0.484 0.4873 0.4905 0.4936 0.4966 0.4994 0.502 0.5044 0.5065 0.5084 0.51 0.5113 0.5123 0.5129 0.5132 0.5132 0.5244 0.5235 0.5226 0.5217 0.5208 0.5199 0.5153 0.5107 0.5062 0.5016 0.497 0.4924 0.4878 0.4832 0.4786 0.4723 0.4661 0.4598 0.4536 0.4473 0.4411 0.4348 0.4286 0.4224 0.4161 0.4099 0.4036 0.3991 0.3963 0.3936 0.3908 0.3881 0.3854 0.3826 0.3776 0.3701 0.3625 0.3549 0.3473 0.3397 0.3454 0.3577 0.37 0.3823 0.3086 0.3046 0.3008 0.2973 0.2941 0.2912 0.2886 0.2864 0.2845 0.283;
0.4916 0.4807 0.4721 0.4655 0.4607 0.4574 0.4555 0.4546 0.4547 0.4556 0.4571 0.4591 0.4616 0.4644 0.4674 0.4705 0.4737 0.477 0.4802 0.4833 0.4863 0.4892 0.4918 0.4942 0.4964 0.4983 0.4999 0.5012 0.5023 0.503 0.5033 0.5194 0.5185 0.5176 0.5166 0.5157 0.5148 0.5139 0.5094 0.5048 0.5002 0.4956 0.491 0.4864 0.4819 0.4773 0.4727 0.4681 0.4626 0.4564 0.4502 0.4439 0.4377 0.4314 0.4252 0.4189 0.4127 0.4064 0.4002 0.394 0.3877 0.3815 0.3752 0.3718 0.3691 0.3663 0.3636 0.3608 0.3542 0.3467 0.3391 0.3315 0.3371 0.3494 0.3617 0.374 0.3044 0.3005 0.2969 0.2936 0.2906 0.288 0.2856 0.2836 0.282 0.2807;
0.4824 0.4715 0.4628 0.4562 0.4514 0.4481 0.4461 0.4452 0.4453 0.4461 0.4476 0.4497 0.4521 0.4549 0.4579 0.461 0.4643 0.4675 0.4707 0.4739 0.4769 0.4798 0.4824 0.4849 0.4871 0.489 0.4907 0.492 0.4931 0.4938 0.5143 0.5134 0.5125 0.5116 0.5107 0.5098 0.5089 0.508 0.5034 0.4988 0.4942 0.4897 0.4851 0.4805 0.4759 0.4713 0.4667 0.4622 0.4576 0.453 0.4467 0.4405 0.4342 0.428 0.4218 0.4155 0.4093 0.403 0.3968 0.3905 0.3843 0.378 0.3718 0.3656 0.3593 0.3531 0.3473 0.3446 0.3418 0.3384 0.3308 0.3232 0.3289 0.3412 0.3535 0.3658 0.3781 0.2973 0.2939 0.2908 0.288 0.2856 0.2834 0.2816 0.2802 0.2792;
0.4741 0.463 0.4544 0.4477 0.4429 0.4395 0.4375 0.4366 0.4366 0.4375 0.439 0.441 0.4434 0.4462 0.4492 0.4523 0.4556 0.4588 0.462 0.4652 0.4682 0.4711 0.4738 0.4763 0.4785 0.4805 0.4822 0.4836 0.4847 0.5093 0.5084 0.5075 0.5066 0.5056 0.5047 0.5038 0.5029 0.502 0.4975 0.4929 0.4883 0.4837 0.4791 0.4745 0.47 0.4654 0.4608 0.4562 0.4516 0.447 0.4425 0.4371 0.4308 0.4246 0.4183 0.4121 0.4058 0.3996 0.3934 0.3871 0.3809 0.3746 0.3684 0.3621 0.3559 0.3496 0.3434 0.3372 0.3309 0.3247 0.3201 0.315 0.3206 0.3329 0.3452 0.3575 0.3698 0.2949 0.2917 0.2888 0.2862 0.2839 0.282 0.2804 0.2793 0.2784;
0.4664 0.4553 0.4466 0.4399 0.435 0.4317 0.4296 0.4287 0.4287 0.4295 0.431 0.433 0.4354 0.4382 0.4412 0.4443 0.4476 0.4508 0.4541 0.4572 0.4603 0.4632 0.4659 0.4684 0.4707 0.4727 0.4744 0.4758 0.5042 0.5033 0.5024 0.5015 0.5006 0.4997 0.4988 0.4979 0.497 0.496 0.4915 0.4869 0.4823 0.4778 0.4732 0.4686 0.464 0.4594 0.4548 0.4503 0.4457 0.4411 0.4365 0.4319 0.4273 0.4212 0.4149 0.4087 0.4024 0.3962 0.3899 0.3837 0.3774 0.3712 0.365 0.3587 0.3525 0.3462 0.34 0.3339 0.3282 0.3225 0.3167 0.311 0.3124 0.3247 0.337 0.3493 0.3616 0.3738 0.2902 0.2875 0.2851 0.283 0.2813 0.28 0.279 0.2784;
0.4594 0.4483 0.4395 0.4328 0.4279 0.4245 0.4224 0.4215 0.4215 0.4223 0.4237 0.4257 0.4281 0.4309 0.4339 0.437 0.4403 0.4435 0.4468 0.45 0.453 0.456 0.4587 0.4612 0.4635 0.4655 0.4673 0.4992 0.4983 0.4974 0.4965 0.4956 0.4946 0.4937 0.4928 0.4919 0.491 0.4901 0.4855 0.481 0.4764 0.4718 0.4672 0.4626 0.458 0.4535 0.4489 0.4443 0.4397 0.4351 0.4305 0.426 0.4214 0.4168 0.4115 0.4052 0.399 0.3928 0.3866 0.3809 0.3752 0.3695 0.3638 0.3581 0.3524 0.3467 0.341 0.3353 0.3296 0.3239 0.3182 0.3124 0.3109 0.3164 0.3287 0.341 0.3533 0.3656 0.2893 0.2868 0.2847 0.2828 0.2813 0.2802 0.2794 0.2791;
0.4531 0.4419 0.4331 0.4264 0.4214 0.418 0.4159 0.4149 0.4149 0.4156 0.4171 0.4191 0.4215 0.4242 0.4272 0.4304 0.4336 0.4369 0.4401 0.4433 0.4464 0.4494 0.4521 0.4547 0.457 0.459 0.4941 0.4932 0.4923 0.4914 0.4905 0.4896 0.4887 0.4878 0.4869 0.486 0.485 0.4841 0.4796 0.475 0.4704 0.4658 0.4613 0.4567 0.4521 0.4475 0.4429 0.4383 0.4338 0.4293 0.4252 0.4211 0.417 0.4129 0.4088 0.4047 0.3995 0.3938 0.3881 0.3823 0.3766 0.3709 0.3652 0.3595 0.3538 0.3481 0.3424 0.3367 0.331 0.3253 0.3196 0.3138 0.3123 0.3129 0.3205 0.3328 0.3451 0.3574 0.3696 0.2868 0.2849 0.2832 0.2819 0.281 0.2805 0.2804;
0.4473 0.4361 0.4273 0.4205 0.4155 0.412 0.4099 0.4089 0.4088 0.4096 0.411 0.413 0.4154 0.4181 0.4211 0.4243 0.4275 0.4308 0.4341 0.4373 0.4404 0.4433 0.4461 0.4487 0.451 0.4891 0.4882 0.4873 0.4864 0.4855 0.4846 0.4836 0.4827 0.4818 0.4809 0.48 0.4791 0.4782 0.4736 0.4691 0.4645 0.4604 0.4563 0.4522 0.4481 0.4441 0.44 0.4359 0.4318 0.4277 0.4236 0.4195 0.4154 0.4113 0.4073 0.4032 0.3991 0.395 0.3895 0.3838 0.378 0.3723 0.3666 0.3609 0.3552 0.3495 0.3438 0.3381 0.3324 0.3267 0.321 0.3153 0.3137 0.3143 0.3148 0.3245 0.3368 0.3491 0.3614 0.2874 0.2856 0.2842 0.2832 0.2825 0.2821 0.2822;
0.4421 0.4308 0.422 0.4151 0.4101 0.4066 0.4044 0.4034 0.4033 0.4041 0.4055 0.4074 0.4098 0.4126 0.4155 0.4187 0.422 0.4252 0.4285 0.4318 0.4349 0.4378 0.4406 0.4432 0.4841 0.4831 0.4822 0.4813 0.4804 0.4795 0.4786 0.4777 0.4768 0.4759 0.475 0.474 0.4731 0.4745 0.4668 0.4644 0.4626 0.4588 0.4548 0.4507 0.4466 0.4425 0.4384 0.4343 0.4302 0.4261 0.422 0.418 0.4139 0.4098 0.4057 0.4016 0.3975 0.3934 0.3893 0.3852 0.3795 0.3737 0.368 0.3623 0.3566 0.3509 0.3452 0.3395 0.3338 0.3281 0.3224 0.3167 0.3151 0.3157 0.3162 0.3168 0.3286 0.3409 0.3531 0.3654 0.287 0.2857 0.2849 0.2844 0.2843 0.2846;
0.4373 0.426 0.4171 0.4103 0.4052 0.4017 0.3995 0.3984 0.3983 0.399 0.4004 0.4024 0.4048 0.4075 0.4105 0.4136 0.4169 0.4202 0.4235 0.4267 0.4298 0.4328 0.4357 0.479 0.4781 0.4772 0.4763 0.4754 0.4745 0.4736 0.4726 0.4717 0.4708 0.4699 0.469 0.4692 0.4706 0.4721 0.4644 0.4566 0.45 0.4483 0.4466 0.4449 0.4432 0.4409 0.4368 0.4327 0.4287 0.4246 0.4205 0.4164 0.4123 0.4082 0.4041 0.4 0.3959 0.3919 0.3878 0.3837 0.3796 0.3752 0.3694 0.3637 0.358 0.3523 0.3466 0.3409 0.3352 0.3295 0.3238 0.3181 0.3165 0.3171 0.3176 0.3182 0.3203 0.3326 0.3449 0.3572 0.2888 0.2878 0.2871 0.2869 0.287 0.2875;
0.433 0.4217 0.4127 0.4058 0.4007 0.3972 0.3949 0.3939 0.3937 0.3945 0.3958 0.3978 0.4001 0.4029 0.4058 0.409 0.4122 0.4156 0.4189 0.4221 0.4252 0.4283 0.474 0.4731 0.4721 0.4712 0.4703 0.4694 0.4685 0.4676 0.4667 0.4658 0.4649 0.464 0.4652 0.4667 0.4681 0.4696 0.4619 0.4541 0.4463 0.4385 0.434 0.4323 0.4306 0.4289 0.4272 0.4255 0.4238 0.4221 0.4189 0.4148 0.4107 0.4066 0.4026 0.3985 0.3944 0.3903 0.3862 0.3821 0.378 0.3739 0.3698 0.3651 0.3594 0.3537 0.348 0.3423 0.3366 0.3309 0.3252 0.3195 0.3179 0.3185 0.319 0.3196 0.3202 0.3244 0.3366 0.3489 0.3612 0.2902 0.2898 0.2897 0.2901 0.2908;
0.4291 0.4177 0.4087 0.4018 0.3966 0.393 0.3908 0.3897 0.3896 0.3902 0.3916 0.3935 0.3959 0.3986 0.4016 0.4047 0.408 0.4113 0.4146 0.4179 0.421 0.4689 0.468 0.4671 0.4662 0.4653 0.4644 0.4635 0.4626 0.4616 0.4607 0.4598 0.4599 0.4613 0.4628 0.4642 0.4657 0.4671 0.4594 0.4516 0.4438 0.436 0.4282 0.4205 0.418 0.4163 0.4146 0.4129 0.4112 0.4095 0.4078 0.4061 0.4044 0.4027 0.401 0.3969 0.3928 0.3887 0.3846 0.3805 0.3764 0.3724 0.3683 0.3642 0.3601 0.3551 0.3494 0.3437 0.338 0.3323 0.3266 0.3209 0.3193 0.3199 0.3205 0.321 0.3216 0.3221 0.3284 0.3407 0.353 0.293 0.2928 0.293 0.2936 0.2946;
0.4255 0.4141 0.405 0.3981 0.3929 0.3893 0.387 0.3859 0.3857 0.3864 0.3877 0.3896 0.392 0.3947 0.3977 0.4008 0.4041 0.4074 0.4107 0.414 0.4639 0.463 0.4621 0.4611 0.4602 0.4593 0.4584 0.4575 0.4566 0.4557 0.4548 0.4559 0.4574 0.4588 0.4603 0.4617 0.4632 0.4646 0.4569 0.4491 0.4413 0.4336 0.4258 0.418 0.4102 0.4037 0.402 0.4003 0.3986 0.3968 0.3951 0.3934 0.3917 0.39 0.3883 0.3866 0.3849 0.3832 0.3815 0.379 0.3749 0.3708 0.3667 0.3626 0.3585 0.3544 0.3503 0.3451 0.3394 0.3337 0.328 0.3223 0.3207 0.3213 0.3219 0.3224 0.323 0.3235 0.3241 0.3324 0.3447 0.357 0.2962 0.2966 0.2974 0.2986;
0.4222 0.4107 0.4017 0.3946 0.3894 0.3858 0.3835 0.3823 0.3821 0.3828 0.3841 0.386 0.3884 0.3911 0.394 0.3972 0.4005 0.4038 0.4071 0.4588 0.4579 0.457 0.4561 0.4552 0.4543 0.4534 0.4525 0.4516 0.4506 0.4505 0.452 0.4534 0.4549 0.4563 0.4578 0.4592 0.4607 0.4621 0.4544 0.4467 0.4389 0.4311 0.4233 0.4155 0.4077 0.3999 0.3921 0.3876 0.3859 0.3842 0.3825 0.3808 0.3791 0.3774 0.3757 0.374 0.3723 0.3706 0.3689 0.3672 0.3655 0.3638 0.3621 0.3604 0.357 0.3529 0.3488 0.3447 0.3406 0.3351 0.3294 0.3237 0.3222 0.3227 0.3233 0.3238 0.3244 0.3249 0.3255 0.3261 0.3365 0.3488 0.2999 0.3005 0.3015 0.3029;
0.4192 0.4077 0.3985 0.3915 0.3862 0.3825 0.3802 0.379 0.3788 0.3795 0.3808 0.3827 0.385 0.3877 0.3907 0.3938 0.3971 0.4004 0.4538 0.4529 0.452 0.4511 0.4501 0.4492 0.4483 0.4474 0.4465 0.4456 0.4466 0.4481 0.4495 0.451 0.4524 0.4539 0.4553 0.4568 0.4582 0.4597 0.452 0.4442 0.4364 0.4286 0.4208 0.413 0.4052 0.3974 0.3896 0.3819 0.3741 0.3716 0.3699 0.3682 0.3665 0.3648 0.3631 0.3614 0.3597 0.358 0.3563 0.3546 0.3529 0.3512 0.3495 0.3478 0.3461 0.3444 0.3427 0.341 0.339 0.3349 0.3308 0.3251 0.3236 0.3241 0.3247 0.3252 0.3258 0.3263 0.3269 0.3275 0.3282 0.3405 0.3528 0.3046 0.3059 0.3075;
0.4163 0.4048 0.3956 0.3885 0.3832 0.3795 0.3772 0.376 0.3757 0.3763 0.3776 0.3795 0.3818 0.3845 0.3875 0.3906 0.3939 0.4487 0.4478 0.4469 0.446 0.4451 0.4442 0.4433 0.4424 0.4415 0.4412 0.4427 0.4441 0.4456 0.447 0.4485 0.4499 0.4514 0.4528 0.4543 0.4557 0.4572 0.4495 0.4417 0.4339 0.4261 0.4183 0.4105 0.4027 0.395 0.3872 0.3794 0.3716 0.3638 0.3573 0.3556 0.3539 0.3522 0.3505 0.3488 0.3471 0.3454 0.3437 0.342 0.3403 0.3386 0.3369 0.3352 0.3335 0.3317 0.33 0.3283 0.3266 0.3249 0.3237 0.3243 0.325 0.3255 0.3261 0.3266 0.3272 0.3278 0.3283 0.3289 0.3294 0.3323 0.3446 0.309 0.3105 0.3123;
0.4136 0.402 0.3928 0.3857 0.3804 0.3767 0.3743 0.373 0.3728 0.3734 0.3747 0.3765 0.3788 0.3815 0.3845 0.3876 0.4437 0.4428 0.4419 0.441 0.4401 0.4391 0.4382 0.4373 0.4364 0.4373 0.4388 0.4402 0.4417 0.4431 0.4446 0.446 0.4475 0.4489 0.4504 0.4518 0.4533 0.4547 0.447 0.4392 0.4314 0.4236 0.4158 0.4081 0.4003 0.3925 0.3847 0.3769 0.3691 0.3613 0.3535 0.3457 0.3413 0.3396 0.3379 0.3362 0.3345 0.3328 0.331 0.3293 0.3276 0.3259 0.3242 0.3225 0.3212 0.3218 0.3224 0.3231 0.3237 0.3243 0.3249 0.3256 0.3262 0.3268 0.3275 0.328 0.3286 0.3292 0.3297 0.3303 0.3308 0.3314 0.3363 0.3135 0.3152 0.3173;
0.4111 0.3994 0.3902 0.383 0.3777 0.3739 0.3715 0.3702 0.37 0.3705 0.3718 0.3737 0.376 0.3786 0.3816 0.4387 0.4377 0.4368 0.4359 0.435 0.4341 0.4332 0.4323 0.4319 0.4334 0.4348 0.4363 0.4377 0.4392 0.4406 0.4421 0.4435 0.445 0.4464 0.4479 0.4493 0.4508 0.4522 0.4445 0.4367 0.429 0.4212 0.4134 0.4056 0.3978 0.39 0.3822 0.3744 0.3666 0.3588 0.351 0.3433 0.3355 0.3277 0.3252 0.3235 0.3218 0.3201 0.3186 0.3193 0.3199 0.3205 0.3211 0.3218 0.3224 0.323 0.3237 0.3243 0.3249 0.3255 0.3262 0.3268 0.3274 0.3281 0.3287 0.3293 0.3299 0.3306 0.3311 0.3317 0.3322 0.3328 0.3334 0.3404 0.32 0.3224;
0.4086 0.3969 0.3876 0.3804 0.375 0.3712 0.3688 0.3675 0.3672 0.3678 0.369 0.3709 0.3732 0.3758 0.4336 0.4327 0.4318 0.4309 0.43 0.4291 0.4281 0.4272 0.428 0.4295 0.4309 0.4324 0.4338 0.4353 0.4367 0.4382 0.4396 0.4411 0.4425 0.444 0.4454 0.4469 0.4483 0.4498 0.4421 0.4343 0.4265 0.4187 0.4109 0.4031 0.3953 0.3875 0.3797 0.3719 0.3641 0.3564 0.3486 0.3408 0.333 0.3312 0.3293 0.3274 0.3256 0.3237 0.3218 0.3205 0.3211 0.3217 0.3224 0.323 0.3236 0.3243 0.3249 0.3255 0.3261 0.3268 0.3274 0.328 0.3286 0.3293 0.3299 0.3305 0.3312 0.3318 0.3324 0.333 0.3336 0.3342 0.3348 0.3353 0.325 0.3275;
0.4062 0.3944 0.3851 0.3779 0.3725 0.3686 0.3661 0.3648 0.3645 0.3651 0.3663 0.3681 0.3704 0.4286 0.4277 0.4267 0.4258 0.4249 0.424 0.4231 0.4226 0.4241 0.4255 0.427 0.4284 0.4299 0.4313 0.4328 0.4342 0.4357 0.4371 0.4386 0.44 0.4415 0.4429 0.4444 0.4458 0.4473 0.4396 0.4318 0.424 0.4162 0.4084 0.4006 0.3928 0.385 0.3773 0.3748 0.3729 0.371 0.3692 0.3673 0.3654 0.3636 0.3617 0.3598 0.358 0.3561 0.3542 0.3523 0.3505 0.3486 0.3467 0.3449 0.343 0.3411 0.3393 0.3374 0.3355 0.3337 0.3318 0.3299 0.3299 0.3305 0.3311 0.3318 0.3324 0.333 0.3336 0.3343 0.3349 0.3355 0.3362 0.3367 0.3373 0.3327;
0.4037 0.392 0.3826 0.3753 0.3699 0.366 0.3635 0.3622 0.3618 0.3623 0.3636 0.3654 0.3677 0.4226 0.4217 0.4208 0.4199 0.419 0.4181 0.4187 0.4202 0.4216 0.4231 0.4245 0.426 0.4274 0.4289 0.4303 0.4317 0.4332 0.4346 0.4361 0.4375 0.439 0.4404 0.4419 0.4433 0.4448 0.4371 0.4293 0.4215 0.4184 0.4165 0.4147 0.4128 0.4109 0.4091 0.4072 0.4053 0.4035 0.4016 0.3997 0.3978 0.396 0.3941 0.3922 0.3904 0.3885 0.3866 0.3848 0.3829 0.381 0.3791 0.3773 0.3754 0.3735 0.3717 0.3698 0.3679 0.3661 0.3642 0.3623 0.3605 0.3586 0.3567 0.3548 0.353 0.3511 0.3492 0.3474 0.3455 0.3436 0.3418 0.3399 0.3386 0.3379;
0.4013 0.3895 0.38 0.3727 0.3672 0.3633 0.3608 0.3595 0.3591 0.3596 0.3608 0.3626 0.4176 0.4167 0.4157 0.4148 0.4139 0.4133 0.4148 0.4162 0.4177 0.4191 0.4206 0.422 0.4235 0.4249 0.4264 0.4278 0.4293 0.4307 0.4322 0.4336 0.4351 0.4365 0.438 0.4394 0.4403 0.4403 0.44 0.4372 0.4344 0.4321 0.4301 0.428 0.4259 0.4239 0.4218 0.4196 0.4174 0.4151 0.4129 0.4107 0.4085 0.4063 0.4041 0.4019 0.3997 0.3975 0.3953 0.3931 0.3909 0.3887 0.3865 0.3843 0.382 0.3798 0.3776 0.3754 0.3732 0.371 0.3688 0.3666 0.3644 0.3622 0.36 0.3578 0.3556 0.3534 0.3512 0.349 0.3467 0.3445 0.3423 0.3401 0.3399 0.3431;
0.3987 0.3869 0.3774 0.3701 0.3646 0.3606 0.3581 0.3567 0.3563 0.3568 0.358 0.4125 0.4116 0.4107 0.4098 0.4089 0.4094 0.4108 0.4123 0.4137 0.4152 0.4166 0.4181 0.4195 0.421 0.4224 0.4239 0.4253 0.4268 0.4282 0.4297 0.4311 0.4326 0.4333 0.4334 0.4334 0.4335 0.4335 0.4336 0.4336 0.4328 0.43 0.4272 0.4244 0.4216 0.4188 0.4159 0.4131 0.4109 0.4088 0.4068 0.4047 0.4026 0.4006 0.3985 0.3964 0.3944 0.3923 0.3902 0.3882 0.3861 0.384 0.382 0.3799 0.3779 0.3758 0.3735 0.3713 0.3691 0.3669 0.3647 0.3625 0.3603 0.3581 0.3559 0.3537 0.3515 0.3493 0.3471 0.3449 0.3427 0.3405 0.3392 0.3418 0.3448 0.3482;
0.3961 0.3842 0.3747 0.3673 0.3618 0.3578 0.3552 0.3538 0.3534 0.3539 0.4075 0.4066 0.4057 0.4047 0.404 0.4055 0.4069 0.4084 0.4098 0.4113 0.4127 0.4142 0.4156 0.4171 0.4185 0.42 0.4214 0.4229 0.4243 0.4258 0.4263 0.4264 0.4264 0.4265 0.4265 0.4266 0.4266 0.4267 0.4267 0.4268 0.4268 0.4269 0.4257 0.4228 0.42 0.4172 0.4144 0.4116 0.4088 0.406 0.4032 0.4003 0.3975 0.3947 0.3919 0.3897 0.3876 0.3855 0.3835 0.3814 0.3793 0.3773 0.3752 0.3731 0.3711 0.369 0.3669 0.3649 0.3628 0.3607 0.3587 0.3566 0.3546 0.3525 0.3504 0.3484 0.3463 0.3442 0.3422 0.3401 0.3392 0.3412 0.3435 0.3463 0.3495 0.3532;
0.3933 0.3814 0.3719 0.3644 0.3588 0.3548 0.3522 0.3508 0.3504 0.4024 0.4015 0.4006 0.3997 0.4001 0.4015 0.403 0.4044 0.4059 0.4073 0.4088 0.4102 0.4117 0.4131 0.4146 0.416 0.4175 0.4189 0.4194 0.4194 0.4195 0.4195 0.4196 0.4196 0.4197 0.4197 0.4198 0.4198 0.4199 0.4199 0.42 0.42 0.4201 0.4201 0.4202 0.4185 0.4157 0.4129 0.4101 0.4072 0.4044 0.4016 0.3988 0.396 0.3932 0.3904 0.3876 0.3847 0.3819 0.3791 0.3763 0.3735 0.3707 0.3684 0.3664 0.3643 0.3622 0.3602 0.3581 0.356 0.354 0.3519 0.3498 0.3478 0.3457 0.3436 0.3416 0.3395 0.3394 0.3398 0.3412 0.343 0.3452 0.3477 0.3507 0.3542 0.3581;
0.3904 0.3784 0.3688 0.3614 0.3557 0.3517 0.3491 0.3476 0.3974 0.3965 0.3956 0.3947 0.3962 0.3976 0.3991 0.4005 0.402 0.4034 0.4049 0.4063 0.4078 0.4092 0.4107 0.4121 0.4124 0.4124 0.4125 0.4125 0.4126 0.4126 0.4127 0.4127 0.4128 0.4128 0.4129 0.4129 0.413 0.413 0.4131 0.4131 0.4132 0.4132 0.4133 0.4133 0.4134 0.4134 0.4113 0.4085 0.4057 0.4029 0.4001 0.3973 0.3945 0.3916 0.3888 0.386 0.3832 0.3804 0.3776 0.3748 0.372 0.3691 0.3663 0.3635 0.3607 0.3579 0.3551 0.3523 0.3494 0.3472 0.3451 0.3431 0.341 0.3394 0.3394 0.3394 0.3409 0.3418 0.343 0.3446 0.3466 0.349 0.3518 0.355 0.3586 0.3628;
0.3873 0.3752 0.3656 0.3581 0.3524 0.3484 0.3457 0.3923 0.3914 0.3905 0.3908 0.3922 0.3937 0.3951 0.3966 0.398 0.3995 0.4009 0.4024 0.4038 0.4053 0.4054 0.4054 0.4055 0.4056 0.4056 0.4057 0.4057 0.4058 0.4058 0.4059 0.4059 0.406 0.406 0.4061 0.4061 0.4062 0.4062 0.4063 0.4063 0.4064 0.4064 0.4065 0.4065 0.4066 0.4066 0.4067 0.4067 0.4042 0.4014 0.3986 0.3957 0.3929 0.3901 0.3873 0.3845 0.3817 0.3789 0.376 0.3732 0.3704 0.3676 0.3648 0.362 0.3592 0.3564 0.3535 0.3507 0.3479 0.3451 0.3421 0.3394 0.3394 0.3394 0.3423 0.3427 0.3435 0.3446 0.346 0.3478 0.35 0.3526 0.3556 0.359 0.3629 0.3673;
0.3839 0.3718 0.3622 0.3546 0.3489 0.3448 0.3873 0.3864 0.3855 0.3869 0.3883 0.3898 0.3912 0.3927 0.3941 0.3956 0.397 0.3984 0.3984 0.3985 0.3985 0.3986 0.3986 0.3987 0.3987 0.3988 0.3988 0.3989 0.3989 0.399 0.399 0.3991 0.3991 0.3992 0.3992 0.3993 0.3993 0.3994 0.3994 0.3995 0.3995 0.3996 0.3996 0.3997 0.3997 0.3998 0.3998 0.3999 0.3999 0.3998 0.397 0.3942 0.3914 0.3886 0.3858 0.383 0.3801 0.3773 0.3745 0.3717 0.3689 0.3661 0.3633 0.3604 0.3576 0.3548 0.3519 0.3489 0.3459 0.3428 0.3398 0.3441 0.3439 0.3439 0.3443 0.3449 0.3458 0.3471 0.3488 0.3508 0.3532 0.356 0.3592 0.3629 0.367 0.3715;
0.3803 0.3682 0.3585 0.3509 0.3452 0.3822 0.3813 0.3815 0.3829 0.3844 0.3858 0.3873 0.3887 0.3902 0.3914 0.3914 0.3915 0.3915 0.3916 0.3916 0.3917 0.3917 0.3918 0.3918 0.3919 0.3919 0.392 0.392 0.3921 0.3921 0.3922 0.3922 0.3923 0.3924 0.3924 0.3925 0.3925 0.3926 0.3926 0.3927 0.3927 0.3928 0.3928 0.3929 0.3929 0.393 0.393 0.3931 0.3931 0.3932 0.3932 0.3927 0.3899 0.387 0.3842 0.3814 0.3786 0.3758 0.373 0.3702 0.3674 0.3645 0.3616 0.3586 0.3556 0.3526 0.35 0.3475 0.347 0.3462 0.3456 0.3453 0.3453 0.3455 0.346 0.3468 0.348 0.3494 0.3513 0.3535 0.3561 0.3591 0.3626 0.3664 0.3708 0.3756;
0.3764 0.3642 0.3545 0.3468 0.3772 0.3763 0.3775 0.379 0.3804 0.3819 0.3833 0.3844 0.3845 0.3845 0.3846 0.3846 0.3847 0.3847 0.3848 0.3848 0.3849 0.3849 0.385 0.385 0.3851 0.3851 0.3852 0.3852 0.3853 0.3853 0.3854 0.3854 0.3855 0.3855 0.3856 0.3856 0.3857 0.3857 0.3858 0.3858 0.3859 0.3859 0.386 0.386 0.3861 0.3861 0.3862 0.3862 0.3863 0.3863 0.3864 0.3864 0.3865 0.3855 0.3827 0.3799 0.3771 0.3743 0.3713 0.3683 0.3658 0.3633 0.3608 0.3583 0.3558 0.3505 0.3492 0.3482 0.3474 0.3467 0.3463 0.3462 0.3463 0.3467 0.3474 0.3484 0.3498 0.3515 0.3535 0.3559 0.3588 0.362 0.3656 0.3697 0.3743 0.3793;
0.3722 0.3599 0.3502 0.3722 0.3722 0.3736 0.3751 0.3765 0.3774 0.3775 0.3775 0.3776 0.3776 0.3777 0.3777 0.3778 0.3778 0.3779 0.3779 0.378 0.378 0.3781 0.3781 0.3782 0.3782 0.3783 0.3783 0.3784 0.3784 0.3785 0.3785 0.3786 0.3786 0.3787 0.3787 0.3788 0.3788 0.3789 0.3789 0.379 0.379 0.3791 0.3792 0.3792 0.3793 0.3793 0.3794 0.3794 0.3795 0.3795 0.3796 0.3797 0.38 0.3803 0.3807 0.3792 0.3768 0.3743 0.3719 0.3695 0.367 0.3558 0.3542 0.3526 0.3512 0.35 0.3489 0.3481 0.3474 0.347 0.3467 0.3468 0.3471 0.3477 0.3486 0.3498 0.3513 0.3532 0.3554 0.3581 0.3611 0.3645 0.3684 0.3727 0.3775 0.3827;
0.3676 0.3553 0.3671 0.3682 0.3697 0.3705 0.3705 0.3706 0.3706 0.3707 0.3707 0.3708 0.3708 0.3709 0.3709 0.371 0.371 0.3711 0.3711 0.3712 0.3712 0.3713 0.3713 0.3714 0.3714 0.3715 0.3715 0.3716 0.3716 0.3717 0.3717 0.372 0.3723 0.3726 0.3729 0.3733 0.3736 0.3739 0.3742 0.3745 0.3748 0.3751 0.3754 0.3757 0.376 0.3763 0.3766 0.3769 0.3772 0.3775 0.3778 0.3781 0.3784 0.3792 0.3801 0.3807 0.3632 0.3613 0.3595 0.3577 0.356 0.3544 0.3529 0.3515 0.3503 0.3492 0.3483 0.3476 0.3471 0.3468 0.3468 0.347 0.3475 0.3483 0.3493 0.3507 0.3525 0.3545 0.357 0.3598 0.3631 0.3667 0.3708 0.3753 0.3803 0.3858;
0.3627 0.3629 0.3635 0.3635 0.3636 0.3636 0.3637 0.3637 0.3638 0.3638 0.3641 0.3644 0.3647 0.365 0.3653 0.3656 0.3659 0.3662 0.3665 0.3668 0.3671 0.3674 0.3677 0.368 0.3683 0.3686 0.3689 0.3692 0.3695 0.3698 0.3701 0.3704 0.3707 0.371 0.3713 0.3716 0.3719 0.3723 0.3726 0.3729 0.3732 0.3735 0.3738 0.3741 0.3744 0.3747 0.375 0.3753 0.3756 0.3759 0.3762 0.3768 0.3678 0.366 0.3643 0.3625 0.3607 0.3589 0.3572 0.3556 0.3541 0.3526 0.3513 0.35 0.349 0.348 0.3473 0.3468 0.3464 0.3463 0.3465 0.3469 0.3475 0.3485 0.3498 0.3513 0.3533 0.3556 0.3582 0.3612 0.3647 0.3685 0.3728 0.3776 0.3828 0.3885;
0.3573 0.345 0.3351 0.3273 0.3214 0.3171 0.3143 0.3126 0.3603 0.3603 0.3603 0.3603 0.3603 0.3603 0.3603 0.3603 0.3605 0.3608 0.361 0.3613 0.3616 0.3619 0.3622 0.3624 0.3627 0.363 0.3633 0.3636 0.3638 0.3641 0.3644 0.3647 0.3649 0.3652 0.3655 0.3658 0.3661 0.3663 0.3666 0.3669 0.3672 0.3675 0.3677 0.368 0.3687 0.3701 0.3714 0.372 0.3706 0.3692 0.3677 0.3661 0.3644 0.3628 0.3611 0.3594 0.3578 0.3562 0.3546 0.3531 0.3517 0.3504 0.3492 0.3482 0.3472 0.3465 0.3459 0.3455 0.3454 0.3454 0.3458 0.3463 0.3472 0.3483 0.3498 0.3516 0.3537 0.3562 0.359 0.3623 0.3659 0.37 0.3745 0.3794 0.3849 0.3908;
0.3516 0.3392 0.3293 0.3215 0.3155 0.3112 0.3083 0.3066 0.306 0.3063 0.3073 0.3089 0.3111 0.3136 0.3165 0.3197 0.3231 0.3265 0.3301 0.3336 0.3372 0.3603 0.3603 0.3603 0.3603 0.3603 0.3603 0.3603 0.3603 0.3603 0.3603 0.3603 0.3603 0.3603 0.3603 0.3603 0.3603 0.3603 0.362 0.3633 0.3647 0.3661 0.3674 0.3716 0.3708 0.3699 0.3688 0.3676 0.3664 0.365 0.3636 0.3621 0.3606 0.3591 0.3576 0.356 0.3545 0.353 0.3516 0.3503 0.349 0.3478 0.3468 0.3459 0.3451 0.3445 0.3441 0.3439 0.3439 0.3441 0.3446 0.3454 0.3464 0.3477 0.3494 0.3514 0.3537 0.3564 0.3594 0.3629 0.3667 0.371 0.3757 0.3809 0.3865 0.3927;
0.3454 0.333 0.323 0.3152 0.3092 0.3048 0.3019 0.3002 0.2996 0.2998 0.3008 0.3024 0.3046 0.3071 0.31 0.3132 0.3166 0.32 0.3236 0.3272 0.3307 0.3342 0.3376 0.3409 0.3441 0.3471 0.3499 0.3526 0.355 0.3573 0.3593 0.3611 0.3627 0.364 0.3652 0.3603 0.3603 0.3603 0.3676 0.3677 0.3677 0.3674 0.367 0.3664 0.3657 0.3649 0.3639 0.3628 0.3617 0.3604 0.3591 0.3578 0.3564 0.355 0.3536 0.3521 0.3508 0.3494 0.3481 0.3469 0.3458 0.3448 0.3439 0.3431 0.3425 0.3421 0.3419 0.3418 0.342 0.3424 0.3431 0.344 0.3452 0.3467 0.3486 0.3507 0.3532 0.3561 0.3594 0.363 0.3671 0.3716 0.3765 0.3819 0.3878 0.3941]';  

% (g/s), engine out PM emissions indexed vertically by fc_map_spd and
% horizontally by fc_map_trq
fc_pm_map=zeros(size(fc_fuel_map)); 

% (g/s), engine out O2 indexed vertically by fc_map_spd and
% horizontally by fc_map_trq
fc_o2_map=zeros(size(fc_fuel_map));


% create BS** maps for plotting purposes
[T,w]=meshgrid(fc_map_trq,fc_map_spd); 
fc_map_kW=T.*w/1000; 
fc_fuel_map_gpkWh=fc_fuel_map./fc_map_kW*3600; 
fc_co_map_gpkWh=fc_co_map./fc_map_kW*3600; 
fc_hc_map_gpkWh=fc_hc_map./fc_map_kW*3600; 
fc_nox_map_gpkWh=fc_nox_map./fc_map_kW*3600; 
fc_pm_map_gpkWh=fc_pm_map./fc_map_kW*3600; 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Cold Engine Maps
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
fc_cold_tmp=20; %deg C
fc_fuel_map_cold=zeros(size(fc_fuel_map));

fc_hc_map_cold=zeros(size(fc_fuel_map));

fc_co_map_cold=zeros(size(fc_fuel_map));

fc_nox_map_cold=zeros(size(fc_fuel_map));

fc_pm_map_cold=zeros(size(fc_fuel_map));

%Process Cold Maps to generate Correction Factor Maps
names={'fc_fuel_map','fc_hc_map','fc_co_map','fc_nox_map','fc_pm_map'};

for i=1:length(names)
    %cold to hot raio, e.g. fc_fuel_map_c2h = fc_fuel_map_cold ./ fc_fuel_map
    eval([names{i},'_c2h=',names{i},'_cold./(',names{i},'+eps); '])
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% LIMITS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% (N*m), max torque curve of the engine indexed by fc_map_spd
fc_max_trq=[1030 1031 1033 1034 1036 1037 1039 1040 1042 1043 1045 1046 1048 1049 1051 1052 1054 1055 1057 1058 1060 1061 1063 1064 1066 1067 1069 1070 1072 1073 1075 1076 1078 1079 1081 1082 1083 1085 1080 1076 1071 1067 1062 1058 1053 1049 1044 1040 1035 1031 1026 1021 1015 1011 1008 1004 999.6 995.2 990.8 986.4 982 977.4 972.8 968.2 963.6 959 952.2 945.4 938.6 931.8 925 920 914 907 901 890 879.4 868.8 858.2 847.6 837 826.2 815.4 804.6 793.8 783]; 

% (N*m), closed throttle torque of the engine (max torque that can be absorbed)
% indexed by fc_map_spd -- correlation from JDMA
fc_ct_trq=4.448/3.281*(-fc_disp)*61.02/24 * ...
   (9*(fc_map_spd/max(fc_map_spd)).^2 + 14 * (fc_map_spd/max(fc_map_spd))); 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DEFAULT SCALING
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% (--), used to scale fc_map_spd to simulate a faster or slower running engine 
fc_spd_scale=1.0; 
% (--), used to scale fc_map_trq to simulate a higher or lower torque engine
fc_trq_scale=1.0; 
fc_pwr_scale=fc_spd_scale*fc_trq_scale;    % --  scale fc power

% user definable mass scaling function
fc_mass_scale_fun=inline('(x(1)*fc_trq_scale+x(2))*(x(3)*fc_spd_scale+x(4))*(fc_base_mass+fc_acc_mass)+fc_fuel_mass','x','fc_spd_scale','fc_trq_scale','fc_base_mass','fc_acc_mass','fc_fuel_mass');

fc_mass_scale_coef=[1 0 1 0]; % coefficients of mass scaling function


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% STUFF THAT SCALES WITH TRQ & SPD SCALES (MASS AND INERTIA)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
fc_inertia=0.1*fc_pwr_scale;            % (kg*m^2), rotational inertia of the engine
fc_max_pwr=(max(fc_map_spd.*fc_max_trq)/1000)*fc_pwr_scale;  % kW     peak engine power
fc_base_mass=588;              	% (kg), mass of the engine block and head (base engine) from cat specs
fc_acc_mass=0.8*fc_max_pwr;              	% kg    engine accy's, electrics, cntrl's - assumes mass penalty of 0.8 kg/kW (from OTA report)
fc_fuel_mass=0.6*fc_max_pwr;             	% kg    mass of fuel and fuel tank
fc_mass=fc_base_mass+fc_acc_mass+fc_fuel_mass;  		% kg  total engine/fuel system mass
fc_ext_sarea=0.3*(fc_max_pwr/100)^0.67;        		% m^2    exterior surface area of engine


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% OTHER DATA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
fc_fuel_den=839;  					% (g/l), density of the fuel 
fc_fuel_lhv=42780;  							% (J/g), lower heating value of the fuel

fc_tstat=96;                   			% C      engine coolant thermostat set temperature (typically 95 +/- 5 C)
fc_cp=500;                     		% J/kgK  ave cp of engine (iron=500, Al or Mg = 1000)
fc_h_cp=500;                   		% J/kgK  ave cp of hood & engine compartment (iron=500, Al or Mg = 1000)
fc_hood_sarea=1.5;             		% m^2    surface area of hood/eng compt.
fc_emisv=.8;                  		%        emissivity of engine ext surface/hood int surface
fc_hood_emisv=.9;             		%        emissivity hood ext
fc_h_air_flow=0;             		% kg/s   heater air flow rate (140 cfm=0.07)
fc_cl2h_eff=.7;               		% --     ave cabin heater HX eff (based on air side)
fc_c2i_th_cond=500;            		% W/K    conductance btwn engine cyl & int
fc_i2x_th_cond=500;            		% W/K    conductance btwn engine int & ext
fc_h2x_th_cond=10;             		% W/K    conductance btwn engine & engine compartment

% calculate "predicted" exh gas flow rate and engine-out (EO) temp
fc_ex_pwr_frac=[0.40 0.30];                         % --   frac of waste heat that goes to exhaust as func of engine speed
fc_exflow_map=fc_fuel_map*(1+14.5);                 % g/s  ex gas flow map:  for SI engines, exflow=(fuel use)*[1 + (stoic A/F ratio)]
fc_waste_pwr_map=fc_fuel_map*fc_fuel_lhv - T.*w;    % W    tot FC waste heat = (fuel pwr) - (mech out pwr)
spd=fc_map_spd; 
fc_ex_pwr_map=zeros(size(fc_waste_pwr_map));        % W   initialize size of ex pwr map
for i=1:length(spd)
 fc_ex_pwr_map(i,:)=fc_waste_pwr_map(i,:)*interp1([min(spd) max(spd)],fc_ex_pwr_frac,spd(i));  % W  trq-spd map of waste heat to exh 
end
fc_extmp_map=fc_ex_pwr_map./(fc_exflow_map*1089/1000) + 20;    % W   EO ex gas temp = Q/(MF*cp) + Tamb (assumes engine tested ~20 C)

%the following variable is not used directly in modelling and should always be equal to one
%it's used for initialization purposes
fc_eff_scale=1; 

% clean up workspace
clear T w fc_waste_pwr_map fc_ex_pwr_map spd fc_map_kW

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% REVISION HISTORY
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DD-MMM-YYYY 
% 03-Jan-2002 14:28:18: file created using engmodel
% 03-Jan-2002: [mpo] update file for ADVISOR 3.2 and add user-friendly comments

 