% ADVISOR Data file:  FC_CI60_emis.m
%
% Data source:  Scott Sluder (& Robert Wagner) of Oak Ridge National Laboratory
%
% Data confidence level: Excellent
%
% Notes from original Excel spreadsheet from ORNL:  
% The data was gathered by Oak Ridge National Laboratory. 
% Each matrix is based on 109 measured points.  The provided matrix was developed by 
% nearest-neighbor interpolation from the measured points.  Also note that since a 
% square matrix is required for inclusion in Advisor, there are values included for 
% conditions that are not attainable on the VW engine.
% This workbook contains an engine map for a Mercedes 1.7L diesel engine.
%
% Created on:  01/17/01 
% By:  Valerie Johnson, National Renewable Energy Laboratory, valerie_johnson@nrel.gov
%
% Revision history at end of file.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% FILE ID INFO
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
fc_description='Mercedes 1.7L Diesel Engine f/ ORNL'; % one line descriptor identifying the engine
fc_version=2003; % version of ADVISOR for which the file was generated
fc_proprietary=0; % 0=> non-proprietary, 1=> proprietary, do not distribute
fc_validation=2; % 0=> no validation, 1=> data agrees with source data, 
% 2=> data matches source data and data collection methods have been verified
fc_fuel_type='Diesel';
fc_disp=1.7; % (L) engine displacement
fc_emis=1;      % boolean 0=no emis data; 1=emis data
fc_cold=1;      % boolean 0=no cold data; 1=cold data exists
disp(['Data loaded: FC_CI60_emis.m - ',fc_description]);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SPEED & TORQUE RANGES over which data is defined
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% (rad/s), speed range of the engine (converted from RPM)
fc_map_spd=[1200:100:4200]*pi/30;

% (N*m), torque range of the engine (converted from ft-lbf)
fc_map_trq=[0:5:135]*(1/(3.281*0.224809)); 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% FUEL USE AND EMISSIONS MAPS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% (g/s) , fuel use map indexed vertically by fc_map_spd and 
% horizontally by fc_map_trq
fc_fuel_map=[0.142	0.157	0.171	0.186	0.201	0.215	0.229	0.255	0.280	0.299	0.317	0.346	0.374	0.517	0.659	0.695	0.731	0.767	0.803	0.866	0.928	0.950	0.972	1.022	1.071	1.103	1.134	1.196	1.257	1.304	1.350
0.177	0.193	0.214	0.229	0.252	0.266	0.287	0.313	0.341	0.366	0.385	0.413	0.447	0.590	0.659	0.685	0.721	0.757	0.803	0.866	0.928	0.950	0.972	1.022	1.071	1.103	1.134	1.196	1.257	1.304	1.350
0.215	0.236	0.257	0.279	0.302	0.321	0.345	0.372	0.401	0.429	0.453	0.485	0.520	0.614	0.659	0.682	0.710	0.754	0.803	0.866	0.928	0.950	0.972	1.022	1.071	1.103	1.148	1.213	1.278	1.342	1.407
0.263	0.284	0.306	0.329	0.356	0.380	0.406	0.434	0.464	0.496	0.526	0.561	0.599	0.636	0.673	0.712	0.750	0.801	0.854	0.907	0.961	1.003	1.043	1.100	1.154	1.209	1.265	1.336	1.400	1.467	1.532
0.308	0.333	0.356	0.385	0.417	0.441	0.472	0.500	0.538	0.576	0.606	0.641	0.689	0.726	0.768	0.809	0.847	0.898	0.957	1.010	1.069	1.116	1.157	1.216	1.272	1.326	1.381	1.452	1.523	1.592	1.662
0.352	0.380	0.410	0.445	0.477	0.506	0.538	0.573	0.612	0.650	0.686	0.730	0.780	0.820	0.862	0.903	0.944	1.001	1.060	1.117	1.176	1.224	1.273	1.334	1.394	1.455	1.511	1.584	1.656	1.735	1.805
0.398	0.434	0.466	0.501	0.537	0.569	0.606	0.647	0.686	0.724	0.769	0.818	0.872	0.917	0.959	1.004	1.046	1.109	1.168	1.228	1.291	1.347	1.398	1.459	1.520	1.587	1.643	1.717	1.790	1.877	1.948
0.445	0.482	0.520	0.561	0.598	0.631	0.675	0.722	0.761	0.801	0.855	0.905	0.965	1.017	1.059	1.108	1.150	1.220	1.280	1.342	1.409	1.472	1.523	1.584	1.645	1.714	1.775	1.850	1.923	2.010	2.090
0.492	0.533	0.571	0.616	0.658	0.701	0.745	0.791	0.836	0.888	0.941	0.999	1.059	1.116	1.159	1.213	1.255	1.324	1.393	1.459	1.527	1.594	1.648	1.709	1.770	1.840	1.908	1.982	2.059	2.150	2.241
0.540	0.581	0.625	0.673	0.719	0.769	0.813	0.859	0.913	0.967	1.026	1.093	1.153	1.212	1.258	1.313	1.359	1.429	1.503	1.577	1.644	1.712	1.773	1.834	1.898	1.979	2.057	2.151	2.229	2.326	2.417
0.588	0.633	0.683	0.733	0.780	0.833	0.880	0.931	0.990	1.046	1.111	1.183	1.246	1.305	1.358	1.413	1.464	1.536	1.613	1.690	1.762	1.829	1.899	1.970	2.041	2.130	2.209	2.322	2.400	2.500	2.592
0.638	0.688	0.739	0.790	0.841	0.894	0.948	1.007	1.066	1.131	1.195	1.268	1.340	1.399	1.458	1.513	1.569	1.647	1.724	1.806	1.886	1.962	2.037	2.113	2.184	2.279	2.361	2.475	2.570	2.670	2.768
0.690	0.740	0.791	0.842	0.904	0.965	1.018	1.078	1.143	1.208	1.281	1.361	1.434	1.502	1.561	1.622	1.678	1.771	1.848	1.941	2.022	2.101	2.176	2.253	2.326	2.421	2.513	2.627	2.741	2.842	2.944
0.742	0.792	0.843	0.906	0.968	1.035	1.089	1.148	1.220	1.285	1.366	1.454	1.527	1.606	1.665	1.731	1.787	1.894	1.971	2.077	2.157	2.238	2.314	2.392	2.469	2.572	2.676	2.796	2.914	3.019	3.121
0.793	0.848	0.903	0.969	1.031	1.103	1.159	1.221	1.297	1.364	1.451	1.546	1.620	1.707	1.768	1.839	1.896	2.012	2.095	2.206	2.293	2.374	2.453	2.532	2.625	2.741	2.846	2.970	3.087	3.194	3.297
0.850	0.907	0.962	1.031	1.095	1.167	1.230	1.298	1.374	1.449	1.536	1.631	1.714	1.800	1.871	1.942	2.005	2.121	2.218	2.329	2.428	2.509	2.595	2.689	2.783	2.909	3.015	3.140	3.261	3.368	3.473
0.906	0.965	1.022	1.091	1.158	1.230	1.300	1.375	1.451	1.534	1.621	1.717	1.807	1.894	1.975	2.046	2.114	2.230	2.342	2.453	2.564	2.658	2.752	2.847	2.941	3.066	3.185	3.309	3.435	3.552	3.667
0.962	1.022	1.081	1.152	1.224	1.299	1.371	1.448	1.528	1.616	1.706	1.805	1.900	1.987	2.078	2.157	2.229	2.352	2.468	2.590	2.703	2.808	2.906	3.004	3.098	3.224	3.355	3.489	3.618	3.755	3.869
0.992	1.084	1.146	1.216	1.290	1.369	1.442	1.519	1.606	1.693	1.790	1.898	1.993	2.080	2.183	2.274	2.346	2.480	2.597	2.729	2.842	2.953	3.052	3.151	3.263	3.395	3.527	3.671	3.800	3.948	4.072
0.992	1.148	1.210	1.281	1.357	1.440	1.513	1.590	1.684	1.771	1.874	1.991	2.086	2.173	2.287	2.391	2.464	2.609	2.725	2.866	2.982	3.092	3.198	3.305	3.434	3.566	3.698	3.845	3.982	4.130	4.275
0.992	1.171	1.274	1.347	1.423	1.507	1.584	1.667	1.761	1.853	1.958	2.077	2.179	2.273	2.391	2.497	2.581	2.726	2.853	2.994	3.121	3.232	3.348	3.476	3.604	3.737	3.870	4.017	4.150	4.233	4.315
0.992	1.171	1.338	1.414	1.490	1.574	1.655	1.744	1.839	1.938	2.042	2.162	2.272	2.377	2.495	2.601	2.698	2.844	2.981	3.122	3.261	3.385	3.516	3.646	3.775	3.908	3.973	4.062	4.150	4.233	4.315
0.992	1.171	1.350	1.446	1.558	1.644	1.728	1.822	1.917	2.022	2.126	2.246	2.365	2.481	2.599	2.707	2.816	2.964	3.109	3.254	3.397	3.538	3.670	3.802	3.859	3.916	3.973	4.062	4.150	4.233	4.315
0.992	1.171	1.350	1.446	1.629	1.723	1.807	1.901	1.997	2.102	2.217	2.341	2.461	2.589	2.707	2.825	2.934	3.092	3.238	3.389	3.531	3.684	3.816	3.948	3.859	3.916	3.973	4.062	4.150	4.233	4.315
0.992	1.171	1.350	1.446	1.700	1.802	1.886	1.980	2.077	2.182	2.307	2.438	2.558	2.697	2.815	2.944	3.053	3.220	3.366	3.524	3.666	3.819	3.963	3.975	3.859	3.916	3.973	4.062	4.150	4.233	4.315
0.992	1.171	1.350	1.490	1.772	1.876	1.965	2.060	2.157	2.265	2.398	2.534	2.655	2.803	2.923	3.058	3.171	3.343	3.494	3.652	3.801	3.954	4.090	3.975	3.859	3.916	3.973	4.062	4.150	4.233	4.315
0.992	1.171	1.350	1.561	1.843	1.948	2.044	2.140	2.238	2.356	2.489	2.625	2.751	2.900	3.031	3.166	3.290	3.461	3.622	3.780	3.936	4.044	4.090	3.975	3.859	3.916	3.973	4.062	4.150	4.233	4.315
0.992	1.171	1.350	1.632	1.915	2.019	2.123	2.221	2.318	2.447	2.580	2.716	2.848	2.997	3.139	3.275	3.408	3.580	3.750	3.879	3.998	4.044	4.090	3.975	3.859	3.916	3.973	4.062	4.150	4.233	4.315
]';

% (g/s), engine out HC emissions indexed vertically by fc_map_spd and
% horizontally by fc_map_trq
fc_hc_map=1e-3*[2.07	1.95	1.82	2.58	3.35	4.45	5.55	7.46	9.37	9.63	9.89	10.86	11.83	10.54	9.26	11.90	14.54	17.18	19.82	22.21	24.60	23.99	23.37	22.95	22.53	23.12	23.72	23.15	22.58	21.61	20.64
1.98	1.85	1.71	2.48	3.15	4.25	4.92	6.84	8.25	8.34	8.60	9.56	10.18	8.89	9.26	10.46	13.10	15.75	19.82	22.21	24.60	23.99	23.37	22.95	22.53	23.12	23.72	23.15	22.58	21.61	20.64
1.87	1.74	1.61	2.28	2.95	3.76	4.30	5.88	7.12	7.16	7.30	8.01	8.52	8.34	9.26	10.08	11.67	15.36	19.82	22.21	24.60	23.99	23.37	22.95	22.53	23.12	23.41	22.67	22.02	20.91	19.62
1.72	1.67	1.73	2.31	2.81	3.34	3.72	4.92	6.04	6.04	6.08	6.57	7.26	8.22	9.07	9.59	10.17	14.60	18.22	20.92	23.11	21.98	20.69	20.86	20.29	20.88	20.96	19.42	18.74	18.40	17.35
1.66	1.78	1.87	2.34	2.77	3.30	3.21	4.41	5.16	4.93	4.97	5.45	6.77	7.74	7.84	8.02	8.60	12.92	15.02	17.72	18.21	17.53	16.34	16.99	17.14	17.88	18.51	16.97	15.46	15.15	14.85
1.68	1.77	1.85	2.29	2.72	2.81	2.71	3.60	4.28	4.02	3.86	4.95	6.29	6.63	6.60	6.75	7.03	9.71	11.82	12.96	13.32	12.63	12.33	13.59	14.89	14.30	14.96	14.05	12.48	12.10	11.80
1.60	1.68	1.76	2.20	2.55	2.43	2.36	3.01	3.73	3.48	3.42	4.74	5.86	5.86	5.85	6.02	6.21	7.86	9.84	10.58	11.03	11.08	11.08	12.00	13.29	10.55	11.21	11.09	9.51	9.06	8.75
1.50	1.58	1.66	1.94	2.30	2.20	2.19	2.73	3.43	3.24	3.44	4.71	5.50	5.50	5.49	5.62	5.81	7.06	8.92	9.54	9.71	9.84	9.84	10.45	11.70	8.36	7.46	7.38	6.55	6.10	5.71
1.36	1.45	1.53	1.78	2.05	2.03	2.02	2.56	3.14	3.26	3.45	4.35	5.14	5.15	5.14	5.23	5.42	6.67	8.00	8.22	8.39	8.56	8.59	9.20	10.11	6.77	3.70	3.62	3.74	3.60	3.47
1.22	1.31	1.41	1.60	1.83	1.89	1.88	2.42	2.93	3.12	3.25	3.98	4.77	4.79	4.78	4.87	5.02	6.27	7.04	7.14	7.07	7.24	7.35	7.96	8.57	6.03	3.27	3.57	3.84	3.77	3.64
1.07	1.18	1.29	1.40	1.61	1.72	1.75	2.27	2.74	2.90	2.97	3.65	4.41	4.42	4.43	4.51	4.63	5.60	6.07	6.26	6.32	6.24	6.20	6.71	7.32	6.09	3.34	3.67	3.94	3.92	3.81
0.95	1.03	1.15	1.27	1.40	1.51	1.61	2.08	2.55	2.62	2.69	3.37	4.04	4.06	4.08	4.16	4.26	4.71	5.18	5.46	5.73	5.81	5.88	5.46	6.07	5.63	3.40	3.74	4.04	4.02	3.98
0.85	0.87	0.96	1.09	1.29	1.42	1.52	1.99	2.39	2.45	2.57	3.11	3.78	3.86	3.87	3.95	4.05	4.39	4.86	5.13	5.41	5.48	5.56	4.69	4.81	4.38	3.46	3.80	4.14	4.21	4.28
0.75	0.77	0.79	0.98	1.19	1.33	1.43	1.90	2.22	2.29	2.45	2.85	3.53	3.66	3.67	3.74	3.83	4.07	4.54	4.80	5.08	5.16	5.23	4.36	3.56	3.54	3.64	4.23	4.64	4.62	4.69
0.65	0.70	0.75	0.88	1.08	1.23	1.34	1.79	2.06	2.13	2.33	2.62	3.27	3.45	3.48	3.53	3.62	3.79	4.21	4.48	4.75	4.83	4.91	4.07	3.59	3.78	3.88	4.73	5.15	5.06	5.10
0.63	0.66	0.72	0.80	0.97	1.12	1.25	1.62	1.89	2.02	2.22	2.50	3.01	3.19	3.28	3.33	3.41	3.58	3.89	4.16	4.43	4.51	4.59	4.20	3.72	4.00	4.12	5.00	5.65	5.56	5.50
0.62	0.64	0.68	0.76	0.87	1.02	1.16	1.45	1.73	1.90	2.10	2.39	2.75	2.93	3.08	3.14	3.20	3.37	3.57	3.83	4.10	4.19	4.29	4.33	3.85	4.13	4.35	5.24	6.10	6.11	6.05
0.60	0.62	0.64	0.73	0.82	0.96	1.12	1.37	1.62	1.82	2.04	2.30	2.58	2.76	2.98	3.05	3.13	3.29	3.46	3.77	4.08	4.20	4.11	4.08	3.98	4.26	4.69	5.36	6.19	6.74	6.68
0.59	0.61	0.64	0.73	0.82	0.93	1.08	1.34	1.57	1.77	2.03	2.23	2.51	2.70	2.98	3.06	3.14	3.27	3.45	3.75	4.07	4.36	4.30	4.21	4.23	4.72	5.16	5.45	6.28	7.12	7.31
0.59	0.61	0.63	0.73	0.82	0.89	1.05	1.30	1.52	1.72	2.03	2.16	2.45	2.63	2.99	3.07	3.15	3.26	3.43	3.74	4.05	4.34	4.48	4.46	4.61	5.19	5.63	5.83	6.38	7.21	7.94
0.59	0.61	0.63	0.72	0.82	0.89	1.01	1.25	1.47	1.71	2.02	2.14	2.38	2.62	3.00	3.08	3.16	3.27	3.42	3.72	4.03	4.33	4.64	4.84	4.99	5.57	6.09	6.30	6.46	7.26	8.06
0.59	0.61	0.63	0.72	0.82	0.89	0.98	1.21	1.43	1.70	2.01	2.13	2.32	2.62	3.01	3.09	3.17	3.27	3.40	3.71	4.02	4.37	4.74	5.12	5.36	5.94	6.37	6.42	6.46	7.26	8.06
0.59	0.61	0.63	0.72	0.82	0.89	0.97	1.17	1.38	1.69	2.01	2.13	2.25	2.63	3.01	3.10	3.18	3.27	3.38	3.79	4.14	4.52	4.89	5.26	5.55	5.96	6.37	6.42	6.46	7.26	8.06
0.59	0.61	0.63	0.72	0.84	0.93	1.00	1.21	1.40	1.71	2.07	2.14	2.26	2.65	3.04	3.13	3.22	3.25	3.35	3.95	4.30	4.69	5.06	5.43	5.55	5.96	6.37	6.42	6.46	7.26	8.06
0.59	0.61	0.63	0.72	0.85	0.96	1.03	1.24	1.41	1.72	2.13	2.15	2.27	2.68	3.06	3.17	3.26	3.22	3.33	4.10	4.45	4.85	5.23	5.46	5.55	5.96	6.37	6.42	6.46	7.26	8.06
0.59	0.61	0.63	0.73	0.87	0.99	1.07	1.27	1.43	1.75	2.20	2.17	2.28	2.70	3.09	3.20	3.29	3.23	3.30	4.09	4.61	5.00	5.37	5.46	5.55	5.96	6.37	6.42	6.46	7.26	8.06
0.59	0.61	0.63	0.75	0.89	1.01	1.10	1.28	1.44	1.82	2.27	2.23	2.29	2.71	3.11	3.23	3.33	3.27	3.27	4.06	4.77	5.11	5.37	5.46	5.55	5.96	6.37	6.42	6.46	7.26	8.06
0.59	0.61	0.63	0.77	0.90	1.02	1.14	1.30	1.45	1.88	2.33	2.30	2.30	2.72	3.13	3.25	3.37	3.30	3.24	4.04	4.85	5.11	5.37	5.46	5.55	5.96	6.37	6.42	6.46	7.26	8.06
]'; 

% (g/s), engine out CO emissions indexed vertically by fc_map_spd and
fc_co_map=1e-3*[4.78	5.62	6.46	8.26	10.06	14.07	18.07	21.95	25.82	28.86	31.89	35.00	38.10	35.75	33.40	37.50	41.60	45.70	49.80	58.88	67.96	66.14	64.32	65.52	66.72	81.24	95.77	121.30	146.83	145.69	144.55
5.03	5.86	6.61	8.41	10.12	14.13	17.09	20.96	24.77	27.38	30.41	33.52	35.00	32.65	33.40	38.04	42.14	46.24	49.80	58.88	67.96	66.14	64.32	65.52	66.72	81.24	95.77	121.30	146.83	145.69	144.55
5.27	6.02	6.76	8.47	10.18	13.47	16.10	19.93	23.72	26.21	28.93	30.87	31.90	31.62	33.40	38.18	42.68	46.38	49.80	58.88	67.96	66.14	64.32	65.52	66.72	81.24	96.00	117.65	142.62	139.48	135.51
5.51	6.25	7.00	8.65	10.21	12.82	15.03	18.83	22.52	24.73	27.06	28.05	29.59	31.44	33.10	37.16	41.43	44.80	47.94	57.38	65.22	62.73	59.76	65.73	66.95	82.96	97.88	93.95	117.70	118.29	115.48
5.74	6.49	7.23	8.75	10.20	12.81	13.81	17.61	20.68	22.35	24.67	25.66	28.87	30.72	31.15	33.87	38.13	41.47	44.21	53.64	56.29	55.05	52.40	61.46	67.28	83.64	99.76	95.83	92.78	93.80	94.92
5.96	6.58	7.15	8.71	10.19	11.63	12.58	15.88	18.84	20.45	22.28	24.88	28.15	28.98	29.19	31.77	34.84	37.73	40.47	45.11	47.36	46.12	45.91	56.99	68.06	68.45	81.89	77.72	72.44	72.06	73.18
6.24	6.47	6.93	8.46	9.80	10.72	11.56	14.53	17.54	19.17	21.26	24.50	27.66	28.00	28.25	30.95	33.63	35.78	38.37	41.38	44.67	46.22	46.84	58.11	69.17	46.96	60.40	57.54	52.26	50.49	51.44
6.49	6.62	6.73	7.83	9.18	10.07	10.79	13.66	16.66	18.43	21.17	24.40	27.41	27.92	28.17	30.92	33.59	35.23	37.66	40.78	44.33	47.15	47.77	59.19	70.28	41.83	38.91	36.12	32.08	30.31	29.70
6.11	6.40	6.56	7.52	8.55	9.29	10.01	12.89	15.78	18.35	21.09	24.15	27.16	27.83	28.09	30.89	33.56	35.20	36.94	40.44	43.99	47.55	48.70	60.12	71.39	42.94	17.42	14.63	12.91	13.17	13.43
5.74	6.02	6.36	7.07	7.93	9.05	9.78	12.62	14.99	17.75	20.41	23.89	26.91	27.63	28.01	30.81	33.53	35.17	36.75	42.43	43.65	47.21	49.63	61.05	70.02	43.38	14.47	13.89	13.04	13.19	13.46
5.36	5.71	6.12	6.53	7.31	8.69	9.63	12.21	14.22	16.93	19.51	23.42	26.66	27.38	27.92	30.73	33.50	35.10	36.65	44.38	48.79	49.91	50.35	52.46	55.98	43.19	14.27	14.02	13.16	13.25	13.49
4.90	5.24	5.73	6.21	6.70	8.07	9.45	11.45	13.45	16.03	18.61	22.52	26.41	27.13	27.84	30.60	33.30	34.86	36.40	43.77	51.24	50.54	49.39	38.43	41.95	37.44	14.08	13.85	13.29	13.38	13.51
4.36	4.54	4.93	5.45	6.26	7.56	8.94	10.94	12.65	15.22	17.69	21.28	25.19	25.95	26.67	29.25	31.95	33.59	35.14	41.61	49.08	49.58	48.44	31.13	27.92	23.41	13.89	13.66	13.42	13.75	14.08
3.81	4.00	4.23	5.01	5.82	7.04	8.42	10.42	11.84	14.41	16.78	20.03	23.94	24.73	25.46	27.89	30.60	32.33	33.87	39.45	46.92	48.27	47.48	30.17	13.89	13.45	14.13	14.10	14.01	14.76	15.09
3.27	3.62	3.98	4.57	5.39	6.56	7.91	9.80	11.03	13.58	15.86	18.84	22.69	23.51	24.24	26.58	29.24	31.02	32.60	37.78	44.76	46.11	46.52	29.32	13.32	13.94	14.62	14.69	14.60	15.64	16.11
3.64	3.36	3.72	4.21	4.95	6.12	7.39	8.99	10.22	12.67	14.95	17.93	21.44	22.26	23.03	25.37	27.89	29.67	31.34	36.52	42.60	43.95	43.82	29.89	13.89	14.44	15.11	15.20	15.19	16.23	17.12
4.06	3.44	3.47	3.96	4.52	5.69	6.88	8.18	9.41	11.75	14.04	17.02	20.19	21.01	21.81	24.15	26.54	28.32	30.07	35.25	40.44	37.55	34.65	30.45	14.46	15.01	15.60	15.69	15.92	17.50	18.98
4.47	3.86	3.26	4.04	4.27	5.33	6.51	7.68	8.83	11.10	13.31	16.13	19.11	19.94	20.87	23.27	25.67	27.50	29.30	33.51	38.60	36.41	28.80	22.56	15.03	15.58	16.38	17.04	17.51	19.84	21.32
4.69	4.58	4.07	4.86	4.14	5.01	6.19	7.36	8.45	10.72	12.80	15.29	18.27	19.10	20.24	22.65	25.05	26.94	28.73	31.68	36.77	39.54	32.41	24.80	15.63	16.70	17.51	18.63	19.10	21.83	23.66
4.69	5.39	4.89	5.48	4.02	4.69	5.87	7.05	8.08	10.35	12.30	14.45	17.43	18.26	19.62	22.03	24.43	26.37	28.17	30.15	34.94	37.71	36.02	27.36	16.28	17.83	18.64	19.87	20.69	23.42	26.00
4.69	5.69	5.71	5.36	3.90	4.56	5.56	6.68	7.70	9.87	11.79	13.85	16.59	17.57	18.99	21.41	23.82	25.75	27.60	29.59	33.11	35.88	37.24	28.01	16.92	18.49	19.77	21.00	22.15	24.31	26.46
4.69	5.69	6.53	5.24	3.77	4.44	5.24	6.30	7.33	9.36	11.28	13.34	15.75	16.94	18.37	20.78	23.20	25.14	27.04	29.02	31.28	30.34	27.74	25.14	17.56	19.13	20.45	21.30	22.15	24.31	26.46
4.69	5.69	6.68	5.18	3.86	4.45	5.15	6.08	6.97	8.86	10.77	12.83	14.90	16.32	17.74	20.12	22.48	24.38	26.32	28.18	30.04	29.38	25.96	22.54	17.88	19.16	20.45	21.30	22.15	24.31	26.46
4.69	5.69	6.68	5.18	4.70	4.83	5.53	6.46	6.87	8.75	10.47	12.34	14.40	15.64	17.06	19.17	21.52	23.30	25.24	27.10	28.97	31.81	28.39	24.97	17.88	19.16	20.45	21.30	22.15	24.31	26.46
4.69	5.69	6.68	5.18	5.54	5.21	5.90	6.83	6.77	8.65	10.18	11.86	13.91	14.96	16.38	18.21	20.57	22.22	24.16	26.03	27.89	30.88	30.82	25.41	17.88	19.16	20.45	21.30	22.15	24.31	26.46
4.69	5.69	6.68	5.69	6.37	5.84	6.28	6.97	6.67	8.51	9.89	11.41	13.43	14.32	15.70	17.36	19.61	21.22	23.08	24.95	26.81	29.81	32.94	25.41	17.88	19.16	20.45	21.30	22.15	24.31	26.46
4.69	5.69	6.68	6.53	7.21	6.68	6.65	6.87	6.57	8.23	9.61	11.12	12.94	13.83	15.02	16.68	18.66	20.26	22.00	23.87	25.73	29.09	32.94	25.41	17.88	19.16	20.45	21.30	22.15	24.31	26.46
4.69	5.69	6.68	7.36	8.05	7.52	7.03	6.77	6.47	7.94	9.32	10.83	12.45	13.34	14.33	16.00	17.70	19.30	20.92	23.04	25.24	29.09	32.94	25.41	17.88	19.16	20.45	21.30	22.15	24.31	26.46
]'; 

% (g/s), engine out NOx emissions indexed vertically by fc_map_spd and
% horizontally by fc_map_trq
fc_nox_map=1e-3*[1.57	1.51	1.46	1.54	1.62	1.60	1.58	1.75	1.92	1.80	1.67	1.68	1.70	3.15	4.61	4.89	5.17	5.45	5.73	6.54	7.35	7.36	7.38	8.69	10.01	10.63	11.24	13.24	15.24	16.08	16.93
1.77	1.71	1.60	1.68	1.82	1.80	1.94	2.11	2.45	2.35	2.23	2.24	2.27	3.73	4.61	4.93	5.21	5.49	5.73	6.54	7.35	7.36	7.38	8.69	10.01	10.63	11.24	13.24	15.24	16.08	16.93
2.00	1.87	1.74	1.88	2.03	2.11	2.29	2.58	2.99	2.90	2.79	2.81	2.85	3.92	4.61	4.94	5.25	5.50	5.73	6.54	7.35	7.36	7.38	8.69	10.01	10.63	11.54	14.00	16.12	18.05	19.78
2.32	2.15	1.93	2.08	2.52	2.69	2.71	3.12	3.58	3.52	3.46	3.48	3.84	4.36	4.88	5.47	6.07	6.33	6.81	7.41	8.00	8.46	8.84	10.18	11.60	12.80	13.91	19.07	21.31	24.11	26.12
2.95	2.44	2.13	2.70	3.50	3.67	3.27	3.67	4.44	4.33	4.27	4.29	5.65	6.17	6.66	7.19	7.78	8.07	8.97	9.57	10.12	10.78	11.21	12.51	13.85	15.07	16.28	21.44	26.51	29.19	31.84
3.81	3.43	3.10	3.73	4.48	4.24	3.82	4.48	5.30	5.18	5.08	6.06	7.45	7.95	8.43	8.95	9.50	10.23	11.13	11.69	12.24	12.90	13.66	15.48	17.20	18.93	20.46	26.27	31.60	33.50	36.15
5.66	4.87	4.40	5.04	5.82	5.33	4.78	5.83	6.70	6.60	6.72	8.09	9.16	9.86	10.35	11.26	11.83	12.27	13.18	13.71	14.84	15.95	16.81	19.64	21.35	23.45	24.97	31.36	36.69	37.89	40.46
7.72	6.83	6.01	6.62	7.40	6.89	6.24	7.62	8.54	8.51	8.94	10.24	10.76	11.90	12.39	13.94	14.51	14.41	15.14	15.91	17.61	19.10	19.95	23.65	25.51	27.70	29.48	35.90	41.78	42.98	44.77
10.99	9.00	7.89	8.41	8.97	8.34	7.70	9.08	10.38	10.72	11.15	11.84	12.36	13.94	14.42	16.62	17.19	17.09	17.10	18.69	20.39	22.09	23.09	26.80	29.66	31.85	34.00	40.42	46.83	48.29	49.63
14.25	12.27	10.68	10.90	11.67	11.31	10.68	11.98	12.58	13.01	13.11	13.44	13.96	15.66	16.46	18.77	19.87	19.77	19.73	21.06	23.16	24.86	26.24	29.94	34.15	36.45	38.94	44.74	51.14	54.79	56.14
17.52	16.03	15.04	14.05	14.55	14.38	13.89	14.81	14.88	15.15	14.97	15.13	15.56	17.26	18.50	20.80	22.54	22.48	22.47	23.45	25.00	27.12	29.53	35.05	40.38	41.46	43.96	49.06	55.46	60.64	62.64
21.64	19.96	19.11	18.27	17.43	17.25	17.07	17.13	17.19	17.01	16.83	16.99	17.17	18.86	20.54	22.89	25.28	25.24	25.23	26.19	27.17	30.96	34.08	41.28	46.62	46.96	48.97	54.03	59.78	64.96	69.15
26.50	23.81	22.41	21.54	20.46	19.84	19.66	19.72	19.70	19.49	19.18	19.00	19.17	21.36	23.05	26.02	28.41	28.16	28.15	28.95	29.93	35.51	38.62	46.65	52.85	53.19	53.98	59.04	64.10	69.66	75.23
31.37	28.67	25.64	24.57	23.49	22.43	22.25	22.31	22.20	22.00	21.57	21.01	21.18	23.89	25.58	29.16	31.55	31.08	31.07	31.70	32.68	39.53	43.17	51.19	59.08	58.82	58.39	64.01	69.06	75.39	80.96
36.23	32.45	28.58	27.60	26.52	25.19	24.84	24.87	24.70	24.47	23.95	23.09	23.19	26.32	28.12	32.11	34.69	34.09	34.00	34.55	35.44	42.28	47.72	55.63	62.26	62.90	62.47	68.97	74.02	80.88	86.69
37.07	35.39	31.52	30.60	29.55	28.22	27.43	27.38	27.21	26.86	26.34	25.48	25.20	28.33	30.65	34.64	37.82	37.23	36.92	37.47	38.20	45.04	51.88	58.55	65.18	66.77	66.55	73.15	78.98	85.84	92.42
37.71	37.20	34.46	33.54	32.57	31.25	30.03	29.88	29.71	29.25	28.73	27.87	27.22	30.34	33.18	37.17	40.96	40.37	39.84	40.40	40.95	47.80	54.64	61.47	68.10	69.69	70.63	77.23	83.58	88.92	94.56
38.34	37.83	37.32	35.75	35.39	34.55	33.25	32.97	32.89	32.34	31.86	31.06	30.17	33.32	36.43	40.22	44.31	43.61	43.02	43.20	43.74	51.17	57.66	64.25	71.02	72.61	73.56	79.92	85.90	89.04	94.68
38.68	38.47	37.96	36.39	38.05	37.98	36.68	36.40	36.73	36.18	35.86	35.25	34.36	37.51	40.54	43.68	47.76	46.91	46.32	45.99	46.52	54.82	61.39	67.88	72.38	74.11	75.03	82.23	88.22	90.19	94.80
38.68	39.11	38.59	37.44	40.71	41.41	40.11	39.83	40.57	40.01	39.85	39.43	38.54	41.69	44.64	47.14	51.22	50.21	49.62	48.90	49.31	57.60	65.12	70.27	72.33	75.58	76.51	83.91	90.54	92.51	94.93
38.68	39.33	39.23	40.11	43.38	44.10	43.55	43.64	44.40	43.97	43.85	43.48	42.73	45.82	48.74	51.16	54.68	53.66	52.92	52.19	52.09	60.39	67.66	70.23	72.29	75.59	77.99	85.39	92.67	93.81	94.95
38.68	39.33	39.87	42.77	46.04	46.77	46.98	47.47	48.24	47.97	47.84	47.48	46.91	49.92	52.85	55.26	58.13	57.12	56.21	55.49	54.88	60.47	64.85	69.22	72.24	75.55	78.87	85.77	92.67	93.81	94.95
38.68	39.33	39.99	44.06	48.27	49.24	49.93	50.93	52.12	51.96	51.84	51.47	51.10	54.02	56.95	59.29	61.59	60.66	59.64	59.51	59.11	62.91	66.79	70.66	72.22	75.54	78.87	85.77	92.67	93.81	94.95
38.68	39.33	39.99	44.06	48.95	51.22	51.91	52.90	56.49	56.34	56.52	55.86	55.51	57.99	60.92	62.75	65.05	64.39	63.38	64.14	63.74	67.45	71.33	75.20	72.22	75.54	78.87	85.77	92.67	93.81	94.95
38.68	39.33	39.99	44.06	49.63	53.20	53.88	54.88	60.87	60.71	61.28	60.28	59.93	61.96	64.88	66.21	68.51	68.13	67.11	68.77	68.37	72.08	75.87	76.02	72.22	75.54	78.87	85.77	92.67	93.81	94.95
38.68	39.33	39.99	44.47	50.31	54.45	55.86	58.03	65.24	65.17	66.04	64.77	64.35	66.02	68.84	69.87	71.97	71.70	70.85	72.58	73.00	76.71	79.82	76.02	72.22	75.54	78.87	85.77	92.67	93.81	94.95
38.68	39.33	39.99	45.15	50.99	55.13	57.83	62.41	69.62	69.93	70.80	69.53	68.77	70.44	72.81	73.83	75.43	75.16	74.59	76.31	77.62	79.79	79.82	76.02	72.22	75.54	78.87	85.77	92.67	93.81	94.95
38.68	39.33	39.99	45.83	51.67	55.81	59.81	66.78	73.99	74.69	75.55	74.28	73.19	74.86	76.77	77.79	78.89	78.62	78.32	79.17	79.76	79.79	79.82	76.02	72.22	75.54	78.87	85.77	92.67	93.81	94.95
]';  

% (g/s), engine out PM emissions indexed vertically by fc_map_spd and
% horizontally by fc_map_trq
fc_pm_map=1e-3*[0.039	0.054	0.069	0.073	0.077	0.090	0.104	0.082	0.060	0.104	0.148	0.130	0.112	0.205	0.298	0.299	0.299	0.299	0.300	0.272	0.244	0.265	0.287	0.314	0.340	0.462	0.584	0.629	0.675	0.785	0.896
0.080	0.095	0.112	0.116	0.100	0.113	0.144	0.122	0.080	0.115	0.159	0.141	0.155	0.248	0.298	0.254	0.254	0.255	0.300	0.272	0.244	0.265	0.287	0.314	0.340	0.462	0.584	0.629	0.675	0.785	0.896
0.129	0.142	0.154	0.138	0.122	0.147	0.184	0.149	0.101	0.132	0.169	0.174	0.197	0.262	0.298	0.242	0.209	0.243	0.300	0.272	0.244	0.265	0.287	0.314	0.340	0.462	0.626	0.655	0.704	0.820	0.947
0.206	0.258	0.372	0.295	0.156	0.192	0.235	0.183	0.140	0.199	0.248	0.264	0.262	0.289	0.317	0.297	0.269	0.329	0.380	0.337	0.299	0.382	0.443	0.542	0.585	0.768	0.960	0.834	0.876	0.947	1.060
0.299	0.462	0.592	0.425	0.209	0.246	0.308	0.256	0.256	0.364	0.414	0.430	0.375	0.402	0.441	0.478	0.449	0.508	0.542	0.498	0.479	0.620	0.695	0.832	0.930	1.111	1.294	1.168	1.048	1.143	1.244
0.405	0.531	0.642	0.467	0.263	0.318	0.381	0.365	0.373	0.486	0.579	0.544	0.488	0.523	0.564	0.607	0.630	0.670	0.703	0.677	0.660	0.800	0.979	1.088	1.227	1.523	1.717	1.296	1.156	1.491	1.592
0.519	0.539	0.622	0.454	0.331	0.394	0.501	0.474	0.482	0.594	0.703	0.647	0.644	0.742	0.787	0.848	0.901	1.007	1.026	1.034	1.121	1.316	1.526	1.351	1.491	1.964	2.158	1.402	1.262	1.812	1.939
0.632	0.646	0.660	0.532	0.409	0.487	0.679	0.585	0.584	0.695	0.798	0.754	0.846	1.048	1.093	1.171	1.224	1.433	1.486	1.526	1.689	1.864	2.073	1.653	1.754	2.276	2.598	1.825	1.369	1.918	2.287
0.715	0.733	0.747	0.616	0.487	0.665	0.857	0.763	0.686	0.791	0.894	0.956	1.048	1.355	1.400	1.494	1.546	1.756	1.945	2.093	2.256	2.419	2.620	2.200	2.017	2.539	3.038	2.265	1.491	2.060	2.633
0.797	0.815	0.789	0.657	0.508	0.648	0.840	0.756	0.795	0.898	1.045	1.158	1.249	1.585	1.706	1.803	1.869	2.079	2.270	2.576	2.824	2.987	3.168	2.747	2.244	2.810	3.337	2.701	1.927	2.402	2.975
0.880	0.844	0.752	0.660	0.520	0.628	0.792	0.775	0.906	1.031	1.219	1.349	1.451	1.786	2.013	2.110	2.192	2.391	2.572	2.903	3.194	3.445	3.691	2.971	2.281	3.088	3.615	3.137	2.363	2.771	3.317
0.885	0.789	0.703	0.618	0.532	0.642	0.752	0.884	1.016	1.204	1.392	1.523	1.653	1.988	2.319	2.412	2.499	2.700	2.881	3.249	3.602	3.779	4.014	3.008	2.319	3.270	3.893	3.425	2.799	3.207	3.658
0.822	0.714	0.622	0.544	0.536	0.700	0.810	0.942	1.006	1.200	1.438	1.653	1.783	2.194	2.530	2.606	2.694	3.060	3.241	3.726	4.079	4.103	4.338	3.193	2.357	3.308	4.172	3.703	3.234	3.619	4.003
0.760	0.652	0.557	0.548	0.540	0.758	0.868	1.000	0.996	1.190	1.474	1.781	1.911	2.400	2.736	2.801	2.888	3.419	3.600	4.203	4.556	4.472	4.662	3.517	2.394	3.445	4.524	4.148	3.716	3.966	4.351
0.697	0.630	0.567	0.552	0.544	0.796	0.926	1.033	0.987	1.191	1.511	1.892	2.039	2.590	2.942	2.999	3.083	3.711	3.960	4.614	5.033	4.949	4.985	3.859	2.950	3.839	4.918	4.630	4.198	4.357	4.698
0.760	0.641	0.578	0.559	0.549	0.800	0.985	1.023	0.977	1.228	1.548	1.929	2.167	2.718	3.148	3.205	3.278	3.906	4.320	4.974	5.510	5.426	5.270	4.458	3.550	4.270	5.312	5.034	4.680	4.839	5.046
0.830	0.681	0.588	0.569	0.553	0.805	1.043	1.013	0.967	1.265	1.585	1.966	2.296	2.846	3.355	3.411	3.472	4.100	4.679	5.333	5.987	5.698	5.408	5.058	4.149	4.870	5.706	5.428	5.200	5.811	6.286
0.899	0.750	0.601	0.599	0.546	0.766	1.013	0.973	0.938	1.260	1.565	1.917	2.301	2.848	3.386	3.450	3.476	4.195	4.821	5.458	6.071	6.131	5.669	5.257	4.748	5.469	6.372	6.108	5.957	7.553	8.028
0.936	0.820	0.671	0.668	0.531	0.707	0.953	0.913	0.889	1.211	1.479	1.762	2.146	2.694	3.208	3.357	3.382	4.245	4.870	5.541	6.154	6.691	6.276	5.814	5.415	6.475	7.386	6.864	6.713	8.832	9.770
0.936	0.890	0.741	0.721	0.517	0.647	0.894	0.854	0.840	1.162	1.394	1.608	1.992	2.539	3.030	3.263	3.289	4.294	4.919	5.616	6.238	6.775	6.883	6.464	6.144	7.489	8.399	7.816	7.469	9.589	11.512
0.936	0.915	0.810	0.706	0.502	0.631	0.835	0.804	0.791	1.085	1.308	1.502	1.837	2.368	2.852	3.096	3.196	4.204	4.969	5.665	6.321	6.858	7.357	7.192	6.872	8.228	9.412	8.829	8.166	10.012	11.858
0.936	0.915	0.880	0.691	0.487	0.616	0.775	0.755	0.742	0.999	1.223	1.416	1.682	2.191	2.675	2.919	3.102	4.110	5.018	5.715	6.404	6.841	7.233	7.626	7.600	8.956	10.021	9.093	8.166	10.012	11.858
0.936	0.915	0.893	0.684	0.503	0.603	0.733	0.715	0.697	0.914	1.137	1.331	1.528	2.013	2.497	2.750	3.010	4.024	5.032	5.667	6.320	7.125	7.478	7.832	7.957	8.989	10.021	9.093	8.166	10.012	11.858
0.936	0.915	0.893	0.684	0.628	0.594	0.723	0.706	0.689	0.906	1.090	1.283	1.477	1.956	2.439	2.660	2.919	3.953	4.961	5.536	6.189	7.571	7.924	8.278	7.957	8.989	10.021	9.093	8.166	10.012	11.858
0.936	0.915	0.893	0.684	0.753	0.585	0.714	0.696	0.681	0.898	1.046	1.237	1.432	1.907	2.390	2.569	2.828	3.882	4.890	5.406	6.058	7.465	8.371	8.358	7.957	8.989	10.021	9.093	8.166	10.012	11.858
0.936	0.915	0.893	0.760	0.877	0.651	0.705	0.688	0.673	0.882	1.003	1.192	1.386	1.859	2.340	2.494	2.737	3.799	4.819	5.330	5.928	7.335	8.759	8.358	7.957	8.989	10.021	9.093	8.166	10.012	11.858
0.936	0.915	0.893	0.885	1.002	0.776	0.696	0.680	0.666	0.839	0.959	1.149	1.341	1.813	2.291	2.445	2.646	3.708	4.749	5.259	5.797	7.248	8.759	8.358	7.957	8.989	10.021	9.093	8.166	10.012	11.858
0.936	0.915	0.893	1.010	1.127	0.900	0.687	0.672	0.658	0.795	0.916	1.105	1.295	1.768	2.242	2.396	2.556	3.617	4.678	5.205	5.737	7.248	8.759	8.358	7.957	8.989	10.021	9.093	8.166	10.012	11.858
]';

% (g/s), engine out O2 emissions indexed vertically by fc_map_spd and
% horizontally by fc_map_trq
fc_o2_map=1e-3*[2325	2361	2397	2702	3006	3307	3608	3928	4248	4333	4417	4663	4908	5462	6017	6585	7153	7720	8288	9053	9818	10018	10217	10926	11635	12168	12700	13284	13867	14169	14470
2222	2263	2334	2638	2909	3210	3501	3821	4148	4300	4384	4629	4922	5477	6017	6655	7223	7791	8288	9053	9818	10018	10217	10926	11635	12168	12700	13284	13867	14169	14470
2132	2201	2271	2542	2812	3106	3394	3719	4048	4218	4351	4630	4936	5481	6017	6674	7293	7809	8288	9053	9818	10018	10217	10926	11635	12168	12665	13236	13812	14053	14302
2078	2138	2184	2451	2828	3109	3312	3637	3973	4176	4369	4671	5143	5626	6076	6713	7390	7870	8409	9151	9822	10012	10210	10808	11509	11904	12377	12911	13486	13691	13928
2090	2071	2096	2521	3033	3315	3280	3605	4000	4259	4452	4754	5739	6221	6460	6840	7517	8005	8651	9393	9836	10005	10197	10729	11331	11702	12089	12623	13159	13354	13546
2151	2186	2242	2733	3238	3290	3248	3622	4027	4292	4535	5330	6334	6642	6845	7198	7644	8248	8894	9424	9850	10019	10172	10664	11159	11491	11856	12336	12870	12953	13145
2314	2415	2485	2969	3411	3356	3354	3847	4274	4545	4908	5913	6755	6909	7106	7424	7764	8307	8968	9386	9724	9903	10045	10495	10991	11268	11632	12048	12582	12564	12744
2476	2570	2655	3121	3563	3526	3625	4249	4692	4992	5481	6450	6998	7067	7264	7539	7880	8284	8900	9286	9546	9776	9918	10333	10823	11085	11409	11821	12295	12276	12342
2394	2637	2760	3241	3715	3797	3897	4520	5111	5565	6054	6693	7242	7225	7422	7655	7995	8400	8832	9108	9368	9628	9791	10206	10654	10916	11185	11598	12015	12019	12021
2313	2555	2847	3270	3721	4074	4174	4797	5269	5770	6329	6937	7485	7446	7580	7806	8111	8516	8767	9031	9190	9450	9664	10078	10509	10756	11023	11460	11880	11934	11936
2231	2534	2899	3264	3702	4215	4451	4992	5352	5882	6491	7152	7729	7689	7739	7964	8227	8544	8703	9017	9250	9404	9544	10013	10479	10603	10870	11325	11745	11834	11851
2109	2487	2886	3284	3683	4193	4704	5069	5435	6045	6654	7314	7972	7933	7897	8115	8326	8482	8641	8958	9275	9374	9481	9983	10449	10499	10717	11173	11610	11700	11766
1952	2303	2688	3094	3572	4103	4614	4979	5454	6068	6656	7189	7845	7839	7801	8085	8296	8433	8592	8918	9234	9311	9418	9936	10419	10469	10564	11020	11476	11541	11606
1796	2146	2502	2984	3462	4013	4524	4889	5473	6088	6646	7049	7705	7732	7694	8055	8266	8384	8543	8877	9193	9254	9355	9873	10389	10445	10502	10951	11425	11318	11383
1639	2004	2371	2873	3351	3915	4434	4840	5493	6101	6637	6934	7565	7618	7587	8002	8236	8343	8494	8831	9153	9214	9292	9812	10344	10435	10492	10901	11375	11149	11159
1479	1874	2240	2755	3241	3805	4343	4859	5512	6091	6628	6924	7425	7478	7480	7895	8206	8313	8445	8782	9112	9173	9284	9765	10298	10418	10482	10886	11325	11099	10936
1320	1729	2110	2624	3130	3694	4253	4879	5532	6082	6618	6915	7286	7338	7373	7788	8176	8283	8396	8734	9071	9276	9481	9719	10251	10371	10472	10876	11250	10974	10700
1161	1570	1979	2489	3026	3598	4163	4829	5507	6045	6630	6972	7267	7323	7398	7835	8278	8391	8502	8729	9074	9302	9607	9883	10205	10325	10376	10696	11025	10730	10456
1077	1421	1834	2344	2927	3508	4073	4739	5441	5978	6665	7111	7405	7461	7579	8004	8447	8561	8672	8731	9077	9234	9532	9838	10102	10124	10172	10471	10801	10495	10213
1077	1277	1689	2209	2827	3418	3983	4649	5374	5912	6700	7249	7544	7599	7761	8173	8616	8732	8843	8775	9079	9236	9457	9735	9947	9920	9968	10262	10576	10271	9969
1077	1225	1545	2110	2728	3319	3893	4581	5308	5924	6736	7314	7682	7768	7942	8352	8785	8900	9013	8946	9082	9239	9387	9580	9793	9764	9764	10058	10369	10145	9921
1077	1225	1400	2010	2629	3219	3804	4515	5241	5959	6771	7350	7821	7949	8123	8534	8953	9069	9184	9116	9085	9218	9341	9464	9639	9610	9641	10005	10369	10145	9921
1077	1225	1374	1962	2532	3121	3711	4442	5176	5995	6806	7385	7959	8131	8304	8669	9004	9086	9199	9069	8904	8979	9120	9261	9564	9603	9641	10005	10369	10145	9921
1077	1225	1374	1962	2448	3024	3615	4345	5121	5940	6738	7209	7783	7901	8079	8428	8763	8738	8851	8837	8672	8663	8804	8945	9564	9603	9641	10005	10369	10145	9921
1077	1225	1374	1962	2364	2927	3518	4249	5066	5886	6660	7017	7590	7645	7824	8186	8521	8390	8503	8605	8441	8428	8489	8889	9564	9603	9641	10005	10369	10145	9921
1077	1225	1374	1911	2279	2838	3422	4173	5012	5826	6582	6846	7398	7403	7568	7939	8279	8107	8154	8267	8209	8196	8214	8889	9564	9603	9641	10005	10369	10145	9921
1077	1225	1374	1826	2195	2753	3325	4118	4957	5747	6504	6768	7206	7211	7312	7683	8038	7865	7806	7919	7977	8042	8214	8889	9564	9603	9641	10005	10369	10145	9921
1077	1225	1374	1742	2110	2669	3229	4063	4902	5669	6425	6690	7014	7019	7056	7427	7796	7623	7458	7652	7870	8042	8214	8889	9564	9603	9641	10005	10369	10145	9921
]';

% (C), engine exhaust gas temperature indexed vertically by fc_map_spd and
% horizontally by fc_map_trq
fc_extmp_map=[116.4	122.3	128.2	128.7	129.2	132.9	136.7	137.0	137.4	143.2	149.1	152.0	154.9	183.1	211.4	213.3	215.3	217.2	219.2	224.3	229.4	228.1	226.7	229.3	231.8	225.2	218.6	221.6	224.6	226.3	227.9
134.0	139.8	145.4	145.9	149.1	152.9	155.6	155.9	156.8	161.9	167.7	170.6	173.2	201.5	211.4	210.0	212.0	213.9	219.2	224.3	229.4	228.1	226.7	229.3	231.8	225.2	218.6	221.6	224.6	226.3	227.9
151.8	157.2	162.5	165.8	169.1	172.1	174.5	175.2	176.2	181.1	186.4	189.1	191.6	207.6	211.4	209.1	208.6	213.0	219.2	224.3	229.4	228.1	226.7	229.3	231.8	225.2	220.8	223.9	227.2	230.8	234.5
170.3	176.5	184.1	186.8	187.8	190.2	193.8	194.8	195.6	199.9	204.5	207.0	207.9	210.6	213.5	214.4	214.8	221.3	227.3	230.8	235.2	237.0	238.8	241.2	244.5	240.8	237.7	239.1	242.4	245.5	249.0
188.1	197.5	205.7	205.8	204.5	206.9	214.1	215.1	214.5	217.3	221.9	224.5	220.2	222.9	227.1	231.6	232.0	238.4	243.6	247.1	254.0	256.4	258.2	260.0	262.5	258.5	254.7	256.1	257.6	261.3	265.1
205.4	213.4	220.9	221.9	221.2	227.1	234.3	234.2	233.4	236.1	239.4	237.0	232.5	236.3	240.8	245.6	249.1	254.7	259.9	265.8	272.9	275.2	276.9	277.1	277.4	274.9	270.7	272.3	273.7	280.7	284.5
217.8	225.9	233.5	234.3	234.1	242.1	249.5	247.3	245.9	248.4	249.9	245.8	242.8	247.8	252.2	257.7	262.3	269.0	274.4	280.9	286.3	288.4	289.6	289.8	290.1	290.6	286.4	288.4	289.8	299.8	304.0
229.5	237.5	245.5	244.7	244.4	252.2	258.6	255.0	253.4	255.6	255.8	251.9	251.2	257.2	261.7	268.6	273.3	281.4	287.3	293.3	297.6	301.1	302.3	302.5	302.8	304.2	302.1	304.2	305.9	315.9	323.5
241.6	249.1	257.0	255.8	254.8	261.3	267.8	264.1	260.9	261.5	261.7	260.3	259.7	266.7	271.1	279.6	284.2	292.4	300.2	304.7	309.0	313.2	314.9	315.2	315.4	316.9	317.9	319.9	321.9	331.5	341.3
253.6	261.2	266.7	266.4	264.8	265.6	272.0	268.6	270.9	271.0	268.9	268.8	268.1	275.4	280.6	289.3	295.2	303.3	310.5	317.5	320.3	324.6	327.6	327.9	327.6	329.5	330.9	334.9	336.9	344.3	354.0
265.7	270.7	273.2	275.7	274.7	272.1	275.5	275.2	281.6	280.6	276.5	276.9	276.5	283.8	290.0	298.7	306.2	313.8	320.4	329.2	335.0	337.8	340.1	338.6	337.3	342.1	343.5	349.9	351.8	357.7	366.8
278.9	281.4	282.5	283.6	284.7	282.1	279.5	285.9	292.2	288.2	284.1	284.5	284.9	292.2	299.4	308.2	316.9	323.7	330.3	339.4	348.3	349.3	350.6	348.3	346.9	353.6	356.2	362.6	366.8	372.7	379.6
293.1	297.3	299.3	300.0	296.1	292.6	290.0	296.4	298.7	294.6	292.2	296.2	296.7	303.9	311.2	317.6	326.3	333.9	340.6	350.5	359.4	359.8	361.1	358.3	356.5	363.2	368.8	375.3	381.8	387.3	392.9
307.3	311.5	315.6	311.4	307.6	303.1	300.5	306.9	305.1	301.1	300.3	308.0	308.5	315.8	323.0	327.0	335.7	344.2	350.8	361.6	370.5	370.5	371.6	368.8	366.2	373.2	380.3	386.6	392.8	401.0	406.5
321.6	325.2	328.8	322.8	319.0	313.9	311.0	315.8	311.5	307.9	308.4	319.2	320.4	327.6	334.9	337.1	345.1	354.1	361.1	372.2	381.6	381.6	382.0	379.4	377.8	384.0	391.1	397.7	403.9	413.8	420.1
337.2	338.4	342.0	334.9	330.4	325.4	321.5	322.3	318.0	316.0	316.6	327.3	332.2	339.5	346.7	349.0	354.5	363.5	371.3	382.5	392.7	392.7	392.6	391.2	389.6	395.0	401.9	408.5	414.9	424.8	433.8
352.9	352.9	355.2	348.2	341.8	336.8	332.0	328.7	324.4	324.1	324.7	335.5	344.1	351.3	358.6	360.8	363.9	372.9	381.6	392.7	403.8	403.6	403.4	403.1	401.5	406.8	412.7	419.3	426.5	438.1	449.5
368.6	368.6	368.5	361.7	352.9	346.9	341.7	337.0	331.1	331.8	330.6	339.9	350.7	357.8	365.1	367.1	368.4	378.2	387.1	401.1	411.8	412.0	413.2	414.0	413.3	418.6	425.2	433.5	441.6	455.1	466.4
376.9	383.2	382.8	376.0	363.7	356.2	351.0	346.4	338.2	338.9	333.9	339.7	350.6	357.7	365.2	369.1	370.3	381.7	390.5	409.1	419.9	419.0	420.1	421.3	426.8	433.2	439.8	448.6	456.7	471.1	483.3
376.9	397.5	397.1	389.6	374.5	365.6	360.4	355.7	345.4	346.0	337.2	339.6	350.5	357.6	365.4	371.0	372.3	385.1	394.0	416.0	427.9	427.0	427.0	431.1	441.8	447.9	454.5	463.4	471.9	486.2	500.3
376.9	402.6	411.4	400.4	385.2	376.3	369.8	363.0	352.5	350.1	340.5	341.9	350.4	357.7	365.6	371.4	374.2	387.1	397.4	419.4	435.9	435.0	436.2	446.1	456.8	462.8	469.1	478.0	485.8	494.7	503.6
376.9	402.6	425.7	411.2	396.0	387.1	379.2	370.1	359.6	353.4	343.8	345.2	350.2	357.8	365.7	371.6	376.2	389.1	400.9	422.9	443.9	448.5	455.5	462.6	471.8	477.8	477.9	481.8	485.8	494.7	503.6
376.9	402.6	428.3	416.4	406.6	397.2	388.2	377.5	366.5	356.7	347.1	348.5	350.1	358.0	365.9	373.0	381.0	394.0	406.9	429.8	453.3	461.0	468.7	476.4	479.1	478.5	477.9	481.8	485.8	494.7	503.6
376.9	402.6	428.3	416.4	416.1	405.6	396.6	385.8	372.1	362.3	352.5	356.9	358.4	367.6	375.4	384.9	392.8	406.2	419.1	439.6	463.1	470.7	478.4	486.1	479.1	478.5	477.9	481.8	485.8	494.7	503.6
376.9	402.6	428.3	416.4	425.7	414.0	404.9	394.2	377.7	367.9	358.2	365.6	367.1	377.8	385.6	396.7	404.6	418.4	431.3	449.4	472.9	480.4	488.1	487.8	479.1	478.5	477.9	481.8	485.8	494.7	503.6
376.9	402.6	428.3	422.2	435.2	423.0	413.3	401.2	383.3	373.5	363.8	373.7	375.8	387.7	395.8	407.9	416.5	430.4	443.5	461.4	482.7	490.3	496.5	487.8	479.1	478.5	477.9	481.8	485.8	494.7	503.6
376.9	402.6	428.3	431.7	444.8	432.5	421.6	406.8	388.8	379.1	369.4	379.3	384.5	396.4	406.0	418.1	428.3	442.2	455.7	473.6	492.5	496.8	496.5	487.8	479.1	478.5	477.9	481.8	485.8	494.7	503.6
376.9	402.6	428.3	441.3	454.3	442.1	430.0	412.3	394.4	384.7	375.1	384.9	393.2	405.1	416.2	428.3	440.2	454.0	467.9	482.9	497.1	496.8	496.5	487.8	479.1	478.5	477.9	481.8	485.8	494.7	503.6
]'; % in deg. C

% (g/s), engine out total exhaust flow indexed vertically by fc_map_spd and
% horizontally by fc_map_trq
fc_exflow_map=[11.99	12.26	12.54	14.07	15.60	17.24	18.88	20.57	22.26	22.97	23.68	25.04	26.41	31.04	35.68	38.56	41.44	44.32	47.21	51.18	55.15	56.34	57.52	61.23	64.94	67.63	70.33	73.59	76.84	78.88	80.92
12.04	12.36	12.87	14.40	15.86	17.50	19.25	20.95	22.72	23.85	24.55	25.92	27.60	32.23	35.68	38.66	41.54	44.43	47.21	51.18	55.15	56.34	57.52	61.23	64.94	67.63	70.33	73.59	76.84	78.88	80.92
12.19	12.70	13.21	14.66	16.12	17.84	19.63	21.38	23.19	24.42	25.43	27.02	28.79	32.63	35.68	38.69	41.64	44.45	47.21	51.18	55.15	56.34	57.52	61.23	64.94	67.63	70.38	73.63	76.90	78.93	80.99
12.59	13.05	13.44	14.90	16.97	18.74	20.16	21.94	23.79	25.24	26.62	28.37	30.86	33.56	36.14	39.30	42.62	45.41	48.45	52.19	55.68	57.09	58.54	61.82	65.57	68.04	70.83	73.95	77.21	79.12	81.14
13.31	13.38	13.66	16.01	18.84	20.60	20.99	22.78	25.02	26.84	28.22	29.96	34.70	37.40	39.16	41.28	44.60	47.43	50.96	54.69	57.40	58.75	60.17	63.16	66.47	68.83	71.27	74.40	77.53	79.43	81.33
14.26	14.63	15.12	17.89	20.71	21.47	21.83	23.93	26.24	28.10	29.81	33.72	38.54	40.57	42.18	44.20	46.59	49.93	53.47	56.47	59.12	60.47	61.76	64.60	67.46	69.74	72.11	75.11	78.25	79.69	81.59
15.69	16.51	17.10	19.84	22.37	22.68	23.31	26.01	28.41	30.30	32.62	37.45	41.67	43.10	44.70	46.61	48.58	51.71	55.31	57.91	60.23	61.73	62.98	65.67	68.52	70.65	73.02	75.84	78.98	80.00	81.85
17.13	17.93	18.67	21.37	23.91	24.32	25.55	28.84	31.32	33.34	36.26	40.96	44.07	45.19	46.78	48.61	50.57	53.17	56.59	59.07	61.11	62.94	64.20	66.75	69.59	71.67	73.92	76.74	79.72	80.73	82.11
17.49	18.98	19.91	22.70	25.44	26.57	27.79	31.09	34.23	36.99	39.90	43.36	46.48	47.28	48.87	50.60	52.57	55.16	57.86	59.95	61.99	64.02	65.41	67.97	70.65	72.73	74.83	77.65	80.50	81.67	82.81
17.85	19.34	21.12	23.66	26.33	28.78	30.01	33.30	36.02	38.99	42.33	45.76	48.88	49.60	50.96	52.67	54.56	57.16	59.15	61.35	62.87	64.90	66.63	69.19	71.86	73.96	76.16	79.33	82.21	83.71	84.85
18.20	20.06	22.28	24.51	27.11	30.33	32.22	35.20	37.48	40.64	44.30	48.01	51.28	52.00	53.05	54.76	56.56	58.81	60.44	62.96	64.97	66.46	67.90	70.84	73.77	75.35	77.54	81.04	83.92	85.65	86.89
18.43	20.72	23.11	25.51	27.90	31.11	34.33	36.63	38.94	42.61	46.26	49.98	53.68	54.40	55.14	56.83	58.49	60.13	61.76	64.36	66.94	68.26	69.59	72.75	75.67	76.95	78.93	82.45	85.64	87.36	88.93
18.53	20.71	23.03	25.47	28.32	31.80	35.02	37.32	40.11	43.80	47.53	50.84	54.54	55.48	56.21	58.31	59.98	61.69	63.32	66.07	68.65	69.95	71.28	74.55	77.58	78.86	80.32	83.83	87.35	88.98	90.62
18.64	20.81	23.03	25.89	28.74	32.49	35.71	38.01	41.28	44.96	48.74	51.64	55.34	56.51	57.24	59.79	61.46	63.25	64.88	67.78	70.36	71.65	72.98	76.24	79.49	80.87	82.27	85.94	89.61	90.38	92.02
18.75	21.06	23.39	26.31	29.16	33.08	36.40	38.89	42.45	46.14	49.96	52.52	56.14	57.49	58.26	61.13	62.94	64.78	66.44	69.41	72.07	73.36	74.67	77.97	81.61	83.13	84.53	88.21	91.88	92.05	93.41
18.94	21.43	23.76	26.71	29.58	33.50	37.09	40.05	43.61	47.36	51.17	53.74	56.95	58.29	59.29	62.16	64.42	66.26	68.00	70.97	73.78	75.07	76.68	80.10	83.74	85.37	86.80	90.47	94.14	94.32	94.81
19.14	21.71	24.12	27.07	30.00	33.92	37.78	41.22	44.78	48.57	52.39	54.95	57.75	59.09	60.32	63.19	65.91	67.75	69.56	72.53	75.49	77.68	79.88	82.23	85.87	87.50	89.06	92.74	96.34	96.44	96.52
19.33	21.90	24.48	27.44	30.56	34.55	38.50	42.11	45.77	49.60	53.68	56.45	59.01	60.36	61.91	64.97	67.98	70.05	71.91	74.52	77.55	79.90	82.68	85.29	87.99	89.63	91.01	94.57	98.05	98.33	98.41
19.43	22.25	24.88	27.84	31.21	35.28	39.23	42.84	46.60	50.43	55.05	58.30	60.86	62.21	64.17	67.34	70.35	72.72	74.59	76.58	79.62	81.56	84.30	87.08	89.94	91.19	92.56	96.29	99.77	100.14	100.30
19.43	22.65	25.28	28.29	31.87	36.00	39.95	43.57	47.43	51.25	56.43	60.15	62.71	64.06	66.43	69.70	72.72	75.40	77.27	78.80	81.69	83.63	85.93	88.76	91.71	92.74	94.12	97.88	101.49	101.86	102.19
19.43	22.79	25.67	28.94	32.52	36.66	40.68	44.39	48.25	52.50	57.80	61.67	64.56	66.20	68.69	71.98	75.09	77.78	79.94	81.48	83.75	85.69	87.72	90.53	93.49	94.51	95.67	99.43	103.07	102.82	102.56
19.43	22.79	26.07	29.60	33.18	37.32	41.41	45.21	49.08	53.88	59.18	63.04	66.41	68.47	70.95	74.24	77.45	80.15	82.62	84.15	85.82	88.00	90.29	92.58	95.26	96.29	96.60	99.84	103.07	102.82	102.56
19.43	22.79	26.14	29.92	33.84	38.00	42.15	46.02	49.91	55.25	60.56	64.42	68.26	70.73	73.21	76.34	79.35	81.89	84.57	85.96	87.11	89.26	91.67	94.09	96.13	96.37	96.60	99.84	103.07	102.82	102.56
19.43	22.79	26.14	29.92	34.54	38.76	42.90	46.78	50.81	56.15	61.46	64.93	68.78	71.02	73.54	77.06	80.08	82.13	84.80	87.04	88.18	89.99	92.41	94.82	96.13	96.37	96.60	99.84	103.07	102.82	102.56
19.43	22.79	26.14	29.92	35.24	39.51	43.66	47.54	51.71	57.05	62.32	65.38	69.23	71.20	73.71	77.79	80.80	82.36	85.04	88.11	89.26	91.05	93.14	94.96	96.13	96.37	96.60	99.84	103.07	102.82	102.56
19.43	22.79	26.14	30.34	35.94	40.24	44.42	48.36	52.61	57.94	63.18	65.91	69.68	71.43	73.88	78.29	81.52	82.89	85.27	88.42	90.33	92.12	93.78	94.96	96.13	96.37	96.60	99.84	103.07	102.82	102.56
19.43	22.79	26.14	31.04	36.64	40.94	45.17	49.26	53.51	58.80	64.04	66.77	70.13	71.88	74.06	78.47	82.25	83.62	85.51	88.65	91.41	92.84	93.78	94.96	96.13	96.37	96.60	99.84	103.07	102.82	102.56
19.43	22.79	26.14	31.74	37.34	41.64	45.93	50.16	54.40	59.66	64.90	67.63	70.58	72.33	74.23	78.64	82.97	84.34	85.75	88.83	91.90	92.84	93.78	94.96	96.13	96.37	96.60	99.84	103.07	102.82	102.56
]';

% (m^3/s), engine out total volume exhaust flow indexed vertically by fc_map_spd and
% horizontally by fc_map_trq
fc_exflow_vol_map=[0.0133	0.0138	0.0143	0.0161	0.0178	0.0199	0.0220	0.0240	0.0260	0.0272	0.0284	0.0303	0.0321	0.0406	0.0490	0.0533	0.0575	0.0617	0.0660	0.0723	0.0786	0.0802	0.0817	0.0874	0.0931	0.0957	0.0983	0.1035	0.1087	0.1119	0.1152
0.0139	0.0145	0.0153	0.0171	0.0190	0.0211	0.0235	0.0255	0.0278	0.0296	0.0308	0.0326	0.0350	0.0435	0.0490	0.0530	0.0572	0.0615	0.0660	0.0723	0.0786	0.0802	0.0817	0.0874	0.0931	0.0957	0.0983	0.1035	0.1087	0.1119	0.1152
0.0147	0.0155	0.0163	0.0183	0.0202	0.0225	0.0249	0.0272	0.0296	0.0315	0.0332	0.0354	0.0380	0.0445	0.0490	0.0529	0.0569	0.0614	0.0660	0.0723	0.0786	0.0802	0.0817	0.0874	0.0931	0.0957	0.0988	0.1040	0.1093	0.1130	0.1168
0.0158	0.0166	0.0174	0.0194	0.0222	0.0246	0.0267	0.0291	0.0316	0.0339	0.0361	0.0386	0.0421	0.0461	0.0499	0.0544	0.0591	0.0638	0.0690	0.0747	0.0804	0.0828	0.0851	0.0904	0.0964	0.0993	0.1027	0.1077	0.1130	0.1165	0.1203
0.0173	0.0178	0.0185	0.0217	0.0256	0.0280	0.0291	0.0314	0.0346	0.0375	0.0397	0.0422	0.0487	0.0527	0.0557	0.0594	0.0640	0.0688	0.0749	0.0807	0.0859	0.0884	0.0908	0.0957	0.1010	0.1038	0.1067	0.1117	0.1167	0.1204	0.1242
0.0192	0.0201	0.0212	0.0251	0.0290	0.0304	0.0314	0.0343	0.0376	0.0406	0.0433	0.0487	0.0553	0.0586	0.0615	0.0651	0.0690	0.0748	0.0809	0.0863	0.0915	0.0940	0.0963	0.1008	0.1053	0.1084	0.1113	0.1163	0.1213	0.1252	0.1290
0.0217	0.0233	0.0245	0.0284	0.0321	0.0330	0.0345	0.0383	0.0417	0.0447	0.0484	0.0550	0.0610	0.0637	0.0666	0.0703	0.0738	0.0796	0.0859	0.0909	0.0955	0.0983	0.1006	0.1049	0.1095	0.1131	0.1159	0.1210	0.1260	0.1301	0.1338
0.0242	0.0258	0.0274	0.0313	0.0349	0.0361	0.0385	0.0432	0.0466	0.0499	0.0544	0.0609	0.0657	0.0683	0.0711	0.0750	0.0785	0.0838	0.0899	0.0948	0.0989	0.1026	0.1048	0.1091	0.1136	0.1173	0.1205	0.1257	0.1307	0.1348	0.1387
0.0253	0.0280	0.0298	0.0339	0.0378	0.0401	0.0425	0.0472	0.0516	0.0559	0.0604	0.0656	0.0704	0.0728	0.0757	0.0798	0.0833	0.0886	0.0939	0.0982	0.1023	0.1065	0.1091	0.1134	0.1177	0.1215	0.1252	0.1303	0.1355	0.1397	0.1440
0.0264	0.0291	0.0322	0.0360	0.0399	0.0438	0.0463	0.0509	0.0553	0.0599	0.0650	0.0703	0.0751	0.0774	0.0802	0.0843	0.0880	0.0933	0.0977	0.1027	0.1058	0.1099	0.1133	0.1176	0.1221	0.1261	0.1302	0.1367	0.1420	0.1464	0.1507
0.0275	0.0307	0.0343	0.0379	0.0418	0.0467	0.0500	0.0545	0.0586	0.0635	0.0689	0.0748	0.0799	0.0822	0.0847	0.0888	0.0928	0.0976	0.1015	0.1073	0.1118	0.1148	0.1177	0.1226	0.1274	0.1313	0.1354	0.1432	0.1485	0.1531	0.1573
0.0285	0.0323	0.0361	0.0399	0.0437	0.0486	0.0536	0.0578	0.0620	0.0674	0.0729	0.0787	0.0846	0.0869	0.0892	0.0933	0.0975	0.1014	0.1053	0.1115	0.1175	0.1201	0.1228	0.1279	0.1327	0.1365	0.1405	0.1484	0.1549	0.1595	0.1640
0.0294	0.0333	0.0371	0.0409	0.0453	0.0508	0.0557	0.0599	0.0646	0.0701	0.0760	0.0819	0.0878	0.0906	0.0929	0.0975	0.1016	0.1060	0.1100	0.1168	0.1228	0.1253	0.1279	0.1331	0.1381	0.1418	0.1456	0.1535	0.1614	0.1659	0.1704
0.0303	0.0342	0.0381	0.0425	0.0469	0.0530	0.0579	0.0621	0.0673	0.0728	0.0791	0.0851	0.0909	0.0942	0.0965	0.1017	0.1058	0.1107	0.1146	0.1220	0.1281	0.1304	0.1330	0.1382	0.1434	0.1475	0.1518	0.1603	0.1685	0.1721	0.1766
0.0312	0.0354	0.0396	0.0441	0.0485	0.0549	0.0601	0.0645	0.0699	0.0755	0.0822	0.0882	0.0941	0.0978	0.1002	0.1057	0.1100	0.1151	0.1192	0.1270	0.1334	0.1357	0.1382	0.1434	0.1500	0.1544	0.1587	0.1674	0.1756	0.1786	0.1828
0.0324	0.0369	0.0410	0.0457	0.0502	0.0565	0.0622	0.0671	0.0726	0.0786	0.0853	0.0913	0.0972	0.1009	0.1038	0.1093	0.1141	0.1193	0.1238	0.1316	0.1387	0.1410	0.1440	0.1502	0.1567	0.1612	0.1655	0.1742	0.1827	0.1857	0.1889
0.0335	0.0382	0.0425	0.0472	0.0518	0.0582	0.0644	0.0698	0.0752	0.0817	0.0884	0.0944	0.1004	0.1041	0.1075	0.1130	0.1183	0.1234	0.1284	0.1362	0.1439	0.1482	0.1524	0.1569	0.1634	0.1679	0.1723	0.1810	0.1899	0.1933	0.1966
0.0346	0.0393	0.0440	0.0487	0.0537	0.0602	0.0667	0.0722	0.0777	0.0845	0.0914	0.0976	0.1036	0.1072	0.1113	0.1172	0.1228	0.1287	0.1338	0.1418	0.1498	0.1543	0.1599	0.1651	0.1701	0.1746	0.1792	0.1885	0.1976	0.2019	0.2052
0.0352	0.0409	0.0457	0.0504	0.0558	0.0625	0.0690	0.0745	0.0801	0.0868	0.0943	0.1008	0.1068	0.1104	0.1154	0.1219	0.1275	0.1344	0.1396	0.1477	0.1556	0.1592	0.1647	0.1703	0.1772	0.1815	0.1861	0.1962	0.2052	0.2100	0.2138
0.0352	0.0426	0.0474	0.0522	0.0580	0.0648	0.0713	0.0768	0.0825	0.0892	0.0972	0.1040	0.1100	0.1136	0.1195	0.1265	0.1322	0.1402	0.1453	0.1535	0.1614	0.1650	0.1695	0.1760	0.1847	0.1884	0.1930	0.2033	0.2129	0.2177	0.2223
0.0352	0.0432	0.0491	0.0544	0.0601	0.0670	0.0736	0.0791	0.0848	0.0920	0.1000	0.1069	0.1132	0.1175	0.1235	0.1307	0.1368	0.1449	0.1511	0.1592	0.1672	0.1708	0.1752	0.1834	0.1921	0.1958	0.1999	0.2102	0.2199	0.2220	0.2240
0.0352	0.0432	0.0508	0.0565	0.0622	0.0691	0.0759	0.0815	0.0872	0.0948	0.1029	0.1098	0.1164	0.1215	0.1276	0.1348	0.1415	0.1495	0.1568	0.1649	0.1731	0.1787	0.1852	0.1917	0.1995	0.2033	0.2041	0.2120	0.2199	0.2220	0.2240
0.0352	0.0432	0.0511	0.0575	0.0644	0.0713	0.0782	0.0839	0.0896	0.0977	0.1058	0.1127	0.1196	0.1256	0.1317	0.1389	0.1460	0.1538	0.1618	0.1701	0.1779	0.1844	0.1913	0.1982	0.2031	0.2036	0.2041	0.2120	0.2199	0.2220	0.2240
0.0352	0.0432	0.0511	0.0575	0.0667	0.0738	0.0807	0.0864	0.0920	0.1002	0.1083	0.1152	0.1221	0.1281	0.1342	0.1429	0.1500	0.1571	0.1651	0.1747	0.1826	0.1883	0.1953	0.2022	0.2031	0.2036	0.2041	0.2120	0.2199	0.2220	0.2240
0.0352	0.0432	0.0511	0.0575	0.0690	0.0762	0.0831	0.0888	0.0945	0.1026	0.1108	0.1176	0.1245	0.1305	0.1366	0.1469	0.1540	0.1604	0.1684	0.1793	0.1872	0.1929	0.1993	0.2029	0.2031	0.2036	0.2041	0.2120	0.2199	0.2220	0.2240
0.0352	0.0432	0.0511	0.0589	0.0713	0.0786	0.0856	0.0913	0.0969	0.1051	0.1133	0.1201	0.1270	0.1329	0.1390	0.1502	0.1580	0.1641	0.1717	0.1827	0.1918	0.1976	0.2027	0.2029	0.2031	0.2036	0.2041	0.2120	0.2199	0.2220	0.2240
0.0352	0.0432	0.0511	0.0612	0.0736	0.0809	0.0880	0.0937	0.0994	0.1076	0.1158	0.1226	0.1295	0.1354	0.1414	0.1526	0.1620	0.1681	0.1750	0.1860	0.1964	0.2006	0.2027	0.2029	0.2031	0.2036	0.2041	0.2120	0.2199	0.2220	0.2240
0.0352	0.0432	0.0511	0.0635	0.0759	0.0832	0.0905	0.0962	0.1019	0.1101	0.1183	0.1251	0.1319	0.1378	0.1437	0.1550	0.1660	0.1721	0.1783	0.1885	0.1986	0.2006	0.2027	0.2029	0.2031	0.2036	0.2041	0.2120	0.2199	0.2220	0.2240
]';

% adjust ex gas temperature map to estimate temperature drop across manifold & turbo 
%  assume delta T is equal to 10% of the temp diff between gas temp and 20 C ambient
fc_extmp_map=fc_extmp_map + (fc_extmp_map - 20)*0.1;

% create BS** maps for plotting purposes
[T,w]=meshgrid(fc_map_trq(2:end),fc_map_spd);
fc_map_kW=T.*w/1000;
fc_fuel_map_gpkWh=fc_fuel_map(:,2:end)./fc_map_kW*3600;
fc_co_map_gpkWh=fc_co_map(:,2:end)./fc_map_kW*3600;
fc_hc_map_gpkWh=fc_hc_map(:,2:end)./fc_map_kW*3600;
fc_nox_map_gpkWh=fc_nox_map(:,2:end)./fc_map_kW*3600;
fc_pm_map_gpkWh=fc_pm_map(:,2:end)./fc_map_kW*3600;

% replace zero torque column values
fc_fuel_map_gpkWh=[fc_fuel_map_gpkWh(:,1)*1.1 fc_fuel_map_gpkWh];
fc_co_map_gpkWh=[fc_co_map_gpkWh(:,1)*1.1 fc_co_map_gpkWh];
fc_nox_map_gpkWh=[fc_nox_map_gpkWh(:,1)*1.1 fc_nox_map_gpkWh];
fc_hc_map_gpkWh=[fc_hc_map_gpkWh(:,1)*1.1 fc_hc_map_gpkWh];
fc_pm_map_gpkWh=[fc_pm_map_gpkWh(:,1)*1.1 fc_pm_map_gpkWh];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Cold Engine Maps
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Note: original data from ORNL ranged from 0-130 Nm and 1200-2800 rpm.  
%       The other values (required to fill out the map) are taken to be the same as hot values

fc_cold_tmp=32.2; %deg C (90F)
% (g/s) , cold fuel use map (at temperature fc_cold_tmp) indexed vertically by fc_map_spd and 
% horizontally by fc_map_trq
fc_fuel_map_cold=[0.205	0.223	0.241	0.259	0.277	0.303	0.330	0.356	0.382	0.410	0.438	0.465	0.493	0.572	0.651	0.730	0.809	0.767	0.803	0.866	0.928	0.950	0.972	1.022	1.071	1.103	1.134	1.196	1.257	1.304	1.350
0.238	0.256	0.275	0.300	0.325	0.351	0.377	0.406	0.437	0.476	0.508	0.536	0.564	0.599	0.651	0.730	0.809	0.757	0.803	0.866	0.928	0.950	0.972	1.022	1.071	1.103	1.134	1.196	1.257	1.304	1.350
0.272	0.298	0.323	0.347	0.372	0.400	0.431	0.461	0.491	0.530	0.569	0.607	0.635	0.670	0.705	0.741	0.809	0.754	0.803	0.866	0.928	0.950	0.972	1.022	1.071	1.103	1.148	1.213	1.278	1.342	1.407
0.312	0.338	0.365	0.395	0.425	0.455	0.485	0.516	0.548	0.589	0.629	0.669	0.709	0.752	0.789	0.827	0.865	0.801	0.854	0.907	0.961	1.003	1.043	1.100	1.154	1.209	1.265	1.336	1.400	1.467	1.532
0.354	0.390	0.420	0.450	0.480	0.511	0.541	0.578	0.618	0.667	0.714	0.754	0.794	0.844	0.894	0.932	0.969	0.898	0.957	1.010	1.069	1.116	1.157	1.216	1.272	1.326	1.381	1.452	1.523	1.592	1.662
0.397	0.433	0.470	0.505	0.536	0.568	0.608	0.648	0.688	0.737	0.786	0.835	0.879	0.929	0.979	1.029	1.074	1.001	1.060	1.117	1.176	1.224	1.273	1.334	1.394	1.455	1.511	1.584	1.656	1.735	1.805
0.441	0.477	0.513	0.551	0.592	0.640	0.680	0.720	0.761	0.810	0.859	0.908	0.965	1.021	1.072	1.122	1.172	1.109	1.168	1.228	1.291	1.347	1.398	1.459	1.520	1.587	1.643	1.717	1.790	1.877	1.948
0.485	0.526	0.567	0.608	0.649	0.700	0.752	0.794	0.835	0.884	0.936	0.994	1.053	1.115	1.168	1.218	1.269	1.220	1.280	1.342	1.409	1.472	1.523	1.584	1.645	1.714	1.775	1.850	1.923	2.010	2.090
0.531	0.575	0.619	0.663	0.706	0.757	0.809	0.860	0.909	0.965	1.023	1.082	1.140	1.202	1.264	1.315	1.365	1.324	1.393	1.459	1.527	1.594	1.648	1.709	1.770	1.840	1.908	1.982	2.059	2.150	2.241
0.577	0.621	0.665	0.713	0.764	0.826	0.881	0.932	0.983	1.052	1.111	1.169	1.228	1.290	1.352	1.411	1.461	1.429	1.503	1.577	1.644	1.712	1.773	1.834	1.898	1.979	2.057	2.151	2.229	2.326	2.417
0.623	0.670	0.721	0.772	0.823	0.885	0.947	1.006	1.058	1.126	1.195	1.257	1.315	1.377	1.439	1.502	1.558	1.536	1.613	1.690	1.762	1.829	1.899	1.970	2.041	2.130	2.209	2.322	2.400	2.500	2.592
0.671	0.724	0.776	0.829	0.881	0.944	1.007	1.069	1.132	1.201	1.270	1.338	1.403	1.465	1.527	1.592	1.658	1.647	1.724	1.806	1.886	1.962	2.037	2.113	2.184	2.279	2.361	2.475	2.570	2.670	2.768
0.721	0.774	0.826	0.881	0.944	1.018	1.081	1.144	1.206	1.275	1.344	1.413	1.493	1.570	1.636	1.702	1.767	1.771	1.848	1.941	2.022	2.101	2.176	2.253	2.326	2.421	2.513	2.627	2.741	2.842	2.944
0.771	0.824	0.880	0.943	1.006	1.085	1.155	1.218	1.281	1.349	1.418	1.494	1.584	1.671	1.745	1.811	1.877	1.894	1.971	2.077	2.157	2.238	2.314	2.392	2.469	2.572	2.676	2.796	2.914	3.019	3.121
0.821	0.880	0.943	1.006	1.069	1.147	1.226	1.292	1.355	1.424	1.495	1.585	1.676	1.763	1.850	1.921	1.986	2.012	2.095	2.206	2.293	2.374	2.453	2.532	2.625	2.741	2.846	2.970	3.087	3.194	3.297
0.875	0.942	1.005	1.069	1.132	1.210	1.288	1.366	1.429	1.498	1.586	1.677	1.768	1.855	1.942	2.028	2.096	2.121	2.218	2.329	2.428	2.509	2.595	2.689	2.783	2.909	3.015	3.140	3.261	3.368	3.473
0.930	0.997	1.064	1.131	1.194	1.273	1.351	1.429	1.503	1.588	1.678	1.769	1.859	1.946	2.033	2.120	2.205	2.230	2.342	2.453	2.564	2.658	2.752	2.847	2.941	3.066	3.185	3.309	3.435	3.552	3.667
0.986	1.053	1.122	1.191	1.260	1.344	1.423	1.501	1.580	1.671	1.762	1.853	1.952	2.054	2.143	2.232	2.322	2.352	2.468	2.590	2.703	2.808	2.906	3.004	3.098	3.224	3.355	3.489	3.618	3.755	3.869
0.994	1.122	1.191	1.260	1.329	1.420	1.501	1.579	1.658	1.749	1.840	1.933	2.046	2.165	2.260	2.349	2.439	2.480	2.597	2.729	2.842	2.953	3.052	3.151	3.263	3.395	3.527	3.671	3.800	3.948	4.072
0.994	1.145	1.260	1.329	1.398	1.489	1.579	1.657	1.736	1.827	1.918	2.027	2.139	2.259	2.377	2.466	2.556	2.609	2.725	2.866	2.982	3.092	3.198	3.305	3.434	3.566	3.698	3.845	3.982	4.130	4.275
0.994	1.145	1.295	1.398	1.467	1.558	1.649	1.735	1.814	1.905	2.008	2.121	2.233	2.352	2.471	2.584	2.673	2.726	2.853	2.994	3.121	3.232	3.348	3.476	3.604	3.737	3.870	4.017	4.150	4.233	4.315
0.994	1.145	1.295	1.446	1.536	1.627	1.718	1.810	1.892	1.989	2.102	2.214	2.327	2.446	2.565	2.684	2.790	2.844	2.981	3.122	3.261	3.385	3.516	3.646	3.775	3.908	3.973	4.062	4.150	4.233	4.315
0.994	1.145	1.295	1.446	1.605	1.696	1.787	1.879	1.970	2.083	2.195	2.308	2.421	2.543	2.665	2.786	2.907	2.964	3.109	3.254	3.397	3.538	3.670	3.802	3.859	3.916	3.973	4.062	4.150	4.233	4.315
0.994	1.145	1.295	1.452	1.676	1.767	1.858	1.954	2.054	2.166	2.278	2.393	2.519	2.660	2.782	2.903	3.024	3.092	3.238	3.389	3.531	3.684	3.816	3.948	3.859	3.916	3.973	4.062	4.150	4.233	4.315
0.994	1.145	1.299	1.523	1.746	1.839	1.938	2.038	2.137	2.249	2.365	2.491	2.617	2.758	2.898	3.020	3.142	3.220	3.366	3.524	3.666	3.819	3.963	3.975	3.859	3.916	3.973	4.062	4.150	4.233	4.315
0.994	1.147	1.370	1.588	1.786	1.908	2.021	2.121	2.220	2.337	2.463	2.590	2.716	2.856	2.997	3.137	3.259	3.343	3.494	3.652	3.801	3.954	4.090	3.975	3.859	3.916	3.973	4.062	4.150	4.233	4.315
0.994	1.192	1.390	1.588	1.786	1.908	2.030	2.151	2.273	2.416	2.559	2.688	2.814	2.954	3.095	3.235	3.373	3.461	3.622	3.780	3.936	4.044	4.090	3.975	3.859	3.916	3.973	4.062	4.150	4.233	4.315
0.992	1.171	1.350	1.632	1.915	2.019	2.123	2.221	2.318	2.447	2.580	2.716	2.848	2.997	3.139	3.275	3.408	3.580	3.750	3.879	3.998	4.044	4.090	3.975	3.859	3.916	3.973	4.062	4.150	4.233	4.315
]';
% (g/s), cold engine out HC emissions indexed vertically by fc_map_spd and
% horizontally by fc_map_trq
fc_hc_map_cold=1e-3*[6.67	7.31	7.95	8.59	9.23	11.00	12.77	14.54	16.31	19.47	22.63	25.79	28.95	26.29	23.63	20.96	18.30	17.18	19.82	22.21	24.60	23.99	23.37	22.95	22.53	23.12	23.72	23.15	22.58	21.61	20.64
5.90	6.54	7.16	7.67	8.17	9.94	11.71	12.97	14.04	15.86	18.41	21.57	24.73	24.67	23.63	20.96	18.30	15.75	19.82	22.21	24.60	23.99	23.37	22.95	22.53	23.12	23.72	23.15	22.58	21.61	20.64
5.13	5.61	6.10	6.61	7.11	8.56	9.63	10.70	11.77	13.59	15.41	17.35	20.51	20.45	20.39	20.34	18.30	15.36	19.82	22.21	24.60	23.99	23.37	22.95	22.53	23.12	23.41	22.67	22.02	20.91	19.62
4.34	4.81	5.28	5.71	6.14	7.02	7.90	8.78	9.61	11.38	13.21	15.03	16.86	17.51	17.74	17.97	18.19	14.60	18.22	20.92	23.11	21.98	20.69	20.86	20.29	20.88	20.96	19.42	18.74	18.40	17.35
3.68	3.91	4.34	4.77	5.20	6.08	6.96	7.64	8.24	9.74	11.31	13.13	14.96	16.23	17.50	17.77	17.99	12.92	15.02	17.72	18.21	17.53	16.34	16.99	17.14	17.88	18.51	16.97	15.46	15.15	14.85
3.18	3.39	3.61	3.83	4.26	5.09	5.68	6.27	6.86	8.36	9.86	11.37	13.06	14.33	15.60	16.88	17.79	9.71	11.82	12.96	13.32	12.63	12.33	13.59	14.89	14.30	14.96	14.05	12.48	12.10	11.80
2.73	2.94	3.15	3.35	3.54	4.03	4.64	5.25	5.86	7.37	8.88	10.39	11.60	12.35	13.61	14.88	16.15	7.86	9.84	10.58	11.03	11.08	11.08	12.00	13.29	10.55	11.21	11.09	9.51	9.06	8.75
2.30	2.48	2.67	2.86	3.05	3.50	3.94	4.52	5.12	6.64	8.03	9.21	10.38	10.56	11.59	12.85	14.12	7.06	8.92	9.54	9.71	9.84	9.84	10.45	11.70	8.36	7.46	7.38	6.55	6.10	5.71
2.05	2.18	2.30	2.42	2.57	3.01	3.46	3.91	4.39	5.65	6.82	8.00	9.17	9.35	9.56	10.83	12.09	6.67	8.00	8.22	8.39	8.56	8.59	9.20	10.11	6.77	3.70	3.62	3.74	3.60	3.47
1.80	1.93	2.05	2.16	2.26	2.56	2.96	3.41	3.86	4.46	5.61	6.78	7.96	8.14	8.32	8.80	10.07	6.27	7.04	7.14	7.07	7.24	7.35	7.96	8.57	6.03	3.27	3.57	3.84	3.77	3.64
1.55	1.67	1.77	1.87	1.97	2.27	2.58	2.91	3.36	3.97	4.57	5.57	6.74	6.93	7.11	7.29	8.04	5.60	6.07	6.26	6.32	6.24	6.20	6.71	7.32	6.09	3.34	3.67	3.94	3.92	3.81
1.38	1.46	1.53	1.61	1.68	1.99	2.30	2.60	2.91	3.48	4.08	4.68	5.53	5.71	5.89	6.21	6.55	4.71	5.18	5.46	5.73	5.81	5.88	5.46	6.07	5.63	3.40	3.74	4.04	4.02	3.98
1.26	1.33	1.41	1.49	1.59	1.82	2.12	2.43	2.74	3.31	3.87	4.44	4.97	5.30	5.64	5.97	6.31	4.39	4.86	5.13	5.41	5.48	5.56	4.69	4.81	4.38	3.46	3.80	4.14	4.21	4.28
1.13	1.20	1.29	1.39	1.50	1.70	1.95	2.26	2.57	3.13	3.70	4.24	4.74	5.07	5.40	5.74	6.07	4.07	4.54	4.80	5.08	5.16	5.23	4.36	3.56	3.54	3.64	4.23	4.64	4.62	4.69
1.00	1.09	1.20	1.30	1.40	1.60	1.80	2.08	2.39	2.96	3.52	4.01	4.51	4.84	5.16	5.50	5.83	3.79	4.21	4.48	4.75	4.83	4.91	4.07	3.59	3.78	3.88	4.73	5.15	5.06	5.10
0.97	1.01	1.10	1.21	1.31	1.51	1.71	1.91	2.22	2.79	3.29	3.78	4.28	4.60	4.93	5.26	5.59	3.58	3.89	4.16	4.43	4.51	4.59	4.20	3.72	4.00	4.12	5.00	5.65	5.56	5.50
0.98	1.03	1.07	1.12	1.22	1.42	1.62	1.82	2.05	2.56	3.06	3.55	4.05	4.37	4.70	5.03	5.36	3.37	3.57	3.83	4.10	4.19	4.29	4.33	3.85	4.13	4.35	5.24	6.10	6.11	6.05
1.00	1.04	1.09	1.14	1.19	1.37	1.58	1.78	1.98	2.47	2.96	3.45	3.95	4.29	4.63	4.98	5.33	3.29	3.46	3.77	4.08	4.20	4.11	4.08	3.98	4.26	4.69	5.36	6.19	6.74	6.68
1.00	1.08	1.13	1.18	1.23	1.38	1.57	1.77	1.98	2.47	2.96	3.45	3.98	4.29	4.63	4.98	5.33	3.27	3.45	3.75	4.07	4.36	4.30	4.21	4.23	4.72	5.16	5.45	6.28	7.12	7.31
1.00	1.09	1.17	1.21	1.26	1.41	1.57	1.77	1.97	2.46	2.95	3.47	4.00	4.31	4.63	4.97	5.32	3.26	3.43	3.74	4.05	4.34	4.48	4.46	4.61	5.19	5.63	5.83	6.38	7.21	7.94
1.00	1.09	1.18	1.25	1.30	1.45	1.60	1.77	1.97	2.46	2.97	3.50	4.03	4.34	4.65	4.97	5.32	3.27	3.42	3.72	4.03	4.33	4.64	4.84	4.99	5.57	6.09	6.30	6.46	7.26	8.06
1.00	1.09	1.18	1.28	1.34	1.48	1.63	1.78	1.96	2.47	2.99	3.52	4.05	4.36	4.67	4.99	5.31	3.27	3.40	3.71	4.02	4.37	4.74	5.12	5.36	5.94	6.37	6.42	6.46	7.26	8.06
1.00	1.09	1.18	1.28	1.39	1.54	1.68	1.82	1.96	2.49	3.02	3.55	4.10	4.48	4.85	5.22	5.59	3.27	3.38	3.79	4.14	4.52	4.89	5.26	5.55	5.96	6.37	6.42	6.46	7.26	8.06
1.00	1.09	1.18	1.30	1.61	1.75	1.90	1.97	2.01	2.53	3.06	3.64	4.47	5.13	5.52	5.89	6.26	3.25	3.35	3.95	4.30	4.69	5.06	5.43	5.55	5.96	6.37	6.42	6.46	7.26	8.06
1.00	1.09	1.20	1.51	1.83	1.95	1.99	2.02	2.05	2.58	3.18	4.02	4.85	5.51	6.17	6.56	6.93	3.22	3.33	4.10	4.45	4.85	5.23	5.46	5.55	5.96	6.37	6.42	6.46	7.26	8.06
1.00	1.10	1.41	1.71	1.95	1.99	2.03	2.06	2.09	2.72	3.56	4.39	5.23	5.89	6.55	7.21	7.59	3.23	3.30	4.09	4.61	5.00	5.37	5.46	5.55	5.96	6.37	6.42	6.46	7.26	8.06
1.00	1.24	1.47	1.71	1.95	1.99	2.03	2.08	2.12	3.02	3.92	4.77	5.61	6.27	6.93	7.59	8.24	3.27	3.27	4.06	4.77	5.11	5.37	5.46	5.55	5.96	6.37	6.42	6.46	7.26	8.06
0.59	0.61	0.63	0.77	0.90	1.02	1.14	1.30	1.45	1.88	2.33	2.30	2.30	2.72	3.13	3.25	3.37	3.30	3.24	4.04	4.85	5.11	5.37	5.46	5.55	5.96	6.37	6.42	6.46	7.26	8.06
]';
% (g/s), cold engine out CO emissions indexed vertically by fc_map_spd and
% horizontally by fc_map_trq
fc_co_map_cold=1e-3*[17.10	18.88	20.65	22.43	24.20	28.89	33.58	38.27	42.96	47.00	51.04	55.09	59.13	62.11	65.09	68.08	71.06	45.70	49.80	58.88	67.96	66.14	64.32	65.52	66.72	81.24	95.77	121.30	146.83	145.69	144.55
16.40	18.17	19.95	21.73	23.51	28.20	32.89	36.74	40.28	47.23	52.59	56.63	60.67	62.70	65.09	68.08	71.06	46.24	49.80	58.88	67.96	66.14	64.32	65.52	66.72	81.24	95.77	121.30	146.83	145.69	144.55
15.54	17.44	19.26	21.04	22.82	26.98	30.52	34.07	37.61	44.56	51.50	58.18	62.22	64.25	66.28	68.31	71.06	46.38	49.80	58.88	67.96	66.14	64.32	65.52	66.72	81.24	96.00	117.65	142.62	139.48	135.51
13.79	15.70	17.60	19.49	21.39	24.80	28.22	31.63	34.98	41.92	48.87	55.82	62.77	65.81	67.84	69.87	71.91	44.80	47.94	57.38	65.22	62.73	59.76	65.73	66.95	82.96	97.88	93.95	117.70	118.29	115.48
12.10	13.93	15.83	17.72	19.62	23.03	26.45	29.58	32.59	39.49	46.40	53.35	60.30	64.83	69.35	71.47	73.50	41.47	44.21	53.64	56.29	55.05	52.40	61.46	67.28	83.64	99.76	95.83	92.78	93.80	94.92
10.47	12.30	14.12	15.95	17.85	21.18	24.19	27.20	30.21	37.11	44.01	50.91	57.84	62.36	66.89	71.41	75.09	37.73	40.47	45.11	47.36	46.12	45.91	56.99	68.06	68.45	81.89	77.72	72.44	72.06	73.18
9.21	11.00	12.79	14.47	15.95	18.52	21.51	24.50	27.50	34.39	41.28	48.17	54.58	57.27	61.63	66.00	70.37	35.78	38.37	41.38	44.67	46.22	46.84	58.11	69.17	46.96	60.40	57.54	52.26	50.49	51.44
8.07	9.47	10.95	12.42	13.90	16.29	18.69	21.55	24.54	31.43	38.15	44.51	50.86	51.69	55.26	59.63	64.00	35.23	37.66	40.78	44.33	47.15	47.77	59.19	70.28	41.83	38.91	36.12	32.08	30.31	29.70
7.24	8.35	9.47	10.59	11.84	14.24	16.64	19.04	21.59	28.07	34.43	40.79	47.15	47.97	48.88	53.25	57.62	35.20	36.94	40.44	43.99	47.55	48.70	60.12	71.39	42.94	17.42	14.63	12.91	13.17	13.43
6.41	7.52	8.64	9.61	10.47	12.25	14.47	16.87	19.27	24.42	30.72	37.08	43.43	44.26	45.08	46.88	51.25	35.17	36.75	42.43	43.65	47.21	49.63	61.05	70.02	43.38	14.47	13.89	13.04	13.19	13.46
5.57	6.60	7.46	8.33	9.19	10.97	12.75	14.68	17.08	22.23	27.38	33.36	39.72	40.54	41.36	42.19	44.87	35.10	36.65	44.38	48.79	49.91	50.35	52.46	55.98	43.19	14.27	14.02	13.16	13.25	13.49
5.05	5.77	6.49	7.21	7.92	9.71	11.51	13.30	15.10	20.08	25.19	30.34	36.00	36.83	37.65	38.76	39.92	34.86	36.40	43.77	51.24	50.54	49.39	38.43	41.95	37.44	14.08	13.85	13.29	13.38	13.51
4.70	5.42	6.13	6.82	7.41	8.90	10.69	12.49	14.28	19.27	24.25	29.23	33.37	34.83	35.98	37.13	38.29	33.59	35.14	41.61	49.08	49.58	48.44	31.13	27.92	23.41	13.89	13.66	13.42	13.75	14.08
4.34	5.06	5.73	6.31	6.90	8.29	9.88	11.68	13.47	18.46	23.44	27.90	31.27	32.98	34.35	35.50	36.65	32.33	33.87	39.45	46.92	48.27	47.48	30.17	13.89	13.45	14.13	14.10	14.01	14.76	15.09
3.99	4.63	5.22	5.81	6.39	7.78	9.17	10.87	12.66	17.64	22.43	25.81	29.18	30.88	32.58	33.87	35.02	31.02	32.60	37.78	44.76	46.11	46.52	29.32	13.32	13.94	14.62	14.69	14.60	15.64	16.11
4.15	4.23	4.71	5.30	5.88	7.27	8.66	10.05	11.85	16.83	20.34	23.71	27.09	28.79	30.49	32.19	33.39	29.67	31.34	36.52	42.60	43.95	43.82	29.89	13.89	14.44	15.11	15.20	15.19	16.23	17.12
4.59	4.68	4.76	4.85	5.37	6.76	8.15	9.54	11.04	14.87	18.25	21.62	25.00	26.70	28.40	30.10	31.76	28.32	30.07	35.25	40.44	37.55	34.65	30.45	14.46	15.01	15.60	15.69	15.92	17.50	18.98
5.03	5.11	5.12	5.13	5.14	6.43	7.83	9.23	10.62	13.95	17.28	20.61	23.46	25.03	26.79	28.55	30.32	27.50	29.30	33.51	38.60	36.41	28.80	22.56	15.03	15.58	16.38	17.04	17.51	19.84	21.32
5.09	5.10	5.11	5.12	5.13	6.28	7.64	9.04	10.43	13.76	17.09	20.28	22.39	23.70	25.37	27.13	28.89	26.94	28.73	31.68	36.77	39.54	32.41	24.80	15.63	16.70	17.51	18.63	19.10	21.83	23.66
5.09	5.10	5.10	5.11	5.12	6.27	7.45	8.85	10.25	13.58	16.91	19.21	21.32	22.63	23.95	25.71	27.47	26.37	28.17	30.15	34.94	37.71	36.02	27.36	16.28	17.83	18.64	19.87	20.69	23.42	26.00
5.09	5.10	5.10	5.11	5.12	6.26	7.41	8.66	10.06	13.39	16.02	18.14	20.25	21.56	22.87	24.29	26.05	25.75	27.60	29.59	33.11	35.88	37.24	28.01	16.92	18.49	19.77	21.00	22.15	24.31	26.46
5.09	5.10	5.10	5.10	5.11	6.26	7.40	8.55	9.87	12.84	14.95	17.07	19.18	20.49	21.80	23.11	24.63	25.14	27.04	29.02	31.28	30.34	27.74	25.14	17.56	19.13	20.45	21.30	22.15	24.31	26.46
5.09	5.10	5.10	5.10	5.20	6.33	7.45	8.58	9.68	11.80	13.92	16.04	18.15	19.49	20.84	22.20	23.55	24.38	26.32	28.18	30.04	29.38	25.96	22.54	17.88	19.16	20.45	21.30	22.15	24.31	26.46
5.09	5.10	5.10	5.17	5.97	7.09	8.22	8.92	9.33	11.45	13.57	15.66	17.65	18.88	20.22	21.58	22.93	23.30	25.24	27.10	28.97	31.81	28.39	24.97	17.88	19.16	20.45	21.30	22.15	24.31	26.46
5.09	5.10	5.15	5.94	6.73	7.76	8.17	8.57	8.98	11.09	13.18	15.16	17.15	18.38	19.61	20.96	22.31	22.22	24.16	26.03	27.89	30.88	30.82	25.41	17.88	19.16	20.45	21.30	22.15	24.31	26.46
5.09	5.12	5.91	6.64	7.16	7.47	7.82	8.22	8.62	10.70	12.68	14.66	16.64	17.88	19.11	20.34	21.69	21.22	23.08	24.95	26.81	29.81	32.94	25.41	17.88	19.16	20.45	21.30	22.15	24.31	26.46
5.09	5.61	6.13	6.64	7.16	7.47	7.78	8.09	8.40	10.30	12.19	14.16	16.14	17.38	18.61	19.84	21.09	20.26	22.00	23.87	25.73	29.09	32.94	25.41	17.88	19.16	20.45	21.30	22.15	24.31	26.46
4.69	5.69	6.68	7.36	8.05	7.52	7.03	6.77	6.47	7.94	9.32	10.83	12.45	13.34	14.33	16.00	17.70	19.30	20.92	23.04	25.24	29.09	32.94	25.41	17.88	19.16	20.45	21.30	22.15	24.31	26.46
]';
% (g/s), cold engine out NOx emissions indexed vertically by fc_map_spd and
% horizontally by fc_map_trq
fc_nox_map_cold=1e-3*[1.02	1.12	1.23	1.33	1.44	1.71	1.98	2.24	2.51	2.20	1.90	1.59	1.28	2.02	2.76	3.50	4.24	5.45	5.73	6.54	7.35	7.36	7.38	8.69	10.01	10.63	11.24	13.24	15.24	16.08	16.93
1.42	1.53	1.67	1.99	2.32	2.59	2.86	3.09	3.31	3.21	3.00	2.69	2.38	2.44	2.76	3.50	4.24	5.49	5.73	6.54	7.35	7.36	7.38	8.69	10.01	10.63	11.24	13.24	15.24	16.08	16.93
1.89	2.22	2.55	2.87	3.20	3.44	3.66	3.88	4.10	4.01	3.91	3.80	3.49	3.55	3.61	3.66	4.24	5.50	5.73	6.54	7.35	7.36	7.38	8.69	10.01	10.63	11.54	14.00	16.12	18.05	19.78
2.70	3.03	3.42	3.99	4.56	4.67	4.78	4.89	4.95	4.92	4.85	4.78	4.71	4.96	5.09	5.21	5.34	6.33	6.81	7.41	8.00	8.46	8.84	10.18	11.60	12.80	13.91	19.07	21.31	24.11	26.12
3.56	4.43	5.00	5.57	6.14	6.25	6.36	6.30	6.16	6.31	6.41	6.34	6.27	6.71	7.15	7.28	7.41	8.07	8.97	9.57	10.12	10.78	11.21	12.51	13.85	15.07	16.28	21.44	26.51	29.19	31.84
4.47	5.37	6.27	7.15	7.72	7.78	7.64	7.51	7.37	7.52	7.67	7.82	7.84	8.27	8.71	9.15	9.48	10.23	11.13	11.69	12.24	12.90	13.66	15.48	17.20	18.93	20.46	26.27	31.60	33.50	36.15
6.21	7.03	7.84	8.60	9.23	9.07	8.93	8.80	8.67	8.82	8.97	9.12	9.27	10.62	11.11	11.59	12.07	12.27	13.18	13.71	14.84	15.95	16.81	19.64	21.35	23.45	24.97	31.36	36.69	37.89	40.46
8.27	8.77	9.40	10.03	10.66	10.48	10.31	10.17	10.04	10.19	10.34	10.49	10.64	12.94	13.84	14.32	14.80	14.41	15.14	15.91	17.61	19.10	19.95	23.65	25.51	27.70	29.48	35.90	41.78	42.98	44.77
12.11	12.04	11.96	11.89	12.09	11.91	11.74	11.56	11.40	11.55	11.70	11.85	12.00	14.31	16.57	17.05	17.54	17.09	17.10	18.69	20.39	22.09	23.09	26.80	29.66	31.85	34.00	40.42	46.83	48.29	49.63
15.95	15.87	15.80	15.23	14.30	13.62	13.30	13.12	12.95	12.92	13.07	13.22	13.37	15.67	17.98	19.78	20.27	19.77	19.73	21.06	23.16	24.86	26.24	29.94	34.15	36.45	38.94	44.74	51.14	54.79	56.14
19.79	19.39	18.47	17.54	16.61	15.94	15.26	14.71	14.53	14.51	14.48	14.58	14.73	17.04	19.34	21.65	23.00	22.48	22.47	23.45	25.00	27.12	29.53	35.05	40.38	41.46	43.96	49.06	55.46	60.64	62.64
23.30	22.21	21.12	20.03	18.93	18.25	17.57	16.89	16.22	16.11	16.07	16.04	16.10	18.40	20.71	23.16	25.64	25.24	25.23	26.19	27.17	30.96	34.08	41.28	46.62	46.96	48.97	54.03	59.78	64.96	69.15
26.65	25.56	24.47	23.22	21.37	20.53	19.85	19.17	18.49	18.39	18.28	18.17	18.14	20.65	23.12	25.60	28.07	28.16	28.15	28.95	29.93	35.51	38.62	46.65	52.85	53.19	53.98	59.04	64.10	69.66	75.23
29.99	28.90	27.51	25.66	23.81	22.91	22.13	21.45	20.77	20.67	20.56	20.50	20.52	23.06	25.56	28.03	30.51	31.08	31.07	31.70	32.68	39.53	43.17	51.19	59.08	58.82	58.39	64.01	69.06	75.39	80.96
33.34	31.81	29.96	28.10	26.25	25.36	24.46	23.73	23.05	22.95	22.85	22.88	22.90	25.44	27.98	30.47	32.94	34.09	34.00	34.55	35.44	42.28	47.72	55.63	62.26	62.90	62.47	68.97	74.02	80.88	86.69
35.32	34.11	32.40	30.55	28.69	27.80	26.90	26.01	25.33	25.22	25.24	25.26	25.28	27.82	30.36	32.90	35.38	37.23	36.92	37.47	38.20	45.04	51.88	58.55	65.18	66.77	66.55	73.15	78.98	85.84	92.42
36.54	35.33	34.12	32.91	31.14	30.24	29.34	28.45	27.61	27.60	27.62	27.64	27.67	30.20	32.74	35.28	37.81	40.37	39.84	40.40	40.95	47.80	54.64	61.47	68.10	69.69	70.63	77.23	83.58	88.92	94.56
37.77	36.56	35.34	34.12	32.91	32.82	31.93	31.04	30.15	30.17	30.18	30.20	31.01	32.80	35.37	37.94	40.51	43.61	43.02	43.20	43.74	51.17	57.66	64.25	71.02	72.61	73.56	79.92	85.90	89.04	94.68
37.95	37.76	36.54	35.32	34.11	35.27	34.62	33.73	32.84	32.86	32.87	33.13	35.15	35.90	38.10	40.66	43.23	46.91	46.32	45.99	46.52	54.82	61.39	67.88	72.38	74.11	75.03	82.23	88.22	90.19	94.80
37.95	38.15	37.74	36.52	35.31	36.47	37.31	36.42	35.53	35.54	35.56	37.27	39.29	40.04	40.82	43.39	45.95	50.21	49.62	48.90	49.31	57.60	65.12	70.27	72.33	75.58	76.51	83.91	90.54	92.51	94.93
37.95	38.15	38.35	37.72	36.51	37.67	38.83	39.10	38.21	38.23	39.39	41.41	43.43	44.19	44.94	46.11	48.68	53.66	52.92	52.19	52.09	60.39	67.66	70.23	72.29	75.59	77.99	85.39	92.67	93.81	94.95
37.95	38.15	38.35	38.55	37.71	38.87	40.03	41.19	40.90	41.51	43.53	45.55	47.57	48.33	49.08	49.84	51.40	57.12	56.21	55.49	54.88	60.47	64.85	69.22	72.24	75.55	78.87	85.77	92.67	93.81	94.95
37.95	38.15	38.35	38.55	38.79	39.98	41.16	42.34	43.61	45.63	47.65	49.66	51.78	52.52	53.31	54.10	54.89	60.66	59.64	59.51	59.11	62.91	66.79	70.66	72.22	75.54	78.87	85.77	92.67	93.81	94.95
37.95	38.15	38.35	38.58	39.08	40.26	41.44	43.88	47.21	49.22	51.24	53.48	57.03	57.07	57.82	58.60	59.39	64.39	63.38	64.14	63.74	67.45	71.33	75.20	72.22	75.54	78.87	85.77	92.67	93.81	94.95
37.95	38.15	38.37	38.87	39.36	40.83	44.15	47.47	50.80	52.81	55.18	58.73	62.27	62.31	62.36	63.11	63.90	68.13	67.11	68.77	68.37	72.08	75.87	76.02	72.22	75.54	78.87	85.77	92.67	93.81	94.95
37.95	38.16	38.65	39.13	39.52	43.81	47.74	51.07	54.39	56.89	60.43	63.98	67.52	67.56	67.60	67.64	68.40	71.70	70.85	72.58	73.00	76.71	79.82	76.02	72.22	75.54	78.87	85.77	92.67	93.81	94.95
37.95	38.34	38.73	39.13	39.52	43.81	48.09	52.37	56.66	61.10	65.54	69.23	72.77	72.81	72.85	72.89	72.78	75.16	74.59	76.31	77.62	79.79	79.82	76.02	72.22	75.54	78.87	85.77	92.67	93.81	94.95
38.68	39.33	39.99	45.83	51.67	55.81	59.81	66.78	73.99	74.69	75.55	74.28	73.19	74.86	76.77	77.79	78.89	78.62	78.32	79.17	79.76	79.79	79.82	76.02	72.22	75.54	78.87	85.77	92.67	93.81	94.95
]';
% (g/s), cold engine out PM emissions indexed vertically by fc_map_spd and
% horizontally by fc_map_trq
fc_pm_map_cold=1e-3*[0.059	0.056	0.052	0.048	0.044	0.073	0.102	0.131	0.160	0.173	0.186	0.199	0.212	0.291	0.370	0.449	0.528	0.299	0.300	0.272	0.244	0.265	0.287	0.314	0.340	0.462	0.584	0.629	0.675	0.785	0.896
0.102	0.098	0.101	0.138	0.175	0.204	0.233	0.225	0.203	0.202	0.208	0.221	0.234	0.299	0.370	0.449	0.528	0.255	0.300	0.272	0.244	0.265	0.287	0.314	0.340	0.462	0.584	0.629	0.675	0.785	0.896
0.149	0.192	0.231	0.269	0.306	0.311	0.290	0.268	0.246	0.245	0.244	0.244	0.257	0.322	0.387	0.453	0.528	0.243	0.300	0.272	0.244	0.265	0.287	0.314	0.340	0.462	0.626	0.655	0.704	0.820	0.947
0.229	0.272	0.309	0.329	0.350	0.333	0.317	0.301	0.295	0.301	0.302	0.304	0.305	0.369	0.440	0.511	0.582	0.329	0.380	0.337	0.299	0.382	0.443	0.542	0.585	0.768	0.960	0.834	0.876	0.947	1.060
0.264	0.294	0.314	0.334	0.354	0.338	0.322	0.343	0.381	0.408	0.429	0.431	0.432	0.487	0.542	0.613	0.684	0.508	0.542	0.498	0.479	0.620	0.695	0.832	0.930	1.111	1.294	1.168	1.048	1.143	1.244
0.247	0.278	0.309	0.339	0.359	0.354	0.391	0.429	0.467	0.494	0.520	0.547	0.559	0.614	0.669	0.724	0.785	0.670	0.703	0.677	0.660	0.800	0.979	1.088	1.227	1.523	1.717	1.296	1.156	1.491	1.592
0.314	0.337	0.359	0.375	0.377	0.446	0.484	0.522	0.560	0.587	0.614	0.641	0.780	0.827	0.887	0.948	1.008	1.007	1.026	1.034	1.121	1.316	1.526	1.351	1.491	1.964	2.158	1.402	1.262	1.812	1.939
0.400	0.403	0.405	0.408	0.410	0.492	0.573	0.621	0.659	0.686	0.755	0.905	1.056	1.088	1.142	1.202	1.263	1.433	1.486	1.526	1.689	1.864	2.073	1.653	1.754	2.276	2.598	1.825	1.369	1.918	2.287
0.422	0.427	0.433	0.439	0.443	0.525	0.606	0.688	0.758	0.879	1.030	1.181	1.331	1.364	1.397	1.457	1.517	1.756	1.945	2.093	2.256	2.419	2.620	2.200	2.017	2.539	3.038	2.265	1.491	2.060	2.633
0.444	0.450	0.455	0.465	0.479	0.615	0.712	0.793	0.873	1.148	1.305	1.456	1.607	1.639	1.672	1.712	1.772	2.079	2.270	2.576	2.824	2.987	3.168	2.747	2.244	2.810	3.337	2.701	1.927	2.402	2.975
0.466	0.475	0.488	0.501	0.515	0.651	0.788	0.911	0.991	1.267	1.542	1.731	1.882	1.915	1.947	1.980	2.027	2.391	2.572	2.903	3.194	3.445	3.691	2.971	2.281	3.088	3.615	3.137	2.363	2.771	3.317
0.515	0.524	0.533	0.542	0.551	0.689	0.827	0.965	1.103	1.383	1.660	1.935	2.157	2.190	2.223	2.266	2.311	2.700	2.881	3.249	3.602	3.779	4.014	3.008	2.319	3.270	3.893	3.425	2.799	3.207	3.658
0.577	0.586	0.595	0.599	0.583	0.760	0.898	1.036	1.174	1.455	1.735	2.016	2.300	2.528	2.573	2.618	2.663	3.060	3.241	3.726	4.079	4.103	4.338	3.193	2.357	3.308	4.172	3.703	3.234	3.619	4.003
0.639	0.648	0.647	0.631	0.616	0.806	0.969	1.107	1.245	1.526	1.807	2.089	2.374	2.749	2.925	2.970	3.015	3.419	3.600	4.203	4.556	4.472	4.662	3.517	2.394	3.445	4.524	4.148	3.716	3.966	4.351
0.701	0.696	0.680	0.664	0.648	0.838	1.028	1.178	1.316	1.597	1.878	2.164	2.449	2.824	3.199	3.322	3.367	3.711	3.960	4.614	5.033	4.949	4.985	3.859	2.950	3.839	4.918	4.630	4.198	4.357	4.698
0.838	0.745	0.712	0.696	0.680	0.870	1.060	1.250	1.387	1.668	1.953	2.238	2.524	2.898	3.273	3.648	3.718	3.906	4.320	4.974	5.510	5.426	5.270	4.458	3.550	4.270	5.312	5.034	4.680	4.839	5.046
1.017	0.924	0.831	0.738	0.713	0.903	1.093	1.283	1.459	1.743	2.028	2.313	2.598	2.973	3.348	3.723	4.070	4.100	4.679	5.333	5.987	5.698	5.408	5.058	4.149	4.870	5.706	5.428	5.200	5.811	6.286
1.196	1.099	0.984	0.868	0.752	0.877	1.064	1.252	1.439	1.728	2.016	2.305	2.556	3.008	3.377	3.746	4.116	4.195	4.821	5.458	6.071	6.131	5.669	5.257	4.748	5.469	6.372	6.108	5.957	7.553	8.028
1.222	1.144	1.029	0.913	0.797	0.825	0.993	1.181	1.368	1.657	1.945	2.223	2.417	2.980	3.389	3.758	4.128	4.245	4.870	5.541	6.154	6.691	6.276	5.814	5.415	6.475	7.386	6.864	6.713	8.832	9.770
1.222	1.159	1.074	0.958	0.843	0.870	0.923	1.110	1.297	1.586	1.875	2.083	2.277	2.840	3.401	3.770	4.139	4.294	4.919	5.616	6.238	6.775	6.883	6.464	6.144	7.489	8.399	7.816	7.469	9.589	11.512
1.222	1.159	1.097	1.003	0.888	0.915	0.943	1.039	1.226	1.515	1.750	1.944	2.138	2.701	3.263	3.782	4.151	4.204	4.969	5.665	6.321	6.858	7.357	7.192	6.872	8.228	9.412	8.829	8.166	10.012	11.858
1.222	1.159	1.097	1.035	0.933	0.960	0.988	1.015	1.156	1.416	1.610	1.804	1.998	2.561	3.124	3.687	4.163	4.110	5.018	5.715	6.404	6.841	7.233	7.626	7.600	8.956	10.021	9.093	8.166	10.012	11.858
1.222	1.159	1.097	1.035	0.987	1.013	1.039	1.064	1.087	1.282	1.477	1.672	1.867	2.456	3.040	3.623	4.207	4.024	5.032	5.667	6.320	7.125	7.478	7.832	7.957	8.989	10.021	9.093	8.166	10.012	11.858
1.222	1.159	1.097	1.046	1.107	1.133	1.158	1.136	1.080	1.275	1.470	1.666	1.864	2.538	3.127	3.710	4.294	3.953	4.961	5.536	6.189	7.571	7.924	8.278	7.957	8.989	10.021	9.093	8.166	10.012	11.858
1.222	1.159	1.104	1.166	1.227	1.242	1.186	1.130	1.074	1.269	1.465	1.663	1.860	2.535	3.209	3.797	4.381	3.882	4.890	5.406	6.058	7.465	8.371	8.358	7.957	8.989	10.021	9.093	8.166	10.012	11.858
1.222	1.163	1.224	1.276	1.294	1.237	1.180	1.124	1.068	1.264	1.462	1.659	1.857	2.532	3.206	3.881	4.468	3.799	4.819	5.330	5.928	7.335	8.759	8.358	7.957	8.989	10.021	9.093	8.166	10.012	11.858
1.222	1.240	1.258	1.276	1.294	1.237	1.179	1.122	1.064	1.261	1.458	1.656	1.854	2.528	3.203	3.878	4.552	3.708	4.749	5.259	5.797	7.248	8.759	8.358	7.957	8.989	10.021	9.093	8.166	10.012	11.858
0.936	0.915	0.893	1.010	1.127	0.900	0.687	0.672	0.658	0.795	0.916	1.105	1.295	1.768	2.242	2.396	2.556	3.617	4.678	5.205	5.737	7.248	8.759	8.358	7.957	8.989	10.021	9.093	8.166	10.012	11.858
]';
% (g/s), cold engine out O2 emissions indexed vertically by fc_map_spd and
% horizontally by fc_map_trq
fc_o2_map_cold=1e-3*[1940	2216	2492	2768	3044	3475	3906	4337	4768	4693	4618	4543	4468	5082	5695	6308	6922	7720	8288	9053	9818	10018	10217	10926	11635	12168	12700	13284	13867	14169	14470
1939	2215	2517	2952	3388	3819	4250	4570	4849	5087	5154	5079	5004	5287	5695	6308	6922	7791	8288	9053	9818	10018	10217	10926	11635	12168	12700	13284	13867	14169	14470
1954	2417	2860	3296	3732	4092	4371	4650	4929	5168	5406	5615	5540	5823	6105	6388	6922	7809	8288	9053	9818	10018	10217	10926	11635	12168	12665	13236	13812	14053	14302
2061	2524	2986	3448	3909	4185	4461	4737	5040	5326	5581	5836	6090	6346	6625	6905	7184	7870	8409	9151	9822	10012	10210	10808	11509	11904	12377	12911	13486	13691	13928
2133	2627	3089	3550	4012	4288	4564	4944	5370	5787	6172	6426	6681	6901	7121	7399	7678	8005	8651	9393	9836	10005	10197	10729	11331	11702	12089	12623	13159	13354	13546
2164	2661	3158	3653	4114	4421	4847	5274	5700	6117	6534	6951	7272	7492	7712	7932	8172	8248	8894	9424	9850	10019	10172	10664	11159	11491	11856	12336	12870	12953	13145
2219	2713	3208	3683	4118	4579	4996	5413	5831	6243	6655	7067	7500	7744	7944	8144	8344	8307	8968	9386	9724	9903	10045	10495	10991	11268	11632	12048	12582	12564	12744
2275	2705	3140	3575	4009	4488	4967	5398	5815	6227	6647	7083	7519	7810	8031	8231	8431	8284	8900	9286	9546	9776	9918	10333	10823	11085	11409	11821	12295	12276	12342
2247	2658	3069	3480	3901	4379	4858	5337	5800	6230	6666	7102	7537	7829	8118	8318	8518	8400	8832	9108	9368	9628	9791	10206	10654	10916	11185	11598	12015	12019	12021
2218	2629	3041	3424	3788	4318	4811	5289	5766	6246	6684	7120	7556	7847	8139	8405	8605	8516	8767	9031	9190	9450	9664	10078	10509	10756	11023	11460	11880	11934	11936
2189	2583	2947	3311	3675	4204	4734	5252	5729	6209	6689	7139	7575	7866	8157	8449	8692	8544	8703	9017	9250	9404	9544	10013	10479	10603	10870	11325	11745	11834	11851
2089	2457	2825	3193	3561	4094	4625	5157	5689	6171	6652	7132	7593	7884	8176	8464	8753	8482	8641	8958	9275	9374	9481	9983	10449	10499	10717	11173	11610	11700	11766
1951	2318	2686	3061	3460	4033	4565	5096	5628	6111	6593	7076	7611	7887	8176	8464	8752	8433	8592	8918	9234	9311	9418	9936	10419	10469	10564	11020	11476	11541	11606
1812	2180	2560	2959	3358	3945	4504	5036	5567	6050	6533	7048	7629	7896	8175	8463	8752	8384	8543	8877	9193	9254	9355	9873	10389	10445	10502	10951	11425	11318	11383
1673	2059	2458	2857	3257	3843	4430	4975	5506	5989	6484	7066	7648	7914	8180	8463	8751	8343	8494	8831	9153	9214	9292	9812	10344	10435	10492	10901	11375	11149	11159
1522	1951	2357	2756	3155	3742	4328	4914	5446	5929	6502	7084	7666	7932	8198	8464	8751	8313	8445	8782	9112	9173	9284	9765	10298	10418	10482	10886	11325	11099	10936
1364	1793	2222	2650	3053	3640	4227	4813	5385	5938	6520	7102	7684	7950	8216	8482	8750	8283	8396	8734	9071	9276	9481	9719	10251	10371	10472	10876	11250	10974	10700
1206	1637	2077	2517	2958	3552	4139	4726	5313	5897	6481	7066	7769	7943	8205	8468	8730	8391	8502	8729	9074	9302	9607	9883	10205	10325	10376	10696	11025	10730	10456
1184	1546	1986	2427	2867	3472	4061	4648	5235	5820	6404	7024	7911	7964	8183	8445	8708	8561	8672	8731	9077	9234	9532	9838	10102	10124	10172	10471	10801	10495	10213
1184	1517	1896	2336	2776	3381	3983	4570	5158	5742	6326	7166	8054	8106	8161	8423	8686	8732	8843	8775	9079	9236	9457	9735	9947	9920	9968	10262	10576	10271	9969
1184	1517	1850	2245	2686	3290	3895	4493	5080	5664	6421	7308	8196	8248	8301	8401	8664	8900	9013	8946	9082	9239	9387	9580	9793	9764	9764	10058	10369	10145	9921
1184	1517	1850	2182	2595	3200	3805	4409	5002	5675	6563	7450	8338	8390	8443	8495	8642	9069	9184	9116	9085	9218	9341	9464	9639	9610	9641	10005	10369	10145	9921
1184	1517	1850	2182	2502	3107	3713	4318	4924	5810	6695	7581	8468	8506	8543	8579	8616	9086	9199	9069	8904	8979	9120	9261	9564	9603	9641	10005	10369	10145	9921
1184	1517	1850	2172	2392	2997	3603	4220	4847	5732	6618	7506	8406	8474	8513	8549	8586	8738	8851	8837	8672	8663	8804	8945	9564	9603	9641	10005	10369	10145	9921
1184	1517	1843	2062	2282	2890	3517	4143	4769	5655	6544	7444	8345	8413	8481	8519	8556	8390	8503	8605	8441	8428	8489	8889	9564	9603	9641	10005	10369	10145	9921
1184	1513	1733	1961	2220	2826	3439	4066	4692	5582	6483	7383	8283	8352	8420	8488	8526	8107	8154	8267	8209	8196	8214	8889	9564	9603	9641	10005	10369	10145	9921
1184	1443	1702	1961	2220	2826	3432	4037	4643	5533	6423	7322	8222	8290	8359	8427	8497	7865	7806	7919	7977	8042	8214	8889	9564	9603	9641	10005	10369	10145	9921
1077	1225	1374	1742	2110	2669	3229	4063	4902	5669	6425	6690	7014	7019	7056	7427	7796	7623	7458	7652	7870	8042	8214	8889	9564	9603	9641	10005	10369	10145	9921
]';
% (C), engine exhaust gas temperature indexed vertically by fc_map_spd and
% horizontally by fc_map_trq
fc_extmp_map_cold=[99.6	102.2	104.7	107.2	109.7	112.9	116.1	119.3	122.5	128.8	135.2	141.6	148.0	156.6	165.2	173.8	182.4	217.2	219.2	224.3	229.4	228.1	226.7	229.3	231.8	225.2	218.6	221.6	224.6	226.3	227.9
112.9	115.4	117.9	120.5	123.0	126.2	129.3	131.8	134.1	139.1	144.9	151.2	157.6	160.2	165.2	173.8	182.4	213.9	219.2	224.3	229.4	228.1	226.7	229.3	231.8	225.2	218.6	221.6	224.6	226.3	227.9
126.5	128.7	131.2	133.7	136.2	139.0	141.2	143.5	145.7	150.7	155.7	160.9	167.2	169.9	172.5	175.2	182.4	213.0	219.2	224.3	229.4	228.1	226.7	229.3	231.8	225.2	220.8	223.9	227.2	230.8	234.5
142.3	144.6	146.5	147.5	148.5	150.7	153.0	155.2	157.4	161.7	166.6	171.4	176.3	180.9	183.9	186.8	189.8	221.3	227.3	230.8	235.2	237.0	238.8	241.2	244.5	240.8	237.7	239.1	242.4	245.5	249.0
157.2	157.3	158.3	159.4	160.4	162.6	164.8	167.1	169.5	171.4	173.8	178.6	183.5	190.6	197.7	200.8	203.7	238.4	243.6	247.1	254.0	256.4	258.2	260.0	262.5	258.5	254.7	256.1	257.6	261.3	265.1
170.9	171.0	171.1	171.2	172.2	174.5	176.9	179.2	181.6	183.5	185.3	187.1	190.7	197.8	204.9	212.0	217.7	254.7	259.9	265.8	272.9	275.2	276.9	277.1	277.4	274.9	270.7	272.3	273.7	280.7	284.5
184.1	184.3	184.4	184.7	185.5	186.8	189.2	191.6	194.0	195.9	197.7	199.5	200.4	206.5	213.7	220.9	228.0	269.0	274.4	280.9	286.3	288.4	289.6	289.8	290.1	290.6	286.4	288.4	289.8	299.8	304.0
197.3	198.2	198.9	199.7	200.5	201.4	202.2	204.2	206.6	208.5	209.9	210.7	211.4	216.5	223.1	230.3	237.5	281.4	287.3	293.3	297.6	301.1	302.3	302.5	302.8	304.2	302.1	304.2	305.9	315.9	323.5
210.5	211.8	213.1	214.4	215.5	216.4	217.2	218.0	219.2	220.2	221.0	221.7	222.5	227.5	232.6	239.8	246.9	292.4	300.2	304.7	309.0	313.2	314.9	315.2	315.4	316.9	317.9	319.9	321.9	331.5	341.3
223.7	225.0	226.3	227.9	229.7	229.2	229.6	230.5	231.4	231.3	232.0	232.8	233.5	238.5	243.6	249.2	256.4	303.3	310.5	317.5	320.3	324.6	327.6	327.9	327.6	329.5	330.9	334.9	336.9	344.3	354.0
236.9	238.4	240.2	242.0	243.8	243.3	242.7	242.5	243.4	243.3	243.3	243.8	244.6	249.6	254.6	259.7	265.8	313.8	320.4	329.2	335.0	337.8	340.1	338.6	337.3	342.1	343.5	349.9	351.8	357.7	366.8
251.6	253.2	254.8	256.3	257.9	257.1	256.4	255.7	255.0	255.3	255.3	255.3	255.6	260.6	265.7	270.5	275.2	323.7	330.3	339.4	348.3	349.3	350.6	348.3	346.9	353.6	356.2	362.6	366.8	372.7	379.6
267.0	268.6	270.1	271.3	270.6	266.9	266.2	265.5	264.8	265.0	265.3	265.5	265.6	270.2	275.0	279.7	284.5	333.9	340.6	350.5	359.4	359.8	361.1	358.3	356.5	363.2	368.8	375.3	381.8	387.3	392.9
282.3	283.9	284.6	283.9	283.2	278.6	275.9	275.2	274.5	274.7	275.0	275.1	275.2	279.6	284.3	289.0	293.8	344.2	350.8	361.6	370.5	370.5	371.6	368.8	366.2	373.2	380.3	386.6	392.8	401.0	406.5
297.7	298.0	297.3	296.6	295.9	291.2	286.5	284.9	284.2	284.4	284.7	284.7	284.7	289.2	293.6	298.3	303.1	354.1	361.1	372.2	381.6	381.6	382.0	379.4	377.8	384.0	391.1	397.7	403.9	413.8	420.1
313.7	311.1	309.9	309.2	308.5	303.9	299.2	294.6	293.9	294.1	294.2	294.2	294.2	298.7	303.2	307.6	312.4	363.5	371.3	382.5	392.7	392.7	392.6	391.2	389.6	395.0	401.9	408.5	414.9	424.8	433.8
330.1	327.5	324.8	322.2	321.2	316.5	311.9	307.2	303.6	303.7	303.7	303.7	303.7	308.2	312.7	317.2	321.7	372.9	381.6	392.7	403.8	403.6	403.4	403.1	401.5	406.8	412.7	419.3	426.5	438.1	449.5
346.5	343.7	340.2	336.7	333.2	327.0	322.2	317.4	312.7	312.7	312.7	312.8	309.9	316.4	320.7	324.9	329.2	378.2	387.1	401.1	411.8	412.0	413.2	414.0	413.3	418.6	425.2	433.5	441.6	455.1	466.4
348.8	355.2	351.7	348.3	344.8	336.1	330.9	326.1	321.4	321.4	321.4	320.6	313.4	322.7	328.0	332.3	336.6	381.7	390.5	409.1	419.9	419.0	420.1	421.3	426.8	433.2	439.8	448.6	456.7	471.1	483.3
348.8	359.0	363.3	359.8	356.3	347.7	339.6	334.9	330.1	330.1	330.2	324.0	316.8	326.1	335.4	339.7	344.0	385.1	394.0	416.0	427.9	427.0	427.0	431.1	441.8	447.9	454.5	463.4	471.9	486.2	500.3
348.8	359.0	369.1	371.3	367.8	359.2	350.5	343.6	338.8	338.8	334.7	327.5	320.2	329.6	338.9	347.1	351.4	387.1	397.4	419.4	435.9	435.0	436.2	446.1	456.8	462.8	469.1	478.0	485.8	494.7	503.6
348.8	359.0	369.1	379.3	379.4	370.7	362.1	353.4	347.5	345.4	338.1	330.9	323.6	333.0	342.3	351.7	358.7	389.1	400.9	422.9	443.9	448.5	455.5	462.6	471.8	477.8	477.9	481.8	485.8	494.7	503.6
348.8	359.0	369.1	379.3	390.8	382.2	373.5	364.9	356.1	348.9	341.7	334.5	327.3	337.6	347.7	357.8	367.9	394.0	406.9	429.8	453.3	461.0	468.7	476.4	479.1	478.5	477.9	481.8	485.8	494.7	503.6
348.8	359.0	369.1	380.3	401.4	392.7	384.1	373.9	362.6	355.4	348.1	341.0	334.0	348.8	359.2	369.2	379.3	406.2	419.1	439.6	463.1	470.7	478.4	486.1	479.1	478.5	477.9	481.8	485.8	494.7	503.6
348.8	359.0	369.8	390.9	411.9	402.9	391.6	380.3	369.0	361.8	354.6	347.7	340.7	355.5	370.4	380.7	390.8	418.4	431.3	449.4	472.9	480.4	488.1	487.8	479.1	478.5	477.9	481.8	485.8	494.7	503.6
348.8	359.3	380.4	400.6	417.9	408.3	398.1	386.8	375.5	368.3	361.3	354.4	347.4	362.2	377.1	392.0	402.2	430.4	443.5	461.4	482.7	490.3	496.5	487.8	479.1	478.5	477.9	481.8	485.8	494.7	503.6
348.8	366.1	383.3	400.6	417.9	408.3	398.7	389.1	379.6	373.7	367.9	361.1	354.1	368.9	383.8	398.7	413.3	442.2	455.7	473.6	492.5	496.8	496.5	487.8	479.1	478.5	477.9	481.8	485.8	494.7	503.6
376.9	402.6	428.3	441.3	454.3	442.1	430.0	412.3	394.4	384.7	375.1	384.9	393.2	405.1	416.2	428.3	440.2	454.0	467.9	482.9	497.1	496.8	496.5	487.8	479.1	478.5	477.9	481.8	485.8	494.7	503.6
]';
% (g/s), cold engine out total exhaust flow indexed vertically by fc_map_spd and
% horizontally by fc_map_trq
fc_exflow_map_cold=[11.03	12.47	13.90	15.33	16.76	19.04	21.33	23.62	25.90	25.90	25.90	25.90	25.89	29.77	33.64	37.52	41.39	44.32	47.21	51.18	55.15	56.34	57.52	61.23	64.94	67.63	70.33	73.59	76.84	78.88	80.92
11.51	12.95	14.51	16.78	19.04	21.33	23.62	25.44	27.09	28.66	29.36	29.36	29.36	31.09	33.64	37.52	41.39	44.43	47.21	51.18	55.15	56.34	57.52	61.23	64.94	67.63	70.33	73.59	76.84	78.88	80.92
12.09	14.49	16.80	19.06	21.33	23.32	24.98	26.63	28.29	29.85	31.41	32.83	32.82	34.56	36.30	38.03	41.39	44.45	47.21	51.18	55.15	56.34	57.52	61.23	64.94	67.63	70.38	73.63	76.90	78.93	80.99
13.18	15.58	18.00	20.45	22.91	24.55	26.20	27.84	29.64	31.44	33.09	34.73	36.38	38.07	39.82	41.57	43.31	45.41	48.45	52.19	55.68	57.09	58.54	61.82	65.57	68.04	70.83	73.95	77.21	79.12	81.14
14.13	16.80	19.25	21.71	24.17	25.81	27.46	29.66	32.12	34.60	36.91	38.56	40.20	41.82	43.44	45.18	46.93	47.43	50.96	54.69	57.40	58.75	60.17	63.16	66.47	68.83	71.27	74.40	77.53	79.43	81.33
14.93	17.62	20.30	22.97	25.43	27.23	29.69	32.14	34.60	37.08	39.56	42.04	44.02	45.64	47.26	48.88	50.55	49.93	53.47	56.47	59.12	60.47	61.76	64.60	67.46	69.74	72.11	75.11	78.25	79.69	81.59
15.84	18.51	21.18	23.79	26.27	28.98	31.39	33.81	36.22	38.68	41.14	43.60	46.26	48.08	49.62	51.15	52.69	51.71	55.31	57.91	60.23	61.73	62.98	65.67	68.52	70.65	73.02	75.84	78.98	80.00	81.85
16.75	19.21	21.69	24.16	26.64	29.46	32.29	34.80	37.22	39.68	42.21	44.89	47.57	49.70	51.38	52.91	54.45	53.17	56.59	59.07	61.11	62.94	64.20	66.75	69.59	71.67	73.92	76.74	79.72	80.73	82.11
17.34	19.75	22.16	24.57	27.01	29.83	32.66	35.49	38.21	40.84	43.52	46.20	48.87	51.01	53.14	54.68	56.21	55.16	57.86	59.95	61.99	64.02	65.41	67.97	70.65	72.73	74.83	77.65	80.50	81.67	82.81
17.93	20.34	22.75	25.09	27.38	30.58	33.52	36.34	39.16	42.13	44.83	47.51	50.18	52.32	54.46	56.44	57.97	57.16	59.15	61.35	62.87	64.90	66.63	69.19	71.86	73.96	76.16	79.33	82.21	83.71	84.85
18.52	20.88	23.18	25.47	27.76	30.96	34.16	37.27	40.09	43.07	46.04	48.81	51.49	53.63	55.77	57.91	59.73	58.81	60.44	62.96	64.97	66.46	67.90	70.84	73.77	75.35	77.54	81.04	83.92	85.65	86.89
18.82	21.15	23.48	25.81	28.14	31.36	34.58	37.79	41.01	44.00	46.97	49.95	52.80	54.94	57.08	59.25	61.43	60.13	61.76	64.36	66.94	68.26	69.59	72.75	75.67	76.95	78.93	82.45	85.64	87.36	88.93
18.97	21.30	23.63	26.03	28.67	32.21	35.43	38.64	41.86	44.84	47.83	50.82	54.19	56.44	58.61	60.79	62.97	61.69	63.32	66.07	68.65	69.95	71.28	74.55	77.58	78.86	80.32	83.83	87.35	88.98	90.62
19.12	21.45	23.91	26.56	29.20	32.84	36.27	39.49	42.70	45.69	48.68	51.90	55.63	57.93	60.15	62.33	64.50	63.25	64.88	67.78	70.36	71.65	72.98	76.24	79.49	80.87	82.27	85.94	89.61	90.38	92.02
19.28	21.79	24.44	27.09	29.74	33.38	37.01	40.33	43.55	46.54	49.61	53.34	57.06	59.36	61.66	63.87	66.04	64.78	66.44	69.41	72.07	73.36	74.67	77.97	81.61	83.13	84.53	88.21	91.88	92.05	93.41
19.46	22.28	24.97	27.62	30.27	33.91	37.55	41.18	44.39	47.38	51.04	54.77	58.49	60.79	63.10	65.40	67.58	66.26	68.00	70.97	73.78	75.07	76.68	80.10	83.74	85.37	86.80	90.47	94.14	94.32	94.81
19.67	22.49	25.31	28.13	30.80	34.44	38.08	41.72	45.24	48.75	52.48	56.20	59.93	62.23	64.53	66.83	69.12	67.75	69.56	72.53	75.49	77.68	79.88	82.23	85.87	87.50	89.06	92.74	96.34	96.44	96.52
19.87	22.71	25.62	28.52	31.43	35.15	38.80	42.44	46.09	49.83	53.57	57.30	61.83	63.74	66.05	68.36	70.68	70.05	71.91	74.52	77.55	79.90	82.68	85.29	87.99	89.63	91.01	94.57	98.05	98.33	98.41
19.90	23.43	26.34	29.25	32.16	35.98	39.65	43.29	46.94	50.68	54.42	58.40	64.14	65.50	67.61	69.92	72.24	72.72	74.59	76.58	79.62	81.56	84.30	87.08	89.94	91.19	92.56	96.29	99.77	100.14	100.30
19.90	23.67	27.07	29.98	32.89	36.71	40.50	44.15	47.79	51.53	55.27	60.70	66.44	67.80	69.17	71.48	73.79	75.40	77.27	78.80	81.69	83.63	85.93	88.76	91.71	92.74	94.12	97.88	101.49	101.86	102.19
19.90	23.67	27.44	30.71	33.62	37.43	41.25	45.00	48.65	52.38	57.26	63.00	68.75	70.10	71.46	73.04	75.35	77.78	79.94	81.48	83.75	85.69	87.72	90.53	93.49	94.51	95.67	99.43	103.07	102.82	102.56
19.90	23.67	27.44	31.21	34.34	38.16	41.98	45.80	49.50	53.82	59.57	65.31	71.05	72.41	73.77	75.13	76.91	80.15	82.62	84.15	85.82	88.00	90.29	92.58	95.26	96.29	96.60	99.84	103.07	102.82	102.56
19.90	23.67	27.44	31.21	35.05	38.88	42.70	46.52	50.35	56.08	61.81	67.54	73.31	74.75	76.13	77.51	78.89	81.89	84.57	85.96	87.11	89.26	91.67	94.09	96.13	96.37	96.60	99.84	103.07	102.82	102.56
19.90	23.67	27.44	31.27	35.65	39.47	43.29	47.21	51.20	56.93	62.65	68.48	74.82	77.24	78.67	80.05	81.43	82.13	84.80	87.04	88.18	89.99	92.41	94.82	96.13	96.37	96.60	99.84	103.07	102.82	102.56
19.90	23.67	27.48	31.86	36.24	40.08	44.07	48.06	52.04	57.77	63.65	69.99	76.34	78.75	81.17	82.60	83.98	82.36	85.04	88.11	89.26	91.05	93.14	94.96	96.13	96.37	96.60	99.84	103.07	102.82	102.56
19.90	23.69	28.07	32.40	36.57	40.78	44.92	48.91	52.89	58.82	65.16	71.51	77.85	80.27	82.69	85.10	86.52	82.89	85.27	88.42	90.33	92.12	93.78	94.96	96.13	96.37	96.60	99.84	103.07	102.82	102.56
19.90	24.07	28.24	32.40	36.57	40.78	45.00	49.21	53.43	60.03	66.64	73.02	79.36	81.78	84.20	86.62	88.99	83.62	85.51	88.65	91.41	92.84	93.78	94.96	96.13	96.37	96.60	99.84	103.07	102.82	102.56
19.43	22.79	26.14	31.74	37.34	41.64	45.93	50.16	54.40	59.66	64.90	67.63	70.58	72.33	74.23	78.64	82.97	84.34	85.75	88.83	91.90	92.84	93.78	94.96	96.13	96.37	96.60	99.84	103.07	102.82	102.56
]';
% (m^3/s), cold engine out total volume exhaust flow indexed vertically by fc_map_spd and
% horizontally by fc_map_trq
fc_exflow_vol_map_cold=[0.0117	0.0133	0.0150	0.0166	0.0182	0.0210	0.0237	0.0264	0.0291	0.0296	0.0301	0.0305	0.0310	0.0366	0.0422	0.0478	0.0535	0.0617	0.0660	0.0723	0.0786	0.0802	0.0817	0.0874	0.0931	0.0957	0.0983	0.1035	0.1087	0.1119	0.1152
0.0126	0.0143	0.0161	0.0188	0.0215	0.0243	0.0270	0.0293	0.0314	0.0338	0.0351	0.0356	0.0361	0.0385	0.0422	0.0478	0.0535	0.0615	0.0660	0.0723	0.0786	0.0802	0.0817	0.0874	0.0931	0.0957	0.0983	0.1035	0.1087	0.1119	0.1152
0.0137	0.0166	0.0194	0.0221	0.0248	0.0273	0.0294	0.0316	0.0337	0.0361	0.0385	0.0407	0.0412	0.0436	0.0461	0.0486	0.0535	0.0614	0.0660	0.0723	0.0786	0.0802	0.0817	0.0874	0.0931	0.0957	0.0988	0.1040	0.1093	0.1130	0.1168
0.0155	0.0184	0.0214	0.0244	0.0275	0.0296	0.0317	0.0339	0.0362	0.0389	0.0414	0.0439	0.0464	0.0492	0.0518	0.0544	0.0570	0.0638	0.0690	0.0747	0.0804	0.0828	0.0851	0.0904	0.0964	0.0993	0.1027	0.1077	0.1130	0.1165	0.1203
0.0172	0.0206	0.0237	0.0268	0.0298	0.0319	0.0341	0.0371	0.0405	0.0439	0.0472	0.0497	0.0522	0.0553	0.0585	0.0611	0.0637	0.0688	0.0749	0.0807	0.0859	0.0884	0.0908	0.0957	0.1010	0.1038	0.1067	0.1117	0.1167	0.1204	0.1242
0.0187	0.0222	0.0257	0.0291	0.0321	0.0345	0.0379	0.0413	0.0447	0.0482	0.0516	0.0551	0.0580	0.0611	0.0643	0.0674	0.0704	0.0748	0.0809	0.0863	0.0915	0.0940	0.0963	0.1008	0.1053	0.1084	0.1113	0.1163	0.1213	0.1252	0.1290
0.0205	0.0239	0.0273	0.0308	0.0341	0.0380	0.0413	0.0447	0.0480	0.0514	0.0549	0.0583	0.0622	0.0657	0.0688	0.0719	0.0750	0.0796	0.0859	0.0909	0.0955	0.0983	0.1006	0.1049	0.1095	0.1131	0.1159	0.1210	0.1260	0.1301	0.1338
0.0222	0.0256	0.0290	0.0323	0.0357	0.0398	0.0438	0.0473	0.0507	0.0541	0.0577	0.0616	0.0656	0.0696	0.0729	0.0759	0.0790	0.0838	0.0899	0.0948	0.0989	0.1026	0.1048	0.1091	0.1136	0.1173	0.1205	0.1257	0.1307	0.1348	0.1387
0.0237	0.0271	0.0305	0.0339	0.0373	0.0414	0.0454	0.0494	0.0533	0.0571	0.0611	0.0650	0.0689	0.0729	0.0769	0.0800	0.0831	0.0886	0.0939	0.0982	0.1023	0.1065	0.1091	0.1134	0.1177	0.1215	0.1252	0.1303	0.1355	0.1397	0.1440
0.0251	0.0285	0.0319	0.0354	0.0389	0.0437	0.0479	0.0519	0.0560	0.0605	0.0644	0.0684	0.0723	0.0763	0.0803	0.0841	0.0871	0.0933	0.0977	0.1027	0.1058	0.1099	0.1133	0.1176	0.1221	0.1261	0.1302	0.1367	0.1420	0.1464	0.1507
0.0266	0.0300	0.0335	0.0370	0.0405	0.0453	0.0500	0.0546	0.0586	0.0631	0.0676	0.0717	0.0757	0.0797	0.0837	0.0877	0.0912	0.0976	0.1015	0.1073	0.1118	0.1148	0.1177	0.1226	0.1274	0.1313	0.1354	0.1432	0.1485	0.1531	0.1573
0.0277	0.0313	0.0349	0.0385	0.0422	0.0469	0.0517	0.0565	0.0613	0.0658	0.0703	0.0748	0.0790	0.0830	0.0870	0.0912	0.0953	0.1014	0.1053	0.1115	0.1175	0.1201	0.1228	0.1279	0.1327	0.1365	0.1405	0.1484	0.1549	0.1595	0.1640
0.0288	0.0324	0.0360	0.0397	0.0440	0.0494	0.0542	0.0590	0.0637	0.0682	0.0728	0.0773	0.0827	0.0870	0.0912	0.0953	0.0994	0.1060	0.1100	0.1168	0.1228	0.1253	0.1279	0.1331	0.1381	0.1418	0.1456	0.1535	0.1614	0.1659	0.1704
0.0298	0.0334	0.0373	0.0416	0.0459	0.0515	0.0567	0.0614	0.0662	0.0707	0.0752	0.0803	0.0864	0.0910	0.0953	0.0995	0.1036	0.1107	0.1146	0.1220	0.1281	0.1304	0.1330	0.1382	0.1434	0.1475	0.1518	0.1603	0.1685	0.1721	0.1766
0.0309	0.0349	0.0392	0.0435	0.0478	0.0534	0.0589	0.0639	0.0687	0.0732	0.0779	0.0840	0.0902	0.0948	0.0994	0.1036	0.1077	0.1151	0.1192	0.1270	0.1334	0.1357	0.1382	0.1434	0.1500	0.1544	0.1587	0.1674	0.1756	0.1786	0.1828
0.0320	0.0367	0.0410	0.0453	0.0496	0.0552	0.0608	0.0664	0.0712	0.0757	0.0817	0.0878	0.0939	0.0985	0.1031	0.1077	0.1119	0.1193	0.1238	0.1316	0.1387	0.1410	0.1440	0.1502	0.1567	0.1612	0.1655	0.1742	0.1827	0.1857	0.1889
0.0332	0.0379	0.0425	0.0472	0.0515	0.0571	0.0627	0.0683	0.0736	0.0793	0.0854	0.0916	0.0977	0.1023	0.1069	0.1115	0.1160	0.1234	0.1284	0.1362	0.1439	0.1482	0.1524	0.1569	0.1634	0.1679	0.1723	0.1810	0.1899	0.1933	0.1966
0.0344	0.0391	0.0439	0.0488	0.0536	0.0594	0.0650	0.0706	0.0762	0.0823	0.0885	0.0947	0.1018	0.1063	0.1110	0.1156	0.1202	0.1287	0.1338	0.1418	0.1498	0.1543	0.1599	0.1651	0.1701	0.1746	0.1792	0.1885	0.1976	0.2019	0.2052
0.0346	0.0414	0.0463	0.0511	0.0559	0.0619	0.0676	0.0732	0.0788	0.0849	0.0911	0.0976	0.1063	0.1106	0.1151	0.1198	0.1244	0.1344	0.1396	0.1477	0.1556	0.1592	0.1647	0.1703	0.1772	0.1815	0.1861	0.1962	0.2052	0.2100	0.2138
0.0346	0.0422	0.0486	0.0534	0.0583	0.0642	0.0702	0.0758	0.0814	0.0875	0.0937	0.1020	0.1107	0.1150	0.1193	0.1240	0.1286	0.1402	0.1453	0.1535	0.1614	0.1650	0.1695	0.1760	0.1847	0.1884	0.1930	0.2033	0.2129	0.2177	0.2223
0.0346	0.0422	0.0498	0.0558	0.0606	0.0666	0.0725	0.0784	0.0840	0.0901	0.0977	0.1065	0.1152	0.1195	0.1238	0.1282	0.1328	0.1449	0.1511	0.1592	0.1672	0.1708	0.1752	0.1834	0.1921	0.1958	0.1999	0.2102	0.2199	0.2220	0.2240
0.0346	0.0422	0.0498	0.0574	0.0629	0.0689	0.0749	0.0808	0.0866	0.0935	0.1022	0.1109	0.1196	0.1239	0.1282	0.1325	0.1370	0.1495	0.1568	0.1649	0.1731	0.1787	0.1852	0.1917	0.1995	0.2033	0.2041	0.2120	0.2199	0.2220	0.2240
0.0346	0.0422	0.0498	0.0574	0.0652	0.0712	0.0772	0.0832	0.0891	0.0979	0.1066	0.1153	0.1241	0.1289	0.1335	0.1381	0.1427	0.1538	0.1618	0.1701	0.1779	0.1844	0.1913	0.1982	0.2031	0.2036	0.2041	0.2120	0.2199	0.2220	0.2240
0.0346	0.0422	0.0498	0.0576	0.0674	0.0734	0.0793	0.0854	0.0916	0.1003	0.1090	0.1179	0.1281	0.1365	0.1413	0.1459	0.1505	0.1571	0.1651	0.1747	0.1826	0.1883	0.1953	0.2022	0.2031	0.2036	0.2041	0.2120	0.2199	0.2220	0.2240
0.0346	0.0422	0.0499	0.0597	0.0695	0.0755	0.0817	0.0879	0.0940	0.1027	0.1118	0.1220	0.1321	0.1405	0.1489	0.1537	0.1583	0.1604	0.1684	0.1793	0.1872	0.1929	0.1993	0.2029	0.2031	0.2036	0.2041	0.2120	0.2199	0.2220	0.2240
0.0346	0.0422	0.0521	0.0617	0.0707	0.0775	0.0841	0.0903	0.0965	0.1056	0.1158	0.1260	0.1362	0.1446	0.1530	0.1614	0.1661	0.1641	0.1717	0.1827	0.1918	0.1976	0.2027	0.2029	0.2031	0.2036	0.2041	0.2120	0.2199	0.2220	0.2240
0.0346	0.0436	0.0527	0.0617	0.0707	0.0775	0.0844	0.0912	0.0980	0.1089	0.1197	0.1300	0.1402	0.1486	0.1570	0.1654	0.1737	0.1681	0.1750	0.1860	0.1964	0.2006	0.2027	0.2029	0.2031	0.2036	0.2041	0.2120	0.2199	0.2220	0.2240
0.0352	0.0432	0.0511	0.0635	0.0759	0.0832	0.0905	0.0962	0.1019	0.1101	0.1183	0.1251	0.1319	0.1378	0.1437	0.1550	0.1660	0.1721	0.1783	0.1885	0.1986	0.2006	0.2027	0.2029	0.2031	0.2036	0.2041	0.2120	0.2199	0.2220	0.2240
]';

%Process Cold Maps to generate Correction Factor Maps
names={'fc_fuel_map','fc_hc_map','fc_co_map','fc_nox_map','fc_pm_map'};
for i=1:length(names)
    %cold to hot raio, e.g. fc_fuel_map_c2h = fc_fuel_map_cold ./ fc_fuel_map
    eval([names{i},'_c2h=',names{i},'_cold./(',names{i},'+eps);'])
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% LIMITS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% (N*m), max torque curve of the engine indexed by fc_map_spd 
temp_max_speed=[0 1200:200:4200]*pi/30;
temp_max_torque=[0 87.7 105.9 137.2 135.5 137.3 138.0 137.6 137.5 135.7 135.3 132.3 124.3 107.4 103.0 99.6 96.0]*(1/(3.281*0.224809));
fc_max_trq=interp1(temp_max_speed,temp_max_torque,fc_map_spd,'linear');%	N*m
clear temp_max_speed temp_max_torque

% (N*m), closed throttle torque of the engine (max torque that can be absorbed)
% indexed by fc_map_spd -- correlation from JDMA
fc_ct_trq=4.448/3.281*(-fc_disp)*61.02/24 * ...
   (9*(fc_map_spd/max(fc_map_spd)).^2 + 14 * (fc_map_spd/max(fc_map_spd)));


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DEFAULT SCALING
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% (--), used to scale fc_map_spd to simulate a faster or slower running engine 
fc_spd_scale=1.0;
% (--), used to scale fc_map_trq to simulate a higher or lower torque engine
fc_trq_scale=1.0;
fc_pwr_scale=fc_spd_scale*fc_trq_scale;   % --  scale fc power


% user definable mass scaling function
fc_mass_scale_fun=inline('(x(1)*fc_trq_scale+x(2))*(x(3)*fc_spd_scale+x(4))*(fc_base_mass+fc_acc_mass)+fc_fuel_mass','x','fc_spd_scale','fc_trq_scale','fc_base_mass','fc_acc_mass','fc_fuel_mass');
fc_mass_scale_coef=[1 0 1 0]; % coefficients of mass scaling function


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% STUFF THAT SCALES WITH TRQ & SPD SCALES (MASS AND INERTIA)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
fc_inertia=(1.9/(0.224809*12*3.28))*fc_pwr_scale;   % (kg*m^2), rotational inertia of the engine 
fc_max_pwr=(max(fc_map_spd.*fc_max_trq)/1000)*fc_pwr_scale; % kW     peak engine power

fc_base_mass=1.8*fc_max_pwr;            % (kg), mass of the engine block and head (base engine)
                                        %       assuming a mass penalty of 1.8 kg/kW from S. Sluder (ORNL) estimate of 300 lb 
fc_acc_mass=0.8*fc_max_pwr;             % kg    engine accy's, electrics, cntrl's - assumes mass penalty of 0.8 kg/kW (from 1994 OTA report, Table 3)
fc_fuel_mass=0.6*fc_max_pwr;            % kg    mass of fuel and fuel tank (from 1994 OTA report, Table 3)
fc_mass=fc_base_mass+fc_acc_mass+fc_fuel_mass; % kg  total engine/fuel system mass
fc_ext_sarea=0.3*(fc_max_pwr/100)^0.67;       % m^2    exterior surface area of engine


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% OTHER DATA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
fc_fuel_den=843;                        % (g/l), density of the fuel from Scott Sluder (ORNL, 1/19/99)
% fc_fuel_den=835;                      % (g/l), density of the fuel (from original TDI map from publication) 
% fc_fuel_den=850;                      % (g/l), density of fuel from handbook
fc_fuel_lhv=18456*2.205/0.9478;         % (J/g), =42937, lower heating value of the fuel from Scott Sluder (ORNL, 1/19/99)
% fc_fuel_lhv=43000;                    % (J/g), lower heating value of the fuel from handbook

%the following was added for the new thermal modeling of the engine 12/17/98 ss and sb
fc_tstat=99;                  % C      engine coolant thermostat set temperature (typically 95 +/- 5 C)
fc_cp=1000;                    % J/kgK  ave cp of engine (iron=500, Al or Mg = 1000)
fc_h_cp=500;                  % J/kgK  ave cp of hood & engine compartment (iron=500, Al or Mg = 1000)
fc_hood_sarea=1.5;            % m^2    surface area of hood/eng compt.
fc_emisv=0.8;                 %        eff emissivity of engine ext surface to hood int surface
fc_hood_emisv=0.9;            %        emissivity hood ext
fc_h_air_flow=0.0;            % kg/s   heater air flow rate (140 cfm=0.07)
fc_cl2h_eff=0.7;              % --     ave cabin heater HX eff (based on air side)
fc_c2i_th_cond=500;           % W/K    conductance btwn engine cyl & int
fc_i2x_th_cond=500;           % W/K    conductance btwn engine int & ext
fc_h2x_th_cond=10;            % W/K    conductance btwn engine & engine compartment


%the following variable is not used directly in modelling and should always be equal to one
%it's used for initialization purposes
fc_eff_scale=1;

% clean up workspace
clear fc_exflow_map_gpkWh fc_co2_map_gpkWh fc_map_kW T w

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% REVISION HISTORY
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 01/17/01: vhj file created from FC_CI67_emis
%               added variables fc_o2_map, fc_exflow_vol_map (to be used in emissions modeling)
% 01/24/01: vhj confirmed fuel properties were the same as VW engine, engine inertia unknown, updated cp (mostly Al engine)
% 01/31/01: vhj added fc_cold=0, added cold map variables, added +eps to avoid dividing by zero
% 01/31/01: vhj added data for cold maps
% 7/30/01:tm added user definable mass scaling function mass=f(fc_spd_scale,fc_trq_scale,fc_base_mass,fc_acc_mass,fc_fuel_mass)
