% ADVISOR Data file:  FC_CI92.m
%
% Data source:  Southwest Research Institute tests on Mercedes OM611 engine
%
%  Engine Model:            Mercedes OM611
%  Engine Features:         2.2 L CIDI
%                           Electronically controlled high pressure common rail with pilot fuel injection
%                           Turbocharged and intercooled
%                           Exhaust gas recirculation
%                           4 valves per cylinder
%                           Intake port cutoff for variable swirl

%  Engine Specifications:   Maximum Power: 92 kW at 4200 rpm
%                           Specific Power: 42.3 kW/l
%                           Compression Ratio:  19:1
%                           Min BSFC: 203 g/kWhr
%
% Data confidence level:  
%
% Notes: 
% File created by engmodel using mat file: swri_hot_al25714.mat;

%
% Created on:  05-Apr-2002 08:26:21
% By:  KJK
%
% Revision history at end of file.
%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% FILE ID INFO
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
fc_description='2.2L Engine';  
fc_version=2003;  		% version of ADVISOR for which the file was generated
fc_proprietary=0;  	    % 0=> non-proprietary, 1=> proprietary, do not distribute
fc_validation=0;  		% 1=> no validation, 1=> data agrees with source data, 
						% 2=> data matches source data and data collection methods have been verified
fc_fuel_type='Diesel'; 
fc_disp=2.2;   			% (L), engine displacement
fc_emis=1;       		% boolean 0=no emis data; 1=emis data
fc_cold=0;              % boolean 0=no cold data; 1=cold data exists
disp(['Data loaded: FC_SWRI_AL25714.m - ',fc_description]); 


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SPEED & TORQUE RANGES over which data is defined
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% (rad/s), speed range of the engine
fc_map_spd=[130.9 157.1 183.3 209.4 235.6 261.8 288 314.2 340.3 366.5 392.7 418.9 445.1]; 

% (N*m), torque range of the engine
fc_map_trq=[10 20 30 40 50 60 70 80 90 100 110 120 130 140 150 160 170 180 190 200 210 220 230 240 250 260 270 280 290 300]; 


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% FUEL USE AND EMISSIONS MAPS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% (g/s), fuel use map indexed vertically by fc_map_spd and 
% horizontally by fc_map_trq
fc_fuel_map=[0.2782 0.4556 0.1943 0.2702 0.3568 0.45 0.5485 0.6531 0.7653 0.8874 1.022 1.17 1.336;
0.2743 0.411 0.5 0.6422 0.7982 1.01 0.7636 0.8838 1.013 1.153 1.306 1.475 1.662;
0.3596 0.4271 0.5342 0.6392 0.7282 0.8562 1.006 1.156 1.353 1.565 1.541 1.73 1.939;
0.4532 0.4938 0.6012 0.717 0.8057 0.8944 1.045 1.2 1.355 1.559 1.768 1.976 2.2;
0.5468 0.5792 0.6867 0.8179 0.9066 1.022 1.19 1.345 1.526 1.75 1.959 2.179 2.457;
0.6289 0.6646 0.7721 0.9188 1.008 1.167 1.335 1.49 1.717 1.942 2.151 2.426 2.712;
0.7059 0.75 0.8718 1.02 1.124 1.312 1.48 1.674 1.909 2.134 2.369 2.673 2.968;
0.7829 0.8354 0.9726 1.121 1.269 1.457 1.631 1.866 2.1 2.325 2.616 2.92 3.224;
0.8764 0.9187 1.069 1.223 1.411 1.599 1.824 2.059 2.294 2.555 2.859 3.163 3.481;
0.976 0.9958 1.146 1.342 1.529 1.726 2.015 2.264 2.499 2.76 3.064 3.368 3.74;
1.076 1.073 1.223 1.46 1.648 1.873 2.162 2.469 2.704 2.965 3.269 3.614 4.001;
1.175 1.15 1.33 1.579 1.777 2.02 2.309 2.628 2.91 3.17 3.494 3.866 4.263;
1.315 1.227 1.448 1.697 1.924 2.167 2.456 2.775 3.095 3.376 3.746 4.117 4.527;
1.464 1.313 1.564 1.812 2.056 2.301 2.618 2.94 3.261 3.601 3.975 4.348 4.792;
1.545 1.413 1.673 1.921 2.166 2.418 2.811 3.133 3.454 3.795 4.168 4.542 5.059;
1.421 1.513 1.782 2.03 2.275 2.569 2.963 3.327 3.648 3.989 4.362 4.777 5.327;
1.51 1.613 1.892 2.14 2.384 2.72 3.114 3.52 3.842 4.183 4.556 5.05 5.597;
1.602 1.714 1.993 2.249 2.506 2.872 3.265 3.678 4.035 4.376 4.778 5.323 5.868;
1.694 1.814 2.093 2.358 2.658 3.023 3.417 3.83 4.229 4.57 5.051 5.595 6.14;
1.788 1.914 2.193 2.468 2.809 3.175 3.568 3.981 4.394 4.779 5.323 5.868 6.414;
1.882 2.036 2.318 2.583 2.949 3.317 3.739 4.153 4.567 5.039 5.596 6.141 6.689;
1.978 2.197 2.472 2.704 3.071 3.453 3.933 4.371 4.785 5.256 5.816 6.376 6.964;
2.075 2.36 2.594 2.826 3.192 3.61 4.09 4.588 5.002 5.473 6.033 6.607 7.241;
2.173 2.448 2.715 2.947 3.326 3.767 4.247 4.755 5.22 5.69 6.252 6.864 7.519;
2.272 2.529 2.812 3.069 3.483 3.925 4.404 4.912 5.42 5.907 6.489 7.121 7.798;
2.372 2.601 2.922 3.196 3.636 4.077 4.566 5.074 5.582 6.118 6.727 7.38 8.078;
2.473 2.71 3.065 3.338 3.778 4.232 4.74 5.248 5.752 6.339 6.967 7.639 8.358;
2.574 2.82 3.207 3.481 3.92 4.405 4.913 5.392 5.956 6.56 7.207 7.899 8.64;
2.677 2.931 3.262 3.623 4.071 4.537 5.039 5.58 6.16 6.782 7.448 8.16 8.922;
2.78 3.043 3.384 3.765 4.217 4.695 5.212 5.768 6.364 7.004 7.689 8.422 9.205]'; 


% (g/s), engine out HC emissions indexed vertically by fc_map_spd and
% horizontally by fc_map_trq
fc_hc_map=[0.002332 0.004875 0.01638 0.01687 0.01735 0.01823 0.01961 0.02145 0.02365 0.02601 0.02837 0.03051 0.03223;
0.001914 0.002589 0.003211 0.005289 0.007636 0.01049 0.01201 0.01377 0.01586 0.01812 0.02034 0.02233 0.02389;
0.001659 0.002379 0.003003 0.003642 0.004264 0.005955 0.008246 0.01054 0.01325 0.01611 0.01614 0.01799 0.01939;
0.001429 0.002168 0.002791 0.003407 0.004029 0.004652 0.006259 0.008623 0.01099 0.0129 0.01573 0.01856 0.01641;
0.001199 0.001911 0.002535 0.003135 0.003757 0.004326 0.005899 0.008263 0.01003 0.01147 0.0143 0.01682 0.01423;
0.001059 0.001654 0.002278 0.002863 0.003486 0.003967 0.005539 0.007903 0.008613 0.01005 0.01288 0.0138 0.01253;
0.0009577 0.001397 0.002007 0.002591 0.003183 0.003607 0.005179 0.006649 0.007196 0.00862 0.01067 0.01079 0.01115;
0.0008568 0.00114 0.001735 0.002319 0.002823 0.003247 0.004685 0.005232 0.005779 0.007193 0.007659 0.007769 0.009977;
0.0008361 0.000927 0.001495 0.002053 0.002478 0.002903 0.00339 0.003945 0.004499 0.00487 0.004936 0.005001 0.008956;
0.0008445 0.0008268 0.001395 0.001838 0.002263 0.002688 0.003076 0.003598 0.004153 0.004524 0.004589 0.004655 0.00804;
0.000853 0.0007266 0.001295 0.001624 0.002049 0.002473 0.002861 0.003251 0.003806 0.004177 0.004243 0.004303 0.007196;
0.0008614 0.0006263 0.001113 0.00141 0.001834 0.002259 0.002646 0.003009 0.003459 0.003831 0.003894 0.00395 0.006404;
0.0008503 0.0005261 0.0008985 0.001195 0.001619 0.002044 0.002431 0.002794 0.003158 0.003484 0.003541 0.003597 0.005644;
0.0008309 0.0004565 0.0007654 0.001076 0.001489 0.001903 0.002241 0.002607 0.002973 0.003221 0.003271 0.003321 0.004904;
0.0008336 0.0004662 0.0007697 0.00108 0.001493 0.001894 0.0021 0.002465 0.002831 0.003078 0.003128 0.003178 0.004174;
0.00 0.0004759 0.0007741 0.001084 0.001498 0.001819 0.002025 0.002323 0.002689 0.002935 0.002985 0.002983 0.003444;
0.00 0.0004856 0.0007785 0.001089 0.001502 0.001745 0.001951 0.002181 0.002547 0.002792 0.002842 0.00274 0.002708;
0.00 0.0004952 0.0007874 0.001093 0.001483 0.00167 0.001876 0.002096 0.002405 0.002649 0.002663 0.002497 0.00196;
0.00 0.0005049 0.0007971 0.001097 0.001409 0.001596 0.001802 0.002021 0.002263 0.002506 0.002421 0.002255 0.001195;
0.00 0.0005146 0.0008068 0.001102 0.001334 0.001522 0.001727 0.001947 0.002166 0.002344 0.002178 0.002012 0.0004093;
0.00 0.0005098 0.0008002 0.001089 0.001274 0.001459 0.001607 0.001824 0.00204 0.002105 0.001935 0.001769 0.00;
0.00 0.0004783 0.0007679 0.001052 0.001238 0.001409 0.001441 0.001596 0.001812 0.001878 0.001708 0.001537 0.00;
0.00 0.0004479 0.0007315 0.001016 0.001201 0.001339 0.001371 0.001368 0.001585 0.001651 0.00148 0.00 0.00;
0.00 0.0004485 0.000695 0.0009791 0.001153 0.001268 0.001301 0.001273 0.001357 0.001424 0.0002149 0.00 0.00;
0.00 0.0004512 0.0006808 0.0009427 0.001083 0.001198 0.001232 0.001203 0.001175 0.001197 0.00 0.00 0.00;
0.00 0.0005731 0.0006672 0.0009088 0.001026 0.001141 0.001153 0.001125 0.001096 0.00 0.00 0.00 0.00;
0.00 0.0004794 0.0006382 0.0008799 0.0009968 0.001085 0.001057 0.001028 0.00 0.00 0.00 0.00 0.00;
0.00 0.0003476 0.0006093 0.000851 0.000968 0.0009884 0.00096 0.00 0.00 0.00 0.00 0.00 0.00;
0.00 0.0001767 0.001495 0.0008221 0.0009203 0.0003793 0.00 0.00 0.00 0.00 0.00 0.00 0.00;
0.00 0.00 0.00128 0.0007932 0.0006659 5.89e-005 0.00 0.00 0.00 0.00 0.00 0.00 0.00]'; 

% (g/s), engine out CO emissions indexed vertically by fc_map_spd and
% horizontally by fc_map_trq
fc_co_map=[0.01601 0.03862 0.00 0.00 0.00 0.00 0.00 0.00 0.00 0.00 0.00 0.00 0.00;
0.00909 0.01464 0.02329 0.05077 0.07931 0.09232 0.06873 0.1016 0.1244 0.1371 0.1407 0.1368 0.1272;
0.00821 0.01173 0.01671 0.02418 0.03283 0.05529 0.08552 0.1157 0.133 0.146 0.1722 0.1694 0.1615;
0.00727 0.01018 0.01516 0.01971 0.02832 0.03693 0.05827 0.08958 0.1209 0.1391 0.1522 0.1653 0.163;
0.006329 0.009315 0.0143 0.01799 0.0266 0.03439 0.0552 0.08651 0.1123 0.1263 0.1394 0.1522 0.153;
0.006554 0.008449 0.01343 0.01627 0.02488 0.03133 0.05214 0.08345 0.09954 0.1136 0.1267 0.1378 0.1393;
0.007301 0.007584 0.01178 0.01454 0.02269 0.02827 0.04908 0.07216 0.08676 0.1008 0.1131 0.1234 0.1251;
0.008049 0.006719 0.01007 0.01282 0.01962 0.0252 0.04478 0.05937 0.07397 0.088 0.09868 0.109 0.1121;
0.01698 0.006296 0.00881 0.01121 0.01681 0.02242 0.03279 0.04743 0.06208 0.07504 0.08522 0.09539 0.1008;
0.0289 0.007052 0.009566 0.01073 0.01633 0.02147 0.02795 0.04162 0.05626 0.06923 0.07941 0.08958 0.09128;
0.04081 0.007808 0.01032 0.01025 0.01584 0.01953 0.02602 0.03581 0.05045 0.06342 0.0736 0.08335 0.08367;
0.05272 0.008563 0.01019 0.009771 0.01482 0.01759 0.02409 0.03309 0.04464 0.05762 0.06759 0.07705 0.0778;
0.123 0.009319 0.009714 0.00929 0.01288 0.01565 0.02216 0.03116 0.04017 0.05181 0.06129 0.07076 0.07347;
0.208 0.013 0.009301 0.008888 0.01157 0.01426 0.02018 0.02919 0.03819 0.04732 0.05666 0.066 0.07047;
0.1968 0.02495 0.009001 0.008589 0.01127 0.01397 0.01815 0.02713 0.03613 0.04526 0.05461 0.06395 0.06857;
0.2921 0.0369 0.008702 0.008289 0.01097 0.01375 0.01793 0.02508 0.03408 0.04321 0.05255 0.0604 0.06756;
0.3154 0.04885 0.008402 0.007989 0.01067 0.01353 0.0177 0.02302 0.03203 0.04116 0.0505 0.05552 0.06721;
0.3391 0.0608 0.01863 0.007689 0.01039 0.01331 0.01747 0.0225 0.02997 0.0391 0.04743 0.05064 0.0673;
0.3631 0.07275 0.03058 0.00739 0.01017 0.01309 0.01724 0.02227 0.02792 0.03705 0.04255 0.04575 0.06764;
0.3871 0.0847 0.04253 0.00709 0.009951 0.01287 0.01702 0.02205 0.02708 0.03445 0.03766 0.04087 0.06804;
0.411 0.13 0.09176 0.007768 0.009895 0.01279 0.01625 0.02125 0.02624 0.03023 0.03278 0.03599 0.06831;
0.4346 0.2364 0.1814 0.008125 0.01011 0.01298 0.01505 0.0192 0.02419 0.02819 0.0306 0.03302 0.06828;
0.4578 0.3453 0.1818 0.008482 0.01033 0.01313 0.0152 0.01714 0.02214 0.02614 0.02856 0.04071 0.06778;
0.4803 0.3434 0.1821 0.008838 0.01053 0.01327 0.01535 0.01694 0.02009 0.02409 0.01816 0.03785 0.06667;
0.5021 0.3322 0.1764 0.009195 0.01068 0.01342 0.0155 0.01709 0.01868 0.02204 0.01346 0.03423 0.0648;
0.5229 0.2839 0.1762 0.0125 0.01394 0.01676 0.01873 0.02037 0.02202 0.00 0.007872 0.02971 0.06203;
0.5427 0.298 0.1867 0.02293 0.02425 0.02683 0.02848 0.03012 0.00 0.00 0.001251 0.02416 0.05823;
0.5614 0.311 0.1971 0.03337 0.03455 0.03659 0.03823 0.00 0.00 0.00 0.00 0.01746 0.05328;
0.5788 0.3227 0.1747 0.0438 0.0447 0.00 0.00 0.00 0.00 0.00 0.00 0.009497 0.04706;
0.5949 0.3331 0.1801 0.05423 0.03036 0.00 0.00 0.00 0.00 0.00 0.00 0.0001568 0.03947]'; 

% (g/s), engine out NOx emissions indexed vertically by fc_map_spd and
% horizontally by fc_map_trq
fc_nox_map =[0.001057 0.00263 0.05238 0.04868 0.0441 0.04044 0.03836 0.03788 0.03868 0.04022 0.04187 0.04294 0.04273;
0.000501 0.001241 0.002004 0.003041 0.004228 0.006425 0.01261 0.01267 0.01397 0.01599 0.0181 0.01959 0.01978;
0.001609 0.00103 0.001483 0.002221 0.002985 0.003949 0.005026 0.006103 0.008023 0.01022 0.009219 0.01114 0.01173;
0.002727 0.00166 0.00212 0.002974 0.003723 0.004471 0.005402 0.00654 0.007678 0.009755 0.0119 0.01405 0.01018;
0.003845 0.002777 0.003236 0.00481 0.005559 0.006251 0.007145 0.008284 0.009928 0.0124 0.01455 0.01705 0.0123;
0.006584 0.003893 0.004352 0.006647 0.007395 0.007995 0.008889 0.01003 0.01257 0.01504 0.01719 0.02146 0.01679;
0.01005 0.005009 0.006135 0.008483 0.009199 0.009739 0.01063 0.01253 0.01521 0.01768 0.0207 0.02587 0.02289;
0.01352 0.006125 0.007969 0.01032 0.01094 0.01148 0.01249 0.01517 0.01785 0.02033 0.02511 0.03028 0.03013;
0.01772 0.00791 0.01011 0.01217 0.01271 0.01325 0.01545 0.01815 0.02085 0.02447 0.02963 0.03479 0.03821;
0.02219 0.01139 0.01359 0.01417 0.01471 0.01549 0.02021 0.02358 0.02628 0.0299 0.03506 0.04022 0.0469;
0.02666 0.01488 0.01708 0.01617 0.01671 0.01824 0.02297 0.02901 0.03171 0.03533 0.04049 0.04703 0.05602;
0.03112 0.01836 0.0195 0.01817 0.01899 0.02099 0.02573 0.03231 0.03715 0.04076 0.04659 0.05404 0.06545;
0.02953 0.02185 0.0215 0.02017 0.02174 0.02374 0.02849 0.03507 0.04165 0.04619 0.0536 0.06105 0.0751;
0.02519 0.02571 0.02531 0.02428 0.02607 0.02787 0.03411 0.041 0.04789 0.05494 0.06227 0.06959 0.08486;
0.0272 0.03021 0.03216 0.03113 0.03292 0.03496 0.0453 0.05223 0.05912 0.06617 0.07349 0.08081 0.09469;
0.000753 0.03472 0.039 0.03798 0.03977 0.04323 0.05355 0.06345 0.07034 0.0774 0.08472 0.09195 0.1045;
0.003986 0.03922 0.04585 0.04483 0.04662 0.05151 0.06181 0.07468 0.08157 0.08862 0.09595 0.103 0.1143;
0.007131 0.04373 0.05069 0.05167 0.05389 0.05978 0.07006 0.08341 0.09279 0.09985 0.1071 0.1141 0.124;
0.01015 0.04824 0.0552 0.05852 0.06216 0.06805 0.07831 0.09166 0.104 0.1111 0.1182 0.1251 0.1336;
0.01302 0.05274 0.0597 0.06537 0.07043 0.07632 0.08656 0.09991 0.1133 0.1223 0.1292 0.1362 0.143;
0.01571 0.05367 0.06021 0.07079 0.07701 0.08318 0.09402 0.1073 0.1206 0.1321 0.1403 0.1472 0.1522;
0.0182 0.04805 0.05607 0.07452 0.08075 0.08767 0.09958 0.1129 0.1262 0.1376 0.1461 0.1546 0.1612;
0.02045 0.04223 0.0598 0.07825 0.0845 0.09319 0.1051 0.1185 0.1318 0.1432 0.1517 0.1614 0.17;
0.02247 0.04362 0.06353 0.08199 0.08887 0.09871 0.1106 0.124 0.1374 0.1488 0.1587 0.1696 0.1786;
0.02422 0.04563 0.06618 0.08572 0.09439 0.1042 0.1161 0.1295 0.143 0.1544 0.1661 0.1775 0.1869;
0.02569 0.05701 0.06812 0.0889 0.09882 0.1086 0.121 0.1344 0.1479 0.1603 0.1733 0.1851 0.1949;
0.02687 0.05888 0.07006 0.09085 0.1008 0.1113 0.1247 0.1381 0.1528 0.1668 0.1802 0.1924 0.2026;
0.02774 0.06044 0.07201 0.0928 0.1027 0.1149 0.1283 0.1439 0.1584 0.1729 0.1868 0.1994 0.2101;
0.0283 0.06169 0.08139 0.09475 0.1052 0.1208 0.1343 0.1488 0.1638 0.1787 0.1931 0.2061 0.2172;
0.02853 0.06261 0.08298 0.0967 0.1109 0.1242 0.1383 0.1533 0.1688 0.1842 0.199 0.2125 0.2239]';  

% (g/s), engine out PM emissions indexed vertically by fc_map_spd and
% horizontally by fc_map_trq
fc_pm_map=[0.0004495 0.0008454 0.00 0.00 0.00 0.00 0.00 0.00 0.00 0.00 0.00 0.00 0.00;
0.0003168 0.0003941 0.0009888 0.001006 0.001041 0.002019 0.00 0.00 0.00 0.00 0.00 0.00 0.00;
0.0005993 0.0005031 0.0004669 0.000864 0.001459 0.00163 0.001562 0.001495 0.002215 0.003193 0.002305 0.002589 0.003436;
0.0008912 0.0007578 0.0007219 0.0006707 0.00126 0.001848 0.001987 0.001907 0.001827 0.002347 0.003305 0.004263 0.005129;
0.001183 0.001041 0.001005 0.0009162 0.001505 0.002031 0.002129 0.002049 0.002146 0.002801 0.003759 0.004708 0.006009;
0.001262 0.001323 0.001288 0.001162 0.00175 0.002173 0.002271 0.002191 0.002602 0.003256 0.004214 0.005112 0.006498;
0.001246 0.001606 0.001537 0.001407 0.00196 0.002316 0.002414 0.002599 0.003059 0.00371 0.004643 0.005516 0.006795;
0.001231 0.001889 0.001783 0.001652 0.002102 0.002458 0.002596 0.003056 0.003515 0.004164 0.005048 0.00592 0.007001;
0.001211 0.002088 0.001981 0.001903 0.002261 0.002618 0.003014 0.003471 0.003928 0.004543 0.005421 0.006298 0.007172;
0.001189 0.00207 0.001963 0.002208 0.002565 0.0029 0.003163 0.003592 0.004049 0.004663 0.005541 0.006418 0.00734;
0.001168 0.002053 0.001946 0.002512 0.00287 0.003132 0.003395 0.003712 0.004169 0.004784 0.005661 0.00641 0.00752;
0.001147 0.002035 0.002158 0.002817 0.003148 0.003363 0.003627 0.003922 0.00429 0.004904 0.005719 0.006384 0.007723;
0.003258 0.002018 0.002463 0.003121 0.003379 0.003595 0.003858 0.004154 0.004449 0.005024 0.005693 0.006357 0.007952;
0.006085 0.001997 0.002553 0.003175 0.003417 0.003657 0.003942 0.004222 0.004501 0.004926 0.005596 0.006266 0.008209;
0.005933 0.001974 0.00228 0.002903 0.003145 0.003394 0.003736 0.004016 0.004295 0.004722 0.005392 0.006062 0.008491;
0.01132 0.001951 0.002008 0.002631 0.002872 0.003174 0.003517 0.00381 0.00409 0.004517 0.005187 0.006176 0.008799;
0.01181 0.001927 0.001736 0.002358 0.0026 0.002955 0.003298 0.003605 0.003884 0.004313 0.004983 0.006576 0.009127;
0.01232 0.001904 0.001677 0.002086 0.002343 0.002735 0.003079 0.003388 0.003679 0.004108 0.004996 0.006977 0.009474;
0.01284 0.001881 0.001654 0.001813 0.002124 0.002516 0.00286 0.003169 0.003473 0.003904 0.005396 0.007377 0.009836;
0.01338 0.001857 0.001631 0.001541 0.001904 0.002297 0.00264 0.002949 0.003258 0.003816 0.005797 0.007778 0.01021;
0.01392 0.003062 0.00298 0.001385 0.001746 0.002128 0.002537 0.002853 0.003168 0.004162 0.006197 0.008178 0.01059;
0.01447 0.006516 0.005879 0.001331 0.001688 0.002113 0.002658 0.003023 0.003338 0.004329 0.006375 0.008421 0.01097;
0.01501 0.01005 0.005825 0.001278 0.001631 0.002156 0.002701 0.003193 0.003508 0.004496 0.006542 0.007925 0.01136;
0.01556 0.01019 0.005772 0.001224 0.001609 0.002199 0.002745 0.003256 0.003678 0.004663 0.005724 0.008176 0.01174;
0.01609 0.01004 0.005681 0.001171 0.001652 0.002243 0.002788 0.0033 0.003811 0.00483 0.005865 0.00842 0.01211;
0.01662 0.008043 0.005772 0.001229 0.001779 0.002371 0.002906 0.003419 0.003932 0.004262 0.005996 0.008655 0.01247;
0.01713 0.0084 0.006089 0.001546 0.002092 0.002669 0.003182 0.003696 0.003211 0.004302 0.006114 0.008876 0.01282;
0.01763 0.00874 0.006407 0.001864 0.002406 0.002946 0.003459 0.002572 0.003184 0.004327 0.006216 0.009081 0.01316;
0.0181 0.009061 0.004979 0.002181 0.002709 0.002238 0.002239 0.0025 0.003138 0.004332 0.006299 0.009267 0.01347;
0.01856 0.00936 0.005148 0.002499 0.002481 0.002171 0.002147 0.002407 0.00307 0.004316 0.00636 0.009432 0.01377]'; 

% (g/s), engine out O2 indexed vertically by fc_map_spd and
% horizontally by fc_map_trq
fc_o2_map=zeros(size(fc_fuel_map));


% create BS** maps for plotting purposes
[T,w]=meshgrid(fc_map_trq,fc_map_spd); 
fc_map_kW=T.*w/1000; 
fc_fuel_map_gpkWh=fc_fuel_map./fc_map_kW*3600; 
fc_co_map_gpkWh=fc_co_map./fc_map_kW*3600; 
fc_hc_map_gpkWh=fc_hc_map./fc_map_kW*3600; 
fc_nox_map_gpkWh=fc_nox_map./fc_map_kW*3600; 
fc_pm_map_gpkWh=fc_pm_map./fc_map_kW*3600; 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Cold Engine Maps
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
fc_cold_tmp=20; %deg C
fc_fuel_map_cold=zeros(size(fc_fuel_map));

fc_hc_map_cold=zeros(size(fc_fuel_map));

fc_co_map_cold=zeros(size(fc_fuel_map));

fc_nox_map_cold=zeros(size(fc_fuel_map));

fc_pm_map_cold=zeros(size(fc_fuel_map));

%Process Cold Maps to generate Correction Factor Maps
names={'fc_fuel_map','fc_hc_map','fc_co_map','fc_nox_map','fc_pm_map'};

for i=1:length(names)
    %cold to hot raio, e.g. fc_fuel_map_c2h = fc_fuel_map_cold ./ fc_fuel_map
    eval([names{i},'_c2h=',names{i},'_cold./(',names{i},'+eps); '])
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% LIMITS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% (N*m), max torque curve of the engine indexed by fc_map_spd
fc_max_trq=[75  238.831  280.578  307.875  299.154  289.939  280.724  271.509 262.329  251.716  238.851  225.987  215.5]; 



% (N*m), closed throttle torque of the engine (max torque that can be absorbed)
% indexed by fc_map_spd -- correlation from JDMA
fc_ct_trq=4.448/3.281*(-fc_disp)*61.02/24 * ...
   (9*(fc_map_spd/max(fc_map_spd)).^2 + 14 * (fc_map_spd/max(fc_map_spd))); 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DEFAULT SCALING
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% (--), used to scale fc_map_spd to simulate a faster or slower running engine 
fc_spd_scale=1.0; 
% (--), used to scale fc_map_trq to simulate a higher or lower torque engine
fc_trq_scale=1.0; 
fc_pwr_scale=fc_spd_scale*fc_trq_scale;    % --  scale fc power

% user definable mass scaling function
fc_mass_scale_fun=inline('(x(1)*fc_trq_scale+x(2))*(x(3)*fc_spd_scale+x(4))*(fc_base_mass+fc_acc_mass)+fc_fuel_mass','x','fc_spd_scale','fc_trq_scale','fc_base_mass','fc_acc_mass','fc_fuel_mass');

fc_mass_scale_coef=[1 0 1 0]; % coefficients of mass scaling function


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% STUFF THAT SCALES WITH TRQ & SPD SCALES (MASS AND INERTIA)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
fc_inertia=0.1*fc_pwr_scale;            % (kg*m^2), rotational inertia of the engine
fc_max_pwr=(max(fc_map_spd.*fc_max_trq)/1000)*fc_pwr_scale;  % kW     peak engine power
fc_base_mass=1.8*fc_max_pwr;              	% (kg), mass of the engine block and head (base engine)
                                        				% mass penalty of 1.8 kg/kW from 1994 OTA report, Table 3 
fc_acc_mass=0.8*fc_max_pwr;              	% kg    engine accy's, electrics, cntrl's - assumes mass penalty of 0.8 kg/kW (from OTA report)
fc_fuel_mass=0.6*fc_max_pwr;             	% kg    mass of fuel and fuel tank
fc_mass=fc_base_mass+fc_acc_mass+fc_fuel_mass;  		% kg  total engine/fuel system mass
fc_ext_sarea=0.3*(fc_max_pwr/100)^0.67;        		% m^2    exterior surface area of engine


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% OTHER DATA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
fc_fuel_den=749;  					% (g/l), density of the fuel 
fc_fuel_lhv=42700;  							% (J/g), lower heating value of the fuel

fc_tstat=96;                   		% C      engine coolant thermostat set temperature (typically 95 +/- 5 C)
fc_cp=500;                     		% J/kgK  ave cp of engine (iron=500, Al or Mg = 1000)
fc_h_cp=500;                   		% J/kgK  ave cp of hood & engine compartment (iron=500, Al or Mg = 1000)
fc_hood_sarea=1.5;             		% m^2    surface area of hood/eng compt.
fc_emisv=.8;                  		%        emissivity of engine ext surface/hood int surface
fc_hood_emisv=.9;             		%        emissivity hood ext
fc_h_air_flow=0;             		% kg/s   heater air flow rate (140 cfm=0.07)
fc_cl2h_eff=.7;               		% --     ave cabin heater HX eff (based on air side)
fc_c2i_th_cond=500;            		% W/K    conductance btwn engine cyl & int
fc_i2x_th_cond=500;            		% W/K    conductance btwn engine int & ext
fc_h2x_th_cond=10;             		% W/K    conductance btwn engine & engine compartment

% calculate "predicted" exh gas flow rate and engine-out (EO) temp
fc_ex_pwr_frac=[0.40 0.30];                         % --   frac of waste heat that goes to exhaust as func of engine speed
fc_exflow_map=fc_fuel_map*(1+14.5);                 % g/s  ex gas flow map:  for SI engines, exflow=(fuel use)*[1 + (stoic A/F ratio)]
fc_waste_pwr_map=fc_fuel_map*fc_fuel_lhv - T.*w;    % W    tot FC waste heat = (fuel pwr) - (mech out pwr)
spd=fc_map_spd; 
fc_ex_pwr_map=zeros(size(fc_waste_pwr_map));        % W   initialize size of ex pwr map
for i=1:length(spd)
 fc_ex_pwr_map(i,:)=fc_waste_pwr_map(i,:)*interp1([min(spd) max(spd)],fc_ex_pwr_frac,spd(i));  % W  trq-spd map of waste heat to exh 
end
fc_extmp_map=fc_ex_pwr_map./(fc_exflow_map*1089/1000) + 20;    % W   EO ex gas temp = Q/(MF*cp) + Tamb (assumes engine tested ~20 C)

%the following variable is not used directly in modelling and should always be equal to one
%it's used for initialization purposes
fc_eff_scale=1; 

% clean up workspace
clear T w fc_waste_pwr_map fc_ex_pwr_map spd fc_map_kW

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% REVISION HISTORY
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%05-Apr-2002 08:26:21: file created using engmodel 

