%-------------------------------------------------------------------------------------
%
% M-file: cp_air.m  [kJ/kg,K]
% 
% Calculates the heat capacity of air as a function of temperature
% Data from L. Wester, 1998
%
% Created: 08/04/00 by Kristina Haraldsson
% Revision history: 04/01/02
%                   
%--------------------------------------------------------------------------------------
function f=cp_air(T)

M_air=28.97;                %[kg/kmol]

a_min1=0;
a_0=29.438265;
a_1=-1.6108220;
a_2=-11.991744;
a_3=68.828384;
a_4=-98.239929;
a_5=64.883505;
a_6=-20.909380;
a_7=2.6652402;

y=a_min1*(T/1000)^(-1)+a_0*(T/1000)^(0)+a_1*(T/1000)^(1)+a_2*(T/1000)^(2)+a_3*(T/1000)^(3)+a_4*(T/1000)^(4)+a_5*(T/1000)^(5)+a_6*(T/1000)^(6)+a_7*(T/1000)^(7);
%z=y/M_air;

f=[y];
