%----------------------------------------------------------------------------------
% 
% M-file: k.m
% Created: 000221 by Kristina Johansson
%-----------------------------------------------------------------------------------
function f=k(T)

%Values from Table A-4 Ideal gas Hydrogen "Advanced Thermodynamics for Engineers" 
%Kenneth Wark Jr.,Mcgraw-Hill 1995
%Unit: kJ/(kg*K)

if T<250
   y=0;
elseif ((T>=250) & (T<300))
   y=(T-250)/(300-250)*(1.400-1.401)+1.401;
elseif ((T>=300) & (T<350))
   y=(T-300)/(350-300)*(1.398-1.400)+1.400;
elseif ((T>=350) & (T<400))
   y=(T-350)/(400-350)*(1.395-1.398)+1.398;
elseif ((T>=400) & (T<450))
   y=(T-400)/(450-400)*(1.391-1.395)+1.395;
elseif ((T>=450) & (T<500))
   y=(T-450)/(500-450)*(1.387-1.391)+1.391;
elseif (T>=500)
   y=0;
end;

f=y;
