function eng_params_process(action)
% gui lets user input engine parameters and then processes the data in the workspace to 
% generate a square matrix for ADVISOR
global einf;

if nargin==0
   
   figcolor=[.8 .8 1];
   butcolor=[1 0.5 0.25];
   butcolor1=[1 1 .64]; %yellow
   butcolor2=[1 .5 .5]; %coral
   butcolor3=[.34 .67 .67]; %greenish
   butcolor4=[.85 .85 .85]; %grey
   dy=20;
   dx=-25;
   dx2=50;
   
   %figure
   h0 = figure('Color',figcolor, ...
      'Name','Process Engine Data', ...
      'NumberTitle','off', ...
      'PaperPosition',[18 180 576 432], ...
      'PaperUnits','points', ...
      'Position',[506+dx 271 652 360], ...
      'ToolBar','none',...
      'visible','off');
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figcolor, ...
      'FontSize',14, ...
      'FontWeight','bold', ...
      'HorizontalAlignment','Left',...
      'Position',[33+dx 310+dy 342 22], ...
      'String','Process Engine Data', ...
      'Style','text');
   
   %Name of mat file
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',butcolor1, ...
      'CallBack','eng_params_process(''get file'')',...
      'Position',[22 255+dy 112 36], ...
      'String','Name of mat file');
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[1 1 1], ...
      'Position',[145 260+dy 179 22], ...
      'String','', ...
      'Style','text', ...
      'Tag','file name');
   try, set(h1,'string',einf.filename); end
   %Algorithm choice
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figcolor, ...
      'FontSize',12, ...
      'Position',[33+dx 224+dy 225 22], ...
      'String','Extrapolated map points algorithm:', ...
      'Style','text');
   %Radiobuttons
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figcolor, ...
      'Callback','eng_params_process(''poly'')',...
      'Position',[192+dx2 225+dy 113 24], ...
      'String','Polynomial Fit', ...
      'Style','radiobutton', ...
      'Tag','polyfit', ...
      'Value',1);
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figcolor, ...
      'Callback','eng_params_process(''nearest'')',...
      'Position',[312+dx2 225+dy 113 24], ...
      'String','Nearest Neighbor', ...
      'Style','radiobutton', ...
      'Tag','nearest', ...
      'Value',0);
   
   %min speed
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figcolor, ...
      'HorizontalAlignment','left', ...
      'Position',[87+dx 184+dy 125 17], ...
      'String','Minimum Speed (rpm)', ...
      'Style','text');
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[1 1 1], ...
      'HorizontalAlignment','left', ...
      'Position',[189 184+dy 276 22], ...
      'String','500', ...
      'Style','edit', ...
      'Tag','min spd');
   %max spd
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figcolor, ...
      'HorizontalAlignment','left', ...
      'Position',[87+dx 155+dy 125 17], ...
      'String','Maximum Speed (rpm)', ...
      'Style','text');
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[1 1 1], ...
      'HorizontalAlignment','left', ...
      'Position',[189 155+dy 276 22], ...
      'String','4000', ...
      'Style','edit', ...
      'Tag','max spd');
   %speed increments
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figcolor, ...
      'HorizontalAlignment','left', ...
      'Position',[87+dx 126+dy 125 17], ...
      'String','Speed increments (rpm) ', ...
      'Style','text');
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[1 1 1], ...
      'HorizontalAlignment','left', ...
      'Position',[189 126+dy 276 22], ...
      'String','250', ...
      'Style','edit', ...
      'Tag','spd inc');
   %min trq
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figcolor, ...
      'HorizontalAlignment','left', ...
      'Position',[87+dx 97+dy 125 17], ...
      'String','Minimum Torque (Nm)', ...
      'Style','text');
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[1 1 1], ...
      'HorizontalAlignment','left', ...
      'Position',[189 97+dy 276 22], ...
      'String','10', ...
      'Style','edit', ...
      'Tag','min trq');
   %max trq
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figcolor, ... 
      'HorizontalAlignment','left', ...
      'Position',[87+dx 68+dy 125 17], ...
      'String','Maximum Torque (Nm)', ...
      'Style','text');
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[1 1 1], ...
      'HorizontalAlignment','left', ...
      'Position',[189 68+dy 276 22], ...
      'String','150', ...
      'Style','edit', ...
      'Tag','max trq');
   %trq inc
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figcolor, ...
      'HorizontalAlignment','left', ...
      'Position',[87+dx 39+dy 125 17], ...
      'String','Torque increment (Nm)', ...
      'Style','text');
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[1 1 1], ...
      'HorizontalAlignment','left', ...
      'Position',[189 39+dy 276 22], ...
      'String','10', ...
      'Style','edit', ...
      'Tag','trq inc');
   %fuel lower heating value
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figcolor, ...
      'HorizontalAlignment','left', ...
      'Position',[87+dx 10+dy 125 17], ...
      'String','Lower Heating Value (J/g)', ...
      'Style','text');
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[1 1 1], ...
      'HorizontalAlignment','left', ...
      'Position',[189 10+dy 276 22], ...
      'String','42600', ...
      'Style','edit', ...
      'Tag','lhv');
   
   %Plot results?
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figcolor, ...
      'Callback','eng_params_process(''plot'')', ...
      'Position',[516 39+dy 118 22], ...
      'Value',1,...
      'Style','checkbox',...
      'String','Plot results?',...
      'Tag','plot results');
   try, set(h1,'value',einf.plot);end
   %Process data
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',butcolor, ...
      'Callback','eng_params_process(''process'')', ...
      'Position',[516 10+dy 118 24], ...
      'String','Process');
   
   try,set(findobj('tag','min spd'),'string',num2str(evalin('base','ceil(min(fc_spd))')));
      set(findobj('tag','max spd'),'string',num2str(evalin('base','floor(max(fc_spd))')));
      set(findobj('tag','min trq'),'string',num2str(evalin('base','ceil(min(fc_trq))')));
      set(findobj('tag','max trq'),'string',num2str(evalin('base','floor(max(fc_trq))')));
   end
   if str2num(get(findobj('tag','min trq'),'string'))<1
      set(findobj('tag','min trq'),'string',num2str(evalin('base','1')));
   end
   eng_params_process('poly');
   
   % Set figure to normalized for proper resizing
   h=findobj('type','uicontrol');
   g=findobj('type','axes');
   set([h; g],'units','normalized')
   
   %Center figure on screen
   screensize=get(0,'screensize');
   position=get(gcf,'position');
   position(1)=(screensize(3)-position(3))/2;
   position(2)=(screensize(4)-(position(4)+20))/2;
   set(gcf,'position',position,'visible','on')
   
   
   eng_params_process('plot');
   
end

if nargin>0
   switch action
   case 'get file'
      %get the file name
      [f p]=uigetfile('*.*','Select mat file');
      if f==0
         return
      end
      
      f.file_name=f;
      set(findobj('tag','file name'),'string',f.file_name);
      einf.filename=f.file_name;
      einf.path=p;
      evalin('base',['load ',f.file_name]);
      
      set(findobj('tag','min spd'),'string',num2str(evalin('base','ceil(min(fc_spd))')));
      set(findobj('tag','max spd'),'string',num2str(evalin('base','floor(max(fc_spd))')));
      set(findobj('tag','min trq'),'string',num2str(evalin('base','ceil(min(fc_trq))')));
      set(findobj('tag','max trq'),'string',num2str(evalin('base','floor(max(fc_trq))')));
      
      if str2num(get(findobj('tag','min trq'),'string'))<1
         set(findobj('tag','min trq'),'string',num2str(evalin('base','1')));
      end
         
   case 'poly'
      poly=get(findobj('tag','polyfit'),'value');
      if poly
         einf.algorithm='polynomial';
         set(findobj('tag','polyfit'),'value',1)
         set(findobj('tag','nearest'),'value',0)
      else
         einf.algorithm='nearest';
         set(findobj('tag','polyfit'),'value',0)
         set(findobj('tag','nearest'),'value',1)
      end
   case 'nearest'
      near=get(findobj('tag','nearest'),'value');
      if ~near
         einf.algorithm='polynomial';
         set(findobj('tag','polyfit'),'value',1)
         set(findobj('tag','nearest'),'value',0)
      else
         einf.algorithm='nearest';
         set(findobj('tag','polyfit'),'value',0)
         set(findobj('tag','nearest'),'value',1)
      end
   case 'plot'
      plot=get(findobj('tag','plot results'),'value');
      if plot
         einf.plot=1;
      else
         einf.plot=0;
      end
   case 'process'
      %check minimum torque (needs to be greater than 0
      if str2num(get(findobj('tag','min trq'),'string'))<0
         errordlg('Minimum torque needs to be greater than zero.');
         return
      end
      
      %get data input by user
      einf.minspd=str2num(get(findobj('tag','min spd'),'string'));
      einf.maxspd=str2num(get(findobj('tag','max spd'),'string'));
      einf.spdinc=str2num(get(findobj('tag','spd inc'),'string'));
      einf.mintrq=str2num(get(findobj('tag','min trq'),'string'));
      einf.maxtrq=str2num(get(findobj('tag','max trq'),'string'));
      einf.trqinc=str2num(get(findobj('tag','trq inc'),'string'));
      einf.lhv=str2num(get(findobj('tag','lhv'),'string'));
      
      %clear workspace, load desired file
      % 2/7/01 and clear global vinf and close input figure if it's open
      try 
          close(findobj('tag','input_figure'))
      end
      clear global vinf
      
      evalin('base',['clear; load ''',einf.path, strrep(einf.filename,'.mat',''),''';']);
      evalin('base','global einf');
      
      %close current window
      close(gcf)
      
      %process the data
      evalin('base','make_engine_map;');
      
      %close windows
      helpdlg('Processing complete');
      
   end
end

%Revision history
%12/16/99: vhj file created from make_ADV_file
%01/03/99: vhj added path with get mat file, min torque set to 1 (greater than zero error dialog box)
%06/16/00: vhj plot results auto checked, load mat file to set correct ranges
%06/22/00: vhj changed lhv to 42600 (insted of typo 46000)
%01/24/01: vhj updated loading of files to allow spaces in directories
% 2/7/01: ss centered figure on screen and made 'visible' 'off' during creation
% 2/7/01: ss closed input figure if it was open and cleared vinf if user processes data.  This is 
%     because engmodel uses the base workspace in such a way that advisor will not run from input figure when returned.