% J17_util.m
% A function that, when passed the distance covered on the given cycle,
% returns its utility, the fraction of daily driving that falls within
% that range.
% Data from 0 thru 30 miles is from 1995 NPTS (Table 10, p. 137 of User Guide)
% Data for 37.25 and 41 from orig J1711 (1990 NPTS?)
% Data for 54.8 from yearly VMT from 1995 NPTS
function [fraction]=j17_util(miles)
uf_tbl=[
   0	0
0.5	0.01
1	0.02
1.5	0.03
2.1	0.04
2.6	0.05
3.2	0.06
3.7	0.07
4.3	0.08
4.9	0.09
5.4	0.1
6	0.11
6.6	0.12
7.2	0.13
7.8	0.14
8.5	0.15
9.1	0.16
9.7	0.17
10.4	0.18
11	0.19
11.7	0.2
12.4	0.21
13	0.22
13.7	0.23
14.5	0.24
15.2	0.25
15.9	0.26
16.7	0.27
17.4	0.28
18.2	0.29
19	0.3
19.8	0.31
20.6	0.32
21.4	0.33
22.3	0.34
23.1	0.35
24	0.36
24.9	0.37
25.9	0.38
26.8	0.39
27.8	0.4
28.8	0.41
29.8	0.42
30.8	0.43
31.9	0.44
33	0.45
34.1	0.46
35.2	0.47
36.4	0.48
37.6	0.49
38.9	0.5
40.2	0.51
41.5	0.52
42.9	0.53
44.3	0.54
45.8	0.55
47.3	0.56
48.9	0.57
50.5	0.58
52.2	0.59
54	0.6
55.8	0.61
57.7	0.62
59.7	0.63
61.8	0.64
63.9	0.65
66.2	0.66
68.6	0.67
71.1	0.68
73.7	0.69
76.6	0.7
79.3	0.71
82.3	0.72
85.5	0.73
88.8	0.74
92.4	0.75
96.1	0.76
100	0.77
105	0.78
110	0.79
114	0.8
119	0.81
125	0.82
131	0.83
138	0.84
146	0.85
154	0.86
163	0.87
173	0.88
184	0.89
196	0.9
210	0.91
226	0.92
243	0.93
264	0.94
288	0.95
316	0.96
349	0.97
388	0.98
438	0.99
10000	0.9901];

fraction=interp1(uf_tbl(:,1),uf_tbl(:,2),miles);
