function list=GetIOParamList(InOrOut,Component,Version,Type)

switch InOrOut
case 'in'
    switch Component
    case 'dcdc'
        list={'dcconvertideal.dcconvertideal1 = key_on = '
            'dcconvertideal.dcconvertideal1 = eff = '
            'dcconvertideal.dcconvertideal1 = vminout = '
            'dcconvertideal.dcconvertideal1 = vmaxout = '
            'dcconvertideal.dcconvertideal1 = curroutmax = '
            'dcconvertideal.dcconvertideal1 = vminin = '
        };
    case 'engine'
        list={'c_pwl.engine_rpm = pwl = [...,'
            '...,'
            '...,'
            '...,'
            '...,'
            '...]'
        };
        
%     case 'engine_trq' %  this is really gc_trq_req
%         list={'c_pwl.mc_trq_req = pwl = [...,'  
%             '...,'
%             '...,'
%             '...,'
%             '...,'
%             '...]'  
%         };
        
    case 'mc'
        list={'c_pwl.maxtorqueavail = pwl = [...,'
            '...,'
            '...,'
            '...,'
            '...,'
            '...]'
            'c_pwl.mc_rpm = pwl = [...,'
            '...,'
            '...,'
            '...,'
            '...,'
            '...]'  
        };
        
    case 'motor'
        list={'induction_motor.induction_motor1 = inertia ='
            'induction_motor.induction_motor1 = rpmmax ='
            'induction_motor.induction_motor1 = maxcrrnt ='
            'induction_motor.induction_motor1 = minvolt ='
        };
            
        
    case 'gc'
        list={'generator_generic.generator_generic = vehicletype = '
            'generator_generic.generator_generic = user_imax93 = '
            'generator_generic.generator_generic = user_imax12 = '
            'generator_generic.generator_generic = cutin93 = '
            'generator_generic.generator_generic = cutin12 = '
            'generator_generic.generator_generic = geneff = '
            'generator_generic.generator_generic = tempalt = '
            'generator_generic.generator_generic = t93 = '
            'generator_generic.generator_generic = t12 = '
        };
        
    case 'gc_reg'
        list={'ind_generator.ind_generator1 = inertia = '
            'ind_generator.ind_generator1 = rpmmax = '
            'ind_generator.ind_generator1 = maxcrrnt = '
            'ind_generator.ind_generator1 = minvolt = '
        };

        
    case 'reg'
        switch Version
        case 'HiV'
            list={'regulator_42v_usa.regulator_hiv_usa1 = vehicletype = '
                'regulator_42v_usa.regulator_hiv_usa1 = vreg_adj = '
                'regulator_42v_usa.regulator_hiv_usa1 = tempreg = '
                'regulator_42v_usa.regulator_hiv_usa1 = vsetmax = '
                'regulator_42v_usa.regulator_hiv_usa1 = temp1 = '
                'regulator_42v_usa.regulator_hiv_usa1 = temp2 = '
                'regulator_42v_usa.regulator_hiv_usa1 = volt1 = '
                'regulator_42v_usa.regulator_hiv_usa1 = volt2 = '
            };
        case 'V14'
            list={'regulator_typ_14v_usa.regulator_typ_14v_usa = vehicletype = '
                'regulator_typ_14v_usa.regulator_typ_14v_usa = vreg_adj = '
                'regulator_typ_14v_usa.regulator_typ_14v_usa = tempreg = '
                'regulator_typ_14v_usa.regulator_typ_14v_usa = vsetmax = '
                'regulator_typ_14v_usa.regulator_typ_14v_usa = temp1 = '
                'regulator_typ_14v_usa.regulator_typ_14v_usa = temp2 = '
                'regulator_typ_14v_usa.regulator_typ_14v_usa = volt1 = '
                'regulator_typ_14v_usa.regulator_typ_14v_usa = volt2 = '
            };
        end
    case 'ess'
        switch Version
        case 'rint'
            list={'r_int_battery.r_int_battery_1 = ess_maxvolts = '
                'r_int_battery.r_int_battery_1 = ess_modnum = '
                'r_int_battery.r_int_battery_1 = ess_minvolts = '
                'r_int_battery.r_int_battery_1 = ess_initsoc = '
            };
        case 'Saber pb'
            list={'batt_pb_1.battery_1 = sg0 = '
                'batt_pb_1.battery_1 = model = model(batt_pb_1.battery_1)<-(ah_nom = ...,'
                'inom = ...,'
                'rnom = ...,'
                'sg_full = ...,'
                'sg_disc = ...,'
                'fah_thi = ...,'
                'fc = ...,'
                'fah_max = ...,'
                'self_disc = ...,'
                'n_cell = ...,'
                'v_flt = ...)'
            };
        end
    case 'ess2'
        switch Version
        case 'rint'
            list={'r_int_battery.r_int_battery_2 = ess_maxvolts = '
                'r_int_battery.r_int_battery_2 = ess_modnum = '
                'r_int_battery.r_int_battery_2 = ess_minvolts = '
                'r_int_battery.r_int_battery_2 = ess_initsoc = '
            };
        case 'Saber pb'
            list={'batt_pb_1.battery_2 = sg0 = '
                'batt_pb_1.battery_2 = model = model(batt_pb_1.battery_2)<-(ah_nom = ...,'
                'inom = ...,'
                'rnom = ...,'
                'sg_full = ...,'
                'sg_disc = ...,'
                'fah_thi = ...,'
                'fc = ...,'
                'fah_max = ...,'
                'self_disc = ...,'
                'n_cell = ...,'
                'v_flt = ...)'
            };
        end
    case 'AuxLoads'
        switch Version
        case 'V14'
            list={'rear_defrost.rear_defrost1 = vehicletype = '
                'rear_defrost.rear_defrost1 = user_v1 = '
                'rear_defrost.rear_defrost1 = user_v2 = '
                'rear_defrost.rear_defrost1 = user_v3 = '
                'rear_defrost.rear_defrost1 = user_i1 = '
                'rear_defrost.rear_defrost1 = user_i2 = '
                'rear_defrost.rear_defrost1 = user_i3 = '
                'rear_defrost.rear_defrost1 = loadcontrol = '
                'heated_seat.heated_seat1 = vehicletype = '
                'heated_seat.heated_seat1 = user_v1 = '
                'heated_seat.heated_seat1 = user_v2 = '
                'heated_seat.heated_seat1 = user_v3 = '
                'heated_seat.heated_seat1 = user_i1 = '
                'heated_seat.heated_seat1 = user_i2 = '
                'heated_seat.heated_seat1 = user_i3 = '
                'heated_seat.heated_seat1 = loadchoice = '
                'heated_seat.heated_seat1 = loadcontrol = '
                'radio.radio1 = vehicletype = '
                'radio.radio1 = user_v1 = '
                'radio.radio1 = user_v2 = '
                'radio.radio1 = user_v3 = '
                'radio.radio1 = user_i1 = '
                'radio.radio1 = user_i2 = '
                'radio.radio1 = user_i3 = '
                'radio.radio1 = loadcontrol = '
                'rear_wiper.rear_wiper1 = vehicletype = '
                'rear_wiper.rear_wiper1 = user_v1 = '
                'rear_wiper.rear_wiper1 = user_v2 = '
                'rear_wiper.rear_wiper1 = user_v3 = '
                'rear_wiper.rear_wiper1 = user_i1 = '
                'rear_wiper.rear_wiper1 = user_i2 = '
                'rear_wiper.rear_wiper1 = user_i3 = '
                'rear_wiper.rear_wiper1 = loadcontrol = '
                'front_wiper.front_wiper1 = vehicletype = '
                'front_wiper.front_wiper1 = user_v1 = '
                'front_wiper.front_wiper1 = user_v2 = '
                'front_wiper.front_wiper1 = user_v3 = '
                'front_wiper.front_wiper1 = user_i1 = '
                'front_wiper.front_wiper1 = user_i2 = '
                'front_wiper.front_wiper1 = user_i3 = '
                'front_wiper.front_wiper1 = loadcontrol = '
                'turn_signal.turn_signal1 = vehicletype = '
                'turn_signal.turn_signal1 = user_v1 = '
                'turn_signal.turn_signal1 = user_v2 = '
                'turn_signal.turn_signal1 = user_v3 = '
                'turn_signal.turn_signal1 = user_i1 = '
                'turn_signal.turn_signal1 = user_i2 = '
                'turn_signal.turn_signal1 = user_i3 = '
                'turn_signal.turn_signal1 = loadcontrol = '
                'misc.misc1 = vehicletype = '
                'misc.misc1 = user_v1 = '
                'misc.misc1 = user_v2 = '
                'misc.misc1 = user_v3 = '
                'misc.misc1 = user_i1 = '
                'misc.misc1 = user_i2 = '
                'misc.misc1 = user_i3 = '
                'misc.misc1 = loadcontrol = '
                'front_hvac.front_hvac1 = vehicletype = '
                'front_hvac.front_hvac1 = user_v1 = '
                'front_hvac.front_hvac1 = user_v2 = '
                'front_hvac.front_hvac1 = user_v3 = '
                'front_hvac.front_hvac1 = user_i1 = '
                'front_hvac.front_hvac1 = user_i2 = '
                'front_hvac.front_hvac1 = user_i3 = '
                'front_hvac.front_hvac1 = loadchoice = '
                'front_hvac.front_hvac1 = loadcontrol = '
                'rear_hvac.rear_hvac1 = vehicletype = '
                'rear_hvac.rear_hvac1 = user_v1 = '
                'rear_hvac.rear_hvac1 = user_v2 = '
                'rear_hvac.rear_hvac1 = user_v3 = '
                'rear_hvac.rear_hvac1 = user_i1 = '
                'rear_hvac.rear_hvac1 = user_i2 = '
                'rear_hvac.rear_hvac1 = user_i3 = '
                'rear_hvac.rear_hvac1 = loadchoice = '
                'rear_hvac.rear_hvac1 = loadcontrol = '
                'engine.engine1 = vehicletype = '
                'engine.engine1 = user_v1 = '
                'engine.engine1 = user_v2 = '
                'engine.engine1 = user_v3 = '
                'engine.engine1 = user_i1 = '
                'engine.engine1 = user_i2 = '
                'engine.engine1 = user_i3 = '
                'engine.engine1 = loadcontrol = '
                'external_lights.external_lights1 = vehicletype = '
                'external_lights.external_lights1 = user_v1 = '
                'external_lights.external_lights1 = user_v2 = '
                'external_lights.external_lights1 = user_v3 = '
                'external_lights.external_lights1 = user_i1 = '
                'external_lights.external_lights1 = user_i2 = '
                'external_lights.external_lights1 = user_i3 = '
                'external_lights.external_lights1 = loadchoice = '
                'external_lights.external_lights1 = loadcontrol = '
                'radiator_fan.radiator_fan1 = vehicletype = '
                'radiator_fan.radiator_fan1 = user_v1 = '
                'radiator_fan.radiator_fan1 = user_v2 = '
                'radiator_fan.radiator_fan1 = user_v3 = '
                'radiator_fan.radiator_fan1 = user_i1 = '
                'radiator_fan.radiator_fan1 = user_i2 = '
                'radiator_fan.radiator_fan1 = user_i3 = '
                'radiator_fan.radiator_fan1 = loadchoice = '
                'radiator_fan.radiator_fan1 = loadcontrol = '
                'brake_lights.brake_lights1 = vehicletype = '
                'brake_lights.brake_lights1 = user_v1 = '
                'brake_lights.brake_lights1 = user_v2 = '
                'brake_lights.brake_lights1 = user_v3 = '
                'brake_lights.brake_lights1 = user_i1 = '
                'brake_lights.brake_lights1 = user_i2 = '
                'brake_lights.brake_lights1 = user_i3 = '
                'brake_lights.brake_lights1 = loadcontrol = '
                'starter.starter_trad = startlength = '
                'starter.starter_trad = start_power = '
                'starter.starter_trad = loadcontrol = '
            };
        case 'HiV'
            list={'load_user_defined_42v.load_user_defined_hiv = user_v1 = '
                'load_user_defined_42v.load_user_defined_hiv = user_v2 = '
                'load_user_defined_42v.load_user_defined_hiv = user_v3 = '
                'load_user_defined_42v.load_user_defined_hiv = user_i1 = '
                'load_user_defined_42v.load_user_defined_hiv = user_i2 = '
                'load_user_defined_42v.load_user_defined_hiv = user_i3 = '
                'load_user_defined_42v.load_user_defined_hiv = loadcontrol = '
                'power_load.user_power1_hiv = power_load = '
                'power_load.user_power1_hiv = loadcontrol = '
                'power_load.user_power2_hiv = power_load = '
                'power_load.user_power2_hiv = loadcontrol = '
                'power_load.user_power3_hiv = power_load = '
                'power_load.user_power3_hiv = loadcontrol = '
                'load_speed_42v.load_speed_hiv = user_rpm1 = '
                'load_speed_42v.load_speed_hiv = user_rpm2 = '
                'load_speed_42v.load_speed_hiv = user_pwr1 = '
                'load_speed_42v.load_speed_hiv = user_pwr2 = '
                'load_speed_42v.load_speed_hiv = loadcontrol = '
                'starter.starter_hiv = startlength = '
                'starter.starter_hiv = start_power = '
                'starter.starter_hiv = loadcontrol = '
            };
        end        
    end
    
    
    
    
case 'out'
    switch Component
    case 'ess'
        switch Version
        case 'Saber pb'
            list={'power(power_meter.pm_battery_1)'
                'battery_1_voltage'
                'soc(batt_pb_1.battery_1)'
                'soc(batt_pb_1.battery_1)'  % dummy input for config subsystem to work
            };
        case 'rint'
            list={'power(power_meter.pm_battery_1)'
                'battery_1_voltage'
                'soc(r_int_battery.r_int_battery_1)'
                'max_ess_chg_pwr(r_int_battery.r_int_battery_1)'
            };
        end
        
    case 'ess2'
        switch Version
        case 'Saber pb'
            list={'power(power_meter.pm_battery_2)'
                'battery_2_voltage'
                'soc(batt_pb_1.battery_2)'
                'soc(batt_pb_1.battery_2)'  % dummy input for config subsystem to work
            };
        case 'rint'
            list={'power(power_meter.pm_battery_2)'
                'battery_2_voltage'
                'soc(r_int_battery.r_int_battery_2)'
                'max_ess_chg_pwr(r_int_battery.r_int_battery_2)'
            };
        end
        
    case 'mc'
        list={'speed(induction_motor.induction_motor1)'
            'torquereq(induction_motor.induction_motor1)'
            'current(power_meter.motor)'
            'mc_v'
        };
        
    case 'gc'
        list={'torquereq(generator_generic.generator_generic)'  % 8/20/02 changed from 'mech_pwr(generator_generic.generator_generic)'
            'gen_v'
            'power(power_meter.generator)'
            'speed(generator_generic.generator_generic)'
        };
        
    case 'gc_ind' 
        list={'torquereq(ind_generator.ind_generator1)'
            'gen_v'
            'power(power_meter.gen)'
            'speed(ind_generator.ind_generator1)'
        };
        
    case 'dcdc'
        list={'iin(dcconvertideal.dcconvertideal1)'
            'iout(dcconvertideal.dcconvertideal1)'
        };
        
    case 'AuxLoads'
        switch Version
        case 'V14'
            list={'power(power_meter.loads_trad)'
                'current(power_meter.loads_trad)'
                'p_engine(engine.engine1)'
                'i(engine.engine1)'
                'p_radiator_fan(radiator_fan.radiator_fan1)'
                'i(radiator_fan.radiator_fan1)'
                'p_misc(misc.misc1)'
                'i(misc.misc1)'
                'p_brake_lights(brake_lights.brake_lights1)'
                'i(brake_lights.brake_lights1)'
                'p_turn_signal(turn_signal.turn_signal1)'
                'i(turn_signal.turn_signal1)'
                'p_external_lights(external_lights.external_lights1)'
                'i(external_lights.external_lights1)'
                'p_front_wiper(front_wiper.front_wiper1)'
                'i(front_wiper.front_wiper1)'
                'p_rear_wiper(rear_wiper.rear_wiper1)'
                'i(rear_wiper.rear_wiper1)'
                'p_rear_defrost(rear_defrost.rear_defrost1)'
                'i(rear_defrost.rear_defrost1)'
                'p_front_hvac(front_hvac.front_hvac1)'
                'i(front_hvac.front_hvac1)'
                'p_rear_hvac(rear_hvac.rear_hvac1)'
                'i(rear_hvac.rear_hvac1)'
                'p_heated_seat(heated_seat.heated_seat1)'
                'i(heated_seat.heated_seat1)'
                'p_radio(radio.radio1)'
                'i(radio.radio1)'
                'pwr(starter.starter_trad)'
                'i(starter.starter_trad)'
            };
            
        case 'HiV'
            list={'power(power_meter.loads_hiv)'
                'current(power_meter.loads_hiv)'
                'p_load_speed_42v(load_speed_42v.load_speed_hiv)'
                'i(load_speed_42v.load_speed_hiv)'
                'pwr(power_load.user_power1_hiv)'
                'i(power_load.user_power1_hiv)'
                'pwr(power_load.user_power2_hiv)'
                'i(power_load.user_power2_hiv)'
                'pwr(power_load.user_power3_hiv)'
                'i(power_load.user_power3_hiv)'
                'pwr(starter.starter_hiv)'
                'i(starter.starter_hiv)'
            };
            
        end
        
    end
end

