function cs_setup(option)

%
% GUI interface to setup control strategy optimization
%

global vinf

if nargin<1
   option='load';
end

switch option
   
case 'load'
   
   button=questdlg('This functionality has been greatly enhanced by using the adv_no_gui scripts combined with optimization tools.  Please refer to documentation (file:\\C:\ADVISOR\documentation\optimization_scripts.html) for more information.  Would you like to continue?','Control Strategy Optimization Updates','Yes','No','Help','No');
   if strcmp(button,'Help')
       load_in_browser('optimization_scripts.html');
       return
   elseif ~strcmp(button,'Yes')
       return
   end
  
   figure_color=[1 1 .8];
   
   screen=get(0,'screensize');
   if screen>=[1 1 1024 768]
      posfig=[(screen(3)-700)/2 (screen(4)-500)/2 700 500];
      line_height=18;
   else
      posfig=[(screen(3)-700)/2 (screen(4)-500)/2-25 700 500];
      line_height=18;
   end
   
   par_left=posfig(1);
   par_bottom=posfig(2);
   par_width=posfig(3);
   par_height=posfig(4)+15;
   char_width=10;
   border=2*char_width;
   button_width=60;
   button_height=line_height+2;
   editbox_width=60;
   editbox_height=line_height;
   line_num=1;
   
   h0 = figure('Color',figure_color, ...
      'Position',posfig, ...
      'numbertitle','off',...
      'name','Control Strategy Optimization Setup Window',...
      'windowstyle','modal');
   
   %set up the defaults if not already set.
   eval('h=vinf.control_strategy; test4exist=1;','test4exist=0;');
   clear h
   if ~test4exist
      if evalin('base','exist(''fc_map_spd'')')
         fc_max_pwr=evalin('base','max(fc_max_trq.*fc_map_spd)');
      elseif evalin('base','exist(''fc_pwr_map'')')
         fc_max_pwr=evalin('base','max(fc_pwr_map)');
      end
      if strcmp(vinf.drivetrain.name,'series')|strcmp(vinf.drivetrain.name,'fuel_cell')
         vinf.control_strategy.dv.name={...
               'cs_lo_soc';...
               'cs_hi_soc';...
               'cs_charge_pwr';...
               'cs_min_pwr';...
               'cs_max_pwr';...
               'cs_max_pwr_rise_rate';...
               'cs_max_pwr_fall_rate';...
               'cs_min_off_time';...
               'cs_fc_init_state';...
            };
         vinf.control_strategy.dv.units={'(--)','(--)','(W)','(W)','(W)','(W/s)','(W/s)','(s)','(boolean)'};
         vinf.control_strategy.dv.lower_bound=[0.1 0.55 1000 1000 0.5*fc_max_pwr 1 -5000 0 0];
         vinf.control_strategy.dv.upper_bound=[0.5 1.0 0.5*fc_max_pwr 0.5*fc_max_pwr fc_max_pwr 5000 -1 200 1];
         vinf.control_strategy.dv.first_points=ones(size(vinf.control_strategy.dv.name))*4;
         vinf.control_strategy.dv.second_points=ones(size(vinf.control_strategy.dv.name))*3;
         vinf.control_strategy.dv.first_points(end)=1;
         vinf.control_strategy.dv.second_points(end)=1;
         vinf.control_strategy.dv.active=ones(size(vinf.control_strategy.dv.name));
      elseif strcmp(vinf.drivetrain.name,'parallel')|strcmp(vinf.drivetrain.name,'parallel_sa')
         vinf.control_strategy.dv.name={...
               'cs_lo_soc';...
               'cs_hi_soc';...
               'cs_charge_trq';...
               'cs_min_trq_frac';...
               'cs_off_trq_frac';...
               'cs_electric_launch_spd_lo';...
               'cs_electric_launch_spd_hi';...
               'cs_charge_deplete_bool';...
            };
         vinf.control_strategy.dv.units={'(--)','(--)','(Nm)','(--)','(--)','(m/s)','(m/s)','(--)'};
         vinf.control_strategy.dv.lower_bound=[0.1 0.55 1 0.05 0.05 0 10 0];
         vinf.control_strategy.dv.upper_bound=[0.5 1.0 evalin('base','max(fc_max_trq)') 1 1 15 30 1];
         vinf.control_strategy.dv.first_points=ones(size(vinf.control_strategy.dv.name))*4;
         vinf.control_strategy.dv.second_points=ones(size(vinf.control_strategy.dv.name))*3;
         vinf.control_strategy.dv.first_points(end)=1;
         vinf.control_strategy.dv.second_points(end)=1;
			vinf.control_strategy.dv.active=ones(size(vinf.control_strategy.dv.name));
      end
      vinf.control_strategy.test.name='TEST_CITY_HWY';
      vinf.control_strategy.cycle.name='CYC_UDDS';
      vinf.control_strategy.cycle.run=1;
      vinf.control_strategy.matlab=0;
      vinf.control_strategy.obj.name={'co','hc','nox','pm','fuel_economy'};
      vinf.control_strategy.obj.active=[1 1 1 1 1];
      vinf.control_strategy.obj.weight=ones(size(vinf.control_strategy.obj.active));
      vinf.control_strategy.con.value=[1.7 0.125 0.4 0.08 80]; % Tier II emissions, 80 mpg
   end
   vinf.control_strategy.doe.run=1; % run a new design of experiments
   if strcmp(vinf.units,'metric')
      vinf.control_strategy.obj.msg={...
            'CO Emissions (Minimize,g/km)',...
            'HC Emissions (Minimize,g/km)',...
            'NOx Emissions (Minimize,g/km)',...
            'PM Emissions (Minimize,g/km)',...
            'Fuel Cons. (Minimize,l/100km)'};
   else
      vinf.control_strategy.obj.msg={...
            'CO Emissions (Minimize,g/mi)',...
            'HC Emissions (Minimize,g/mi)',...
            'NOx Emissions (Minimize,g/mi)',...
            'PM Emissions (Minimize,g/mi)',...
            'Fuel Economy (Maximize,mpg)'};
   end
   for i=1:length(vinf.control_strategy.dv.name)
      vinf.control_strategy.dv.init_cond(i)=evalin('base',vinf.control_strategy.dv.name{i});
   end
   
   % Engine selection section title
   line_num=line_num+1;
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figure_color, ...
      'Position',[border par_height-line_num*line_height par_width-2*border line_height], ...
      'String','Control Strategy Optimization Method Selection', ...
      'Fontweight','bold',...
      'Style','text');
   % Engine selection radio buttons
   line_num=line_num+1;
   h1 = uicontrol('Parent',h0, ...
      'Callback','cs_setup(''matlab'')',...
      'BackgroundColor',figure_color, ...
      'Position',[border par_height-line_num*line_height par_width/2 line_height], ...
      'String','Optimize using Matlab',...
      'Style','radiobutton', ...
      'Tag','matlab_radiobutton',...
      'Value',vinf.control_strategy.matlab);
   h1 = uicontrol('Parent',h0, ...
      'Callback','cs_setup(''visdoc'')',...
      'BackgroundColor',figure_color, ...
      'Position',[par_width/2 par_height-line_num*line_height par_width/2 line_height], ...
      'String','Optimize using VisualDOC',...
      'Style','radiobutton', ...
      'Tag','visdoc_radiobutton',...
      'Value',~vinf.control_strategy.matlab);
   
   line_num=line_num+1;
   
   % Procedure selection section title
   line_num=line_num+1;
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figure_color, ...
      'Position',[border par_height-line_num*line_height par_width-2*border line_height], ...
      'String','Cycle/Test Procedure Selection', ...
      'Fontweight','bold',...
      'Style','text');
   % cycle menu
   line_num=line_num+1;
   h1 = uicontrol('Parent',h0, ...
      'callback','cs_setup(''drive_cycle'')',...
      'BackgroundColor',figure_color, ...
      'Position',[border par_height-line_num*line_height 10*char_width line_height], ...
      'HorizontalAlignment','left',...
      'String','Drive Cycle', ...
      'Fontweight','normal',...
      'Style','radiobutton',...
      'Tag','drive_cycle_radiobutton', ...
      'value',vinf.control_strategy.cycle.run);
   h1 = uicontrol('Parent',h0, ...
      'FontSize',8, ...
      'Position',[border+10*char_width par_height-line_num*line_height 12*char_width line_height], ...
      'String',optionlist('get','cycles'), ...
      'Style','popupmenu', ...
      'Tag','drive_cycle', ...
      'enable','on',...
      'Value',1);
   
   %%%%% -----
   % maybe able to move this to the case statements at the end later
   if vinf.control_strategy.cycle.run 
      set(findobj('Tag','drive_cycle'),'enable','on')
      set(findobj('Tag','drive_cycle'),'value',optionlist('value','cycles',vinf.control_strategy.cycle.name))
   else       
      set(findobj('Tag','drive_cycle'),'enable','off')
      set(findobj('Tag','drive_cycle'),'value',1)
   end
   %%%%% -----
   
   % test procedure menu
   h1 = uicontrol('Parent',h0, ...
      'callback','cs_setup(''test_procedure'')',...
      'BackgroundColor',figure_color, ...
      'Position',[par_width/2 par_height-line_num*line_height 10*char_width line_height], ...
      'HorizontalAlignment','left',...
      'String','Test Procedure', ...
      'Fontweight','normal',...
      'Style','radiobutton',...
      'Tag','test_procedure_radiobutton', ...
      'value',~vinf.control_strategy.cycle.run);
   h1 = uicontrol('Parent',h0, ...
      'FontSize',8, ...
      'Position',[par_width/2+10*char_width par_height-line_num*line_height 12*char_width line_height], ...
      'String',optionlist('get','test_procedures'), ...
      'Style','popupmenu', ...
      'Tag','test_procedure', ...
      'enable','off',...
      'Value',1);
   
   %%%%% -----
   % maybe able to move this to the case statements at the end later
   if ~vinf.control_strategy.cycle.run 
      set(findobj('Tag','test_procedure'),'enable','on')
      set(findobj('Tag','test_procedure'),'value',optionlist('value','test_procedures',vinf.control_strategy.test.name))
   else       
      set(findobj('Tag','test_procedure'),'enable','off')
      set(findobj('Tag','test_procedure'),'value',1)
   end
   %%%%% -----
   
   line_num=line_num+1;
   
   % Design variables section title
   line_num=line_num+1;
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figure_color, ...
      'Position',[border par_height-line_num*line_height par_width-2*border line_height], ...
      'String','Design Variables', ...
      'Fontweight','bold',...
      'Style','text');
   % variable header
   line_num=line_num+1;
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figure_color, ...
      'Position',[border par_height-line_num*line_height 13*char_width line_height], ...
      'String','Variable Name', ...
      'Style','text');
   % units header
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figure_color, ...
      'Position',[border+15*char_width par_height-line_num*line_height 3*char_width line_height], ...
      'String','Units', ...
      'Style','text');
   % initial condition header
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figure_color, ...
      'Position',[border+18*char_width par_height-line_num*line_height 10*char_width line_height], ...
      'String','Initial Condition', ...
      'Style','text');
   % lower bound header
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figure_color, ...
      'Position',[border+28*char_width par_height-line_num*line_height 10*char_width line_height], ...
      'String','Lower Bound', ...
      'Style','text');
   % upper bound header
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figure_color, ...
      'Position',[border+38*char_width par_height-line_num*line_height 10*char_width line_height], ...
      'String','Upper Bound', ...
      'Style','text');
   % 1st points header
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figure_color, ...
      'Position',[border+48*char_width par_height-line_num*line_height 10*char_width line_height], ...
      'String','# Points 1st Sweep', ...
      'Style','text');
   % 2nd points header
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figure_color, ...
      'Position',[border+58*char_width par_height-line_num*line_height 10*char_width line_height], ...
      'String','# Points 2nd Sweep', ...
      'Style','text');
   
   if vinf.control_strategy.matlab
      str='on';
   else
      str='off';
   end
   
   for i=1:length(vinf.control_strategy.dv.name)
      line_num=line_num+1;
      %check box
      h1 = uicontrol('Parent',h0, ...
         'BackgroundColor',figure_color, ...
         'Position',[border par_height-line_num*line_height 15*char_width line_height], ...
         'String',vinf.control_strategy.dv.name{i}, ...
         'Style','checkbox', ...
         'value',vinf.control_strategy.dv.active(i), ...
         'Tag',[vinf.control_strategy.dv.name{i},'_checkbox']);
      % units
      h1 = uicontrol('Parent',h0, ...
         'BackgroundColor',figure_color, ...
         'Position',[border+15*char_width par_height-line_num*line_height 3*char_width line_height], ...
         'String',vinf.control_strategy.dv.units{i},...
         'Style','text');
      % initial condition
      h1 = uicontrol('Parent',h0, ...
         'BackgroundColor',[1 1 1], ...
         'Position',[border+20*char_width par_height-line_num*line_height editbox_width line_height], ...
         'String',num2str(vinf.control_strategy.dv.init_cond(i)),...
         'Style','edit', ...
         'enable','on', ...
         'Tag',[vinf.control_strategy.dv.name{i},'_init']);
      % lower bound
      h1 = uicontrol('Parent',h0, ...
         'BackgroundColor',[1 1 1], ...
         'Position',[border+30*char_width par_height-line_num*line_height editbox_width line_height], ...
         'String',num2str(vinf.control_strategy.dv.lower_bound(i)),...
         'Style','edit', ...
         'enable','on', ...
         'Tag',[vinf.control_strategy.dv.name{i},'_lb']);
      % upper bound
      h1 = uicontrol('Parent',h0, ...
         'BackgroundColor',[1 1 1], ...
         'Position',[border+40*char_width par_height-line_num*line_height editbox_width line_height], ...
         'String',num2str(vinf.control_strategy.dv.upper_bound(i)),...
         'Style','edit', ...
         'enable','on', ...
         'Tag',[vinf.control_strategy.dv.name{i},'_ub']);
      % # points 1st sweep
      h1 = uicontrol('Parent',h0, ...
         'BackgroundColor',[1 1 1], ...
         'Position',[border+50*char_width par_height-line_num*line_height editbox_width line_height], ...
         'String',num2str(vinf.control_strategy.dv.first_points(i)),...
         'Style','edit', ...
         'enable',str, ...
         'Tag',[vinf.control_strategy.dv.name{i},'_pts1']);
      % # points 2nd sweep
      h1 = uicontrol('Parent',h0, ...
         'BackgroundColor',[1 1 1], ...
         'Position',[border+60*char_width par_height-line_num*line_height editbox_width line_height], ...
         'String',num2str(vinf.control_strategy.dv.second_points(i)),...
         'Style','edit', ...
         'enable',str, ...
         'Tag',[vinf.control_strategy.dv.name{i},'_pts2']);
   end
   
   line_num=line_num+1;
   
   % Objectives section title
   line_num=line_num+1;
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figure_color, ...
      'Position',[border par_height-line_num*line_height par_width/2-2*border line_height], ...
      'String','Objectives/Constraints', ...
      'Fontweight','bold',...
      'Style','text');
   % obj/con radio button header
   line_num=line_num+1;
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figure_color, ...
      'Position',[border par_height-line_num*line_height 6*char_width line_height], ...
      'String','OBJ  CON' , ...
      'Style','text');
   % weight factor header
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figure_color, ...
      'Position',[border+15*char_width par_height-line_num*line_height 15*char_width line_height], ...
      'String','Weighting Factor (0-1)' , ...
      'Style','text');
   % constraint header
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figure_color, ...
      'Position',[border+30*char_width par_height-line_num*line_height 6*char_width line_height], ...
      'String','Value' , ...
      'Style','text');
   % Objectives - checkboxes and editboxes
   for i=1:length(vinf.control_strategy.obj.active) 
      line_num=line_num+1;
      % objective radiobutton
      h1 = uicontrol('Parent',h0, ...
         'BackgroundColor',figure_color, ...
         'callback',['h=get(findobj(''Tag'',[''obj_',vinf.control_strategy.obj.name{i},'_radiobutton'']),''value''); if h set(findobj(''Tag'',[''con_',vinf.control_strategy.obj.name{i},'_radiobutton'']),''value'',0); set(findobj(''Tag'',[''con_',vinf.control_strategy.obj.name{i},'_value'']),''enable'',''off''); set(findobj(''Tag'',[''obj_',vinf.control_strategy.obj.name{i},'_weight'']),''enable'',''on''); else set(findobj(''Tag'',[''con_',vinf.control_strategy.obj.name{i},'_radiobutton'']),''value'',1); set(findobj(''Tag'',[''con_',vinf.control_strategy.obj.name{i},'_value'']),''enable'',''on''); set(findobj(''Tag'',[''obj_',vinf.control_strategy.obj.name{i},'_weight'']),''enable'',''off''); end;'], ...
         'Position',[border+1*char_width par_height-line_num*line_height par_width-2*border line_height], ...
         'String','', ...
         'Style','radiobutton', ...
         'Tag',['obj_',vinf.control_strategy.obj.name{i},'_radiobutton'], ...
         'Value',vinf.control_strategy.obj.active(i));
      % constraint radiobutton
      h1 = uicontrol('Parent',h0, ...
         'BackgroundColor',figure_color, ...
         'callback',['h=get(findobj(''Tag'',[''con_',vinf.control_strategy.obj.name{i},'_radiobutton'']),''value''); if h set(findobj(''Tag'',[''obj_',vinf.control_strategy.obj.name{i},'_radiobutton'']),''value'',0); set(findobj(''Tag'',[''obj_',vinf.control_strategy.obj.name{i},'_weight'']),''enable'',''off''); set(findobj(''Tag'',[''con_',vinf.control_strategy.obj.name{i},'_value'']),''enable'',''on''); else set(findobj(''Tag'',[''obj_',vinf.control_strategy.obj.name{i},'_radiobutton'']),''value'',1); set(findobj(''Tag'',[''obj_',vinf.control_strategy.obj.name{i},'_weight'']),''enable'',''on''); set(findobj(''Tag'',[''con_',vinf.control_strategy.obj.name{i},'_value'']),''enable'',''off''); end;'], ...
         'Position',[border+3*char_width par_height-line_num*line_height par_width-2*border line_height], ...
         'String',vinf.control_strategy.obj.msg{i}, ...
         'Style','radiobutton', ...
         'Tag',['con_',vinf.control_strategy.obj.name{i},'_radiobutton'], ...
         'Value',~vinf.control_strategy.obj.active(i));
      % objective weight editbox
      if vinf.control_strategy.obj.active(i)
         str='on';
      else
         str='off';
      end
      h1 = uicontrol('Parent',h0, ...
         'BackgroundColor',[1 1 1], ...
         'Position',[border+20*char_width par_height-line_num*line_height editbox_width line_height], ...
         'String',num2str(vinf.control_strategy.obj.weight(i)),...
         'Style','edit', ...
         'enable',str, ...
         'Tag',['obj_',vinf.control_strategy.obj.name{i},'_weight']);
      % constraint editbox
      if ~vinf.control_strategy.obj.active(i)
         str='on';
      else
         str='off';
      end
      if i==5
         if strcmp(vinf.units,'metric')
            val=(1/(vinf.control_strategy.con.value(i)*units('mpg2kmpl'))*100);
         else
            val=vinf.control_strategy.con.value(i);
         end
      else
         val=(vinf.control_strategy.con.value(i)*units('gpm2gpkm'));
      end
      h1 = uicontrol('Parent',h0, ...
         'BackgroundColor',[1 1 1], ...
         'Position',[border+30*char_width par_height-line_num*line_height editbox_width line_height], ...
         'String',num2str(val),...
         'Style','edit', ...
         'enable',str, ...
         'Tag',['con_',vinf.control_strategy.obj.name{i},'_value']);
   end
   
   % visdoc parameters section title
   line_num=line_num-length(vinf.control_strategy.obj.active)-1;
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figure_color, ...
      'Position',[border+par_width/2 par_height-line_num*line_height par_width/2-2*border line_height], ...
      'String','VisualDOC Parameters', ...
      'Fontweight','bold',...
      'Style','text');
   %%%%%
   %% add vdoc parameter inputs here
   line_num=line_num+length(vinf.control_strategy.obj.active)+1; % make sure line numbers align
   %%%%%
   
   line_num=line_num+1;
   
   %run button
   h1 = uicontrol('Parent',h0, ...
      'CallBack','cs_setup(''run'')',...
      'Position',[(par_width-4*button_width)/5 10 button_width button_height], ...
      'String','RUN', ...
      'Tag','Pushbutton1');
   
   %defaults button
   h1 = uicontrol('Parent',h0, ...
      'CallBack','cs_setup(''defaults'')',...
      'Position',[2*(par_width-4*button_width)/5+1*button_width 10 button_width button_height], ...
      'String','DEFAULTS', ...
      'Tag','Pushbutton2');
   
   %cancel button
   h1 = uicontrol('Parent',h0, ...
      'CallBack','cs_setup(''cancel'')',...
      'Position',[3*(par_width-4*button_width)/5+2*button_width 10 button_width button_height], ...
      'String','CANCEL', ...
      'Tag','Pushbutton3');
   
   %help button
   h1 = uicontrol('Parent',h0, ...
      'CallBack','load_in_browser(''cs_opt_help.html'');',...
      'Position',[4*(par_width-4*button_width)/5+3*button_width 10 button_width button_height], ...
      'String','HELP', ...
      'Tag','Pushbutton4');
   
   % check for previous doe run data
   eval('vinf.control_strategy.cv; test4exist=1;','test4exist=0;')
   if test4exist
      button=questdlg('The data set from a previous Design of Experiments run was found in the Matlab workspace.  Do you want to reuse this data or generate a new data set?','Run DOE Prompt','Reuse Data Set','Generate New Data Set','Reuse Data Set');
      if strcmp(button,'Reuse Data Set')
         vinf.control_strategy.doe.run=0;
         cs_setup('skip_doe')
      else
         vinf.control_strategy.doe.run=1;
         vinf.control_strategy=rmfield(vinf.control_strategy,'cv');
         vinf.control_strategy=rmfield(vinf.control_strategy,'cr');
         cs_setup('run_doe')
      end
   end
   
   if get(findobj('tag','matlab_radiobutton'),'value')
      cs_setup('matlab')
   end
   
   cs_setup('emissions')
   
case 'emissions'
   if ~evalin('base','nnz(fc_co_map)')
      set(findobj('tag',['obj_',vinf.control_strategy.obj.name{1},'_radiobutton']),'value',0)
      set(findobj('tag',['con_',vinf.control_strategy.obj.name{1},'_radiobutton']),'value',1)
      set(findobj('tag',['obj_',vinf.control_strategy.obj.name{1},'_radiobutton']),'enable','off')
      set(findobj('tag',['con_',vinf.control_strategy.obj.name{1},'_radiobutton']),'enable','off')
      set(findobj('tag',['obj_',vinf.control_strategy.obj.name{1},'_weight']),'value',0)
      set(findobj('tag',['con_',vinf.control_strategy.obj.name{1},'_value']),'string','-1')
      set(findobj('tag',['obj_',vinf.control_strategy.obj.name{1},'_weight']),'enable','off')
      set(findobj('tag',['con_',vinf.control_strategy.obj.name{1},'_value']),'enable','off')
   end
   if ~evalin('base','nnz(fc_hc_map)')
      set(findobj('tag',['obj_',vinf.control_strategy.obj.name{2},'_radiobutton']),'value',0)
      set(findobj('tag',['con_',vinf.control_strategy.obj.name{2},'_radiobutton']),'value',1)
      set(findobj('tag',['obj_',vinf.control_strategy.obj.name{2},'_radiobutton']),'enable','off')
      set(findobj('tag',['con_',vinf.control_strategy.obj.name{2},'_radiobutton']),'enable','off')
      set(findobj('tag',['obj_',vinf.control_strategy.obj.name{2},'_weight']),'value',0)
      set(findobj('tag',['con_',vinf.control_strategy.obj.name{2},'_value']),'string','-1')
      set(findobj('tag',['obj_',vinf.control_strategy.obj.name{2},'_weight']),'enable','off')
      set(findobj('tag',['con_',vinf.control_strategy.obj.name{2},'_value']),'enable','off')
   end
   if ~evalin('base','nnz(fc_nox_map)')
      set(findobj('tag',['obj_',vinf.control_strategy.obj.name{3},'_radiobutton']),'value',0)
      set(findobj('tag',['con_',vinf.control_strategy.obj.name{3},'_radiobutton']),'value',1)
      set(findobj('tag',['obj_',vinf.control_strategy.obj.name{3},'_radiobutton']),'enable','off')
      set(findobj('tag',['con_',vinf.control_strategy.obj.name{3},'_radiobutton']),'enable','off')
      set(findobj('tag',['obj_',vinf.control_strategy.obj.name{3},'_weight']),'value',0)
      set(findobj('tag',['con_',vinf.control_strategy.obj.name{3},'_value']),'string','-1')
      set(findobj('tag',['obj_',vinf.control_strategy.obj.name{3},'_weight']),'enable','off')
      set(findobj('tag',['con_',vinf.control_strategy.obj.name{3},'_value']),'enable','off')
   end
   if ~evalin('base','nnz(fc_pm_map)')
      set(findobj('tag',['obj_',vinf.control_strategy.obj.name{4},'_radiobutton']),'value',0)
      set(findobj('tag',['con_',vinf.control_strategy.obj.name{4},'_radiobutton']),'value',1)
      set(findobj('tag',['obj_',vinf.control_strategy.obj.name{4},'_radiobutton']),'enable','off')
      set(findobj('tag',['con_',vinf.control_strategy.obj.name{4},'_radiobutton']),'enable','off')
      set(findobj('tag',['obj_',vinf.control_strategy.obj.name{4},'_weight']),'value',0)
      set(findobj('tag',['con_',vinf.control_strategy.obj.name{4},'_value']),'string','-1')
      set(findobj('tag',['obj_',vinf.control_strategy.obj.name{4},'_weight']),'enable','off')
      set(findobj('tag',['con_',vinf.control_strategy.obj.name{4},'_value']),'enable','off')
   end
   
case 'run'
   
   error_flag=0;
   
   if get(findobj('tag','test_procedure_radiobutton'),'value')
      %if ~(strcmp(gui_current_str('test_procedure'),'TEST_CITY_HWY')|strcmp(gui_current_str('test_procedure'),'TEST_FTP'))
      if ~(strcmp(gui_current_str('test_procedure'),'TEST_CITY_HWY'))
         error_flag=1;
         h_msg=warndlg('Control Strategy Optimization routine is unavailable for the selected test procedure.','Test Procedure Warning');
         uiwait(h_msg);
      end
   end
   
   if get(findobj('tag','visdoc_radiobutton'),'value')&~error_flag
      for i=1:length(vinf.control_strategy.dv.active)
         if get(findobj('tag',[vinf.control_strategy.dv.name{i},'_checkbox']),'value')
            if (str2num(get(findobj('tag',[vinf.control_strategy.dv.name{i},'_init']),'string'))<str2num(get(findobj('tag',[vinf.control_strategy.dv.name{i},'_lb']),'string')))|(str2num(get(findobj('tag',[vinf.control_strategy.dv.name{i},'_init']),'string'))>str2num(get(findobj('tag',[vinf.control_strategy.dv.name{i},'_ub']),'string')))
               error_flag=1;
               break
            end
         end
      end
      if error_flag
         h_msg=warndlg('The initial conditions you have set are outside of the range specified by the upper and lower bounds. Please modify the initial conditions or the bounds.','Bound Violation Warning');
         uiwait(h_msg);
      end
   end
   
   
   if ~error_flag
      
      cs_setup('constraints')
      
      eval('vinf.autosize; test4exist=1;','test4exist=0;')
      if test4exist&nnz(vinf.autosize.constraints)>0
         
         dv_num=0;
         for i=1:length(vinf.control_strategy.dv.name)
            dv_num=dv_num+get(findobj('tag',[vinf.control_strategy.dv.name{i},'_checkbox']),'value');
         end
         
         if dv_num>0
            % confirm for version status and number of design variables
            vdoc_warning=0;
            if get(findobj('tag','visdoc_radiobutton'),'value')
               % search for vdoc_matlab.exe
               advisor_path=evalin('base','which(''advisor.m'')');
               vdoc_path=[strrep(advisor_path,'\advisor.m','\optimization\'),'vdoc_matlab.exe'];
               info=dir(vdoc_path);
               if length(info)>0
                  locate_vdoc=info.name(1);
               else
                  locate_vdoc='';
               end
               
               if ~strcmp(locate_vdoc,'')
                  [ver_num,demo]=vdoc_ver_num(locate_vdoc);
               else
                  ver_num=-1;
                  demo=0;
               end
               
               if ver_num>0
                  if demo
                     if dv_num>5
                        h=warndlg('You are using a limited version of VisualDOC.  This version is limited to no more than 5 design variables.  Please redefine your optimization problem.','Warning - too many design variables!');
                        uiwait(h)
                        vdoc_warning=1; % set flag to skip rest of case 'run'
                     end
                  end
               else
                  h=warndlg('Unable to determine version number of VisualDOC.  ','Warning - version number error!');
                  uiwait(h)
                  vdoc_warning=1; % set flag to skip rest of case 'run'
               end
            end
            
            if ~vdoc_warning % if flag==1 skip the rest of the routine
               time_est=0;
               
               if get(findobj('tag','matlab_radiobutton'),'value')
                  
                  for i=1:length(vinf.control_strategy.dv.name)
                     time_est=time_est+...
                        get(findobj('tag',[vinf.control_strategy.dv.name{i},'_checkbox']),'value')*...
                        (str2num(get(findobj('tag',[vinf.control_strategy.dv.name{i},'_pts1']),'string'))+...
                        str2num(get(findobj('tag',[vinf.control_strategy.dv.name{i},'_pts2']),'string')))*...
                        (get(findobj('tag','drive_cycle_radiobutton'),'value')*75+...
                        ~get(findobj('tag','drive_cycle_radiobutton'),'value')*150)/60; 
                     % assumes 75s per advisor call for a single cycle and 150s for a test procedure
                  end
                  
                  % adjust for emissions calcs
                  for i=1:4
                     if get(findobj('tag',['obj_',vinf.control_strategy.obj.name{i},'_radiobutton']),'value')
                        time_est=time_est*2; % emis calcs take twice as long
                        break;
                     end
                  end
                  
               else
                  
                  % account for DOE
                  if vinf.control_strategy.doe.run
                     dv_num=0;
                     call_num=0;
                     for i=1:length(vinf.control_strategy.dv.name)
                        dv_num=dv_num+get(findobj('tag',[vinf.control_strategy.dv.name{i},'_checkbox']),'value');
                        if get(findobj('tag',[vinf.control_strategy.dv.name{i},'_checkbox']),'value')
                           call_num=call_num+dv_num;
                        end
                     end
                     time_est=time_est+call_num*((get(findobj('tag','drive_cycle_radiobutton'),'value')*75+...
                        ~get(findobj('tag','drive_cycle_radiobutton'),'value')*150))/60; 
                     % assumes 75s per advisor call for a single cycle and 150s for a test procedure
                  end
                  
                  % account for approximations
                  time_est=time_est+15*((get(findobj('tag','drive_cycle_radiobutton'),'value')*75+...
                     ~get(findobj('tag','drive_cycle_radiobutton'),'value')*150))/60; 
                  % assumes 75s per advisor call for a single cycle and 150s for a test procedure
                  
                  % account for emissions calcs
                  for i=1:4
                     if get(findobj('tag',['obj_',vinf.control_strategy.obj.name{i},'_radiobutton']),'value')
                        time_est=time_est*2; % emis calcs take twice as long
                        break
                     end
                  end
                  
               end
               
               % provide time estimate info to user
               button=questdlg(['Estimated time to complete control strategy optimization ==> ',num2str(time_est),' minutes.'],' ','CANCEL','OK','CANCEL');
               
               if strcmp(button,'OK')
                  % save the user inputs to the workspace
                  for i=1:length(vinf.control_strategy.dv.name)
                     vinf.control_strategy.dv.init_cond(i)=str2num(get(findobj('tag',[vinf.control_strategy.dv.name{i},'_init']),'string'));
                     vinf.control_strategy.dv.lower_bound(i)=str2num(get(findobj('tag',[vinf.control_strategy.dv.name{i},'_lb']),'string'));
                     vinf.control_strategy.dv.upper_bound(i)=str2num(get(findobj('tag',[vinf.control_strategy.dv.name{i},'_ub']),'string'));
                     vinf.control_strategy.dv.first_points(i)=str2num(get(findobj('tag',[vinf.control_strategy.dv.name{i},'_pts1']),'string'));
                     vinf.control_strategy.dv.second_points(i)=str2num(get(findobj('tag',[vinf.control_strategy.dv.name{i},'_pts2']),'string'));
                     vinf.control_strategy.dv.active(i)=get(findobj('tag',[vinf.control_strategy.dv.name{i},'_checkbox']),'value');
                  end
                  for i=1:length(vinf.control_strategy.obj.active)
                     vinf.control_strategy.obj.active(i)=get(findobj('tag',['obj_',vinf.control_strategy.obj.name{i},'_radiobutton']),'value');
                     vinf.control_strategy.obj.weight(i)=str2num(get(findobj('tag',['obj_',vinf.control_strategy.obj.name{i},'_weight']),'string'));
                     if i==5
                        if strcmp(vinf.units,'metric')
                           vinf.control_strategy.con.value(i)=1/(str2num(get(findobj('tag',['con_',vinf.control_strategy.obj.name{i},'_value']),'string')))/100/units('mpg2kmpl');
                        else
                           vinf.control_strategy.con.value(i)=str2num(get(findobj('tag',['con_',vinf.control_strategy.obj.name{i},'_value']),'string'));
                        end
                     else
                        vinf.control_strategy.con.value(i)=str2num(get(findobj('tag',['con_',vinf.control_strategy.obj.name{i},'_value']),'string'))/units('gpm2gpkm');
                     end
                  end
                  if get(findobj('tag','drive_cycle_radiobutton'),'value')
                     vinf.control_strategy.cycle.run=1;
                  else
                     vinf.control_strategy.cycle.run=0;
                  end
                  vinf.control_strategy.cycle.name=gui_current_str('drive_cycle');
                  vinf.control_strategy.test.name=gui_current_str('test_procedure');
                  vinf.control_strategy.matlab=get(findobj('tag','matlab_radiobutton'),'value');
                  
                  %the following is if gui is running
                  h=findobj('tag','execute_figure');
                  if ~isempty(h)
                     set(h,'Visible','off')
                  end
                  
                  % close the current figure
                  close(gcf)
                  
                  % load default initial conditions
                  init_conds
                  
                  if ~vinf.control_strategy.matlab % run using visual doc
                     % run VisualDOC-based control stategy optimization
                     resp=vdoc_cs_opt('matlab',vinf.control_strategy.doe.run);
                  else % run using matlab
                     % run matlab-based control stategy optimization
                     opt_cs8(vinf.control_strategy)
                  end
                  
                  %the following is if gui is running
                  if ~isempty(h)
                     
                     % make summary window current figure
                     figure(findobj('tag','cs_optimization_summary'));
                     
                     %  completion message
                     str={'The control strategy optimization has completed successfully!'};
                     h_msg=warndlg(str,'Control Strategy Complete');
                     set(h_msg,'Windowstyle','modal')
                     
                     % wait until summary figure has been closed to continue
                     uiwait(findobj('tag','cs_optimization_summary'))
                     
                     % make simulation setup figure visible
                     set(h,'Visible','on');
                     
                     %  Status information
                     str={'The control strategy optimization has completed successfully!';...
                           'The workspace variables and the list of editted variables have been updated.  However, it is highly recommended that you save the current vehicle configuration for future use.';...
                           'To save the current configuration, select BACK from the Simulation Setup Screen and then select SAVE from the Vehicle Setup Screen.';...
                           'Otherwise, your changes will be lost!'};
                     h_msg=warndlg(str,'Save Changes Warning');
                     set(h_msg,'Windowstyle','modal')
                     
                  end
               end
            end
         else
            h=warndlg('No design variables have been selected. The vehicle can not be optimized.','Design Variables Warning');
            uiwait(h)
         end
      else
         h=warndlg('No vehicle performance constraints have been defined. The vehicle can not be optimized.','Constraints Warning');
         uiwait(h)
      end
   end
   
   
case 'defaults'
   
   vinf=rmfield(vinf,'control_strategy');
   close(gcbf);
   cs_setup('load');
   
case 'cancel'
   close(gcbf);
   
case 'test_procedure'
   if get(findobj('tag','test_procedure_radiobutton'),'value') 
      set(findobj('tag','test_procedure'),'enable','on'); 
      set(findobj('tag','drive_cycle_radiobutton'),'value',0);
      set(findobj('tag','drive_cycle'),'enable','off'); 
   end
   
case 'drive_cycle'
   if get(findobj('tag','drive_cycle_radiobutton'),'value') 
      set(findobj('tag','drive_cycle'),'enable','on'); 
      set(findobj('tag','test_procedure'),'enable','off'); 
      set(findobj('tag','test_procedure_radiobutton'),'value',0); 
   end
   
case 'matlab'
   set(findobj('tag','matlab_radiobutton'),'value',1);
   set(findobj('tag','visdoc_radiobutton'),'value',0);
   
   % enable # of pts editboxes
   for i=1:length(vinf.control_strategy.dv.name)
      set(findobj('tag',[vinf.control_strategy.dv.name{i},'_pts2']),'enable','on');
      set(findobj('tag',[vinf.control_strategy.dv.name{i},'_pts1']),'enable','on');
   end
   
   % disable cs_hi_soc and cs_lo_soc design variables
   for i=1:2
      set(findobj('tag',[vinf.control_strategy.dv.name{i},'_pts2']),'enable','off');
      set(findobj('tag',[vinf.control_strategy.dv.name{i},'_pts1']),'enable','off');
      set(findobj('tag',[vinf.control_strategy.dv.name{i},'_lb']),'enable','off');
      set(findobj('tag',[vinf.control_strategy.dv.name{i},'_ub']),'enable','off');
      set(findobj('tag',[vinf.control_strategy.dv.name{i},'_init']),'enable','off');
      set(findobj('tag',[vinf.control_strategy.dv.name{i},'_checkbox']),'enable','off');
      set(findobj('tag',[vinf.control_strategy.dv.name{i},'_checkbox']),'value',0);
   end
   
case 'visdoc'
   
   set(findobj('tag','matlab_radiobutton'),'value',0);
   set(findobj('tag','visdoc_radiobutton'),'value',1);
   
   % search for vdoc_matlab.exe
   h=waitbar(0.5,'Please wait...');
   set(h,'windowstyle','modal');
   
   % search for vdoc_matlab.exe
   advisor_path=evalin('base','which(''advisor.m'')');
   vdoc_path=[strrep(advisor_path,'\advisor.m','\optimization\'),'vdoc_matlab.exe'];
   info=dir(vdoc_path);
   if length(info)>0
      locate=info.name(1);
   else
      locate='';
   end
   %locate=evalin('base','which(''vdoc_matlab.exe'')');
   if strcmp(locate,'')
      btn=questdlg('ADVISOR was unable to locate vdoc_matlab.exe on this machine.  Please refer to documentation on Control Strategy Optimization using VisualDOC for troubleshooting tips.','VisualDOC Warning','OK','HELP','OK');
      if strcmp(btn,'HELP')
         load_in_browser('cs_opt_help.html');
      end
      eval('cs_setup(''matlab'')')
   else
      [ver_num,demo]=vdoc_ver_num(locate);
      if ver_num>0
         if demo&exist('vdoc_msg.m')
            assignin('base','dont_show',0);
            [vdoc_image,vdoc_image_map] = evalin('base','imread(''smlogo'',''jpg'')');
            h_msg=msgbox('ADVISOR will use a limited version of VisualDOC to perform your optimization.  For more information about VisualDOC or to obtain a full release version for more complex optimization problems please contact Vanderplaats R&D at www.vrand.com.','VisualDOC Message','custom',vdoc_image,vdoc_image_map,'modal');
            h1 = uicontrol('Parent',h_msg, ...
               'Callback','dont_show=get(findobj(''tag'',''vdoc_msg_checkbox''),''value'');', ...
               'Position',[10 10 165 20], ...
               'String','Don''t show this message again.', ...
               'Style','checkbox', ...
               'Tag','vdoc_msg_checkbox',...
               'Value',evalin('base','dont_show'));
            uiwait(h_msg)
            if evalin('base','dont_show')==1
               path_old=evalin('base','which(''vdoc_msg.m'')');
               name_new='vdoc_ms_.m';
               evalin('base',['!rename "',path_old,'" ',name_new,''])
            end
            evalin('base','clear dont_show')
         end
         
         % disable # pts editboxes
         for i=1:length(vinf.control_strategy.dv.name)
            set(findobj('tag',[vinf.control_strategy.dv.name{i},'_pts2']),'enable','off');
            set(findobj('tag',[vinf.control_strategy.dv.name{i},'_pts1']),'enable','off');
         end
         
         % enable cs_hi_soc and cs_lo_soc design vars
         for i=1:2
            set(findobj('tag',[vinf.control_strategy.dv.name{i},'_lb']),'enable','on');
            set(findobj('tag',[vinf.control_strategy.dv.name{i},'_ub']),'enable','on');
            set(findobj('tag',[vinf.control_strategy.dv.name{i},'_init']),'enable','on');
            set(findobj('tag',[vinf.control_strategy.dv.name{i},'_checkbox']),'enable','on');
            set(findobj('tag',[vinf.control_strategy.dv.name{i},'_checkbox']),'value',vinf.control_strategy.dv.active(i));
         end
      else
         h_msg=warndlg('Unable to determine version number of VisualDOC.  ','Warning - version number error!');
         uiwait(h_msg)
      end
   end
   close(h); % close wait msg
            
   
case 'run_doe'
   set(findobj('tag','visdoc_radiobutton'),'value',1);
   for i=1:length(vinf.control_strategy.dv.name)
      set(findobj('tag',[vinf.control_strategy.dv.name{i},'_pts2']),'enable','off');
      set(findobj('tag',[vinf.control_strategy.dv.name{i},'_pts1']),'enable','off');
      set(findobj('tag',[vinf.control_strategy.dv.name{i},'_init']),'enable','on');
      set(findobj('tag',[vinf.control_strategy.dv.name{i},'_ub']),'enable','on');
      set(findobj('tag',[vinf.control_strategy.dv.name{i},'_lb']),'enable','on');
      set(findobj('tag',[vinf.control_strategy.dv.name{i},'_checkbox']),'enable','on');
      %set(findobj('tag',[vinf.control_strategy.dv.name{i},'_checkbox']),'value',1);
   end
   for i=1:length(vinf.control_strategy.obj.active)
      %set(findobj('tag',['con_',vinf.control_strategy.obj.name{i},'_radiobutton']),'value',1);
      %set(findobj('tag',['con_',vinf.control_strategy.obj.name{i},'_radiobutton']),'enable','off');
      %set(findobj('tag',['obj_',vinf.control_strategy.obj.name{i},'_radiobutton']),'value',0);
      %set(findobj('tag',['obj_',vinf.control_strategy.obj.name{i},'_radiobutton']),'enable','off');
      %set(findobj('tag',['con_',vinf.control_strategy.obj.name{i},'_value']),'enable','off');
      %set(findobj('tag',['obj_',vinf.control_strategy.obj.name{i},'_weight']),'enable','off');
   end
   
   cs_setup('emissions')
   
case 'skip_doe'
   set(findobj('tag','visdoc_radiobutton'),'value',1);
   for i=1:length(vinf.control_strategy.dv.name)
      set(findobj('tag',[vinf.control_strategy.dv.name{i},'_pts2']),'enable','off');
      set(findobj('tag',[vinf.control_strategy.dv.name{i},'_pts1']),'enable','off');
      if ~vinf.control_strategy.dv.active(i)
         set(findobj('tag',[vinf.control_strategy.dv.name{i},'_init']),'enable','off');
         set(findobj('tag',[vinf.control_strategy.dv.name{i},'_ub']),'enable','off');
         set(findobj('tag',[vinf.control_strategy.dv.name{i},'_lb']),'enable','off');
         set(findobj('tag',[vinf.control_strategy.dv.name{i},'_checkbox']),'enable','off');
      end
   end
   set(findobj('tag','drive_cycle_radiobutton'),'enable','off');
   set(findobj('tag','test_procedure_radiobutton'),'enable','off');
   set(findobj('tag','drive_cycle'),'enable','off');
   set(findobj('tag','test_procedure'),'enable','off');
   
   
case 'constraints'
   
   screen=get(0,'screensize');
   line_height=18;
   %figure_color=[1 1 .8];
   figure_color=[.4 .8 .8];
   posfig=[(screen(3)-400)/2 (screen(4)-300)/2 400 300];
   par_left=posfig(1);
   par_bottom=posfig(2);
   par_width=posfig(3);
   par_height=posfig(4);
   char_width=10;
   border=2*char_width;
   button_width=60;
   button_height=line_height+2;
   editbox_width=60;
   editbox_height=line_height;
   line_num=1;
   
   eval('vinf.autosize.constraints; test4exist=1;','test4exist=0;')
   if ~test4exist
      vinf.autosize.constraints=[1 1];
   else 
      default_constraints=vinf.autosize.constraints;   
   end
   
  % eval('vinf.autosize.con; test4exist=1;','test4exist=0;')
   eval('vinf.autosize.con.grade; test4exist=1;','test4exist=0;')
   if ~test4exist
      vinf.autosize.con.max_spd=90;
      vinf.autosize.con.grade.goal.mph=55;
      vinf.autosize.con.grade.goal.grade=6;
      vinf.autosize.con.accel.goal.t0_18=-1;
      vinf.autosize.con.accel.goal.t0_30=-1;
      vinf.autosize.con.accel.goal.t0_60=12;
      vinf.autosize.con.accel.goal.t40_60=5.3;
      vinf.autosize.con.accel.goal.t0_85=23.4;
      vinf.autosize.con.grade.tol.mph=0.01;
      vinf.autosize.con.grade.tol.grade=0.05;
      vinf.autosize.con.accel.tol.t0_18=0.02;
      vinf.autosize.con.accel.tol.t0_30=0.02;
      vinf.autosize.con.accel.tol.t0_60=0.02;
      vinf.autosize.con.accel.tol.t40_60=0.02;
      vinf.autosize.con.accel.tol.t0_85=0.05;
   else
      default_con=vinf.autosize.con;
   end
   
   h0 = figure('Color',figure_color, ...
      'Position',posfig, ...
      'numbertitle','off',...
      'name','Constraints Configuration Window',...
      'windowstyle','modal');
   % Constraints section title
   line_num=line_num+1;
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figure_color, ...
      'Position',[border par_height-line_num*line_height par_width-2*border line_height], ...
      'String','Constraints', ...
      'Fontweight','bold',...
      'Style','text');
     line_num=line_num+1;
 % Grade checkbox
   line_num=line_num+1;
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figure_color, ...
      'Position',[border par_height-line_num*line_height par_width line_height], ...
      'String','Grade', ...
      'Style','checkbox', ...
      'Tag','grade_checkbox',...
      'Value',vinf.autosize.constraints(1));
   % Goals header
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figure_color, ...
      'Position',[border+10*char_width par_height-line_num*line_height 10*char_width line_height], ...
      'String','Goal', ...
      'Style','text');
   % Tolerances header
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figure_color, ...
      'Position',[border+20*char_width par_height-line_num*line_height 10*char_width line_height], ...
      'String','Tolerance (+/-)', ...
      'Style','text');
   
   % Grade speed goal
   line_num=line_num+1;
   if strcmp(vinf.units,'metric')
      str='Speed(km/h)';
   else
      str='Speed(mph)';
   end
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figure_color, ...
      'Position',[2*border par_height-line_num*line_height 10*char_width line_height], ...
      'String',str, ...
      'Style','text');
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[1 1 1], ...
      'Position',[2*border+10*char_width par_height-line_num*line_height editbox_width line_height], ...
      'String',num2str(round(vinf.autosize.con.grade.goal.mph*units('mph2kmph')*10)/10),...
      'Style','edit', ...
      'enable','on', ...
      'Tag','autosize_speed_goal');
   % Grade speed tol
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[1 1 1], ...
      'Position',[2*border+20*char_width par_height-line_num*line_height editbox_width line_height], ...
      'String',num2str(round(vinf.autosize.con.grade.tol.mph*units('mph2kmph')*100)/100),...
      'Style','edit', ...
      'enable','on', ...
      'Tag','autosize_speed_tol');
   % Grade grade goal
   line_num=line_num+1;
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figure_color, ...
      'Position',[2*border par_height-line_num*line_height 10*char_width line_height], ...
      'String','Grade(%)', ...
      'Style','text');
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[1 1 1], ...
      'Position',[2*border+10*char_width par_height-line_num*line_height editbox_width line_height], ...
      'String',num2str(vinf.autosize.con.grade.goal.grade),...
      'Style','edit', ...
      'enable','on', ...
      'Tag','autosize_grade_goal');
   % Grade grade tol
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[1 1 1], ...
      'Position',[2*border+20*char_width par_height-line_num*line_height editbox_width line_height], ...
      'String',num2str(vinf.autosize.con.grade.tol.grade),...
      'Style','edit', ...
      'enable','on', ...
      'Tag','autosize_grade_tol');
   
   line_num=line_num+1;
   
   % Accel checkbox
   line_num=line_num+1;
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figure_color, ...
      'Position',[border par_height-line_num*line_height 15*char_width line_height], ...
      'String','Acceleration', ...
      'Style','checkbox', ...
      'Tag','accel_checkbox',...
      'Value',vinf.autosize.constraints(2));
   % Goals header
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figure_color, ...
      'Position',[border+15*char_width par_height-line_num*line_height 10*char_width line_height], ...
      'String','Goal', ...
      'Style','text');
   % Tolerances header
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figure_color, ...
      'Position',[border+25*char_width par_height-line_num*line_height 10*char_width line_height], ...
      'String','Tolerance (+/-)', ...
      'Style','text');
   
   % 0-18 time
   line_num=line_num+1;
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figure_color, ...
      'Position',[2*border par_height-line_num*line_height 15*char_width line_height], ...
      'String','0-18mph (0-29km/h) (s)', ...
      'Style','checkbox', ...
      'value',vinf.autosize.con.accel.goal.t0_18>0, ...
      'Tag','accel_0_18_checkbox');
   if vinf.autosize.con.accel.goal.t0_18<0 
      vinf.autosize.con.accel.goal.t0_18=3.5;
   end
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[1 1 1], ...
      'Position',[2*border+15*char_width par_height-line_num*line_height editbox_width line_height], ...
      'String',num2str(vinf.autosize.con.accel.goal.t0_18),...
      'Style','edit', ...
      'enable','on', ...
      'Tag','autosize_0_18_goal');
   % 0-18 time tol
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[1 1 1], ...
      'Position',[2*border+25*char_width par_height-line_num*line_height editbox_width line_height], ...
      'String',num2str(vinf.autosize.con.accel.tol.t0_18),...
      'Style','edit', ...
      'enable','on', ...
      'Tag','autosize_0_18_tol');
   
   % 0-30 time
   line_num=line_num+1;
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figure_color, ...
      'Position',[2*border par_height-line_num*line_height 15*char_width line_height], ...
      'String','0-30mph (0-48km/h) (s)', ...
      'Style','checkbox', ...
      'value',vinf.autosize.con.accel.goal.t0_30>0, ...
      'Tag','accel_0_30_checkbox');
   if vinf.autosize.con.accel.goal.t0_30<0 
      vinf.autosize.con.accel.goal.t0_30=10;
   end
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[1 1 1], ...
      'Position',[2*border+15*char_width par_height-line_num*line_height editbox_width line_height], ...
      'String',num2str(vinf.autosize.con.accel.goal.t0_30),...
      'Style','edit', ...
      'enable','on', ...
      'Tag','autosize_0_30_goal');
   % 0-30 time tol
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[1 1 1], ...
      'Position',[2*border+25*char_width par_height-line_num*line_height editbox_width line_height], ...
      'String',num2str(vinf.autosize.con.accel.tol.t0_30),...
      'Style','edit', ...
      'enable','on', ...
      'Tag','autosize_0_30_tol');
   
   % 0-60 time
   line_num=line_num+1;
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figure_color, ...
      'Position',[2*border par_height-line_num*line_height 15*char_width line_height], ...
      'String','0-60mph (0-97km/h) (s)', ...
      'Style','checkbox', ...
      'value',vinf.autosize.con.accel.goal.t0_60>0, ...
      'Tag','accel_0_60_checkbox');
   if vinf.autosize.con.accel.goal.t0_60<0 
      vinf.autosize.con.accel.goal.t0_60=12.0;
   end
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[1 1 1], ...
      'Position',[2*border+15*char_width par_height-line_num*line_height editbox_width line_height], ...
      'String',num2str(vinf.autosize.con.accel.goal.t0_60),...
      'Style','edit', ...
      'enable','on', ...
      'Tag','autosize_0_60_goal');
   % 0-60 time tol
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[1 1 1], ...
      'Position',[2*border+25*char_width par_height-line_num*line_height editbox_width line_height], ...
      'String',num2str(vinf.autosize.con.accel.tol.t0_60),...
      'Style','edit', ...
      'enable','on', ...
      'Tag','autosize_0_60_tol');
   
   % 40-60 time
   line_num=line_num+1;
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figure_color, ...
      'Position',[2*border par_height-line_num*line_height 15*char_width line_height], ...
      'String','40-60mph (64-97km/h) (s)', ...
      'Style','checkbox', ...
      'value',vinf.autosize.con.accel.goal.t40_60>0,...
      'Tag','accel_40_60_checkbox');
   if vinf.autosize.con.accel.goal.t40_60<0 
      vinf.autosize.con.accel.goal.t40_60=5.3;
   end
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[1 1 1], ...
      'Position',[2*border+15*char_width par_height-line_num*line_height editbox_width line_height], ...
      'String',num2str(vinf.autosize.con.accel.goal.t40_60),...
      'Style','edit', ...
      'enable','on', ...
      'Tag','autosize_40_60_goal');
   % 40-60 time tol
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[1 1 1], ...
      'Position',[2*border+25*char_width par_height-line_num*line_height editbox_width line_height], ...
      'String',num2str(vinf.autosize.con.accel.tol.t40_60),...
      'Style','edit', ...
      'enable','on', ...
      'Tag','autosize_40_60_tol');
   
   % 0-85 time
   line_num=line_num+1;
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',figure_color, ...
      'Position',[2*border par_height-line_num*line_height 15*char_width line_height], ...
      'String','0-85mph (0-137km/h) (s)', ...
      'Style','checkbox', ...
      'value',vinf.autosize.con.accel.goal.t0_85>0, ...
      'Tag','accel_0_85_checkbox');
   if vinf.autosize.con.accel.goal.t0_85<0 
      vinf.autosize.con.accel.goal.t0_85=23.4;
   end
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[1 1 1], ...
      'Position',[2*border+15*char_width par_height-line_num*line_height editbox_width line_height], ...
      'String',num2str(vinf.autosize.con.accel.goal.t0_85),...   
      'Style','edit', ...
      'enable','on', ...
      'Tag','autosize_0_85_goal');
   % 0-85 time tol
   h1 = uicontrol('Parent',h0, ...
      'BackgroundColor',[1 1 1], ...
      'Position',[2*border+25*char_width par_height-line_num*line_height editbox_width line_height], ...
      'String',num2str(vinf.autosize.con.accel.tol.t0_85),...   
      'Style','edit', ...
      'enable','on', ...
      'Tag','autosize_0_85_tol');
   
   %run button
   h1 = uicontrol('Parent',h0, ...
      'CallBack','cs_setup(''store_constraints'')',...
      'Position',[(par_width-2*button_width)/3 10 button_width button_height], ...
      'String','ACCEPT', ...
      'Tag','Pushbutton1');
   
   
   %cancel button
   h1 = uicontrol('Parent',h0, ...
      'CallBack','cs_setup(''restore_constraints'')',...
      'Position',[2*(par_width-2*button_width)/3+button_width 10 button_width button_height], ...
      'String','CANCEL', ...
      'Tag','Pushbutton3');
   
   uiwait(h0)
   
case 'store_constraints'
   
h_grade=get(findobj('tag','grade_checkbox'),'value');
h_accel=get(findobj('tag','accel_checkbox'),'value');  
vinf.autosize.constraints=[h_grade h_accel];

grade_mph=str2num(get(findobj('tag','autosize_speed_goal'),'string'));
grade_grade=str2num(get(findobj('tag','autosize_grade_goal'),'string'));

vinf.autosize.con.grade.goal.mph=grade_mph/units('mph2kmph');
vinf.autosize.con.grade.goal.grade=grade_grade;

grade_mph_tol=str2num(get(findobj('tag','autosize_speed_tol'),'string'));
grade_grade_tol=str2num(get(findobj('tag','autosize_grade_tol'),'string'));

vinf.autosize.con.grade.tol.mph=grade_mph_tol/units('mph2kmph');
vinf.autosize.con.grade.tol.grade=grade_grade_tol;

if h_accel
   if get(findobj('tag','accel_0_18_checkbox'),'value')
      accel_0_18=str2num(get(findobj('tag','autosize_0_18_goal'),'string'));
   else
      accel_0_18=-1;
   end
   if get(findobj('tag','accel_0_30_checkbox'),'value')
      accel_0_30=str2num(get(findobj('tag','autosize_0_30_goal'),'string'));
   else
      accel_0_30=-1;
   end
   if get(findobj('tag','accel_0_60_checkbox'),'value')
      accel_0_60=str2num(get(findobj('tag','autosize_0_60_goal'),'string'));
   else
      accel_0_60=-1;
   end
   if get(findobj('tag','accel_40_60_checkbox'),'value')
      accel_40_60=str2num(get(findobj('tag','autosize_40_60_goal'),'string'));
   else
      accel_40_60=-1;
   end
   if get(findobj('tag','accel_0_85_checkbox'),'value')
      accel_0_85=str2num(get(findobj('tag','autosize_0_85_goal'),'string'));
   else
      accel_0_85=-1;
   end
else
   accel_0_18=-1;
   accel_0_30=-1;
   accel_0_60=-1;
   accel_0_85=-1;
   accel_40_60=-1;
end

vinf.autosize.con.accel.goal.t0_18=accel_0_18;
vinf.autosize.con.accel.goal.t0_30=accel_0_30;
vinf.autosize.con.accel.goal.t0_60=accel_0_60;
vinf.autosize.con.accel.goal.t40_60=accel_40_60;
vinf.autosize.con.accel.goal.t0_85=accel_0_85;

accel_0_18_tol=str2num(get(findobj('tag','autosize_0_18_tol'),'string'));
accel_0_30_tol=str2num(get(findobj('tag','autosize_0_30_tol'),'string'));
accel_0_60_tol=str2num(get(findobj('tag','autosize_0_60_tol'),'string'));
accel_40_60_tol=str2num(get(findobj('tag','autosize_40_60_tol'),'string'));
accel_0_85_tol=str2num(get(findobj('tag','autosize_0_85_tol'),'string'));

vinf.autosize.con.accel.tol.t0_18=accel_0_18_tol;
vinf.autosize.con.accel.tol.t0_30=accel_0_30_tol;
vinf.autosize.con.accel.tol.t0_60=accel_0_60_tol;
vinf.autosize.con.accel.tol.t40_60=accel_40_60_tol;
vinf.autosize.con.accel.tol.t0_85=accel_0_85_tol;

close(gcf)

case 'restore_constraints'

if ~evalin('caller','exist(''default_con'')')&~evalin('caller','exist(''default_constraints'')')
   vinf=rmfield(vinf,'autosize');
end

close(gcf)

end % case statements


% revision history
% 8/16/99:tm updated to allow the user to optimize the control strategy using visual doc or matlab
% 9/15/99:tm updated for metric units capability
% 9/24/99: ss updated help button file
% 7/10/00:ss all references to FUDS are now UDDS
% 7/17/00: ss replaced all gui options with optionlist. 
% 8/15/00:tm removed \gui from path info for vdoc due to new directory structure
% 8/15/00:tm fixed link to documentation for help from unable to find vdoc
% 8/18/00:tm updated list of control varialbes if parallel or parallel_sa drivetrain
% 1/31/01:tm added .grade to test4exist conditional to decide whether to load default accel and grade constraint info (workaround for new test formats)
%
%
