function fig = gui_cty_hwy_results()
% This is the machine-generated representation of a Handle Graphics object
% and its children.  Note that handle values may change when these objects
% are re-created. This may cause problems with any callbacks written to
% depend on the value of the handle at the time the object was saved.
%
% To reopen this object, just type the name of the M-file at the MATLAB
% prompt. The M-file and its associated MAT-file must be on your path.
global vinf

%colors for all items of figure
figure_color=[.7 0.9 1];

screen=get(0,'screensize');

h0 = figure('Color',figure_color, ...
   'MenuBar','none',...
	'Name',['City/Hwy Results--',advisor_ver('info')], ...
   'NumberTitle','off', ...
   'Position',[(screen(3)-432)/2 (screen(4)-363)/2 432 363], ...
   'Tag','city_hwy_results_figure');

%load advisor menubar
adv_menu('city/hwy results')


%title
h1 = uicontrol('Parent',h0, ...
   'BackgroundColor',figure_color, ...
	'FontSize',12, ...
	'Position',[15 331 372 25], ...
	'String','Combined City/Highway Cycle Results', ...
	'Style','text', ...
	'Tag','StaticText1');

%Fuel Economy Section
%Title
if strcmp(vinf.units,'metric')
   str='Fuel Consumption (L/100 km)';
else
   str='Fuel Economy (mpg)';
end
h1 = uicontrol('Parent',h0, ...
   'BackgroundColor',figure_color, ...
	'FontWeight','bold', ...
	'Position',[30 300 190 18], ...
	'String',str, ...
	'Style','text');

%Headings
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',figure_color, ...
	'Position',[216 289 123 18], ...
	'String','Gasoline Equivalent', ...
	'Style','text');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',figure_color, ...
	'Position',[79 262 59 18], ...
	'String','City', ...
	'Style','text');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',figure_color, ...
	'Position',[79  237  59  18], ...
   'String','Hwy',...
   'Style','text');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',figure_color, ...
	'Position',[79 210 59 18], ...
	'String','Combined', ...
	'Style','text');

%fuel economy values
if strcmp(vinf.units,'metric')
   str1=evalin('base','num2str(round(10*(1/mpg)*units(''gpm2lp100km''))/10)');
   str2=evalin('base','num2str(round(10*(1/mpg_hwy)*units(''gpm2lp100km''))/10)');
   str3=evalin('base','num2str(round(10*(1/combined_mpg)*units(''gpm2lp100km''))/10)');
   str4=evalin('base','num2str(round(10*(1/mpgge)*units(''gpm2lp100km''))/10)');
   str5=evalin('base','num2str(round(10*(1/mpgge_hwy)*units(''gpm2lp100km''))/10)');
   str6=evalin('base','num2str(round(10*(1/combined_mpgge)*units(''gpm2lp100km''))/10)');
 
else
   str1=evalin('base','num2str(round(10*mpg)/10)');
   str2=evalin('base','num2str(round(10*mpg_hwy)/10)');
   str3=evalin('base','num2str(round(10*combined_mpg)/10)');
   str4=evalin('base','num2str(round(10*mpgge)/10)');
   str5=evalin('base','num2str(round(10*mpgge_hwy)/10)');
   str6=evalin('base','num2str(round(10*combined_mpgge)/10)');
end

h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',[1 1 1], ...
	'FontWeight','bold', ...
	'Position',[150 262 58 18], ...
	'String',str1, ...
	'Style','text', ...
	'Tag','city-mpg');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',[1 1 1], ...
	'FontWeight','bold', ...
	'Position',[150   237    58    18], ...
	'String',str2, ...
	'Style','text', ...
	'Tag','Hwy-mpg');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',[1 1 1], ...
	'FontWeight','bold', ...
	'ListboxTop',0, ...
	'Position',[150 211 58 18], ...
	'String',str3, ...
	'Style','text', ...
	'Tag','com-mpg');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',[1 1 1], ...
	'FontWeight','bold', ...
	'Position',[241 263 59 18], ...
	'String',str4, ...
	'Style','text', ...
	'Tag','city-gaseq');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',[1 1 1], ...
	'FontWeight','bold', ...
	'Position',[241 238 59 18], ...
	'String',str5, ...
	'Style','text', ...
	'Tag','hwygaseq');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',[1 1 1], ...
	'FontWeight','bold', ...
	'Position',[241 213 59 18], ...
	'String',str6, ...
	'Style','text', ...
	'Tag','com-gaseq');


h1 = uicontrol('Parent',h0, ...
	'CallBack','WindowStickerFigControl', ...
	'FontWeight','normal', ...
	'Position',[315 250 90 20], ...
	'String',{'Window Sticker'}, ...
	'Style','Pushbutton', ...
	'Tag','sticker_pushbutton');


%Emissions Section
%title
if strcmp(vinf.units,'metric')
   str='Emissions (grams/km)';
else
   str='Emissions (grams/mile)';
end

h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',figure_color, ...
	'FontWeight','bold', ...
	'Position',[34 176 140 18], ...
	'String',str, ...
	'Style','text');
%headings
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',figure_color, ...
	'Position',[77   138    59    18], ...
	'String','City', ...
	'Style','text');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',figure_color, ...
	'Position',[77 105 59 18], ...
	'String','Hwy', ...
	'Style','text');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',figure_color, ...
	'Position',[366 162 58 18], ...
	'String','PM', ...
	'Style','text');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',figure_color, ...
	'Position',[296 162 58 18], ...
	'String','NOx', ...
	'Style','text');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',figure_color, ...
	'Position',[226 162 58 18], ...
	'String','CO', ...
	'Style','text');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',figure_color, ...
	'Position',[153 162 58 18], ...
	'String','HC', ...
	'Style','text');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',figure_color, ...
	'Position',[152 106 123 18], ...
	'String','Ratio of Hwy/City NOx:', ...
	'Style','text');
%emissions values
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',[1 1 1], ...
	'FontWeight','bold', ...
	'Position',[153   138    58    18], ...
	'String',evalin('base','num2str(round(1000*hc_gpm*units(''gpm2gpkm''))/1000)'), ...
	'Style','text', ...
	'Tag','city hc');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',[1 1 1], ...
	'FontWeight','bold', ...
	'Position',[226   138    58    18], ...
	'String',evalin('base','num2str(round(1000*co_gpm*units(''gpm2gpkm''))/1000)'), ...
	'Style','text', ...
	'Tag','city co');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',[1 1 1], ...
	'FontWeight','bold', ...
	'Position',[296   138    58    18], ...
	'String',evalin('base','num2str(round(1000*nox_gpm*units(''gpm2gpkm''))/1000)'), ...
	'Style','text', ...
   'Tag','city nox');
h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',[1 1 1], ...
	'FontWeight','bold', ...
	'Position',[366   138    58    18], ...
	'String',evalin('base','num2str(round(1000*pm_gpm*units(''gpm2gpkm''))/1000)'), ...
	'Style','text', ...
	'Tag','city pm');

h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',[1 1 1], ...
	'FontWeight','bold', ...
	'Position',[282 106 58 18], ...
	'String',evalin('base','num2str(round(100*nox_ratio)/100)'), ...
	'Style','text', ...
	'Tag','hwynoxratio');

notestr='Note:  City values based on one cold-start FTP-75 cycle.  Highway values based on one hot-start HWFETS cycle. Combined fuel economy FE_comb=1/((.55/MPG_u)+(.45/MPG_H))';

h1 = uicontrol('Parent',h0, ...
	'BackgroundColor',figure_color, ...
	'Position',[22 44 373 43], ...
	'String',notestr, ...
	'Style','text');

h1=uicontrol('Parent',h0,...
   'callback','close(gcbf);SimSetupFig',...
   'position',[107 5 200 30],...
   'string','Close and Return to Simulation Figure');

if nargout > 0, fig = h0; end


%Revisions

% 5/6/99 ss: added the call to advisor_ver inside the figure setup to display the
%              current version of advisor being run.
% 9/17/99 ss: updating units to be either us or metric.
% 9/23/99 ss: minor change to the text for L/100 km was l/100km
% 7/21/00 ss: updated name for version info to advisor_ver.
% 1/31/01:tm added window sticker button to open another gui
%